<?php
namespace api\Siat;


use api\Siat\Invoices\InvoiceDetail;
use api\Siat\Services\ServicioSiat;
use api\Siat\Invoices\ElectronicaCompraVenta;
use api\Siat\Invoices\CompraVenta;
use api\Siat\Invoices\ElectronicaComercialExportacion;
use api\Siat\Invoices\ComercialExportacion;
use api\Siat\Invoices\InvoiceDetailComercialExportacion;
use api\Siat\Invoices\ElectronicaServicioTuristicoHospedaje;
use api\Siat\Invoices\InvoiceDetailTuristico;
use api\Siat\Invoices\ServicioTuristicoHospedaje;
use api\Siat\Invoices\ElectronicaTasaCero;
use api\Siat\Invoices\TasaCero;
use api\Siat\Invoices\ElectronicaSectorEducativo;
use api\Siat\Invoices\ElectronicaHotel;
use api\Siat\Invoices\InvoiceDetailHotel;
use api\Siat\Invoices\ElectronicaHospitales;
use api\Siat\Invoices\InvoiceDetailHospital;
use api\Siat\Invoices\ElectronicaComercialExportacionServicio;
use api\Siat\Invoices\SectorEducativo;
use api\Siat\Invoices\Hotel;
use api\Siat\Invoices\Hospitales;
use api\Siat\Invoices\ComercialExportacionServicio;
use Exception;
use api\Siat\Invoices\ElectronicaServicioBasico;
use api\Siat\Invoices\ElectronicaEntidadFinanciera;
use api\Siat\Invoices\ServicioBasico;
use api\Siat\Invoices\EntidadFinanciera;
use api\Siat\Services\ServicioFacturacionElectronica;
use api\Siat\Services\ServicioFacturacionComputarizada;

class SiatFactory
{
	/**
	 * 
	 * @param int $documentoSector
	 * @param int $modalidad
	 * @throws Exception
	 * @return \api\Siat\Invoices\ElectronicaCompraVenta|\api\Siat\Invoices\CompraVenta|\api\Siat\Invoices\ComercialExportacion|\api\Siat\Invoices\ServicioTuristicoHospedaje|\api\Siat\Invoices\TasaCero|\api\Siat\Invoices\SectorEducativo|\api\Siat\Invoices\Hotel|\api\Siat\Invoices\Hospitales|\api\Siat\Invoices\ComercialExportacionServicio|\api\Siat\Invoices\ServicioBasico|\api\Siat\Invoices\EntidadFinanciera
	 */
	public static function construirFacturaSector(int $documentoSector, int $modalidad, &$detailClass)
	{
		$factura = null;
		$detailClass = InvoiceDetail::class;
		
		if( $modalidad == ServicioSiat::MOD_ELECTRONICA_ENLINEA )
		{
			if( $documentoSector == DocumentTypes::FACTURA_COMPRA_VENTA )
				$factura = new ElectronicaCompraVenta();
			else if( $documentoSector == DocumentTypes::FACTURA_COMERCIAL_EXPORTACION )
			{
				$factura = new ElectronicaComercialExportacion();
				$detailClass = InvoiceDetailComercialExportacion::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_SERVICIO_TURISTICO )
			{
				$factura = new ElectronicaServicioTuristicoHospedaje();
				$detailClass = InvoiceDetailTuristico::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_TASA_CERO_LIBROS )
			{
				$factura = new ElectronicaTasaCero();
				//$detailClass = InvoiceDetailTuristico::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_SECTOR_EDUCATIVO )
			{
				$factura = new ElectronicaSectorEducativo();
			}
			else if( $documentoSector == DocumentTypes::FACTURA_HOTELES )
			{
				$factura = new ElectronicaHotel();
				$detailClass = InvoiceDetailHotel::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_HOSPITALES )
			{
				$factura = new ElectronicaHospitales();
				$detailClass = InvoiceDetailHospital::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_COM_EXPORT_SERVICIOS )
			{
				$factura = new ElectronicaComercialExportacionServicio();
				//$detailClass = InvoiceDetailComercialExportacion::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_SERV_BASICOS )
			{
				$factura = new ElectronicaServicioBasico();
			}
			else if( $documentoSector == DocumentTypes::FACTURA_ENT_FINANCIERA )
			{
				$factura = new ElectronicaEntidadFinanciera();
			}
		}
		else
		{
			if( $documentoSector == DocumentTypes::FACTURA_COMPRA_VENTA )
				$factura = new CompraVenta();
			else if( $documentoSector == DocumentTypes::FACTURA_COMERCIAL_EXPORTACION )
			{
				$factura = new ComercialExportacion();
				$detailClass = InvoiceDetailComercialExportacion::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_SERVICIO_TURISTICO )
			{
				$factura = new ServicioTuristicoHospedaje();
				$detailClass = InvoiceDetailTuristico::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_TASA_CERO_LIBROS )
			{
				$factura = new TasaCero();
				//$detailClass = InvoiceDetailTuristico::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_SECTOR_EDUCATIVO )
			{
				$factura = new SectorEducativo();
			}
			else if( $documentoSector == DocumentTypes::FACTURA_HOTELES )
			{
				$factura = new Hotel();
				$detailClass = InvoiceDetailHotel::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_HOSPITALES )
			{
				$factura = new Hospitales();
				$detailClass = InvoiceDetailHospital::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_COM_EXPORT_SERVICIOS )
			{
				$factura = new ComercialExportacionServicio();
				//$detailClass = InvoiceDetailComercialExportacion::class;
			}
			else if( $documentoSector == DocumentTypes::FACTURA_SERV_BASICOS )
			{
				$factura = new ServicioBasico();
			}
			else if( $documentoSector == DocumentTypes::FACTURA_ENT_FINANCIERA )
			{
				$factura = new EntidadFinanciera();
			}
		}
		if( !$factura )
			throw new Exception('El documento sector no se encuentra o no esta implementado');
		//$factura->detalle = new $detailClass();
		
		return $factura;
	}
	/**
	 * Crear el servicio de factura segun datos de la configuracion
	 * 
	 * @param SiatConfig $config
	 * @return \api\Siat\Services\ServicioFacturacionElectronica|\api\Siat\Services\ServicioFacturacionComputarizada
	 */
	public static function obtenerServicioFacturacion(SiatConfig $config, string $cuis = '', string $cufd = '', string $codigoControl = '')
	{
		$servicio = $config->modalidad == ServicioSiat::MOD_ELECTRONICA_ENLINEA ?
			new ServicioFacturacionElectronica($cuis, $cufd) : 
			new ServicioFacturacionComputarizada($cuis, $cufd);
		$servicio->setConfig((array)$config);
		if( $codigoControl )
			$servicio->codigoControl = $codigoControl;
		if( $config->modalidad == ServicioSiat::MOD_ELECTRONICA_ENLINEA )
		{
			$servicio->setPrivateCertificateFile($config->privCert);
			$servicio->setPublicCertificateFile($config->pubCert);
		}
		
		return $servicio;
	}
}