<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper" class="ibox-content" style="padding: 0px;">
		<div class="sk-spinner sk-spinner-wave" >
			<div class="sk-rect1"></div>
			<div class="sk-rect2"></div>
			<div class="sk-rect3"></div>
			<div class="sk-rect4"></div>
			<div class="sk-rect5"></div>
		</div>
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Ingresos de Mercaderia </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<div class="col-sm-2">
									<h5>Sucursal : <b id='nomSucursal'></b></h5>
								</div>
								<div class="col-lg-2">
									<div id="mostrarsucursal" style="display:none;">
										<select class="form-control" id="selectSucursal"></select>
									</div>
								</div>
								<div class="row form-group col-sm-8">
									<div class="col-sm-11">
										<label class="col-sm-1 control-label"> Mes:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='mes' onchange="cam_inifin(this.value);" required />
										</div>
										<label class="col-sm-1 control-label"> F.Ini:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='finicio' required />
										</div>
										<label class="col-sm-1 control-label"> F.Fin:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='ffin' required />
										</div>
									</div>
									<div class="col-sm-1">
										<!-- -->
										<button class="btn btn-info btn-sm " onclick="cargarAjustes();"> <i class="fa fa-filter"></i> </button>
									</div>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active "> <a id="tabventa" href="#tab-1" data-toggle="tab"><label class="text-navy"><i class="fa fa-shopping-cart"></i> Realizar Ajuste </a></label></li>
									<li> <a id="tablistado" href="#tab-2" onclick="cargarAjustes();"><label class="text-navy"><i class="fa fa-tags"></i> Listado Ajustes </a></label></li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active">
										<div class="ibox-content">
											<div class="row">
												<div class="col-lg-9">
													<div class="ibox">
														<div class="ibox-title">
															<div class="col-md-4">
																<h5> Listado Productos </h5>
															</div>
															<div class="col-md-2">
																<label style="text-align: right;">Stock Total: </label>
															</div>
															<div class="col-md-3">
																<input class="form-control input-sm" type="text" id="stocktotal" disabled>
															</div>
															<div class="col-md-3">
																<button type="button" style="float:right" class="btn btn-outline btn-primary btn-sm" data-toggle="modal" data-target="#modalExcel"> <i class="fa fa-file-excel-o"></i> </button>
															</div>
														</div>
														<div class="ibox-content">
															<div class="row">
																<div class="col-md-6" style="font-size:10px;">
																	<select class="form-control" id="selectInventario" onchange="agregarItemStock(this.value,1)" style="width: 100%;" required></select>
																</div>
																<div class="col-md-6" style="font-size:10px;">
																	<div class="input-group">
																		<input type="text" id="codbar_aju" placeholder="Ingrese codigo de Barras" onkeypress="ingresarCodigo(event)" class="form-control input-sm vnt"><span class="input-group-btn"> <button type="button" style="width:35px;" onclick="buscarCodigoBarras()" class="btn btn-info btn-outline btn-sm"><i class="fa fa-search"></i></button></span>
																	</div>
																</div>
															</div>
															<hr>
															<div class="row">
																<div class="table-responsive">
																	<table class="table table-striped table-bordered table-hover lisPedido" style="font-size:10px;"></table>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="col-lg-3">
													<div class="ibox">
														<div class="ibox-title">
															<h5>Detalle Ajuste </h5><small>( TC : <span id="tcempresa"></span> )</small><span class="pull-right btn btn-primary btn-outline btn-sm"> <i class="fa fa-shopping-cart"></i>(<strong id="itmcantidad">0</strong>) Items</span>
														</div>
														<div class="ibox-content">
															<div class="form-horizontal form-label-left">

																<div class="row">
																	<div class="col-md-12">
																		<label class="control-label">Concepto: </label>
																		<input type="text" id="concepto_aju" value="-" class="form-control ">
																	</div>
																	<div class="col-md-12">
																		<label class="control-label">Cantidad: </label>
																		<input type="text" value="0" id="cantidad_aju" class="form-control vnt" readonly>
																	</div>
																	<div class="col-md-12">
																		<label class="control-label">Precio Total</label>
																		<input type="text" value="0" id="precio_aju" class="form-control vnt" readonly>
																	</div>
																</div>
																<br>
																<div class="row">
																	<div class="col-md-12">
																		<button onclick="realizarAjuste()" class="btn btn-block btn-outline btn-success"> <i class="fa fa-shopping-cart"></i> Realizar Ajuste </button>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Ajustes </h5>
														<div class="ibox-tools">
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive">
															<table class="table table-striped table-bordered table-hover lisAjuste" style="font-size:10px; ">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalExcel" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-file-excel-o"></i> Subir Excel de Ajustes</h4>
							<small> Subir Excel de Ajustes al Sistema.</small>
						</div>
						<div class="modal-body">
							<form method="post" enctype="multipart/form-data">
								<div class="row">
									<div class="form-group">
										<div class="col-md-2 col-sm-2 col-xs-2">
											<label class="control-label"> Excel: </label>
										</div>
										<div class="col-md-8 col-sm-8 col-xs-8">
											<input type="file" class="form-control" id="excelaju">
										</div>
									</div>
								</div>
							</form>
						</div>
						<div class="modal-footer">
							<button onclick="subirExcelAjuste();" class="btn btn-success btn-sm"><i class="fa fa-upload"></i> Subir Excel </button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var date = new Date();
		var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth() + 1);
		var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
		var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
		var fecini = mes + "-" + Empresa.agregarCero(primerDia);
		var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
		var fechoy = mes + "-" + date.getDate();


		var ids = "<?php echo $ids; ?>";
		var usr = "<?php echo $usr; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisAjuste = [];
		var pedido = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById('tcempresa').innerHTML = tc;
			selectTiposDoc();
			selectMetodoPago();
			selectTipoPago();
			selectSucursal(ids);
			cargarFechas();
			selectInventario();
			headerDetalleAjuste();

			if (idr == '2') {
				$('#mostrarsucursal').show();
			}

		}

		function cargarFechas() {
			$("#mes").val(mes);
			$("#finicio").val(fecini);
			$("#ffin").val(fecfin);
			$("#ffin").val(fecfin);
			var date0 = $('input[id="mes"]');
			var date1 = $('input[id="finicio"]');
			var date2 = $('input[id="ffin"]');
			var hoy = $('input[id="farqueo"]');
			date0.datepicker({
				format: 'yyyy-mm',
				startView: 'months',
				minViewMode: 'months',
				todayHighlight: true,
				autoclose: true,
			});
			date1.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			date2.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			hoy.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
		}

		function cam_inifin(dato) {
			Empresa.cambiarFechas(dato, "#finicio", "#ffin");
			mes = $("#mes").val();
			fecini = $("#finicio").val();
			fecfin = $("#ffin").val();
		}

		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor) {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectSucursal").val(valor);
					$("#selectSucursal").select2();
				}
			});
			ids = valor;
		}

		function selectTipoPago() {
			Empresa.actualizarSelect({
				selector: "#selectTipoPago",
				sql: "select id_tipo as id, concat(tipo_pago) as etiqueta from tipo_pago",
				callback: function(data) {
					$("#selectTipoPago").val(1);
					$("#selectTipoPago").select2();
				}
			});
		}

		function selectTiposDoc() {
			Empresa.actualizarSelect({
				selector: "#selectTipoDoc",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_tipos_documento_identidad",
				callback: function(data) {
					$('#selectTipoDoc').val(1);
					$('#selectTipoDoc').select2();
				}
			});
		}

		function selectMetodoPago() {
			Empresa.actualizarSelect({
				selector: "#selectMetodoPago",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_metodo_pago order by descripcion ",
				callback: function(data) {
					$('#selectMetodoPago').val(1);
					$('#selectMetodoPago').select2();
				}
			});
		}

		function selectInventario() {
			Empresa.actualizarSelect({
				selector: "#selectInventario",
				sql: "SELECT p.id_producto as id, concat(p.codigo,' ',p.nombre) as etiqueta FROM producto p",
				callback: function(data) {
					$("#selectInventario").select2({
						placeholder: "Seleccione un producto del inventario.",
						minimumInputLength: 2
					});
				}
			});
			stockInventario();
		}
		// -------------------------- Ventas ---------------------------- //

		function headerDetalleAjuste() {
			var columnsName = [{
				title: "#"
			}, {
				title: "Imagen"
			}, {
				title: "Producto"
			}, {
				title: "Cantidad"
			}, {
				title: "P/U"
			}, {
				title: "SubTotal"
			},{
				title: "Vencimiento"
			},{
				title: "Lote"
			}, {
				title: ""
			}];
			Empresa.inicializarTablaSinFormato({
				selector: ".lisPedido",
				columnas: columnsName
			});
		}

		function limitarCadena(cadena, maximoCaracteres) {
			return cadena.length > maximoCaracteres ? cadena.substring(0, maximoCaracteres) : cadena;
		}

		function stockInventario() {
			var funcion = "stockInventario";
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: funcion,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var stock = respuesta.stock;
					$("#stocktotal").val(stock.stocktotal);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function buscarCodigoBarras() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var codigob = document.getElementById("codbar_cmp").value;
			var funcion = "buscarCodigoBarrasIngreso";
			var body = {
				funcion: funcion,
				codigob: codigob,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var producto = respuesta.producto;
					Empresa.hideSpinner();
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO_BARRAS, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_MAYOR, producto.PRECIO_ESPECIAL, producto.PRECIO_TOPE, producto.UNIDAD, cantidad, producto.IMAGEN, producto.CODIGO_SIN, producto.CODIGO_ACTIVIDAD, producto.UNIDAD_MEDIDA);
					$("#codbar_cmp").val("");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					$("#codbar_cmp").val("");
					Empresa.hideSpinner();
				}
			});
		}

		function ingresarCodigo(e) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			if ((keycode >= 48 && keycode <= 57) || (keycode > 64 && keycode < 91) || (keycode >= 96 && keycode <= 123) || keycode == 8 || keycode == 45) {

			} else if (keycode == '13') {
				e.preventDefault();
				buscarCodigoBarras();
			} else {
				e.preventDefault();
			}
		}

		function agregarItemStock(id, cantidad) {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var funcion = "editProducto";
			var body = {
				funcion: funcion,
				idproducto: id,
				cantidad: cantidad,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO_BARRAS, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_MAYOR, producto.PRECIO_ESPECIAL, producto.PRECIO_TOPE, producto.UNIDAD, cantidad, producto.IMAGEN, producto.CODIGO_SIN, producto.CODIGO_ACTIVIDAD, producto.UNIDAD_MEDIDA);
					selectInventario();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function agregarItem(idp, codigo, nombre, pcompra, pventa, pmayor, pespecial, ptope, unidad, cantidad, imagen, codsin, codact, unimed) {
			// Inicialización de variables
			var count = pedido.length;
			var pfinal = pcompra;

			// Calcular el precio base (preciobs) para el nuevo artículo
			var precbs = Math.floor(pfinal * cantidad * 100) / 100;
			var preciobs = Empresa.financial(precbs, 2);

			// Crear un nuevo objeto de artículo
			var itemPedido = {
				idp: idp,
				idproducto: idp,
				codigo: codigo,
				codigop: codigo,
				nombre: nombre,
				producto: nombre,
				pcompra: pcompra,
				pventa: pventa,
				pmayor: pmayor,
				pespecial: pespecial,
				ptope: ptope,
				pfinal: pfinal,
				unidad: unidad,
				cantidad: cantidad,
				imagen: imagen,
				actividad: codact,
				codigosin: codsin,
				descuento: 0,  // Sin descuento por defecto
				unidadmedida: unimed,
				preciounitario: pfinal,
				preciobs: preciobs,
				fvencimiento: fechoy,
				lote: '0'  // Lote inicial
			};
			if (count > 0) {
				var id = pedido.findIndex(e => e.idp === idp);
				if (id >= 0) {
					pedido[id].cantidad = parseFloat((parseFloat(pedido[id].cantidad) + parseFloat(cantidad)).toFixed(3));
				} else {
					pedido.push(itemPedido);
				}
			} else {
				pedido.push(itemPedido);
			}
			// Ahora, redibujamos la tabla con los artículos actualizados
			dibujarTabla();
		}

		function quitarArticulo(id) {
			if (id >= 0 && id < pedido.length) {
				pedido.splice(id, 1);
			}
			dibujarTabla();
		}

		function itemsCarrito(id, valor) {
			if (id >= 0 && id < pedido.length) {
				pedido[id].cantidad = valor;
			}
			dibujarTabla();
		}

		function actualizarPrecio(e, actual, id, pmax, pmin) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;
			
			if (keycode >= 46 && keycode <= 57 || keycode == 8) {
				// Permitido, no hacer nada
			} else if (keycode == '13' || bool == true) {
				actual = parseFloat(actual);
				pmin = parseFloat(pmin);
				
				if (actual >= pmin) {
					if (id >= 0 && id < pedido.length) {
						pedido[id].pfinal = actual;
					}
					dibujarTabla();
				} else {
					Empresa.notificationError("No se puede modificar el precio menor al precio tope");
					$('#prec' + id).val(pmax).focus();
				}
			} else {
				e.preventDefault();
			}
		}

		function actualizarLote(e, actual, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if (keycode >= 46 && keycode <= 57 || keycode == 8) {
				// Permitido, no hacer nada
			} else if (keycode == '13' || bool == true) {
				if (id >= 0 && id < pedido.length) {
					pedido[id].lote = actual;
				}
				dibujarTabla();
			} else {
				e.preventDefault();
			}
		}

		function actualizarVencimiento(e, actual, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if (keycode >= 46 && keycode <= 57 || keycode == 8) {
				// Permitido, no hacer nada
			} else if (keycode == '13' || bool == true) {
				if (id >= 0 && id < pedido.length) {
					pedido[id].fvencimiento = actual;
				}
				dibujarTabla();
			} else {
				e.preventDefault();
			}
		}


		function realizarAjuste() {
			var concepto = document.getElementById("concepto_aju").value;
			var cantidad = document.getElementById("cantidad_aju").value;
			var precio = document.getElementById("precio_aju").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			if (pedido.length == 0) {
				Empresa.notificationError("No se Puede Realizar esta transaccion si no tiene detalle.");
				Empresa.hideSpinner();
				return;
			}
			var funcion = "realizarAjuste";
			var body = {
				funcion: funcion,
				concepto: concepto,
				precio: precio,
				cantidad: cantidad,
				detalle: pedido,
				idsucursal: idsucursal,
				iduser: idu
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var idaju = respuesta.idajuste;
					Empresa.notificationSuccess(" Se realizo correctamente el ajuste");
					imprimirAjuste(idaju);
					window.location.reload();

				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function dibujarTabla() {
			lisDetalleAjuste = [];
			var sumtitems = 0;
			var preciototal = 0;
			var sumtprecio = 0;

			// Redibujar los elementos del pedido actualizado
			for (var i = 0; i < pedido.length; i++) {
				sumtitems = parseFloat(sumtitems) + parseFloat(pedido[i].cantidad);
				preciototal = parseFloat(pedido[i].pfinal) * parseFloat(pedido[i].cantidad);
				sumtprecio = parseFloat(sumtprecio) + parseFloat(preciototal);
				
				lisDetalleAjuste.push([
					"" + (i + 1),
					crearImgDet(pedido[i].imagen, "40"),
					pedido[i].nombre,
					crearInputCantidad(i, pedido[i].cantidad) + " Uds",
					crearInputPrecio(i, pedido[i].pfinal, pedido[i].ptope) + " Bs.",
					crearInputPrecioSubTotal(i, preciototal) + " Bs.",
					crearInputVencimiento(i, pedido[i].fvencimiento),
					crearInputLote(i, pedido[i].lote),
					crearButtonQuitar(i)
				]);
			}

			document.getElementById('itmcantidad').innerHTML = sumtitems;
			$("#cantidad_aju").val(sumtitems);
			$("#precio_aju").val(Empresa.roundNumber(sumtprecio, 2));

			// Refrescar la tabla con los nuevos datos
			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: lisDetalleAjuste
			});
		}

		function cargarAjustes() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			$('#tablistado').tab('show');
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var columnsName = [{
				title: "#"
			}, {
				title: " Fecha"
			}, {
				title: " Boleta"
			}, {
				title: "Concepto"
			}, {
				title: " Cantidad"
			}, {
				title: " Costo Total"
			}, {
				title: " "
			}];
			lisAjuste = [];
			var body = {
				funcion: "listarAjustes",
				idsucursal: idsucursal,
				iduser: idu,
				idrol: idr,
				fecini: fecini,
				fecfin: fecfin
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var ajustes = respuesta.ajustes.data;
					for (var i = 0; i < ajustes.length; i++) {
						lisAjuste.push([
							i + 1,
							ajustes[i].FECHA_REGISTRO,
							ajustes[i].BOLETA,
							ajustes[i].CONCEPTO,
							ajustes[i].CANTIDAD,
							ajustes[i].PRECIO_TOTAL,
							crearButtonsAjuste(ajustes[i].ID_AJUSTE)
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisAjuste",
						data: lisAjuste,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisAjuste",
						data: lisAjuste
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function subirExcelAjuste() {
			Empresa.showSpinner();
			var inputFile = document.getElementById("excelaju");
			var file = inputFile.files[0];
			var archivo = file.name;
			var data = new FormData();
			var funcion = "subirExcelAjuste";
			data.append('excelaju', file);
			data.append('funcion', funcion);
			Empresa.restImg({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesArchivosInventario.php"),
				data: data,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var excel = respuesta.excel;
					$("#excelaju").val("");
					cargarExcelAjuste(excel);
					$("#modalExcel").modal("hide");
					Empresa.notificationSuccess("Archivo Subido Correctamente");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function cargarExcelAjuste(excel) {
			Empresa.showSpinner();
			lisNewFactura = [];
			var body = {
				funcion: "cargarExcelAjuste",
				excel: excel
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {

					var detalle = respuesta.detalle;
					$('#tabcompra').tab('show');
					pedido = [];
					pedido = detalle;

					dibujarTabla();
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
				}
			});
		}

		function imprimirAjuste(id) {
			Empresa.PopupCenter('print_ajuste.php?id=' + id + '', 'IMPRIMIR AJUSTE', 400, 520);
		}

		function crearButtonsAjuste(id) {
			return "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Imprimir Ajuste' onclick='imprimirAjuste(\"" + id + "\")'><i class='fa fa-print'></i></button>";
		}

		function crearInputCantidad(id, cantidad) {
			return "<input class='form-control'  style='width: 60px;' id='num" + id + "' onchange='itemsCarrito(\"" + id + "\",this.value)' type='number'  step='1' min='1' value='" + cantidad + "' >";
		}


		function crearInputPrecio(i, precio, ptope) {
			return "<input class='form-control' id='prec" + i + "'  style='width: 80px;' size='4' type='text' value='" + precio + "'  onfocusout='actualizarPrecio(event,this.value,\"" + i + "\",\"" + precio + "\",\"" + ptope + "\")'>";;
		}

		function crearInputVencimiento(i, vencimiento) {
			return "<input class='form-control' id='vencimiento" + i + "'   type='date' value='" + vencimiento + "'  onfocusout='actualizarVencimiento(event,this.value,\"" + i + "\")'>";;
		}

		function crearInputLote(i, lote) {
			return "<input class='form-control' id='lote" + i + "'  style='width: 80px;' size='4' type='text' value='" + lote + "'  onfocusout='actualizarLote(event,this.value,\"" + i + "\")'>";;
		}

		function crearButtonQuitar(id) {
			return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Articulo' onclick='quitarArticulo(\"" + id + "\")'><i class='fa fa-trash'></i></button>";
		}

		function crearInputPrecioSubTotal(i, precio) {
			return "<input class='form-control' readonly id='precsubtotal" + i + "'  style='width: 60px;' size='4' type='text' value='" + precio + "'>";
		}

		function crearImgDet(url, tam) {
			var imgurl = "<img src='img/producto/" + url + "'  width='" + tam + "' id='imageModel' /> ";
			return imgurl;
		}

		this.initializer();
	</script>
</body>

</html>