
<?php

class DB
{
    private $host;
    private $user;
    private $password;
    private $database;
    private $link;


    public function DB($host = "localhost", $user = "met4soft_admin", $password = "Metasoft.2022", $database = "met4soft_farmaciaespecializadajyg")
    {
        $this->host = $host;
        $this->user = $user;
        $this->password = $password;
        $this->database = $database;
    }

    public function conectar()
    {
        $this->link = new mysqli($this->host, $this->user, $this->password, $this->database);
        if (mysqli_connect_errno()) {
            throw new Exception('[DB error] La conexión a la base de datos falló');
        }
        _log("[sql] conectar", "sql.log", true);
    }

    // Métodos de consulta
    public function consultaOne($consultaSql, $close = false)
    {
        $resultadoConsulta = $this->consulta($consultaSql, $close);
        return $this->convertirAObjeto($resultadoConsulta);
    }

    public function consultaAll($consultaSql, $close = false)
    {
        $resultado = array();
        $coleccionDeDatos = array();
        $resultadoConsulta = $this->consulta($consultaSql, $close);
        
        while ($dato = $this->convertirAObjeto($resultadoConsulta)) {
            array_push($coleccionDeDatos, $dato);
        }
        
        $resultado["size"] = $this->obtenerNumeroFilas($resultadoConsulta);
        $resultado["data"] = $coleccionDeDatos;
        return $resultado;
    }

    public function consulta($consultaSql, $close = false)
    {
        _log('[sql] ' . $consultaSql, "sql.log", true);
        if ($resultadoConsulta = mysqli_query($this->link, $consultaSql)) {
            return $resultadoConsulta;
        } else {
            $errorSql = mysqli_error($this->link);
            _log('[DB error] ' . $errorSql, "sql.log");
            throw new Exception('[DB error: ' . $errorSql . ' ] sql: ' . $consultaSql, 500);
        }
    }

    public function convertirAObjeto($variable)
    {
        return mysqli_fetch_object($variable);
    }

    public function obtenerNumeroFilas($resultadoConsulta)
    {
        $resultado = mysqli_num_rows($resultadoConsulta);
        if ($resultado === false) {
            throw new Exception('[DB error: Error al recuperar número de filas]', 500);
        }
        return $resultado;
    }

    // Métodos de consultas preparadas
    public function consultaPreparadaOne($consultaSql, $tipos = "", $parametros = [], $close = false)
    {
        $stmt = $this->link->prepare($consultaSql);
        if ($stmt === false) {
            throw new Exception("[DB error] Error en la preparación de la consulta: " . $this->link->error);
        }

        // Verifica si hay tipos y parámetros para bind_param
        if ($tipos && count($parametros) > 0) {
            $stmt->bind_param($tipos, ...$parametros);
        }

        $stmt->execute();
        $resultado = $stmt->get_result();
        $data = $resultado->fetch_object();

        if ($close) {
            $stmt->close();
        }

        return $data;
    }


    public function consultaPreparadaAll($consultaSql, $tipos = "", $parametros = [], $close = false)
    {
        $stmt = $this->link->prepare($consultaSql);
        if ($stmt === false) {
            throw new Exception("[DB error] Error en la preparación de la consulta: " . $this->link->error);
        }

        // Verifica si hay tipos y parámetros para bind_param
        if ($tipos && count($parametros) > 0) {
            $stmt->bind_param($tipos, ...$parametros);
        }

        $stmt->execute();
        $resultado = $stmt->get_result();
        $coleccionDeDatos = array();
        
        while ($dato = $resultado->fetch_object()) {
            array_push($coleccionDeDatos, $dato);
        }

        if ($close) {
            $stmt->close();
        }

        $resultadoArray = array(
            "size" => count($coleccionDeDatos),
            "data" => $coleccionDeDatos
        );

        return $resultadoArray;
    }


    public function insertPreparado($consultaSql, $tipos = "", $parametros = [])
    {
        if (substr_count($consultaSql, '?') !== count($parametros)) {
            throw new Exception("[DB error] El número de parámetros no coincide con los placeholders (?) en la consulta.");
        }
    
        $stmt = $this->link->prepare($consultaSql);
        if ($stmt === false) {
            throw new Exception("[DB error] Error en la preparación de la consulta: " . $this->link->error);
        }
    
        if (!empty($tipos) && !empty($parametros)) {
            $refs = [];
            foreach ($parametros as $key => $value) {
                $refs[$key] = &$parametros[$key];
            }
    
            array_unshift($refs, $tipos); 
            call_user_func_array([$stmt, 'bind_param'], $refs);
        }

        $stmt->execute();
        if ($stmt->affected_rows === -1) {
            throw new Exception("[DB error] Error en la ejecución del INSERT: " . $stmt->error);
        }

        $insertId = $stmt->insert_id;
    

        $stmt->close();
    
        return $insertId;
    }
    

    public function updatePreparado($consultaSql, $tipos = "", $parametros = [])
    {
        $stmt = $this->link->prepare($consultaSql);
        if ($stmt === false) {
            throw new Exception("[DB error] Error en la preparación de la consulta: " . $this->link->error);
        }

        // Verifica si hay tipos y parámetros para bind_param
        if ($tipos && count($parametros) > 0) {
            $stmt->bind_param($tipos, ...$parametros);
        }

        $stmt->execute();

        if ($stmt->affected_rows === -1) {
            throw new Exception("[DB error] Error en la ejecución del UPDATE: " . $this->link->error);
        }

        // Devuelve el número de filas afectadas
        $affectedRows = $stmt->affected_rows;
        $stmt->close();
        return $affectedRows;
    }

    public function consultaPreparada($query, $types = "", $params = [])
    {
        $stmt = $this->link->prepare($query);
        if ($stmt === false) {
            throw new Exception("Prepare failed: " . $this->link->error);
        }

        // Verifica si hay tipos y parámetros para bind_param
        if ($types && count($params) > 0) {
            $stmt->bind_param($types, ...$params);
        }

        $stmt->execute();

        $result = $stmt->get_result();
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        $stmt->close();
        return $data;
    }


    // Otros métodos
    public function begin()
    {
        mysqli_autocommit($this->link, FALSE);
        _log("[sql] begin", "sql.log", true);
    }

    public function commit()
    {
        mysqli_commit($this->link);
        _log("[sql] commit", "sql.log", true);
    }

    public function rollback()
    {
        mysqli_rollback($this->link);
        _log("[sql] rollback", "sql.log");
    }

    public function close()
    {
        mysqli_close($this->link);
        _log("[sql] close", "sql.log", true);
    }
}
?>


<?php

