<?php

class Response
{
    private static $instance;

    public static function singleton()
    {
        if (!isset(self::$instance)) {
            self::$instance = new Response();
        }
        return self::$instance;
    }

    public static function sendOne($data = null, $status = "200")
    {
        if ($data == null) {
            $data = array();
            $data['data'] = new stdClass();
        }

        if (ob_get_length()) {
            ob_end_clean(); // limpia cualquier salida anterior
        }

        http_response_code((int)$status);
        header('Content-Type: application/json; charset=UTF-8');
        echo json_encode($data);
        exit;
    }

    public static function sendAll($data = null, $status = "200")
    {
        if (ob_get_length()) {
            ob_end_clean();
        }

        http_response_code((int)$status);
        header('Content-Type: application/json; charset=UTF-8');
        if ($data == null) {
            echo json_encode(array());
        } else {
            echo json_encode($data);
        }
        exit;
    }

    public static function sendError($exception, $mensajeParaUsuario = "desconocido")
    {
        _log($exception->getMessage(), "./response.log");
        $code = $exception->getCode();
        if ($code == 0) {
            $code = 500;
        }

        if (ob_get_length()) {
            ob_end_clean();
        }

        http_response_code($code);
        header('Content-Type: application/json; charset=UTF-8');

        $mensaje = array();
        $mensaje['codigo'] = $code;
        $mensaje['mensaje'] = $exception->getMessage();
        $mensaje['mensajeParaUsuario'] = "Ocurrió un error: " . $mensajeParaUsuario . ", si el error persiste comuníquese con el administrador del sistema";

        if ($code == 500) {
            $mensaje['rastro'] = $exception->getTrace();
        }

        echo json_encode($mensaje);
        exit;
    }

    public static function getBody()
    {
        return (array)json_decode(file_get_contents('php://input'));
    }

    public static function getQuery()
    {
        $otros = array();
        if (!isset($_SERVER['QUERY_STRING'])) return (object)$otros;

        $queries = explode("&", $_SERVER['QUERY_STRING']);
        foreach ($queries as $tupla) {
            $query = explode("=", $tupla);
            if (isset($query[1])) {
                $otros[$query[0]] = explode(",", $query[1]);
            }
        }
        return (object)$otros;
    }

    public static function getField()
    {
        $query = self::getQuery();
        $resultado = "*";
        if (isset($query->fields)) {
            $resultado = implode(",", $query->fields);
        }
        return $resultado;
    }

    public static function getParamas()
    {
        return explode("/", $_SERVER['PATH_INFO'] ?? '');
    }

    public static function getMetodo()
    {
        return $_SERVER['REQUEST_METHOD'];
    }

    public static function getVariable($nombreVariable)
    {
        $query = json_decode(json_encode(self::getQuery()), true);
        if (isset($query[$nombreVariable])) {
            $resultado = $query[$nombreVariable];
            return count($resultado) === 1 ? $resultado[0] : $resultado;
        } else {
            throw new Exception("La variable: " . $nombreVariable . " es obligatoria");
        }
    }
}

$Response = Response::singleton();
