<?php
namespace api\Siat\Invoices;

use api\Siat\Invoices\InvoiceDetail;
use Exception;

class InvoiceDetailHospital extends InvoiceDetail
{
	public	$actividadEconomica;
	public	$codigoProductoSin;
	public	$codigoProducto;
	public	$descripcion;
	public	$especialidad; //## CA ##
	public	$especialidadDetalle; //## CA ##
	public	$nroQuirofanoSalaOperaciones; //## CA ##
	public	$especialidadMedico; //## CA ##
	public	$nombreApellidoMedico; //## CA ##
	public	$nitDocumentoMedico; //## CA ##
	public	$nroMatriculaMedico; //## CA ##
	public	$nroFacturaMedico; //## CA ##
	public	$cantidad;
	public	$unidadMedida;
	public	$precioUnitario;
	public	$montoDescuento;
	public	$subTotal;
	
	
	public function __construct()
	{
		parent::__construct();
		$this->xmlAttributes = array_merge($this->xmlAttributes, [
			'especialidad'		,
			'especialidadDetalle' ,
			'especialidadMedico' ,
			'nroMatriculaMedico' ,
			'nroFacturaMedico' ,
		]);
		$this->skipProperties[] = 'numeroSerie';
		$this->skipProperties[] = 'numeroImei';
	}
	public function validate()
	{
		
		if( (int)$this->nroMatriculaMedico <= 0 )
			$this->nroMatriculaMedico = null;
		
		parent::validate();
		if( (int)$this->nitDocumentoMedico <= 0 )
			throw new Exception('Debe ingresar un NIT para el medico');
		if( (int)$this->nroQuirofanoSalaOperaciones <= 0 )
			throw new Exception('El nro de quirofona debe ser mayor o igual a 1');
	}
}