<?php
set_time_limit(0);
require_once dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'autoload.php';
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'test-functions.php';

use api\Siat\DocumentTypes;
use api\Siat\SiatConfig;
use api\Siat\Invoices\SiatInvoice;
use api\Siat\Services\ServicioSiat;
use api\Siat\Services\ServicioFacturacionSincronizacion;

//openssl pkcs12 -info -in [cert_filename] -nodes -nocerts -out [out_cert_filename]
//openssl pkcs12 -in [cert_filename] -clcerts -nokeys -out [out_cert_filename]

date_default_timezone_set('America/La_Paz');

$config = new SiatConfig([
	'nombreSistema' => 'GemglooBill',
	'codigoSistema' => '77606FDBE7889D509F2F96F',
	'nit'           => '493884023',
	'razonSocial'   => 'PAGLOO S.R.L',
	'modalidad'     => ServicioSiat::MOD_COMPUTARIZADA_ENLINEA,
	//'modalidad'     => ServicioSiat::MOD_ELECTRONICA_ENLINEA,
	'ambiente'      => ServicioSiat::AMBIENTE_PRUEBAS,
	'tokenDelegado'	=> 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJHZW1nbG9vMjMiLCJjb2RpZ29TaXN0ZW1hIjoiNzc2MDZGREJFNzg4OUQ1MDlGMkY5NkYiLCJuaXQiOiJINHNJQUFBQUFBQUFBRE94Tkxhd01ERXdNZ1lBYjdzbjVna0FBQUE9IiwiaWQiOjMwMTYzNjIsImV4cCI6MTcwNTEwNDAwMCwiaWF0IjoxNjk0MjE0ODgwLCJuaXREZWxlZ2FkbyI6NDkzODg0MDIzLCJzdWJzaXN0ZW1hIjoiU0ZFIn0.B5BjP9Y0QsFXQP4Dlx9Qsxe-S9yejLrokLHidb8djsxC0cQTPCKa62-HAM1Y22fbFiI17d2FydXJcRldqzqzaA',
	'pubCert'		=> MOD_SIAT_DIR . SB_DS . 'certs' . SB_DS . 'publicKey.pem',
	'privCert'		=> MOD_SIAT_DIR . SB_DS . 'certs' . SB_DS . 'privateKey.pem',
]);
$sucursal 			= 0;
$puntoventa 		= 0;
$cantFacturas		= 1000;
$codigoEvento		= 2;
$evento 			= null;
$cufdAntiguo 		= 'BQTlDVMOTa0FBNzDhFODRCNjYwMjY=QmV1Rm9NYUpXVUFIyODVFNEE5MzkyN';
$codigoControlAntiguo = '675ECB0303D6D74';
$fechaInicio 		= '2022-09-25T13:00:00.000';
$fechaFin 			= '2022-09-25T13:20:00.000';
$fechaEmision		= '2022-09-25T13:15:00.000';
//$fechaEmision		= date("Y-m-d\TH:i:s.v"); 2022-09-23T15:30:00.000 fecha emision
$codigoActividad	= '620100';
$codigoProductoSin	= '83141';
$documentoSector	= 34;
$tipoFactura		= 1;
$cafc 				= null;
$resEvento 			= null;


function pruebasCatalogos()
{
	global $config, $sucursal;
	
	$count = 0;
	foreach([0, 1] as $puntoventa)
	{
		$resCuis 	= obtenerCuis($puntoventa, $sucursal, true);
		$service = new ServicioFacturacionSincronizacion($resCuis->RespuestaCuis->codigo);
		$service->setConfig((array)$config);
		for($i = 0; $i < 50; $i++)
		{
			$res = $service->sincronizarActividades($sucursal, $puntoventa);
			$res = $service->sincronizarFechaHora($sucursal, $puntoventa);
			$res = $service->sincronizarListaLeyendasFactura($sucursal, $puntoventa);
			$res = $service->sincronizarListaMensajesServicios($sucursal, $puntoventa);
			$res = $service->sincronizarListaProductosServicios($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaEventosSignificativos($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaMotivoAnulacion($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaPaisOrigen($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaTipoDocumentoIdentidad($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaTipoDocumentoSector($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaTipoEmision($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaTipoHabitacion($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaTipoMetodoPago($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaTipoMoneda($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaTipoPuntoVenta($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaTiposFactura($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarParametricaUnidadMedida($sucursal, $puntoventa);print_r($res);
			$res = $service->sincronizarListaActividadesDocumentoSector($sucursal, $puntoventa);
			//print_r($res);
			$count++;
			if( $count == 80 )
			{
				$count = 0;
				sleep(10);
			}
		}
	}
	
	die;
}
function pruebaCufd()
{
	global $config, $sucursal;
	
	foreach([0,1] as $puntoventa)
	{
		$resCuis 	= obtenerCuis($puntoventa, $sucursal, true);
		
		for($i = 0; $i < 100; $i++)
		{
			$resCufd = obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo, true);
			print_r($resCufd);
		}
	}
	die;
}
function pruebasEmisionIndividual()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;
	
	foreach([1] as $puntoventa)
	{
		$resCuis 	= obtenerCuis($puntoventa, $sucursal, true);
		$resCufd	= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo, true);
		
		for($i = 0; $i < 125; $i++)
		{
			$factura = construirFactura($puntoventa, $sucursal, $config->modalidad, $documentoSector, $codigoActividad, $codigoProductoSin);
			$res = testFactura($sucursal, $puntoventa, $factura, $tipoFactura);
			print_r($res);
		}
		sleep(10);
	}
	die;
}
function pruebasEventos()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;
	$cufdAntiguo 	= 'BQUFlQztteEFBNzUQ1MDlGMkY5NkY=QmXDmkNkSktKWFVc2MDZGREJFNzg4O';
	$fechaInicio 	= '2023-09-09T09:31:17.000';
	$fechaFin		= '2023-09-09T09:32:00.000';
	foreach([0,1] as $puntoventa)
	{
	
		$pvfechaInicio 	= $fechaInicio;
		$pvfechaFin		= $fechaFin;
		$resCuis 	= obtenerCuis($puntoventa, $sucursal, true);
		$resCufd	= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo, true);
		$evento 	= obtenerListadoEventos($sucursal, $puntoventa);
		print_r($evento); 
		print_r($resCuis);
		print_r($resCufd);
		foreach($evento->RespuestaListaParametricas->listaCodigos as $evento)
		{
			for($i = 0; $i < 10; $i++)
			{

				$resEvento = registroEvento(
					$resCuis->RespuestaCuis->codigo, 
					$resCufd->RespuestaCufd->codigo, 
					$sucursal, 
					$puntoventa, 
					$evento, 
					$cufdAntiguo, 
					$pvfechaInicio, 
					$pvfechaFin
				);
				print_r($resEvento);
				$pvfechaInicio = date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
				$pvfechaFin = date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 2);
				var_dump($pvfechaInicio, $pvfechaFin);
			}
		}
	}
		
	die;
	//ultimo registro evento hora fecha => 2022-05-19T09:35:00.000
}
function pruebasAnulacion()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;
	
	foreach([0,1] as $puntoventa)
	{
		$resCuis 	= obtenerCuis($puntoventa, $sucursal, true);
		$resCufd	= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo, true);
		
		for($i = 0; $i < 130; $i++)
		{
			$factura = construirFactura($puntoventa, $sucursal, $config->modalidad, $documentoSector, $codigoActividad, $codigoProductoSin);
			print_r($factura);
			$res = testFactura($sucursal, $puntoventa, $factura, $tipoFactura);
			print_r($res);
			if($res->RespuestaServicioFacturacion->codigoEstado == 908 )
			{
				$resa = testAnular(1, $factura->cabecera->cuf, $sucursal, $puntoventa, $tipoFactura, SiatInvoice::TIPO_EMISION_ONLINE, $documentoSector);
				print_r($resa);
			}
			if( $i == 100 )
				sleep(10);
		}
		sleep(10);
	}
	die;
}
function pruebasPaquetes()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;
	
	$cufdAntiguo 	= 'QUE5Q1TDk2tBQQ==NDhFODRCNjYwMjY=QmXDiWZNU1hKV1VBNzIyODVFNEE5Mzky';
	$codigoControlAntiguo = '3F65A4A352D6D74';
	$fechaInicio 	= '2022-09-22T14:50:01.000';
	$fechaFin		= '2022-09-22T14:59:00.000';
	$cantidad 		= 2;
	$puntoventa 	= 0;
	$codigoEvento 	= 1;
	$cafc			= '10131358F292D';
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	//print_r($resCufd);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	for($i = 0; $i < 10; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
		test_log($resEvento);
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		$res = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 60);
		//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 10);
		test_log($pvfechaInicio);
		test_log($pvfechaFin);
	}
}
function pruebasFirma()
{
	global $config, $sucursal, $tipoFactura, $documentoSector, $codigoActividad, $codigoProductoSin;
	
	$puntoventa = 0;
	$resCuis = obtenerCuis($puntoventa, $sucursal);
	print_r($resCuis);
	$resCufd = obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	
	for($i = 0; $i < 115; $i++)
	{
		$factura = construirFactura($puntoventa, $sucursal, $config->modalidad, $documentoSector, $codigoActividad, $codigoProductoSin);
		$res = testFirma($sucursal, $puntoventa, $factura, $tipoFactura);
		print_r($res);
		//die;
	}
}
function pruebasEmisionMasiva()
{
	global $config, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;
	
	$fechaEmision		= date("Y-m-d\TH:i:s.v");
	$cantidad 			= 0;
	$codigoSucursal 	= 0;
	$codigoPuntoVenta 	= 1;
	$cafc				= null; //'1011E37BF100D';
	
	for($i = 0; $i < 20; $i++)
	{
		$facturas = construirFacturas($codigoSucursal, $codigoPuntoVenta, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $fechaEmision);
		
		$fechaEmision = date("Y-m-d\TH:i:s.v", strtotime($fechaEmision) + 5);
		$res = testMasiva($codigoSucursal, $codigoPuntoVenta, $documentoSector, $facturas, $tipoFactura);
		print_r($res);	
		
	}
	
}

function pruebasEmisionMasiva1()
{
	global $config, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;
	
	$fechaEmision		= date("Y-m-d\TH:i:s.v");
	$cantidad 			= 2;
	$codigoSucursal 	= 0;
	$codigoPuntoVenta 	= 0;
	$cafc				= '1011E37BF100D';
	
	for($i = 0; $i < 10; $i++)
	{
		$facturas = construirFacturas($codigoSucursal, $codigoPuntoVenta, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $fechaEmision);
		
		$fechaEmision = date("Y-m-d\TH:i:s.v", strtotime($fechaEmision) + 5);
		$res = testMasiva($codigoSucursal, $codigoPuntoVenta, $documentoSector, $facturas, $tipoFactura);
		//print_r($res);
		$codigoRecepcion = $res->RespuestaServicioFacturacion->codigoRecepcion;
		//print_r($codigoRecepcion);
		$res1 = testRecepcionMasiva($codigoSucursal, $codigoPuntoVenta, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//print_r($res1);
		
	}
	
}


function pruebasPaquetes1_1()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T09:00:01.000';
	$fechaFin		= '2023-09-11T09:29:59.000';

	$cantidad 		= 2;
	$puntoventa 	= 0;
	$codigoEvento   = 1;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	//$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 50; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		//test_log($pvfechaInicio);
		//test_log($pvfechaFin);
		
	}

}
function pruebasPaquetes1_2()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T09:30:01.000';
	$fechaFin		= '2023-09-11T09:59:59.000';

	$cantidad 		= 2;
	$puntoventa 	= 0;
	$codigoEvento   = 2;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 10; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		//$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		//test_log($pvfechaInicio);
		//test_log($pvfechaFin);
		
	}

}
function pruebasPaquetes1_3()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T10:00:01.000';
	$fechaFin		= '2023-09-11T10:29:59.000';

	$cantidad 		= 2;
	$puntoventa 	= 0;
	$codigoEvento   = 3;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 10; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		//test_log($pvfechaInicio);
		//test_log($pvfechaFin);
		
	}

}
function pruebasPaquetes1_4()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T10:30:01.000';
	$fechaFin		= '2023-09-11T10:59:59.000';

	$cantidad 		= 2;
	$puntoventa 	= 0;
	$codigoEvento   = 4;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 100; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		//test_log($pvfechaInicio);
		//test_log($pvfechaFin);
		
	}

}
// funciona para codigos cafc
function pruebasPaquetes1_5()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-10T13:00:01.000';
	$fechaFin		= '2023-09-10T13:59:59.000';

	$cantidad 		= 2;
	$puntoventa 	= 0;
	foreach([5,6,7] as $codigoEvento)
	{
		$cafc			= '134C781B6F72E';
		//$cafc			= null;
		$resEvento 		= null;
		$resCuis 		= obtenerCuis($puntoventa, $sucursal);
		//print_r($resCuis);
		$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
		$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
		$evento or die('Evento no encontrado');
		
		$pvfechaInicio 	= $fechaInicio;
		$pvfechaFin		= $fechaFin;
		
		for($i = 0; $i < 10; $i++)
		{
			$resEvento 		= $resEvento ?: registroEvento(
				$resCuis->RespuestaCuis->codigo,
				$resCufd->RespuestaCufd->codigo,
				$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
			);
		
			$facturas 		= construirFacturas(
				$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
			);
			
			$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
			print_r($res);
			$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
			//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
			//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
			//test_log($pvfechaInicio);
			//test_log($pvfechaFin);
			
		}
	}
}

function pruebasPaquetes2_1()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T11:00:01.000';
	$fechaFin		= '2023-09-11T11:29:59.000';

	$cantidad 		= 500;
	$puntoventa 	= 1;
	$codigoEvento   = 1;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 10; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		test_log($pvfechaInicio);
		test_log($pvfechaFin);
		
	}

}
function pruebasPaquetes2_2()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T11:30:01.000';
	$fechaFin		= '2023-09-11T11:59:59.000';

	$cantidad 		= 500;
	$puntoventa 	= 1;
	$codigoEvento   = 2;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 10; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		test_log($pvfechaInicio);
		test_log($pvfechaFin);
		
	}

}
function pruebasPaquetes2_3()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T12:00:01.000';
	$fechaFin		= '2023-09-11T12:29:59.000';

	$cantidad 		= 500;
	$puntoventa 	= 1;
	$codigoEvento   = 3;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 10; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		test_log($pvfechaInicio);
		test_log($pvfechaFin);
		
	}

}
function pruebasPaquetes2_4()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T12:30:01.000';
	$fechaFin		= '2023-09-11T12:59:59.000';

	$cantidad 		= 500;
	$puntoventa 	= 1;
	$codigoEvento   = 4;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 10; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		test_log($pvfechaInicio);
		test_log($pvfechaFin);
		
	}

}
function pruebasPaquetes2_5()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-11T13:00:01.000';
	$fechaFin		= '2023-09-11T13:59:59.000';

	$cantidad 		= 500;
	$puntoventa 	= 1;
	foreach([5,6,7] as $codigoEvento)
	{
		$cafc			= '134C781B6F72E';
		//$cafc			= null;
		$resEvento 		= null;
		$resCuis 		= obtenerCuis($puntoventa, $sucursal);
		//print_r($resCuis);
		$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
		$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
		$evento or die('Evento no encontrado');
		
		$pvfechaInicio 	= $fechaInicio;
		$pvfechaFin		= $fechaFin;
		
		for($i = 0; $i < 10; $i++)
		{
			$resEvento 		= $resEvento ?: registroEvento(
				$resCuis->RespuestaCuis->codigo,
				$resCufd->RespuestaCufd->codigo,
				$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
			);
		
			$facturas 		= construirFacturas(
				$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
			);
			
			$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
			print_r($res);
			$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
			//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
			//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
			test_log($pvfechaInicio);
			test_log($pvfechaFin);
			
		}
	}
}

function pruebasPaquetes3_1()
{
	global $config, $sucursal, $documentoSector, $codigoActividad, $codigoProductoSin, $tipoFactura;

	//2022-09-23T16:33:40.000
	//fecha emision
	
	$cufdAntiguo 	= 'BQWVDO214QUE=NzUQ1MDlGMkY5NkY=QlU9RW5USkpYVUFc2MDZGREJFNzg4O';
	$codigoControlAntiguo = '6028916067EFD74';
	$fechaInicio 	= '2023-09-09T14:20:01.000';
	$fechaFin		= '2023-09-09T14:29:59.000';

	$cantidad 		= 2;
	$puntoventa 	= 1;
	$codigoEvento   = 1;

	$cafc			= null;
	$resEvento 		= null;
	$resCuis 		= obtenerCuis($puntoventa, $sucursal);
	//print_r($resCuis);
	print_r($codigoEvento);
	$resCufd		= obtenerCufd($puntoventa, $sucursal, $resCuis->RespuestaCuis->codigo);
	$evento 		= obtenerListadoEventos($sucursal, $puntoventa, $codigoEvento);
	//$evento or die('Evento no encontrado');
	
	$pvfechaInicio 	= $fechaInicio;
	$pvfechaFin		= $fechaFin;
	
	for($i = 0; $i < 30; $i++)
	{
		$resEvento 		= $resEvento ?: registroEvento(
			$resCuis->RespuestaCuis->codigo,
			$resCufd->RespuestaCufd->codigo,
			$sucursal, $puntoventa, $evento, $cufdAntiguo, $fechaInicio, $fechaFin
		);
	
		$facturas 		= construirFacturas(
			$sucursal, $puntoventa, $cantidad, $documentoSector, $codigoActividad, $codigoProductoSin, $pvfechaInicio, $cufdAntiguo
		);
		
		$res = testPaquetes($sucursal, $puntoventa, $facturas, $codigoControlAntiguo, $tipoFactura, $resEvento->RespuestaListaEventos, $cafc);
		print_r($res);
		$res1 = testRecepcionPaquete($sucursal, $puntoventa, $documentoSector, $tipoFactura, $res->RespuestaServicioFacturacion->codigoRecepcion);
		//$pvfechaInicio 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaFin) + 1);
		//$pvfechaFin 	= date('Y-m-d\TH:i:s.v', strtotime($pvfechaInicio) + 1);
		//test_log($pvfechaInicio);
		//test_log($pvfechaFin);
		
	}

}

//$resCuis 		= obtenerCuis(1, 0);
//$resCuis 		= obtenerCuis(0, 0);
//$resPv = registroPuntoVenta(0,'punto Venta 1');
//pruebasFirma();
//pruebasEmisionMasiva1();

//$res = testCierreOperacionesSistema($sucursal, $puntoventa);
//print_r($res);
//pruebasCatalogos();
//$res = obtenerCuis($puntoventa, $sucursal);
//print_r($res);
//pruebasCatalogos();
//pruebaCufd();
//pruebasEmisionIndividual();
//pruebasEventos();
//pruebasAnulacion();
//pruebasFirma();
//pruebasEmisionMasiva();
//pruebasEmisionIndividual();
//pruebasEmisionMasiva();



//pruebasPaquetes1_1();
//pruebasPaquetes1_2();
//pruebasPaquetes1_3();
//pruebasPaquetes1_4();
//pruebasPaquetes1_5();



//pruebasPaquetes2_1();
//pruebasPaquetes2_2();
//pruebasPaquetes2_3();
//pruebasPaquetes2_4();
//pruebasPaquetes2_5();
pruebasPaquetes3_1();




