<?php
date_default_timezone_set("America/La_Paz");
header('Content-Type: text/html; charset=UTF-8');
include "../api.php";
try {

	$body = Response::getBody();
	/* ---------------------------------------------------- */
	$DB = new DB();
	$DB->conectar();
	$DB->begin();
	/* ---------------------------------------------------- */

	$fechareg = date("Y-m-d H:i:s");
	$newfecha = date("Y-m-d");
	$newhora = date("G:i:s");
	$funcion = $body["funcion"];

	switch ($funcion) {
		/* ---------------------  Tipos Producto  ---------------------------- */
		case 'configuracionPagina':
			$c00 = "SELECT * from configuracion_pagina where id_configuracion='1'";
			$configuracion = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["configuracion"] = $configuracion;
			break;
			/* ---------------------  Tipos Producto  ---------------------------- */
		case 'listarTiposProducto':
			$c00 = "SELECT * from tipo_producto";
			$tipos = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["tipos"] = $tipos;
			break;

		case 'newTipoProducto':
			$tipo = $body["tipo"];
			$codigo = $body["codigo"];

			$c00 = "INSERT INTO tipo_producto values(default, '" . $codigo . "', '" . $tipo . "');";
			$inserttipo = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $inserttipo;
			break;

		case 'editTipoProducto':
			$id = $body["idtipo"];
			$c00 = "SELECT * from tipo_producto where id_tipo = '" . $id . "'";
			$tipo = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["tipo"] = $tipo;
			break;

		case 'updTipoProducto':
			$id = $body["idtipo"];
			$tipo = $body["tipo"];
			$codigo = $body["codigo"];

			$c00 = "UPDATE tipo_producto SET tipo_producto = '" . $tipo . "', codigo = '" . $codigo . "' WHERE id_tipo = '" . $id . "';";
			$updtipo = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updtipo;
			break;

		case 'deleteTipoProducto':
			$id = $body["id"];
			$c00 = "DELETE FROM tipo_producto WHERE id_tipo = '" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;

			/* ---------------------  Complementos  ---------------------------- */
		case 'listarComplementos':
			$c00 = "SELECT * FROM complementos";
			$complementos = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["complementos"] = $complementos;
			break;

		case 'newComplemento':
			$nombre = $body["nombre"];
			$tipoSeleccion = $body["tipoSeleccion"];
			$seleccionMaxima = $body["seleccionMaxima"];

			$c00 = "INSERT INTO complementos VALUES (default,'" . $nombre . "', '" . $tipoSeleccion . "','0','0','0','" . $seleccionMaxima . "','[]');";
			$insertcomplemento = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insertcomplemento;
			break;

		case 'editComplemento':
			$id = $body["idComplemento"];
			$c00 = "SELECT * FROM complementos WHERE ID_COMPLEMENTO = '" . $id . "'";
			$complemento = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["complemento"] = $complemento;
			break;

		case 'updComplemento':
			$id = $body["idComplemento"];
			$nombre = $body["nombre"];
			$tipoSeleccion = $body["tipoSeleccion"];
			$seleccionMaxima = $body["seleccionMaxima"];

			$c00 = "UPDATE complementos SET NOMBRE = '" . $nombre . "',TIPO_SELECCION = " . $tipoSeleccion . ",SELECCION_MAXIMA = " . $seleccionMaxima . " WHERE ID_COMPLEMENTO = '" . $id . "';";
			$updcomplemento = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updcomplemento;
			break;

		case 'deleteComplemento':
			$id = $body["id"];
			$c00 = "DELETE FROM complementos WHERE ID_COMPLEMENTO = '" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;

		case 'cambiarEstadoComplemento':
			$id = $body["idComplemento"];
			$num = $body["num"];
			$valor = $body["valor"];

			$nvalor = ($valor == '1') ? '0' : '1';

			if ($num == '1') {
				$c00 = "UPDATE complementos SET habilitar_cantidades = '" . $nvalor . "' WHERE id_complemento = '" . $id . "'";
			}
			if ($num == '2') {
				$c00 = "UPDATE complementos SET afectar_cantidades = '" . $nvalor . "' WHERE id_complemento = '" . $id . "'";
			}
			if ($num == '3') {
				$c00 = "UPDATE complementos SET campo_requerido = '" . $nvalor . "' WHERE id_complemento = '" . $id . "'";
			}
			$updComplemento = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $updComplemento;
			break;
		case 'deleteDatos':
			$id = $body["idcomplemento"];
			$idd = $body["iddato"];

			$c00 = "SELECT * FROM complementos WHERE ID_COMPLEMENTO = '" . $id . "'";
			$complemento = $DB->consultaOne($c00);

			$array = json_decode($complemento->DATOS, true);

			$arrayFiltrado = [];
			foreach ($array as $item) {
				if ((int)$item['id'] !== (int)$idd) {
					$arrayFiltrado[] = $item;
				}
			}
			$arrayFiltrado = array_values($arrayFiltrado);

			$jsonFinal = json_encode($arrayFiltrado);

			$updateDatos = "UPDATE complementos SET DATOS = '" . $jsonFinal . "' WHERE ID_COMPLEMENTO = '" . $id . "'";

			$update = $DB->consulta($updateDatos);

			$resultado = array();
			$resultado["ok"] = $update;

			break;
		case 'updateDatos':
			$id = $body["idcomplemento"];
			$idd = $body["iddato"];
			$nombre = $body["nombre"];
			$precio = $body["precio"];

			$c00 = "SELECT * FROM complementos WHERE ID_COMPLEMENTO = '" . $id . "'";
			$complemento = $DB->consultaOne($c00);

			$array = json_decode($complemento->DATOS, true);

			foreach ($array as &$item) {
				if ((int)$item['id'] === (int)$idd) {
					$item['nombre'] = $nombre;
					$item['precio'] = $precio;
					break;
				}
			}

			$jsonFinal = json_encode($array);

			$updateDatos = "UPDATE complementos SET DATOS = '" . $jsonFinal . "' WHERE ID_COMPLEMENTO = '" . $id . "'";
			$update = $DB->consulta($updateDatos);

			$resultado = array();
			$resultado["ok"] = $update;
			break;
		case 'newDatos':
			$id = $body["idcomplemento"];
			$nombre = $body["nombre"];
			$precio = $body["precio"];

			$c00 = "SELECT * FROM complementos WHERE ID_COMPLEMENTO = '" . $id . "'";
			$complemento = $DB->consultaOne($c00);

			$array = json_decode($complemento->DATOS, true);

			$newId = count($array) > 0 ? max(array_column($array, 'id')) + 1 : 1;

			$nuevoDato = array(
				"id" => $newId,
				"nombre" => $nombre,
				"precio" => $precio
			);

			$array[] = $nuevoDato;

			$jsonFinal = json_encode($array);

			$updateDatos = "UPDATE complementos SET DATOS = '" . $jsonFinal . "' WHERE ID_COMPLEMENTO = '" . $id . "'";
			$update = $DB->consulta($updateDatos);

			// Preparas la respuesta
			$resultado = array();
			$resultado["ok"] = $update;
			$resultado["json"] = $jsonFinal;
			break;
			/* ---------------------  Categorias  ---------------------------- */
		case 'listarCategorias':
			$c00 = "SELECT * from categoria";
			$categorias = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["categorias"] = $categorias;
			break;

		case 'listarCategoriaProductos':
			$c00 = "SELECT c.CATEGORIA, c.ID_CATEGORIA, c.IMAGEN, c.CODIGO FROM producto p, categoria c where p.CATEGORIA = c.CATEGORIA GROUP BY c.ID_CATEGORIA";
			$categorias = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["categorias"] = $categorias;
			break;

		case 'listarCategoriaInventario':
			$c00 = "SELECT c.CATEGORIA, c.ID_CATEGORIA, c.IMAGEN, c.CODIGO FROM categoria c INNER JOIN producto p ON p.CATEGORIA = c.CATEGORIA INNER JOIN inventario i ON p.ID_PRODUCTO = i.ID_PRODUCTO WHERE i.CANTIDAD > 0  GROUP BY c.ID_CATEGORIA";
						
			$categorias = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["categorias"] = $categorias;
			break;

		case 'newCategoria':
			$categoria = $body["categoria"];
			$codigo = $body["codigo"];

			$c00 = " INSERT INTO categoria values(default,'" . $codigo . "','" . $categoria . "','noimage.png');";
			$insertcategoria = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insertcategoria;
			break;
		case 'editCategoria':
			$id = $body["idcategoria"];
			$c00 = "SELECT * from categoria where id_categoria ='" . $id . "'";
			$categoria = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["categoria"] = $categoria;
			break;
		case 'updCategoria':
			$id = $body["idcategoria"];
			$categoria = $body["categoria"];
			$codigo = $body["codigo"];

			$c00 = "UPDATE categoria set categoria='" . $categoria . "',  codigo='" . $codigo . "' WHERE id_categoria = '" . $id . "';";
			$updcategoria = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updcategoria;
			break;
		case 'deleteCategoria':
			$id = $body["id"];
			$c00 = " delete from categoria where id_categoria ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;

			/* ---------------------  Marcas  ---------------------------- */
		case 'listarMarcas':
			$c00 = "SELECT * from marca";
			$marcas = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["marcas"] = $marcas;
			break;
		case 'newMarca':
			$marca = $body["marca"];
			$codigo = $body["codigo"];

			$c00 = " INSERT INTO marca values(default,'" . $codigo . "','" . $marca . "');";
			$insertmarca = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insertmarca;
			break;
		case 'editMarca':
			$id = $body["idmarca"];
			$c00 = "SELECT * from marca where id_marca ='" . $id . "'";
			$marca = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["marca"] = $marca;
			break;
		case 'updMarca':
			$id = $body["idmarca"];
			$marca = $body["marca"];
			$codigo = $body["codigo"];

			$c00 = "UPDATE marca set marca='" . $marca . "', codigo='" . $codigo . "' WHERE id_marca = '" . $id . "';";
			$updmarca = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updmarca;
			break;
		case 'deleteMarca':
			$id = $body["id"];
			$c00 = " delete from marca where id_marca ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
			/* ---------------------  Tipos Pago  ---------------------------- */
		case 'listarTiposPago':
			$c00 = "SELECT * from tipo_pago";
			$tipos = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["tipos"] = $tipos;
			break;
		case 'newTipoPago':
			$tipo = $body["tipo"];
			$codigo = $body["codigo"];

			$c00 = " INSERT INTO tipo_pago values(default,'" . $codigo . "','" . $tipo . "');";
			$inserttipo = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $inserttipo;
			break;
		case 'editTipoPago':
			$id = $body["idtipo"];
			$c00 = "SELECT * from tipo_pago where id_tipo ='" . $id . "'";
			$tipo = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["tipo"] = $tipo;
			break;
		case 'updTipoPago':
			$id = $body["idtipo"];
			$tipo = $body["tipo"];
			$codigo = $body["codigo"];

			$c00 = "UPDATE tipo_pago set tipo_pago='" . $tipo . "', codigo='" . $codigo . "' WHERE id_tipo = '" . $id . "';";
			$updtipo = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updtipo;
			break;
		case 'deleteTipoPago':
			$id = $body["id"];
			$c00 = " delete from tipo_pago where id_tipo ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
			/* ---------------------  Tipos Transaccion  ---------------------------- */
		case 'listarTiposTransaccion':
			$c00 = "SELECT * from tipo_transaccion";
			$tipos = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["tipos"] = $tipos;
			break;
		case 'newTipoTransaccion':
			$tipo = $body["tipo"];
			$codigo = $body["codigo"];
			$transaccion = $body["transaccion"];

			$c00 = " INSERT INTO tipo_transaccion values(default,'" . $codigo . "','" . $transaccion . "','" . $tipo . "');";
			$inserttipo = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $inserttipo;
			break;
		case 'editTipoTransaccion':
			$id = $body["idtipo"];
			$c00 = "SELECT * from tipo_transaccion where id_tipo ='" . $id . "'";
			$tipo = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["tipo"] = $tipo;
			break;
		case 'updTipoTransaccion':
			$id = $body["idtipo"];
			$tipo = $body["tipo"];
			$codigo = $body["codigo"];
			$transaccion = $body["transaccion"];

			$c00 = "UPDATE tipo_transaccion set tipo_transaccion ='" . $tipo . "', codigo='" . $codigo . "', transaccion='" . $transaccion . "' WHERE id_tipo = '" . $id . "';";
			$updtipo = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updtipo;
			break;
		case 'deleteTipoTransaccion':
			$id = $body["id"];
			$c00 = " delete from tipo_transaccion where id_tipo ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
			/* ---------------------  Unidad Medida  ---------------------------- */
		case 'listarUnidadMedida':
			$c00 = "SELECT * from unidad_medida";
			$unids = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["unids"] = $unids;
			break;
		case 'newUnidadMedida':
			$medida = $body["medida"];
			$codigo = $body["codigo"];

			$c00 = " INSERT INTO unidad_medida values(default,'" . $codigo . "','" . $medida . "');";
			$insert = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insert;
			break;
		case 'editUnidadMedida':
			$id = $body["idunidad"];
			$c00 = "SELECT * from unidad_medida where id_unidad ='" . $id . "'";
			$unidad = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["unidad"] = $unidad;
			break;
		case 'updUnidadMedida':
			$id = $body["idunidad"];
			$medida = $body["medida"];
			$codigo = $body["codigo"];

			$c00 = "UPDATE unidad_medida set medida ='" . $medida . "', codigo='" . $codigo . "' WHERE id_unidad = '" . $id . "';";
			$updunidad = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updunidad;
			break;
		case 'deleteTipoEgreso':
			$id = $body["id"];
			$c00 = " delete from unidad_medida where id_unidad ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
			/* ---------------------  Clientes  ---------------------------- */
		case 'listarClientes':
			$c00 = "SELECT * from cliente";
			$clientes = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["clientes"] = $clientes;
			break;
		case 'newCliente':
			$nit = $body["nitci"];
			$rzs = $body["rzs"];
			$telefono = $body["telefono"];
			$mail = $body["email"];
			$cmp = $body["cmp"];

			$c00 = "INSERT INTO cliente  VALUES (default, '" . $rzs . "', '" . $nit . "', '".$telefono."',  '" . $mail . "', '" . $cmp . "','ACTIVO');";
			$insert = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insert;
			break;
		case 'editCliente':
			$id = $body["idcliente"];
			$c00 = "SELECT * from cliente where id ='" . $id . "'";
			$cliente = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["cliente"] = $cliente;
			break;
		case 'updCliente':
			$id = $body["idcliente"];
			$nit = $body["nitci"];
			$telefono = $body["telefono"];
			$rzs = $body["rzs"];
			$mail = $body["email"];
			$cmp = $body["cmp"];

			$c00 = "UPDATE cliente  SET nitCi = '" . $nit . "', razonSocial = '" . $rzs . "', email = '" . $mail . "' , complemento = '" . $cmp . "', telefono = '".$telefono."' WHERE id='" . $id . "' ";
			$update = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $update;
			break;
		case 'cambiarEstadoCliente':
			$idcliente = $body["idcliente"];
			$estado = $body["estado"];
			if ($estado == 'A') {
				$nestado = 'INACTIVO';
			} else {
				$nestado = 'ACTIVO';
			}

			$c00 = "UPDATE cliente set estado = '" . $nestado . "' WHERE id = '" . $idcliente . "';";
			$updCliente = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updCliente;
			break;
			/* ---------------------  Proveedores  ---------------------------- */
		case 'listarProveedores':
			$c00 = "SELECT * from proveedor";
			$proveedores = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["proveedores"] = $proveedores;
			break;
		case 'newProveedor':
			$proveedor = $body["proveedor"];
			$telefono = $body["telefono"];

			$c00 = " INSERT INTO proveedor values(default,'" . $proveedor . "','" . $telefono . "','ACTIVO');";
			$insert = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insert;
			break;
		case 'editProveedor':
			$id = $body["idproveedor"];
			$c00 = "SELECT * from proveedor where id_proveedor ='" . $id . "'";
			$proveedor = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["proveedor"] = $proveedor;
			break;
		case 'updProveedor':
			$id = $body["idproveedor"];
			$proveedor = $body["proveedor"];
			$telefono = $body["telefono"];

			$c00 = "UPDATE proveedor set razon_social ='" . $proveedor . "', telefono='" . $telefono . "' WHERE id_proveedor = '" . $id . "';";
			$updProveedor = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updProveedor;
			break;
		case 'cambiarEstadoProveedor':
			$idproveedor = $body["idproveedor"];
			$estado = $body["estado"];
			if ($estado == 'A') {
				$nestado = 'INACTIVO';
			} else {
				$nestado = 'ACTIVO';
			}

			$c00 = "UPDATE proveedor set estado = '" . $nestado . "' WHERE id_proveedor = '" . $idproveedor . "';";
			$updProveedor = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updProveedor;
			break;
			/* ---------------------  Vendedores  ---------------------------- */

		case 'listarVendedores':
			$idsucursal = $body["sucursal"];
			$c00 = "SELECT * from vendedor v, sucursal s where v.id_sucursal = s.id_sucursal and s.id_sucursal='" . $idsucursal . "'";
			$vendedores = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["vendedores"] = $vendedores;
			break;

		case 'newVendedor':
			$vendedor = $body["vendedor"];
			$telefono = $body["telefono"];
			$idsucursal = $body["idsucursal"];

			$c00 = "INSERT INTO vendedor VALUES (DEFAULT, '" . $idsucursal . "', '" . $vendedor . "', '" . $telefono . "', 'ACTIVO');";
			$insert = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insert;
			break;

		case 'editVendedor':
			$id = $body["idvendedor"];
			$c00 = "SELECT * from vendedor WHERE ID_VENDEDOR = '" . $id . "'";
			$vendedor = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["vendedor"] = $vendedor;
			break;

		case 'updVendedor':
			$id = $body["idvendedor"];
			$vendedor = $body["vendedor"];
			$telefono = $body["telefono"];
			$idsucursal = $body["sucursal"];

			$c00 = "UPDATE vendedor SET ID_SUCURSAL = '" . $idsucursal . "',VENDEDOR = '" . $vendedor . "', TELEFONO = '" . $telefono . "' WHERE ID_VENDEDOR = '" . $id . "';";
			$updVendedor = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updVendedor;
			break;

		case 'cambiarEstadoVendedor':
			$idvendedor = $body["idvendedor"];
			$estado = $body["estado"];
			$nestado = ($estado == 'A') ? 'INACTIVO' : 'ACTIVO';

			$c00 = "UPDATE vendedor SET ESTADO = '" . $nestado . "' WHERE ID_VENDEDOR = '" . $idvendedor . "';";
			$updVendedor = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updVendedor;
			break;

			/* --------------------- Ambientes ---------------------------- */
		case 'listarAmbientes':
			$idsucursal = $body["idsucursal"];
			$mlibre = 0;
			$mocupado = 0;
			$ambientes = array();
			$c00 = "SELECT * FROM ambiente WHERE id_sucursal = '" . $idsucursal . "' ORDER BY id_ambiente";
			$amb = $DB->consultaAll($c00);
			for ($j = 0; $j < $amb["size"]; $j++) {
				$c01 = "SELECT ID_MESA as ID, concat('MESA_',CODIGO) as ITEM, ESTADO, CAPACIDAD, MESERO from mesa where id_ambiente='" . $amb["data"][$j]->ID_AMBIENTE . "' ORDER BY id_mesa";
				$mesas = $DB->consultaAll($c01);

				$c02 = "SELECT count(*) as cantidad from mesa where estado ='OCUPADO' and id_ambiente='" . $amb["data"][$j]->ID_AMBIENTE . "'";
				$ocu = $DB->consultaOne($c02);
				$mocupado = $ocu->cantidad;

				$c03 = "SELECT count(*) as cantidad from mesa where estado ='LIBRE' and id_ambiente='" . $amb["data"][$j]->ID_AMBIENTE . "'";
				$lib = $DB->consultaOne($c03);
				$mlibre = $lib->cantidad;

				$detItems = new stdClass();
				$detItems->ID_AMBIENTE = $amb["data"][$j]->ID_AMBIENTE;
				$detItems->CODIGO = $amb["data"][$j]->CODIGO;
				$detItems->AMBIENTE = $amb["data"][$j]->AMBIENTE;
				$detItems->DATOS = $mesas;
				$detItems->NMESAS = $mesas["size"];
				$detItems->MLIBRE = $mlibre;
				$detItems->MOCUPADO = $mocupado;
				array_push($ambientes, $detItems);
			}

			$resultado = array();
			$resultado["ambientes"] = $ambientes;
			break;
		case 'newAmbiente':
			$idsucursal = $body["idsucursal"];
			$ambiente = $body["ambiente"];
			$codigo = $body["codigo"];

			$c00 = " INSERT INTO ambiente values(default,'" . $idsucursal . "','" . $codigo . "','" . $ambiente . "')";
			$insert = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insert;
			break;
		case 'editAmbiente':
			$id = $body["idambiente"];
			$c00 = "SELECT * from ambiente where id_ambiente ='" . $id . "'";
			$ambiente = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["ambiente"] = $ambiente;
			break;
		case 'updAmbiente':
			$id = $body["idambiente"];
			$ambiente = $body["ambiente"];
			$codigo = $body["codigo"];

			$c00 = "UPDATE ambiente set ambiente='" . $ambiente . "',  codigo='" . $codigo . "' WHERE id_ambiente = '" . $id . "'";
			$update = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $update;
			break;
		case 'deleteAmbiente':
			$id = $body["id"];
			$c00 = " delete from ambiente where id_ambiente ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
			/* --------------------- Mesas ---------------------------- */
		case 'newMesa':
			$idambiente = $body["idambiente"];
			$numero = $body["numero"];
			$capacidad = $body["capacidad"];
			$codigo = $body["codigo"];

			$c00 = " INSERT INTO mesa values(default,'" . $idambiente . "','" . $codigo . "','" . $numero . "','" . $capacidad . "','','LIBRE')";
			$insert = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $insert;
			break;
		case 'editMesa':
			$id = $body["idmesa"];
			$c00 = "SELECT * from mesa where id_mesa ='" . $id . "'";
			$mesa = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["mesa"] = $mesa;
			break;
		case 'updMesa':
			$id = $body["idmesa"];
			$numero = $body["numero"];
			$capacidad = $body["capacidad"];
			$codigo = $body["codigo"];

			$c00 = "UPDATE mesa set nro_mesa ='" . $numero . "',  codigo='" . $codigo . "' , capacidad = '" . $capacidad . "' WHERE id_mesa = '" . $id . "'";
			$update = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $update;
			break;
	}

	/* ---------------------------------------------------- */
	$DB->commit();
	$DB->close();
	Response::sendOne($resultado);
} catch (Exception $e) {

	$DB->rollback();
	$DB->close();
	Response::sendError($e);
}
