<?php
set_time_limit(0);

//error_reporting(0);
date_default_timezone_set('America/La_Paz');
session_start();
require_once  '../Siat/autoload.php';
require_once '../Siat/test/test-functions.php';
include "../../controlador/utils.php";
include "../api.php";

require '../librerias/phpMailer/PHPMailer.php';
require '../librerias/phpMailer/SMTP.php';
require '../librerias/phpMailer/Exception.php';

require '../librerias/fpdf/fpdf.php';
require '../librerias/phpqrcode/qrlib.php';
header('Content-Type: text/html; charset=UTF-8');


use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

use api\Siat\DocumentTypes;
use api\Siat\SiatConfig;
use api\Siat\Invoices\SiatInvoice;
use api\Siat\Services\ServicioSiat;
use api\Siat\Services\ServicioFacturacionSincronizacion;


try {

	$body = Response::getBody();
	/* ---------------------------------------------------- */
	$DB = new DB();
	$DB->conectar();
	$DB->begin();
	/* ---------------------------------------------------- */
	$fechareg = date("Y-m-d H:i:s");
	$newfecha = date("Y-m-d");
	$newhora = date("G:i:s");
	$funcion = $body["funcion"];

	$consulta = "select * from siat_configuracion where id = '1' ";
	$siat = $DB->consultaOne($consulta);

	/* ---------------------------------------------------- */

	$config = new SiatConfig([
		'nombreSistema' => $siat->nombreSistema,
		'codigoSistema' => $siat->codigoSistema,
		'nit'           => $siat->nitCi,
		'razonSocial'   => $siat->razonSocial,
		'modalidad'     => $siat->modalidad,
		'ambiente'      => $siat->ambiente,
		'tokenDelegado'	=> $siat->token,
		'pubCert'		=> MOD_SIAT_DIR . SB_DS . 'certs' . SB_DS . $siat->pubCert,
		'privCert'		=> MOD_SIAT_DIR . SB_DS . 'certs' . SB_DS . $siat->privCert,
	]);

	switch ($funcion) {
		case 'listarFacturas':
			$facturas = array();
			$idp = $body["ids"];
			$fechaini = $body["fechainicio"];
			$fechafin = $body["fechafin"];
			$c00 = "SELECT * FROM siat_factura  WHERE idPuntoVenta = '" . $idp . "' AND fecha >= '" . $fechaini . "' AND fecha <= '" . $fechafin . "' GROUP BY id ORDER BY id DESC; ";
			$fact = $DB->consultaAll($c00);
			for ($i = 0; $i < $fact["size"]; $i++) {

				$c01 = "SELECT * from cliente where nitCi = '" . $fact["data"][$i]->numeroDocumento . "'";
				$cliente = $DB->consultaOne($c01);

				$detItems = new stdClass();
				$detItems->id = $fact["data"][$i]->id;
				$detItems->tipoEmision = $fact["data"][$i]->tipoEmision;
				$detItems->nitEmisor = $fact["data"][$i]->nitEmisor;
				$detItems->fecha = $fact["data"][$i]->fecha;
				$detItems->hora = $fact["data"][$i]->hora;
				$detItems->numeroFactura = $fact["data"][$i]->numeroFactura;
				$detItems->numeroDocumento = $fact["data"][$i]->numeroDocumento;
				$detItems->nombreRazonSocial = $fact["data"][$i]->nombreRazonSocial;
				$detItems->montoTotalSujetoIva = $fact["data"][$i]->montoTotalSujetoIva;
				$detItems->descuentoAdicional = $fact["data"][$i]->descuentoAdicional;
				$detItems->montoGiftCard = 0;
				$detItems->estado = $fact["data"][$i]->estado;
				$detItems->cuf = $fact["data"][$i]->cuf;
				$detItems->email = $cliente->email;

				array_push($facturas, $detItems);
			}

			$resultado = array();
			$resultado["facturas"] = $facturas;
			break;
		case 'prepararFactura':
			$detalle = array();
			$idv = $body["idventa"];

			$c00 = "select * from ventas where id_venta = '" . $idv . "' ";
			$venta = $DB->consultaOne($c00);

			$c01 = "select * from cliente where id ='" . $venta->ID_CLIENTE . "' ";
			$cliente = $DB->consultaOne($c01);

			$c02 = "SELECT sum(vd.cantidad) as CANTIDAD, vd.precio_venta as PRECIO_UNITARIO, p.ID_PRODUCTO, p.NOMBRE, p.CODIGO, p.CODIGO_BARRAS, p.CODIGO_SIN, p.CODIGO_ACTIVIDAD , p.UNIDAD_MEDIDA from venta_detalle vd , producto p where p.id_producto = vd.id_producto and vd.id_venta ='" . $idv . "' group by vd.id_producto; ";
			$dets = $DB->consultaAll($c02);

			for ($i = 0; $i < $dets["size"]; $i++) {
				$det = $dets["data"][$i];
				$itemdet = new stdClass();
				$itemdet->actividad			= $det->CODIGO_ACTIVIDAD;
				$itemdet->codigosin			= $det->CODIGO_SIN;
				$itemdet->codigop			= $det->CODIGO_BARRAS;
				$itemdet->producto			= $det->NOMBRE;
				$itemdet->idproducto		= $det->ID_PRODUCTO;
				$itemdet->preciounitario	= $det->PRECIO_UNITARIO;
				$itemdet->cantidad			= $det->CANTIDAD;
				$itemdet->unidadmedida		= $det->UNIDAD_MEDIDA;
				$itemdet->preciobs 			= (float) $det->PRECIO_UNITARIO * (float) $det->CANTIDAD;
				$itemdet->descuento			= 0;
				array_push($detalle, $itemdet);
			}
			$resultado = array();
			$resultado["venta"] = $venta;
			$resultado["detalle"] = $detalle;
			$resultado["cliente"] = $cliente;
			break;
		case 'procesarFactura':
			$resultado = array();
			$detalle = $body["detalle"];
			$maestro = $body["maestro"];
			$idven = $body["idven"];

			$idp = isset($maestro->ids) ? $maestro->ids : '';
			$usr = isset($maestro->usr) ? $maestro->usr : '';
			$nit = isset($maestro->nit) ? $maestro->nit : '';
			$rzs = isset($maestro->rzs) ? $maestro->rzs : '';
			$idlectura = isset($maestro->idlectura) ? $maestro->idlectura : '0';
			$tipoDocumento = isset($maestro->tipodoc) ? $maestro->tipodoc : '1';
			$mail = isset($maestro->mail) ? $maestro->mail : '';
			$cmp = isset($maestro->cmp) ? $maestro->cmp : '';
			$iduser = isset($maestro->iduser) ? $maestro->iduser : '0';
			$ttbs = isset($maestro->ttbs) ? $maestro->ttbs : '0';
			$tbs = isset($maestro->tbs) ? $maestro->tbs : '0';
			$stbs = isset($maestro->stbs) ? $maestro->stbs : '0';
			$dtbs = isset($maestro->dtbs) ? $maestro->dtbs : '0';
			$tarjeta = isset($maestro->tarjeta) ? $maestro->tarjeta : '0000000000000000';
			$gift = isset($maestro->gift) ? $maestro->gift : '0';
			$nrocafc = isset($maestro->nrocafc) ? $maestro->nrocafc : '0';
			$hcafc = isset($maestro->hcafc) ? $maestro->hcafc : '0';
			$fcafc = isset($maestro->fcafc) ? $maestro->fcafc : '0';
			$metodoPago = isset($maestro->metodopago) ? $maestro->metodopago : '1';
			$tventa = isset($maestro->tipoventa) ? $maestro->tipoventa : 'EFECTIVO';
			$rzs = html_entity_decode($rzs, ENT_QUOTES | ENT_HTML401, "UTF-8");
			$rzs1 = xmlEscape($rzs);

			$newtbs = $tbs + $gift;

			// -------------------------- Recuperar Datos de PuntoVenta-Sucursal ------------------------------

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);
			$tipoEmision = $puntoventa->tipoEmision;

			$c01 = "SELECT * FROM siat_sucursal WHERE nroSucursal = '" . $puntoventa->nroSucursal . "'";
			$sucursal = $DB->consultaOne($c01);

			// ------------------------------ Verificar Si existe Codigo CUIS --------------------------------

			$c02 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c02);
			if ($cuis == null) {
				$nmsj = "NO SE TIENE UN CODIGO CUIS VIGENTE";
				throw new Exception($nmsj);
			} else {
				$codcuis = $cuis->codigoCuis;
			}

			if ($tipoEmision == 1) {

				// ----------------------- Verificar Conexion a Impuestos -------------------------------

				$resConexion = conexionImpuestos();
				$codConexion = $resConexion->return->mensajesList->codigo;

				if ($codConexion != "926") {
					$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA CAMBIAR A FUERA DE LINEA .";
					throw new Exception($nmsj);
				}
			}

            
			// ------------------------------ Verificar Si existe Codigo CUFD --------------------------------

			$c03 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' order by id desc";
			$cufd = $DB->consultaOne($c03);
			if ($cufd == null) {
				$resCufd = obtenerCufd($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $codcuis, true);
				$c03_0 = "UPDATE siat_cufd set estado ='INACTIVO' WHERE idPuntoVenta = '" . $puntoventa->id . "' ";
				$update0 = $DB->consulta($c03_0);

				$fechaOriginal = $resCufd->RespuestaCufd->fechaVigencia;
				$fecha = new DateTime($fechaOriginal);
				$fechaFormateada = $fecha->format('Y-m-d H:i:s');

				$c03_1 = "INSERT INTO siat_cufd VALUES (NULL, '" . $puntoventa->id . "', now(), '" . $fechaFormateada . "', '" . $resCufd->RespuestaCufd->codigo . "', '" . $resCufd->RespuestaCufd->codigoControl . "', 'ACTIVO')";
				$insert0 = $DB->consulta($c03_1);

				$c03_2 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' order by id desc";
				$cufd_0 = $DB->consultaOne($c03_2);
				$codcufd = $cufd_0->codigoCufd;
				$codcontrol = $cufd_0->codigoControl;
			} else {
				$codcufd = $cufd->codigoCufd;
				$codcontrol = $cufd->codigoControl;
			}

			// -------------------------- Verificar Si existe Evento Significativo ----------------------------

			$c04 = "SELECT * FROM siat_evento_significativo WHERE idPuntoVenta = '" . $puntoventa->id . "' and estado = 'EN PROCESO' ORDER BY id DESC ";
			$evento = $DB->consultaOne($c04);
			if ($evento == null) {
				$finievento = '0';
				$codevento = '0';
			} else {
				$finievento = $evento->fechaInicioEvento;
				$codevento = $evento->codigoEvento;
				$oldCodigoControl = $evento->codigoControl;
				$oldCodigoCufd = $evento->cufd;
			}

			// -------------------------------- Ver que Evento Significativo es ------------------------------
			$fechaEmision = date('Y-m-d\TH:i:s.v', strtotime($fechareg));
			if ($codevento <= 4) {
				$ncafc = null;
				$c04_0 = "select COALESCE(MAX(nro_factura) + 1, 1) as maxnro from numeracion_factura where id_punto='" . $puntoventa->id . "' ";
				$res4 = $DB->consultaOne($c04_0);
				$nrofac = $res4->maxnro;
			} else {
				$ncafc = $siat->cafc;
				$nrofac = $nrocafc;
				$newfecha = $fcafc;
				$newhora = $hcafc;
				$codcufd = $oldCodigoCufd;
				$codcontrol = $oldCodigoControl;
				$oldfechaEmision = $newfecha . " " . $newhora;
				$fechaEmision = date('Y-m-d\TH:i:s.v', strtotime($oldfechaEmision));
			}

			// ------------------------ Verificar cliente con nit o ci Registrado ----------------------------

			$c05 = "select * from cliente where nitCi = '" . $nit . "' ";
			$cli = $DB->consultaOne($c05);
			if ($cli == null) {
				$c05_0 = "SELECT max(id)+1 AS maxnro FROM cliente ";
				$numcli = $DB->consultaOne($c05_0);
				if ($numcli->maxnro == null) {
					$idcli = 1;
				} else {
					$idcli = $numcli->maxnro;
				}
				$c05_1 = "INSERT INTO cliente  VALUES ('" . $idcli . "', '" . $rzs . "', '" . $nit . "', '', '" . $mail . "', '" . $cmp . "','ACTIVO');";
				$insert5 = $DB->consulta($c05_1);
			} else {
				$idcli = $cli->id;
				$c05_2 = "UPDATE cliente  SET razonSocial = '" . $rzs . "', email = '" . $mail . "' , complemento = '" . $cmp . "' WHERE id='" . $idcli . "' ";
				$update5 = $DB->consulta($c05_2);
			}
			$codcliente = 'c-' . $idcli;

			// ------------------------ Caso NIT Verificar si es valido o no -------------------------------

			$codigoExcepcion = 0;
			if ($tipoEmision == '1') {
				if ($tipoDocumento == '5') {
					$verificarNit = validarNit($nit, 0, $codcuis);
					$codverificacion = $verificarNit->RespuestaVerificarNit->mensajesList->codigo;
					if ($codverificacion == '986') {
						$codigoExcepcion = 0;
					} else {
						$codigoExcepcion = 1;
					}
				}
			} else {
				if ($tipoDocumento == '5') {
					$codigoExcepcion = 1;
				} else {
					$codigoExcepcion = 0;
				}
			}
			// ------------------------ Escoger Leyenda de las habilitadas -------------------------------
			$idley = rand(1, 2);
			$c06 = "select * from siat_sinc_leyendas where id = '" . $idley . "' ";
			$ley = $DB->consultaOne($c06);
			if ($ley == null) {
				$nmsj = "NO SE TIENE LEYENDA SINCRONIZE EL CATALOGO.";
				throw new Exception($nmsj);
			} else {
				$leyenda  = $ley->descripcion;
			}

			//------------------------- Armar Factura Computarizada en Linea ----------------------------

            
			$tipoCambio = 1; // por que es Boliviano es 1 

			if ($tarjeta == "") {
				$tarjeta = 0;
			}
			if ($gift == "") {
				$gift = 0;
			}

			$maestro->municipio = $sucursal->ciudadSucursal;
			$maestro->telefono = $sucursal->telefonoSucursal;
			$maestro->numeroFactura = $nrofac;
			$maestro->cufd = $codcufd;
			$maestro->codCliente = $codcliente;
			$maestro->direccion = $sucursal->direccionSucursal;
			$maestro->complemento = $cmp;
			$maestro->leyenda = $leyenda;
			$maestro->fechaEmision = $fechaEmision;
			$maestro->rzs = $rzs1;
			$maestro->cafc = $ncafc;
			$maestro->usr = $usr;
			$maestro->tipoCambio = $tipoCambio;
			$maestro->montoTotal = $tbs;
			$maestro->nmontoTotal = $newtbs;
			$maestro->codigoMoneda = $siat->tipoMoneda;
			$maestro->numeroTarjeta = $tarjeta;
			$maestro->descuentoAdicional = $dtbs;
			$maestro->montoGiftCard = $gift;
			$maestro->codigoMetodoPago = $metodoPago;
			$maestro->codigoExcepcion = $codigoExcepcion;
            
			$factura = newFactura($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $config->modalidad, $siat->tipoDocumentoSector, $puntoventa->tipoEmision, $siat->tipoFactura, $codcontrol, $maestro, $detalle);
            
           
			//------------------------- Enviar Factura Computarizada en Linea ----------------------------


			$cdevento  = 0;
			
			$enviar = enviarFactura($cuis->codigoCuis, $codcufd, $factura, $siat->tipoFactura, $codcontrol, $puntoventa->tipoEmision);
            
            
			if ($tipoEmision == '1') {
				$resenviar = $enviar->RespuestaServicioFacturacion->codigoEstado;
				if ($resenviar != "908") {
					$nmsj = "EXISTEN 2 CASOS ACTUALIZE EL CUFD MANUELMENTE O ESPERE UN MOMENTO SOLO EN CASO DE FACTURAS EN LINEA.";
					print_r($enviar);
					throw new Exception($enviar);
				}
			} else {
				$c07 = "select * from siat_evento_significativo where estado = 'EN PROCESO' ";
				$res7 = $DB->consultaOne($c07);
				if ($res7 == null) {
					$cdevento = 0;
				} else {
					$cdevento = $res7->codigoEvento;
				}
			}
			//------------------------- Obtener id maximo de la factura --------------------------------
			$c08 = "select COALESCE(MAX(id) + 1, 1) as maxid from siat_factura";
			$res8 = $DB->consultaOne($c08);
			$idfact = $res8->maxid;

			//--------------------------- Insertar Datos a siat_factura --------------------------------
			$c09 = "INSERT INTO siat_factura VALUES ('" . $idfact . "', '" . $idp . "', '" . $newfecha . "', '" . $newhora . "', '" . $config->nit . "', '" . $config->razonSocial . "', '" . $sucursal->ciudadSucursal . "', '" . $sucursal->telefonoSucursal . "', '" . $nrofac . "', '" . $factura->cabecera->cuf . "', '" . $codcufd . "','" . $sucursal->direccionSucursal . "', '" . $fechaEmision . "', '" . $rzs . "', '" . $tipoDocumento . "', '" . $nit . "', '" . $cmp . "', '" . $codcliente . "', '" . $metodoPago . "', '" . $tarjeta . "', '" . $newtbs . "', '" . $tbs . "', '" . $siat->tipoMoneda . "', '" . $tipoCambio . "', '" . $newtbs . "', '" . $gift . "', '" . $dtbs . "', '" . $codigoExcepcion . "',  '" . $ncafc . "', '" . $leyenda . "', '" . $usr . "', '" . $siat->tipoDocumentoSector . "', '0', 'EFECTIVO', '" . $puntoventa->tipoEmision . "', '0', 'VALIDO');";
			$insertVentaFactura = $DB->consulta($c09);

			//------------------------ Insertar Datos a numeracion factura -----------------------------

			if ($codevento <= 4) {
				$c10 = "INSERT INTO numeracion_factura VALUES ('" . $idp . "', '" . $nrofac . "',  '" . $newfecha . "');";
				$insertNumeracionFact = $DB->consulta($c10);
			}

			//-------------------------- Insertar Datos a detalle factura ------------------------------		
			foreach ($detalle as $k => $caja) {
				$c11 = "select descripcion from siat_sinc_unidades_medida where codigo='" . $caja->unidadmedida . "'";
				$unids = $DB->consultaOne($c11);

				$subtotal = round($caja->cantidad * $caja->preciounitario, 2) - round($caja->descuento, 2);
				$c12 = "INSERT INTO siat_factura_item VALUES (NULL,'" . $idfact . "', '" . $caja->actividad . "', '" . $caja->codigosin . "', '" . $caja->codigop . "', '" . $caja->producto . "', '" . $caja->preciounitario . "', '" . $caja->cantidad . "', '" . $unids->descripcion . "', '" . $caja->descuento . "', '" . $subtotal . "', '-', '-', 'VALIDO')";
				$insertDetalleFact = $DB->consulta($c12);
			}
			if ($idven != "0") {
				$c13 = "update ventas set id_factura = '" . $idfact . "' where id_venta = '" . $idven . "'";
				$updateVenta = $DB->consulta($c13);
			}
			// -------------------------------- Generamos imagen Qr -----------------------------------

			//Declaramos una carpeta temporal para guardar la imagenes generadas
			$dir = '../Siat/temp/';

			//Si no existe la carpeta la creamos
			if (!file_exists($dir))
				mkdir($dir);

			//Declaramos la ruta y nombre del archivo a generar
			$filename = $dir . 'factura-' . $factura->cabecera->cuf . '.png';

			//Parametros de Condiguración

			$tamaño = 10; //Tamaño de Pixel
			$level = 'L'; //Precisión Baja
			$framSize = 3; //Tamaño en blanco
			$contenido = "https://siat.impuestos.gob.bo/consulta/QR?nit=" . $config->nit . "&cuf=" . $factura->cabecera->cuf . "&numero=" . $nrofac . "&t=1"; //Texto

			//Enviamos los parametros a la Función para generar código QR 
			QRcode::png($contenido, $filename, $level, $tamaño, $framSize);
			


			//$resultado["resenviar"] = $resenviar;
			$resultado["idfac"] = $idfact;
			$resultado["cuf"] = $factura->cabecera->cuf;
			$resultado["tipoEmision"] = $puntoventa->tipoEmision;
			$resultado["idcli"] = $idcli;
			$resultado["cdevento"] = $cdevento;

			break;
		case 'generarFacturaPdf':
			$idfac = $body["idfac"];
			$zero = "";
			$dir = '../Siat/temp/';

			$c00 = "select * from siat_factura where id = '" . $idfac . "' ";
			$factura = $DB->consultaOne($c00);

			$date = date_create($factura->fecha);
			$fecha1 = date_format($date, 'd/m/Y');

			$entero = explode(".", $factura->montoTotalSujetoIva);
			if ($entero[0] == 0) {
				$zero = "cero";
			}

			if ($factura->tipoEmision == '1') {
				$leyenda = 'Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido en una modalidad de facturación en línea';
			} else {
				$leyenda = 'Este documento es la Representación Gráfica de un Documento Fiscal Digital emitido fuera de línea, verifique su envío con su proveedor o en la página web www.impuestos.gob.bo.';
			}
			if ($factura->complemento == "" || is_null($factura->complemento)) {
				$documento = $factura->numeroDocumento;
			} else {
				$documento = $factura->numeroDocumento . "-" . $factura->complemento;
			}

			$c01 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $factura->idPuntoVenta . "'";
			$pos = $DB->consultaOne($c01);

			$c02 = "SELECT * FROM siat_sucursal WHERE nroSucursal = '" . $pos->nroSucursal . "'";
			$sucursal = $DB->consultaOne($c02);

			$c03 = "SELECT * FROM siat_factura_item WHERE idFactura = '" . $idfac . "'";
			$resdatos = $DB->consultaAll($c03);

			$count = $resdatos["size"];

			$nvalor = $count * 16;

			$tampagina = 220 + $nvalor;

			$posX = 1;
			$posY = 1;

			$pdf = new FPDF('P', 'mm', array($tampagina, 100));

			$pdf->AddPage();
			$pdf->SetAutoPageBreak(false);

			$pdf->SetFont('Arial', 'B', 9);
			$pdf->SetXY($posX + 5, $posY + 15);
			$pdf->Cell(85, 5, "FACTURA", 0, 0, 'C');
			$pdf->SetFont('Arial', 'B', 9);
			$pdf->SetXY($posX + 5, $posY + 19);
			$pdf->Cell(85, 5, "CON DERECHO A CREDITO FISCAL", 0, 0, 'C');
			$pdf->SetFont('Arial', '', 8);
			$pdf->SetXY($posX + 5, $posY + 23);
			$pdf->Cell(85, 5, $factura->razonSocialEmisor, 0, 0, 'C');
			$pdf->SetXY($posX + 5, $posY + 27);
			$pdf->Cell(85, 5, $sucursal->nombreSucursal, 0, 0, 'C');
			$pdf->SetXY($posX + 5, $posY + 31);
			$pdf->Cell(85, 5, "Nro Punto de Venta : " . $pos->nroPuntoVenta, 0, 0, 'C');
			$pdf->SetXY($posX + 5, $posY + 35);
			$pdf->Cell(85, 5, $sucursal->direccionSucursal, 0, 0, 'C');
			$pdf->SetXY($posX + 5, $posY + 39);
			$pdf->Cell(85, 5, "Telf: " . $sucursal->telefonoSucursal . " - " . $sucursal->celularSucursal, 0, 0, 'C');
			$pdf->SetXY($posX + 5, $posY + 43);
			$pdf->Cell(85, 5, $sucursal->ciudadSucursal, 0, 0, 'C');
			$pdf->SetXY($posX + 5, $posY + 47);
			$pdf->Cell(85, 5, "------------------------------------------------------------------------------------------", 0, 0, 'C');
			$pdf->SetFont('Arial', 'B', 8);
			$pdf->SetXY($posX + 5, $posY + 51);
			$pdf->Cell(85, 5, "NIT", 0, 0, 'C');
			$pdf->SetFont('Arial', '', 8);
			$pdf->SetXY($posX + 5, $posY + 55);
			$pdf->Cell(85, 5, $factura->nitEmisor, 0, 0, 'C');
			$pdf->SetFont('Arial', 'B', 8);
			$pdf->SetXY($posX + 5, $posY + 59);
			$pdf->Cell(85, 5, "FACTURA Nro", 0, 0, 'C');
			$pdf->SetFont('Arial', '', 8);
			$pdf->SetXY($posX + 5, $posY + 63);
			$pdf->Cell(85, 5, $factura->numeroFactura, 0, 0, 'C');
			$pdf->SetFont('Arial', 'B', 8);
			$pdf->SetXY($posX + 5, $posY + 67);
			$pdf->Cell(85, 5, "CODIGO AUTORIZACION", 0, 0, 'C');
			$pdf->SetFont('Arial', '', 8);
			$pdf->SetXY($posX + 7, $posY + 71);
			$pdf->Cell(85, 5, $factura->cuf, 0, 0, 'C');
			$pdf->SetXY($posX + 5, $posY + 75);
			$pdf->Cell(85, 5, "------------------------------------------------------------------------------------------", 0, 0, 'C');

			$pdf->SetFont('Arial', 'B', 8);
			$pdf->SetXY($posX + 5, $posY + 79);
			$pdf->Cell(42.5, 5, "NOMBRE/RAZON SOCIAL: ", 0, 0, 'R');
			$pdf->SetXY($posX + 5, $posY + 83);
			$pdf->Cell(42.5, 5, "NIT/CI/CEX: ", 0, 0, 'R');
			$pdf->SetXY($posX + 5, $posY + 87);
			$pdf->Cell(42.5, 5, "COD.CLIENTE: ", 0, 0, 'R');
			$pdf->SetXY($posX + 5, $posY + 91);
			$pdf->Cell(42.5, 5, "FECHA EMISION: ", 0, 0, 'R');

			$pdf->SetFont('Arial', '', 8);
			$pdf->SetXY($posX + 48.5, $posY + 79);
			$pdf->Cell(42.5, 5, utf8_decode($factura->nombreRazonSocial), 0, 0, 'L');
			$pdf->SetXY($posX + 48.5, $posY + 83);
			$pdf->Cell(42.5, 5, $documento, 0, 0, 'L');
			$pdf->SetXY($posX + 48.5, $posY + 87);
			$pdf->Cell(42.5, 5, $factura->codigoCliente, 0, 0, 'L');
			$pdf->SetXY($posX + 48.5, $posY + 91);
			$pdf->Cell(42.5, 5, $fecha1 . " - " . $factura->hora, 0, 0, 'L');


			$pdf->SetXY($posX + 5, $posY + 95);
			$pdf->Cell(85, 5, "------------------------------------------------------------------------------------------", 0, 0, 'C');

			$pdf->SetFont('Arial', 'B', 9);
			$pdf->SetXY($posX + 5, $posY + 99);
			$pdf->Cell(85, 5, "DETALLE", 0, 0, 'C');

			$pdf->SetFont('Arial', '', 8);
			$pdf->SetXY($posX + 5, $posY + 103);
			$pdf->Cell(85, 5, "------------------------------------------------------------------------------------------", 0, 0, 'C');

			$tb = $posY + 103;
			$sum = 0;

			for ($i = 0; $i < $resdatos["size"]; $i++) {
				$sum = $sum + 16;
				$pdf->SetFont('Arial', '', 7);
				$pdf->SetXY($posX + 5, $tb + $sum - 12);
				$pdf->Cell(65, 5, $resdatos["data"][$i]->codigoProductoSin . " | " . $resdatos["data"][$i]->descripcion, 0, 0, 'L');
				$pdf->SetXY($posX + 5, $tb + $sum - 8);
				$pdf->Cell(65, 5, " Unidad Medida : " . $resdatos["data"][$i]->unidadMedida, 0, 0, 'L');
				$pdf->SetXY($posX + 5, $tb + $sum - 4);
				$pdf->Cell(65, 5, $resdatos["data"][$i]->cantidad . " x " . $resdatos["data"][$i]->precioUnitario . " - " . $resdatos["data"][$i]->montoDescuento, 0, 0, 'L');
				$pdf->SetXY($posX + 70.5, $tb + $sum - 4);
				$pdf->Cell(20, 5, $resdatos["data"][$i]->subTotal, 0, 0, 'R');
				$pdf->SetFont('Arial', '', 8);
				$pdf->SetXY($posX + 5, $tb + $sum);
				$pdf->Cell(85, 5, "------------------------------------------------------------------------------------------", 0, 0, 'C');
			}
			$nposY = $tb + $sum;
			$pdf->SetFont('Arial', 'B', 8);
			$pdf->SetXY($posX + 5, $nposY + 4);
			$pdf->Cell(65, 5, " SUBTOTAL Bs. : ", 0, 0, 'R');
			$pdf->SetXY($posX + 5, $nposY + 8);
			$pdf->Cell(65, 5, " DESCUENTO Bs. : ", 0, 0, 'R');
			$pdf->SetXY($posX + 5, $nposY + 12);
			$pdf->Cell(65, 5, " TOTAL Bs. : ", 0, 0, 'R');
			$pdf->SetXY($posX + 5, $nposY + 16);
			$pdf->Cell(65, 5, " MONTO GIFT CARD Bs. : ", 0, 0, 'R');
			$pdf->SetXY($posX + 5, $nposY + 20);
			$pdf->Cell(65, 5, " MONTO A PAGAR Bs. : ", 0, 0, 'R');
			$pdf->SetXY($posX + 5, $nposY + 24);
			$pdf->Cell(65, 5, " IMPORTE BASE CREDITO FISCAL Bs. : ", 0, 0, 'R');

			$pdf->SetFont('Arial', '', 8);
			$pdf->SetXY($posX + 70.5, $nposY + 4);
			$pdf->Cell(20, 5, number_format($factura->montoTotalSujetoIva + $factura->descuentoAdicional + $factura->montoGiftCard, 2), 0, 0, 'R');
			$pdf->SetXY($posX + 70.5, $nposY + 8);
			$pdf->Cell(20, 5, number_format($factura->descuentoAdicional, 2), 0, 0, 'R');
			$pdf->SetXY($posX + 70.5, $nposY + 12);
			$pdf->Cell(20, 5, number_format($factura->montoTotalSujetoIva + $factura->montoGiftCard, 2), 0, 0, 'R');
			$pdf->SetXY($posX + 70.5, $nposY + 16);
			$pdf->Cell(20, 5, number_format($factura->montoGiftCard, 2), 0, 0, 'R');
			$pdf->SetXY($posX + 70.5, $nposY + 20);
			$pdf->Cell(20, 5, number_format($factura->montoTotalSujetoIva, 2), 0, 0, 'R');
			$pdf->SetXY($posX + 70.5, $nposY + 24);
			$pdf->Cell(20, 5, number_format($factura->montoTotalSujetoIva, 2), 0, 0, 'R');


			$pdf->SetXY($posX + 5, $nposY + 28);
			$pdf->Cell(85, 5, "------------------------------------------------------------------------------------------", 0, 0, 'C');
			$pdf->SetXY($posX + 5, $nposY + 32);
			$pdf->Cell(85, 5, "Son : " . $zero . " " . convertir_a_letras($factura->montoTotalSujetoIva, '') . " Bolivianos", 0, 0, 'L');
			$pdf->SetXY($posX + 5, $nposY + 36);
			$pdf->Cell(85, 5, "------------------------------------------------------------------------------------------", 0, 0, 'C');

			$pdf->SetFont('Arial', 'B', 8);
			$pdf->SetXY($posX + 5, $nposY + 40);
			$pdf->MultiCell(85, 3, utf8_decode("ESTA FACTURA CONTRIBUYE AL DESARROLLO DEL PAÍS,EL USO ILÍCITO SERÁ SANCIONADO PENALMENTE DE ACUERDO A LEY"), 0, 'C', false);
			$pdf->SetXY($posX + 5, $nposY + 52);
			$pdf->MultiCell(85, 3, utf8_decode($factura->leyenda), 0, 'C', false);

			$pdf->SetXY($posX + 5, $nposY + 64);
			$pdf->MultiCell(85, 3, utf8_decode($leyenda), 0, 'C', false);

			$pdf->Image($dir . "factura-" . $factura->cuf . ".png", 30, $nposY + 78, 30, 0, 'PNG');

			$pdf->Output('F', $dir . "factura-" . $factura->cuf . ".pdf");

			$nombrePdf = "factura-" . $factura->cuf . ".pdf";
			$rutaPdf = $dir . $nombrePdf;

			$pdf->Output('F', $rutaPdf);

			$contenido = file_get_contents($rutaPdf);
			$base64 = base64_encode($contenido);


			$resultado = array();
			$resultado["factura"] = $factura->cuf;
			$resultado["nrofac"] = $factura->numeroFactura;
			break;
		case 'enviarMailFactura':
			$correo = $body["mail"];
			$cuf = $body["cuf"];
			$nit = $body["nit"];
			$rzs = $body["rzs"];

			// ----------------------------- Enviar Email ------------------------------
			//Create an instance; passing `true` enables exceptions
			$mail = new PHPMailer(true);

			try {
				//Server settings
				$mail->SMTPDebug = 0;                     					//Enable verbose debug output
				$mail->isSMTP();                                            //Send using SMTP
				$mail->Host       = $siat->smtp_email;                       //Set the SMTP server to send through
				$mail->SMTPAuth   = true;                                   //Enable SMTP authentication
				$mail->Username   = $siat->email;                 			//SMTP username
				$mail->Password   = $siat->pwd_email;                     	//SMTP password
				$mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
				$mail->Port       = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

				//Recipients
				$mail->setFrom($siat->email, $siat->nombreSistema);
				$mail->addAddress($correo);     //Add a recipient

				//Attachments 
				$xmlfac = 'factura-' . $cuf . '.xml';
				$pdffac = 'factura-' . $cuf . '.pdf';
				
				$xmlPath = dirname(__DIR__) . "/Siat/temp/" . $xmlfac;
                $pdfPath = dirname(__DIR__) . "/Siat/temp/" . $pdffac;
				if (file_exists($xmlPath) && file_exists($pdfPath)) {
                    $mail->addAttachment($xmlPath);
                    $mail->addAttachment($pdfPath);
                } else {
                    die("Uno o ambos archivos no existen.");
                }

				//Content
				$mail->isHTML(true);                                  //Set email format to HTML
				$mail->Subject = 'Datos Factura';
				$mail->Body    = '<b>Datos de su Factura</b><br><p>
				Estimado cliente informarle que se ha emitido su factura a nombre de ' . $rzs . '. <br>
				En adjunto encontrara la representación gráfica y el documento XML de su factura electrónica en línea.</p>';

				$mail->send();
			} catch (Exception $e) {
				echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
			}

			$resultado = array();
			$resultado["correo"] = $correo;
			break;
		case 'anularFactura':
			$idp = $body["ids"];
			$idf = $body["idf"];
			$motivo = $body["motivo"];
			// -------------------------- Recuperar Datos de Factura-cliente ------------------------------
			$c00 = "SELECT * FROM siat_factura WHERE id = '" . $idf . "'";
			$factura = $DB->consultaOne($c00);

			$cli = explode("-", $factura->codigoCliente);

			$c01 = "SELECT * FROM cliente WHERE id = '" . $cli[1] . "'";
			$cliente = $DB->consultaOne($c01);

			// -------------------------- Recuperar Datos de PuntoVenta-Sucursal ------------------------------

			$c02 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c02);
			$tipoEmision = $puntoventa->tipoEmision;

			$c03 = "SELECT * FROM siat_sucursal WHERE nroSucursal = '" . $puntoventa->nroSucursal . "'";
			$sucursal = $DB->consultaOne($c03);

			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA REALIZAR ESTA ACCION CUANDO EXISTA CONEXION.";
				throw new Exception($nmsj);
			}

			// ------------------------------ Verificar Si existe Codigo CUIS --------------------------------

			$c04 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c04);
			if ($cuis == null) {
				$nmsj = "NO SE TIENE UN CODIGO CUIS VIGENTE";
				throw new Exception($nmsj);
			} else {
				$codcuis = $cuis->codigoCuis;
			}

			// ------------------------------ Verificar Si existe Codigo CUFD --------------------------------

			$c05 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' order by id desc";
			$cufd = $DB->consultaOne($c05);
			if ($cufd == null) {
				$resCufd = obtenerCufd($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $codcuis, true);
				$c05_0 = "UPDATE siat_cufd set estado ='INACTIVO' WHERE idPuntoVenta = '" . $puntoventa->id . "' ";
				$update0 = $DB->consulta($c05_0);

				$fechaOriginal = $resCufd->RespuestaCufd->fechaVigencia;
				$fecha = new DateTime($fechaOriginal);
				$fechaFormateada = $fecha->format('Y-m-d H:i:s');

				$c05_1 = "INSERT INTO siat_cufd VALUES (NULL, '" . $puntoventa->id . "', now(), '" . $fechaFormateada . "', '" . $resCufd->RespuestaCufd->codigo . "', '" . $resCufd->RespuestaCufd->codigoControl . "', 'ACTIVO')";
				$insert0 = $DB->consulta($c05_1);

				$c05_2 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' order by id desc";
				$cufd_0 = $DB->consultaOne($c05_2);
				$codcufd = $cufd_0->codigoCufd;
				$codcontrol = $cufd_0->codigoControl;
			} else {
				$codcufd = $cufd->codigoCufd;
				$codcontrol = $cufd->codigoControl;
			}

			// ------------------------------ Enviar la Anulacion de la Factura --------------------------------

			$anularFac = anularFactura($motivo, $factura->cuf, $puntoventa->nroSucursal, $puntoventa->nroPuntoVenta, $siat->tipoFactura, $puntoventa->tipoEmision, $siat->tipoDocumentoSector, $codcuis, $codcufd);

			$resAnular = $anularFac->RespuestaServicioFacturacion->codigoEstado;

			if ($resAnular != "905") {
				$nmsj = $anularFac->RespuestaServicioFacturacion->mensajesList->descripcion;
				throw new Exception($nmsj);
			}
			$c05 = "UPDATE siat_factura SET estado='ANULADO' WHERE id = '" . $idf . "';";
			$updateResultado = $DB->consulta($c05);

			$resultado = array();
			$resultado["res"] = $anularFac;
			$resultado["cuf"] = $factura->cuf;
			$resultado["nro"] = $factura->numeroFactura;
			$resultado["rzs"] = $cliente->razonSocial;
			$resultado["nit"] = $cliente->nitCi;
			$resultado["correo"] = $cliente->email;

			break;
		case 'enviarMailFacturaAnulada':
			$correo = $body["mail"];
			$cuf = $body["cuf"];
			$rzs = $body["rzs"];
			$nit = $body["nit"];
			$nro = $body["nro"];
			$selected = $body["selected"];

			// ----------------------------- Enviar Email ------------------------------
			//Create an instance; passing `true` enables exceptions
			$mail = new PHPMailer(true);

			try {
				//Server settings
				$mail->SMTPDebug = 0;                      //Enable verbose debug output
				$mail->isSMTP();                                            //Send using SMTP
				$mail->Host       = $siat->smtp_email;                       //Set the SMTP server to send through
				$mail->SMTPAuth   = true;                                   //Enable SMTP authentication
				$mail->Username   = $siat->email;                 //SMTP username
				$mail->Password   = $siat->pwd_email;                     //SMTP password
				$mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
				$mail->Port       = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

				//Recipients
				$mail->setFrom($siat->email, $siat->nombreSistema);
				$mail->addAddress($correo);     //Add a recipient

				//Content
				$mail->isHTML(true);                                  //Set email format to HTML
				$mail->Subject = 'Factura Anulada';
				$mail->Body    = '<b>Factura Anulada </b><br><p>Se anulo correctamente la Factura con codigo de autorización : ' . $cuf . ' -> <b> Nro Factura : </b> ' . $nro . ' -> <b> Razon Social : </b> ' . $rzs . ' por el motivo : ' . $selected . '</p>';

				$mail->send();
			} catch (Exception $e) {
				echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
			}

			$resultado = array();
			$resultado["correo"] = $correo;
			break;
		case 'revertirFactura':
			$idp = $body["ids"];
			$idf = $body["idf"];
			// -------------------------- Recuperar Datos de Factura-cliente ------------------------------
			$c00 = "SELECT * FROM siat_factura WHERE id = '" . $idf . "'";
			$factura = $DB->consultaOne($c00);

			$cli = explode("-", $factura->codigoCliente);

			$c01 = "SELECT * FROM cliente WHERE id = '" . $cli[1] . "'";
			$cliente = $DB->consultaOne($c01);

			// -------------------------- Recuperar Datos de PuntoVenta-Sucursal ------------------------------

			$c02 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c02);
			$tipoEmision = $puntoventa->tipoEmision;

			$c03 = "SELECT * FROM siat_sucursal WHERE nroSucursal = '" . $puntoventa->nroSucursal . "'";
			$sucursal = $DB->consultaOne($c03);


			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA REALIZAR ESTA ACCION CUANDO EXISTA CONEXION.";
				throw new Exception($nmsj);
			}

			// ------------------------------ Verificar Si existe Codigo CUIS --------------------------------

			$c04 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c04);
			if ($cuis == null) {
				$nmsj = "NO SE TIENE UN CODIGO CUIS VIGENTE";
				throw new Exception($nmsj);
			} else {
				$codcuis = $cuis->codigoCuis;
			}

			// ------------------------------ Verificar Si existe Codigo CUFD --------------------------------

			$c05 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' order by id desc";
			$cufd = $DB->consultaOne($c05);
			if ($cufd == null) {
				$resCufd = obtenerCufd($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $codcuis, true);
				$c05_0 = "UPDATE siat_cufd set estado ='INACTIVO' WHERE idPuntoVenta = '" . $puntoventa->id . "' ";
				$update0 = $DB->consulta($c05_0);

				$fechaOriginal = $resCufd->RespuestaCufd->fechaVigencia;
				$fecha = new DateTime($fechaOriginal);
				$fechaFormateada = $fecha->format('Y-m-d H:i:s');

				$c05_1 = "INSERT INTO siat_cufd VALUES (NULL, '" . $puntoventa->id . "', now(), '" . $fechaFormateada . "', '" . $resCufd->RespuestaCufd->codigo . "', '" . $resCufd->RespuestaCufd->codigoControl . "', 'ACTIVO')";
				$insert0 = $DB->consulta($c05_1);

				$c05_2 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' order by id desc";
				$cufd_0 = $DB->consultaOne($c05_2);
				$codcufd = $cufd_0->codigoCufd;
				$codcontrol = $cufd_0->codigoControl;
			} else {
				$codcufd = $cufd->codigoCufd;
				$codcontrol = $cufd->codigoControl;
			}

			// ------------------------------ Enviar la Anulacion de la Factura --------------------------------

			$revertirFac = revertirFactura(1, $factura->cuf, $puntoventa->nroSucursal, $puntoventa->nroPuntoVenta, $siat->tipoFactura, $puntoventa->tipoEmision, $siat->tipoDocumentoSector, $codcuis, $codcufd);

			$resRevertir = $revertirFac->RespuestaServicioFacturacion->codigoEstado;
			if ($resRevertir != "907") {
				$nmsj = $revertirFac->RespuestaServicioFacturacion->mensajesList->descripcion;
				throw new Exception($nmsj);
			}
			$c05 = "UPDATE siat_factura SET estado='REVERTIDO' WHERE id = '" . $idf . "';";
			$updateResultado = $DB->consulta($c05);

			$resultado = array();
			$resultado["res"] = $revertirFac;
			$resultado["cuf"] = $factura->cuf;
			$resultado["nro"] = $factura->numeroFactura;
			$resultado["rzs"] = $cliente->razonSocial;
			$resultado["nit"] = $cliente->nitCi;
			$resultado["correo"] = $cliente->email;
			break;
		case 'enviarMailFacturaRevertida':
			$correo = $body["mail"];
			$cuf = $body["cuf"];
			$rzs = $body["rzs"];
			$nit = $body["nit"];
			$nro = $body["nro"];

			// ----------------------------- Enviar Email ------------------------------
			//Create an instance; passing `true` enables exceptions
			$mail = new PHPMailer(true);

			try {
				//Server settings
				$mail->SMTPDebug = 0;                      //Enable verbose debug output
				$mail->isSMTP();                                            //Send using SMTP
				$mail->Host       = $siat->smtp_email;                       //Set the SMTP server to send through
				$mail->SMTPAuth   = true;                                   //Enable SMTP authentication
				$mail->Username   = $siat->email;                 //SMTP username
				$mail->Password   = $siat->pwd_email;                     //SMTP password
				$mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
				$mail->Port       = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

				//Recipients
				$mail->setFrom($siat->email, $siat->nombreSistema);
				$mail->addAddress($correo);     //Add a recipient

				//Content
				$mail->isHTML(true);                                  //Set email format to HTML
				$mail->Subject = 'Factura Revertida';
				$mail->Body    = '<b>Factura Anulada Revertia </b><br><p>Se revirtio correctamente la Factura anulada con codigo de autorización : ' . $cuf . ' -> <b> Nro Factura : </b> ' . $nro . ' -> <b> Razon Social : </b> ' . $rzs . ' </p>';

				$mail->send();
			} catch (Exception $e) {
				echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
			}

			$resultado = array();
			$resultado["correo"] = $correo;
			break;
		case 'buscarNit':
			$nit = $body["cinit"];
			$c00 = "select  * from cliente where nitCi='" . $nit . "' ";
			$cliente = $DB->consultaOne($c00);

			$resultado = array();
			$resultado["cliente"] = $cliente;
			break;
		case 'buscarRazonSocial':
			$rzs = $body["rzs"];
			$c00 = "select  * from cliente where razonSocial like '%".$rzs."%' ";
			$clientes = $DB->consultaAll($c00);

			$resultado = array();
			$resultado["query"] = $c00;
			$resultado["clientes"] = $clientes;
			break;
		case 'buscarNro':
			$nro = $body["nromed"];
			$c00 = "select  * from cliente where nroMedidor = '" . $nro . "' ";
			$cliente = $DB->consultaOne($c00);

			$resultado = array();
			$resultado["cliente"] = $cliente;
			break;
		case 'verificarEvento':
			$ids = $body["ids"];
			$nomevento = '';
			$c00 = "select * from siat_evento_significativo where idPuntoVenta='" . $ids . "' and estado = 'EN PROCESO' ";
			$evento = $DB->consultaOne($c00);
			$codigoEvento = isset($evento->codigoEvento) ? $evento->codigoEvento : '0';
			if ($codigoEvento == '0') {
				$evento = 0;
			} else {
				$c01 = "select * from siat_sinc_eventos_significativos where codigo='" . $codigoEvento . "' ";
				$nomevento = $DB->consultaOne($c01);
			}
			$resultado = array();
			$resultado["evento"] = $evento;
			$resultado["nomevento"] = $nomevento;
			break;


		case 'updPaswordCliente':
			$idcli = $body["idcli"];
			$codigocli = "c-" . $idcli;

			$c0 = "UPDATE cliente set email ='" . $codigocli . "' WHERE id = '" . $idcli . "' ";
			$update0 = $DB->consulta($c0);

			$resultado = array();
			$resultado["upd"] = $update0;
			break;
		case 'listarFacturasCliente':
			$codigo = $body["codigo"];
			$c00 = "SELECT * FROM siat_factura  WHERE codigoCliente = '" . $codigo . "' GROUP BY id ORDER BY id DESC; ";
			$facturas = $DB->consultaAll($c00);

			$resultado = array();
			$resultado["facturas"] = $facturas;
			$resultado["c00"] = $c00;
			break;
		case 'listarSincronizacion':
			$c00 = "SELECT * FROM siat_sinc_actividades ";
			$datos0 = $DB->consultaAll($c00);
			$c01 = "SELECT * FROM siat_sinc_documento_sector ";
			$datos1 = $DB->consultaAll($c01);
			$c02 = "SELECT * FROM siat_sinc_leyendas ";
			$datos2 = $DB->consultaAll($c02);
			$c03 = "SELECT * FROM siat_sinc_productos_servicios ";
			$datos3 = $DB->consultaAll($c03);
			$c04 = "SELECT * FROM siat_sinc_eventos_significativos ";
			$datos4 = $DB->consultaAll($c04);
			$c05 = "SELECT * FROM siat_sinc_motivos_anulacion ";
			$datos5 = $DB->consultaAll($c05);
			$c06 = "SELECT * FROM siat_sinc_tipos_documento_identidad ";
			$datos6 = $DB->consultaAll($c06);
			$c07 = "SELECT * FROM siat_sinc_tipos_documento_sector ";
			$datos7 = $DB->consultaAll($c07);
			$c08 = "SELECT * FROM siat_sinc_tipos_emision ";
			$datos8 = $DB->consultaAll($c08);
			$c09 = "SELECT * FROM siat_sinc_metodo_pago ";
			$datos9 = $DB->consultaAll($c09);
			$c10 = "SELECT * FROM siat_sinc_tipos_moneda ";
			$datos10 = $DB->consultaAll($c10);
			$c11 = "SELECT * FROM siat_sinc_tipos_punto_venta";
			$datos11 = $DB->consultaAll($c11);
			$c12 = "SELECT * FROM siat_sinc_tipos_factura ";
			$datos12 = $DB->consultaAll($c12);
			$c13 = "SELECT * FROM siat_sinc_unidades_medida ";
			$datos13 = $DB->consultaAll($c13);

			$resultado = array();
			$resultado["datos0"] = $datos0;
			$resultado["datos1"] = $datos1;
			$resultado["datos2"] = $datos2;
			$resultado["datos3"] = $datos3;
			$resultado["datos4"] = $datos4;
			$resultado["datos5"] = $datos5;
			$resultado["datos6"] = $datos6;
			$resultado["datos7"] = $datos7;
			$resultado["datos8"] = $datos8;
			$resultado["datos9"] = $datos9;
			$resultado["datos10"] = $datos10;
			$resultado["datos11"] = $datos11;
			$resultado["datos12"] = $datos12;
			$resultado["datos13"] = $datos13;
			break;
		case 'sincronizarSiat':
			$valor = $body["valor"];
			$idp = $body["ids"];


			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA REALIZAR ESTA ACCION CUANDO EXISTA CONEXION.";
				throw new Exception($nmsj);
			}

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);

			$c01 = "SELECT * FROM siat_cuis WHERE idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c01);

			$service = new ServicioFacturacionSincronizacion($cuis->codigoCuis);
			$service->setConfig((array)$config);

			if ($valor == 0 || $valor == 14) {
				$res = $service->sincronizarActividades($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaActividades->listaActividades;

				$c0 = "TRUNCATE siat_sinc_actividades";
				$truncate0 = $DB->consulta($c0);
				$c0 = "INSERT INTO siat_sinc_actividades VALUES (default, '" . $datos0->codigoCaeb . "', '" . $datos0->descripcion . "', '" . $datos0->tipoActividad . "','" . $fechareg . "');";
				$insert0 = $DB->consulta($c0);
				/*
				for ($k = 0; $k < count($datos0); $k++) 
				{
					$c0="INSERT INTO siat_sinc_actividades VALUES (default, '".$datos0[$k]->codigoCaeb."', '".$datos0[$k]->descripcion."', '".$datos0[$k]->tipoActividad."','".$fechareg."');";
					$insert0 = $DB->consulta($c0);
				}*/
				
			}
			if ($valor == 1 || $valor == 14) {
				$res = $service->sincronizarListaActividadesDocumentoSector($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaActividadesDocumentoSector->listaActividadesDocumentoSector;

				$c0 = "TRUNCATE siat_sinc_documento_sector";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_documento_sector VALUES (default, '" . $datos0[$k]->codigoActividad . "', '" . $datos0[$k]->codigoDocumentoSector . "', '" . $datos0[$k]->tipoDocumentoSector . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 2 || $valor == 14) {
				$res = $service->sincronizarListaLeyendasFactura($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricasLeyendas->listaLeyendas;

				$c0 = "TRUNCATE siat_sinc_leyendas";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_leyendas VALUES (default, '" . $datos0[$k]->codigoActividad . "', '" . $datos0[$k]->descripcionLeyenda . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 3 || $valor == 14) {
				$res = $service->sincronizarListaProductosServicios($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaProductos->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_productos_servicios";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_productos_servicios VALUES (default, '" . $datos0[$k]->codigoActividad . "', '" . $datos0[$k]->codigoProducto . "', '" . $datos0[$k]->descripcionProducto . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 4 || $valor == 14) {
				$res = $service->sincronizarParametricaEventosSignificativos($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_eventos_significativos";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_eventos_significativos VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 5 || $valor == 14) {
				$res = $service->sincronizarParametricaMotivoAnulacion($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_motivos_anulacion";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_motivos_anulacion VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 6 || $valor == 14) {
				$res = $service->sincronizarParametricaTipoDocumentoIdentidad($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_tipos_documento_identidad";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_tipos_documento_identidad VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 7 || $valor == 14) {
				$res = $service->sincronizarParametricaTipoDocumentoSector($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_tipos_documento_sector";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_tipos_documento_sector VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 8 || $valor == 14) {
				$res = $service->sincronizarParametricaTipoEmision($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_tipos_emision";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_tipos_emision VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 9 || $valor == 14) {
				$res = $service->sincronizarParametricaTipoMetodoPago($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_metodo_pago";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_metodo_pago VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 10 || $valor == 14) {
				$res = $service->sincronizarParametricaTipoMoneda($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_tipos_moneda";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_tipos_moneda VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 11 || $valor == 14) {
				$res = $service->sincronizarParametricaTipoPuntoVenta($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_tipos_punto_venta";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_tipos_punto_venta VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 12 || $valor == 14) {
				$res = $service->sincronizarParametricaTiposFactura($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_tipos_factura";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_tipos_factura VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			if ($valor == 13 || $valor == 14) {
				$res = $service->sincronizarParametricaUnidadMedida($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta);
				$datos0 =  $res->RespuestaListaParametricas->listaCodigos;

				$c0 = "TRUNCATE siat_sinc_unidades_medida";
				$truncate0 = $DB->consulta($c0);
				for ($k = 0; $k < count($datos0); $k++) {
					$c0 = "INSERT INTO siat_sinc_unidades_medida VALUES (default, '" . $datos0[$k]->codigoClasificador . "', '" . $datos0[$k]->descripcion . "','" . $fechareg . "');";
					$insert0 = $DB->consulta($c0);
				}
			}

			$resultado = array();
			$resultado["service"] = $datos0;
			break;
		case 'deleteSiat':
			$valor = $body["valor"];
			if ($valor == 0) {
				$c0 = "TRUNCATE siat_sinc_actividades";
				$truncate0 = $DB->consulta($c0);
			}
			if ($valor == 1) {

				$c0 = "TRUNCATE siat_sinc_documento_sector";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 2) {

				$c0 = "TRUNCATE siat_sinc_leyendas";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 3) {

				$c0 = "TRUNCATE siat_sinc_productos_servicios";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 4) {

				$c0 = "TRUNCATE siat_sinc_eventos_significativos";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 5) {

				$c0 = "TRUNCATE siat_sinc_motivos_anulacion";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 6) {

				$c0 = "TRUNCATE siat_sinc_tipos_documento_identidad";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 7) {

				$c0 = "TRUNCATE siat_sinc_tipos_documento_sector";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 8) {

				$c0 = "TRUNCATE siat_sinc_tipos_emision";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 9) {

				$c0 = "TRUNCATE siat_sinc_metodo_pago";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 10) {

				$c0 = "TRUNCATE siat_sinc_tipos_moneda";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 11) {

				$c0 = "TRUNCATE siat_sinc_tipos_punto_venta";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 12) {

				$c0 = "TRUNCATE siat_sinc_tipos_factura";
				$truncate0 = $DB->consulta($c0);
			}

			if ($valor == 13) {

				$c0 = "TRUNCATE siat_sinc_unidades_medida";
				$truncate0 = $DB->consulta($c0);
			}

			$resultado = array();
			$resultado["res"] = $truncate0;
			break;
		case 'listarCodigos':
			$idp = $body["ids"];

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);

			$c01 = "SELECT * FROM siat_cuis sc, siat_punto_de_venta pv WHERE pv.id = sc.idPuntoVenta AND  sc.idPuntoVenta = '" . $puntoventa->id . "' ";
			$cuis = $DB->consultaAll($c01);

			$c02 = "SELECT * FROM siat_cufd sc, siat_punto_de_venta pv WHERE pv.id = sc.idPuntoVenta AND sc.idPuntoVenta = '" . $puntoventa->id . "' ";
			$cufds = $DB->consultaAll($c02);

			$resultado = array();
			$resultado["cuiss"] = $cuis;
			$resultado["cufds"] = $cufds;

			break;
		case 'listarEventos':
			$idp = $body["ids"];

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);

			$c01 = "SELECT * FROM siat_evento_significativo es, siat_punto_de_venta pv WHERE pv.id = es.idPuntoVenta AND es.idPuntoVenta = '" . $puntoventa->id . "' ";
			$eventos = $DB->consultaAll($c01);

			$resultado = array();
			$resultado["eventos"] = $eventos;

			break;

			/* --------------------- sucursal  ---------------------------- */
		case 'listarSucursales':
			$c00 = "SELECT * FROM siat_sucursal";
			$sucursales = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["sucursales"] = $sucursales;
			break;
		case 'newSucursal':
			$nro = $body["nrosucursal"];
			$codigo = $body["codsucursal"];
			$sucursal = $body["sucursal"];
			$responsable = $body["responsable"];
			$direccion = $body["direccion"];
			$telefono = $body["telefono"];
			$celular = $body["celular"];

			$c00 = "INSERT INTO siat_sucursal VALUES (default, '" . $nro . "', '" . $codigo . "', '" . $sucursal . "', '" . $responsable . "', '" . $telefono . "', '" . $celular . "', '" . $direccion . "', '', 'ACTIVO');";
			$insertsucursal = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $insertsucursal;
			break;
		case 'editSucursal':
			$id = $body["idsucursal"];
			$c00 = "SELECT * from siat_sucursal where id ='" . $id . "'";
			$sucursal = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["sucursal"] = $sucursal;
			break;
		case 'updSucursal':
			$id = $body["idsucursal"];
			$sucursal = $body["sucursal"];
			$responsable = $body["responsable"];
			$direccion = $body["direccion"];
			$telefono = $body["telefono"];
			$celular = $body["celular"];

			$c00 = "UPDATE siat_sucursal set nombreSucursal='" . $sucursal . "', responsableSucursal ='" . $responsable . "', direccionSucursal='" . $direccion . "', telefonoSucursal = '" . $telefono . "', celularSucursal = '" . $celular . "' WHERE id = '" . $id . "';";
			$updsucursal = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updsucursal;
			break;
		case 'listarPos':

			$c00 = "SELECT * FROM siat_punto_de_venta";
			$pos = $DB->consultaAll($c00);

			$resultado = array();
			$resultado["pos"] = $pos;

			break;
		case 'newPos':
			$sucursal = $body["sucursal"];
			$tipopv = $body["tipopv"];
			$nombrepv = $body["nombrepv"];


			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA REALIZAR ESTA ACCION CUANDO EXISTA CONEXION.";
				throw new Exception($nmsj);
			}

			$res = registroPuntoVenta($sucursal, $tipopv, $nombrepv);

			$codigopv = $res->RespuestaRegistroPuntoVenta->codigoPuntoVenta;

			$c00 = "INSERT INTO siat_punto_de_venta VALUES (default, '" . $sucursal . "', '" . $codigopv . "', '" . $nombrepv . "', '" . $tipopv . "', 1, 'ACTIVO')";
			$insert0 = $DB->consulta($c00);

			$resultado = array();
			$resultado["res"] = $res;

			break;
		case 'sincronizarPos':
			$nroSucursal = $body["nroSucursal"];


			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA REALIZAR ESTA ACCION CUANDO EXISTA CONEXION.";
				throw new Exception($nmsj);
			}

			$res = consultaPuntoVenta($nroSucursal);

			$datos0 =  $res->RespuestaConsultaPuntoVenta->listaPuntosVentas;

			for ($k = 0; $k < count($datos0); $k++) {
				$c00 = "SELECT codigo FROM siat_sinc_tipos_punto_venta WHERE descripcion = '" . $datos0[$k]->tipoPuntoVenta . "' ";
				$codigo = $DB->consultaOne($c00);
				$cdtipo = isset($codigo->codigo) ? $codigo->codigo : '5';

				$c0 = "UPDATE siat_punto_de_venta SET  nombrePuntoVenta = '" . $datos0[$k]->nombrePuntoVenta . "', tipoPuntoVenta = '" . $cdtipo . "' WHERE nroPuntoVenta = '" . $datos0[$k]->codigoPuntoVenta . "'";
				$insert0 = $DB->consulta($c0);
			}

			$resultado = array();
			$resultado["res"] = $res;

			break;
		case 'configuracionSiat':
			$c00 = "SELECT * FROM siat_configuracion  WHERE id = '1' ";
			$configuracion = $DB->consultaOne($c00);

			$resultado = array();
			$resultado["configuracion"] = $configuracion;
			break;
		case 'updConfiguracion':
			$nomsistema = $body["nomsistema"];
			$metsistema = $body["metsistema"];
			$codsistema = $body["codsistema"];
			$rzssistema = $body["rzssistema"];
			$nitsistema = $body["nitsistema"];
			$modsistema = $body["modsistema"];
			$ambsistema = $body["ambsistema"];
			$cafcsistema = $body["cafcsistema"];
			$monsistema = $body["monsistema"];
			$docsectorsistema = $body["docsectorsistema"];
			$facsistema = $body["facsistema"];
			$toksistema = $body["toksistema"];
			$ciusistema = $body["ciusistema"];
			$telsistema = $body["telsistema"];
			$impsistema = $body["impsistema"];
			$inicafcsistema = $body["inicafcsistema"];
			$fincafcsistema = $body["fincafcsistema"];
			$pubsistema = $body["pubsistema"];
			$privsistema = $body["privsistema"];
			$pwdemailsistema = $body["pwdemailsistema"];
			$smtpemailsistema = $body["smtpemailsistema"];
			$emailsistema = $body["emailsistema"];
			$c00 = "UPDATE siat_configuracion SET codigoSistema='" . $codsistema . "',nombreSistema='" . $nomsistema . "',nitCi='" . $nitsistema . "',razonSocial='" . $rzssistema . "',modalidad='" . $modsistema . "',ambiente='" . $ambsistema . "',tipoDocumentoSector='" . $docsectorsistema . "',tipoMetodoPago='" . $metsistema . "', tipoFactura='" . $facsistema . "',tipoMoneda='" . $monsistema . "',token='" . $toksistema . "',ciudad='" . $ciusistema . "',telefono='" . $telsistema . "',cafc='" . $cafcsistema . "',inicioNroCafc='" . $inicafcsistema . "',finNroCafc='" . $fincafcsistema . "',pubCert='" . $pubsistema . "',privCert='" . $privsistema . "',tipoImpresion='" . $impsistema . "' , email='" . $emailsistema . "',pwd_email='" . $pwdemailsistema . "',smtp_email='" . $smtpemailsistema . "'  WHERE id= '1' ";
			$updConfiguracion = $DB->consulta($c00);

			$resultado = array();
			$resultado["configuracion"] = $updConfiguracion;
			break;
		case 'sincronizarCuis':
			$idp = $body["ids"];


			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA REALIZAR ESTA ACCION CUANDO EXISTA CONEXION.";
				throw new Exception($nmsj);
			}

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);

			$c01 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c01);
			$idcuis = isset($cuis->id) ? $cuis->idCuis : '0';
			if ($idcuis == 0) {
				$c0 = "UPDATE siat_cuis set estado ='INACTIVO' WHERE idPuntoVenta = '" . $puntoventa->id . "' ";
				$update0 = $DB->consulta($c0);
				$resCuis 	= obtenerCuis($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal);

				$fechaOriginal = $resCuis->RespuestaCuis->fechaVigencia;
				$fecha = new DateTime($fechaOriginal);
				$fechaFormateada = $fecha->format('Y-m-d H:i:s');

				$c1 = "INSERT INTO siat_cuis VALUES (NULL, '" . $puntoventa->id . "', '" . $fechareg . "', '" . $fechaFormateada . "', '" . $resCuis->RespuestaCuis->codigo . "', 'ACTIVO');";
				$insert0 = $DB->consulta($c1);
				$msj = 'Se genero un codigo CUIS para esta sucursal con vigencia a fecha: ' . $fechaFormateada;
			} else {
				$msj = 'Se tiene un codigo CUIS para esta sucursal con vigencia a fecha: ' . $cuis->fechaVigencia;
			}

			$resultado = array();
			$resultado["msj"] = $msj;
			$resultado["res"] = $resCuis;
			$resultado["puntoventa"] = $puntoventa;

			break;
		case 'sincronizarCufd':
			$idp = $body["ids"];


			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA REALIZAR ESTA ACCION CUANDO EXISTA CONEXION.";
				throw new Exception($nmsj);
			}

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);

			// ------------------------------ Verificar que no este fuera de linea ----------------------------
			if ($puntoventa->tipoEmision == "2") {
				$nmsj = "NO SE PUEDE ACTUALIZAR EL CUFD EN MODO FUERA DE LINEA.";
				throw new Exception($nmsj);
			}


			$c01 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c01);
			$idcuis = isset($cuis->id) ? $cuis->id : '0';
			if ($idcuis != 0) {
				$c02 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO'";
				$cufd = $DB->consultaOne($c02);
				$idcufd = isset($cufd->idCufd) ? $cufd->idCufd : '0';
				if ($idcufd == 0) {
					$resCufd = obtenerCufd($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $cuis->codigoCuis, true);
					$c0 = "UPDATE siat_cufd set estado ='INACTIVO' WHERE idPuntoVenta = '" . $puntoventa->id . "' ";
					$update0 = $DB->consulta($c0);

					$fechaOriginal = $resCufd->RespuestaCufd->fechaVigencia;
					$fecha = new DateTime($fechaOriginal);
					$fechaFormateada = $fecha->format('Y-m-d H:i:s');

					$c1 = "INSERT INTO siat_cufd VALUES (NULL, '" . $puntoventa->id . "', now(), '" . $fechaFormateada . "', '" . $resCufd->RespuestaCufd->codigo . "', '" . $resCufd->RespuestaCufd->codigoControl . "', 'ACTIVO')";
					$insert0 = $DB->consulta($c1);
					$msj = 'Se genero un codigo CUFD para esta sucursal con vigencia a fecha: ' . $fechaFormateada;
				} else {
					$msj = 'Se tiene un codigo CUFD para esta sucursal con vigencia a fecha: ' . $cufd->fechaVigencia;
				}
			} else {
				$msj = 'No se Tiene un codigo CUIS Vigente para esta sucursal.';
			}

			$resultado = array();
			$resultado["msj"] = $msj;
			$resultado["query"] = $c01;
			$resultado["query"] = $c01;
			$resultado["res"] = $resCufd;
			break;
		case 'newEventoSignificativoCafc':
			$idp = $body["ids"];
			$evento = $body["evento"];
			$idcufd = $body["idcufd"];
			$fini = $body["fini"];
			$ffin = $body["ffin"];
         
			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);

			if ($evento == 5) {
				$descripcion = "VIRUS INFORMÁTICO O FALLA DE SOFTWARE";
			}
			if ($evento == 6) {
				$descripcion = "CAMBIO DE INFRAESTRUCTURA DEL SISTEMA INFORMÁTICO";
			}
			if ($evento == 7) {
				$descripcion = "CORTE DE SUMINISTRO DE ENERGIA ELECTRICA";
			}

			$c01 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c01);
			$codcuis = isset($cuis->codigoCuis) ? $cuis->codigoCuis : '0';
            
			$c02 = "SELECT * FROM siat_cufd WHERE id = '" . $idcufd . "'";
			$ocufd = $DB->consultaOne($c02);
			$oldcodcufd = isset($ocufd->codigoCufd) ? $ocufd->codigoCufd : '0';
			$oldcodcontrol = isset($ocufd->codigoControl) ? $ocufd->codigoControl : '0';

			$c0 = "UPDATE siat_punto_de_venta set tipoEmision = '2' WHERE id = '" . $idp . "' ";
			$insert0 = $DB->consulta($c0);

			$c1 = "INSERT INTO siat_evento_significativo VALUES (NULL, '" . $puntoventa->id . "', '" . $config->ambiente . "', '" . $config->codigoSistema . "', '" . $config->nit . "', '" . $codcuis . "', '" . $oldcodcufd . "', '" . $oldcodcontrol . "', '" . $evento . "', '" . $descripcion . "', '" . $fini . "', '" . $ffin . "', '-', '-', '-', 'EN PROCESO');";
			$insert0 = $DB->consulta($c1);

			$msj = "Se genero correctamente el Evento por: " . $descripcion;

			$resultado = array();
			$resultado["msj"] = $msj;

			break;
		case 'newEventoSignificativo':
			$idp = $body["ids"];
			$evento = $body["evento"];

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);
            
			if ($evento == 1) {
				$descripcion = "CORTE DEL SERVICIO DE INTERNET";
			}
			if ($evento == 2) {
				$descripcion = "INACCESIBILIDAD AL SERVICIO WEB DE LA ADMINISTRACIÓN TRIBUTARIA";
			}
			if ($evento == 3) {
				$descripcion = "INGRESO A ZONAS SIN INTERNET POR DESPLIEGUE DE PUNTO DE VENTA EN VEHICULOS AUTOMOTORES";
			}
			if ($evento == 4) {
				$descripcion = "VENTA EN LUGARES SIN INTERNET";
			}

            
			$c01 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c01);
			$codcuis = isset($cuis->codigoCuis) ? $cuis->codigoCuis : '0';
            
			$c02 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO'";
			$cufd = $DB->consultaOne($c02);
			$codcufd = isset($cufd->codigoCufd) ? $cufd->codigoCufd : '0';
			$codcontrol = isset($cufd->codigoControl) ? $cufd->codigoControl : '0';
            
			$c0 = "UPDATE siat_punto_de_venta set tipoEmision = '2' WHERE id = '" . $idp . "' ";
			$update0 = $DB->consulta($c0);
           
			$c1 = "INSERT INTO siat_evento_significativo VALUES (NULL, '" . $puntoventa->id . "', '" . $config->ambiente . "', '" . $config->codigoSistema . "', '" . $config->nit . "', '" . $codcuis . "', '" . $codcufd . "', '" . $codcontrol . "', '" . $evento . "', '" . $descripcion . "', now(), now(), '-', '-', '-', 'EN PROCESO');";
			$insert0 = $DB->consulta($c1);
			$msj = "Se genero correctamente el Evento por: " . $descripcion;

			$resultado = array();
			$resultado["msj"] = $msj;
			$resultado["cufd"] = $codcufd;

			break;
		case 'finEventoSignificativoCafc':
			$datos = array();
			$codrecepcion = '-';
			$resPaquete = '-';
			$idp = $body["ids"];
			$newcufd = '-';


			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS SE RECOMIENDA REALIZAR ESTA ACCION CUANDO EXISTA CONEXION.";
				throw new Exception($nmsj);
			}

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);

			$c01 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c01);
			$codcuis = isset($cuis->codigoCuis) ? $cuis->codigoCuis : '0';


			$c03 = "SELECT * FROM siat_evento_significativo WHERE idPuntoVenta = '" . $puntoventa->id . "' and estado = 'EN PROCESO' ORDER BY id DESC ";
			$evento = $DB->consultaOne($c03);
			$finievento = isset($evento->fechaInicioEvento) ? $evento->fechaInicioEvento : '0';
			$ffinevento = isset($evento->fechaFinEvento) ? $evento->fechaFinEvento : '0';
			$codevento = isset($evento->codigoEvento) ? $evento->codigoEvento : '0';
			$oldcufd = isset($evento->cufd) ? $evento->cufd : '0';
			$oldcodcontrol = isset($evento->codigoControl) ? $evento->codigoControl : '0';
			$idevento = isset($evento->id) ? $evento->id : '0';
			$descripcion = isset($evento->descripcion) ? $evento->descripcion : '';

			$c04 = "SELECT count(*) as contador FROM siat_factura WHERE fechaEmision >= '" . $finievento . "' ";
			$numeros = $DB->consultaOne($c04);

			$numfacturas = $numeros->contador;

			if ($numfacturas) {
				if ($codevento <= 4) {
					$cafc_actual = null;
				} else {
					$cafc_actual = $siat->cafc;
				}

				$pvfechaInicio = date('Y-m-d\TH:i:s.v', strtotime($finievento));
				$pvfechaFin = date('Y-m-d\TH:i:s.v', strtotime($ffinevento));

				$nevento = obtenerListadoEventos($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta, $codevento, $codcuis);

				$resCufd = obtenerCufd($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $codcuis, true);

				$newcufd = $resCufd->RespuestaCufd->codigo;
				$newcodcontrol = $resCufd->RespuestaCufd->codigoControl;

				$c0 = "UPDATE siat_cufd set estado ='INACTIVO' WHERE 1";
				$update0 = $DB->consulta($c0);

				$fechaOriginal = $resCufd->RespuestaCufd->fechaVigencia;
				$fecha = new DateTime($fechaOriginal);
				$fechaFormateada = $fecha->format('Y-m-d H:i:s');

				$c1 = "INSERT INTO siat_cufd VALUES (NULL, '" . $puntoventa->id . "', now(), '" . $fechaFormateada . "', '" . $newcufd . "', '" . $newcodcontrol . "', 'ACTIVO')";
				$insert0 = $DB->consulta($c1);

				$resEvento = registroEvento($cuis->codigoCuis, $newcufd, $puntoventa->nroSucursal, $puntoventa->nroPuntoVenta, $nevento, $oldcufd, $pvfechaInicio, $pvfechaFin);

				//print_r($resEvento); die();

				$codrecepcion = $resEvento->RespuestaListaEventos->codigoRecepcionEventoSignificativo;


				$c03 = "SELECT * FROM siat_factura sf WHERE sf.tipoEmision='2' and sf.xml = '0'";
				$resdatos = $DB->consultaAll($c03);

				for ($i = 0; $i < $resdatos["size"]; $i++) {
					$nidfact =  $resdatos["data"][$i]->id;
					$nitcliente = $resdatos["data"][$i]->numeroDocumento;
					$detalle = array();

					$c04 = "SELECT * FROM cliente WHERE nitCi = '" . $nitcliente . "'";
					$cliente = $DB->consultaOne($c04);
					$mailcliente = $cliente->email;
					$rzscliente = $cliente->razonSocial;

					$c041 = "SELECT * FROM siat_factura_item WHERE idFactura='" . $nidfact . "' ";
					$det = $DB->consultaAll($c041);
					for ($j = 0; $j < $det["size"]; $j++) {
						$c042 = "select codigo from siat_sinc_unidades_medida where descripcion='" . $det["data"][$j]->unidadMedida . "'";
						$unids = $DB->consultaOne($c042);

						$esclavo = new stdClass();
						$esclavo->actividad				= $det["data"][$j]->actividadEconomica;
						$esclavo->codigosin				= $det["data"][$j]->codigoProductoSin;
						$esclavo->codigop				= $det["data"][$j]->codigoProducto;
						$esclavo->producto			    = $det["data"][$j]->descripcion;
						$esclavo->cantidad				= $det["data"][$j]->cantidad;
						$esclavo->unidadmedida			= $unids->codigo;
						$esclavo->preciounitario				= $det["data"][$j]->precioUnitario;
						$esclavo->descuento				= $det["data"][$j]->montoDescuento;
						$esclavo->subtotal				= $det["data"][$j]->subTotal;
						array_push($detalle, $esclavo);
					}
					$fechaEmision = date('Y-m-d\TH:i:s.v', strtotime($resdatos["data"][$i]->fecha . ' ' . $resdatos["data"][$i]->hora));

					$maestro = new stdClass();
					$maestro->cufd 				= $resdatos["data"][$i]->cufd;
					$maestro->municipio        	= $resdatos["data"][$i]->municipio;
					$maestro->telefono			= $resdatos["data"][$i]->telefono;
					$maestro->numeroFactura		= $resdatos["data"][$i]->numeroFactura;
					$maestro->direccion			= $resdatos["data"][$i]->direccion;
					$maestro->fechaEmision		= $fechaEmision;
					$maestro->rzs				= xmlEscape($resdatos["data"][$i]->nombreRazonSocial);
					$maestro->tipodoc			= $resdatos["data"][$i]->codigoTipoDocumentoIdentidad;
					$maestro->nit				= $resdatos["data"][$i]->numeroDocumento;
					$maestro->codCliente		= $resdatos["data"][$i]->codigoCliente;
					$maestro->codigoMetodoPago	= $resdatos["data"][$i]->codigoMetodoPago;
					$maestro->leyenda			= $resdatos["data"][$i]->leyenda;
					$maestro->complemento		= $resdatos["data"][$i]->complemento;
					$maestro->codigoExcepcion	= $resdatos["data"][$i]->codigoExcepcion;
					$maestro->codigoMoneda		= $resdatos["data"][$i]->codigoMoneda;
					$maestro->numeroTarjeta 	= $resdatos["data"][$i]->numeroTarjeta;
					$maestro->montoTotal 		= $resdatos["data"][$i]->montoTotalSujetoIva;
					$maestro->nmontoTotal 		= $resdatos["data"][$i]->montoTotal;
					$maestro->descuentoAdicional = $resdatos["data"][$i]->descuentoAdicional;
					$maestro->montoGiftCard 	= $resdatos["data"][$i]->montoGiftCard;
					$maestro->tipoCambio		= $resdatos["data"][$i]->tipoCambio;
					$maestro->usr				= $resdatos["data"][$i]->usuario;
					$maestro->cuf				= $resdatos["data"][$i]->cuf;
					$maestro->cafc				= $resdatos["data"][$i]->cafc;
					$maestro->idfac				= $resdatos["data"][$i]->id;
					$maestro->email				= $mailcliente;
					$maestro->cliente			= $rzscliente;
					$maestro->detalle 			= $detalle;

					array_push($datos, $maestro);
				}

				$facturas = newFacturas($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $config->modalidad, $siat->tipoDocumentoSector, $puntoventa->tipoEmision, $siat->tipoFactura, $oldcodcontrol, $oldcufd, $cafc_actual, $datos);

				$resPaquete =  enviarPaquetes($facturas, $oldcodcontrol, $siat->tipoFactura, $resEvento->RespuestaListaEventos, $cafc_actual, $cuis->codigoCuis, $newcufd, $puntoventa->tipoEmision);


				$resVerifica = verificarRecepcionPaquete($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta, $siat->tipoDocumentoSector, $siat->tipoFactura, $resPaquete->RespuestaServicioFacturacion->codigoRecepcion, $cuis->codigoCuis, $newcufd);
			}

			$c0 = "UPDATE siat_punto_de_venta set tipoEmision = '1' WHERE id= '" . $puntoventa->id . "' ";
			$insert0 = $DB->consulta($c0);

			$c1 = "UPDATE siat_evento_significativo set estado = 'FINALIZADO', fechaFinEvento = '" . $ffinevento . "', codigoRecepcion = '" . $codrecepcion . "' , cufdEvento = '" . $newcufd . "' , codigoControlEvento = '" . $newcodcontrol . "' WHERE id='" . $idevento . "' ";
			$update1 = $DB->consulta($c1);

			$c2 = "UPDATE siat_factura sf set sf.xml = '1' WHERE tipoEmision = '2' ";
			$update2 = $DB->consulta($c2);

			$msj = "Se finalizo correctamente el Evento por: " . $descripcion;

			$resultado = array();
			$resultado["msj"] = $msj;
			$resultado["resEvento"] = $resEvento;
			$resultado["resPaquete"] = $resPaquete;
			$resultado["resVerifica"] = $resVerifica;
			$resultado["facturas"] = $facturas;
			$resultado["datos"] = $datos;
			break;
		case 'finEventoSignificativo':
			$datos = array();
			$resultado = array();
			$codrecepcion = '-';
			$resPaquete = '-';
			$idp = $body["ids"];
			$newcodigocufd = '-';

			// -------------------------- Recuperar Datos de PuntoVenta-Sucursal ------------------------------

			$c00 = "SELECT * FROM siat_punto_de_venta WHERE id = '" . $idp . "'";
			$puntoventa = $DB->consultaOne($c00);
			$tipoEmision = $puntoventa->tipoEmision;

			$c01 = "SELECT * FROM siat_sucursal WHERE nroSucursal = '" . $puntoventa->nroSucursal . "'";
			$sucursal = $DB->consultaOne($c01);

			// ------------------------------ Verificar Si existe Codigo CUIS --------------------------------

			$c02 = "SELECT * FROM siat_cuis WHERE fechaVigencia >= '" . $fechareg . "' and idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' ";
			$cuis = $DB->consultaOne($c02);
			if ($cuis == null) {
				$nmsj = "NO SE TIENE UN CODIGO CUIS VIGENTE";
				throw new Exception($nmsj);
			} else {
				$codcuis = $cuis->codigoCuis;
			}

			// ------------------------------ Verificar Conexion a Impuestos ----------------------------------

			$resConexion = conexionImpuestos();
			$codConexion = $resConexion->return->mensajesList->codigo;

			if ($codConexion != "926") {
				$nmsj = "NO HAY CONEXION A IMPUESTOS INTENTE CUANDO LA CONEXION SE HAYA RESTABLECIDO.";
				throw new Exception($nmsj);
			}

			// ------------------------------ Verificar Si existe Codigo CUFD --------------------------------

			$c03 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' order by id desc";
			$cufd = $DB->consultaOne($c03);
			if ($cufd == null) {
				$resCufd = obtenerCufd($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $codcuis, true);
				$c03_0 = "UPDATE siat_cufd set estado ='INACTIVO' WHERE idPuntoVenta = '" . $puntoventa->id . "' ";
				$update0 = $DB->consulta($c03_0);

				$fechaOriginal = $resCufd->RespuestaCufd->fechaVigencia;
				$fecha = new DateTime($fechaOriginal);
				$fechaFormateada = $fecha->format('Y-m-d H:i:s');

				$c03_1 = "INSERT INTO siat_cufd VALUES (NULL, '" . $puntoventa->id . "', now(), '" . $fechaFormateada . "', '" . $resCufd->RespuestaCufd->codigo . "', '" . $resCufd->RespuestaCufd->codigoControl . "', 'ACTIVO')";
				$insert0 = $DB->consulta($c03_1);

				$c03_2 = "SELECT * FROM siat_cufd WHERE fechaVigencia >= '" . $fechareg . "' AND idPuntoVenta = '" . $puntoventa->id . "' and estado = 'ACTIVO' order by id desc";
				$cufd_0 = $DB->consultaOne($c03_2);
				$codcufd = $cufd_0->codigoCufd;
				$codcontrol = $cufd_0->codigoControl;
			} else {
				$codcufd = $cufd->codigoCufd;
				$codcontrol = $cufd->codigoControl;
			}

			// ----------------------- Verificar Si existe evento significativo en proceso -----------------------
            
			$c03 = "SELECT * FROM siat_evento_significativo WHERE idPuntoVenta = '" . $puntoventa->id . "' and estado = 'EN PROCESO' ORDER BY id DESC ";
			$evento = $DB->consultaOne($c03);
			if ($evento == null) {
				$nmsj = "NO TIENE UN EVENTO SIGNIFICATIVO EN PROCESO";
				throw new Exception($nmsj);
			} else {
				$finievento = $evento->fechaInicioEvento;
				$codevento = $evento->codigoEvento;
				$idevento = $evento->id;
				$descripcion = $evento->descripcion;
			}
            
			// ------------------- Cantidad de facturas emitidas fuera de linea para enviar -----------------------

			$c04 = "SELECT count(*) as contador FROM siat_factura WHERE  fechaEmision >= '" . $finievento . "' and tipoEmision='2' and xml = '0'";
			$numeros = $DB->consultaOne($c04);
			$numfacturas = $numeros->contador;

			if ($numfacturas > 0) {

				if ($codevento <= 4) {
					$cafc_actual = null;
				} else {
					$cafc_actual = $siat->cafc;
				}

				$pvfechaInicio = date('Y-m-d\TH:i:s.v', strtotime($finievento));
				$pvfechaFin = date('Y-m-d\TH:i:s.v', strtotime($fechareg));

				// ------------------- Obtener codigo y descripcion del evento -----------------------

				$nevento = obtenerListadoEventos($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta, $codevento, $codcuis);

				// --------------------- Obtener nuevo cufd para el evento ---------------------------

				$resCufd = obtenerCufd($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $codcuis, true);
				$newcodigocontrol = $resCufd->RespuestaCufd->codigoControl;
				$newfechavigencia = $resCufd->RespuestaCufd->fechaVigencia;
				$newcodigocufd = $resCufd->RespuestaCufd->codigo;

				$c05 = "UPDATE siat_cufd set estado ='INACTIVO' WHERE 1";
				$update5 = $DB->consulta($c05);

				// ----------------- Se inserta el nuevo codigo cufd y se activa ---------------------

				$fechaOriginal = $resCufd->RespuestaCufd->fechaVigencia;
				$fecha = new DateTime($fechaOriginal);
				$fechaFormateada = $fecha->format('Y-m-d H:i:s');

				$c06 = "INSERT INTO siat_cufd VALUES (NULL, '" . $puntoventa->id . "', now(), '" . $fechaFormateada . "', '" . $newcodigocufd . "', '" . $newcodigocontrol . "', 'ACTIVO')";
				$insert6 = $DB->consulta($c06);
				
				

				// ------------------------ Se Registra el evento significativo -----------------------

				$resEvento = registroEvento($cuis->codigoCuis, $newcodigocufd, $puntoventa->nroSucursal, $puntoventa->nroPuntoVenta, $nevento, $codcufd, $pvfechaInicio, $pvfechaFin);

				$codrecepcion = $resEvento->RespuestaListaEventos->codigoRecepcionEventoSignificativo;
				

				// ------------------- Se obtiene todas las facturas no enviadas ----------------------

				$c07 = "SELECT * FROM siat_factura sf WHERE fechaEmision >= '" . $finievento . "' and sf.tipoEmision='2' and sf.xml = '0'";
				$resdatos = $DB->consultaAll($c07);

				for ($i = 0; $i < $resdatos["size"]; $i++) {
					$nidfact =  $resdatos["data"][$i]->id;
					$nitcliente = $resdatos["data"][$i]->numeroDocumento;
					$detalle = array();

					// ------------------------ Se obtiene datos del cliente --------------------------

					$c08 = "SELECT * FROM cliente WHERE nitCi = '" . $nitcliente . "'";
					$cliente = $DB->consultaOne($c08);
					$mailcliente = $cliente->email;
					$rzscliente = $cliente->razonSocial;



					$c09 = "SELECT * FROM siat_factura_item WHERE idFactura='" . $nidfact . "' ";
					$det = $DB->consultaAll($c09);
					for ($j = 0; $j < $det["size"]; $j++) {
						// ------------------- Se arma el xml del detalleFactura ----------------------
						$c10 = "select codigo from siat_sinc_unidades_medida where descripcion='" . $det["data"][$j]->unidadMedida . "'";
						$unids = $DB->consultaOne($c10);

						$esclavo = new stdClass();
						$esclavo->actividad				= $det["data"][$j]->actividadEconomica;
						$esclavo->codigosin				= $det["data"][$j]->codigoProductoSin;
						$esclavo->codigop				= $det["data"][$j]->codigoProducto;
						$esclavo->producto			    = $det["data"][$j]->descripcion;
						$esclavo->cantidad				= $det["data"][$j]->cantidad;
						$esclavo->unidadmedida			= $unids->codigo;
						$esclavo->preciounitario				= $det["data"][$j]->precioUnitario;
						$esclavo->descuento				= $det["data"][$j]->montoDescuento;
						$esclavo->subtotal				= $det["data"][$j]->subTotal;
						array_push($detalle, $esclavo);
					}
					$fechaEmision = date('Y-m-d\TH:i:s.v', strtotime($resdatos["data"][$i]->fecha . ' ' . $resdatos["data"][$i]->hora));

					if ($resdatos["data"][$i]->cafc == '') {
						$cafc = null;
					} else {
						$cafc = $resdatos["data"][$i]->cafc;
					}

					$maestro = new stdClass();
					$maestro->cufd 				= $resdatos["data"][$i]->cufd;
					$maestro->municipio        	= $resdatos["data"][$i]->municipio;
					$maestro->telefono			= $resdatos["data"][$i]->telefono;
					$maestro->numeroFactura		= $resdatos["data"][$i]->numeroFactura;
					$maestro->direccion			= $resdatos["data"][$i]->direccion;
					$maestro->fechaEmision		= $fechaEmision;
					$maestro->rzs				= xmlEscape($resdatos["data"][$i]->nombreRazonSocial);
					$maestro->tipodoc			= $resdatos["data"][$i]->codigoTipoDocumentoIdentidad;
					$maestro->nit				= $resdatos["data"][$i]->numeroDocumento;
					$maestro->codCliente		= $resdatos["data"][$i]->codigoCliente;
					$maestro->codigoMetodoPago	= $resdatos["data"][$i]->codigoMetodoPago;
					$maestro->leyenda			= $resdatos["data"][$i]->leyenda;
					$maestro->complemento		= $resdatos["data"][$i]->complemento;
					$maestro->codigoExcepcion	= $resdatos["data"][$i]->codigoExcepcion;
					$maestro->codigoMoneda		= $resdatos["data"][$i]->codigoMoneda;
					$maestro->numeroTarjeta 	= $resdatos["data"][$i]->numeroTarjeta;
					$maestro->montoTotal 		= $resdatos["data"][$i]->montoTotalSujetoIva;
					$maestro->nmontoTotal 		= $resdatos["data"][$i]->montoTotal;
					$maestro->descuentoAdicional = $resdatos["data"][$i]->descuentoAdicional;
					$maestro->montoGiftCard 	= $resdatos["data"][$i]->montoGiftCard;
					$maestro->tipoCambio		= $resdatos["data"][$i]->tipoCambio;
					$maestro->usr				= $resdatos["data"][$i]->usuario;
					$maestro->cuf				= $resdatos["data"][$i]->cuf;
					$maestro->cafc				= $resdatos["data"][$i]->cafc;
					$maestro->email				= $mailcliente;
					$maestro->cliente			= $rzscliente;
					$maestro->detalle 			= $detalle;

					array_push($datos, $maestro);
				}
				// ------------------- Se arma el xml general de las facturas para enviar ---------------------
                
				$facturas = newFacturas($puntoventa->nroPuntoVenta, $puntoventa->nroSucursal, $config->modalidad, $siat->tipoDocumentoSector, $puntoventa->tipoEmision, $siat->tipoFactura, $codcontrol, $codcufd, $cafc_actual, $datos);
                
				// ---------------------- Se envia el paquete de las facturas a enviar -------------------------

				$resPaquete =  enviarPaquetes($facturas, $codcontrol, $siat->tipoFactura, $resEvento->RespuestaListaEventos, $cafc_actual, $cuis->codigoCuis, $newcodigocufd, $puntoventa->tipoEmision);
                
				// -------------------- Se verifica el paquete de las facturas enviadas ------------------------

				$resVerifica = verificarRecepcionPaquete($puntoventa->nroSucursal, $puntoventa->nroPuntoVenta, $siat->tipoDocumentoSector, $siat->tipoFactura, $resPaquete->RespuestaServicioFacturacion->codigoRecepcion, $cuis->codigoCuis, $newcodigocufd);
			}
            
			$c11 = "UPDATE siat_punto_de_venta set tipoEmision = '1' WHERE id= '" . $puntoventa->id . "' ";
			$insert11 = $DB->consulta($c11);

			$c12 = "UPDATE siat_evento_significativo set estado = 'FINALIZADO', fechaFinEvento = '" . $fechareg . "', codigoRecepcion = '" . $codrecepcion . "', cufdEvento = '" . $newcodigocufd . "' ,codigoControlEvento = '" . $newcodigocontrol . "' WHERE id='" . $idevento . "' ";
			$update12 = $DB->consulta($c12);

			$c13 = "UPDATE siat_factura sf set sf.xml = '1' WHERE tipoEmision = '2' ";
			$update13 = $DB->consulta($c13);

			$msj = "Se finalizo correctamente el Evento por: " . $descripcion . " con " . $numfacturas . " facturas enviadas.";


			$resultado["codevento"] = $codevento;
			$resultado["msj"] = $msj;
			$resultado["resEvento"] = $resEvento;
			$resultado["resPaquete"] = $resPaquete;
			$resultado["resVerifica"] = $resVerifica;
			$resultado["datos"] = $datos;

			break;
		case 'loginCliente':
			$user = $body["usuario"];
			$pwd = $body["contrasena"];
			$c00 = "SELECT * FROM cliente WHERE email='" . $user . "' and nitCi='" . $pwd . "' ";
			$autentificacion = $DB->consultaAll($c00);
			if ($autentificacion["size"] > 0) {
				$sesion = '1';
				$_SESSION['ok'] = true;
				$_SESSION['codigo'] = 'c-' . $autentificacion["data"][0]->id;
				$_SESSION['correo'] = $autentificacion["data"][0]->email;
				$_SESSION['cliente'] = $autentificacion["data"][0]->razonSocial;
			} else {
				$sesion = '0';
			}
			$resultado = array();
			$resultado["sesion"] = $sesion;
			$resultado["aut"] = $autentificacion;
			$resultado["query"] = $c00;
			break;
	}

	/* ---------------------------------------------------- */
	$DB->commit();
	$DB->close();
	/* ---------------------------------------------------- */

	Response::sendOne($resultado);
} catch (Exception $e) {
	/* ---------------------------------------------------- */
	$DB->rollback();
	$DB->close();
	/* ---------------------------------------------------- */

	Response::sendError($e);
}
