s<?php
date_default_timezone_set("America/La_Paz");
header('Content-Type: text/html; charset=UTF-8');
include "../api.php";
require_once '../librerias/PHPExcel/Classes/PHPExcel.php';
try {

	$body = Response::getBody();
	error_reporting(0);

	/* ---------------------------------------------------- */
	$DB = new DB();
	$DB->conectar();
	$DB->begin();
	/* ---------------------------------------------------- */
	$fechareg = date("Y-m-d H:i:s");
	$newfecha = date("Y-m-d");
	$newhora = date("G:i:s");
	$funcion = $body["funcion"];
	switch ($funcion) {
		
			/* --------------------- Productos  ---------------------------- */
		case 'listarProductos':
			$c00 = "SELECT * from producto ";
			$productos = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["productos"] = $productos;
			break;
		
		case 'filtrarProductos':
			$productos = array();
			$idcategoria = $body["idcategoria"]; 
		
			if ($idcategoria == '0') {
				$c00 = "SELECT p.*, c.ID_CATEGORIA, i.LOTE, i.FECHA_VENCIMIENTO, SUM(i.CANTIDAD) AS STOCK FROM producto p INNER JOIN categoria c ON p.CATEGORIA = c.CATEGORIA INNER JOIN inventario i ON p.ID_PRODUCTO = i.ID_PRODUCTO WHERE i.CANTIDAD > 0 GROUP BY p.ID_PRODUCTO, i.LOTE, i.FECHA_VENCIMIENTO;";
			} else {
				$c00 = "SELECT p.*, c.ID_CATEGORIA, i.LOTE, i.FECHA_VENCIMIENTO, SUM(i.CANTIDAD) AS STOCK FROM producto p INNER JOIN categoria c ON p.CATEGORIA = c.CATEGORIA INNER JOIN inventario i ON p.ID_PRODUCTO = i.ID_PRODUCTO WHERE c.ID_CATEGORIA = '" . $idcategoria . "' AND i.CANTIDAD > 0 GROUP BY p.ID_PRODUCTO, i.LOTE, i.FECHA_VENCIMIENTO;";
			}
			$productosData = $DB->consultaAll($c00);
		
			for ($i = 0; $i < $productosData["size"]; $i++) {
				$productoData = $productosData["data"][$i];
		
				$detcmp = []; 

				if ($productoData->TIPO_PRODUCTO == "RECETA") {
					$cmp = explode(" - ", $productoData->COMPLEMENTOS);
					foreach ($cmp as $elemento) {
						$c01 = "SELECT * FROM complementos WHERE nombre ='" . $elemento . "'";
						$cmps = $DB->consultaOne($c01);
						if ($cmps) {
							$detcmp[] = $cmps; 
						}
					}
				}
				
				$producto = new stdClass();	
				$producto->ID_PRODUCTO       = $productoData->ID_PRODUCTO ?? null;
				$producto->CODIGO            = $productoData->CODIGO ?? '';
				$producto->CODIGO_ACTIVIDAD  = $productoData->CODIGO_ACTIVIDAD ?? '';
				$producto->CODIGO_SIN        = $productoData->CODIGO_SIN ?? '';
				$producto->UNIDAD_MEDIDA     = $productoData->UNIDAD_MEDIDA ?? '';
				$producto->CODIGO_BARRAS     = $productoData->CODIGO_BARRAS ?? '';
				$producto->NOMBRE            = $productoData->NOMBRE ?? '';
				$producto->NOMBRE_GENERICO   = $productoData->NOMBRE_GENERICO ?? '';
				$producto->TIPO_PRODUCTO     = $productoData->TIPO_PRODUCTO ?? '';
				$producto->CATEGORIA         = $productoData->CATEGORIA ?? '';
				$producto->MARCA             = $productoData->MARCA ?? '';
				$producto->STOCK             = $productoData->STOCK ?? '0';
				$producto->UNIDAD            = $productoData->UNIDAD ?? '';
				$producto->PRECIO_COMPRA     = $productoData->PRECIO_COMPRA ?? 0.0;
				$producto->PRECIO_VENTA      = $productoData->PRECIO_VENTA ?? 0.0;
				$producto->PRECIO_MAYOR      = $productoData->PRECIO_MAYOR ?? 0.0;
				$producto->PRECIO_ESPECIAL   = $productoData->PRECIO_ESPECIAL ?? 0.0;
				$producto->PRECIO_TOPE       = $productoData->PRECIO_TOPE ?? 0.0;
				$producto->DETALLE           = $productoData->DETALLE ?? '';
				$producto->IMAGEN            = $productoData->IMAGEN ?? 'noimage.png';
				$producto->STOCK_MINIMO      = $productoData->STOCK_MINIMO ?? 0;
				$producto->COMPLEMENTOS      = $productoData->COMPLEMENTOS ?? '';
				$producto->VENCIMIENTO       = $productoData->VENCIMIENTO ?? 'NO';
				$producto->ESTADO            = $productoData->ESTADO ?? 'ACTIVO';
				$producto->LOTE 		     = $productoData->LOTE ?? '0';
				$producto->FECHA_VENCIMIENTO = $productoData->FECHA_VENCIMIENTO ?? '000-00-00';
				$producto->ID_CATEGORIA      = $productoData->ID_CATEGORIA ?? null; // si hiciste JOIN con tabla `categoria`
				$producto->DET_CMP           = $detcmp ?? [];
				array_push($productos, $producto);
			}
		
			$resultado = array();
			$resultado["productos"] = $productos;
			break;
		case 'newProducto':
			$actividad = $body["actividad"];
			$umedida = $body["umedida"];
			$productosin = $body["productosin"];
			$stock = $body["stock"];
			$codigo = $body["codigo"];
			$generico = $body["generico"];
			$codigob = $body["codigob"];
			$descripcion = $body["descripcion"];
			$categoria = $body["categoria"];
			$nombre = $body["nombre"];
			$marca = $body["marca"];
			$unidad = $body["unidad"];
			$tipop = $body["tipop"];
			$pcompra = $body["precompra"];
			$pventa = $body["preventa"];
			$pmayor = $body["premayor"];
			$pespecial = $body["preespecial"];
			$ptope = $body["pretope"];

			$c00 = "SELECT COALESCE(MAX(ID_PRODUCTO) + 1, 1) AS maxid FROM producto";
			$res0 = $DB->consultaOne($c00);
			$idProducto = $res0->maxid;			

			$c01 = "INSERT INTO producto VALUES ('".$idProducto."', '" . $codigo . "', '" . $productosin . "','" . $actividad . "','" . $umedida . "','" . $codigob . "', '" . $nombre . "', '" . $generico . "', '" . $tipop . "', '" . $categoria . "','" . $marca . "', '" . $unidad . "', '" . $pcompra . "', '" . $pventa . "', '" . $pmayor . "', '" . $pespecial . "', '" . $ptope . "', '-', 'noimage.png','" . $stock . "', '','NO', 'ACTIVO');";
			$insertproducto = $DB->consulta($c01);

			$c02 = "INSERT INTO producto_imagen VALUES (default,'$idProducto', 'noimage.png', 'PORTADA');";
			$insertImgProducto = $DB->consulta($c02);

			$resultado = array();
			$resultado["ok"] = $insertproducto;
			break;
		case 'cambiarEstadoProducto':
			$idproducto = $body["idproducto"];
			$estado = $body["estado"];
			$nestado = ($estado == 'ACTIVO') ? 'INACTIVO' : 'ACTIVO';

			$c00 = "UPDATE producto SET estado = '" . $nestado . "' WHERE id_producto = '" . $idproducto . "'";
			$updProducto = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $updProducto;
			break;
		case 'cambiarEstadoVencimiento':
			$idproducto = $body["idproducto"];
			$vencimiento = $body["vencimiento"];
			$nvencimiento = ($estado == 'SI') ? 'NO' : 'SI';

			$c00 = "UPDATE producto SET vencimiento = '" . $nvencimiento . "' WHERE id_producto = '" . $idproducto . "'";
			$updProducto = $DB->consulta($c00);

			$resultado = array();
			$resultado["ok"] = $updProducto;
			break;

		case 'cargarExcelProducto':
			$detalle = array();
			$excel = $body["excel"];
			$archivo = "../../archivos/excel/" . $excel;
			$inputFileType = PHPExcel_IOFactory::identify($archivo);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($archivo);
			$sheet = $objPHPExcel->getSheet(0);
			$highestRow = $sheet->getHighestRow();
			$highestColumn = $sheet->getHighestColumn();
		
			for ($row = 2; $row <= $highestRow; $row++) {
				$codigoProducto = addslashes($sheet->getCell("A" . $row)->getValue());
				$codigoActividad = addslashes($sheet->getCell("B" . $row)->getValue());
				$codigoSin = addslashes($sheet->getCell("C" . $row)->getValue());
				$unidadMedida = addslashes($sheet->getCell("D" . $row)->getValue());
				$codigoBarras = addslashes($sheet->getCell("E" . $row)->getValue());
				$nombre = addslashes($sheet->getCell("F" . $row)->getValue());
				$tipoProducto = addslashes($sheet->getCell("G" . $row)->getValue());
				$categoria = addslashes($sheet->getCell("H" . $row)->getValue());
				$marca = addslashes($sheet->getCell("I" . $row)->getValue());
				$unidad = addslashes($sheet->getCell("J" . $row)->getValue());
				$precioCompra = floatval($sheet->getCell("K" . $row)->getValue());
				$precioVenta = floatval($sheet->getCell("L" . $row)->getValue());
				$precioMayor = floatval($sheet->getCell("M" . $row)->getValue());
				$precioEspecial = floatval($sheet->getCell("N" . $row)->getValue());
				$precioTope = floatval($sheet->getCell("O" . $row)->getValue());
				$vencimiento = addslashes($sheet->getCell("P" . $row)->getValue());
				$generico = addslashes($sheet->getCell("Q" . $row)->getValue());
		
				$c08 = "SELECT COALESCE(MAX(ID_PRODUCTO) + 1, 1) AS maxid FROM producto";
				$res8 = $DB->consultaOne($c08);
				$idProducto = $res8->maxid;
		
				$c01 = "INSERT INTO producto (ID_PRODUCTO, CODIGO, CODIGO_ACTIVIDAD, CODIGO_SIN, UNIDAD_MEDIDA, CODIGO_BARRAS, NOMBRE, NOMBRE_GENERICO, TIPO_PRODUCTO, CATEGORIA, MARCA, UNIDAD, PRECIO_COMPRA, PRECIO_VENTA, PRECIO_MAYOR, PRECIO_ESPECIAL, PRECIO_TOPE, DETALLE, IMAGEN, STOCK_MINIMO, COMPLEMENTOS, VENCIMIENTO, ESTADO) VALUES ('$idProducto', '$codigoProducto', '$codigoActividad', '$codigoSin', '$unidadMedida', '$codigoBarras', '$nombre', '$generico', '$tipoProducto', '$categoria', '$marca', '$unidad', '$precioCompra', '$precioVenta', '$precioMayor', '$precioEspecial', '$precioTope', '-', 'noimage.png', '0', '-', '$vencimiento', 'ACTIVO');";
		
				$insertproducto = $DB->consulta($c01);

				$c02 = "INSERT INTO producto_imagen VALUES (default,'$idProducto', 'noimage.png', 'PORTADA');";
				$insertImgProducto = $DB->consulta($c02);
			}
		
			$resultado = array();
			$resultado["row"] = $highestRow;
			$resultado["insert"] = $insertproducto;
			break;
		case 'editProducto':
			$imagenes = array();
			$id = $body["idproducto"];
			$valor = $body["valor"];
			$c00 = "SELECT max(id_producto) as max FROM producto";
			$maximo = $DB->consultaOne($c00);
			$maxid = $maximo->max;
			$c01 = "SELECT min(id_producto) as min FROM producto";
			$minimo = $DB->consultaOne($c01);
			$minid = $minimo->min;
			if ($id == '0') {
				if ($valor == 0) {
					$c00 = "SELECT * FROM producto ORDER BY id_producto DESC LIMIT 1";
				}
			} else {
				if ($valor == 0) {
					$c00 = "SELECT * FROM producto WHERE id_producto = '" . $id . "'";
				}
				if ($valor == 1) {
					$c00 = "SELECT * FROM producto WHERE id_producto = '" . $minid . "'";
				}
				if ($valor == 2) {
					$valid = intval($id) - 1;
					if ($valid >= $minid) {
						$nid = $valid;
					} else {
						$nid = $minid;
					}
					$c00 = "SELECT * FROM producto WHERE id_producto = '" . $nid . "'";
				}
				if ($valor == 3) {
					$valid = intval($id) + 1;
					if ($valid <= $maxid) {
						$nid = $valid;
					} else {
						$nid = $maxid;
					}
					$c00 = "SELECT * FROM producto WHERE id_producto = '" . $nid . "'";
				}
				if ($valor == 4) {
					$c00 = "SELECT * FROM producto WHERE id_producto = '" . $maxid . "'";
				}
			}

			$producto = $DB->consultaOne($c00);

			$nimg = "../../img/Producto/" . $producto->IMAGEN;
			$img = existeImagen($nimg);
			$producto->IMAGEN = $img;
			$c01 = "SELECT * from producto_imagen where id_producto ='" . $producto->ID_PRODUCTO . "' order by TIPO desc";
			$imgs = $DB->consultaAll($c01);
			for ($i = 0; $i < $imgs["size"]; $i++) {

				$nomImagen = "../../img/Producto/" . $imgs["data"][$i]->IMAGEN;

				$srcimg = existeImagen($nomImagen);

				$detItems = new stdClass();
				$detItems->ID_IMAGEN = $imgs["data"][$i]->ID_IMAGEN;
				$detItems->ID_PRODUCTO = $imgs["data"][$i]->ID_PRODUCTO;
				$detItems->IMAGEN = $srcimg;
				$detItems->TIPO = $imgs["data"][$i]->TIPO;
				array_push($imagenes, $detItems);
			}
			$resultado = array();
			$resultado["producto"] = $producto;
			$resultado["imagenes"] = $imagenes;
			break;

		case 'datosImagenesProducto':
			$sucursales = array();
			$ventas = array();
			$imagenes = array();
			$id = $body["idproducto"];
			$c00 = "SELECT * from producto_imagen where  id_producto ='" . $id . "' ";
			$imgs = $DB->consultaAll($c00);
			for ($i = 0; $i < $imgs["size"]; $i++) {

				$nomImagen = "../../img/Producto/" . $imgs["data"][$i]->IMAGEN;

				$srcimg = existeImagen($nomImagen);

				$detItems = new stdClass();
				$detItems->ID_IMAGEN = $imgs["data"][$i]->ID_IMAGEN;
				$detItems->ID_PRODUCTO = $imgs["data"][$i]->ID_PRODUCTO;
				$detItems->IMAGEN = $srcimg;
				$detItems->TIPO = $imgs["data"][$i]->TIPO;
				array_push($imagenes, $detItems);
			}
			$c01 = "SELECT * from producto where id_producto ='" . $id . "'";
			$producto = $DB->consultaOne($c01);

			$c02 = "SELECT * FROM sucursal";
			$sucs = $DB->consultaAll($c02);
			for ($i = 0; $i < $sucs["size"]; $i++) {
				$idsuc = $sucs["data"][$i]->ID_SUCURSAL;

				$c03 = "select sum(cantidad) as stock from inventario where id_sucursal='" . $idsuc . "' and id_producto='" . $id . "'";
				$res = $DB->consultaOne($c03);
				if ($res->stock == null || $res->stock == "") {
					$stk = 0;
				} else {
					$stk = $res->stock;
				}
				$detItems = new stdClass();
				$detItems->sucursal = $sucs["data"][$i]->SUCURSAL;
				$detItems->stock = $stk;

				array_push($sucursales, $detItems);
			}

			$c02 = "SELECT year(v.fecha_registro) as anio FROM venta_detalle vd , ventas v where vd.id_venta = v.id_venta and vd.id_producto = '" . $id . "'";
			$vens = $DB->consultaAll($c02);
			for ($i = 0; $i < $vens["size"]; $i++) {
				$anio = $vens["data"][$i]->anio;

				$c03 = "SELECT sum(vd.cantidad) as venta FROM venta_detalle vd , ventas v where vd.id_venta = v.id_venta and vd.id_producto = '" . $id . "' and year(v.fecha_registro) = '" . $anio . "' group by vd.id_producto";
				$res1 = $DB->consultaOne($c03);
				if ($res1->venta == null || $res1->venta == "") {
					$ven = 0;
				} else {
					$ven = $res1->venta;
				}
				$detVen = new stdClass();
				$detVen->anio = $anio;
				$detVen->venta = $ven;

				array_push($ventas, $detVen);
			}

			$resultado = array();
			$resultado["imagenes"] = $imagenes;
			$resultado["producto"] = $producto;
			$resultado["sucursales"] = $sucursales;
			$resultado["ventas"] = $ventas;
			break;
		
		case 'updProducto':
			$id = $body["idproducto"];
			$codigo = $body["codigo"];
			$codigob = $body["codigob"];
			$nombre = $body["nombre"];
			$generico = $body["generico"];
			$categoria = $body["categoria"];
			$marca = $body["marca"];
			$unidad = $body["unidad"];
			$pcompra = $body["precompra"];
			$pventa = $body["preventa"];
			$pmayor = $body["premayor"];
			$pespecial = $body["preespecial"];
			$ptope = $body["pretope"];
			$actividad = $body["actividad"];
			$codigosin = $body["codigosin"];
			$unidadmedida = $body["unidadmedida"];
			$stock = $body["stock"];
			$tipo = $body["tipo"];
			$complemento = $body["complemento"];
			$complemento = implode(" - ", $complemento);

			$c00 = "UPDATE producto set codigo = '" . $codigo . "' , codigo_actividad='" . $actividad . "' , codigo_sin='" . $codigosin . "', unidad_medida='" . $unidadmedida . "', codigo_barras = '" . $codigob . "',  categoria = '" . $categoria . "' , nombre = '" . $nombre . "' , nombre_generico = '" . $generico . "' , marca = '" . $marca . "' , unidad = '" . $unidad . "' , precio_compra = '" . $pcompra . "', precio_venta = '" . $pventa . "', precio_mayor = '" . $pmayor . "', precio_especial = '" . $pespecial . "', precio_tope = '" . $ptope . "', stock_minimo = '" . $stock . "', tipo_producto = '" . $tipo . "', complementos = '" . $complemento . "'  WHERE id_producto = '" . $id . "';";
			$updproducto = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updproducto;
			break;
		case 'irProducto':
			$imagenes = array();
			$idproducto = $body["idproducto"];

			$c00 = "SELECT * from producto where id_producto ='" . $id_producto . "'";
			$producto = $DB->consultaOne($c00);
			if ($producto == null) {
				$nmsj = "No se encontro ningun producto con el codigo: " . $codigo;
				throw new Exception($nmsj);
			}
			$nimg = "../../img/Producto/" . $producto->IMAGEN;
			$img = existeImagen($nimg);
			$producto->IMAGEN = $img;
			$c01 = "SELECT * from producto_imagen where id_producto ='" . $producto->ID_PRODUCTO . "' ";
			$imgs = $DB->consultaAll($c01);
			for ($i = 0; $i < $imgs["size"]; $i++) {

				$nomImagen = "../../img/Producto/" . $imgs["data"][$i]->IMAGEN;

				$srcimg = existeImagen($nomImagen);

				$detItems = new stdClass();
				$detItems->ID_IMAGEN = $imgs["data"][$i]->ID_IMAGEN;
				$detItems->ID_PRODUCTO = $imgs["data"][$i]->ID_PRODUCTO;
				$detItems->IMAGEN = $srcimg;
				$detItems->TIPO = $imgs["data"][$i]->TIPO;
				array_push($imagenes, $detItems);
			}
			$resultado = array();
			$resultado["producto"] = $producto;
			$resultado["imagenes"] = $imagenes;
			break;
		case 'updContProducto':
			$id = $body["idproducto"];
			$contenido = $body["contenido"];

			$c00 = "UPDATE producto set detalle = '" . $contenido . "'  WHERE id_producto = '" . $id . "';";
			$updproducto = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $updproducto;
			$resultado["query"] = $c00;
			break;
		case 'deleteProducto':
			$id = $body["id"];
			$c00 = " delete from producto where id_producto ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
		case 'datosImagenesProducto':
			$id = $body["idproducto"];
			$c00 = "SELECT * from producto_imagen where  id_producto ='" . $id . "' ";
			$imagenes = $DB->consultaAll($c00);
			$c01 = "SELECT * from producto where id_producto ='" . $id . "'";
			$producto = $DB->consultaOne($c01);
			$resultado = array();
			$resultado["imagenes"] = $imagenes;
			$resultado["producto"] = $producto;
			break;
		case 'cambiarPortada':
			$id = $body["idproducto"];
			$idimg = $body["idimg"];
			$c00 = "UPDATE producto_imagen set tipo = 'NORMAL'  WHERE id_producto = '" . $id . "';";
			$updproducto = $DB->consulta($c00);
			$c01 = "UPDATE producto_imagen set tipo = 'PORTADA'  WHERE id_imagen = '" . $idimg . "';";
			$updimg = $DB->consulta($c01);
			$c02 = "SELECT * from producto_imagen where id_imagen = '" . $idimg . "' ";
			$prd_img = $DB->consultaOne($c02);
			$c04 = "UPDATE producto set imagen='" . $prd_img->IMAGEN . "'  WHERE id_producto = '" . $id . "';";
			$updprod = $DB->consulta($c04);

			$resultado = array();
			$resultado["imagenes"] = $imagenes;
			break;
		case 'deleteItemImagen':
			$id = $body["idimg"];
			$c00 = " delete from producto_imagen where id_imagen ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
			/* --------------------- Ventas ---------------------------- */
		case 'listarVentas':
			$ventas = array();
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			
			$c02 = "SELECT v.ARQUEO, v.ID_FACTURA, v.ID_VENTA,v.FECHA_REGISTRO, v.BOLETA,v.TIPO_VENTA, v.CONCEPTO, v.CANTIDAD, v.PRECIO_TOTAL, v.ESTADO, c.razonSocial AS NOMBRES, c.nitCi AS CI, c.telefono AS TELEFONO , c.complemento AS COMPLEMENTO FROM ventas v JOIN cliente c ON v.ID_CLIENTE = c.id WHERE v.ID_SUCURSAL = '" . $idsucursal . "' AND DATE(v.FECHA_REGISTRO) >= '" . $fini . "' AND DATE(v.FECHA_REGISTRO) <= '" . $ffin . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c02 .= " AND v.id_user = '" . $iduser . "'";
			}

			$c02 .= " ORDER BY v.ID_VENTA DESC";

			$ventasData = $DB->consultaAll($c02);
		
			for ($j = 0; $j < $ventasData["size"]; $j++) {
				$c03 = "SELECT IFNULL(SUM(monto), 0) AS totalPagos FROM pagos WHERE id_venta = '" . $ventasData["data"][$j]->ID_VENTA . "'";
				$pagos = $DB->consultaOne($c03);
		
				$detitem = new stdClass();
				$detitem->FECHA_REGISTRO = $ventasData["data"][$j]->FECHA_REGISTRO;
				$detitem->ID_VENTA = $ventasData["data"][$j]->ID_VENTA;
				$detitem->ID_FACTURA = $ventasData["data"][$j]->ID_FACTURA;
				$detitem->ID_ARQUEO = $ventasData["data"][$j]->ARQUEO;
				$detitem->BOLETA = $ventasData["data"][$j]->BOLETA;
				$detitem->TIPO_VENTA = $ventasData["data"][$j]->TIPO_VENTA;
				$detitem->CONCEPTO = $ventasData["data"][$j]->CONCEPTO;
				$detitem->CANTIDAD = $ventasData["data"][$j]->CANTIDAD;
				$detitem->PRECIO_TOTAL = $ventasData["data"][$j]->PRECIO_TOTAL;
				$detitem->ESTADO = $ventasData["data"][$j]->ESTADO;
				$detitem->NOMBRES = $ventasData["data"][$j]->NOMBRES;
				$detitem->ESCUELA = $ventasData["data"][$j]->ESCUELA;
				$detitem->CI = $ventasData["data"][$j]->CI;
				$detitem->TELEFONO = $ventasData["data"][$j]->TELEFONO;
				$detitem->TOTAL_PAGOS = $pagos->totalPagos;
				$detitem->SALDO = number_format($ventasData["data"][$j]->PRECIO_TOTAL - $pagos->totalPagos, 2);
		
				array_push($ventas, $detitem);
			}
		
			$resultado = array();
			$resultado["ventas"] = $ventas;
			$resultado["query"] = $c02;
			break;
		case 'realizarVenta':
			$detalle = $body["detalle"];
			$concepto = $body["concepto"];
			$precio = $body["precio"];
			$cantidad = $body["cantidad"];
			$tipopago = $body["tipopago"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$idfactura = $body["idfactura"];
		
			$idcli = $body["idcli"];
			$nit = $body["nit"];
			$rzs = $body["rzs"];
			$mail = isset($body["mail"]) && !empty($body["mail"]) ? $body["mail"] : "farmacia.especializadajg@gmail.com";
			$cmp = $body["cmp"];
		
			// Obtener el ID de venta máximo
			$c00 = "SELECT IFNULL(MAX(id_venta) + 1, 1) AS maxid FROM ventas;";
			$selectRes = $DB->consultaOne($c00);
			$idven = $selectRes->maxid;
		
			// Verificar si existe un arqueo iniciado para la sucursal y usuario
			$c01 = "SELECT id_arqueo FROM arqueo WHERE id_sucursal='" . $idsucursal . "' AND id_user = '" . $iduser . "' AND estado = 'INICIADO'";
			$arqueo = $DB->consultaOne($c01);
			$idarqueo = $arqueo->id_arqueo;
			if ($idarqueo == null) {
				$nmsj = "NO SE TIENE ARQUEO INICIADO NO SE PUEDE REALIZAR VENTAS.";
				throw new Exception($nmsj);
			}
		
			if ($idcli == '0') {
				$c_check = "SELECT id FROM cliente WHERE nitCi = '$nit' LIMIT 1";
				$cliente_existente = $DB->consultaOne($c_check);

				if ($cliente_existente) {
					$idcli = $cliente_existente->id;

					$c_update = "UPDATE cliente SET razonSocial = '$rzs', email = '$mail', complemento = '$cmp' WHERE id = '$idcli'";
					$DB->consulta($c_update);
				} else {
					$c01_0 = "SELECT IFNULL(MAX(id) + 1, 1) AS maxnro FROM cliente";
					$numcli = $DB->consultaOne($c01_0);
					$idcli = $numcli->maxnro;

					$c01_2 = "INSERT INTO cliente VALUES ('$idcli', '$rzs', '$nit', '', '$mail', '$cmp', 'ACTIVO')";
					$DB->consulta($c01_2);
				}
			} else {
				$c01_3 = "UPDATE cliente SET nitCi = '$nit', razonSocial = '$rzs', email = '$mail', complemento = '$cmp' WHERE id = '$idcli'";
				$DB->consulta($c01_3);
			}

			$c02 = "SELECT IFNULL(MAX(boleta) + 1, 1) AS boleta FROM ventas WHERE id_sucursal = '" . $idsucursal . "'";
			$selectRes2 = $DB->consultaOne($c02);
			$bol = $selectRes2->boleta;
		
			$c03 = "INSERT INTO ventas VALUES ('" . $idven . "', '" . $idsucursal . "', '" . $idcli . "', '" . $iduser . "', now(), '" . $bol . "', '" . $tipopago . "', '" . $concepto . "', '" . $cantidad . "', '" . $precio . "', '" . $idfactura . "', '" . $idarqueo . "', 'CONFIRMADO')";
			$insertVentas = $DB->consulta($c03);

			foreach ($detalle as $k => $det) {
				$itmfinal =  $det->pfinal;
				$itmventa =  $det->pventa;
				$itmcantidad = $det->cantidad;
				$itmproducto = $det->nombre;
				$itmcompra = $det->pcompra;
				$ptope = $det->ptope;
				$pespecial = $det->pespecial;
				$pmayor = $det->pmayor;
				$itmidp = $det->idp;
				$itmunid = $det->unidad;
				$fvencimiento = $det->fvencimiento;
				$lote = $det->lote;

				if ($itmunid == 'UNIDAD') {
					for ($j = 0; $j < $itmcantidad; $j++) {
						$c04= "select min(ID_INVENTARIO) as idi from inventario where id_producto = '".$itmidp."' AND leido = '".$iduser."' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
						$res4 = $DB->consultaOne($c04);
						$idinv = $res4->idi;

						$c05 = "INSERT INTO venta_detalle VALUES (default, '" . $idven . "', '" . $itmidp . "', '".$idinv."', '" . $itmproducto . "', '1', '" . $itmfinal . "', '" . $lote . "', '" . $fvencimiento . "')";
						$insertDetVentas = $DB->consulta($c05);

						$c06 = "UPDATE inventario set cantidad ='0' WHERE id_inventario = '".$idinv."';";
						$updinv = $DB->consulta($c06);
					}
				} else {
					
					$c04= "select min(ID_INVENTARIO) as idi, cantidad from inventario where id_producto = '".$itmidp."' AND leido = '0' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
					$res4 = $DB->consultaOne($c04);
					$idinv = $res4->idi;
					if ($res4) {
						if ($res4->cantidad >= $itmcantidad) {
							$c05 = "INSERT INTO venta_detalle VALUES (default, '" . $idven . "', '" . $itmidp . "', '".$idinv."', '" . $itmproducto . "', '".$itmcantidad."', '" . $itmfinal . "', '" . $lote . "', '" . $fvencimiento . "')";
							$insertDetVentas = $DB->consulta($c05);

							$c06 = "UPDATE inventario SET cantidad = (cantidad - " . $itmcantidad . ") WHERE id_inventario = '" . $res4->idi . "'";
							$updinv = $DB->consulta($c06);
						} else {
							$nmsj = "NO HAY STOCK DISPONIBLE PARA EL PRODUCTO SOLICITADO.";
							throw new Exception($nmsj);
						}
					}
				}
				
			}
		
			// Devolver el ID de la venta realizada
			$resultado = array();
			$resultado["idven"] = $idven;
			break;
		case 'realizarVentaVeco':
			$detalle = $body["detalle"];
			$concepto = $body["concepto"];
			$precio = $body["precio"];
			$cantidad = $body["cantidad"];
			$tipopago = $body["tipopago"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$idfactura = $body["idfactura"];
		
			$idcli = $body["idcli"];
		
			// Obtener el ID de venta máximo
			$c00 = "SELECT IFNULL(MAX(id_venta) + 1, 1) AS maxid FROM ventas;";
			$selectRes = $DB->consultaOne($c00);
			$idven = $selectRes->maxid;
		
			// Verificar si existe un arqueo iniciado para la sucursal y usuario
			$c01 = "SELECT id_arqueo FROM arqueo WHERE id_sucursal='" . $idsucursal . "' AND id_user = '" . $iduser . "' AND estado = 'INICIADO'";
			$arqueo = $DB->consultaOne($c01);
			$idarqueo = $arqueo->id_arqueo;
			if ($idarqueo == null) {
				$nmsj = "NO SE TIENE ARQUEO INICIADO NO SE PUEDE REALIZAR VENTAS.";
				throw new Exception($nmsj);
			}
		
			$c02 = "SELECT IFNULL(MAX(boleta) + 1, 1) AS boleta FROM ventas WHERE id_sucursal = '" . $idsucursal . "'";
			$selectRes2 = $DB->consultaOne($c02);
			$bol = $selectRes2->boleta;
		
			$c03 = "INSERT INTO ventas VALUES ('" . $idven . "', '" . $idsucursal . "', '" . $idcli . "', '" . $iduser . "', now(), '" . $bol . "', '" . $tipopago . "', '" . $concepto . "', '" . $cantidad . "', '" . $precio . "', '" . $idfactura . "', '" . $idarqueo . "', 'CONFIRMADO')";
			$insertVentas = $DB->consulta($c03);

			foreach ($detalle as $k => $det) {
				$itmfinal =  $det->pfinal;
				$itmventa =  $det->pventa;
				$itmcantidad = $det->cantidad;
				$itmproducto = $det->nombre;
				$itmcompra = $det->pcompra;
				$ptope = $det->ptope;
				$pespecial = $det->pespecial;
				$pmayor = $det->pmayor;
				$itmidp = $det->idp;
				$itmunid = $det->unidad;
				$fvencimiento = $det->fvencimiento;
				$lote = $det->lote;

				if ($itmunid == 'UNIDAD') {
					for ($j = 0; $j < $itmcantidad; $j++) {
						$c04= "select min(ID_INVENTARIO) as idi from inventario where id_producto = '".$itmidp."' AND leido = '".$iduser."' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
						$res4 = $DB->consultaOne($c04);
						$idinv = $res4->idi;

						$c05 = "INSERT INTO venta_detalle VALUES (default, '" . $idven . "', '" . $itmidp . "', '".$idinv."', '" . $itmproducto . "', '1', '" . $itmfinal . "', '" . $lote . "', '" . $fvencimiento . "')";
						$insertDetVentas = $DB->consulta($c05);

						$c06 = "UPDATE inventario set cantidad ='0' WHERE id_inventario = '".$idinv."';";
						$updinv = $DB->consulta($c06);
					}
				} else {
					
					$c04= "select min(ID_INVENTARIO) as idi, cantidad from inventario where id_producto = '".$itmidp."' AND leido = '0' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
					$res4 = $DB->consultaOne($c04);
					$idinv = $res4->idi;
					if ($res4) {
						if ($res4->cantidad >= $itmcantidad) {
							$c05 = "INSERT INTO venta_detalle VALUES (default, '" . $idven . "', '" . $itmidp . "', '".$idinv."', '" . $itmproducto . "', '".$itmcantidad."', '" . $itmfinal . "', '" . $lote . "', '" . $fvencimiento . "')";
							$insertDetVentas = $DB->consulta($c05);

							$c06 = "UPDATE inventario SET cantidad = (cantidad - " . $itmcantidad . ") WHERE id_inventario = '" . $res4->idi . "'";
							$updinv = $DB->consulta($c06);
						} else {
							$nmsj = "NO HAY STOCK DISPONIBLE PARA EL PRODUCTO SOLICITADO.";
							throw new Exception($nmsj);
						}
					}
				}
				
			}
		
			// Devolver el ID de la venta realizada
			$resultado = array();
			$resultado["idven"] = $idven;
			break;
		case 'modificarVenta':
			$detalle = $body["detalle"];
			$concepto = $body["concepto"];
			$precio = $body["precio"];
			$cantidad = $body["cantidad"];
			$tipopago = $body["tipopago"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$idventa = $body["idventa"];
			$idfactura = $body["idfactura"];
		
			$idcli = $body["idcli"];
		
			// Obtener el ID de venta máximo
			$c00 = "DELETE FROM venta_detalle WHERE id_venta='" . $idventa . "'";
			$delete = $DB->consulta($c00);

			$c01 = "update ventas  set  concepto ='" . $concepto . "', cantidad = '" . $cantidad . "', precio_total = " . $precio . " WHERE id_venta='" . $idventa . "' ";
			$update = $DB->consulta($c01);
		

			foreach ($detalle as $k => $det) {
				$itmfinal =  $det->pfinal;
				$itmventa =  $det->pventa;
				$itmcantidad = $det->cantidad;
				$itmproducto = $det->nombre;
				$itmcompra = $det->pcompra;
				$ptope = $det->ptope;
				$pespecial = $det->pespecial;
				$pmayor = $det->pmayor;
				$itmidp = $det->idp;
				$itmunid = $det->unidad;
				$fvencimiento = $det->fvencimiento;
				$lote = $det->lote;

				if ($itmunid == 'UNIDAD') {
					for ($j = 0; $j < $itmcantidad; $j++) {
						$c04= "select min(ID_INVENTARIO) as idi from inventario where id_producto = '".$itmidp."' AND leido = '".$iduser."' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
						$res4 = $DB->consultaOne($c04);
						$idinv = $res4->idi;

						$c05 = "INSERT INTO venta_detalle VALUES (default, '" . $idventa . "', '" . $itmidp . "', '".$idinv."', '" . $itmproducto . "', '1', '" . $itmfinal . "', '" . $lote . "', '" . $fvencimiento . "')";
						$insertDetVentas = $DB->consulta($c05);

						$c06 = "UPDATE inventario set cantidad ='0' WHERE id_inventario = '".$idinv."';";
						$updinv = $DB->consulta($c06);
					}
				} else {
					
					$c04= "select min(ID_INVENTARIO) as idi, cantidad from inventario where id_producto = '".$itmidp."' AND leido = '0' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
					$res4 = $DB->consultaOne($c04);
					$idinv = $res4->idi;
					if ($res4) {
						if ($res4->cantidad >= $itmcantidad) {
							$c05 = "INSERT INTO venta_detalle VALUES (default, '" . $idventa . "', '" . $itmidp . "', '".$idinv."', '" . $itmproducto . "', '".$itmcantidad."', '" . $itmfinal . "', '" . $lote . "', '" . $fvencimiento . "')";
							$insertDetVentas = $DB->consulta($c05);

							$c06 = "UPDATE inventario SET cantidad = (cantidad - " . $itmcantidad . ") WHERE id_inventario = '" . $res4->idi . "'";
							$updinv = $DB->consulta($c06);
						} else {
							$nmsj = "NO HAY STOCK DISPONIBLE PARA EL PRODUCTO SOLICITADO.";
							throw new Exception($nmsj);
						}
					}
				}
				
			}
		
			// Devolver el ID de la venta realizada
			$resultado = array();
			$resultado["idven"] = $idventa;
			break;	

		case 'verBoletaVenta':
			$id = $body["id"];
			$c00 = "SELECT v.BOLETA, v.FECHA_REGISTRO, v.CONCEPTO, v.CANTIDAD, v.PRECIO_TOTAL, v.ID_USER, v.ID_SUCURSAL, c.razonSocial as CLIENTE FROM ventas v , cliente c where v.id_cliente = c.id  and id_venta ='" . $id . "'";
			$venta = $DB->consultaOne($c00);
			$c01 = "SELECT sum(vd.cantidad) as CANTIDAD, sum(vd.precio_venta) as PRECIO_VENTA, vd.precio_venta as PRECIO_UNITARIO, p.ID_PRODUCTO, P.NOMBRE, P.CODIGO from venta_detalle vd , producto p where p.id_producto = vd.id_producto and vd.id_venta ='" . $id . "' group by vd.id_producto;";
			$dets = $DB->consultaAll($c01);
			$c02 = "SELECT * from sucursal where id_sucursal ='" . $venta->ID_SUCURSAL . "'";
			$sucursal = $DB->consultaOne($c02);
			$c03 = "SELECT * from user where id_user ='" . $venta->ID_USER . "'";
			$usuario = $DB->consultaOne($c03);
			$resultado = array();
			$resultado["venta"] = $venta;
			$resultado["dets"] = $dets;
			$resultado["usuario"] = $usuario;
			$resultado["sucursal"] = $sucursal;
			break;
		case 'editarVenta':
			$id = $body["idventa"];
			$c00 = "SELECT * from ventas  where id_venta ='" . $id . "'";
			$venta = $DB->consultaOne($c00);

			$c02 = "SELECT ID_PRODUCTO, ID_INVENTARIO, CANTIDAD, LOTE FROM venta_detalle WHERE ID_VENTA = '".$id."'";
			$detalles = $DB->consultaAll($c02);
		
			for ($j = 0; $j < $detalles["size"]; $j++) {
				$detallesData = $detalles["data"][$j];
				$idProducto = $detallesData->ID_PRODUCTO;
				$idInventario = $detallesData->ID_INVENTARIO;
				$cantidad = $detallesData->CANTIDAD;
		
				$c03 = "UPDATE inventario SET cantidad =  '".$cantidad."', leido = '0'  WHERE ID_INVENTARIO = '".$idInventario."' ";
				$updateInventario=  $DB->consulta($c03);
			}

			$resultado = array();
			$resultado["venta"] = $venta;
			$resultado["detalles"] = $detalles;
			$resultado["query"] = $c03;
			break;
		case 'anularVenta':
			$idarqueo = $body["idarqueo"];
			$idventa = $body["idventa"];
		
			$c00 = "SELECT estado FROM arqueo WHERE id_arqueo = '".$idarqueo."'";
			$arqueo = $DB->consultaOne($c00);
		
			if ($arqueo->estado == 'TERMINADO') {
				throw new Exception("NO SE PUEDE HACER UNA ANULACIÓN DE UNA VENTA QUE HA SIDO ARQUEADA.");
			}
		
			$c01 = "UPDATE ventas SET ESTADO = 'ANULADO' WHERE ID_VENTA = '".$idventa."'";
			$updateVenta = $DB->consulta($c01);
		
			$c02 = "SELECT ID_PRODUCTO, ID_INVENTARIO, CANTIDAD FROM venta_detalle WHERE ID_VENTA = '".$idventa."'";
			$detalles = $DB->consultaAll($c02);
		
			for ($j = 0; $j < $detalles["size"]; $j++) {
				$detallesData = $detalles["data"][$j];
				$idProducto = $detallesData->ID_PRODUCTO;
				$idInventario = $detallesData->ID_INVENTARIO;
				$cantidad = $detallesData->CANTIDAD;
		
				$c03 = "UPDATE inventario SET cantidad =  '".$cantidad."' WHERE ID_INVENTARIO = '".$idInventario."'";
				$updateInventario=  $DB->consulta($c03);
			}
		
			$c04 = "SELECT BOLETA FROM ventas WHERE ID_VENTA = '".$idventa."'";
			$venta = $DB->consultaOne($c04);
		
			$resultado = array();
			$resultado["boleta"] = $venta->BOLETA;
			$resultado["query"] = $c02;
			$resultado["idp"] = $idProducto;
			$resultado["idi"] = $idInventario;
			break;
		case 'verPagos': 
			$id = $body["idventa"]; 
			$c03 = "SELECT * from pagos where id_venta='".$id."' ";
			$pagos = $DB->consultaAll($c03);
			
			$resultado = array();
			$resultado["pagos"] = $pagos;
		break;
		case 'newPago':	
			$iduser = $body["iduser"];
			$idventa = $body["idventa"];  // Cambiado de idprestamo a idventa
			$idsucursal = $body["idsucursal"];
			$concepto = $body["concepto"];
			$monto = $body["monto"];
			$tipopago = $body["tipopago"];
		
			// Obtenemos la venta usando el idventa
			$c00 = "SELECT * FROM ventas WHERE id_venta = '".$idventa."'";
			$venta = $DB->consultaOne($c00);
			$bolven = $venta->BOLETA;
		
			$glosa = "Abono a la venta Nro : ".$bolven;
		
			// Verificamos si existe un arqueo iniciado
			$c01 = "SELECT ID_ARQUEO FROM arqueo WHERE id_sucursal='".$idsucursal."' AND id_user='".$iduser."' AND estado='INICIADO'";
			$arqueo = $DB->consultaOne($c01);
			$idarqueo = $arqueo->ID_ARQUEO;
		
			if ($idarqueo == '' || $idarqueo == null) {
				$nmsj = "NO SE PUEDE REALIZAR EL PAGO SI NO ABRE UN ARQUEO";
				throw new Exception($nmsj);
			}
		
			$c02 = "SELECT IFNULL(MAX(boleta) + 1, 1) AS boleta FROM ingresos WHERE id_sucursal = '".$idsucursal."'";
			$selectRes2 = $DB->consultaOne($c02);
			$bol = $selectRes2->boleta;
		
			$c03 = "INSERT INTO ingresos VALUES (DEFAULT, '".$idsucursal."', '".$iduser."', NOW(), '".$bol."', '".$tipopago."', 'PAGO CREDITO', '".$glosa."', '".$monto."', '".$idarqueo."', 'VALIDO')";
			
			$insert = $DB->consulta($c03);
		
			// Obtener el último ID de pago
			$c04 = "SELECT IFNULL(MAX(ID_PAGO), 0) + 1 AS nuevo_id_pago FROM pagos";
			$selectRes4 = $DB->consultaOne($c04);
			$idPago = $selectRes4->nuevo_id_pago; // El nuevo ID de pago

			// Ahora insertamos el nuevo pago con este ID
			$c05 = "INSERT INTO pagos VALUES ('".$idPago."', '".$idventa."', '".$iduser."', NOW(), '".$glosa."', '".$monto."')";
			$insert = $DB->consulta($c05);

		
			// Resultado de la operación
			$resultado = array();
			$resultado["ok"] = $insert;
			$resultado["idpago"] = $idPago;
		break;

			/* --------------------- Traspasos ---------------------------- */
		case 'listarTraspasos':
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			
			$c00 = "SELECT t.ID_SUCURSAL_ORIGEN, t.ID_SUCURSAL_DESTINO, t.ID_TRASPASO, t.FECHA_REGISTRO, t.BOLETA, t.CONCEPTO, t.CANTIDAD, t.PRECIO_TOTAL, t.ESTADO, so.SUCURSAL as ORIGEN, sd.SUCURSAL as DESTINO FROM  traspasos t, sucursal so, sucursal sd WHERE t.id_sucursal_origen = so.id_sucursal and t.id_sucursal_destino = sd.id_sucursal and DATE(t.fecha_registro) >='" . $fini . "' AND DATE(t.fecha_registro) <= '" . $ffin . "' and  t.id_sucursal_origen = '" . $idsucursal . "' group by t.id_traspaso ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND t.id_user = '" . $iduser . "'";
			}

			$c00 .= " order by t.id_traspaso desc";
			$enviados = $DB->consultaAll($c00);
			$c01 = "SELECT t.ID_SUCURSAL_ORIGEN, t.ID_SUCURSAL_DESTINO, t.ID_TRASPASO, t.FECHA_REGISTRO, t.BOLETA, t.CONCEPTO, t.CANTIDAD, t.PRECIO_TOTAL, t.ESTADO, so.SUCURSAL as ORIGEN, sd.SUCURSAL as DESTINO FROM  traspasos t, sucursal so, sucursal sd WHERE t.id_sucursal_origen = so.id_sucursal and t.id_sucursal_destino = sd.id_sucursal and DATE(t.fecha_registro) >='" . $fini . "' AND DATE(t.fecha_registro) <= '" . $ffin . "' and  t.id_sucursal_destino = '" . $idsucursal . "' group by t.id_traspaso order by t.id_traspaso desc";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c01 .= " AND t.id_user = '" . $iduser . "'";
			}
			$c01 .= " order by t.id_traspaso desc";
			$recibidos = $DB->consultaAll($c01);
			$resultado = array();
			$resultado["enviados"] = $enviados;
			$resultado["recibidos"] = $recibidos;
			break;
		case 'realizarTraspaso':
			$detalle = $body["detalle"];
			$concepto = $body["concepto"];
			$precio = $body["precio"];
			$cantidad = $body["cantidad"];
			$vendedor = $body["vendedor"];
			$origen = $body["origen"];
			$destino = $body["destino"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];

			$c00 = "select IFNULL(MAX(id_traspaso) + 1, 1) AS maxid from traspasos ";
			$selectRes = $DB->consultaOne($c00);
			$idtras = $selectRes->maxid;
			$c01 = "select IFNULL(MAX(boleta) + 1, 1) AS boleta from traspasos where id_sucursal_origen = '" . $idsucursal . "'";
			$selectRes1 = $DB->consultaOne($c01);
			$bol = $selectRes1->boleta;

			$c02 = "INSERT INTO traspasos VALUES ('" . $idtras . "', '" . $iduser . "', '" . $origen . "','" . $destino . "', now(), '" . $bol . "', '" . $concepto . "', '" . $cantidad . "', " . $precio . ", 'PENDIENTE')";
			$insertTraspaso = $DB->consulta($c02);

			foreach ($detalle as $k => $det) {
				$itmventa =  $det->pventa;
				$itmcantidad = $det->cantidad;
				$itmproducto = $det->nombre;
				$itmcompra = $det->pcompra;
				$itmunid = $det->unidad;
				$ptope = $det->ptope;
				$itmidp = $det->idp;
				$fvencimiento = $det->fvencimiento;
				$lote = $det->lote;

				if ($itmunid == 'UNIDAD') {
					for ($j = 0; $j < $itmcantidad; $j++) {
						$c04 = "SELECT MIN(ID_INVENTARIO) as idi FROM inventario WHERE ID_PRODUCTO='" . $itmidp . "' AND cantidad > 0 AND id_sucursal ='" . $idsucursal . "'";
						$res4 = $DB->consultaOne($c04);
						$id_inventario = ($res4 && isset($res4->idi)) ? $res4->idi : 0;

						$c05 = "INSERT INTO traspaso_detalle VALUES (default,'" . $idtras . "','" . $itmidp . "', '" . $id_inventario . "', '" . $itmproducto . "','1', '" . $itmcompra . "', '" . $lote . "', '" . $fvencimiento . "')";
						$insertDetTraspaso = $DB->consulta($c05);

						$c06 = "INSERT INTO inventario VALUES (default, '" . $destino . "', '" . $idtras . "', '" . $itmidp . "', 'TRASPASO', now(), '" . $fvencimiento . "' , '" . $lote . "', '" . $itmcompra . "', '" . $itmventa . "', '" . $ptope . "','1', '0', 'SIN VERIFICAR');";
						$insertInventario = $DB->consulta($c06);
					}
				} else {
					$c04= "select min(ID_INVENTARIO) as idi, cantidad from inventario where id_producto = '".$itmidp."' AND leido = '0' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
					$res4 = $DB->consultaOne($c04);
					$idinv = $res4->idi;
					if ($res4) {
						if ($res4->cantidad >= $itmcantidad) {
							$c05 = "INSERT INTO traspaso_detalle VALUES (default,'" . $idtras . "','" . $itmidp . "', '" . $id_inventario . "', '" . $itmproducto . "','".$itmcantidad."', '" . $itmcompra . "', '" . $lote . "', '" . $vencimiento . "')";
							$insertDetTraspaso = $DB->consulta($c05);

							$c06 = "INSERT INTO inventario VALUES (default, '" . $destino . "', '" . $idtras . "', '" . $itmidp . "', 'TRASPASO', now(), '" . $fvencimiento . "' , '" . $lote . "', '" . $itmcompra . "', '" . $itmventa . "', '" . $ptope . "','".$itmcantidad."', '0', 'SIN VERIFICAR');";
							$insertInventario = $DB->consulta($c06);
						} else {
							$nmsj = "NO HAY STOCK DISPONIBLE PARA EL PRODUCTO SOLICITADO.";
							throw new Exception($nmsj);
						}
					}
						
				}
			}
			$resultado = array();
			$resultado["idtras"] = $idtras;
			break;
		case 'confirmarTraspaso':
			$id = $body["idtraspaso"];
			$origen = $body["origen"];
			$destino = $body["destino"];
			$c00 = "UPDATE traspasos set estado ='CONFIRMADO' WHERE id_traspaso = '" . $id . "' ;";
			$updcompra = $DB->consulta($c00);
			$c01 = "SELECT td.id_inventario, td.cantidad, p.unidad FROM traspaso_detalle td, producto p WHERE p.id_producto= td.id_producto AND td.id_traspaso = '" . $id . "' ";
			$tras = $DB->consultaAll($c01);
			for ($i = 0; $i < $tras["size"]; $i++) {
				$trasData = $tras["data"][$j];
				$idinv = $trasData->id_inventario;
				$cant = $trasData->cantidad;
				$unid = $trasData->unidad;

				if ($unid == 'UNIDAD') {
                	$c02 = "UPDATE inventario SET cantidad = 0 WHERE id_inventario = '" . $idinv . "'";
				} else {
					$cantactual = floatval($cant);
					$c02 = "UPDATE inventario SET cantidad = GREATEST(cantidad - " . floatval($cantactual) . ", 0) WHERE id_inventario = '" . $idinv . "'";

				}
				$updateInv = $DB->consulta($c02);

			}
			$c03 = "UPDATE inventario set estado = 'VERIFICADO' WHERE id_ingreso = '" . $id . "' AND tipo_ingreso='TRASPASO';";
			$updinventario = $DB->consulta($c03);

			$resultado = array();
			$resultado["traspaso"] = $id;
			break;
		case 'verBoletaTraspaso':
			$id = $body["id"];
			$c00 = "SELECT * from traspasos where  id_traspaso ='" . $id . "'";
			$traspaso = $DB->consultaOne($c00);
			$c01 = "SELECT sum(td.cantidad) as CANTIDAD, td.PRECIO AS PRECIO_UNITARIO, p.ID_PRODUCTO, p.CODIGO, p.NOMBRE from traspaso_detalle td , producto p where p.id_producto = td.id_producto and td.id_traspaso ='" . $id . "' group by td.id_producto;";
			$dets = $DB->consultaAll($c01);
			$c02 = "SELECT sucursal as origen from sucursal where id_sucursal ='" . $traspaso->ID_SUCURSAL_ORIGEN . "'";
			$origen = $DB->consultaOne($c02);
			$norigen = $origen->origen;
			$c03 = "SELECT usuario from user where id_user ='" . $traspaso->ID_USER . "'";
			$usuario = $DB->consultaOne($c03);
			$nusuario = $usuario->usuario;
			$c04 = "SELECT sucursal as destino from sucursal where id_sucursal ='" . $traspaso->ID_SUCURSAL_DESTINO . "'";
			$destino = $DB->consultaOne($c04);
			$ndestino = $destino->destino;
			$resultado = array();
			$resultado["traspaso"] = $traspaso;
			$resultado["origen"] = $norigen;
			$resultado["destino"] = $ndestino;
			$resultado["usuario"] = $nusuario;
			$resultado["dets"] = $dets;
			break;
			/* --------------------- Compras ---------------------------- */
		case 'listarCompras':
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c00 = "SELECT  * FROM compras WHERE id_sucursal = '" . $idsucursal . "' and DATE(fecha_registro) >= '" . $fini . "' and DATE(fecha_registro) <='" . $ffin . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND id_user = '" . $iduser . "'";
			}

			$c00 .= " ORDER BY id_compra DESC";
			$compras = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["compras"] = $compras;
			break;

		case 'realizarCompra':
			$detalle = $body["detalle"];
			$concepto = $body["concepto"];
			$precio = $body["precio"];
			$cantidad = $body["cantidad"];
			$proveedor = $body["proveedor"];
			$tipopago = $body["tipopago"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$tc = $body["tc"];

			$c00 = "select IFNULL(MAX(id_compra) + 1, 1) AS maxid from compras ";
			$selectRes = $DB->consultaOne($c00);
			$idcmp = $selectRes->maxid;

			$c01 = "select IFNULL(MAX(boleta) + 1, 1) AS boleta from compras where id_sucursal = '" . $idsucursal . "'";
			$selectRes1 = $DB->consultaOne($c01);
			$bol = $selectRes1->boleta;

			$c02 = "INSERT INTO compras VALUES ('" . $idcmp . "', '" . $idsucursal . "', '" . $proveedor . "', '" . $iduser . "', now(), '" . $bol . "', '" . $concepto . "', '" . $cantidad . "', " . $precio . ",'" . $tipopago . "',  'SIN VERIFICAR')";
			$insertCompras = $DB->consulta($c02);

			foreach ($detalle as $k => $det) {
				$itmventa =  $det->pventa;
				$itmcantidad = $det->cantidad;
				$itmproducto = $det->nombre;
				$itmcompra = $det->pcompra;
				$ptope = $det->ptope;
				$pespecial = $det->pespecial;
				$pmayor = $det->pmayor;
				$itmidp = $det->idp;
				$itmunid = $det->unidad;
				$fvencimiento = $det->fvencimiento ? $det->fvencimiento : "0000-00-00";
                $lote = $det->lote ? $det->lote : "0";


				$subprecio = floatval($itmcantidad) * floatval($itmcompra);
				if ($itmunid == 'UNIDAD') {
					$itmcantidad = round($itmcantidad);
					for ($j = 0; $j < $itmcantidad; $j++) {
						$c03 = "select IFNULL(MAX(id_inventario) + 1, 1) AS maxid from inventario";
						$selectRes1 = $DB->consultaOne($c03);
						$idinv = $selectRes1->maxid;

						$c04 = "INSERT INTO compra_detalle VALUES (default,'" . $idcmp . "','" . $itmidp . "','" . $idinv . "', '" . $itmproducto . "','1', '" . $itmcompra . "', '" . $lote . "', '" . $fvencimiento . "');";
						$insertDetCompras = $DB->consulta($c04);
						$c05 = "INSERT INTO inventario VALUES ('" . $idinv . "', '" . $idsucursal . "', '" . $idcmp . "', '" . $itmidp . "', 'COMPRA', now() , '" . $fvencimiento . "' , '" . $lote . "', '" . $itmcompra . "', '" . $itmventa . "', '" . $ptope . "', '1', '0', 'SIN VERIFICAR');";
						$insertInventario = $DB->consulta($c05);
					}
				} else {

					$itmcantidad = round($itmcantidad, 3);
					$c03 = "select IFNULL(MAX(id_inventario) + 1, 1) AS maxid from inventario";
					$selectRes1 = $DB->consultaOne($c03);
					$idinv = $selectRes1->maxid;

					$c04 = "INSERT INTO compra_detalle VALUES (default,'" . $idcmp . "','" . $itmidp . "','" . $idinv . "', '" . $itmproducto . "', '" . $itmcantidad . "', '" . $itmcompra . "', '" . $lote . "', '" . $fvencimiento . "');";
					$insertDetCompras = $DB->consulta($c04);
					$c05 = "INSERT INTO inventario VALUES ('" . $idinv . "', '" . $idsucursal . "', '" . $idcmp . "', '" . $itmidp . "', 'COMPRA', now() , '" . $fvencimiento . "' , '" . $lote . "', '" . $itmcompra . "', '" . $itmventa . "', '" . $ptope . "', '" . $itmcantidad . "', '0', 'SIN VERIFICAR');";
					$insertInventario = $DB->consulta($c05);
				}

				$c06 = "UPDATE producto set precio_tope ='" . $ptope . "', precio_compra = '" . $itmcompra . "',  precio_venta = '" . $itmventa . "',  precio_mayor = '" . $pmayor . "',  precio_especial = '" . $pespecial . "' WHERE id_producto = '" . $itmidp . "';";
				$updproducto = $DB->consulta($c06);
			}
			$resultado = array();
			$resultado["idcmp"] = $idcmp;
			$resultado["query"] = $c04;
			break;
		case 'modificarCompra':
			$detalle = $body["detalle"];
			$idcompra = $body["idcompra"];
			$concepto = $body["concepto"];
			$precio = $body["precio"];
			$cantidad = $body["cantidad"];
			$proveedor = $body["proveedor"];
			$tipopago = $body["tipopago"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$tc = $body["tc"];

			$c00 = "DELETE FROM compra_detalle WHERE id_compra='" . $idcompra . "'";
			$delete = $DB->consulta($c00);

			$c01 = "DELETE FROM inventario WHERE id_ingreso='" . $idcompra . "' and tipo_ingreso='COMPRA'";
			$delete1 = $DB->consulta($c01);

			$c02 = "update compras  set id_proveedor = '" . $proveedor . "', concepto ='" . $concepto . "', cantidad = '" . $cantidad . "', precio_total = " . $precio . ", tipo_pago = '" . $tipopago . "' WHERE id_compra='" . $idcompra . "' ";
			$update = $DB->consulta($c02);

			foreach ($detalle as $k => $det) {
				$itmventa =  $det->pventa;
				$itmcantidad = $det->cantidad;
				$itmproducto = $det->nombre;
				$itmcompra = $det->pcompra;
				$ptope = $det->ptope;
				$pespecial = $det->pespecial;
				$pmayor = $det->pmayor;
				$itmidp = $det->idp;
				$itmunid = $det->unidad;
				$fvencimiento = $det->fvencimiento;
				$lote = $det->lote;

				if ($itmunid == 'UNIDAD') {
					$itmcantidad = round($itmcantidad);
					for ($j = 0; $j < $itmcantidad; $j++) {
						$c03 = "select IFNULL(MAX(id_inventario) + 1, 1) AS maxid from inventario";
						$selectRes1 = $DB->consultaOne($c03);
						$idinv = $selectRes1->maxid;

						$c04 = "INSERT INTO compra_detalle VALUES (default,'" . $idcompra . "','" . $itmidp . "','" . $idinv . "', '" . $itmproducto . "','1', '" . $itmcompra . "', '" . $lote . "', '" . $fvencimiento . "');";
						$insertDetCompras = $DB->consulta($c04);
						$c05 = "INSERT INTO inventario VALUES ('" . $idinv . "', '" . $idsucursal . "', '" . $idcompra . "', '" . $itmidp . "', 'COMPRA', now() , '" . $fvencimiento . "' , '" . $lote . "', '" . $itmcompra . "', '" . $itmventa . "', '" . $ptope . "', '1', '0', 'SIN VERIFICAR');";
						$insertInventario = $DB->consulta($c05);
					}
				} else {
					$itmcantidad = round($itmcantidad, 3);
					$c03 = "select IFNULL(MAX(id_inventario) + 1, 1) AS maxid from inventario";
					$selectRes1 = $DB->consultaOne($c03);
					$idinv = $selectRes1->maxid;

					$c04 = "INSERT INTO compra_detalle VALUES (default,'" . $idcompra . "','" . $itmidp . "','" . $idinv . "', '" . $itmproducto . "', '" . $itmcantidad . "', '" . $itmcompra . "', '" . $lote . "', '" . $fvencimiento . "');";
					$insertDetCompras = $DB->consulta($c04);
					$c05 = "INSERT INTO inventario VALUES ('" . $idinv . "', '" . $idsucursal . "', '" . $idcompra . "', '" . $itmidp . "', 'COMPRA', now() , '" . $fvencimiento . "' , '" . $lote . "', '" . $itmcompra . "', '" . $itmventa . "', '" . $ptope . "', '" . $itmcantidad . "', '0', 'SIN VERIFICAR');";
					$insertInventario = $DB->consulta($c05);
				}
				$c06 = "UPDATE producto set precio_tope ='" . $ptope . "', precio_compra = '" . $itmcompra . "', precio_especial = '" . $pespecial . "', precio_mayor = '" . $pmayor . "',  precio_venta = '" . $itmventa . "' WHERE id_producto = '" . $itmidp . "';";
				$updproducto = $DB->consulta($c06);
			}
			$resultado = array();
			$resultado["idcmp"] = $idcompra;
			break;
		case 'modalEditarCompra':
			$id = $body["idcompra"];
			$c00 = "SELECT * from compras  where id_compra ='" . $id . "'";
			$compra = $DB->consultaOne($c00);
			$c01 = "SELECT vc.lote, vc.fecha_vencimiento as fvencimiento, sum(vc.cantidad) as cantidad, vc.precio_compra AS pcompra, p.id_producto as idp, p.codigo, p.unidad, p.nombre, p.imagen, p.precio_venta as pventa, p.precio_mayor as pmayor, p.precio_especial as pespecial, p.precio_tope as ptope from compra_detalle vc , producto p where p.id_producto = vc.id_producto and vc.id_compra ='" . $id . "' group by vc.id_producto , vc.lote; ";
			$detalle = $DB->consultaAll($c01);

			$resultado = array();
			$resultado["compra"] = $compra;
			$resultado["detalle"] = $detalle;
			break;
		case 'verBoletaCompra':
			$id = $body["id"];
			$c00 = "SELECT * from compras c, proveedor p where p.id_proveedor= c.id_proveedor and id_compra ='" . $id . "'";
			$compra = $DB->consultaOne($c00);
			$c01 = "SELECT sum(vc.cantidad) as CANTIDAD, sum(vc.precio_compra) as PRECIO_COMPRA, vc.PRECIO_COMPRA AS PRECIO_UNITARIO, p.ID_PRODUCTO, p.CODIGO, p.NOMBRE from compra_detalle vc , producto p where p.id_producto = vc.id_producto and vc.id_compra ='" . $id . "' group by vc.id_producto;";
			$dets = $DB->consultaAll($c01);
			$c02 = "SELECT sucursal from sucursal where id_sucursal ='" . $compra->ID_SUCURSAL . "'";
			$sucursal = $DB->consultaOne($c02);
			$nsucursal = $sucursal->sucursal;
			$c03 = "SELECT usuario from user where id_user ='" . $compra->ID_USER . "'";
			$usuario = $DB->consultaOne($c03);
			$nusuario = $usuario->usuario;
			$resultado = array();
			$resultado["compra"] = $compra;
			$resultado["sucursal"] = $nsucursal;
			$resultado["usuario"] = $nusuario;
			$resultado["dets"] = $dets;
			break;
		case 'confirmarCompra':
			$id = $body["idcompra"];
			$idsucursal = $body["idsucursal"];
			$c00 = "UPDATE compras set estado ='VERIFICADO' WHERE id_compra = '" . $id . "' ;";
			$updcompra = $DB->consulta($c00);
			$c01 = "UPDATE inventario set estado ='VERIFICADO' WHERE id_ingreso = '" . $id . "' AND tipo_ingreso='COMPRA';";
			$updinventario = $DB->consulta($c01);
			$resultado = array();
			$resultado["compra"] = $id;
			break;
		case 'cargarExcelCompra':
			$detalle = array();
			$excel = $body["excel"];
			$archivo = "../../archivos/excel/" . $excel;
			$inputFileType = PHPExcel_IOFactory::identify($archivo);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($archivo);
			$sheet = $objPHPExcel->getSheet(0);
			$highestRow = $sheet->getHighestRow();
			$highestColumn = $sheet->getHighestColumn();
			for ($row = 2; $row <= $highestRow; $row++) {
				$c00 = "select * from producto where codigo = '" . $sheet->getCell("A" . $row)->getValue() . "'";
				$producto = $DB->consultaOne($c00);
				$nimg = "../../img/Producto/" . $producto->IMAGEN;
				$img = existeImagen($nimg);
				$idpr = $producto->ID_PRODUCTO;
				if ($idpr == null) {
					$idpr = 1;
				} else {
					$detitem = new stdClass();
					$detitem->idp				= $producto->ID_PRODUCTO;
					$detitem->codigo			= $sheet->getCell("A" . $row)->getValue();
					$detitem->nombre			= $producto->NOMBRE;
					$detitem->cantidad			= $sheet->getCell("B" . $row)->getValue();
					$detitem->pcompra			= $producto->PRECIO_COMPRA;
					$detitem->pventa			= $producto->PRECIO_VENTA;
					$detitem->pmayor			= $producto->PRECIO_MAYOR;
					$detitem->pespecial			= $producto->PRECIO_ESPECIAL;
					$detitem->ptope				= $producto->PRECIO_TOPE;
					$detitem->unidad			= $producto->UNIDAD;
					$detitem->lote				= $sheet->getCell("C" . $row)->getValue();
					$detitem->fvencimiento		= $sheet->getCell("D" . $row)->getValue();
					$detitem->fvencimiento 		= date("Y-m-d", ($detitem->fvencimiento - 25569) * 86400);
					$detitem->imagen			= $img;
					array_push($detalle, $detitem);
				}
			}
			$resultado = array();
			$resultado["detalle"] = $detalle;
			break;
			/* --------------------- Ajustes ---------------------------- */
		case 'listarAjustes':
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c00 = "SELECT * FROM ajustes  WHERE ID_SUCURSAL = '" . $idsucursal . "' AND DATE(FECHA_REGISTRO) >= '" . $fini . "' AND DATE(FECHA_REGISTRO) <= '" . $ffin . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND id_user = '" . $iduser . "'";
			}

			$c00 .= " ORDER BY ID_AJUSTE DESC";
			$ajustes = $DB->consultaAll($c00);
			$resultado = array();
			$resultado["ajustes"] = $ajustes;
			break;

		case 'realizarAjuste':
			$detalle = $body["detalle"];
			$concepto = $body["concepto"];
			$precio = $body["precio"];
			$cantidad = $body["cantidad"];
			$iduser = $body["iduser"];
			$idsucursal = $body["idsucursal"];
		
			$c00 = "SELECT IFNULL(MAX(ID_AJUSTE) + 1, 1) AS maxid FROM ajustes";
			$selectRes = $DB->consultaOne($c00);
			$idajuste = $selectRes->maxid;
		
			$c01 = "SELECT IFNULL(MAX(BOLETA) + 1, 1) AS boleta FROM ajustes WHERE ID_SUCURSAL = '" . $idsucursal . "'";
			$selectRes1 = $DB->consultaOne($c01);
			$bol = $selectRes1->boleta;
		
			$c02 = "INSERT INTO ajustes VALUES ('" . $idajuste . "', '" . $idsucursal . "', '" . $iduser . "', NOW(), '" . $bol . "', '" . $concepto . "', '" . $cantidad . "', " . $precio . ")";
			$insertAjustes = $DB->consulta($c02);
		
			foreach ($detalle as $k => $det) {
				$itmventa =  $det->pventa;
				$itmcantidad = $det->cantidad;
				$itmproducto = $det->nombre;
				$itmcompra = $det->pcompra;
				$ptope = $det->ptope;
				$pespecial = $det->pespecial;
				$pmayor = $det->pmayor;
				$itmidp = $det->idp;
				$itmunid = $det->unidad;
				$fvencimiento = $det->fvencimiento ? $det->fvencimiento : "0000-00-00";
                $lote = $det->lote ? $det->lote : "0";
		
				if ($itmunid == 'UNIDAD') {
					$itmcantidad = round($itmcantidad);
					for ($j = 0; $j < $itmcantidad; $j++) {
						$c03 = "select IFNULL(MAX(id_inventario) + 1, 1) AS maxid from inventario";
						$selectRes1 = $DB->consultaOne($c03);
						$idinv = $selectRes1->maxid;
		
						$c04 = "INSERT INTO ajuste_detalle VALUES (default, '" . $idajuste . "', '" . $itmidp . "', '" . $idinv . "', '" . $itmproducto . "', '1', '" . $itmcompra . "','INGRESO', '".$lote."', '".$fvencimiento."')";
						$insertAjuste = $DB->consulta($c04);
						
						$c05 = "INSERT INTO inventario VALUES ('" . $idinv . "', '" . $idsucursal . "', '" . $idajuste . "', '" . $itmidp . "', 'AJUSTE', now() , '" . $fvencimiento . "', '" . $lote . "', '" . $itmcompra . "', '" . $itmventa . "', '" . $ptope . "', '1', '0', 'VERIFICADO');";
						$insertInventario = $DB->consulta($c05);
					}
				} else {
					$itmcantidad = round($itmcantidad, 3);
					$c03 = "select IFNULL(MAX(id_inventario) + 1, 1) AS maxid from inventario";
					$selectRes1 = $DB->consultaOne($c03);
					$idinv = $selectRes1->maxid;
		
					$c04 = "INSERT INTO ajuste_detalle VALUES (default, '" . $idajuste . "', '" . $itmidp . "', '" . $idinv . "', '" . $itmproducto . "', '" . $itmcantidad . "', '" . $itmcompra . "','INGRESO', '".$lote."', '".$fvencimiento."')";
					$insertAjuste = $DB->consulta($c04);
					
					$c05 = "INSERT INTO inventario VALUES ('" . $idinv . "', '" . $idsucursal . "', '" . $idajuste . "', '" . $itmidp . "', 'AJUSTE', now() , '" . $fvencimiento . "', '" . $lote . "', '" . $itmcompra . "', '" . $itmventa . "', '" . $ptope . "', '" . $itmcantidad . "', '0', 'VERIFICADO');";
					$insertInventario = $DB->consulta($c05);
				}
			}
		
			$resultado = array();
			$resultado["idajuste"] = $idajuste;
			break;
			

		case 'verBoletaAjuste':
			$id = $body["id"];
			$c00 = "SELECT BOLETA, FECHA_REGISTRO, CONCEPTO, CANTIDAD, PRECIO_TOTAL, ID_USER, ID_SUCURSAL FROM ajustes WHERE ID_AJUSTE = '" . $id . "'";
			$ajuste = $DB->consultaOne($c00);

			$c01 = "SELECT SUM(ad.CANTIDAD) AS CANTIDAD, SUM(ad.PRECIO_AJUSTE) AS PRECIO_AJUSTE, ad.PRECIO_AJUSTE AS PRECIO_UNITARIO, p.ID_PRODUCTO, p.NOMBRE 
					FROM ajuste_detalle ad, producto p 
					WHERE p.ID_PRODUCTO = ad.ID_PRODUCTO AND ad.ID_AJUSTE = '" . $id . "' 
					GROUP BY ad.ID_PRODUCTO";
			$dets = $DB->consultaAll($c01);

			$c02 = "SELECT sucursal FROM sucursal WHERE ID_SUCURSAL = '" . $ajuste->ID_SUCURSAL . "'";
			$sucursal = $DB->consultaOne($c02);
			$nsucursal = $sucursal->sucursal;

			$c03 = "SELECT usuario FROM user WHERE ID_USER = '" . $ajuste->ID_USER . "'";
			$usuario = $DB->consultaOne($c03);
			$nusuario = $usuario->usuario;

			$resultado = array();
			$resultado["ajuste"] = $ajuste;
			$resultado["dets"] = $dets;
			$resultado["usuario"] = $nusuario;
			$resultado["sucursal"] = $nsucursal;
			break;

		case 'cargarExcelAjuste':
			$detalle = array();
			$excel = $body["excel"];
			$archivo = "../../archivos/excel/" . $excel;
			$inputFileType = PHPExcel_IOFactory::identify($archivo);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($archivo);
			$sheet = $objPHPExcel->getSheet(0);
			$highestRow = $sheet->getHighestRow();
			$highestColumn = $sheet->getHighestColumn();
			for ($row = 2; $row <= $highestRow; $row++) {
				$c00 = "select * from producto where codigo = '" . $sheet->getCell("A" . $row)->getValue() . "'";
				$producto = $DB->consultaOne($c00);
				$nimg = "../../img/Producto/" . $producto->IMAGEN;
				$img = existeImagen($nimg);
				$idpr = $producto->ID_PRODUCTO;
				if ($idpr == null) {
					$idpr = 1;
				} else {
					$detitem = new stdClass();
					$detitem->idp				= $producto->ID_PRODUCTO;
					$detitem->codigo			= $sheet->getCell("A" . $row)->getValue();
					$detitem->nombre			= $producto->NOMBRE;
					$detitem->cantidad			= $sheet->getCell("B" . $row)->getValue();
					$detitem->pfinal			= $producto->PRECIO_COMPRA;
					$detitem->pcompra			= $producto->PRECIO_COMPRA;
					$detitem->pventa			= $producto->PRECIO_VENTA;
					$detitem->pmayor			= $producto->PRECIO_MAYOR;
					$detitem->pespecial			= $producto->PRECIO_ESPECIAL;
					$detitem->ptope				= $producto->PRECIO_TOPE;
					$detitem->unidad			= $producto->UNIDAD;
					$detitem->lote				= $sheet->getCell("C" . $row)->getValue();
					$detitem->fvencimiento		= $sheet->getCell("D" . $row)->getValue();
					$detitem->fvencimiento 		= date("Y-m-d", ($detitem->fvencimiento - 25569) * 86400);
					$detitem->imagen			= $img;
					array_push($detalle, $detitem);
				}
			}
			$resultado = array();
			$resultado["detalle"] = $detalle;
			break;

			/* --------------------- Bajas ---------------------------- */
		case 'listarBajas':
			
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c02 = "SELECT  * FROM  bajas b , vendedor ve WHERE b.id_sucursal = '" . $idsucursal . "' and ve.id_vendedor = b.id_vendedor and DATE(b.fecha_registro) >= '" . $fini . "' and DATE(b.fecha_registro) <='" . $ffin . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND b.id_user = '" . $iduser . "'";
			}

			$c00 .= "order by b.id_baja desc";
			$bajas = $DB->consultaAll($c02);
			$resultado = array();
			$resultado["bajas"] = $bajas;
			break;
		case 'realizarBaja':
			$detalle = $body["detalle"];
			$concepto = $body["concepto"];
			$precio = $body["precio"];
			$cantidad = $body["cantidad"];
			$vendedor = $body["vendedor"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];

			$c00 = "select IFNULL(MAX(id_baja) + 1, 1) AS maxid from bajas";
			$selectRes = $DB->consultaOne($c00);
			$idbaj = $selectRes->maxid;

			$c01 = "select IFNULL(MAX(boleta) + 1, 1) AS boleta from bajas where id_sucursal = '" . $idsucursal . "'";
			$selectRes1 = $DB->consultaOne($c01);
			$bol = $selectRes1->boleta;

			$c02 = "INSERT INTO bajas VALUES ('" . $idbaj . "', '" . $idsucursal . "', '" . $vendedor . "','" . $iduser . "', now(), '" . $bol . "',  '" . $concepto . "', '" . $cantidad . "', " . $precio . ")";
			$insertBajas = $DB->consulta($c02);

			foreach ($detalle as $k => $det) {
				$itmventa =  $det->pventa;
				$itmcantidad = $det->cantidad;
				$itmproducto = $det->nombre;
				$itmcompra = $det->pcompra;
				$itmunid = $det->unidad;
				$ptope = $det->ptope;
				$itmidp = $det->idp;
				$fvencimiento = $det->fvencimiento;
				$lote = $det->lote;

			

				if ($itmunid == 'UNIDAD') {
					for ($j = 0; $j < $itmcantidad; $j++) {
						$itmcantidad = round($itmcantidad);
						$c04= "select min(ID_INVENTARIO) as idi from inventario where id_producto = '".$itmidp."' AND leido = '".$iduser."' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
						$res4 = $DB->consultaOne($c04);
						$idinv = $res4->idi;

						$c05 = "INSERT INTO baja_detalle VALUES (default,'" . $idbaj . "','" . $itmidp . "', '" . $idinv . "', '" . $itmproducto . "','1', '" . $itmcompra . "', '" . $lote . "', '" . $fvencimiento . "')";
						$insertDetBajas = $DB->consulta($c05);

						$c06 = "UPDATE inventario set cantidad ='0' WHERE id_inventario = '".$idinv."';";
						$updinv = $DB->consulta($c06);
					}
				} else {
					$itmcantidad = round($itmcantidad,3);
					$c04= "select min(ID_INVENTARIO) as idi, cantidad from inventario where id_producto = '".$itmidp."' AND leido = '".$iduser."' and cantidad > 0  and id_sucursal='".$idsucursal."'  ";
					$res4 = $DB->consultaOne($c04);
					$idinv = $res4->idi;
					
					if ($res4) {
						if ($res4->cantidad >= $itmcantidad) {
							$c05 = "INSERT INTO venta_detalle VALUES (default, '" . $idven . "', '" . $itmidp . "', '".$idinv."', '" . $itmproducto . "', '".$itmcantidad."', '" . $itmfinal . "', '" . $lote . "', '" . $fvencimiento . "')";
							$insertDetVentas = $DB->consulta($c05);

							$c06 = "UPDATE inventario SET cantidad = (cantidad - " . $itmcantidad . ") WHERE id_inventario = '" . $res4->idi . "'";
							$updinv = $DB->consulta($c06);
						} else {
							$nmsj = "NO HAY STOCK DISPONIBLE PARA EL PRODUCTO SOLICITADO.";
							throw new Exception($nmsj);
						}
					}
				}
				
			}				

			$resultado = array();
			$resultado["idbaj"] = $idbaj;
			break;
		case 'verBoletaBaja':
			$id = $body["id"];
			$c00 = "SELECT BOLETA, FECHA_REGISTRO, CONCEPTO, CANTIDAD, PRECIO_TOTAL, ID_USER, ID_VENDEDOR, ID_SUCURSAL FROM bajas   where id_baja ='" . $id . "'";
			$baja = $DB->consultaOne($c00);
			$c01 = "SELECT sum(vd.cantidad) as CANTIDAD, sum(vd.precio_baja) as PRECIO_BAJA, vd.precio_baja as PRECIO_UNITARIO, p.ID_PRODUCTO, p.NOMBRE from baja_detalle vd , producto p where p.id_producto = vd.id_producto and vd.id_baja ='" . $id . "' group by vd.id_producto;";
			$dets = $DB->consultaAll($c01);
			$c02 = "SELECT sucursal from sucursal where id_sucursal ='" . $baja->ID_SUCURSAL . "'";
			$sucursal = $DB->consultaOne($c02);
			$nsucursal = $sucursal->sucursal;
			$c03 = "SELECT usuario from user where id_user ='" . $baja->ID_USER . "'";
			$usuario = $DB->consultaOne($c03);
			$nusuario = $usuario->usuario;
			$c04 = "SELECT vendedor from vendedor where id_vendedor ='" . $baja->ID_VENDEDOR . "'";
			$vendedor = $DB->consultaOne($c04);
			$nvendedor = $vendedor->vendedor;
			$resultado = array();
			$resultado["baja"] = $baja;
			$resultado["dets"] = $dets;
			$resultado["usuario"] = $nusuario;
			$resultado["sucursal"] = $nsucursal;
			$resultado["vendedor"] = $nvendedor;
			break;
			/* --------------------- Inventarios ---------------------------- */
		case 'listarInventarios':
			$sucursal = $body["idsucursal"];
			$c02 = "SELECT i.lote, i.fecha_vencimiento, p.id_producto, p.codigo, p.imagen, p.codigo_barras, p.precio_tope, p.nombre,  p.marca,  p.unidad, p.precio_compra, p.precio_venta, p.precio_especial, p.precio_mayor, p.stock_minimo, SUM(i.cantidad) AS stock , i.precio_compra, i.precio_venta , sum(i.precio_compra) as total , sum(i.precio_venta) as total1 FROM inventario AS i, producto as p WHERE i.id_producto = p.id_producto AND i.id_sucursal='" . $sucursal . "' AND i.cantidad > 0 AND i.estado = 'VERIFICADO' GROUP BY i.id_producto, i.lote ";
			$items = $DB->consultaAll($c02);
			$resultado = array();
			$resultado["items"] = $items;
			break;
		case 'stockInventario':
			$sucursal = $body["idsucursal"];
			$c00 = "SELECT sum(cantidad) as stocktotal FROM inventario WHERE id_sucursal='" . $sucursal . "' and estado='VERIFICADO'";
			$stock = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["stock"] = $stock;
			break;

		case 'buscarCodigoBarrasIngreso':
			$producto = array();
			$codigob = $body["codigob"];

			$c00 = "SELECT * FROM producto WHERE codigo_barras = '" . $codigob . "'";
			$producto = $DB->consultaOne($c00);

			if ($producto) {
				$producto->CANTIDAD = 1; 
			}

			$resultado = array();
			$resultado["producto"] = $producto;

			break;


		case 'buscarCodigoBarras':
			$producto = array();
			$codigob = $body["codigob"];
			$ids = $body["idsucursal"];
			$iduser = $body["iduser"];
			$lote = isset($body["lote"]) ? $body["lote"] : "";

			// Obtener el producto por código de barras
			$c00 = "SELECT id_producto, vencimiento, unidad FROM producto WHERE codigo_barras = '" . $codigob . "'";
			$resVencimiento = $DB->consultaOne($c00);

			if (!$resVencimiento) {
				throw new Exception("PRODUCTO NO ENCONTRADO.");
			}

			$idProducto = $resVencimiento->id_producto;

			if ($resVencimiento->vencimiento == 'SI' && empty($lote)) {
				throw new Exception("EL PRODUCTO TIENE VENCIMIENTO, SE REQUIERE EL LOTE.");
			}

			if ($resVencimiento->vencimiento == 'SI' && !empty($lote)) {
				$c01 = "SELECT SUM(cantidad) AS stock, MIN(id_inventario) AS min_id 
						FROM inventario 
						WHERE id_producto = '" . $idProducto . "' 
						AND lote = '" . $lote . "' 
						AND id_sucursal = '" . $ids . "' 
						AND cantidad > 0 AND leido = 0";
			} else {
				$c01 = "SELECT SUM(cantidad) AS stock, MIN(id_inventario) AS min_id 
						FROM inventario 
						WHERE id_producto = '" . $idProducto . "' 
						AND id_sucursal = '" . $ids . "' 
						AND cantidad > 0 AND leido = 0";
			}

			$resStock = $DB->consultaOne($c01);

			if (!$resStock || $resStock->stock <= 0) {
				throw new Exception("NO HAY STOCK DISPONIBLE PARA EL PRODUCTO.");
			}

			$minIdInventario = $resStock->min_id;

			if ($resVencimiento->unidad == 'UNIDAD' && $minIdInventario) {
				$c02 = "UPDATE inventario SET leido = '" . $iduser . "' WHERE id_inventario = '" . $minIdInventario . "'";
				$updateResult = $DB->consulta($c02);
				if (!$updateResult) {
					throw new Exception("ERROR AL MARCAR INVENTARIO COMO LEÍDO.");
				}
			}

			$c03 = "SELECT I.ID_INVENTARIO, I.ID_SUCURSAL, I.FECHA_INGRESO, I.FECHA_VENCIMIENTO, I.LOTE, I.PRECIO_COMPRA, 
					I.PRECIO_VENTA, I.CANTIDAD, I.LEIDO, I.ESTADO, 
					P.ID_PRODUCTO, P.CODIGO, P.NOMBRE, P.MARCA, P.UNIDAD, P.PRECIO_TOPE, 
					P.PRECIO_ESPECIAL, P.PRECIO_MAYOR, P.STOCK_MINIMO, P.IMAGEN, 
					P.CODIGO_BARRAS, P.CODIGO_SIN, P.CODIGO_ACTIVIDAD, P.UNIDAD_MEDIDA 
					FROM inventario I 
					JOIN producto P ON I.ID_PRODUCTO = P.ID_PRODUCTO 
					WHERE I.ID_PRODUCTO = '" . $idProducto . "' 
					AND I.ID_INVENTARIO = '" . $minIdInventario . "'";

			$productoInventario = $DB->consultaOne($c03);

			if (!$productoInventario) {
				throw new Exception("NO SE ENCONTRÓ EL PRODUCTO O INVENTARIO CORRESPONDIENTE.");
			}

			$resultado = array();
			$resultado["producto"] = $productoInventario;

			break;

		case 'verificarStock':
			$idProducto = $body["idproducto"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$lote = $body["lote"];
		
			$c00 = "SELECT vencimiento, unidad  FROM producto WHERE id_producto = '" . $idProducto . "'";
			$resVencimiento = $DB->consultaOne($c00);

			if (!$resVencimiento ) {
				$nmsj = "PRODUCTO NO ENCONTRADO O VENCIMIENTO VACÍO.";
				throw new Exception($nmsj);
			}
		
			if ($resVencimiento->vencimiento == 'SI' && empty($lote)) {
				$nmsj = "EL PRODUCTO TIENE VENCIMIENTO, SE REQUIERE EL LOTE.";
				throw new Exception($nmsj);
			}
		
			if ($resVencimiento && $resVencimiento->vencimiento == 'SI' && !empty($lote)) {
				$c01 = "SELECT SUM(cantidad) AS stock, MIN(id_inventario) AS min_id FROM inventario WHERE id_producto = '" . $idProducto . "' AND lote = '" . $lote . "' AND id_sucursal = '" . $idsucursal . "' AND cantidad > 0 AND leido = 0";
			} else {
				$c01 = "SELECT SUM(cantidad) AS stock, MIN(id_inventario) AS min_id FROM inventario WHERE id_producto = '" . $idProducto . "' AND id_sucursal = '" . $idsucursal . "' AND cantidad > 0 AND leido = 0";
			}
			$resStock = $DB->consultaOne($c01);
			//print_r($c01);die();
			if (!$resStock) {
				$nmsj = "NO SE ENCONTRÓ INFORMACIÓN DE STOCK PARA EL PRODUCTO ESPECIFICADO.";
				throw new Exception($nmsj);
			}
		
			$stockDisponible = ($resStock && $resStock->stock > 0) ? $resStock->stock : 0;
			$minIdInventario = ($resStock && $resStock->min_id) ? $resStock->min_id : null;
		
			if ($stockDisponible <= 0) {
				$nmsj = "NO HAY STOCK DISPONIBLE PARA EL PRODUCTO SOLICITADO.";
				throw new Exception($nmsj);
			}
		
			if ($stockDisponible > 0 && $minIdInventario) {
				if ($resVencimiento->unidad == 'UNIDAD') {
					$c02 = "UPDATE inventario SET leido = '".$iduser."' WHERE id_inventario = '" . $minIdInventario . "'";
					$updateResult = $DB->consulta($c02);

					if (!$updateResult) {
						$nmsj = "ERROR AL ACTUALIZAR EL ESTADO DE LECTURA DEL INVENTARIO.";
						throw new Exception($nmsj);
					}
				}	
			}
		
			$c03 = "SELECT I.ID_INVENTARIO, I.ID_SUCURSAL, I.FECHA_INGRESO, I.FECHA_VENCIMIENTO, I.LOTE, I.PRECIO_COMPRA, P.PRECIO_VENTA, I.CANTIDAD, I.LEIDO, I.ESTADO, P.ID_PRODUCTO, P.CODIGO, P.NOMBRE, P.MARCA, P.UNIDAD, P.PRECIO_TOPE, P.PRECIO_ESPECIAL, P.PRECIO_MAYOR, P.STOCK_MINIMO, P.IMAGEN, P.CODIGO_BARRAS, P.CODIGO_SIN, P.CODIGO_ACTIVIDAD, P.UNIDAD_MEDIDA FROM inventario I JOIN producto P ON I.ID_PRODUCTO = P.ID_PRODUCTO WHERE I.ID_PRODUCTO = '" . $idProducto . "' AND I.ID_INVENTARIO = '" . $minIdInventario . "'";
			$productoInventario = $DB->consultaOne($c03);
		
			if (!$productoInventario) {
				$nmsj = "NO SE ENCONTRÓ EL PRODUCTO O INVENTARIO CORRESPONDIENTE.";
				throw new Exception($nmsj);
			}
		
			$resultado = array();
			$resultado["producto"] = $productoInventario;
		
			break;
		case 'desmarcarLeidosId':
			$idProducto = $body["idproducto"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$c00 = "UPDATE inventario SET leido = '0' WHERE id_producto = '" . $idProducto . "' AND id_sucursal = '" . $idsucursal . "' AND leido = '" . $iduser . "' AND cantidad > 0";
			$updateResult = $DB->consulta($c00);
			$resultado = array();
			$resultado["res"] = $c00;
			break;

		case 'desmarcarLeidos':
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$c00 = "UPDATE inventario SET leido = '0' WHERE id_sucursal = '" . $idsucursal . "'  AND cantidad > 0";
			$updateResult = $DB->consulta($c00);
			$resultado = array();
			$resultado["res"] = $c00;
			break;
		case 'actualizarLeidos':
			$idProducto = $body["idproducto"];
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$diferencia = floatval($body["diferencia"]);
			$valor = floatval($body["valor"]);
			$lote = $body["lote"];

			$c0 = "SELECT unidad FROM producto WHERE id_producto = '" . $idProducto . "' ";
			$producto = $DB->consultaOne($c0);

			$c00 = "SELECT SUM(cantidad) AS stock FROM inventario WHERE id_producto = '" . $idProducto . "' AND lote = '" . $lote . "' AND id_sucursal = '" . $idsucursal . "' AND cantidad > 0 ";
			$res = $DB->consultaOne($c00);

			$totalstock = floatval($res->stock) ;

			if ($valor > $totalstock) {
				$nmsj = "NO HAY SUFICIENTE STOCK DISPONIBLE. STOCK ACTUAL: $totalstock | SOLICITADO: $valor";
				throw new Exception($nmsj);
			}

			if ($diferencia > 0) {
				for ($j = 0; $j < $diferencia; $j++) {
					$c01 = "SELECT SUM(cantidad) AS stock, MIN(id_inventario) AS min_id FROM inventario WHERE id_producto = '" . $idProducto . "' AND lote = '" . $lote . "' AND id_sucursal = '" . $idsucursal . "' AND cantidad > 0 AND leido = 0";
					$resStock = $DB->consultaOne($c01);
			
					if (!$resStock) {
						$nmsj = "NO SE ENCONTRÓ INFORMACIÓN DE STOCK PARA EL PRODUCTO ESPECIFICADO.";
						throw new Exception($nmsj);
					}
				
					$stockDisponible = ($resStock && $resStock->stock > 0) ? $resStock->stock : 0;
					$minIdInventario = ($resStock && $resStock->min_id) ? $resStock->min_id : null;
				
					if ($stockDisponible <= 0) {
						$nmsj = "NO HAY STOCK DISPONIBLE PARA EL PRODUCTO SOLICITADO.";
						throw new Exception($nmsj);
					}
				
					if ($stockDisponible > 0 && $minIdInventario) {
						if ($producto->unidad == 'UNIDAD') {
							$c02 = "UPDATE inventario SET leido = '".$iduser."' WHERE id_inventario = '" . $minIdInventario . "'";
							$updateResult = $DB->consulta($c02);
							
							if (!$updateResult) {
								$nmsj = "ERROR AL ACTUALIZAR EL ESTADO DE LECTURA DEL INVENTARIO.";
								throw new Exception($nmsj);
							}
						}
					}	
				}
			} else {
				$diferencia = abs($diferencia);
				for ($j = 0; $j < $diferencia; $j++) {
					$c01 = "SELECT SUM(cantidad) AS stock, MAX(id_inventario) AS max_id FROM inventario WHERE id_producto = '" . $idProducto . "' AND lote = '" . $lote . "' AND id_sucursal = '" . $idsucursal . "' AND cantidad > 0 AND leido = '".$iduser."' ";
					$resStock = $DB->consultaOne($c01);
			
					if (!$resStock) {
						$nmsj = "NO SE ENCONTRÓ INFORMACIÓN DE STOCK PARA EL PRODUCTO ESPECIFICADO.";
						throw new Exception($nmsj);
					}
				
					$stockDisponible = ($resStock && $resStock->stock > 0) ? $resStock->stock : 0;
					$maxIdInventario = ($resStock && $resStock->max_id) ? $resStock->max_id : null;
				
					if ($stockDisponible <= 0) {
						$nmsj = "NO HAY STOCK DISPONIBLE PARA EL PRODUCTO SOLICITADO.";
						throw new Exception($nmsj);
					}
				
					if ($stockDisponible > 0 && $maxIdInventario) {
						if ($producto->unidad == 'UNIDAD') {
							$c02 = "UPDATE inventario SET leido = '0' WHERE id_inventario = '" . $maxIdInventario . "'";
							$updateResult = $DB->consulta($c02);
							
							if (!$updateResult) {
								$nmsj = "ERROR AL ACTUALIZAR EL ESTADO DE LECTURA DEL INVENTARIO.";
								throw new Exception($nmsj);
							}
						}
					}
					
				}
			}
			$resultado = array();
			$resultado["exito"] = $updateResult ? true : false;
			break;
			/* ---------------------  Arqueo ---------------------------- */
		case 'verificarArqueo':
			$sucursal = $body["idsucursal"];
			$user = $body["iduser"];
			$c00 = "SELECT * FROM arqueo WHERE id_sucursal='" . $sucursal . "' AND id_user = '" . $user . "' AND estado = 'INICIADO' ";
			$arqueo = $DB->consultaOne($c00);
			$resultado = array();
			$resultado["arqueo"] = $arqueo;
			break;
		case 'newArqueo':
			$sucursal = $body["idsucursal"];
			$user = $body["iduser"];
			$saldo = $body["saldo"];
			$turno = $body["turno"];

			$c00 = "select IFNULL(MAX(boleta) + 1, 1) AS boleta from arqueo where id_sucursal = '" . $sucursal . "'";
			$selectRes = $DB->consultaOne($c00);
			$bol = $selectRes->boleta;

			$c00 = "INSERT INTO arqueo VALUES (default, '" . $sucursal . "', '" . $user . "', now(), '" . $bol . "', now(), now(), '" . $turno . "', '" . $saldo . "', '0', '0', '0', '0', '0', '0', 'INICIADO');";
			$insertarq = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $insertarq;
			break;
		case 'verArqueo':
			$sucursal = $body["idsucursal"];
			$user = $body["iduser"];
			$vefe = 0;
			$vtj = 0;
			$vqr = 0;
			$ingre = 0;
			$egre = 0;

			$c0 = "SELECT id_arqueo, saldo_anterior FROM arqueo WHERE id_sucursal='" . $sucursal . "' AND id_user = '" . $user . "' AND estado = 'INICIADO'";
			$arqueo = $DB->consultaOne($c0);
			$idarq = $arqueo->id_arqueo;
			if ($idarq == null) {
				$nmsj = "NO SE PUEDE CERRAR UN ARQUEO SI NO TIENE UNO INICIADO";
				throw new Exception($nmsj);
			} else {
				$c00 = "SELECT sum(precio_total) as efectivo FROM ventas WHERE id_sucursal='" . $sucursal . "' AND id_user = '" . $user . "'  AND arqueo = '" . $idarq . "'  AND tipo_venta = 'EFECTIVO' AND estado = 'CONFIRMADO' ";
				$vefec = $DB->consultaOne($c00);
				$idvefe = $vefec->efectivo;
				if ($idvefe == null) {
					$vefe = 0;
				} else {
					$vefe = $vefec->efectivo;
				}

				$c01 = "SELECT sum(precio_total) as tarjeta FROM ventas WHERE id_sucursal='" . $sucursal . "' AND id_user = '" . $user . "'  AND arqueo = '" . $idarq . "'  AND tipo_venta = 'TARJETA' AND estado = 'CONFIRMADO'";
				$vtjj = $DB->consultaOne($c01);
				$idvtj = $vtjj->tarjeta;
				if ($idvtj == null) {
					$vtj = 0;
				} else {
					$vtj = $vtjj->tarjeta;
				}

				$c02 = "SELECT sum(precio_total) as qr FROM ventas WHERE id_sucursal='" . $sucursal . "' AND id_user = '" . $user . "'  AND arqueo = '" . $idarq . "'  AND tipo_venta = 'QR' AND estado = 'CONFIRMADO'";
				$vqrr = $DB->consultaOne($c02);
				$idvqr = $vqrr->qr;
				if ($idvqr == null) {
					$vqr = 0;
				} else {
					$vqr = $vqrr->qr;
				}

				$c03 = "SELECT sum(monto) as ingre FROM ingresos WHERE id_sucursal='" . $sucursal . "' AND id_user = '" . $user . "'  AND arqueo = '" . $idarq . "' AND estado = 'VALIDO'";
				$ingres = $DB->consultaOne($c03);
				$iding = $ingres->ingre;
				if ($iding == null) {
					$ingre = 0;
				} else {
					$ingre = $ingres->ingre;
				}

				$c04 = "SELECT sum(monto) as egre FROM egresos WHERE id_sucursal='" . $sucursal . "' AND id_user = '" . $user . "'  AND arqueo = '" . $idarq . "' AND estado = 'VALIDO'";
				$egres = $DB->consultaOne($c04);
				$idegre = $egres->egre;
				if ($idegre == null) {
					$egre = 0;
				} else {
					$egre = $egres->egre;
				}
			}
			$resultado = array();
			$resultado["vefe"] = $vefe;
			$resultado["vtj"] = $vtj;
			$resultado["vqr"] = $vqr;
			$resultado["ingre"] = $ingre;
			$resultado["egre"] = $egre;
			$resultado["arqueo"] = $arqueo;
			break;
		case 'listarArqueos':
			$arqueos = array();
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$c00 = "SELECT * FROM arqueo WHERE id_sucursal='" . $idsucursal . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND id_user = '" . $iduser . "'";
			}

			$c00 .= " order by id_arqueo desc";
			$arq = $DB->consultaAll($c00);
			for ($j = 0; $j < $arq["size"]; $j++) {
				$c01 = "select nombres, apellidos, usuario from user where id_user='" . $arq["data"][$j]->ID_USER . "'";
				$cajero = $DB->consultaOne($c01);
				$c02 = "select sucursal from sucursal where id_sucursal='" . $arq["data"][$j]->ID_SUCURSAL . "'";
				$sucursal = $DB->consultaOne($c02);

				$detitem = new stdClass();
				$detitem->fecha_registro   = $arq["data"][$j]->FECHA_REGISTRO;
				$detitem->sucursal         = $sucursal->sucursal;
				$detitem->cajero           = $cajero->nombres . " " . $cajero->apellidos;
				$detitem->turno            = $arq["data"][$j]->TURNO;
				$detitem->boleta           = $arq["data"][$j]->BOLETA;
				$detitem->id_arqueo        = $arq["data"][$j]->ID_ARQUEO;
				$detitem->saldo_anterior   = (float)$arq["data"][$j]->SALDO_ANTERIOR;
				$detitem->venta_ef         = (float)$arq["data"][$j]->VENTA_EF;
				$detitem->venta_tj         = (float)$arq["data"][$j]->VENTA_TJ;
				$detitem->venta_qr         = (float)$arq["data"][$j]->VENTA_QR;
				$detitem->otros_ingresos   = (float)$arq["data"][$j]->OTROS_INGRESOS;
				$detitem->egresos          = (float)$arq["data"][$j]->EGRESOS;

				// Calculamos total_general y lo redondeamos a 2 decimales
				$detitem->total_general = round(
					$detitem->saldo_anterior
				+ $detitem->venta_ef
				+ $detitem->venta_tj
				+ $detitem->venta_qr
				+ $detitem->otros_ingresos
				- $detitem->egresos
				, 2);


				$detitem->estado           = $arq["data"][$j]->ESTADO;
				array_push($arqueos, $detitem);

			}
			$resultado = array();
			$resultado["arqueos"] = $arqueos;
			break;
		case 'procesarArqueo':
			$sucursal = $body["idsucursal"];
			$user = $body["iduser"];
			$idarqueo = $body["idarqueo"];
			$vefe = $body["vefe"];
			$vtj = $body["vtj"];
			$vqr = $body["vqr"];
			$total = $body["total"];
			$ingre = $body["ingre"];
			$egre = $body["egre"];

			$c03 = "update arqueo set FECHA_HORA_FIN=now(),VENTA_EF='" . $vefe . "',VENTA_TJ='" . $vtj . "',VENTA_QR='" . $vqr . "',OTROS_INGRESOS='" . $ingre . "',EGRESOS='" . $egre . "',TOTAL_GENERAL='" . $total . "', ESTADO='TERMINADO' WHERE id_arqueo='" . $idarqueo . "'";
			$updateArqueo = $DB->consulta($c03);

			$resultado = array();
			$resultado["arqueo"] = $updateArqueo;
			break;
		case 'verBoletaArqueo':
			$idarqueo = $body["idarqueo"];

			$c00 = "SELECT * FROM arqueo WHERE id_arqueo='" . $idarqueo . "'";
			$arqueo = $DB->consultaOne($c00);

			$c01 = "select * from user where id_user='" . $arqueo->ID_USER . "' ";
			$usuario = $DB->consultaOne($c01);

			$c02 = "select * from sucursal where id_sucursal='" . $arqueo->ID_SUCURSAL . "' ";
			$sucursal = $DB->consultaOne($c02);

			$resultado = array();
			$resultado["arqueo"] = $arqueo;
			$resultado["usuario"] = $usuario;
			$resultado["sucursal"] = $sucursal;
			break;
			/* ------------------------- EGRESOS --------------------------- */
		case 'listarEgresos':
			$egresos = array();
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$c00 = "SELECT * FROM egresos WHERE id_sucursal='" . $idsucursal . "' and DATE(fecha_registro) >= '" . $fini . "' and DATE(fecha_registro) <='" . $ffin . "'  ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND id_user = '" . $iduser . "'";
			}

			$c00 .= " order by id_egreso desc";
			$egre = $DB->consultaAll($c00);
			for ($j = 0; $j < $egre["size"]; $j++) {
				$c01 = "select nombres, apellidos, usuario from user where id_user='" . $egre["data"][$j]->ID_USER . "'";
				$cajero = $DB->consultaOne($c01);
				$c02 = "select sucursal from sucursal where id_sucursal='" . $egre["data"][$j]->ID_SUCURSAL . "'";
				$sucursal = $DB->consultaOne($c02);

				$detitem = new stdClass();
				$detitem->fecha_registro		= $egre["data"][$j]->FECHA_REGISTRO;
				$detitem->sucursal				= $sucursal->sucursal;
				$detitem->cajero				= $cajero->nombres . " " . $cajero->apellidos;
				$detitem->id_arqueo				= $egre["data"][$j]->ARQUEO;
				$detitem->boleta				= $egre["data"][$j]->BOLETA;
				$detitem->id_egreso				= $egre["data"][$j]->ID_EGRESO;
				$detitem->tipo_egreso			= $egre["data"][$j]->TIPO;
				$detitem->glosa					= $egre["data"][$j]->DETALLE;
				$detitem->monto					= $egre["data"][$j]->MONTO;
				$detitem->estado				= $egre["data"][$j]->ESTADO;
				array_push($egresos, $detitem);
			}
			$resultado = array();
			$resultado["egresos"] = $egresos;
			break;
		case 'listarEgresos':
			$egresos = array();
			$idsucursal = $body["idsucursal"];
			$rol = $body["idrol"];
			$iduser = $body["iduser"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$c00 = "SELECT * FROM egresos WHERE id_sucursal='" . $idsucursal . "' and DATE(fecha_registro) >= '" . $fini . "' and DATE(fecha_registro) <='" . $ffin . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND id_user = '" . $iduser . "'";
			}

			$c00 .= "order by id_egreso desc";
			$egre = $DB->consultaAll($c00);
			for ($j = 0; $j < $egre["size"]; $j++) {
				$c01 = "select nombres, apellidos, usuario from user where id_user='" . $egre["data"][$j]->ID_USER . "'";
				$cajero = $DB->consultaOne($c01);
				$c02 = "select sucursal from sucursal where id_sucursal='" . $egre["data"][$j]->ID_SUCURSAL . "'";
				$sucursal = $DB->consultaOne($c02);

				$detitem = new stdClass();
				$detitem->fecha_registro		= $egre["data"][$j]->FECHA_REGISTRO;
				$detitem->sucursal				= $sucursal->sucursal;
				$detitem->cajero				= $cajero->nombres . " " . $cajero->apellidos;
				$detitem->id_arqueo				= $egre["data"][$j]->ARQUEO;
				$detitem->boleta				= $egre["data"][$j]->BOLETA;
				$detitem->id_egreso				= $egre["data"][$j]->ID_EGRESO;
				$detitem->tipo_egreso			= $egre["data"][$j]->TIPO;
				$detitem->glosa					= $egre["data"][$j]->DETALLE;
				$detitem->monto					= $egre["data"][$j]->MONTO;
				$detitem->estado				= $egre["data"][$j]->ESTADO;
				$detitem->tipo_pago				= $egre["data"][$j]->TIPO_PAGO;
				array_push($egresos, $detitem);
			}
			$resultado = array();
			$resultado["egresos"] = $egresos;
			break;
		case 'newEgreso':
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$monto = $body["monto"];
			$detalle = $body["detalle"];
			$glosa = $body["glosa"];
			$tipopago = $body["tipopago"];
			$c00 = "SELECT id_arqueo FROM arqueo WHERE id_sucursal='" . $idsucursal . "' AND id_user = '" . $iduser . "' AND estado = 'INICIADO' ";
			$arqueo = $DB->consultaOne($c00);
			$idarqueo = $arqueo->id_arqueo;
			if ($idarqueo == null) {
				$nmsj = "NO SE PUEDE REALIZAR UN INGRESO SI NO ABRE UN ARQUEO";
				throw new Exception($nmsj);
			}
			$c01 = "SELECT IFNULL(MAX(boleta) + 1, 1) AS boleta from egresos where id_sucursal = '" . $idsucursal . "'";
			$selectRes1 = $DB->consultaOne($c01);
			$bol = $selectRes1->boleta;
			$c02 = "INSERT INTO egresos VALUES (DEFAULT, '" . $idsucursal . "', '" . $iduser . "',now(), '" . $bol . "', '" . $tipopago . "', '" . $detalle . "', '" . $glosa . "', '" . $monto . "', '" . $idarqueo . "','VALIDO');";
			$insert = $DB->consulta($c02);
			$resultado = array();
			$resultado["ok"] = $insert;
			break;
		case 'deleteEgreso':
			$id = $body["id"];
			$c00 = " delete from egresos where id_egreso ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
			/* ------------------------- INGRESOS --------------------------- */
		case 'listarIngresos':
			$ingresos = array();
			$idsucursal = $body["idsucursal"];
			$rol = $body["idrol"];
			$iduser = $body["iduser"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$c00 = "SELECT * FROM ingresos WHERE id_sucursal='" . $idsucursal . "' and DATE(fecha_registro) >= '" . $fini . "' and DATE(fecha_registro) <='" . $ffin . "'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND id_user = '" . $iduser . "'";
			}

			$c00 .= " order by id_ingreso desc";
			$ingre = $DB->consultaAll($c00);
			for ($j = 0; $j < $ingre["size"]; $j++) {
				$c01 = "select nombres, apellidos, usuario from user where id_user='" . $ingre["data"][$j]->ID_USER . "'";
				$cajero = $DB->consultaOne($c01);
				$c02 = "select sucursal from sucursal where id_sucursal='" . $ingre["data"][$j]->ID_SUCURSAL . "'";
				$sucursal = $DB->consultaOne($c02);

				$detitem = new stdClass();
				$detitem->fecha_registro		= $ingre["data"][$j]->FECHA_REGISTRO;
				$detitem->sucursal				= $sucursal->sucursal;
				$detitem->cajero				= $cajero->nombres . " " . $cajero->apellidos;
				$detitem->id_arqueo				= $ingre["data"][$j]->ARQUEO;
				$detitem->boleta				= $ingre["data"][$j]->BOLETA;
				$detitem->id_ingreso			= $ingre["data"][$j]->ID_INGRESO;
				$detitem->tipo_ingreso			= $ingre["data"][$j]->TIPO;
				$detitem->glosa					= $ingre["data"][$j]->DETALLE;
				$detitem->monto					= $ingre["data"][$j]->MONTO;
				$detitem->estado				= $ingre["data"][$j]->ESTADO;
				$detitem->tipo_pago				= $ingre["data"][$j]->TIPO_PAGO;
				array_push($ingresos, $detitem);
			}
			$resultado = array();
			$resultado["ingresos"] = $ingresos;
			break;
		case 'newIngreso':
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$monto = $body["monto"];
			$detalle = $body["detalle"];
			$ingreso = $body["ingreso"];
			$tipopago = $body["tipopago"];
			$c00 = "SELECT id_arqueo FROM arqueo WHERE id_sucursal='" . $idsucursal . "' AND id_user = '" . $iduser . "' AND estado = 'INICIADO' ";
			$arqueo = $DB->consultaOne($c00);
			$idarqueo = $arqueo->id_arqueo;
			if ($idarqueo == null) {
				$nmsj = "NO SE PUEDE REALIZAR UN INGRESO SI NO ABRE UN ARQUEO";
				throw new Exception($nmsj);
			}

			$c01 = "SELECT IFNULL(MAX(boleta) + 1, 1) AS boleta from ingresos where id_sucursal = '" . $idsucursal . "'";
			$selectRes1 = $DB->consultaOne($c01);
			$bol = $selectRes1->boleta;

			$c02 = "INSERT INTO ingresos VALUES (DEFAULT, '" . $idsucursal . "', '" . $iduser . "',now(), '" . $bol . "', '" . $tipopago . "','" . $ingreso . "',  '" . $detalle . "', '" . $monto . "','" . $idarqueo . "','VALIDO');";
			$insert = $DB->consulta($c02);
			$resultado = array();
			$resultado["ok"] = $insert;
			break;
		case 'deleteIngreso':
			$id = $body["id"];
			$c00 = " delete from ingresos where id_ingreso ='" . $id . "';";
			$delete = $DB->consulta($c00);
			$resultado = array();
			$resultado["ok"] = $delete;
			break;
		case 'verIngreso':
			$id = $body["idingreso"];

			$c00 = "select * from ingresos where id_ingreso='" . $id . "' ";
			$ingreso = $DB->consultaOne($c00);

			$c01 = "select * from user where id_user='" . $ingreso->ID_USER . "' ";
			$usuario = $DB->consultaOne($c01);

			$c02 = "select * from sucursal where id_sucursal='" . $ingreso->ID_SUCURSAL . "' ";
			$sucursal = $DB->consultaOne($c02);

			$resultado = array();
			$resultado["ingreso"] = $ingreso;
			$resultado["usuario"] = $usuario;
			$resultado["sucursal"] = $sucursal;
			break;
			/* ------------------------- INICIO --------------------------- */
		case 'cargarInicio':
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c00 = "SELECT SUM(precio_total) AS total, COUNT(DISTINCT id_compra)  AS cantidad FROM compras WHERE id_sucursal='" . $idsucursal . "' AND DATE(fecha_registro) >= '" . $fini . "' AND DATE(fecha_registro) <= '" . $ffin . "' AND estado = 'VERIFICADO'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND id_user = '" . $iduser . "'";
			}
			$compra = $DB->consultaOne($c00);

			$c01 = "SELECT SUM(precio_total) AS total, COUNT(DISTINCT id_venta)  AS cantidad FROM ventas WHERE id_sucursal='" . $idsucursal . "' AND DATE(fecha_registro) >= '" . $fini . "' AND DATE(fecha_registro) <= '" . $ffin . "' AND estado = 'CONFIRMADO'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c01 .= " AND id_user = '" . $iduser . "'";
			}
			$venta = $DB->consultaOne($c01);

			$c02 = "SELECT SUM(precio_total) AS total, COUNT(DISTINCT id_ajuste)  AS cantidad FROM ajustes WHERE id_sucursal = '" . $idsucursal . "' AND DATE(fecha_registro) >= '" . $fini . "' AND DATE(fecha_registro) <= '" . $ffin . "'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c02 .= " AND id_user = '" . $iduser . "'";
			}
			$ajuste = $DB->consultaOne($c02);

			$c03 = "SELECT SUM(precio_total) AS total, COUNT(DISTINCT id_traspaso)  AS cantidad FROM traspasos WHERE id_sucursal_origen = '" . $idsucursal . "' AND DATE(fecha_registro) >= '" . $fini . "' AND DATE(fecha_registro) <= '" . $ffin . "'  AND estado = 'CONFIRMADO'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c03 .= " AND id_user = '" . $iduser . "'";
			}
			$traspaso_enviado = $DB->consultaOne($c03);

			$c04 = "SELECT SUM(precio_total) AS total, COUNT(DISTINCT id_traspaso)  AS cantidad FROM traspasos WHERE id_sucursal_destino = '" . $idsucursal . "' AND DATE(fecha_registro) >= '" . $fini . "' AND DATE(fecha_registro) <= '" . $ffin . "'  AND estado = 'CONFIRMADO'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c04 .= " AND id_user = '" . $iduser . "'";
			}
			$traspaso_recibido = $DB->consultaOne($c04);

			$c05 = "SELECT SUM(precio_total) AS total, COUNT(DISTINCT id_baja) AS cantidad FROM bajas WHERE id_sucursal = '" . $idsucursal . "' AND DATE(fecha_registro) >= '" . $fini . "' AND DATE(fecha_registro) <= '" . $ffin . "'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c05 .= " AND id_user = '" . $iduser . "'";
			}
			$baja = $DB->consultaOne($c05);

			$c06 = "SELECT SUM(monto) AS total, COUNT(DISTINCT id_egreso)  AS cantidad FROM egresos WHERE id_sucursal='" . $idsucursal . "' AND DATE(fecha_registro) >= '" . $fini . "' AND DATE(fecha_registro) <= '" . $ffin . "' AND estado = 'VALIDO'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c06 .= " AND id_user = '" . $iduser . "'";
			}
			$egreso = $DB->consultaOne($c06);

			$c07 = "SELECT SUM(monto) AS total, COUNT(DISTINCT id_ingreso)  AS cantidad FROM ingresos WHERE id_sucursal='" . $idsucursal . "' AND DATE(fecha_registro) >= '" . $fini . "' AND DATE(fecha_registro) <= '" . $ffin . "' AND estado = 'VALIDO'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c07 .= " AND id_user = '" . $iduser . "'";
			}
			$ingreso = $DB->consultaOne($c07);

			$c08 = "SELECT SUM(montoTotal) AS total, COUNT(DISTINCT id) AS cantidad FROM siat_factura WHERE idPuntoVenta = '" . $idsucursal . "' AND fecha >= '" . $fini . "' AND fecha <= '" . $ffin . "' AND estado = 'VALIDO'";
			$factura = $DB->consultaOne($c08);



			$nini = primerDiaMes();
			$nfin = ultimoDiaMes();
			if ($fini == $ffin) {
				$tiempo = "Hoy";
			} else if ($fini == $nini && $nfin == $ffin) {
				$tiempo = "Mensual";
			} else {
				$tiempo = "Rango";
			}

			$resultado = array();
			$resultado["ingreso"] = $ingreso;
			$resultado["egreso"] = $egreso;
			$resultado["venta"] = $venta;
			$resultado["compra"] = $compra;
			$resultado["enviado"] = $traspaso_enviado;
			$resultado["recibido"] = $traspaso_recibido;
			$resultado["baja"] = $baja;
			$resultado["ajuste"] = $ajuste;
			$resultado["factura"] = $factura;
			$resultado["tiempo"] = $tiempo;
			break;
		case 'cargarInicioMovil':
			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c00 = "SELECT IFNULL(SUM(precio_total), 0) AS total, IFNULL(COUNT(DISTINCT id_venta), 0) AS cantidad FROM ventas WHERE id_sucursal='$idsucursal' AND tipo_venta='EFECTIVO' AND DATE(fecha_registro) >= '$fini' AND DATE(fecha_registro) <= '$ffin' AND estado = 'CONFIRMADO' ";
			
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND id_user = '" . $iduser . "'";
			}
			$ventaefectivo = $DB->consultaOne($c00);

			$c01 = "SELECT IFNULL(SUM(precio_total), 0) AS total, IFNULL(COUNT(DISTINCT id_venta), 0) AS cantidad FROM ventas WHERE id_sucursal='$idsucursal' AND tipo_venta='QR' AND DATE(fecha_registro) >= '$fini' AND DATE(fecha_registro) <= '$ffin' AND estado = 'CONFIRMADO'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c01 .= " AND id_user = '" . $iduser . "'";
			}
			$ventaqr = $DB->consultaOne($c01);

			$c02 = "SELECT IFNULL(SUM(p.MONTO), 0) AS total, IFNULL(COUNT(DISTINCT v.ID_VENTA), 0) AS cantidad FROM ventas v INNER JOIN pagos p ON v.ID_VENTA = p.ID_VENTA WHERE v.ID_SUCURSAL = '$idsucursal' AND v.TIPO_VENTA = 'CREDITO' AND DATE(p.FECHA_PAGO) >= '$fini' AND DATE(p.FECHA_PAGO) <= '$ffin' AND v.estado = 'CONFIRMADO'";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c02 .= " AND v.id_user = '" . $iduser . "'";
			}
			$ventacredito = $DB->consultaOne($c02);

			$c03 = "SELECT IFNULL(SUM(montoTotal), 0) AS total, IFNULL(COUNT(DISTINCT id), 0) AS cantidad FROM siat_factura WHERE idPuntoVenta = '$idsucursal' AND fecha >= '$fini' AND fecha <= '$ffin' AND estado = 'VALIDO'";
			$factura = $DB->consultaOne($c03);

			$c04 = "SELECT IFNULL(SUM(cantidad), 0) AS cantidad, IFNULL(SUM(precio_compra), 0) AS total FROM inventario WHERE id_sucursal='$idsucursal' AND estado='VERIFICADO' AND cantidad > 0";
			$inventario = $DB->consultaOne($c04);

			$nini = primerDiaMes();
			$nfin = ultimoDiaMes();
			if ($fini == $ffin) {
				$tiempo = "Hoy";
			} else if ($fini == $nini && $nfin == $ffin) {
				$tiempo = "Mensual";
			} else {
				$tiempo = "Rango";
			}

			$resultado = array();
			$resultado["ventaefectivo"] = $ventaefectivo;
			$resultado["ventaqr"] = $ventaqr;
			$resultado["ventacredito"] = $ventacredito;
			$resultado["factura"] = $factura;
			$resultado["inventario"] = $inventario;
			$resultado["tiempo"] = $tiempo;
			break;
	}

	/* ---------------------------------------------------- */
	$DB->commit();
	$DB->close();

	Response::sendOne($resultado);
} catch (Exception $e) {
	$DB->rollback();
	$DB->close();
	Response::sendError($e);
}
