<?php
date_default_timezone_set("America/La_Paz");
header('Content-Type: text/html; charset=UTF-8');
include "../api.php";
try {

	$body = Response::getBody();
	error_reporting(0);

	/* ---------------------------------------------------- */
	$DB = new DB();
	$DB->conectar();
	$DB->begin();
	/* ---------------------------------------------------- */
	$fechareg = date("Y-m-d H:i:s");
	$newfecha = date("Y-m-d");
	$newhora = date("G:i:s");
	$funcion = $body["funcion"];
	switch ($funcion) {
			/* ------------------------- INICIO --------------------------- */
		case 'cargarInicio':
			$idsucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c01 = "select IFNULL(SUM(COALESCE(montoTotal, 0)), 0) AS total, count(*) as cantidad  from siat_factura where idPuntoVenta='" . $idsucursal . "'  and date(fecha) >= '" . $fini . "' and date(fecha) <='" . $ffin . "' ";
			$factura = $DB->consultaOne($c01);

			$c02 = "select IFNULL(SUM(COALESCE(monto, 0)), 0) AS total, count(*) as cantidad  from egresos where id_sucursal='" . $idsucursal . "'  and date(fecha_registro) >= '" . $fini . "' and date(fecha_registro) <='" . $ffin . "' ";
			$egreso = $DB->consultaOne($c02);

			$c03 = "select IFNULL(SUM(COALESCE(monto, 0)), 0) AS total, count(*) as cantidad  from ingresos where id_sucursal='" . $idsucursal . "'  and date(fecha_registro) >= '" . $fini . "' and date(fecha_registro) <='" . $ffin . "' ";
			$ingreso = $DB->consultaOne($c03);

			$nini = primerDiaMes();
			$nfin = ultimoDiaMes();
			if ($fini == $ffin) {
				$tiempo = "Hoy";
			} else if ($fini == $nini && $nfin == $ffin) {
				$tiempo = "Mensual";
			} else {
				$tiempo = "Rango";
			}
			$resultado = array();
			$resultado["ingreso"] = $ingreso;
			$resultado["egreso"] = $egreso;
			$resultado["factura"] = $factura;
			$resultado["tiempo"] = $tiempo;
			break;
		case 'verDatosMovimiento':
			$compras = array();
			$ventas = array();
			$ingresos = array();
			$egresos = array();
			$dias = array();

			$idsucursal = $body["idsucursal"];
			$iduser = $body["iduser"];
			$rol = $body["idrol"];
			$fecini = $body["fecini"];
			$partesFecha = explode('-', $fecini);

			// ===============================
			// COMPRAS
			// ===============================
			$c00 = "SELECT DAYOFMONTH(dia) AS dia, IFNULL(SUM(compras.precio_total), 0) AS compra_dia 
					FROM (SELECT DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY AS dia 
						FROM (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 
								UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t0, 
							(SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 
								UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t1 
						WHERE DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY <= LAST_DAY('" . $fecini . "')) AS dias 
					LEFT JOIN compras ON DAYOFMONTH(compras.fecha_registro) = DAYOFMONTH(dias.dia) 
					AND MONTH(compras.fecha_registro) = '" . $partesFecha[1] . "' 
					AND YEAR(compras.fecha_registro) = '" . $partesFecha[0] . "' 
					AND compras.id_sucursal = '" . $idsucursal . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c00 .= " AND compras.id_user = '" . $iduser . "'";
			}
			$c00 .= " GROUP BY dias.dia ORDER BY dias.dia;";

			$comp = $DB->consultaAll($c00);
			for ($i = 0; $i < $comp["size"]; $i++) {
				array_push($compras, $comp["data"][$i]->compra_dia);
				array_push($dias, $i + 1);
			}

			// ===============================
			// VENTAS
			// ===============================
			$c01 = "SELECT DAYOFMONTH(dia) AS dia, IFNULL(SUM(ventas.precio_total), 0) AS venta_dia 
					FROM (SELECT DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY AS dia 
						FROM (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 
								UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t0, 
							(SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 
								UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t1 
						WHERE DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY <= LAST_DAY('" . $fecini . "')) AS dias 
					LEFT JOIN ventas ON DAYOFMONTH(ventas.fecha_registro) = DAYOFMONTH(dias.dia) 
					AND MONTH(ventas.fecha_registro) = '" . $partesFecha[1] . "' 
					AND YEAR(ventas.fecha_registro) = '" . $partesFecha[0] . "' 
					AND ventas.id_sucursal = '" . $idsucursal . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c01 .= " AND ventas.id_user = '" . $iduser . "'";
			}
			$c01 .= " GROUP BY dias.dia ORDER BY dias.dia;";

			$vent = $DB->consultaAll($c01);
			for ($i = 0; $i < $vent["size"]; $i++) {
				array_push($ventas, $vent["data"][$i]->venta_dia);
			}

			// ===============================
			// INGRESOS
			// ===============================
			$c02 = "SELECT DAYOFMONTH(dia) AS dia, IFNULL(SUM(ingresos.monto), 0) AS ingreso_dia 
					FROM (SELECT DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY AS dia 
						FROM (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 
								UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t0, 
							(SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 
								UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t1 
						WHERE DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY <= LAST_DAY('" . $fecini . "')) AS dias 
					LEFT JOIN ingresos ON DAYOFMONTH(ingresos.fecha_registro) = DAYOFMONTH(dias.dia) 
					AND MONTH(ingresos.fecha_registro) = '" . $partesFecha[1] . "' 
					AND YEAR(ingresos.fecha_registro) = '" . $partesFecha[0] . "' 
					AND ingresos.id_sucursal = '" . $idsucursal . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c02 .= " AND ingresos.id_user = '" . $iduser . "'";
			}
			$c02 .= " GROUP BY dias.dia ORDER BY dias.dia;";

			$ing = $DB->consultaAll($c02);
			for ($i = 0; $i < $ing["size"]; $i++) {
				array_push($ingresos, $ing["data"][$i]->ingreso_dia);
			}

			// ===============================
			// EGRESOS
			// ===============================
			$c03 = "SELECT DAYOFMONTH(dia) AS dia, IFNULL(SUM(egresos.monto), 0) AS egreso_dia 
					FROM (SELECT DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY AS dia 
						FROM (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 
								UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t0, 
							(SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 
								UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t1 
						WHERE DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY <= LAST_DAY('" . $fecini . "')) AS dias 
					LEFT JOIN egresos ON DAYOFMONTH(egresos.fecha_registro) = DAYOFMONTH(dias.dia) 
					AND MONTH(egresos.fecha_registro) = '" . $partesFecha[1] . "' 
					AND YEAR(egresos.fecha_registro) = '" . $partesFecha[0] . "' 
					AND egresos.id_sucursal = '" . $idsucursal . "' ";
			if ($rol != 1 && $rol != 2 && $rol != 3) {
				$c03 .= " AND egresos.id_user = '" . $iduser . "'";
			}
			$c03 .= " GROUP BY dias.dia ORDER BY dias.dia;";

			$egr = $DB->consultaAll($c03);
			for ($i = 0; $i < $egr["size"]; $i++) {
				array_push($egresos, $egr["data"][$i]->egreso_dia);
			}

			// ===============================
			// Resultado final
			// ===============================
			$resultado = array();
			$resultado["compras"]  = $compras;
			$resultado["ventas"]   = $ventas;
			$resultado["ingresos"] = $ingresos;
			$resultado["egresos"]  = $egresos;
			$resultado["dias"]     = $dias;
			break;

			/* --------------------- Movimiento Ingreso - Egreso  ---------------------------- */
		case 'verDatosMovimiento':
			$ingresos = array();
			$egresos = array();
			$dias = array();
			$sucursal = $body["idsucursal"];
			$fecini = $body["fecini"];
			$partesFecha = explode('-', $fecini);
			$c00 = "SELECT DAYOFMONTH(dia) AS dia, IFNULL(SUM(ingresos.monto), 0) AS ingreso_dia FROM (SELECT DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY AS dia FROM (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t0, (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t1 WHERE DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY <= LAST_DAY('" . $fecini . "')) AS dias LEFT JOIN ingresos ON DAYOFMONTH(ingresos.fecha_registro) = DAYOFMONTH(dias.dia) AND MONTH(ingresos.fecha_registro) = '" . $partesFecha[1] . "' AND YEAR(ingresos.fecha_registro) = '" . $partesFecha[0] . "' AND ingresos.id_sucursal = '" . $sucursal . "' LEFT JOIN tipo_ingreso ON ingresos.tipo_ingreso = tipo_ingreso.ID_TIPO AND tipo_ingreso.ver_arqueo = 'SI' GROUP BY dias.dia ORDER BY dias.dia;";
			$ing = $DB->consultaAll($c00);
			for ($i = 0; $i < $ing["size"]; $i++) {
				array_push($ingresos, $ing["data"][$i]->ingreso_dia);
				array_push($dias, $i + 1);
			}
			$c01 = "SELECT DAYOFMONTH(dia) AS dia, IFNULL(SUM(egresos.monto), 0) AS egreso_dia FROM (SELECT DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY AS dia FROM (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t0, (SELECT 0 AS i UNION SELECT 1 UNION SELECT 2 UNION SELECT 3 UNION SELECT 4 UNION SELECT 5 UNION SELECT 6 UNION SELECT 7 UNION SELECT 8 UNION SELECT 9) t1 WHERE DATE('" . $fecini . "') + INTERVAL (t0.i + t1.i * 10) DAY <= LAST_DAY('" . $fecini . "')) AS dias LEFT JOIN egresos ON DAYOFMONTH(egresos.fecha_registro) = DAYOFMONTH(dias.dia) AND MONTH(egresos.fecha_registro) = '" . $partesFecha[1] . "' AND YEAR(egresos.fecha_registro) = '" . $partesFecha[0] . "' AND egresos.id_sucursal = '" . $sucursal . "' LEFT JOIN tipo_egreso ON egresos.tipo_egreso = tipo_egreso.ID_TIPO AND tipo_egreso.ver_arqueo = 'SI' GROUP BY dias.dia ORDER BY dias.dia;";
			$egre = $DB->consultaAll($c01);
			for ($i = 0; $i < $egre["size"]; $i++) {
				array_push($egresos, $egre["data"][$i]->egreso_dia);
			}
			$resultado = array();
			$resultado["ingresos"] = $ingresos;
			$resultado["egresos"] = $egresos;
			$resultado["dias"] = $dias;
			break;

			/* --------------------- Reporte - Ventas Generales ---------------------------- */

		case 'reporteVentas':
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c01 = "SELECT v.FECHA_REGISTRO, v.BOLETA, v.ID_VENTA, v.CONCEPTO, CONCAT(u.nombres, ' ', u.apellidos) AS VENDEDOR, p.NOMBRE AS PRODUCTO, SUM(vd.CANTIDAD) AS CANTIDAD, vd.PRECIO_VENTA AS PRECIO_UNITARIO, SUM(vd.CANTIDAD * vd.PRECIO_VENTA) AS TOTAL FROM ventas v JOIN venta_detalle vd ON v.id_venta = vd.id_venta JOIN producto p ON vd.id_producto = p.id_producto JOIN user u ON u.id_user = v.id_user WHERE DATE(v.fecha_registro) >= '".$fini."' AND DATE(v.fecha_registro) <= '".$ffin."' AND v.id_sucursal = '".$sucursal."' GROUP BY vd.id_producto, vd.id_venta ORDER BY vd.id_venta DESC;";
			$ventas = $DB->consultaAll($c01);

			$resultado = array();
			$resultado["ventas"] = $ventas;
			break;

			/* --------------------- Reporte - Ventas/Vendedor ---------------------------- */

		case 'reporteVentasVendedor':
			$reportes = array();
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$c00 = "SELECT u.id_user, concat(u.nombres,' ',u.apellidos) as vendedor FROM ventas v, user u WHERE v.id_user = u.id_user and DATE(v.fecha_registro) >='" . $fini . "' AND DATE(v.fecha_registro) <= '" . $ffin . "' and v.id_sucursal = '" . $sucursal . "' GROUP BY u.id_user";
			$vend = $DB->consultaAll($c00);
			for ($i = 0; $i < $vend["size"]; $i++) {
				$c01 = "SELECT v.FECHA_REGISTRO, v.BOLETA, v.ID_VENTA, v.CONCEPTO, CONCAT(u.nombres, ' ', u.apellidos) AS VENDEDOR, p.NOMBRE, SUM(vd.CANTIDAD) AS CANTIDAD, SUM(vd.PRECIO_VENTA * vd.CANTIDAD) AS TOTAL, vd.PRECIO_VENTA AS PRECIO_UNITARIO FROM ventas v INNER JOIN user u ON u.id_user = v.id_user INNER JOIN venta_detalle vd ON v.id_venta = vd.id_venta INNER JOIN producto p ON vd.id_producto = p.id_producto WHERE DATE(v.fecha_registro) >= '" . $fini . "' AND DATE(v.fecha_registro) <= '" . $ffin . "' AND v.id_sucursal = '" . $sucursal . "' AND v.id_user = '" . $vend["data"][$i]->id_user . "' GROUP BY vd.id_producto, vd.id_venta ORDER BY vd.id_venta DESC;";
				$ventas = $DB->consultaAll($c01);
				$detItems = new stdClass();
				$detItems->id_user = $vend["data"][$i]->id_user;
				$detItems->vendedor = $vend["data"][$i]->vendedor;
				$detItems->ventas = $ventas;
				array_push($reportes, $detItems);
			}

			$resultado = array();
			$resultado["reportes"] = $reportes;
			break;

			/* --------------------- Reporte - Perdidas Ganancias  ---------------------------- */

		case 'reportePerdidasGanancias':
			$reportes = array();
			$idsuc = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c00 = "SELECT DATE(fecha_registro) AS fecha FROM ventas WHERE id_sucursal = ? AND DATE(fecha_registro) >= ? AND DATE(fecha_registro) <= ? GROUP BY DATE(fecha_registro)";
			$nventa = $DB->consultaPreparadaAll($c00, "iss", [$idsuc, $fini, $ffin]);

			if ($nventa["size"] > 0) {
				for ($j = 0; $j < $nventa["size"]; $j++) {
					$c01 = "SELECT DATE(v.FECHA_REGISTRO) AS fecha, p.CODIGO, p.NOMBRE, SUM(vd.CANTIDAD * vd.PRECIO_VENTA) AS ventas, SUM(p.PRECIO_COMPRA * vd.CANTIDAD) AS compras, (SUM(vd.CANTIDAD * vd.PRECIO_VENTA) - SUM(p.PRECIO_COMPRA * vd.CANTIDAD)) AS ganancias FROM ventas v JOIN venta_detalle vd ON v.ID_VENTA = vd.ID_VENTA JOIN producto p ON vd.ID_PRODUCTO = p.ID_PRODUCTO WHERE DATE(v.FECHA_REGISTRO) = ? GROUP BY DATE(v.FECHA_REGISTRO), p.CODIGO, p.NOMBRE;";
					$ventas = $DB->consultaPreparadaAll($c01, "s", [$nventa["data"][$j]->fecha]);

					$detVenta = new stdClass();
					$detVenta->fecha = $nventa["data"][$j]->fecha;
					$detVenta->ventas = $ventas;
					array_push($reportes, $detVenta);
				}
			} else {
				$reportes = [];
			}

			$resultado = array();
			$resultado["reportes"] = $reportes;
			break;

			/* --------------------- Reporte - Compras  ---------------------------- */
		case 'reporteCompras':
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c01 = "SELECT c.FECHA_REGISTRO, c.BOLETA, c.ID_COMPRA, c.CONCEPTO, pr.RAZON_SOCIAL as PROVEEDOR, p.NOMBRE, SUM(cd.CANTIDAD) as CANTIDAD, SUM(cd.PRECIO_COMPRA)as TOTAL , cd.PRECIO_COMPRA AS PRECIO_UNITARIO FROM compras c , proveedor pr, compra_detalle cd, producto p where c.id_compra = cd.id_compra and cd.id_producto = p.id_producto and pr.id_proveedor = c.id_proveedor and DATE(c.fecha_registro) >='" . $fini . "' AND DATE(c.fecha_registro) <= '" . $ffin . "' and c.id_sucursal = '" . $sucursal . "' GROUP BY cd.id_producto, cd.id_compra order by cd.id_compra desc";
			$compras = $DB->consultaAll($c01);

			$resultado = array();
			$resultado["compras"] = $compras;
			break;

			/* --------------------- Reporte - Compras/Proveedor  ---------------------------- */

		case 'reporteComprasProveedor':
			$reportes = array();
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$c00 = "SELECT p.id_proveedor, p.razon_social as proveedor  FROM compras c, proveedor p WHERE p.id_proveedor = c.id_proveedor and DATE(c.fecha_registro) >='" . $fini . "' AND DATE(c.fecha_registro) <= '" . $ffin . "' and c.id_sucursal = '" . $sucursal . "' GROUP BY c.id_proveedor";
			$comp = $DB->consultaAll($c00);
			for ($i = 0; $i < $comp["size"]; $i++) {

				$c01 = "SELECT c.FECHA_REGISTRO, c.BOLETA, c.ID_COMPRA, c.CONCEPTO, pr.RAZON_SOCIAL as PROVEEDOR, p.NOMBRE, SUM(cd.CANTIDAD) as CANTIDAD, SUM(cd.PRECIO_COMPRA)as TOTAL , cd.PRECIO_COMPRA AS PRECIO_UNITARIO FROM compras c , proveedor pr, compra_detalle cd, producto p where c.id_compra = cd.id_compra and cd.id_producto = p.id_producto and pr.id_proveedor = c.id_proveedor and DATE(c.fecha_registro) >='" . $fini . "' AND DATE(c.fecha_registro) <= '" . $ffin . "' and c.id_sucursal = '" . $sucursal . "' and c.id_proveedor = '" . $comp["data"][$i]->id_proveedor . "' GROUP BY cd.id_producto, cd.id_compra order by cd.id_compra desc";
				$compras = $DB->consultaAll($c01);
				$detItems = new stdClass();
				$detItems->id_proveedor = $comp["data"][$i]->id_proveedor;
				$detItems->proveedor = $comp["data"][$i]->proveedor;
				$detItems->compras = $compras;
				array_push($reportes, $detItems);
			}

			$resultado = array();
			$resultado["reportes"] = $reportes;
			$resultado["query"] = $c00;
			break;



			/* --------------------- Reporte - Traspasos  ---------------------------- */

		case 'reporteTraspasos':
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c00 = "SELECT so.SUCURSAL as ORIGEN, sd.SUCURSAL as DESTINO, t.FECHA_REGISTRO, t.BOLETA, t.ID_TRASPASO, t.CONCEPTO, p.NOMBRE,  SUM(td.CANTIDAD) as CANTIDAD, SUM(td.PRECIO)as TOTAL , td.PRECIO AS PRECIO_UNITARIO FROM traspasos t , sucursal so, sucursal sd, traspaso_detalle td, producto p  where t.id_traspaso = td.id_traspaso and td.id_producto = p.id_producto and so.id_sucursal = t.id_sucursal_origen and sd.id_sucursal = t.id_sucursal_destino and DATE(t.fecha_registro) >='" . $fini . "' AND DATE(t.fecha_registro) <= '" . $ffin . "' and t.id_sucursal_origen = '" . $sucursal . "' GROUP BY td.id_producto, td.id_traspaso order by td.id_traspaso desc";
			$enviados = $DB->consultaAll($c00);

			$c01 = "SELECT so.SUCURSAL as ORIGEN, sd.SUCURSAL as DESTINO, t.FECHA_REGISTRO, t.BOLETA, t.ID_TRASPASO, t.CONCEPTO, p.NOMBRE, SUM(td.CANTIDAD) as CANTIDAD, SUM(td.PRECIO)as TOTAL , td.PRECIO AS PRECIO_UNITARIO FROM traspasos t , sucursal so, sucursal sd, traspaso_detalle td, producto p  where t.id_traspaso = td.id_traspaso and td.id_producto = p.id_producto and so.id_sucursal = t.id_sucursal_origen and sd.id_sucursal = t.id_sucursal_destino and DATE(t.fecha_registro) >='" . $fini . "' AND DATE(t.fecha_registro) <= '" . $ffin . "' and t.id_sucursal_destino = '" . $sucursal . "' GROUP BY td.id_producto, td.id_traspaso order by td.id_traspaso desc";
			$recibidos = $DB->consultaAll($c01);

			$resultado = array();
			$resultado["enviados"] = $enviados;
			$resultado["recibidos"] = $recibidos;
			break;

			/* --------------------- Reporte - Bajas  ---------------------------- */

		case 'reporteBajas':
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c01 = "SELECT b.FECHA_REGISTRO, b.BOLETA, b.ID_BAJA, b.CONCEPTO, v.VENDEDOR , p.ID_PRODUCTO, p.NOMBRE,  SUM(bd.CANTIDAD) as CANTIDAD, SUM(bd.PRECIO_BAJA)as TOTAL , bd.PRECIO_BAJA AS PRECIO_UNITARIO FROM bajas b , vendedor v, baja_detalle bd, producto p where b.id_baja = bd.id_baja and bd.id_producto = p.id_producto and v.id_vendedor = b.id_vendedor and DATE(b.fecha_registro) >='" . $fini . "' AND DATE(b.fecha_registro) <= '" . $ffin . "' and b.id_sucursal = '" . $sucursal . "' GROUP BY bd.id_producto, bd.id_baja order by bd.id_baja desc";
			$bajas = $DB->consultaAll($c01);

			$resultado = array();
			$resultado["bajas"] = $bajas;
			break;

			/* --------------------- Reporte - Ajustes ---------------------------- */

		case 'reporteAjustes':
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c01 = "SELECT a.FECHA_REGISTRO, a.BOLETA, a.ID_AJUSTE, a.CONCEPTO, p.ID_PRODUCTO, p.NOMBRE, SUM(ad.CANTIDAD) AS CANTIDAD, SUM(ad.PRECIO_AJUSTE) AS TOTAL, ad.PRECIO_AJUSTE AS PRECIO_UNITARIO FROM ajustes a JOIN ajuste_detalle ad ON a.id_ajuste = ad.id_ajuste JOIN producto p ON ad.id_producto = p.id_producto WHERE DATE(a.fecha_registro) >= '" . $fini . "' AND DATE(a.fecha_registro) <= '" . $ffin . "' AND a.id_sucursal = '" . $sucursal . "' GROUP BY ad.id_producto, ad.id_ajuste ORDER BY ad.id_ajuste DESC";

			$ajustes = $DB->consultaAll($c01);

			$resultado = array();
			$resultado["ajustes"] = $ajustes;
			break;


			/* --------------------- Reporte - Arqueo  ---------------------------- */

		case 'reporteArqueo':
			$idsuc = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$reportes = array();
			$c00 = "SELECT date(fecha_registro) as fecha from arqueo where id_sucursal='" . $idsuc . "' and date(fecha_registro) >='" . $fini . "' and  date(fecha_registro) <='" . $ffin . "' and estado = 'TERMINADO' group by date(fecha_registro) ";
			$narq = $DB->consultaAll($c00);
			for ($j = 0; $j < $narq["size"]; $j++) {
				$arqueos = array();
				$c01 = "SELECT * FROM arqueo WHERE id_sucursal='" . $idsuc . "' and date(fecha_registro) ='" . $narq["data"][$j]->fecha . "' ";
				$arq = $DB->consultaAll($c01);
				for ($i = 0; $i < $arq["size"]; $i++) {
					$c01 = "select nombres, apellidos, usuario from user where id_user='" . $arq["data"][$i]->ID_USER . "'";
					$cajero = $DB->consultaOne($c01);
					$c02 = "select sucursal from sucursal where id_sucursal='" . $arq["data"][$i]->ID_SUCURSAL . "'";
					$sucursal = $DB->consultaOne($c02);

					$detitem = new stdClass();
					$detitem->fecha_registro		= $arq["data"][$i]->FECHA_REGISTRO;
					$detitem->sucursal				= $sucursal->sucursal;
					$detitem->cajero				= $cajero->nombres . " " . $cajero->apellidos;
					$detitem->turno			    	= $arq["data"][$i]->TURNO;
					$detitem->id_arqueo				= $arq["data"][$i]->ID_ARQUEO;
					$detitem->saldo_anterior		= $arq["data"][$i]->SALDO_ANTERIOR;
					$detitem->vefe					= $arq["data"][$i]->VENTA_EF;
					$detitem->vqr					= $arq["data"][$i]->VENTA_QR;
					$detitem->vtj					= $arq["data"][$i]->VENTA_TJ;
					$detitem->ingresos				= $arq["data"][$i]->OTROS_INGRESOS;
					$detitem->egresos				= $arq["data"][$i]->EGRESOS;
					$detitem->total_general			= $arq["data"][$i]->TOTAL_GENERAL;
					$detitem->estado				= $arq["data"][$i]->ESTADO;
					array_push($arqueos, $detitem);
				}
				$detSus = new stdClass();
				$detSus->fecha = $narq["data"][$j]->fecha;
				$detSus->arqueos = $arqueos;
				array_push($reportes, $detSus);
			}
			$resultado = array();
			$resultado["reportes"] = $reportes;
			break;

			/* --------------------- Reporte - Facturas ---------------------------- */

		case 'reporteFacturas':
			$facturas = array();
			$idsuc = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];

			$c00 = "SELECT * FROM siat_factura  WHERE idPuntoVenta = '" . $idsuc . "' AND fecha >= '" . $fini . "' AND fecha <= '" . $ffin . "' GROUP BY id ORDER BY id DESC; ";
			$fact = $DB->consultaAll($c00);
			for ($i = 0; $i < $fact["size"]; $i++) {

				$c01 = "SELECT * from cliente where nitCi = '" . $fact["data"][$i]->numeroDocumento . "'";
				$cliente = $DB->consultaOne($c01);

				$detItems = new stdClass();
				$detItems->id = $fact["data"][$i]->id;
				$detItems->tipoEmision = $fact["data"][$i]->tipoEmision;
				$detItems->nitEmisor = $fact["data"][$i]->nitEmisor;
				$detItems->fecha = $fact["data"][$i]->fecha;
				$detItems->hora = $fact["data"][$i]->hora;
				$detItems->numeroFactura = $fact["data"][$i]->numeroFactura;
				$detItems->numeroDocumento = $fact["data"][$i]->numeroDocumento;
				$detItems->nombreRazonSocial = $fact["data"][$i]->nombreRazonSocial;
				$detItems->montoTotalSujetoIva = $fact["data"][$i]->montoTotalSujetoIva;
				$detItems->descuentoAdicional = $fact["data"][$i]->descuentoAdicional;
				$detItems->montoGiftCard = 0;
				$detItems->estado = $fact["data"][$i]->estado;
				$detItems->cuf = $fact["data"][$i]->cuf;
				$detItems->email = $cliente->email;

				array_push($facturas, $detItems);
			}

			$resultado = array();
			$resultado["reportes"] = $facturas;
			break;

			/* --------------------- Reporte - Kardex - Producto  ---------------------------- */

		case 'reporteKardexProducto':
			$reportes = array();
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$idProducto = $body["idProducto"];

			$c00 = "SELECT * FROM (
				(SELECT 'VENTA' AS TRANSACCION, v.BOLETA AS BOLETA, SUM(vd.CANTIDAD) AS SALIDA, 0 AS ENTRADA, SUM(vd.CANTIDAD * vd.PRECIO_VENTA) AS PRECIO, v.FECHA_REGISTRO, vd.PRECIO_VENTA AS PRECIO_UNITARIO FROM venta_detalle vd JOIN ventas v ON vd.ID_VENTA = v.ID_VENTA WHERE v.FECHA_REGISTRO >= '" . $fini . "' AND v.FECHA_REGISTRO <= '" . $ffin . "' AND v.ID_SUCURSAL = '" . $sucursal . "' AND vd.ID_PRODUCTO = '" . $idProducto . "' AND v.ESTADO='CONFIRMADO')
				UNION ALL
				(SELECT 'COMPRA' AS TRANSACCION, c.BOLETA AS BOLETA, 0 AS SALIDA, SUM(cd.CANTIDAD) AS ENTRADA, SUM(cd.CANTIDAD * cd.PRECIO_COMPRA) AS PRECIO, c.FECHA_REGISTRO, cd.PRECIO_COMPRA AS PRECIO_UNITARIO FROM compra_detalle cd JOIN compras c ON cd.ID_COMPRA = c.ID_COMPRA WHERE c.FECHA_REGISTRO >= '" . $fini . "' AND c.FECHA_REGISTRO <= '" . $ffin . "' AND c.ID_SUCURSAL = '" . $sucursal . "' AND cd.ID_PRODUCTO = '" . $idProducto . "' AND c.ESTADO='VERIFICADO')
				UNION ALL
				(SELECT 'BAJA' AS TRANSACCION, b.BOLETA AS BOLETA, SUM(bd.CANTIDAD) AS SALIDA, 0 AS ENTRADA, SUM(bd.PRECIO_BAJA) AS PRECIO, b.FECHA_REGISTRO,bd.PRECIO_BAJA AS PRECIO_UNITARIO FROM bajas b JOIN baja_detalle bd ON b.id_baja = bd.id_baja WHERE DATE(b.fecha_registro) >= '" . $fini . "' AND DATE(b.fecha_registro) <= '" . $ffin . "' AND b.id_sucursal = '" . $sucursal . "' AND bd.id_producto = '" . $idProducto . "')
				UNION ALL
				(SELECT 'TRASPASO ENVIADO' AS TRANSACCION, t.BOLETA AS BOLETA, SUM(td.CANTIDAD) AS SALIDA, 0 AS ENTRADA, SUM(td.PRECIO) AS PRECIO, t.FECHA_REGISTRO, td.PRECIO AS PRECIO_UNITARIO FROM traspasos t JOIN sucursal so ON so.id_sucursal = t.id_sucursal_origen JOIN sucursal sd ON sd.id_sucursal = t.id_sucursal_destino JOIN traspaso_detalle td ON t.id_traspaso = td.id_traspaso WHERE DATE(t.fecha_registro) >= '" . $fini . "' AND DATE(t.fecha_registro) <= '" . $ffin . "' AND t.id_sucursal_origen = '" . $sucursal . "' AND td.id_producto = '" . $idProducto . "' AND t.ESTADO='CONFIRMADO')
				UNION ALL
				(SELECT 'TRASPASO RECIBIDO' AS TRANSACCION, t.BOLETA AS BOLETA, 0 AS SALIDA, SUM(td.CANTIDAD) AS ENTRADA, SUM(td.PRECIO) AS PRECIO, t.FECHA_REGISTRO, td.PRECIO AS PRECIO_UNITARIO FROM traspasos t JOIN sucursal so ON so.id_sucursal = t.id_sucursal_origen JOIN sucursal sd ON sd.id_sucursal = t.id_sucursal_destino JOIN traspaso_detalle td ON t.id_traspaso = td.id_traspaso WHERE DATE(t.fecha_registro) >= '" . $fini . "' AND DATE(t.fecha_registro) <= '" . $ffin . "' AND t.id_sucursal_destino = '" . $sucursal . "' AND td.id_producto = '" . $idProducto . "' AND t.ESTADO='CONFIRMADO')
				UNION ALL
				(SELECT 'AJUSTE' AS TRANSACCION, a.BOLETA AS BOLETA, 0 AS SALIDA, SUM(ad.CANTIDAD) AS ENTRADA, SUM(ad.CANTIDAD * ad.PRECIO_AJUSTE) AS PRECIO, a.FECHA_REGISTRO, ad.PRECIO_AJUSTE AS PRECIO_UNITARIO  FROM ajustes a JOIN ajuste_detalle ad ON a.ID_AJUSTE = ad.ID_AJUSTE WHERE DATE(a.FECHA_REGISTRO) >= '" . $fini . "' AND DATE(a.FECHA_REGISTRO) <= '" . $ffin . "' AND a.ID_SUCURSAL = '" . $sucursal . "' AND ad.ID_PRODUCTO = '" . $idProducto . "')
			) AS resultados WHERE SALIDA <> 0 OR ENTRADA <> 0 ORDER BY FECHA_REGISTRO;";
			$reporte = $DB->consultaAll($c00);

			$saldo = 0;

			for ($i = 0; $i < $reporte["size"]; $i++) {
				$entrada = (float) $reporte["data"][$i]->ENTRADA;
				$salida = (float) $reporte["data"][$i]->SALIDA;
				$saldo += $entrada;
				$saldo -= $salida;

				$detitem = new stdClass();
				$detitem->fecha_registro    = $reporte["data"][$i]->FECHA_REGISTRO;
				$detitem->boleta            = $reporte["data"][$i]->BOLETA;
				$detitem->transaccion       = $reporte["data"][$i]->TRANSACCION;
				$detitem->entrada 			= number_format($entrada, 2, '.', '');
				$detitem->salida 			= number_format($salida, 2, '.', '');
				$detitem->precio_unitario   = number_format((float)$reporte["data"][$i]->PRECIO_UNITARIO, 2, '.', '');
				$detitem->precio_total      = number_format((float)$reporte["data"][$i]->PRECIO, 2, '.', '');
				$detitem->saldo 			= number_format($saldo, 2, '.', '');

				array_push($reportes, $detitem);
			}

			$resultado = array();
			$resultado["reportes"] = $reportes;

			break;


			/* --------------------- Reporte - Productos - Mas Vendidos  ---------------------------- */

		case 'reporteProductosMasVendidos':
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$idProducto = $body["idProducto"];

			$c00 = "SELECT p.NOMBRE AS PRODUCTO, SUM(vd.CANTIDAD) AS CANTIDAD, SUM(vd.CANTIDAD * vd.PRECIO_VENTA) AS PRECIO FROM venta_detalle vd JOIN ventas v ON vd.ID_VENTA = v.ID_VENTA JOIN producto p ON vd.ID_PRODUCTO = p.ID_PRODUCTO WHERE v.FECHA_REGISTRO >= '" . $fini . "' AND v.FECHA_REGISTRO <= '" . $ffin . "' AND v.ID_SUCURSAL = '" . $sucursal . "' GROUP BY p.NOMBRE ORDER BY CANTIDAD DESC LIMIT 25";
			$reporte = $DB->consultaAll($c00);

			$resultado = array();
			$resultado["reportes"] = $reporte;
			break;

			/* --------------------- Reporte - Kardex Ventas/Producto  ---------------------------- */

		case 'reporteVentasProductos':
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$idProducto = $body["idProducto"];

			$c00 = "SELECT 	v.BOLETA AS Boleta, p.NOMBRE AS Producto, SUM(vd.CANTIDAD) AS Cantidad, SUM(vd.CANTIDAD * vd.PRECIO_VENTA) AS Total_Precio_Venta, vd.PRECIO_VENTA AS Precio_Unitario, v.FECHA_REGISTRO AS Fecha_Venta FROM venta_detalle vd JOIN ventas v ON vd.ID_VENTA = v.ID_VENTA JOIN producto p ON vd.ID_PRODUCTO = p.ID_PRODUCTO WHERE v.FECHA_REGISTRO >= '" . $fini . "' AND v.FECHA_REGISTRO <= '" . $ffin . "' AND v.ID_SUCURSAL = '" . $sucursal . "' AND vd.ID_PRODUCTO = '" . $idProducto . "' GROUP BY v.BOLETA, p.NOMBRE, v.FECHA_REGISTRO ORDER BY v.FECHA_REGISTRO;";
			$producto = $DB->consultaAll($c00);

			$resultado = array();
			$resultado["producto"] = $producto;
			break;



			/* --------------------- Reporte - Kardex Compras/Producto  ---------------------------- */

		case 'reporteComprasProductos':
			$sucursal = $body["idsucursal"];
			$fini = $body["fecini"];
			$ffin = $body["fecfin"];
			$idProducto = $body["idProducto"];

			$c01 = "SELECT c.BOLETA AS Boleta, p.NOMBRE AS Producto, SUM(cd.CANTIDAD) AS Cantidad, SUM(cd.CANTIDAD * cd.PRECIO_COMPRA) AS Total_Precio_Compra, cd.PRECIO_COMPRA AS Precio_Unitario,  c.FECHA_REGISTRO AS Fecha_Compra FROM compra_detalle cd JOIN compras c ON cd.ID_COMPRA = c.ID_COMPRA JOIN producto p ON cd.ID_PRODUCTO = p.ID_PRODUCTO WHERE c.FECHA_REGISTRO >= '$fini' AND c.FECHA_REGISTRO <= '$ffin' AND c.ID_SUCURSAL = '$sucursal' AND cd.ID_PRODUCTO = '$idProducto' GROUP BY c.BOLETA, p.NOMBRE, c.FECHA_REGISTRO ORDER BY c.FECHA_REGISTRO;";
			$producto = $DB->consultaAll($c01);

			$resultado = array();
			$resultado["producto"] = $producto;
			break;

			/* --------------------- Reporte - Kardex Stock/Minimo  ---------------------------- */

		case 'reporteStockMinimo':
			$sucursal = $body["idsucursal"];

			$c00 = "SELECT p.id_producto, p.codigo, p.imagen, p.codigo_barras, p.precio_tope, p.nombre, p.marca, p.unidad, p.precio_compra, p.precio_venta, p.precio_especial, p.precio_mayor, p.stock_minimo, SUM(i.cantidad) AS stock, i.precio_compra, i.precio_venta FROM inventario AS i JOIN producto AS p ON i.id_producto = p.id_producto WHERE i.id_sucursal = '" . $sucursal . "' AND i.cantidad > 0 AND i.estado = 'VERIFICADO' AND p.stock_minimo > 0 GROUP BY i.id_producto HAVING SUM(i.cantidad) <= p.stock_minimo;";
			$reportes = $DB->consultaAll($c00);

			$resultado = array();
			$resultado["reportes"] = $reportes;
			break;
	}

	/* ---------------------------------------------------- */
	$DB->commit();
	$DB->close();

	Response::sendOne($resultado);
} catch (Exception $e) {
	$DB->rollback();
	$DB->close();
	Response::sendError($e);
}
