<?php
session_start();
date_default_timezone_set("America/La_Paz");
header('Content-Type: text/html; charset=UTF-8');
require '../librerias/phpMailer/PHPMailer.php';
require '../librerias/phpMailer/SMTP.php';
require '../librerias/phpMailer/Exception.php';
require '../librerias/phpqrcode/qrlib.php';
include "../api.php";

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

try {

	$body = Response::getBody();
	/* ---------------------------------------------------- */
	$DB = new DB();
	$DB->conectar();
	$DB->begin();
	/* ---------------------------------------------------- */
	$fechareg = date("Y-m-d H:i:s");
	$newfecha = date("Y-m-d");
	$newhora = date("G:i:s");
	$funcion = $body["funcion"];

	switch ($funcion) {
			/* ---------------------login - logout---------------------------- */
		case 'login':
			$user = $body["usuario"];
			$pwd = md5($body["contrasena"]);

			$c00 = "SELECT u.usuario, u.nombres AS nomuser, u.apellidos, u.id_user, u.foto, u.estado, u.email,
						   s.id_sucursal, s.sucursal, s.direccion, s.telefono, s.celular, s.ciudad, s.localidad 
					FROM user AS u 
					INNER JOIN user_sucursal AS us ON u.id_user = us.id_user 
					INNER JOIN sucursal AS s ON us.id_sucursal = s.id_sucursal 
					WHERE u.usuario = ? AND u.password = ?";
			$autentificacion = $DB->consultaPreparadaAll($c00, "ss", [$user, $pwd]);

			if ($autentificacion["size"] > 0) {
				foreach ($autentificacion["data"] as $userData) {
					$c01 = "SELECT r.id_rol, r.rol 
							FROM user AS u 
							INNER JOIN user_rol AS ur ON u.id_user = ur.id_user 
							INNER JOIN rol AS r ON ur.id_rol = r.id_rol 
							WHERE u.id_user = ?";
					$selectResRol = $DB->consultaPreparadaOne($c01, "i", [$userData->id_user]);

					$c02 = "SELECT empresa, id_empresa, sigla, icono, logo_cuadrado, tipo_cambio FROM empresa WHERE id_empresa = ?";
					$empresa = $DB->consultaPreparadaOne($c02, "i", [1]);

					$_SESSION = [
						'log' => true,
						'usr' => $userData->usuario,
						'idu' => $userData->id_user,
						'est' => $userData->estado,
						'mail' => $userData->email,
						'suc' => $userData->sucursal,
						'ids' => $userData->id_sucursal,
						'nom' => $userData->nomuser,
						'aps' => $userData->apellidos,
						'foto' => $userData->foto,
						'dir' => $userData->direccion,
						'telf' => $userData->telefono,
						'ciu' => $userData->ciudad,
						'loc' => $userData->localidad,
						'cel' => $userData->celular,
						'rol' => $selectResRol->rol,
						'idr' => $selectResRol->id_rol,
						'emp' => $empresa->empresa,
						'tc' => $empresa->tipo_cambio,
						'ide' => $empresa->id_empresa,
						'sig' => $empresa->sigla,
						'ico' => $empresa->icono,
						'logo' => $empresa->logo_cuadrado
					];
					$sesion = '1';
				}
			} else {
				$sesion = '0';
			}
			$resultado = array();
			$resultado["sesion"] = $sesion;
			$resultado["datos"] = $_SESSION;
			break;

		case 'logout':
			session_destroy();
			$sesion = '0';
			$resultado = array();
			$resultado["sesion"] = $sesion;
			break;
			/* --------------------- Usuarios ---------------------------- */

		case 'listarUsuarios':
			$usuarios = array();
			$c00 = "SELECT * FROM user u JOIN user_rol ur ON u.id_user = ur.id_user GROUP BY u.id_user";
			$users = $DB->consultaAll($c00);

			for ($i = 0; $i < $users["size"]; $i++) {
				$user = $users["data"][$i];
				$id = $user->ID_USER;

				$c01 = "SELECT ur.id_user_rol AS id, r.rol AS item FROM rol r JOIN user_rol ur ON ur.id_rol = r.id_rol WHERE ur.id_user = ?";
				$roles = $DB->consultaPreparadaAll($c01, "i", [$id]);

				$c02 = "SELECT us.id_user_suc AS id, s.sucursal AS item FROM sucursal s JOIN user_sucursal us ON us.id_sucursal = s.id_sucursal WHERE us.id_user = ?";
				$sucursales = $DB->consultaPreparadaAll($c02, "i", [$id]);

				$c03 = "SELECT id_direccion AS id, etiqueta AS item FROM direccion WHERE id_user = ? AND estado <> 'ELIMINADO'";
				$direcciones = $DB->consultaPreparadaAll($c03, "i", [$id]);

				$detItems = new stdClass();
				$detItems->id_user = $user->ID_USER;
				$detItems->id_rol = $user->ID_ROL;
				$detItems->user = $user->USUARIO;
				$detItems->ci = $user->CI;
				$detItems->noms = $user->NOMBRES;
				$detItems->aps = $user->APELLIDOS;
				$detItems->email = $user->EMAIL;
				$detItems->telf = $user->TELEFONO;
				$detItems->foto = $user->FOTO;
				$detItems->estado = $user->ESTADO;
				$detItems->roles = $roles;
				$detItems->sucursales = $sucursales;
				$detItems->direcciones = $direcciones;

				array_push($usuarios, $detItems);
			}

			$resultado = array();
			$resultado["users"] = $usuarios;
			break;


		case 'newUser':
			$rol = $body["rol"];
			$sucursal = $body["sucursal"];
			$user = $body["user"];
			$ci = $body["ci"];
			$noms = $body["noms"];
			$aps = $body["aps"];
			$email = $body["email"];
			$telf = $body["telf"];
			$cel = $body["cel"];
			$fecnac = isset($body["fecnac"]) && $body["fecnac"] != '' ? $body["fecnac"] : '0000-00-00';
			$genero = isset($body["genero"]) ? $body["genero"] : "MASCULINO";
			$pwd = md5($body["ci"]);
			$qrcode = md5($body["user"]);
		
			$codigover = rand(100000, 999999);
		
			$c00 = "SELECT email, ci, id_user FROM user WHERE email = ? OR ci = ?";
			$usersis = $DB->consultaPreparadaOne($c00, "ss", [$email, $ci]);
		
			$existeEmail = isset($usersis->email) ? $usersis->email : "";
			$existeCI = isset($usersis->ci) ? $usersis->ci : "";
		
			$c01 = "SELECT * FROM empresa WHERE id_empresa = '1'";
			$empresa = $DB->consultaOne($c01);
			$nomempresa = $empresa->EMPRESA;
		
			if ($existeEmail != "" && $existeCI != "") {
				$nmsj = "Usuario ya registrado con este email y CI.";
				throw new Exception($nmsj);
			} elseif ($existeEmail != "") {
				$nmsj = "Usuario con este email ya registrado.";
				throw new Exception($nmsj);
			} elseif ($existeCI != "") {
				$c05 = "UPDATE user SET email = ? WHERE ci = ?";
				$DB->updatePreparado($c05, "ss", [$email, $ci]);
		
			} else {
				$c01 = "SELECT COALESCE(MAX(id_user), 0) + 1 AS maxuser FROM user";
				$maxUser = $DB->consultaOne($c01);
				$idus = $maxUser->maxuser;
		
				$c02 = "INSERT INTO user (USUARIO, PASSWORD, CI, NOMBRES, APELLIDOS, GENERO, FECHA_NAC, EMAIL, TELEFONO, CELULAR, CODIGO_QR, FOTO, ESTADO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,'usr.png', 'INACTIVO')";
				$DB->insertPreparado($c02, "sssssssssss", [$user, $pwd, $ci, $noms, $aps, $genero, $fecnac, $email, $telf, $cel, $qrcode]);		
		
				$c03 = "INSERT INTO user_rol VALUES (DEFAULT, ?, ?)";
				$DB->insertPreparado($c03, "ii", [$idus, $rol]);
		
				$c04 = "INSERT INTO user_sucursal VALUES (DEFAULT, ?, ?)";
				$DB->insertPreparado($c04, "ii", [$idus, $sucursal]);
		        
				// ------------------- Generamos imagen Qr ---------------------
				$dir = '../../img/qr/';
				if (!file_exists($dir)) mkdir($dir);
		
				$filename = $dir . 'cod-' . $qrcode . '.png';
				$tamaño = 10; //Tamaño de Pixel
				$level = 'L'; //Precisión Baja
				$framSize = 3; //Tamaño en blanco
				$contenido = $qrcode; //Texto
		
				// Generar código QR 
				QRcode::png($contenido, $filename, $level, $tamaño, $framSize);
			}
		
			$resultado = array();
			$resultado["valor"] = 0;
			break;
			
		case 'newCliente':
			$rol = $body["rol"];
			$sucursal = $body["sucursal"];
			$user = $body["user"];
			$ci = $body["ci"];
			$noms = $body["noms"];
			$aps = $body["aps"];
			$email = isset($body["email"]) ? $body["email"] : "";
			$telf = $body["telf"];
			$cel = $body["cel"];
			$fecnac = isset($body["fecnac"]) && $body["fecnac"] != '' ? $body["fecnac"] : '0000-00-00';
			$genero = isset($body["genero"]) ? $body["genero"] : "MASCULINO";
			$pwd = md5($body["ci"]);
			$qrcode = md5($body["user"]);
		
			$codigover = rand(100000, 999999);
		
			// Verificar si el usuario ya existe por CI
			$c00 = "SELECT ci FROM user WHERE ci = ?";
			$usersis = $DB->consultaPreparadaOne($c00, "s", [$ci]);
			$existe = isset($usersis->ci) ? $usersis->ci : "";
		
			$c01 = "SELECT * FROM empresa WHERE id_empresa = '1'";
			$empresa = $DB->consultaOne($c01);
			$nomempresa = $empresa->EMPRESA;
		
			if ($existe == "") {
				// Obtener el siguiente ID de usuario
				$c01 = "SELECT COALESCE(MAX(id_user), 0) + 1 AS maxuser FROM user";
				$maxUser = $DB->consultaOne($c01);
				$idus = $maxUser->maxuser;
		
				// Insertar nuevo cliente
				$c02 = "INSERT INTO user VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'usr.png', 'INACTIVO')";
				$DB->insertPreparado($c02, "issssssssssss", [$idus, $user, $pwd, $ci, $noms, $aps, $genero, $fecnac, $email, $telf, $cel, $qrcode, $codigover]);
		
				// Insertar rol del cliente
				$c03 = "INSERT INTO user_rol VALUES (DEFAULT, ?, ?)";
				$DB->insertPreparado($c03, "ii", [$idus, $rol]);
		
				// Insertar sucursal del cliente
				$c04 = "INSERT INTO user_sucursal VALUES (DEFAULT, ?, ?)";
				$DB->insertPreparado($c04, "ii", [$idus, $sucursal]);
		
				// Si se proporciona un email, se manda el correo de bienvenida
				if ($email != "") {
					// ----------------------------- Enviar Email ------------------------------
					$mail = new PHPMailer(true);
					try {
						//Server settings
						$mail->SMTPDebug = 0;
						$mail->isSMTP();
						$mail->Host       = 'mail.metasoft-bo.com';
						$mail->SMTPAuth   = true;
						$mail->Username   = 'juntos@metasoft-bo.com';
						$mail->Password   = 'Metasoft.2024';
						$mail->SMTPSecure = 'ssl';
						$mail->Port       = 465;
		
						//Recipients
						$mail->setFrom('juntos@metasoft-bo.com', $nomempresa);
						$mail->addAddress($email);
		
						//Content
						$mail->isHTML(true);
						$mail->Subject = 'Bienvenido a METASOFT - Tu cuenta ha sido creada';
		
						$mail->Body = '<html>
											<head>
												<style>
													body {
														font-family: Arial, sans-serif;
														color: #333;
														line-height: 1.6;
													}
													.container {
														width: 100%;
														max-width: 600px;
														margin: 0 auto;
														padding: 20px;
														background-color: #f9f9f9;
														border: 1px solid #ddd;
														border-radius: 8px;
													}
													.header {
														text-align: center;
														padding: 10px 0;
													}
													.content {
														margin-top: 20px;
													}
													.content p {
														margin: 10px 0;
													}
													.footer {
														text-align: center;
														font-size: 0.9em;
														color: #777;
														margin-top: 30px;
													}
													.button {
														display: inline-block;
														background-color: #4CAF50;
														color: white;
														padding: 10px 20px;
														font-size: 16px;
														border-radius: 5px;
														text-decoration: none;
													}
													.button:hover {
														background-color: #45a049;
													}
												</style>
											</head>
											<body>
												<div class="container">
													<div class="header">
														<h1>Bienvenido a ' . $nomempresa . '</h1>
													</div>
													<div class="content">
														<p>Hola <b>' . $noms . ' ' . $aps . '</b>,</p>
														<p>Tu cuenta ha sido creada exitosamente en nuestro sistema. A continuación, te proporcionamos los datos de acceso:</p>
														<p><strong>Usuario:</strong> <b>' . $user . '</b></p>
														<p><strong>Contraseña:</strong> <b>' . $ci . '</b></p>
														<p>Recuerda que puedes cambiar tu contraseña una vez que inicies sesión.</p>
														<p>Para activar tu cuenta, por favor introduce el siguiente código de verificación después de iniciar sesión:</p>
														<p><strong>Código de verificación:</strong> <b>' . $codigover . '</b></p>
														<p>Si tienes alguna duda, no dudes en ponerte en contacto con nuestro soporte.</p>
														<p><a href="http://www.tusitio.com/login" class="button">Ir al inicio de sesión</a></p>
													</div>
													<div class="footer">
														<p>Gracias por formar parte de ' . $nomempresa . '</p>
														<p>Si no solicitaste esta cuenta, por favor, ignora este correo.</p>
													</div>
												</div>
											</body>
										</html>';
		
						$mail->send();
					} catch (Exception $e) {
						echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
					}
				}
		
				// ----------------------------- Generamos imagen Qr ------------------------------
				$dir = '../../img/qr/';
				if (!file_exists($dir)) mkdir($dir);
		
				$filename = $dir . 'cod-' . $qrcode . '.png';
				$tamaño = 10; //Tamaño de Pixel
				$level = 'L'; //Precisión Baja
				$framSize = 3; //Tamaño en blanco
				$contenido = $qrcode; //Texto
		
				// Generar código QR 
				QRcode::png($contenido, $filename, $level, $tamaño, $framSize);
			} else {
				$nmsj = "USUARIO EXISTENTE SE TIENE REGISTRADO ESTE CI";
				throw new Exception($nmsj);
			}
		
			$resultado = array();
			$resultado["valor"] = 0;
			break;
		case 'recuperarContrasena':
			$email = $body["email"];
		
			// Verificar si el correo electrónico existe en la base de datos
			$c00 = "SELECT id_user, email FROM user WHERE email = ?";
			$usersis = $DB->consultaPreparadaOne($c00, "s", [$email]);
			$existe = isset($usersis->email) ? $usersis->email : "";
		
			// Obtener el nombre de la empresa
			$c01 = "SELECT EMPRESA FROM empresa WHERE id_empresa = 1";
			$empresa = $DB->consultaOne($c01);
			$nomempresa = $empresa->EMPRESA;
		
			if ($existe != "") {
				// Usar el id_user como token
				$token = $usersis->id_user;
		
				// Generar un enlace de recuperación usando el token (id_user)
				$linkRecuperacion = "http://www.tusitio.com/recuperar-contrasena.php?token=" . $token;
		
				// Enviar el correo con el enlace de recuperación
				$mail = new PHPMailer(true);
				try {
					// Configurar el servidor de correo
					$mail->isSMTP();
					$mail->Host       = 'mail.metasoft-bo.com';
					$mail->SMTPAuth   = true;
					$mail->Username   = 'juntos@metasoft-bo.com';
					$mail->Password   = 'Metasoft.2024';
					$mail->SMTPSecure = 'ssl';
					$mail->Port       = 465;
		
					// Remitente y destinatario
					$mail->setFrom('juntos@metasoft-bo.com', $nomempresa);
					$mail->addAddress($email);
		
					// Contenido del correo
					$mail->isHTML(true);
					$mail->Subject = 'Recuperación de Contraseña - ' . $nomempresa;
					$mail->Body = '<html>
									<body>
										<p>Hola,</p>
										<p>Hemos recibido una solicitud para restablecer tu contraseña. Si no fuiste tú quien hizo la solicitud, por favor ignora este correo.</p>
										<p>Para restablecer tu contraseña, haz clic en el siguiente enlace:</p>
										<p><a href="' . $linkRecuperacion . '" target="_blank">Restablecer mi contraseña</a></p>
										<p>Este enlace expirará en 1 hora.</p>
										<p>Gracias por ser parte de ' . $nomempresa . '</p>
									</body>
									</html>';
		
					$mail->send();
		
				} catch (Exception $e) {
					$resultado = array();
					$resultado["valor"] = 1; // Error
					$resultado["mensaje"] = "Error al enviar el correo. " . $mail->ErrorInfo;
				}
			} else {
				$nmsj = "EL CORREO ELECTRONICO NO ESTA REGISTRADO";
				throw new Exception($nmsj);
				
			}
			$resultado = array();
			$resultado["valor"] = 0; 
			break;
		case 'reenviarCodigoVerificacion':
			$email = $body["email"];
			
			// Verificar si el correo electrónico existe en la base de datos
			$c00 = "SELECT id_user, email FROM user WHERE email = ?";
			$usersis = $DB->consultaPreparadaOne($c00, "s", [$email]);
			$existe = isset($usersis->email) ? $usersis->email : "";
		    
			if ($existe != "") {
				// Generar un nuevo código de verificación de 6 dígitos
				$nuevoCodigo = rand(100000, 999999);
		
				// Obtener el id_user para actualizar el código
				$idUser = $usersis->id_user;
		        
		        
				// Actualizar el código de verificación en la base de datos
				$c01 = "UPDATE user SET codigo_verificacion = ? WHERE id_user = ?";
				$DB->updatePreparado($c01, "si", [$nuevoCodigo, $idUser]);
		
				// Obtener el nombre de la empresa
				$c02 = "SELECT EMPRESA FROM empresa WHERE id_empresa = 1";
				$empresa = $DB->consultaOne($c02);
				$nomempresa = $empresa->EMPRESA;
		        
				// Enviar el correo con el nuevo código de verificación
				$mail = new PHPMailer(true);
				try {
					// Configurar el servidor de correo
					$mail->isSMTP();
					$mail->Host       = 'mail.metasoft-bo.com';
					$mail->SMTPAuth   = true;
					$mail->Username   = 'juntos@metasoft-bo.com';
					$mail->Password   = 'Metasoft.2024';
					$mail->SMTPSecure = 'ssl';
					$mail->Port       = 465;
		
					// Remitente y destinatario
					$mail->setFrom('juntos@metasoft-bo.com', $nomempresa);
					$mail->addAddress($email);
		
					// Contenido del correo
					$mail->isHTML(true);
					$mail->Subject = 'Nuevo Código de Verificación - ' . $nomempresa;
					$mail->Body = '<html>
									<body>
										<p>Hola,</p>
										<p>Hemos generado un nuevo código de verificación para tu cuenta. Si no fuiste tú quien hizo la solicitud, por favor ignora este correo.</p>
										<p>Tu nuevo código de verificación es: <b>' . $nuevoCodigo . '</b></p>
										<p>Este código será válido por 1 hora.</p>
										<p>Gracias por ser parte de ' . $nomempresa . '</p>
									</body>
									</html>';
		
					$mail->send();
					
				} catch (Exception $e) {
					throw new Exception("Error al enviar el correo. " . $mail->ErrorInfo);
				}
			} else {
				throw new Exception("El correo electrónico no está registrado");
			}
			
			$resultado = array();
			$resultado["valor"] = 0; 
			break;
			
		case 'validarCodigoVerificacion':
			$idUser = $body["iduser"]; // Recibir el id_user
			$codigoVerificacion = $body["codigoVerificacion"]; // Recibir el código de verificación
		
			// Verificar si el id_user existe y obtener el código de verificación
			$c00 = "SELECT id_user, codigo_verificacion, estado FROM user WHERE id_user = ?";
			$user = $DB->consultaPreparadaOne($c00, "i", [$idUser]);
		
			if (isset($user->id_user)) {
				// Si el usuario existe, validar el código de verificación
				if ($user->codigo_verificacion == $codigoVerificacion) {
					// Si el código es correcto, actualizar el estado a "ACTIVO"
					$c01 = "UPDATE user SET estado = 'ACTIVO' WHERE id_user = ?";
					$DB->updatePreparado($c01, "i", [$user->id_user]);
		
					// Responder que la validación fue exitosa
					$resultado = array();
					$resultado["valor"] = 0;
					$resultado["mensaje"] = "Código de verificación válido. Cuenta activada correctamente.";
				} else {
					// Si el código es incorrecto
					$nmsj = "El código de verificación es incorrecto.";
					throw new Exception($nmsj);
				}
			} else {
				// Si el id_user no existe
				$nmsj = "El usuario no existe.";
				throw new Exception($nmsj);
			}
			break;
			
				

		case 'validarUsuario':
			$user = $body["user"];

			$c00 = "SELECT usuario FROM user WHERE usuario = ?";
			$usersis = $DB->consultaPreparadaOne($c00, "s", [$user]);
			$existe = isset($usersis->usuario) ? $usersis->usuario : "";

			$valor = ($existe == "") ? 0 : 1;
			$resultado = array();
			$resultado["valor"] = $valor;
			break;

		case 'editUser':
			$idus = $body["iduser"];
			$c00 = "SELECT * FROM user WHERE id_user = ?";
			$user = $DB->consultaPreparadaOne($c00, "i", [$idus]);

			$resultado = array();
			$resultado["user"] = $user;
			break;

		case 'updUser':
			$iduser = $body["iduser"];
			$ci = $body["ci"];
			$noms = $body["noms"];
			$aps = $body["aps"];
			$email = $body["email"];
			$telf = $body["telf"];
			$cel = $body["cel"];
			$fecnac = $body["fecnac"];
			$genero = $body["genero"];

			$c00 = "UPDATE user SET ci = ?, nombres = ?, apellidos = ?, email = ?, telefono = ?, celular = ?, genero = ?, fecha_nac = ? WHERE id_user = ?";
			$updUser = $DB->updatePreparado($c00, "ssssssssi", [$ci, $noms, $aps, $email, $telf, $cel, $genero, $fecnac, $iduser]);

			$resultado = array();
			$resultado["ok"] = $updUser;
			break;

		case 'cambiarEstadoUser':
			$iduser = $body["iduser"];
			$estado = $body["estado"];
			$nestado = ($estado == 'A') ? 'INACTIVO' : 'ACTIVO';

			$c00 = "UPDATE user SET estado = ? WHERE id_user = ?";
			$updUser = $DB->updatePreparado($c00, "si", [$nestado, $iduser]);

			$resultado = array();
			$resultado["ok"] = $updUser;
			break;

		case 'updPwdUser':
			$resultado = array();
			$iduser = $body["iduser"];
			$apwd = md5($body["apwd"]);
			$npwd = md5($body["npwd"]);
			$valor = 0;

			$c00 = "SELECT password FROM user WHERE id_user = ?";
			$password = $DB->consultaPreparadaOne($c00, "i", [$iduser]);
			$pwd = $password->password;

			if ($apwd == $pwd) {
				$c01 = "UPDATE user SET password = ? WHERE id_user = ?";
				$updUser = $DB->updatePreparado($c01, "si", [$npwd, $iduser]);
			} else {
				$nmsj = "LA CONTRASEÑA ANTERIOR NO COINCIDE CON LA ACTUAL.";
				throw new Exception($nmsj);
			}

			$resultado["valor"] = $valor;
			break;

		case 'updQrUser':
			$resultado = array();
			$iduser = $body["iduser"];
			$pwd = $body["pwd"];
			$qrcode = md5($body["txtqr"]);
			$valor = 0;

			if ($pwd === "alohomora") {
				$c01 = "UPDATE user SET codigo_qr = ? WHERE id_user = ?";
				$updUser = $DB->updatePreparado($c01, "si", [$qrcode, $iduser]);

				// -------------------------------- Generamos imagen Qr -----------------------------------

				// Declaramos una carpeta temporal para guardar las imágenes generadas
				$dir = '../../img/qr/';

				// Si no existe la carpeta, la creamos
				if (!file_exists($dir)) {
					mkdir($dir);
				}

				// Declaramos la ruta y nombre del archivo a generar
				$filename = $dir . 'cod-' . $qrcode . '.png';

				// Parámetros de Configuración
				$tamaño = 10; // Tamaño de Pixel
				$level = 'L'; // Precisión Baja
				$framSize = 3; // Tamaño en blanco
				$contenido = $qrcode; // Texto

				// Enviamos los parámetros a la Función para generar código QR 
				QRcode::png($contenido, $filename, $level, $tamaño, $framSize);
			} else {
				$nmsj = "LA CONTRASEÑA DE ADMINISTRADOR NO ES CORRECTA";
				throw new Exception($nmsj);
			}

			$resultado["valor"] = $qrcode;
			break;

			/* --------------------- Actualizar Fotografia ---------------------------- */
		case 'marcarAsistencia':
			$codigo = $body["codigo"];
			$idsucursal = $body["idsucursal"];
			$msj = "";

			// Consulta para obtener el usuario
			$c00 = "SELECT u.id_user, u.nombres, u.apellidos, u.ci, u.foto 
					FROM user u 
					JOIN user_sucursal us ON u.id_user = us.id_user 
					WHERE u.codigo_qr = ? AND us.id_sucursal = ?";
			$user = $DB->consultaPreparadaOne($c00, "si", [$codigo, $idsucursal]);

			if ($user == null) {
				$nmsj = "EL USUARIO NO ESTA REGISTRADO EN EL SISTEMA O SU CARNET NO FUE HABILITADO.";
				throw new Exception($nmsj);
			} else {
				$msj = "Bienvenido " . $user->nombres . " " . $user->apellidos . ". Se registró correctamente su asistencia.";

				// Inserción de asistencia
				$c01 = "INSERT INTO asistencia VALUES (DEFAULT, ?, ?, NOW())";
				$insertasis = $DB->insertPreparado($c01, "ii", [$idsucursal, $user->id_user]);
			}

			$resultado = array();
			$resultado["user"] = $user;
			$resultado["msj"] = $msj;
			break;
			/* --------------------- Direccion ---------------------------- */
		case 'listarDireccion':
			$iduser = $body["iduser"];
			$c00 = "SELECT * FROM direccion WHERE id_user = ? AND estado <> 'ELIMINADO'";
			$direcciones = $DB->consultaPreparada($c00, "i", [$iduser]);
			$resultado = array();
			$resultado["direcciones"] = $direcciones;
			$resultado["query"] = $c00;
			break;

		case 'newDireccion':
			$iduser = $body["iduser"];
			$latitud = $body["latitud"];
			$longitud = $body["longitud"];
			$etiqueta = $body["etiqueta"];
			$direccion = $body["direccion"];
			$pais = $body["pais"];
			$ciudad = $body["ciudad"];
			$localidad = $body["localidad"];
		
			$c00 = "INSERT INTO direccion VALUES (DEFAULT,?, ?, ?, ?, ?, ?, ?, ?, 'ACTIVO')";
		
			$insertDireccion = $DB->insertPreparado($c00, "isssssss", [$iduser, $etiqueta, $direccion, $latitud, $longitud, $pais, $ciudad, $localidad]);
		
			$resultado = array();
			$resultado["ok"] = $insertDireccion;
			break;
			
		case 'deleteDireccion':
			$id = $body["id"];
			$c00 = "UPDATE direccion SET estado = 'ELIMINADO' WHERE id_direccion = ?";
			$updDireccion = $DB->updatePreparado($c00, "i", [$id]);
			$resultado = array();
			$resultado["ok"] = $updDireccion;
			break;

		case 'verDireccion':
			$id = $body["id"];
			$c00 = "SELECT * FROM direccion WHERE id_direccion = ?";
			$direccion = $DB->consultaPreparadaOne($c00, "i", [$id]);
			$resultado = array();
			$resultado["direccion"] = $direccion;
			break;
	}

	$DB->commit();
	$DB->close();
	Response::sendOne($resultado);
} catch (Exception $e) {
	$DB->rollback();
	$DB->close();
	Response::sendError($e);
}
