<!DOCTYPE html>
<html>
<head>
    <?php
	include('includes/cabecera.inc');
	?>
</head>
<body class="skin-5 pace-done mini-navbar">
    <div id="wrapper">
		<?php
			include('includes/menu_izq.inc');
		?>
        <div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
					include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Arqueo de Caja </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title" >
								<div class="col-sm-2"  >
									<h5>Sucursal : <b id='nomSucursal'></b></h5>
								</div>
								<div class="col-lg-2" >
									<div id="mostrarsucursal" style="display:none;">
										<select class="form-control" id="selectSucursal" onchange="cargarArqueos();"></select>
									</div>
								</div>
								<div class="row form-group col-sm-8">
									<div class="col-sm-11">
										<label class="col-sm-1 control-label"> Mes:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='mes' onchange="cam_inifin(this.value);" required />
										</div>
										<label class="col-sm-1 control-label"> F.Ini:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='finicio' required />
										</div>
										<label class="col-sm-1 control-label"> F.Fin:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='ffin' required />
										</div>
									</div>
									<div class="col-sm-1">
										<button class="btn btn-info btn-sm " onclick="cargarArqueos();"> <i class="fa fa-filter"></i> </button>						
									</div>
								</div>
							</div>	
						</div>
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active "> <a id="tabarqueo" onclick="cargarArqueos();" href="#tab-1" ><label class="text-navy" ><i class="fa fa-calculator"></i> Arqueo Caja </a></label></li>
									<li> <a id="tabingreso" href="#tab-2" onclick="cargarIngresos();"><label class="text-navy" ><i class="fa fa-usd"></i> Listado Ingresos </a></label></li>
									<li> <a id="tabegreso" href="#tab-3" onclick="cargarEgresos();"><label class="text-navy" ><i class="fa fa-money"></i> Listado Egresos </a></label></li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado de Arqueos</h5>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" >
															<div id="toogle-columns"></div>
															<table class="table table-striped table-bordered table-hover lisArqueo" >
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Otros Ingresos</h5>
														<div class="ibox-tools">
															<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#newIngreso">
																<i class="fa fa-plus" aria-hidden="true"></i> Nuevo Ingreso
															</button>
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" >
															<div id="toogle-columns2"></div>
															<table class="table table-striped table-bordered table-hover lisIngreso" >
															</table>
														</div>
														
													</div>
												</div>
											</div>
										</div>
										
									</div>
									<div id="tab-3" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado de Egresos</h5>
														<div class="ibox-tools">
															<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#newEgreso">
																<i class="fa fa-plus" aria-hidden="true"></i> Nuevo Egreso
															</button>
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" >
															<div id="toogle-columns2"></div>
															<table class="table table-striped table-bordered table-hover lisEgreso" >
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newEgreso" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"><i class="fa fa-pluss"></i> Nuevo Egreso</h4>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left" >
								<div class="form-group">  
									<label class="control-label col-md-3 col-sm-3 col-xs-12" > Egreso :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectEgreso" style="width: 100%;"  class="form-control" required></select>
									</div>
								</div>
								<div class="form-group">  
									<label class="control-label col-md-3 col-sm-3 col-xs-12" > Tipo Pago :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectTipoPagoE" style="width: 100%;"  class="form-control" required></select>
									</div>
								</div>
								<div class="form-group">  
									<label class="control-label col-md-3 col-sm-3 col-xs-12" > Monto :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" class="form-control input-sm"  id='montoegreso'/>
									</div>
								</div>
								<div class="form-group">  
									<label class="control-label col-md-3 col-sm-3 col-xs-12" > Glosa :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" class="form-control input-sm"  id='glosaegreso'/>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newEgreso();" class="btn btn-success btn-sm" ><i class="fa fa-check"></i> Registrar Egreso </button>
								</div>												
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newIngreso" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"><i class="fa fa-plus"></i> Nuevo Ingreso</h4>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left" >
								<div class="form-group">  
									<label class="control-label col-md-3 col-sm-3 col-xs-12" > Ingreso :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectIngreso" style="width: 100%;"  class="form-control" required></select>
									</div>
								</div>
								<div class="form-group">  
									<label class="control-label col-md-3 col-sm-3 col-xs-12" > Tipo Pago :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectTipoPagoI" style="width: 100%;"  class="form-control" required></select>
									</div>
								</div>
								<div class="form-group">  
									<label class="control-label col-md-3 col-sm-3 col-xs-12" > Monto :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" class="form-control input-sm"  id='montoingreso'/>
									</div>
								</div>
								<div class="form-group">  
									<label class="control-label col-md-3 col-sm-3 col-xs-12" > Glosa :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" class="form-control input-sm"  id='nomingreso'/>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newIngreso();" class="btn btn-success btn-sm" ><i class="fa fa-check"></i> Registrar Ingreso </button>
								</div>												
							</div>
						</div>
					</div>
				</div>
			
			</div>
			<div class="modal inmodal" id="modalIngresos" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"><i class="fa fa-plus-square"></i> Ingresos del Arqueo Seleccionado </h4>
						</div>
						<div class="modal-body">
							<div class="ibox table-responsive" >
								<table class="table table-striped table-bordered table-hover lisIng" >
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalVentas" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"><i class="fa fa-shopping-cart"></i> Ventas del Arqueo Seleccionado </h4>
						</div>
						<div class="modal-body">
							<div class="ibox table-responsive" >
								<table class="table table-striped table-bordered table-hover lisVen" >
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalEgresos" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"><i class="fa fa-minus-square"></i> Egresos del Arqueo Seleccionado </h4>
						</div>
						<div class="modal-body">
							<div class="ibox table-responsive" >
								<table class="table table-striped table-bordered table-hover lisEg" >
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
					include('includes/footer.inc');
				?>
			</div>
        </div>	
    </div>
    <?php
	include('includes/pie.inc');
	?>
	<script>

		var date = new Date();
		var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth()+1);
		var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
		var ultimoDia = new Date(date.getFullYear(), date.getMonth()+1, 0).getDate();
		var fecini = mes + "-" + Empresa.agregarCero(primerDia);
		var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
		var fechoy = mes + "-" + date.getDate();	


		var ids = "<?php echo $ids;?>";
		var idu = "<?php echo $idu;?>";
		var idr = "<?php echo $idr;?>";
		var aps = "<?php echo $aps;?>";
		var nom = "<?php echo $nom;?>";
		var rol = "<?php echo $rol;?>";
		var ico = "<?php echo $ico;?>";
		var emp = "<?php echo $emp;?>";
		var foto = "<?php echo $foto;?>";
		var logo = "<?php echo $logo;?>";
		var tc = "<?php echo $tc;?>";
		var nomSuc = "<?php echo $suc;?>";
		var sig = "<?php echo $sig;?>";
		var dir = "<?php echo $dir;?>";
		var telf = "<?php echo $telf;?>";
		var cel = "<?php echo $cel;?>";
		var loc = "<?php echo $loc;?>";
		var ciu = "<?php echo $ciu;?>";

		var lisArqueo = [];  var lisIngreso = [];
		var lisEgreso = [];

	
		function initializer() {
			cargarDatosWeb(); menuNotificaciones(); menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom+' '+aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src="img/usuario/"+foto+"";
			document.getElementById('nomUser').innerHTML = nom+' '+aps;
			document.getElementById('rolUser').innerHTML = rol;
			selectEgresos(); selectIngresos();
			selectTipoPagoI();selectTipoPagoE();
			selectSucursal(ids);cargarFechas();  verificarArqueo();
			if(idr == '2'){
				$('#mostrarsucursal').show();
			}
			cargarArqueos();
			
		}
		function cargarFechas() {
			$("#mes").val(mes);
			$("#finicio").val(fecini);
			$("#ffin").val(fecfin);
			$("#ffin").val(fecfin);
			var date0=$('input[id="mes"]');
			var date1=$('input[id="finicio"]');
			var date2=$('input[id="ffin"]');
			var hoy=$('input[id="farqueo"]');
			date0.datepicker({
				format: 'yyyy-mm',
				startView: 'months', 
				minViewMode: 'months',
				todayHighlight: true,
				autoclose: true,
			});
			date1.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			date2.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			hoy.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
		}
		function cam_inifin(dato)
		{
			Empresa.cambiarFechas(dato,"#finicio","#ffin");
			mes=$("#mes").val();
			fecini=$("#finicio").val();
			fecfin=$("#ffin").val();
		}
		
		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor){
		    Empresa.actualizarSelect({
			selector: "#selectSucursal",
			sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
			callback: function (data) {
				$("#selectSucursal").val(valor);
				$("#selectSucursal").select2();
			}
		   });
		   ids = valor;
		}
		function selectTipoPagoI() {
			Empresa.actualizarSelect({
				selector: "#selectTipoPagoI",
				sql: "select id_tipo as id, concat(tipo_pago) as etiqueta from tipo_pago",
				callback: function(data) {
					$("#selectTipoPagoI").val(1);
					$("#selectTipoPagoI").select2();
				}
			});
		}
		function selectTipoPagoE() {
			Empresa.actualizarSelect({
				selector: "#selectTipoPagoE",
				sql: "select id_tipo as id, concat(tipo_pago) as etiqueta from tipo_pago",
				callback: function(data) {
					$("#selectTipoPagoE").val(1);
					$("#selectTipoPagoE").select2();
				}
			});
		}
		function selectEgresos(){
		    Empresa.actualizarSelect({
			selector: "#selectEgreso",
			sql: "select transaccion as id, concat(transaccion) as etiqueta from tipo_transaccion where tipo_transaccion='EGRESO'",
			callback: function (data) {
				$("#selectEgreso").select2();
			}
		   });
		}
		function selectIngresos(){
		    Empresa.actualizarSelect({
			selector: "#selectIngreso",
			sql: "select transaccion as id, concat(transaccion) as etiqueta from tipo_transaccion where tipo_transaccion='INGRESO'",
			callback: function (data) {
				$("#selectIngreso").select2();
			}
		   });
		}
		function cargarArqueos() {
			Empresa.showSpinner();
			$('#tabarqueo').tab('show');
			var columnsName = [{title: "#"},{title: " Fecha Registro"},{title: " Boleta"},{title: " Sucursal "},{title: " Cajero"},{title: " Turno"},{title: " Saldo Anterior"}, {title: "Total General"}, {title: " Estado"},{title: " Ventas"},{title: " Ingresos"},{title: " egresos"},{title: " "}];
			lisArqueo = [];
			var idsucursal = document.getElementById("selectSucursal").value;
			if(idsucursal == ""){ idsucursal=ids;}
			var body = 	{ 	funcion: "listarArqueos" , 
							idsucursal: idsucursal,
							idrol: idr,
							iduser: idu,
						};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					var arqueos = respuesta.arqueos;				
					for (var i = 0; i < arqueos.length; i++) {
						lisArqueo.push([
							i+1,
							arqueos[i].fecha_registro,
							arqueos[i].boleta,
							arqueos[i].sucursal,
							arqueos[i].cajero,
							arqueos[i].turno,
							arqueos[i].saldo_anterior,
							arqueos[i].total_general,
							arqueos[i].estado,
							crearButtonsArqueoVentas(arqueos[i].ventas),
							crearButtonsArqueoIngresos(arqueos[i].ingresos),
							crearButtonsArqueoEgresos(arqueos[i].egresos),
							crearButtonsArqueo(arqueos[i].id_arqueo)
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisArqueo",
						data: lisArqueo,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisArqueo",
						data: lisArqueo
					});
					Empresa.hideSpinner();
				},
				funcionError: function (e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}	
		function cargarEgresos() {
			Empresa.showSpinner();
			$('#tabegreso').tab('show');
			var columnsName = [{title: "#"},{title: " Fecha Registro"},{title: " Boleta "},{title: " Sucursal "},{title: " Cajero"},{title: "Egreso"}, {title: "Monto"}, {title: "Glosa"},{title: "Tipo Pago"},{title: "estado"},{title: " "}];
			var lisEgreso = [];
			var idsucursal = document.getElementById("selectSucursal").value;
			if(idsucursal == ""){ idsucursal=ids;}
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var body = 	{ 	funcion: "listarEgresos" , 
							idsucursal: idsucursal,
							idrol: idr,
							iduser: idu,
							fecini: fecini,
							fecfin: fecfin
						};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					var egresos = respuesta.egresos;				
					for (var i = 0; i < egresos.length; i++) {
						lisEgreso.push([
							i+1,
							egresos[i].fecha_registro,
							egresos[i].boleta,
							egresos[i].sucursal,
							egresos[i].cajero,
							egresos[i].tipo_egreso,
							egresos[i].monto,
							egresos[i].glosa,
							egresos[i].tipo_pago,
							egresos[i].estado,
							createButtonDelete(egresos[i].id_egreso, egresos[i].id_arqueo,'Egreso')
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisEgreso",
						data: lisEgreso,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisEgreso",
						data: lisEgreso
					});
					Empresa.hideSpinner();
				},
				funcionError: function (e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}
		function newEgreso(){
			Empresa.showSpinner();
			var detalle = document.getElementById("selectEgreso").value;
			var monto = document.getElementById("montoegreso").value;
			var glosa = document.getElementById("glosaegreso").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			const tipopago = $('select[id="selectTipoPagoE"] option:selected').text();
			if(idsucursal == ""){ idsucursal=ids;}
			var funcion = "newEgreso";
			var body = { funcion: funcion, idsucursal: idsucursal , iduser : idu, detalle: detalle, monto: monto , tipopago: tipopago, glosa: glosa};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					$("#newEgreso").modal("hide");
					$('.egres').val('');
					cargarEgresos();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function (e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}
		function deleteItemEgreso(id){
			var funcion = "deleteEgreso";
			var body = { funcion: funcion , id: id};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					cargarEgresos();
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}
		function cargarIngresos() {
			Empresa.showSpinner();
			$('#tabingreso').tab('show');
			var columnsName = [{title: "#"},{title: " Fecha Registro"},{title: " Boleta "},{title: " Sucursal "},{title: " Cajero"},{title: "Ingreso"}, {title: "Monto"}, {title: "Glosa"}, {title: "Tipo Pago"},{title: "estado"},{title: " "}];
			var lisIngreso = [];
			var idsucursal = document.getElementById("selectSucursal").value;
			if(idsucursal == ""){ idsucursal=ids;}
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var body = 	{ 	funcion: "listarIngresos" , 
							idsucursal: idsucursal,
							idrol: idr,
							iduser: idu,
							fecini: fecini,
							fecfin: fecfin
						};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					var ingresos = respuesta.ingresos;				
					for (var i = 0; i < ingresos.length; i++) {
						lisIngreso.push([
							i+1,
							ingresos[i].fecha_registro,
							ingresos[i].boleta,
							ingresos[i].sucursal,
							ingresos[i].cajero,
							ingresos[i].tipo_ingreso,
							ingresos[i].monto,
							ingresos[i].glosa,
							ingresos[i].tipo_pago,
							ingresos[i].estado,
							createButtonDelete(ingresos[i].id_ingreso, ingresos[i].id_arqueo,'Ingreso')
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisIngreso",
						data: lisIngreso,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisIngreso",
						data: lisIngreso
					});
					Empresa.hideSpinner();
				},
				funcionError: function (e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}
		function newIngreso(){
			Empresa.showSpinner();
			var detalle = document.getElementById("nomingreso").value;
			var monto = document.getElementById("montoingreso").value;
			var ingreso = document.getElementById("selectIngreso").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			var tipopago = $('select[id="selectTipoPagoI"] option:selected').text();
			if(idsucursal == ""){ idsucursal=ids;}
			var funcion = "newIngreso";
			var body = { funcion: funcion, idsucursal: idsucursal, iduser : idu, detalle: detalle, monto: monto, tipopago: tipopago, ingreso: ingreso };
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					$("#newIngreso").modal("hide");
					$('.ingres').val('');
					cargarIngresos();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function (e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}
		function deleteItemIngreso(id){
			var funcion = "deleteIngreso";
			var body = { funcion: funcion , id: id};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					cargarIngresos();
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}

		function verModalIngresos(ingresos) {

			$("#modalIngresos").modal("show");

			var ingresosData = ingresos.data;

			var columnsName = [
				{title: "#"},
				{title: "Fecha Registro"},
				{title: "Boleta"},
				{title: "Ingreso"},
				{title: "Glosa"},
				{title: "Tipo Pago"},
				{title: "Monto"},
			];

			var lisIng = [];
			var totalIngresos = 0;

			for (var i = 0; i < ingresosData.length; i++) {
				let monto = parseFloat(ingresosData[i].MONTO) || 0;
				totalIngresos += monto;

				lisIng.push([
					i + 1,
					ingresosData[i].FECHA_REGISTRO,
					ingresosData[i].BOLETA,
					ingresosData[i].TIPO,    
					ingresosData[i].DETALLE,
					ingresosData[i].TIPO_PAGO,
					monto.toFixed(2)
				]);
			}

			lisIng.push([
				"", "", "", "", "", "<b>Total</b>", `<b>${Empresa.financial(totalIngresos, 2)}</b>`
			]);

			Empresa.inicializarTablaPrint({
				selector: ".lisIng",
				data: lisIng,
				columnas: columnsName
			});

			Empresa.hideSpinner();
		}

		function verModalEgresos(egresos) {

			$("#modalEgresos").modal("show");

			var egresosData = egresos.data;

			var columnsName = [
				{title: "#"},
				{title: "Fecha Registro"},
				{title: "Boleta"},
				{title: "Egreso"},
				{title: "Glosa"},
				{title: "Tipo Pago"},
				{title: "Monto"},
			];

			var lisEgr = [];
			var totalEgresos = 0;

			for (var i = 0; i < egresosData.length; i++) {
				let monto = parseFloat(egresosData[i].MONTO) || 0;
				totalEgresos += monto;

				lisEgr.push([
					i + 1,
					egresosData[i].FECHA_REGISTRO,
					egresosData[i].BOLETA,  
					egresosData[i].TIPO,    
					egresosData[i].DETALLE,
					egresosData[i].TIPO_PAGO,
					monto.toFixed(2)
				]);
			}

			// Agregar fila total
			lisEgr.push([
				"", "", "", "", "", "<b>Total</b>", `<b>${Empresa.financial(totalEgresos, 2)}</b>`
			]);

			Empresa.inicializarTablaPrint({
				selector: ".lisEg",
				data: lisEgr,
				columnas: columnsName
			});

			Empresa.hideSpinner();
		}

		function verModalVentas(ventas) {

			$("#modalVentas").modal("show");

			var ventasData = ventas.data;

			var columnsName = [
				{title: "#"},
				{title: "Fecha Registro"},
				{title: "Boleta"},
				{title: "Cliente"},
				{title: "Glosa"},
				{title: "Tipo Pago"},
				{title: "Cantidad"},
				{title: "Monto"},
			];

			var lisVen = [];
			var totalMonto = 0;
			var totalCantidad = 0;

			for (var i = 0; i < ventasData.length; i++) {
				let monto = parseFloat(ventasData[i].PRECIO_TOTAL) || 0;
				let cantidad = parseFloat(ventasData[i].CANTIDAD) || 0;

				totalMonto += monto;
				totalCantidad += cantidad;

				lisVen.push([
					i + 1,
					ventasData[i].FECHA_REGISTRO,
					ventasData[i].BOLETA,
					ventasData[i].cliente,
					ventasData[i].CONCEPTO,
					ventasData[i].TIPO_VENTA,
					cantidad,
					monto.toFixed(2)
				]);
			}

			// Fila de totales
			lisVen.push([
				"", "", "", "", "", "<b>Total</b>",
				`<b>${Empresa.financial(totalCantidad, 2)}</b>`,
				`<b>${Empresa.financial(totalMonto, 2)}</b>`
			]);

			Empresa.inicializarTablaPrint({
				selector: ".lisVen",
				data: lisVen,
				columnas: columnsName
			});

			Empresa.hideSpinner();
		}



		
		function createButtonDelete(id,arqueo,tabla){
			var btns = "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Imprimir "+tabla+"' onclick='imprimir"+tabla+"(\"" + id + "\")'><i class='fa fa-print'></i></button>";	
			if(arqueo == "0"){
				btns += "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Eliminar Egreso' onclick='deleteItem"+tabla+"(\"" + id + "\")'><i class='fa fa-close'></i></button>";
			}
			return btns;
		}
		function imprimirArqueo(id) {                           
			Empresa.PopupCenter('print_arqueo.php?id='+id+'','IMPRIMIR ARQUEO',400,720);
		}
		function imprimirIngreso(id) {                           
			Empresa.PopupCenter('print_ingreso.php?id='+id+'','IMPRIMIR INGRESO',400,520);
		}
		function imprimirEgreso(id) {                           
			Empresa.PopupCenter('print_egreso.php?id='+id+'','IMPRIMIR EGRESO',400,520);
		}
		function crearButtonsArqueo(id){
			return "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Imprimir compra' onclick='imprimirArqueo(\"" + id + "\")'><i class='fa fa-print'></i></button>";
		}
		function crearButtonsArqueoVentas(ventas){
			return "<button class='btn btn-success btn-xs btn-outline' style='font-size:8px' title='Ventas de Arqueo' onclick='verModalVentas(" + JSON.stringify(ventas) + ")'><i class='fa fa-shopping-cart'></i></button>";
		}
		function crearButtonsArqueoIngresos(ingresos){
			return "<button class='btn btn-primary btn-xs btn-outline' style='font-size:8px' title='Ingresos del Arqueo' onclick='verModalIngresos(" + JSON.stringify(ingresos) + ")'><i class='fa fa-plus-square'></i></button>";
		}
		function crearButtonsArqueoEgresos(egresos){
			return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Egresos del Arqueo' onclick='verModalEgresos(" + JSON.stringify(egresos) + ")'><i class='fa fa-minus-square'></i></button>";
		}

		this.initializer();		
	</script>
</body>
</html>