<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Clientes Empresa </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5>Sucursal : <b id='nomSucursal'></b></h5>
								<div class="ibox-tools">
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-12 col-md-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5> Listado <small class="m-l-sm"> (Clientes) </small></h5>
								<div class="ibox-tools">
									<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#newCliente" title="Nuevo Cliente">
										<i class="fa fa-plus" aria-hidden="true"></i>
									</button>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins" style='margin-top:-15px;'>
							<div class="ibox-content">
								<div id="contenedortablaprincipal" class="ibox ">
									<div id="toogle-columns"></div>
									<div class="ibox table-responsive" style="font-size:10px; max-height: 500px; ">
										<table class="table table-striped table-bordered table-hover lisCliente" style="font-size:10px;">
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newCliente" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Cliente</h4>
							<small>Registro de Clientes del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Razon Social:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="rzs" class="form-control clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="telefono" class="form-control clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> NIT/CI:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="nitci" class="form-control clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Complemento:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="cmp" class="form-control  clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Email:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="email" class="form-control  clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newCliente();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updCliente" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Editar Cliente</h4>
							<small>Editar Clientes del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Razon Social:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updrzs" class="form-control clis col-md-7 col-xs-12">
										<input type="hidden" id="updid" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updtelefono" class="form-control clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> NIT/CI:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updnitci" class="form-control clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Complemento:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updcmp" class="form-control  clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Email:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updemail" class="form-control  clis col-md-7 col-xs-12">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="updCliente();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>

	<?php
	include('includes/pie.inc');
	?>
	<script>
		var ids = "<?php echo $ids; ?>";
		var usr = "<?php echo $usr; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var nomPv = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisCliente = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			headerClientes();
			cargarClientes();
		}
		// -------------------------- Controles Tabla Clientes ---------------------------- //
		function headerClientes() {
			var columnsName = [{
					title: "#"
				},
				{
					title: " Razon Social"
				},
				{
					title: " Telefono"
				},
				{
					title: " NIT/CI"
				},
				{
					title: " Complemento"
				},
				{
					title: " Email"
				},
				{
					title: " Estado"
				},
				{
					title: ""
				}
			];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".lisCliente",
				data: lisCliente,
				columnas: columnsName
			});
		}

		function cargarClientes() {
			Empresa.showSpinner();
			lisCliente = [];
			var body = {
				funcion: "listarClientes"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var clientes = respuesta.clientes.data;
					for (var i = 0; i < clientes.length; i++) {
						lisCliente.push([
							i + 1,
							clientes[i].razonSocial,
							clientes[i].telefono,
							clientes[i].nitCi,
							clientes[i].complemento,
							clientes[i].email,
							createButtonEstado(clientes[i].id, clientes[i].estado, "Cliente"),
							Empresa.createButtonsEdit(clientes[i].id, "Cliente")

						]);
					}

					Empresa.refrescarTablaDeDatos({
						selector: ".lisCliente",
						data: lisCliente
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function newCliente() {
			Empresa.showSpinner();
			var rzs = document.getElementById("rzs").value;
			var nitci = document.getElementById("nitci").value;
			var cmp = document.getElementById("cmp").value;
			var email = document.getElementById("email").value;
			var telefono = document.getElementById("telefono").value;
			var funcion = "newCliente";
			var body = {
				funcion: funcion,
				rzs: rzs,
				telofono: telefono,
				nitci: nitci,
				cmp: cmp,
				email: email
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newCliente").modal("hide");
					$('.clis').val('');
					cargarClientes();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditCliente(id) {
			Empresa.showSpinner();
			var funcion = "editCliente";
			var body = {
				funcion: funcion,
				idcliente: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cliente = respuesta.cliente;
					Empresa.hideSpinner();
					$("#updCliente").modal("show");
					$("#updid").val(cliente.id);
					$("#updrzs").val(cliente.razonSocial);
					$("#updtelefono").val(cliente.telefono);
					$("#updnitci").val(cliente.nitCi);
					$("#updcmp").val(cliente.complemento);
					$("#updemail").val(cliente.email);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updCliente() {
			Empresa.showSpinner();
			var id = document.getElementById("updid").value;
			var rzs = document.getElementById("updrzs").value;
			var nitci = document.getElementById("updnitci").value;
			var cmp = document.getElementById("updcmp").value;
			var telefono = document.getElementById("updtelefono").value;
			var email = document.getElementById("updemail").value;
			var funcion = "updCliente";
			var body = {
				funcion: funcion,
				idcliente: id,
				rzs: rzs,
				telefono: telefono,
				nitci: nitci,
				cmp: cmp,
				email: email
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updCliente").modal("hide");
					$('.clis').val('');
					cargarClientes();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se Actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}

		function cambiarEstadoCliente(id, estado) {
			Empresa.showSpinner();
			var funcion = "cambiarEstadoCliente";
			var body = {
				funcion: funcion,
				idcliente: id,
				estado: estado
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarClientes();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizó correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizó el registro. Intente de nuevo, por favor.");
				}
			});
		}

		// -------------------------- Botón para Cambiar Estado ---------------------------- //

		function createButtonEstado(id, estado, tabla) {
			var btns = "";
			estado = estado.charAt(0);
			$("#updid").val(id);
			if (estado === 'A') {
				btns = "<button class='btn btn-primary btn-xs' style='font-size:8px' title='Cambiar Estado' onclick='cambiarEstado" + tabla + "(\"" + id + "\", \"" + estado + "\")'>" + estado + "</button>";
			} else {
				btns = "<button class='btn btn-danger btn-xs' style='font-size:8px' title='Cambiar Estado' onclick='cambiarEstado" + tabla + "(\"" + id + "\", \"" + estado + "\")'>" + estado + "</button>";
			}

			return btns;
		}


		this.initializer();
	</script>
</body>

</html>