<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper" class="ibox-content" style="padding: 0px;">
		<div class="sk-spinner sk-spinner-wave" >
			<div class="sk-rect1"></div>
			<div class="sk-rect2"></div>
			<div class="sk-rect3"></div>
			<div class="sk-rect4"></div>
			<div class="sk-rect5"></div>
		</div>
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Compra Productos </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<div class="col-sm-2">
									<h5>Sucursal: <b id='nomSucursal'></b></h5>
								</div>
								<div class="col-lg-2">
									<div id="mostrarsucursal" style="display:none;">
										<select class="form-control" id="selectSucursal"></select>
									</div>
								</div>
								<div class="row form-group col-sm-8">
									<div class="col-sm-11">
										<label class="col-sm-1 control-label">Mes:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='mes' onchange="cam_inifin(this.value);" required />
										</div>
										<label class="col-sm-1 control-label">F.Ini:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='finicio' required />
										</div>
										<label class="col-sm-1 control-label">F.Fin:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='ffin' required />
										</div>
									</div>
									<div class="col-sm-1">
										<button class="btn btn-info btn-sm " onclick="cargarCompras();"> <i class="fa fa-filter"></i> </button>
									</div>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active">
										<a id="tabcompra" href="#tab-1" data-toggle="tab"><label class="text-navy"><i class="fa fa-shopping-cart"></i> Realizar Compra</label></a>
									</li>
									<li>
										<a id="tablistado" href="#tab-2" onclick="cargarCompras();"><label class="text-navy"><i class="fa fa-tags"></i> Listado de Compras </label></a>
									</li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-9">
													<div class="ibox">
														<div class="ibox-title">
															<div class="col-md-4">
																<h5>Listado Productos</h5>
															</div>
															<div class="col-md-2">
																<label style="text-align: right;">Stock Total: </label>
															</div>
															<div class="col-md-2">
																<input class="form-control input-sm" type="text" id="stocktotal" disabled>
															</div>
															<div class="col-md-4">
																<button type="button" style="float:right" class="btn btn-outline btn-primary btn-sm" data-toggle="modal" data-target="#modalExcel"> <i class="fa fa-file-excel-o"></i> </button>
															</div>
														</div>
														<div class="ibox-content">
															<div class="row">
																<div class="col-md-6">
																	<select class="form-control" id="selectInventario" onchange="agregarItemStock(this.value,1)" style="width: 100%;" required></select>
																</div>
																<div class="col-md-6">
																	<div class="input-group">
																		<input type="text" id="codbar_cmp" placeholder="Ingrese codigo de Barras" onkeypress="ingresarCodigo(event)" class="form-control input-sm vnt">
																		<span class="input-group-btn">
																			<button type="button" style="width:35px;" onclick="buscarCodigoBarras()" class="btn btn-info btn-sm"><i class="fa fa-search"></i></button>
																		</span>
																	</div>
																</div>
															</div>
															<div class="row">
																<div class="ibox-content">
																	<div class="table-responsive">
																		<table class="table table-striped table-bordered table-hover lisPedido" style="font-size:10px;">
																		</table>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="col-md-3">
													<div class="ibox">
														<div class="ibox-title">
															<span class="pull-right btn btn-primary btn-outline btn-sm">
																<i class="fa fa-shopping-cart"></i>(<strong id="itmcantidad">0</strong>) Items
															</span>
															<h5>Detalle Compra <small>( TC : <span id="tcempresa"></span> )</small></h5>
														</div>
														<div class="ibox-content">
															<div class="form-horizontal form-label-left">
																<label class="control-label">Proveedor: </label>
																<div class="input-group">
																	<select id="selectProveedor" style="width: 100%;" required></select><span class="input-group-btn"> <button type="button" style="width:35px;" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#newProveedor"><i class="fa fa-plus"></i></button></span>
																</div>
																<label class="control-label">Concepto: </label>
																<input type="text" id="concepto_cmp" value='-' class="form-control input-sm  cmp">
																<input type="hidden" id="updidcmp">
																<label class="control-label">Tipo Pago: </label>
																<select id="selectTipoPago" style="width: 100%;" class="form-control  cmp" required></select>
																<label class="control-label">Cantidad: </label>
																<input type="text" value="0" id="cantidad_cmp" class="form-control ven" readonly>
																<label class="control-label">Precio Total</label>
																<input type="text" value="0" id="precio_cmp" class="form-control ven" readonly>
																<div class="modal-footer">
																	<button id="btnokcompra" onclick="realizarCompra()" class="btn btn-primary"> <i class="fa fa-check"></i> Realizar Compra </button>
																	<button id="btnmodcompra" onclick="modificarCompra()" style="display:none;" class="btn btn-success"> <i class="fa fa-check"></i> Modificar Compra </button>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5>Listado Compras</h5>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive">
															<table class="table table-striped table-bordered table-hover lisCompra" style="font-size:10px;">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newProveedor" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Proveedor</h4>
							<small> Registro de un nuevo proveedor </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Razon Social :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="rzsprov" class="form-control col-md-7 col-xs-12 provs">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="telprov" class="form-control col-md-7 col-xs-12 provs">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newProveedor();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalExcel" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-file-excel-o"></i> Subir Excel de Compras </h4>
							<small> Subir Excel de Compras al Sistema.</small>
						</div>
						<div class="modal-body">
							<form method="post" enctype="multipart/form-data">
								<div class="row">
									<div class="form-group">
										<div class="col-md-2 col-sm-2 col-xs-2">
											<label class="control-label"> Excel: </label>
										</div>
										<div class="col-md-8 col-sm-8 col-xs-8">
											<input type="file" class="form-control" id="excelcmp">
										</div>
									</div>
								</div>
							</form>
						</div>
						<div class="modal-footer">
							<button onclick="subirExcelCompra();" class="btn btn-success btn-sm"><i class="fa fa-upload"></i> Subir Excel </button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var date = new Date();
		var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth() + 1);
		var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
		var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
		var fecini = mes + "-" + Empresa.agregarCero(primerDia);
		var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
		var fechoy = mes + "-" + date.getDate();


		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisCompra = [];
		var pedido = [];
		var lisReporte = [];
		var lisInventario = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById('tcempresa').innerHTML = tc;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById('tcempresa').innerHTML = tc;
			selectSucursal(ids);
			selectTipoPago();
			selectProveedor();
			selectInventario();
			cargarFechas();
			headerDetalleCompra();
			if (idr == '2') {
				$('#mostrarsucursal').show();
			}

		}

		function cargarFechas() {
			$("#mes").val(mes);
			$("#finicio").val(fecini);
			$("#ffin").val(fecfin);
			$("#ffin").val(fecfin);
			var date0 = $('input[id="mes"]');
			var date1 = $('input[id="finicio"]');
			var date2 = $('input[id="ffin"]');
			var hoy = $('input[id="farqueo"]');
			date0.datepicker({
				format: 'yyyy-mm',
				startView: 'months',
				minViewMode: 'months',
				todayHighlight: true,
				autoclose: true,
			});
			date1.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			date2.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			hoy.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
		}

		function cam_inifin(dato) {
			Empresa.cambiarFechas(dato, "#finicio", "#ffin");
			mes = $("#mes").val();
			fecini = $("#finicio").val();
			fecfin = $("#ffin").val();
		}

		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal() {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectSucursal").val(ids);
					$("#selectSucursal").select2();
				}
			});
		}

		function selectTipoPago() {
			Empresa.actualizarSelect({
				selector: "#selectTipoPago",
				sql: "select id_tipo as id, concat(tipo_pago) as etiqueta from tipo_pago",
				callback: function(data) {
					$("#selectTipoPago").val(1);
					$("#selectTipoPago").select2();
				}
			});
		}

		function selectProveedor() {
			Empresa.actualizarSelect({
				selector: "#selectProveedor",
				sql: "select id_proveedor as id, concat(razon_social) as etiqueta from proveedor",
				callback: function(data) {
					$("#selectProveedor").select2();
				}
			});
		}

		function selectInventario() {
			Empresa.actualizarSelect({
				selector: "#selectInventario",
				sql: "SELECT p.id_producto as id, concat(p.nombre) as etiqueta FROM producto p",
				callback: function(data) {

					$("#selectInventario").select2({
						placeholder: "Seleccione un producto del inventario.",
						minimumInputLength: 2
					});
				}
			});
			stockInventario();
		}

		// -------------------------- Compras ---------------------------- //

		function headerDetalleCompra() {
			columnsName = [{
				title: "#"
			}, {
				title: "Imagen"
			}, {
				title: "Codigo"
			}, {
				title: "Producto"
			}, {
				title: "Cantidad"
			}, {
				title: "P/Compra"
			}, {
				title: "P/Venta"
			}, {
				title: "P/Mayor"
			}, {
				title: "P/Especial"
			}, {
				title: "P/Tope"
			}, {
				title: "Subtotal"
			},{
				title: "F/Vencimiento"
			},{
				title: "Lote"
			},{
				title: ""
			}];
			Empresa.inicializarTablaSinFormato({
				selector: ".lisPedido",
				columnas: columnsName
			});
		}

		function stockInventario() {
			var funcion = "stockInventario";
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: funcion,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var stock = respuesta.stock;
					$("#stocktotal").val(stock.stocktotal);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function buscarCodigoBarras() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var codigob = document.getElementById("codbar_cmp").value;
			var funcion = "buscarCodigoBarrasIngreso";
			var body = {
				funcion: funcion,
				codigob: codigob,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var producto = respuesta.producto;
					Empresa.hideSpinner();
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_MAYOR, producto.PRECIO_ESPECIAL, producto.PRECIO_TOPE, producto.UNIDAD, producto.IMAGEN, producto.CANTIDAD);
					$("#codbar_cmp").val("");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					$("#codbar_cmp").val("");
					Empresa.hideSpinner();
				}
			});
		}

		function ingresarCodigo(e) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			if ((keycode >= 48 && keycode <= 57) || (keycode > 64 && keycode < 91) || (keycode >= 96 && keycode <= 123) || keycode == 8 || keycode == 45) {

			} else if (keycode == '13') {
				e.preventDefault();
				buscarCodigoBarras();
			} else {
				e.preventDefault();
			}
		}

		function agregarItemStock(id, cantidad) {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var funcion = "editProducto";
			var body = {
				funcion: funcion,
				idproducto: id,
				cantidad: cantidad,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_MAYOR, producto.PRECIO_ESPECIAL, producto.PRECIO_TOPE, producto.UNIDAD, producto.IMAGEN, cantidad);
					selectInventario();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function agregarItem(idp, codigo, nombre, pcompra, pventa, pmayor, pespecial, ptope, unidad, imagen, cantidad) {
			var count = pedido.length;
			var itemPedido = {
				idp, codigo, nombre, pcompra, pventa, pmayor, pespecial, ptope,
				unidad, cantidad, imagen, fvencimiento: fechoy, lote: '0'
			};

			if (count > 0) {
				var id = pedido.findIndex(e => e.idp === idp);
				if (id >= 0) {
					pedido[id].cantidad = parseFloat((parseFloat(pedido[id].cantidad) + parseFloat(cantidad)).toFixed(3));
				} else {
					pedido.push(itemPedido);
				}
			} else {
				pedido.push(itemPedido);
			}

			dibujarTabla();
		}

		function quitarArticulo(id) {
			pedido.splice(id, 1);
			dibujarTabla();
		}

		function itemsCarrito(id, valor) {
			if (pedido[id]) {
				pedido[id].cantidad = parseFloat(valor);
				dibujarTabla();
			}
		}

		function actualizarPrecio(e, actual, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if ((keycode >= 46 && keycode <= 57) || keycode === 8) {
				// Permitidos: números, punto decimal y retroceso
				return;
			}

			if (keycode === 13 || bool === true) {
				if (pedido[id]) {
					pedido[id].pcompra = parseFloat(actual);
					dibujarTabla();
				}
			} else {
				e.preventDefault(); // Bloquea cualquier otra tecla
			}
		}


		function actualizarPrecioTope(e, actual, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if ((keycode >= 46 && keycode <= 57) || keycode == 8) {
				// permite números, punto y borrar
			} else if (keycode == 13 || bool == true) {
				if (pedido[id]) {
					pedido[id].ptope = parseFloat(actual);
					dibujarTabla();
				}
			} else {
				e.preventDefault();
			}
		}

		function actualizarPrecioVenta(e, actual, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if ((keycode >= 46 && keycode <= 57) || keycode == 8) {
				// permite números, punto y borrar
			} else if (keycode == 13 || bool == true) {
				if (pedido[id]) {
					pedido[id].pventa = parseFloat(actual);
					dibujarTabla();
				}
			} else {
				e.preventDefault();
			}
		}

		function actualizarPrecioMayor(e, actual, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if ((keycode >= 46 && keycode <= 57) || keycode == 8) {
				// permite números, punto y borrar
			} else if (keycode == 13 || bool == true) {
				if (pedido[id]) {
					pedido[id].pmayor = parseFloat(actual);
					dibujarTabla();
				}
			} else {
				e.preventDefault();
			}
		}

		function actualizarPrecioEspecial(e, actual, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if ((keycode >= 46 && keycode <= 57) || keycode == 8) {
				// permite números, punto y borrar
			} else if (keycode == 13 || bool == true) {
				if (pedido[id]) {
					pedido[id].pespecial = parseFloat(actual);
					dibujarTabla();
				}
			} else {
				e.preventDefault();
			}
		}

		function actualizarVencimiento(e, valor, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if (keycode === 13 || bool === true) {
				const esFechaValida = !isNaN(Date.parse(valor));
				if (pedido[id] && esFechaValida) {
					pedido[id].fvencimiento = valor;
					dibujarTabla();
				} else {
					Empresa.notificationError("Ingrese una fecha valida.");
				}
			} else {
				e.preventDefault();
			}
		}

		function actualizarLote(e, valor, id) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if ((keycode >= 48 && keycode <= 57) || keycode === 8) {
				// permite números y retroceso
			} else if (keycode === 13 || bool === true) {
				const numero = parseInt(valor);
				if (pedido[id] && !isNaN(numero) && numero >= 0) {
					pedido[id].lote = numero;
					dibujarTabla();
				} else {
					alert("Ingrese un número de lote válido.");
				}
			} else {
				e.preventDefault();
			}
		}

		function dibujarTabla() {
			var detailItem = [];
			var sumtitems = 0;
			var sumtprecio = 0;

			for (var i = 0; i < pedido.length; i++) {
				var preciototal = parseFloat(pedido[i].pcompra) * parseFloat(pedido[i].cantidad);
				sumtitems += parseFloat(pedido[i].cantidad);
				sumtprecio += preciototal;

				detailItem.push([
					"" + (i + 1),
					crearImgDet(pedido[i].imagen, "50"),
					pedido[i].codigo,
					pedido[i].nombre,
					crearInputCantidad(i, pedido[i].cantidad),
					crearInputPrecio(i, pedido[i].pcompra) + " Bs. ",
					crearInputPrecioVenta(i, pedido[i].pventa) + " Bs.",
					crearInputPrecioMayor(i, pedido[i].pmayor) + " Bs.",
					crearInputPrecioEspecial(i, pedido[i].pespecial) + " Bs.",
					crearInputPrecioTope(i, pedido[i].ptope) + " Bs.",
					crearInputPrecioSubTotal(i, preciototal) + " Bs. ",
					crearInputVencimiento(i, pedido[i].fvencimiento),
					crearInputLote(i, pedido[i].lote),
					crearButtonQuitar(i)
				]);
			}

			document.getElementById('itmcantidad').innerHTML = Empresa.financial(sumtitems, 2);
			$("#cantidad_cmp").val(Empresa.financial(sumtitems, 2));
			$("#precio_cmp").val(Empresa.roundNumber(sumtprecio, 2));

			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: detailItem
			});
		}

		// -------------------------- Compras ---------------------------- //
		function cargarCompras() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			$('#tablistado').tab('show');
			var columnsName = [{
				title: "#"
			}, {
				title: " Fecha"
			}, {
				title: " Boleta"
			}, {
				title: " Concepto"
			}, {
				title: " Cantidad Productos"
			}, {
				title: " Costo Total"
			}, {
				title: " Estado"
			}, {
				title: " "
			}];
			lisCompra = [];
			var body = {
				funcion: "listarCompras",
				idsucursal: idsucursal,
				iduser: idu,
				idrol: idr,
				fecini: fecini,
				fecfin: fecfin
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var compras = respuesta.compras.data;
					for (var i = 0; i < compras.length; i++) {
						lisCompra.push([
							i + 1,
							compras[i].FECHA_REGISTRO,
							compras[i].BOLETA,
							compras[i].CONCEPTO,
							compras[i].CANTIDAD,
							compras[i].PRECIO_TOTAL,
							compras[i].ESTADO,
							crearButtonsCompra(compras[i].ID_COMPRA, compras[i].ESTADO)
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisCompra",
						data: lisCompra,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisCompra",
						data: lisCompra
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
			stockInventario();
		}

		function realizarCompra() {
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var concepto = document.getElementById("concepto_cmp").value;
			var proveedor = document.getElementById("selectProveedor").value;
			var tipopago = $('select[id="selectTipoPago"] option:selected').text();
			var cantidad = document.getElementById("cantidad_cmp").value;
			var precio = document.getElementById("precio_cmp").value;
			if (concepto === "") {
				$('#concepto_cmp').val('').focus();
				Empresa.notificationWarning(" El campo de concepto es obligatorio .");
				return;
			}
			if (proveedor === "") {
				$('#selectProveedor').val('').focus();
				Empresa.notificationWarning(" El campo de proveedor es obligatorio .");
				return;
			}
			if (pedido.length == 0) {
				Empresa.notificationError("No se Puede Realizar esta transaccion si no tiene detalle.");
				Empresa.hideSpinner();
				return;
			}
			var funcion = "realizarCompra";
			var body = {
				funcion: funcion,
				concepto: concepto,
				precio: precio,
				cantidad: cantidad,
				detalle: pedido,
				idsucursal: idsucursal,
				proveedor: proveedor,
				iduser: idu,
				tipopago: tipopago,
				tc: tc
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var idcmp = respuesta.idcmp;
					Empresa.notificationSuccess(" Se realizo correctamente la compra");
					imprimirCompra(idcmp);
					location.reload();
				}
			});
		}

		function modificarCompra() {
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var concepto = document.getElementById("concepto_cmp").value;
			var idcompra = document.getElementById("updidcmp").value;
			var proveedor = document.getElementById("selectProveedor").value;
			var tipopago = $('select[id="selectTipoPago"] option:selected').text();
			var cantidad = document.getElementById("cantidad_cmp").value;
			var precio = document.getElementById("precio_cmp").value;
			if (concepto === "") {
				$('#concepto_cmp').val('').focus();
				Empresa.notificationWarning(" El campo de concepto es obligatorio .");
				return;
			}
			if (proveedor === "") {
				$('#selectProveedor').val('').focus();
				Empresa.notificationWarning(" El campo de proveedor es obligatorio .");
				return;
			}
			var funcion = "modificarCompra";
			var body = {
				funcion: funcion,
				concepto: concepto,
				precio: precio,
				cantidad: cantidad,
				detalle: pedido,
				idsucursal: idsucursal,
				proveedor: proveedor,
				iduser: idu,
				tipopago: tipopago,
				tc: tc,
				idcompra: idcompra
			};

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var idcmp = respuesta.idcmp;
					Empresa.notificationSuccess(" Se modifico correctamente la compra");
					imprimirCompra(idcmp);
					location.reload();
				}
			});
		}

		function imprimirCompra(id) {
			Empresa.PopupCenter('print_compra.php?id=' + id + '', 'IMPRIMIR COMPRA', 400, 700);
		}

		function confirmarCompra(id) {
			swal({
					title: "Confirmar Compra",
					text: "Esta Seguro de ingresar la Compra al Inventario",
					type: "warning",
					showCancelButton: true,
					confirmButtonClass: "btn-danger",
					confirmButtonText: "Ingresar",
					cancelButtonText: "Cancelar",
					closeOnConfirm: false,
					closeOnCancel: false
				},
				function(isConfirm) {
					if (isConfirm) {
						swal.close();
						var funcion = "confirmarCompra";
						var body = {
							funcion: funcion,
							idcompra: id,
							idsucursal: ids
						};
						Empresa.rest({
							verbo: 'POST',
							url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
							data: body,
							funcionExito: function(respuesta) {
								var idcmp = respuesta.idcmp;
								Empresa.notificationSuccess(" Se Confirmo Correctamenta la compra y se encuentra en el inventario.");
								cargarCompras();
							}
						});
					} else {
						swal.close();
					}
				});

		}

		function modalEditarCompra(id) {
			$("#updidcmp").val(id);

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: {
					funcion: "modalEditarCompra",
					idcompra: id
				},
				funcionExito: function(respuesta) {
					const detalle = respuesta.detalle.data;
					const compra = respuesta.compra;

					$('#tabcompra').tab('show');
					$("#btnmodcompra").show();
					$("#btnokcompra").hide();
					$("#selectProveedor").val(compra.ID_PROVEEDOR).trigger('change');
					$("#concepto_cmp").val(compra.CONCEPTO);

					pedido = detalle; // carga los ítems en el pedido
					dibujarTabla();   // reutiliza la lógica común

				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargó correctamente el listado");
				}
			});
		}


		function subirExcelCompra() {
			Empresa.showSpinner();
			var inputFile = document.getElementById("excelcmp");
			var file = inputFile.files[0];
			var archivo = file.name;
			var data = new FormData();
			var funcion = "subirExcelCompra";
			data.append('excelcmp', file);
			data.append('funcion', funcion);
			Empresa.restImg({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesArchivosInventario.php"),
				data: data,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var excel = respuesta.excel;
					$("#excelcmp").val("");
					cargarExcelCompra(excel);
					$("#modalExcel").modal("hide");
					Empresa.notificationSuccess("Archivo Subido Correctamente");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function cargarExcelCompra(excel) {
			Empresa.showSpinner();
			lisNewFactura = [];
			var body = {
				funcion: "cargarExcelCompra",
				excel: excel
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {

					var detalle = respuesta.detalle;
					$('#tabcompra').tab('show');
					pedido = [];
					pedido = detalle;
					var detailItem = [];

					var sumtitems = 0;
					var preciototal = 0;
					var sumtprecio = 0;
					for (var i = 0; i < pedido.length; i++) {
						sumtitems = parseFloat(sumtitems) + parseFloat(pedido[i].cantidad);
						preciototal = parseFloat(pedido[i].pcompra) * parseFloat(pedido[i].cantidad);
						sumtprecio = parseFloat(sumtprecio) + parseFloat(preciototal);
						detailItem.push([
							"" + (i + 1),
							crearImgDet(pedido[i].imagen, "50"),
							pedido[i].codigo,
							pedido[i].nombre,
							crearInputCantidad(i, pedido[i].cantidad),
							crearInputPrecio(i, pedido[i].pcompra) + " Bs. ",
							crearInputPrecioVenta(i, pedido[i].pventa) + " Bs.",
							crearInputPrecioMayor(i, pedido[i].pmayor) + " Bs.",
							crearInputPrecioEspecial(i, pedido[i].pespecial) + " Bs.",
							crearInputPrecioTope(i, pedido[i].ptope) + " Bs.",
							crearInputPrecioSubTotal(i, preciototal) + " Bs. ",
							crearInputVencimiento(i, pedido[i].fvencimiento),
							crearInputLote(i, pedido[i].lote),
					
							crearButtonQuitar(i)
						]);
					}
					document.getElementById('itmcantidad').innerHTML = Empresa.financial(sumtitems, 2);
					$("#cantidad_cmp").val(Empresa.financial(sumtitems, 2));
					$("#precio_cmp").val(Empresa.roundNumber(sumtprecio, 2));

					Empresa.refrescarTablaDeDatos({
						selector: ".lisPedido",
						data: detailItem
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
				}
			});
		}
		//------------------------------ Proveedor ---------------------------------------
		function newProveedor() {
			Empresa.showSpinner();
			var proveedor = document.getElementById("rzsprov").value;
			var telefono = document.getElementById("telprov").value;

			var funcion = "newProveedor";
			var body = {
				funcion: funcion,
				proveedor: proveedor,
				telefono: telefono
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newProveedor").modal("hide");
					$('.provs').val('');
					selectProveedor();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}


		function crearInputCantidad(id, cantidad) {
			return "<input class='form-control'  style='width: 70px;' id='num" + id + "' onchange='itemsCarrito(\"" + id + "\",this.value)' type='number' size='4'  step='0.1' min='0.1' value='" + cantidad + "' >";
		}

		function crearInputPrecio(i, precio) {
			return "<input class='form-control' style='width: 80px;' id='prec" + i + "' size='4' type='number' min='0' step='0.01' max='10000' value='" + precio + "'  onfocusout='actualizarPrecio(event,this.value,\"" + i + "\")'>";
		}

		function crearInputPrecioSubTotal(i, precio) {
			return "<input class='form-control' style='width: 70px;' readonly id='precsubtotal" + i + "' size='4' type='text' value='" + precio + "'>";
		}

		function crearInputPrecioVenta(i, preciov) {
			return "<input class='form-control' style='width: 70px;' id='preciov" + i + "' size='4'  type='number' min='0' max='10000' step='0.01' value='" + preciov + "' onfocusout='actualizarPrecioVenta(event,this.value,\"" + i + "\")'>";
		}

		function crearInputPrecioMayor(i, preciom) {
			return "<input class='form-control' style='width: 70px;' id='preciom" + i + "' size='4'  type='number' min='0' max='10000' step='0.01' value='" + preciom + "' onfocusout='actualizarPrecioMayor(event,this.value,\"" + i + "\")'>";
		}

		function crearInputPrecioEspecial(i, precioe) {
			return "<input class='form-control' style='width: 70px;' id='precioe" + i + "' size='4'  type='number' min='0' max='10000' step='0.01' value='" + precioe + "' onfocusout='actualizarPrecioEspecial(event,this.value,\"" + i + "\")'>";
		}

		function crearInputVencimiento(i, vencimiento) {
			return "<input class='form-control' id='vencimiento" + i + "'   type='date' value='" + vencimiento + "'  onfocusout='actualizarVencimiento(event,this.value,\"" + i + "\")'>";;
		}

		function crearInputLote(i, lote) {
			return "<input class='form-control' id='lote" + i + "'  style='width: 80px;' size='4' type='text' value='" + lote + "'  onfocusout='actualizarLote(event,this.value,\"" + i + "\")'>";;
		}

		function crearInputPrecioTope(i, preciotope) {
			return "<input class='form-control' style='width: 70px;' id='preciotope" + i + "' size='4'  type='number' min='0' max='100' step='0.01' value='" + preciotope + "' onfocusout='actualizarPrecioTope(event,this.value,\"" + i + "\")'>";
		}

		function crearButtonQuitar(id) {
			return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Articulo' onclick='quitarArticulo(\"" + id + "\")'><i class='fa fa-trash'></i></button>";
		}

		function crearButtonsCompra(id, estado) {
			var btns = "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Imprimir compra' onclick='imprimirCompra(\"" + id + "\")'><i class='fa fa-print'></i></button>";
			if (estado == "SIN VERIFICAR") {
				btns += "<button class='btn btn-success btn-xs btn-outline' style='font-size:8px' title='Confirmar Compra' onclick='confirmarCompra(\"" + id + "\")'><i class='fa fa-check'></i></button><button class='btn btn-warning btn-xs btn-outline' style='font-size:8px' title='Editar Compra' onclick='modalEditarCompra(\"" + id + "\")'><i class='fa fa-edit'></i></button>";
			}
			return btns;
		}

		function crearImgDet(url, tam) {
			var imgurl = "<img src='img/Producto/" + url + "'  width='" + tam + "' id='imageModel' /> ";
			return imgurl;
		}

		this.initializer();
	</script>
</body>

</html>