<?php

function ean($cadena)//función para generar el control de verificación de un código de barras EAN13 (son 12 dígitos y el de control separado por un guión)
{
    $cadena = strrev($cadena);//se presentan los 12 números de manera inversa
    $i = 0;
    while($i < strlen($cadena))
    {
        if($i%2 == 0) $impares += $cadena[$i];//se suman los impares
        else $pares += $cadena[$i];//se suman los pares
        $i++;
    }
    $suma = $pares + ($impares*3); //se realiza la suma de los pares con el resultado de multiplicar la suma de los impares por 3
    $valor = 10 -($suma%10);
    if($valor == 10){
        return $valor =0;
    }
    else{
        return $valor;
    }
    ////se resta a 10 el resto de dividir esa suma por 10.
}

function validarTextSpace($dato, $null)
{
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;

    $dato = strip_tags($dato);
    $dato = trim($dato);
    if (ereg("[^A-Za-z ]", $dato)) {
        $dev['error'] = false;
        $dev['mensaje'] = "Solo se permiten caracteres";
    }
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
    }
    return $dev;
}

function validarText($dato, $null)
{
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;

    $dato = strip_tags($dato);
    $dato = trim($dato);
    if (ereg("[^A-Za-z]", $dato)) {
        $dev['error'] = false;
        $dev['mensaje'] = "Solo se permiten caracteres sin espacios";
    }
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
    }
    return $dev;
}
function validarText1($dato, $null)
{
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;

    $dato = strip_tags($dato);
    $dato = trim($dato);
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
    }
    return $dev;
}
function validarTextNumericSpace($dato, $null)
{
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;

    $dato = strip_tags($dato);
    $dato = trim($dato);
    if (ereg("[^a-zA-Z0-9\-_ ]$", $dato)) {
        $dev['error'] = false;
        $dev['mensaje'] = "Solo se permiten caracteres alfanumericos";
    }
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
    }
    return $dev;
}
function validarIdTablas($dato, $null)
{
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;

    $dato = strip_tags($dato);
    $dato = trim($dato);
    if (ereg("[A-Za-z]{-}[0-9]", $dato)) {
        $dev['error'] = false;
        $dev['mensaje'] = "Formato de codigo de elemento seleccionado incorrecto";
    }
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
    }
    return $dev;
}
function validarEmail($dato, $null)
{
    $dato = strip_tags($dato);
    $dato = trim($dato);
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;
    if(!ereg("^[A-Za-z0-9\.|-|_]*[@]{1}[A-Za-z0-9\.|-|_]*[.]{1}[a-z]{2,5}$", $dato)) {
        $dev['error'] = false;
        $dev['mensaje'] = "Formato de email incorrecto";
    }
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
        $dev['error'] = true;
    }
    return $dev;
}
function validarUrl($dato, $null)
{
    $dato = strip_tags($dato);
    $dato = trim($dato);
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;
    if(!ereg("^(http\:\/\/)?(www.)?[A-Za-z0-9\.|-|_]*[.]{1}[a-z]{2,5}$", $dato)) {
        $dev['error'] = false;
        $dev['mensaje'] = "Formato de direccion url incorrecto";
    }
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
    }
    return $dev;
}
function validarEntero($dato, $null)
{
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;

    $dato = strip_tags($dato);
    $dato = trim($dato);
    if (ereg("[^0-9]", $dato)) {
        $dev['error'] = false;
        $dev['mensaje'] = "Solo se permiten Numeros";
    }
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
    }
    return $dev;
}
function validarDecimal($dato, $null)
{
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;

    $dato = strip_tags($dato);
    $dato = trim($dato);
    if (ereg("[^0-9]{.}[0-9]{0,20}", $dato)) {
        $dev['error'] = false;
        $dev['mensaje'] = "Solo se permiten Numeros decimales ej. 0.00";
    }
    if($null == true)
    {
        if($dato == "" || $dato == null)
        {
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
        }
    }
    else
    {
        $dev['dato'] = $dato;
    }
    return $dev;
}
function validarPassword($pass1, $pass2, $null)
{

    $pass1 = strip_tags($pass1);
    $pass1 = trim($pass1);
    $pass2 = strip_tags($pass2);
    $pass2 = trim($pass2);
    $dev['error'] = false;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $pass1;
    if($pass1 == $pass2)
    {
        $dev['error'] = true;
    }
    else
    {
        $dev['mensaje'] = "No coinciden las contrasenas";
        $dev['dato'] = "";
    }
    /*if($null)
    {
        if(($pass1 == "" || $pass1 == null) && ($pass2 == null  || $pass2 == "")){
            $dev['error'] = false;
            $dev['mensaje'] = "El parametro es nulo";
            $dev['dato'] = $dato;
        }
    }*/
    return $dev;
}
function validarFecha($dato, $return = true, $formato = "yyyy-mm-dd")
{
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $dev['dato'] = $dato;

    if(strtolower($formato) == "yyyy-mm-dd")
    {
        $a = split("-", $dato);
        $ano = $a[0];
        $mes = $a[1];
        $dia = $a[2];
    }

    if(checkdate($mes, $dia, $ano) != true)
    {
        $dev['error'] = false;
    }
    return $dev;
}
function compararFecha($fechaanterior , $horaanterior, $fechanuevo , $horanuevo , $return = true){
    $dev['error'] = true;
    $dev['mensaje'] = "Todo ok";
    $a = split("-", $fechaanterior);
    $ano = $a[0];
    $mes = $a[1];
    $dia = $a[2];
    $a1 = split(":", $horaanterior);
    $h = $a1[0];
    $m = $a1[1];
    $s = $a1[2];
    $b = split("-", $fechanuevo);
    $ano1 = $b[0];
    $mes1 = $b[1];
    $dia1 = $b[2];
    $b1 = split(":", $horanuevo);
    $h1 = $b1[0];
    $m1 = $b1[1];
    $s1 = $b1[2];
    $anterior = mktime($h, $m, $s, $mes, $dia, $ano);
    $nuevo = mktime($h1, $m1, $s1, $mes1, $dia1, $ano1);
    if($anterior > $nuevo){
        $dev['error'] = false;
    }
    return $dev;
}

function generarSetsUpdate($setC)
{
    $dev = '';
    if($setC != NULL)
    {
        $i = 0;
        do{
            if($setC[$i]['dato'] != null && $setC[$i]['dato'] != "")
            {
                if($dev == "")
                {
                    $dev = $setC[$i]['campo']." = '".$setC[$i]['dato']."' ";
                }
                else
                {
                    $dev .= ", ".$setC[$i]['campo']." = '".$setC[$i]['dato']."' ";
                }
            }
            $i++;
        }while(next($setC)!=false);
    }
    return $dev;
}
function generarInsertValues($setC)
{
    $tem = $setC;
    $dev = '';
    if($setC != NULL)
    {
        $i = 0;
        do{
            if(($setC[$i]['dato'] != null && $setC[$i]['dato'] != "") || ($setC[$i]['dato'] == "0"))
            {
                //                echo $setC[$i]['campo']."----".$setC[$i]['dato']."---";
                if($dev == "")
                {
                    $dev = "(".$setC[$i]['campo']." ";
                }
                else
                {
                    $dev .= ", ".$setC[$i]['campo']." ";
                }
            }
            $i++;
        }while(next($setC)!=false);
        $dev .= ") VALUES";
        $devv ="";
        $i = 0;
        do{
            if(($setC[$i]['dato'] != null && $setC[$i]['dato'] != "") || ($setC[$i]['dato'] == "0"))
            {
                if($devv == "")
                {
                    $tt = substr($tem[$i]['dato'], 0, 1);
                    if($tt == "(")
                    {
                        $dev .= "(".$tem[$i]['dato']." ";
                    }
                    else
                    {
                        $dev .= "('".$tem[$i]['dato']."' ";
                    }
                    $devv ="asdf";
                }
                else
                {
                    $tt = substr($tem[$i]['dato'], 0, 1);
                    if($tt == "(")
                    {
                        $dev .= ", ".$tem[$i]['dato']." ";
                    }
                    else
                    {
                        $dev .= ", '".$tem[$i]['dato']."' ";
                    }
                }
            }
            $i++;
        }while(next($tem)!=false);
    }
    $dev .= ");";
    return $dev;
}
function generarWhereUpdate($setC)
{
    $dev = "";
    if($setC != NULL)
    {
        $i = 0;
        do{

            if($setC[$i]['dato'] != null && $setC[$i]['dato'] != "")
            {
                if($dev == "")
                {
                    $dev = $setC[$i]['campo']." = '".$setC[$i]['dato']."' ";
                }
                else
                {
                    $dev .= " AND ".$setC[$i]['campo']." = '".$setC[$i]['dato']."' ";
                }
            }
            $i++;
        }while(next($setC)!=false);
        $dev = $dev.";";
    }
    return $dev;
}


function genera_password($longitud,$tipo="alfanumerico")
{
    if ($tipo=="alfanumerico"){
        $exp_reg="[^A-Z0-9]";
    } elseif ($tipo=="numerico"){
        $exp_reg="[^0-9]";
    }
    return strtoupper(substr(eregi_replace($exp_reg, "", md5(time())) .
            eregi_replace($exp_reg, "", md5(time())) .
            eregi_replace($exp_reg, "", md5(time())),
            0, $longitud));
}

function MostrarErroresAvisos()
{
    if($_SESSION['error']!=NULL)
    {
        GenerarErrorLog($_SESSION['error'],'Haydee', $_SESSION['error'], 'error', 'si', 'si', '');
        $_SESSION['error']='';
    }
    if($_SESSION['mensaje']!=NULL)
    {
        GenerarErrorLog($_SESSION['mensaje'],'Haydee', $_SESSION['mensaje'], 'mensaje', 'si', 'si', '');
        $_SESSION['mensaje']='';
    }
}

function GenerarErrorLog($error, $autor, $otros='.', $tipo='error', $mostrar='si', $guardar='si', $dirLog='')
{
    if($guardar == 'si')
    {
        $file=date("Ymd");

        $file=$dirLog."../logs/".$file.".txt";
        $log=$tipo."\t".$_SESSION['user']."\t".$autor."\t".date("H:i:s")."\t".$_SERVER['PHP_SELF'].$otros."\n\n";
        if($f=fopen($file, 'a'))
        {
            fwrite($f, $log);
            fclose($f);
        }
    }
    if($tipo=='error')
    {
        $dev="<div class='error'>".$error."</div>";
    }
    else
    {
        $dev="<div class='mensaje'>".$error."</div>";
    }
    if($mostrar=='si')
    {
        echo $dev;
    }
    else
    {
        return $dev;
    }
}

/**
 *
 */
function GuardarScript($script)
{
    $file=date("jnY");

    $file=$dirLog."../scripts/".$file.".sql";
    $dato=$script."\n\n";
    if($f=fopen($file, 'a'))
    {
        fwrite($f, $dato);
        fclose($f);
    }
}

function redondear($numero, $digito=2)
{

    $dev = 0.00;
    if($numero==NULL)
    {
        $numero=0;
        $numero=$numero.".";
        for($i=0;$i<$digito;$i++)
        {
            $numero=$numero."0";
        }
        $dev = $numero;
    }
    else
    {
        if(strpos($numero, '.')==false)
        {
            $numero=$numero.".";
            for($i=0;$i<$digito;$i++)
            {
                $numero=$numero."0";
            }
            $dev = $numero;
        }
        else
        {
            if(strlen($numero)<strpos($numero, '.')+$digito+1)
            {
                $numero=substr($numero, 0, (strpos($numero, '.')+$digito+1));
                for($i=1;$i<$digito;$i++)
                {
                    $numero=$numero."0";
                }
                $dev = $numero;
            }
            else
            {
                $dev = substr($numero, 0, (strpos($numero, '.')+$digito+1));
            }
        }
    }
    return $dev;
}

function ObtenerNavegador($user_agent) {

    $is_lynx = $is_gecko = $is_winIE = $is_macIE = $is_opera = $is_NS4 = $is_safari = $is_chrome = false;

    if (strpos($_SERVER['HTTP_USER_AGENT'], 'Lynx') !== false) {
        $is_lynx = true;
    } elseif ( strpos(strtolower($_SERVER['HTTP_USER_AGENT']), 'chrome') !== false ) {
        $is_chrome = true;
    } elseif ( strpos(strtolower($_SERVER['HTTP_USER_AGENT']), 'webkit') !== false ) {
        $is_safari = true;
    } elseif (strpos($_SERVER['HTTP_USER_AGENT'], 'Gecko') !== false) {
        $is_gecko = true;
    } elseif (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false && strpos($_SERVER['HTTP_USER_AGENT'], 'Win') !== false) {
        $is_winIE = true;
    } elseif (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false && strpos($_SERVER['HTTP_USER_AGENT'], 'Mac') !== false) {
        $is_macIE = true;
    } elseif (strpos($_SERVER['HTTP_USER_AGENT'], 'Opera') !== false) {
        $is_opera = true;
    } elseif (strpos($_SERVER['HTTP_USER_AGENT'], 'Nav') !== false && strpos($_SERVER['HTTP_USER_AGENT'], 'Mozilla/7.') !== false) {
        $is_NS4 = true;
    }

    //    $is_IE = ( $is_macIE || $is_winIE );
    //        return $is_chrome;
    return true;
}
function convertir_a_letras($numero, $moneda = "Bs.")
{
    $numero = number_format($numero, 2, '.', '');
    list($entero, $decimal) = explode('.', $numero);

    $letras = ucfirst(numero_a_letras($entero)) . " {$decimal}/100 {$moneda}";
    return $letras;
}

function numero_a_letras($numero)
{
    $unidades = [
        '', 'uno', 'dos', 'tres', 'cuatro', 'cinco', 'seis', 'siete', 'ocho', 'nueve',
        'diez', 'once', 'doce', 'trece', 'catorce', 'quince', 'dieciséis', 'diecisiete', 'dieciocho', 'diecinueve', 'veinte'
    ];
    $decenas = [
        '', '', 'veinte', 'treinta', 'cuarenta', 'cincuenta', 'sesenta', 'setenta', 'ochenta', 'noventa'
    ];
    $centenas = [
        '', 'ciento', 'doscientos', 'trescientos', 'cuatrocientos', 'quinientos',
        'seiscientos', 'setecientos', 'ochocientos', 'novecientos'
    ];

    if ($numero == 0) return 'cero';
    if ($numero == 100) return 'cien';

    $letras = '';
    if ($numero >= 1000000) {
        $millones = floor($numero / 1000000);
        $letras .= numero_a_letras($millones) . ' millón' . ($millones > 1 ? 'es' : '') . ' ';
        $numero %= 1000000;
    }

    if ($numero >= 1000) {
        $miles = floor($numero / 1000);
        if ($miles == 1) {
            $letras .= 'mil ';
        } else {
            $letras .= numero_a_letras($miles) . ' mil ';
        }
        $numero %= 1000;
    }

    if ($numero > 0) {
        $c = floor($numero / 100);
        $d = floor(($numero % 100) / 10);
        $u = $numero % 10;

        if ($numero <= 20) {
            $letras .= $unidades[$numero];
        } elseif ($numero < 100) {
            $letras .= $decenas[$d];
            if ($u > 0) {
                if ($d == 2) {
                    $letras = substr($letras, 0, -1) . 'i' . $unidades[$u]; // veintiuno
                } else {
                    $letras .= ' y ' . $unidades[$u];
                }
            }
        } else {
            $letras .= $centenas[$c];
            $resto = $numero % 100;
            if ($resto > 0) {
                $letras .= ' ' . numero_a_letras($resto);
            }
        }
    }

    return trim($letras);
}
