<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
	<style>
		.select2-dropdown {
			z-index: 9001;
		}
	</style>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Administracion Entidades </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5>Sucursal : <b id='nomSucursal'></b></h5>
								<div class="ibox-tools">
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active "> <a id="tabtipoproducto" href="#tab-1" onclick="cargarTiposProducto();"><label class="text-navy"><i class="fa fa-dropbox"></i> Tipos Producto </a></label></li>
									<li> <a id="tabcategoria" href="#tab-2" onclick="cargarCategorias();"><label class="text-navy"><i class="fa fa-tags"></i> Categorias </a></label></li>
									<li> <a id="tabmarca" href="#tab-4" onclick="cargarMarcas();"><label class="text-navy"><i class="fa fa-tag"></i> Marcas </a></label></li>
									<li> <a id="tabtipopago" href="#tab-3" onclick="cargarTiposPago();"><label class="text-navy"><i class="fa fa-usd"></i> Tipos de Pago </a></label></li>
									<li> <a id="tabtipotransaccion" href="#tab-5" onclick="cargarTiposTransaccion();"><label class="text-navy"><i class="fa fa-money"></i> Tipos de Transaccion</a></label></li>
									<li> <a id="tabunidadmedida" href="#tab-6" onclick="cargarUnidadMedida();"><label class="text-navy"><i class="fa fa-filter"></i> Unidades de Medida </a></label></li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Tipos Producto</h5>
														<div class="ibox-tools">
															<button class="btn btn-primary btn-xs" title="Nuevo Tipo Producto" data-toggle="modal" data-target="#newTipoProducto">
																<i class="fa fa-plus" aria-hidden="true"></i>
															</button>
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" style="font-size:10px;  ">
															<table class="table table-striped table-bordered table-hover listiproducto">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Categorias </h5>
														<div class="ibox-tools">
															<button class="btn btn-primary btn-xs" title="Nueva Categoria" data-toggle="modal" data-target="#newCategoria">
																<i class="fa fa-plus" aria-hidden="true"></i>
															</button>
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" style="font-size:10px;  ">
															<table class="table table-striped table-bordered table-hover liscategoria">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-3" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Tipos Pago</h5>
														<div class="ibox-tools">
															<button class="btn btn-primary btn-xs" title="Nuevo Tipo Pago" data-toggle="modal" data-target="#newTipoPago">
																<i class="fa fa-plus" aria-hidden="true"></i>
															</button>
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" style="font-size:10px;  ">
															<table class="table table-striped table-bordered table-hover listipopago">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-4" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Marcas</h5>
														<div class="ibox-tools">
															<button class="btn btn-primary btn-xs" title="Nueva Marca" data-toggle="modal" data-target="#newMarca">
																<i class="fa fa-plus" aria-hidden="true"></i>
															</button>
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" style="font-size:10px;  ">
															<table class="table table-striped table-bordered table-hover lismarca">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-5" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Tipos Transaccion</h5>
														<div class="ibox-tools">
															<button class="btn btn-primary btn-xs" title="Nuevo Tipo Transaccion" data-toggle="modal" data-target="#newTipoTransaccion">
																<i class="fa fa-plus" aria-hidden="true"></i>
															</button>
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" style="font-size:10px;  ">
															<table class="table table-striped table-bordered table-hover listipotransaccion">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-6" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Unidades Medida</h5>
														<div class="ibox-tools">
															<button class="btn btn-primary btn-xs" title="Nueva Unidad de Medida" data-toggle="modal" data-target="#newUnidadMedida">
																<i class="fa fa-plus" aria-hidden="true"></i>
															</button>
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" style="font-size:10px;">
															<table class="table table-striped table-bordered table-hover lisunidadmedida">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newTipoProducto" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Item</h4>
							<small> Registro de un nuevo tipo de Producto </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codprod" class="form-control col-md-7 col-xs-12 tipprod">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Producto:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="tipprod" class="form-control col-md-7 col-xs-12 tipprod">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="newTipoProducto();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
						</div>
					</div>
				</div>
			</div>

			<div class="modal inmodal" id="updTipoProducto" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Actualizar Tipo Producto</h4>
							<small> Actualizar Datos del Tipo de Producto </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updcodprod" class="form-control col-md-7 col-xs-12 tips"><input type="hidden" id="updidprod">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Producto:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updtipprod" class="form-control col-md-7 col-xs-12 tips">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updTipoProducto();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newCategoria" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Item</h4>
							<small> Registro de un nuevo item de Categoria </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codcat" class="form-control col-md-7 col-xs-12 cats">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Categoria:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="catcat" class="form-control col-md-7 col-xs-12 cats">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newCategoria();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updCategoria" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Actualizar Categoria </h4>
							<small> Actualizar Datos Categoria. </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updcodcat" class="form-control col-md-7 col-xs-12 cats"><input type="hidden" id="updidcat">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Categoria:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updcatcat" class="form-control col-md-7 col-xs-12 cats">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updCategoria();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="editImageCategoria" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-camera"></i> Actualizar Imagen </h4>
							<small>Actualizar imagen de la Categoria</small>
						</div>
						<div class="modal-body">
							<div class="row">
								<form method="post" action="" enctype="multipart/form-data" id="categoriaForm">

									<div class="col-md-8 col-sm-8 col-xs-12">
										<input type="file" onchange="vistaPreviaCategoria(this);" id="newImgCategoria" class="form-control">
									</div>
									<div class="col-md-4 col-sm-4 col-xs-12" id="categoriaAnt">
										<center><img alt="image" class="img-thumbnail" id="imgCategoria" width="200px" src=""></center>
									</div>
								</form>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updImgCategoria();" type="submit" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos </button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newMarca" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Item</h4>
							<small> Registro de un nuevo item de marca. </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codmar" class="form-control col-md-7 col-xs-12 mars">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Marca:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="marmar" class="form-control col-md-7 col-xs-12 mars">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newMarca();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updMarca" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Actualizar Marca</h4>
							<small> Actualizar Datos Marca . </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updcodmar" class="form-control col-md-7 col-xs-12 mars"><input type="hidden" id="updidmar">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Marca:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updmarmar" class="form-control col-md-7 col-xs-12 mars">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updMarca();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newTipoPago" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Item</h4>
							<small> Registro de un nuevo tipo pago. </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codtip" class="form-control col-md-7 col-xs-12 tips">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Tipo Pago:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="tiptip" class="form-control col-md-7 col-xs-12 tips">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newTipoPago();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updTipoPago" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Actualizar Tipo Pago</h4>
							<small> Actualizar Datos Tipo Pago </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updcodtip" class="form-control col-md-7 col-xs-12 tips"><input type="hidden" id="updidtip">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Tipo Pago:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updtiptip" class="form-control col-md-7 col-xs-12 tips">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updTipoPago();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newTipoTransaccion" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Item</h4>
							<small> Registro de un nuevo tipo Transaccion </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codtipo" class="form-control col-md-7 col-xs-12 tiptr">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Transaccion :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="tiptr" class="form-control col-md-7 col-xs-12 tiptr">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Tipo :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="form-control" style="width: 100%;" id="selectTipoTransaccion">
											<option value="INGRESO">INGRESO</option>
											<option value="EGRESO">EGRESO</option>
										</select>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newTipoTransaccion();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updTipoTransaccion" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Actualizar Tipo Transaccion</h4>
							<small> Actualizar Datos Tipo Egreso </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updcodtipo" class="form-control col-md-7 col-xs-12 tips"><input type="hidden" id="updidtiptr">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Transaccion:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updtiptr" class="form-control col-md-7 col-xs-12 tips">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Tipo :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="form-control" style="width: 100%;" id="updSelectTipoTransaccion">
											<option value="INGRESO">INGRESO</option>
											<option value="EGRESO">EGRESO</option>
										</select>
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updTipoTransaccion();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newUnidadMedida" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Item</h4>
							<small> Registro de una nueva Unidad de Medida. </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codunid" class="form-control col-md-7 col-xs-12 unids">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Medida:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="medunid" class="form-control col-md-7 col-xs-12 unids">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newUnidadMedida();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updUnidadMedida" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Actualizar Unidad de Medida</h4>
							<small> Actualizar Datos Unidad de Medida</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updcodunid" class="form-control col-md-7 col-xs-12 unids"><input type="hidden" id="updidunid">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Medida:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updmedunid" class="form-control col-md-7 col-xs-12 unids">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updUnidadMedida();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			cargarTiposProducto();
			selectSucursal(ids);
		}
		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor) {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectSucursal").val(valor);
					$("#selectSucursal").select2();
				}
			});
			ids = valor;
		}
		// -------------------------- Tipos Producto  ------------------------------
		function cargarTiposProducto() {
			$('#tabtipoproducto').tab('show');
			Empresa.showSpinner();
			var columnsName = [{
					title: "#"
				},
				{
					title: "Codigo"
				},
				{
					title: "Item"
				},
				{
					title: "Editar"
				},
				{
					title: "Eliminar"
				}
			];
			var listiproducto = [];
			var funcion = "listarTiposProducto";
			var body = {
				funcion: funcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var tipos = respuesta.tipos.data;
					for (var i = 0; i < tipos.length; i++) {
						listiproducto.push([
							i + 1,
							tipos[i].CODIGO,
							tipos[i].TIPO_PRODUCTO,
							Empresa.createButtonsEdit(tipos[i].ID_TIPO, "TipoProducto"),
							Empresa.createButtonDelete(tipos[i].ID_TIPO, 'TipoProducto')
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".listiproducto",
						data: listiproducto,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".listiproducto",
						data: listiproducto
					});
				}
			});
		}

		function newTipoProducto() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codprod").value;
			var tipo = document.getElementById("tipprod").value;

			var funcion = "newTipoProducto";
			var body = {
				funcion: funcion,
				tipo: tipo,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newTipoProducto").modal("hide");
					$('.tips').val('');
					cargarTiposProducto();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro, intente de nuevo por favor.");
				}
			});
		}

		function modalEditTipoProducto(id) {
			Empresa.showSpinner();
			var funcion = "editTipoProducto";
			var body = {
				funcion: funcion,
				idtipo: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var tipo = respuesta.tipo;
					Empresa.hideSpinner();
					$("#updTipoProducto").modal("show");
					$("#updidprod").val(tipo.ID_TIPO);
					$("#updtipprod").val(tipo.TIPO_PRODUCTO);
					$("#updcodprod").val(tipo.CODIGO);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updTipoProducto() {
			Empresa.showSpinner();
			var idtipo = document.getElementById("updidprod").value;
			var codigo = document.getElementById("updcodprod").value;
			var tipo = document.getElementById("updtipprod").value;
			var funcion = "updTipoProducto";
			var body = {
				funcion: funcion,
				idtipo: idtipo,
				codigo: codigo,
				tipo: tipo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updTipoProducto").modal("hide");
					$('.tips').val('');
					cargarTiposProducto();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro, intente de nuevo por favor.");
				}
			});
		}

		function deleteItemTipoProducto(id) {
			var funcion = "deleteTipoProducto";
			var body = {
				funcion: funcion,
				id: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarTiposProducto();
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}

		// -------------------------- Categoria  ------------------------------
		function cargarCategorias() {
			$('#tabcategoria').tab('show');
			Empresa.showSpinner();
			var columnsName = [{
				title: "#"
			}, {
				title: "Imagen"
			}, {
				title: "Codigo"
			}, {
				title: "Item"
			}, {
				title: "Editar"
			}, {
				title: "Eliminar"
			}];
			var liscategoria = [];
			var funcion = "listarCategorias";
			var body = {
				funcion: funcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var categorias = respuesta.categorias.data;
					for (var i = 0; i < categorias.length; i++) {
						liscategoria.push([
							i + 1,
							Empresa.crearImagenEdit(categorias[i].ID_CATEGORIA, categorias[i].IMAGEN, "70", "Categoria"),
							categorias[i].CODIGO,
							categorias[i].CATEGORIA,
							Empresa.createButtonsEdit(categorias[i].ID_CATEGORIA, "Categoria"),
							Empresa.createButtonDelete(categorias[i].ID_CATEGORIA, 'Categoria')
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".liscategoria",
						data: liscategoria,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".liscategoria",
						data: liscategoria
					});
				}
			});
		}

		function newCategoria() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codcat").value;
			var categoria = document.getElementById("catcat").value;

			var funcion = "newCategoria";
			var body = {
				funcion: funcion,
				categoria: categoria,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newCategoria").modal("hide");
					$('.cats').val('');
					cargarCategorias();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditCategoria(id) {
			Empresa.showSpinner();
			var funcion = "editCategoria";
			var body = {
				funcion: funcion,
				idcategoria: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var categoria = respuesta.categoria;
					Empresa.hideSpinner();
					$("#updCategoria").modal("show");
					$("#updidcat").val(categoria.ID_CATEGORIA);
					$("#updcatcat").val(categoria.CATEGORIA);
					$("#updcodcat").val(categoria.CODIGO);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updCategoria() {
			Empresa.showSpinner();
			var idcategoria = document.getElementById("updidcat").value;
			var codigo = document.getElementById("updcodcat").value;
			var categoria = document.getElementById("updcatcat").value;
			var funcion = "updCategoria";
			var body = {
				funcion: funcion,
				idcategoria: idcategoria,
				codigo: codigo,
				categoria: categoria
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updCategoria").modal("hide");
					$('.cats').val('');
					cargarCategorias();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function deleteItemCategoria(id) {
			var funcion = "deleteCategoria";
			var body = {
				funcion: funcion,
				id: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarCategorias();
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}

		function vistaPreviaCategoria(input) {
			$('#categoriaAnt').hide();
			if (input.files && input.files[0]) {
				var reader = new FileReader();
				reader.onload = function(e) {
					$('#categoriaForm + div').remove();
					$('#categoriaForm').after('<div class="col-md-4 col-sm-4 col-xs-12"><center><img alt="image" class="img-thumbnail" width="200px" src="' + e.target.result + '"></center></div>');
				};
				reader.readAsDataURL(input.files[0]);
			}
		}

		function editImageCategoria(id, img) {
			$("#editImageCategoria").modal("show");
			$("#updidcat").val(id);
			document.getElementById("imgCategoria").src = "img/categoria/" + img + "";
		}

		function updImgCategoria() {
			Empresa.showSpinner();
			var inputFileImage = document.getElementById("newImgCategoria");
			var id = document.getElementById("updidcat").value;
			var file = inputFileImage.files[0];
			var archivo = file.name;
			var data = new FormData();
			var funcion = "updImgCategoria";
			data.append('newImgCategoria', file);
			data.append('id', id);
			data.append('funcion', funcion);
			Empresa.restImg({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesArchivosAdministracion.php"),
				data: data,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					$("#editImageCategoria").modal("hide");
					$("#newImgCategoria").val("");
					Empresa.notificationSuccess("Archivo Subido Correctamente");
					cargarCategorias();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		// -------------------------- Tipos Pago  ------------------------------
		function cargarTiposPago() {
			$('#tabtipopago').tab('show');
			Empresa.showSpinner();
			var columnsName = [{
				title: "#"
			}, {
				title: "Codigo"
			}, {
				title: "Item"
			}, {
				title: "Editar"
			}, {
				title: "Eliminar"
			}];
			var listipopago = [];
			var funcion = "listarTiposPago";
			var body = {
				funcion: funcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var tipos = respuesta.tipos.data;
					for (var i = 0; i < tipos.length; i++) {
						listipopago.push([
							i + 1,
							tipos[i].CODIGO,
							tipos[i].TIPO_PAGO,
							Empresa.createButtonsEdit(tipos[i].ID_TIPO, "TipoPago"),
							Empresa.createButtonDelete(tipos[i].ID_TIPO, 'TipoPago')
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".listipopago",
						data: listipopago,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".listipopago",
						data: listipopago
					});
				}
			});
		}

		function newTipoPago() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codtip").value;
			var tipo = document.getElementById("tiptip").value;

			var funcion = "newTipoPago";
			var body = {
				funcion: funcion,
				tipo: tipo,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newTipoPago").modal("hide");
					$('.tips').val('');
					cargarTiposPago();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditTipoPago(id) {
			Empresa.showSpinner();
			var funcion = "editTipoPago";
			var body = {
				funcion: funcion,
				idtipo: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var tipo = respuesta.tipo;
					Empresa.hideSpinner();
					$("#updTipoPago").modal("show");
					$("#updidtip").val(tipo.ID_TIPO);
					$("#updtiptip").val(tipo.TIPO_PAGO);
					$("#updcodtip").val(tipo.CODIGO);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updTipoPago() {
			Empresa.showSpinner();
			var idtipo = document.getElementById("updidtip").value;
			var codigo = document.getElementById("updcodtip").value;
			var tipo = document.getElementById("updtiptip").value;
			var funcion = "updTipoPago";
			var body = {
				funcion: funcion,
				idtipo: idtipo,
				codigo: codigo,
				tipo: tipo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updTipoPago").modal("hide");
					$('.tips').val('');
					cargarTiposPago();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function deleteItemTipoPago(id) {
			var funcion = "deleteTipoPago";
			var body = {
				funcion: funcion,
				id: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarTiposPago();
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}
		// -------------------------- Marca  ------------------------------
		function cargarMarcas() {
			$('#tabmarca').tab('show');
			Empresa.showSpinner();
			var columnsName = [{
				title: "#"
			}, {
				title: "Codigo"
			}, {
				title: "Item"
			}, {
				title: "Editar"
			}, {
				title: "Eliminar"
			}];
			var lismarca = [];
			var funcion = "listarMarcas";
			var body = {
				funcion: funcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var marcas = respuesta.marcas.data;
					for (var i = 0; i < marcas.length; i++) {
						lismarca.push([
							i + 1,
							marcas[i].CODIGO,
							marcas[i].MARCA,
							Empresa.createButtonsEdit(marcas[i].ID_MARCA, "Marca"),
							Empresa.createButtonDelete(marcas[i].ID_MARCA, 'Marca')
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lismarca",
						data: lismarca,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lismarca",
						data: lismarca
					});
				}
			});
		}

		function newMarca() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codmar").value;
			var marca = document.getElementById("marmar").value;

			var funcion = "newMarca";
			var body = {
				funcion: funcion,
				marca: marca,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newMarca").modal("hide");
					$('.mars').val('');
					cargarMarcas();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditMarca(id) {
			Empresa.showSpinner();
			var funcion = "editMarca";
			var body = {
				funcion: funcion,
				idmarca: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var marca = respuesta.marca;
					Empresa.hideSpinner();
					$("#updMarca").modal("show");
					$("#updidmar").val(marca.ID_MARCA);
					$("#updmarmar").val(marca.MARCA);
					$("#updcodmar").val(marca.CODIGO);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updMarca() {
			Empresa.showSpinner();
			var idmarca = document.getElementById("updidmar").value;
			var codigo = document.getElementById("updcodmar").value;
			var marca = document.getElementById("updmarmar").value;
			var funcion = "updMarca";
			var body = {
				funcion: funcion,
				idmarca: idmarca,
				codigo: codigo,
				marca: marca
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updMarca").modal("hide");
					$('.mars').val('');
					cargarMarcas();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function deleteItemMarca(id) {
			var funcion = "deleteMarca";
			var body = {
				funcion: funcion,
				id: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarMarcas();
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}
		// -------------------------- Tipos Transaccion ------------------------------
		function cargarTiposTransaccion() {
			$('#tabtipotransaccion').tab('show');
			Empresa.showSpinner();
			var columnsName = [{
				title: "#"
			}, {
				title: "Codigo"
			}, {
				title: "Transaccion"
			}, {
				title: "Tipo"
			}, {
				title: "Editar"
			}, {
				title: "Eliminar"
			}];
			var listipotransaccion = [];
			var funcion = "listarTiposTransaccion";
			var body = {
				funcion: funcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var tipos = respuesta.tipos.data;
					for (var i = 0; i < tipos.length; i++) {
						listipotransaccion.push([
							i + 1,
							tipos[i].CODIGO,
							tipos[i].TRANSACCION,
							tipos[i].TIPO_TRANSACCION,
							Empresa.createButtonsEdit(tipos[i].ID_TIPO, "TipoTransaccion"),
							Empresa.createButtonDelete(tipos[i].ID_TIPO, 'TipoTransaccion')
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".listipotransaccion",
						data: listipotransaccion,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".listipotransaccion",
						data: listipotransaccion
					});
				}
			});
		}

		function newTipoTransaccion() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codtipo").value;
			var transaccion = document.getElementById("tiptr").value;
			var tipo = document.getElementById("selectTipoTransaccion").value;

			var funcion = "newTipoTransaccion";
			var body = {
				funcion: funcion,
				tipo: tipo,
				codigo: codigo,
				transaccion: transaccion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newTipoTransaccion").modal("hide");
					$('.tiptr').val('');
					cargarTiposTransaccion();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditTipoTransaccion(id) {
			Empresa.showSpinner();
			var funcion = "editTipoTransaccion";
			var body = {
				funcion: funcion,
				idtipo: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var tipo = respuesta.tipo;
					Empresa.hideSpinner();
					$("#updTipoTransaccion").modal("show");
					$("#updidtiptr").val(tipo.ID_TIPO);
					$("#updtiptr").val(tipo.TRANSACCION);
					$("#updcodtipo").val(tipo.CODIGO);
					$("#updSelectTipoTransaccion").val(tipo.TIPO_TRANSACCION);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updTipoTransaccion() {
			Empresa.showSpinner();
			var idtipo = document.getElementById("updidtiptr").value;
			var codigo = document.getElementById("updcodtipo").value;
			var tipo = document.getElementById("updSelectTipoTransaccion").value;
			var transaccion = document.getElementById("updtiptr").value;
			var funcion = "updTipoTransaccion";
			var body = {
				funcion: funcion,
				idtipo: idtipo,
				codigo: codigo,
				tipo: tipo,
				transaccion: transaccion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updTipoTransaccion").modal("hide");
					$('.tiptr').val('');
					cargarTiposTransaccion();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function deleteItemTipoTransaccion(id) {
			var funcion = "deleteTipoTransaccion";
			var body = {
				funcion: funcion,
				id: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarTiposTransaccion();
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}
		// -------------------------- Unidad Medida ------------------------------
		function cargarUnidadMedida() {
			$('#tabunidadmedida').tab('show');
			Empresa.showSpinner();
			var columnsName = [{
				title: "#"
			}, {
				title: "Codigo"
			}, {
				title: "Medida"
			}, {
				title: "Editar"
			}, {
				title: "Eliminar"
			}];
			var lisunidadmedida = [];
			var funcion = "listarUnidadMedida";
			var body = {
				funcion: funcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var unids = respuesta.unids.data;
					for (var i = 0; i < unids.length; i++) {
						lisunidadmedida.push([
							i + 1,
							unids[i].CODIGO,
							unids[i].MEDIDA,
							Empresa.createButtonsEdit(unids[i].ID_UNIDAD, "UnidadMedida"),
							Empresa.createButtonDelete(unids[i].ID_UNIDAD, 'UnidadMedida')
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisunidadmedida",
						data: lisunidadmedida,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisunidadmedida",
						data: lisunidadmedida
					});
				}
			});
		}

		function newUnidadMedida() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codunid").value;
			var medida = document.getElementById("medunid").value;

			var funcion = "newUnidadMedida";
			var body = {
				funcion: funcion,
				medida: medida,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newUnidadMedida").modal("hide");
					$('.unids').val('');
					cargarUnidadMedida();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditUnidadMedida(id) {
			Empresa.showSpinner();
			var funcion = "editUnidadMedida";
			var body = {
				funcion: funcion,
				idunidad: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var unidad = respuesta.unidad;
					Empresa.hideSpinner();
					$("#updUnidadMedida").modal("show");
					$("#updidunid").val(unidad.ID_UNIDAD);
					$("#updmedunid").val(unidad.MEDIDA);
					$("#updcodunid").val(unidad.CODIGO);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updUnidadMedida() {
			Empresa.showSpinner();
			var idunidad = document.getElementById("updidunid").value;
			var codigo = document.getElementById("updcodunid").value;
			var medida = document.getElementById("updmedunid").value;
			var funcion = "updUnidadMedida";
			var body = {
				funcion: funcion,
				idunidad: idunidad,
				codigo: codigo,
				medida: medida
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updUnidadMedida").modal("hide");
					$('.unids').val('');
					cargarUnidadMedida();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function deleteItemUnidadMedida(id) {
			var funcion = "deleteUnidadMedida";
			var body = {
				funcion: funcion,
				id: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarUnidadMedida();
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}
		// -------------------------- Div para mostrar Datos ---------------------------- //
		function createDivDatos(datos, nmesas) {
			var divDatos = "";
			if (nmesas > 0) {
				for (var i = 0; i < datos.length; i++) {
					divDatos += "<a class='btn btn-success btn-xs' style='font-size:10px; margin:3px;' title='Editar Mesa' onclick='modalEditMesa(\"" + datos[i].ID + "\")' >" + datos[i].ITEM + "</a>";
				}
			} else {
				divDatos = "<a class='btn btn-warning btn-xs' style='font-size:10px; margin:3px;' title='SIN MESAS' > SIN MESAS </a>";
			}

			return divDatos;
		}

		function createButtonNewMesa(id) {
			return "<button class='btn btn-primary btn-xs btn-outline' style='font-size:8px' title='Imprimir Venta' onclick='modalNewMesa(\"" + id + "\")'><i class='fa fa-plus'></i></button>";
		}

		function createSwitch(id, num, valor, i) {
			if (valor == "1") {
				var check = "checked";
			} else {
				var check = "";
			}
			return "<div class='switch'><div class='onoffswitch'>" +
				"<input type='checkbox' class='onoffswitch-checkbox' id='" + num + i + "' " + check +
				" onclick='cambiarEstadoComplemento(" + id + ", " + num + ", " + valor + ")'>" +
				"<label class='onoffswitch-label' for='" + num + i + "'>" +
				"<span class='onoffswitch-inner'></span>" +
				"<span class='onoffswitch-switch'></span>" +
				"</label></div></div>";
		}

		function createButtonAgregar(id) {
			return "<button class='btn btn-primary btn-xs btn-outline' style='font-size:8px' title='Nuevos Datos' onclick='modalNewDatos(\"" + id + "\")'><i class='fa fa-plus'></i></button>";
		}
		this.initializer();
	</script>
</body>

</html>