<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>

			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<div class="col-sm-2">
									<h5>Sucursal : <b id='nomSucursal'></b></h5>
								</div>
								<div class="col-lg-2">
									<div id="mostrarsucursal" style="display:none;">
										<select class="form-control" id="selectSucursal" onchange="cargarInicio();"></select>
									</div>
								</div>
								<div class="row form-group col-sm-8">
									<div class="col-sm-11">
										<label class="col-sm-1 control-label"> Mes:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='mes' onchange="cam_inifin(this.value);" required />
										</div>
										<label class="col-sm-1 control-label"> F.Ini:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='finicio' required />
										</div>
										<label class="col-sm-1 control-label"> F.Fin:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='ffin' required />
										</div>
									</div>
									<div class="col-sm-1">
										<button class="btn btn-info btn-sm " onclick="cargarInicio();"> <i class="fa fa-filter"></i> </button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">

					<div class="col-md-3">
						<div class="col-md-12">
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-primary pull-right" id="ticmp">Mensual</span>
									<h5>Compras</h5>
								</div>
								<div class="ibox-content">
									<h1 class="no-margins text-navy" id="mcmp">0</h1>
									<div class="stat-percent font-bold text-navy"><span id="ccmp"> 0 Boleta(s)</span> <i class="fa fa-tag"></i></div>
									<small>Costo Compras </small>
								</div>
							</div>
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-success pull-right" id="tiaju">Mensual</span>
									<h5>Ajustes</h5>
								</div>
								<div class="ibox-content ">
									<h1 class="no-margins text-success" id="maju">0</h1>
									<div class="stat-percent font-bold text-success"><span id="caju"> 0 Boleta(s)</span> <i class="fa fa-tag"></i></div>
									<small>Costo Ajustes </small>
								</div>
							</div>
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-info pull-right" id="titrec">Mensual</span>
									<h5>Traspasos Recibidos</h5>
								</div>
								<div class="ibox-content">
									<h1 class="no-margins text-info" id="mtrec">0</h1>
									<div class="stat-percent font-bold text-info"><span id="ctrec"> 0 Boleta(s)</span> <i class="fa fa-tag"></i></div>
									<small>Costo Traspaso</small>
								</div>
							</div>
						</div>
					</div>

					<div class="col-md-3">
						<div class="col-md-12">
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-primary pull-right" id="tivnt">Mensual</span>
									<h5>Ventas</h5>
								</div>
								<div class="ibox-content">
									<h1 class="no-margins" id="mvnt">0</h1>
									<div class="stat-percent font-bold text-navy"> <span id="cvnt"> 0 Boleta(s)</span> <i class="fa fa-tag"></i></div>
									<small>Total Ventas </small>
								</div>
							</div>
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-warning pull-right" id="tibaj">Mensual</span>
									<h5>Bajas</h5>
								</div>
								<div class="ibox-content">
									<h1 class="no-margins" id="mbaj">0</h1>
									<div class="stat-percent font-bold text-warning"> <span id="cbaj"> 0 Boleta(s) </span> <i class="fa fa-tag"></i></div>
									<small>Costo Bajas </small>
								</div>
							</div>
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-info pull-right" id="titenv">Mensual</span>
									<h5>Traspasos Enviados</h5>
								</div>
								<div class="ibox-content">
									<h1 class="no-margins" id="mtenv">0</h1>
									<div class="stat-percent font-bold text-info"> <span id="tenv"> 0 Boleta(s)</span> <i class="fa fa-tag"></i></div>
									<small>Costo Traspasos Enviados </small>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-3">
						<div class="col-md-12">
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-default pull-right" id="tifac">Mensual</span>
									<h5>Facturas</h5>
								</div>
								<div class="ibox-content">
									<h1 class="no-margins" id="mfac">0</h1>
									<div class="stat-percent font-bold text-default"> <span id="cfac"> 0 Boleta(s)</span> <i class="fa fa-tag"></i></div>
									<small>Total Facturas </small>
								</div>
							</div>
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-primary pull-right" id="tiing">Mensual</span>
									<h5>Ingresos</h5>
								</div>
								<div class="ibox-content">
									<h1 class="no-margins" id="ming">0</h1>
									<div class="stat-percent font-bold text-navi"> <span id="cing"> 0 Boleta(s) </span> <i class="fa fa-tag"></i></div>
									<small>Total Ingresos </small>
								</div>
							</div>
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<span class="label label-danger pull-right" id="tiegre">Mensual</span>
									<h5>Egresos</h5>
								</div>
								<div class="ibox-content">
									<h1 class="no-margins" id="megre">0</h1>
									<div class="stat-percent font-bold text-danger"> <span id="cegre"> 0 Boleta(s)</span> <i class="fa fa-tag"></i></div>
									<small>Total Egresos </small>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-3">
						<div class="panel panel-default">
							<div class="panel-heading">
								<label><i class="fa fa-calendar"></i> Calendario </label>
								<button class="btn btn-primary btn-xs pull-right" onclick="cargarHoy();"> HOY </button>
							</div>
							<div class="panel-body">
								<center>
									<div id="data_1"> </div>
								</center>
							</div>
						</div>
					</div>
					<div class="col-md-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5> Grafico <small class="m-l-sm"> (Compras-Ventas) </small></h5>
							</div>
						</div>
						<div class="ibox float-e-margins" style='margin-top:-15px;'>
							<div class="ibox-content">
								<div>
									<canvas id="barChart" height="50"></canvas>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>

	<?php
	include('includes/pie.inc');
	?>
	<script>
		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";

		var date = new Date();
		var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth() + 1);
		var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
		var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
		var fecini = mes + "-" + Empresa.agregarCero(primerDia);
		var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
		var fechoy = mes + "-" + Empresa.agregarCero(date.getDate());

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/usuario/" + foto + "";
			cargarFechas();
			$('#data_1').datepicker({
				todayHighlight: true
			});
			selectSucursal(ids);
			if (idr == '2') {
				$('#mostrarsucursal').show();
			}
			cargarInicio();
			verDatosMovimiento();
		}

		function cargarFechas() {
			$("#mes").val(mes);
			$("#finicio").val(fecini);
			$("#ffin").val(fecfin);
			$("#ffin").val(fecfin);
			var date0 = $('input[id="mes"]');
			var date1 = $('input[id="finicio"]');
			var date2 = $('input[id="ffin"]');
			var hoy = $('input[id="farqueo"]');
			date0.datepicker({
				format: 'yyyy-mm',
				startView: 'months',
				minViewMode: 'months',
				todayHighlight: true,
				autoclose: true,
			});
			date1.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			date2.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			hoy.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
		}

		function cam_inifin(dato) {
			Empresa.cambiarFechas(dato, "#finicio", "#ffin");
			mes = $("#mes").val();
			fecini = $("#finicio").val();
			fecfin = $("#ffin").val();
		}
		// -------------------------- Cargar Selects ---------------------------- //

		function selectSucursal(valor) {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectSucursal").val(valor);
					$("#selectSucursal").select2();
				}
			});
			ids = valor;
		}
		// -------------------------- Cargar Inicio ---------------------------- //
		function cargarInicio() {
			Empresa.showSpinner();
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var funcion = "cargarInicio";
			var body = {
				funcion: funcion,
				idsucursal: idsucursal,
				iduser: idu,
				idrol: idr,
				fecini: fecini,
				fecfin: fecfin
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var compra = respuesta.compra;
					var venta = respuesta.venta;
					var egreso = respuesta.egreso;
					var ingreso = respuesta.ingreso;
					var ajuste = respuesta.ajuste;
					var baja = respuesta.baja;
					var recibido = respuesta.recibido;
					var enviado = respuesta.enviado;
					var factura = respuesta.factura;
					var tiempo = respuesta.tiempo;

					document.getElementById('ccmp').innerHTML = (Math.round(compra.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mcmp').innerHTML = (compra.total || "0") + " Bs.";
					document.getElementById('ticmp').innerHTML = tiempo;

					document.getElementById('cvnt').innerHTML = (Math.round(venta.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mvnt').innerHTML = (venta.total || "0") + " Bs.";
					document.getElementById('tivnt').innerHTML = tiempo;

					document.getElementById('cing').innerHTML = (Math.round(ingreso.cantidad || 0)) + " Boleta(s)";
					document.getElementById('ming').innerHTML = (ingreso.total || "0") + " Bs.";
					document.getElementById('tiing').innerHTML = tiempo;

					document.getElementById('cegre').innerHTML = (Math.round(egreso.cantidad || 0)) + " Boleta(s)";
					document.getElementById('megre').innerHTML = (egreso.total || "0") + " Bs.";
					document.getElementById('tiegre').innerHTML = tiempo;

					document.getElementById('caju').innerHTML = (Math.round(ajuste.cantidad || 0)) + " Boleta(s)";
					document.getElementById('maju').innerHTML = (ajuste.total || "0") + " Bs.";
					document.getElementById('tiaju').innerHTML = tiempo;

					document.getElementById('cbaj').innerHTML = (Math.round(baja.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mbaj').innerHTML = (baja.total || "0") + " Bs.";
					document.getElementById('tibaj').innerHTML = tiempo;

					document.getElementById('ctrec').innerHTML = (Math.round(recibido.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mtrec').innerHTML = (recibido.total || "0") + " Bs.";
					document.getElementById('titrec').innerHTML = tiempo;

					document.getElementById('tenv').innerHTML = (Math.round(enviado.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mtenv').innerHTML = (enviado.total || "0") + " Bs.";
					document.getElementById('titenv').innerHTML = tiempo;

					document.getElementById('cfac').innerHTML = (Math.round(factura.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mfac').innerHTML = (factura.total || "0") + " Bs.";
					document.getElementById('tifac').innerHTML = tiempo;


				}
			});
		}

		function cargarHoy() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var funcion = "cargarInicio";
			var body = {
				funcion: funcion,
				idsucursal: idsucursal,
				iduser: idu,
				idrol: idr,
				fecini: fechoy,
				fecfin: fechoy
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var compra = respuesta.compra;
					var venta = respuesta.venta;
					var egreso = respuesta.egreso;
					var ingreso = respuesta.ingreso;
					var ajuste = respuesta.ajuste;
					var baja = respuesta.baja;
					var recibido = respuesta.recibido;
					var enviado = respuesta.enviado;
					var factura = respuesta.factura;
					var tiempo = respuesta.tiempo;

					document.getElementById('ccmp').innerHTML = (Math.round(compra.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mcmp').innerHTML = (compra.total || "0") + " Bs.";
					document.getElementById('ticmp').innerHTML = tiempo;

					document.getElementById('cvnt').innerHTML = (Math.round(venta.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mvnt').innerHTML = (venta.total || "0") + " Bs.";
					document.getElementById('tivnt').innerHTML = tiempo;

					document.getElementById('cing').innerHTML = (Math.round(ingreso.cantidad || 0)) + " Boleta(s)";
					document.getElementById('ming').innerHTML = (ingreso.total || "0") + " Bs.";
					document.getElementById('tiing').innerHTML = tiempo;

					document.getElementById('cegre').innerHTML = (Math.round(egreso.cantidad || 0)) + " Boleta(s)";
					document.getElementById('megre').innerHTML = (egreso.total || "0") + " Bs.";
					document.getElementById('tiegre').innerHTML = tiempo;

					document.getElementById('caju').innerHTML = (Math.round(ajuste.cantidad || 0)) + " Boleta(s)";
					document.getElementById('maju').innerHTML = (ajuste.total || "0") + " Bs.";
					document.getElementById('tiaju').innerHTML = tiempo;

					document.getElementById('cbaj').innerHTML = (Math.round(baja.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mbaj').innerHTML = (baja.total || "0") + " Bs.";
					document.getElementById('tibaj').innerHTML = tiempo;

					document.getElementById('ctrec').innerHTML = (Math.round(recibido.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mtrec').innerHTML = (recibido.total || "0") + " Bs.";
					document.getElementById('titrec').innerHTML = tiempo;

					document.getElementById('tenv').innerHTML = (Math.round(enviado.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mtenv').innerHTML = (enviado.total || "0") + " Bs.";
					document.getElementById('titenv').innerHTML = tiempo;

					document.getElementById('cfac').innerHTML = (Math.round(factura.cantidad || 0)) + " Boleta(s)";
					document.getElementById('mfac').innerHTML = (factura.total || "0") + " Bs.";
					document.getElementById('tifac').innerHTML = tiempo;

				}
			});
		}

		function verDatosMovimiento() {
			Empresa.showSpinner();
			var fecini = document.getElementById("finicio").value;
			var funcion = "verDatosMovimiento";
			var body = {
				funcion: funcion,
				idsucursal: ids,
				idrol: idr,
				iduser: idu,
				fecini: fecini
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var compras = respuesta.compras;
					var ventas = respuesta.ventas;
					var ingresos = respuesta.ingresos;
					var egresos = respuesta.egresos;
					var dias = respuesta.dias;

					var barOptions = {
						responsive: true,
						scales: {
							y: {
								beginAtZero: true
							}
						}
					};

					var barData = {
						labels: dias,
						datasets: [
							{
								label: "Compras Bs.",
								backgroundColor: '#f8ac59', // naranja
								borderColor: "#f8ac59",
								data: compras
							},
							{
								label: "Ventas Bs.",
								backgroundColor: '#1c84c6', // azul
								borderColor: "#1c84c6",
								data: ventas
							},
							{
								label: "Ingresos Bs.",
								backgroundColor: '#1ab394', // verde
								borderColor: "#1ab394",
								data: ingresos
							},
							{
								label: "Egresos Bs.",
								backgroundColor: '#ed5565', // rojo
								borderColor: "#ed5565",
								data: egresos
							}
						]
					};

					var ctx2 = document.getElementById("barChart").getContext("2d");
					new Chart(ctx2, {
						type: 'bar',
						data: barData,
						options: barOptions
					});
				}
			});
		}


		this.initializer();
	</script>
</body>

</html>