<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <title id="nombreempresa"></title>

    <link rel="shortcut icon" id="iconoempresa" href="" />
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Toastr style -->
    <link href="css/plugins/toastr/toastr.min.css" rel="stylesheet">

    <!-- Gritter -->
    <link href="js/plugins/gritter/jquery.gritter.css" rel="stylesheet">

    <link href="css/plugins/iCheck/custom.css" rel="stylesheet">

    <link href="css/plugins/steps/jquery.steps.css" rel="stylesheet">

    <!-- Tables -->
    <link href="css/plugins/dataTables/datatables.min.css" rel="stylesheet">
    <link href="css/plugins/dataTables/jquery.dataTables.css" rel="stylesheet">

    <!-- Lightslider -->
    <link href="css/plugins/lightslider/lightslider.css" rel="stylesheet">

    <link href="css/plugins/fullcalendar/fullcalendar.css" rel="stylesheet">
    <link href="css/plugins/fullcalendar/fullcalendar.print.css" rel='stylesheet' media='print'>

    <link href="css/plugins/chosen/bootstrap-chosen.css" rel="stylesheet">

    <!-- Select -->
    <link href="css/plugins/select2/select2.min.css" rel="stylesheet">


    <link href="css/plugins/datapicker/datepicker3.css" rel="stylesheet">

    <!-- Sweet Alert -->
    <link href="css/plugins/sweetalert/sweetalert.css" rel="stylesheet">

    <!-- dropzone -->
    <link href="css/plugins/dropzone/basic.css" rel="stylesheet">

    <link href="css/plugins/dropzone/dropzone.css" rel="stylesheet">

    <link href="css/plugins/bootstrapSocial/bootstrap-social.css" rel="stylesheet">

    <!-- checkbox -->
    <link href="css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="css/plugins/awesome-bootstrap-checkbox/awesome-bootstrap-checkbox.css" rel="stylesheet">

    <!-- MapBox -->
    <link href="https://api.mapbox.com/mapbox-gl-js/v1.12.0/mapbox-gl.css" rel="stylesheet" />

    <link href="css/plugins/summernote/summernote.css" rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

</head>

<body class="top-navigation">
    <div id="preloader">
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
    </div>
    <div id="wrapper">
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom white-bg">
                <nav class="navbar navbar-expand-lg navbar-static-top" role="navigation">
                    <div class="container">
                        <div class="row">
                            <div class="col-xs-4">
                                <img class="logo-name" width="120px" id="logolargoempresa" src="img/empresa/logolargo.png">
                            </div>
                            <div class="col-xs-3">
                            </div>
                            <div class="col-md-5 hidden-xs">
                                <ul class="nav navbar-top-links navbar-right">
                                    <li>
                                        <a>
                                            <i class="fa fa-calendar"></i> 
                                            <span id="fechaliteral" ></span> 
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                    </div>
                </nav>
            </div>
            <div class="wrapper wrapper-content ">
                <div class="row">
                    <div class="container">
                        <div class="ibox float-e-margins">
                            <div class="ibox-content">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="ibox-content">
                                            <div class="row">

                                                <div class="col-sm-9">
                                                    <div class="row">
                                                        <div class="col-md-12 hidden-xs hidden-sm">
                                                            <img id="banerempresa" src="img/empresa/baner.jpeg" style="width:100%">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3 b-r">
                                                    <div class='m-t text-center'>
                                                        <img class='logo-name' width='100%' id="logoempresa" src='img/empresa/logo_cuadrado.png'>
                                                    </div>

                                                    <div id="login-form">
                                                        <h3 class="m-t-none m-b text-center">INGRESAR SISTEMA</h3>
                                                        <div role="form">
                                                            <div class="form-group">
                                                                <input type="text" class="form-control" id="usr" placeholder="Usuario" required="" />
                                                            </div>
                                                            <div class="form-group">
                                                                <input type="password" class="form-control" id="pwd" placeholder="Contraseña" required="" onkeypress="ingresarPwd(event)" />
                                                            </div>
                                                            <div>
                                                                <button class="btn btn-primary block full-width m-b" onclick="ingresarSistema()"><i class='fa fa-sign-in'></i> Ingresar</button>
                                                                <a href="#" data-toggle="modal" data-target="#modalRecuperarContraseña"><small>¿Olvidaste tu contraseña?</small></a>
                                                                <p class="text-muted text-center"><small>¿No tienes una cuenta?</small></p>
                                                                <a class="btn btn-sm btn-white btn-block" onclick="mostrarRegistro()">Crea una cuenta</a>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div id="register-form" style="display: none;">
                                                        <h3 class="m-t-none m-b text-center">REGISTRO RÁPIDO</h3>
                                                        <div role="form">
                                                            <div class="form-group">
                                                                <input type="text" class="form-control" id="nombres" placeholder="Nombres" required />
                                                            </div>

                                                            <div class="form-group">
                                                                <input type="text" class="form-control" id="apellidos" placeholder="Apellidos" required />
                                                            </div>

                                                            <div class="form-group">
                                                                <input type="text" class="form-control" id="ci" placeholder="CI" required />
                                                            </div>

                                                            <div class="form-group">
                                                                <input type="email" class="form-control" id="email" placeholder="Correo electrónico" required />
                                                            </div>

                                                            <div>
                                                                <button class="btn btn-primary block full-width m-b" onclick="registrarUsuario()"><i class='fa fa-user-plus'></i> Registrar</button>
                                                                <a class="btn btn-sm btn-white btn-block" onclick="mostrarLogin()">Cancelar</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Modal para recuperar contraseña -->
            <div class="modal fade" id="modalRecuperarContraseña" tabindex="-1" role="dialog" aria-labelledby="modalRecuperarContraseñaLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalRecuperarContraseñaLabel">Recuperar Contraseña</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form id="formRecuperarContraseña">
                                <div class="form-group">
                                    <label for="emailRecuperacion">Correo Electrónico</label>
                                    <input type="email" class="form-control" id="emailRecuperacion" placeholder="Ingrese su correo electrónico" required>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                            <button type="button" class="btn btn-primary" onclick="enviarRecuperacion()">Enviar</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="footer ">
                <div class="container">
                    <?php
                    include('includes/footer.inc');
                    ?>
                </div>
            </div>

        </div>
    </div>
    <?php
    include('includes/pie1.inc');
    ?>
</body>
<script>
    function initializer() {
        cargarDatosIndex();
        const fechaActualLiteral = obtenerFechaLiteral();
        document.getElementById('fechaliteral').innerHTML = fechaActualLiteral;
        setTimeout(function() {
            Empresa.hidePreloader('wrapper'); 
        }, 1000); 
    }

    function ingresarPwd(e) {
        var keycode = (e.keyCode ? e.keyCode : e.which);
        if ((keycode >= 48 && keycode <= 57) || (keycode > 64 && keycode < 91) || (keycode >= 96 && keycode <= 123) || keycode == 8 || keycode == 45) {

        } else if (keycode == '13') {
            e.preventDefault();
            ingresarSistema();
        } else {
            e.preventDefault();
        }
    }

    function cargarDatosIndex() {
        var funcion = "editEmpresa";
        var body = {
            funcion: funcion
        };
        Empresa.rest({
            verbo: 'POST',
            url: Empresa.armarUrl("/api/paginaweb/funcionesPaginaWeb.php"),
            data: body,
            funcionExito: function(respuesta) {
                var empresa = respuesta.empresa;
                document.getElementById("nombreempresa").innerHTML = empresa.EMPRESA;
                document.getElementById("logoempresa").src = "img/empresa/" + empresa.LOGO_CUADRADO + "";
                document.getElementById("logolargoempresa").src = "img/empresa/" + empresa.LOGO_LARGO + "";
                document.getElementById("banerempresa").src = "img/empresa/" + empresa.BANER_INICIO + "";
                document.getElementById("iconoempresa").href = "img/empresa/" + empresa.ICONO + "";
            }
        });
    }

    function ingresarSistema() {
        var funcion = "login";
        var usr = document.getElementById("usr").value.trim();
        var pwd = document.getElementById("pwd").value.trim();

        // Validación de campos vacíos
        if (!usr || !pwd) {
            swal("Campos incompletos", "Por favor, ingresa tu usuario y contraseña.", "warning");
            return;
        }

        var body = {
            funcion: funcion,
            usuario: usr,
            contrasena: pwd
        };

        Empresa.rest({
            verbo: 'POST',
            url: Empresa.armarUrl("api/usuario/funcionesUsuarios.php"),
            data: body,
            funcionExito: function(respuesta) {
                var sesion = respuesta.sesion;
                if (sesion == '1') {
                    window.location = "home"; // Redirige a la página principal
                } else if (sesion == '0') {
                    swal("Error", "Contraseña o usuario incorrectos.", "error");
                }
            },
            funcionError: function() {
                swal("Error", "Hubo un problema al iniciar sesión. Intente nuevamente.", "error");
            }
        });
    }


    function mostrarRegistro() {
        document.getElementById('login-form').style.display = 'none';
        document.getElementById('register-form').style.display = 'block';
    }

    function mostrarLogin() {
        document.getElementById('register-form').style.display = 'none';
        document.getElementById('login-form').style.display = 'block';
    }

    function registrarUsuario() {
        Empresa.showSpinner();
        var rol = '4';
        var sucursal = '1';
        var ci = document.getElementById("ci").value;
        var noms = document.getElementById("nombres").value;
        var aps = document.getElementById("apellidos").value;
        var genero = 'MASCULINO';
        var fecnac = '0000-00-00';
        var email = document.getElementById("email").value;
        var telf = '';
        var cel = '';

        // Verificación de campos vacíos
        if (!noms || !aps || !ci || !email) {
            swal("Campos incompletos", "Por favor, complete todos los campos.", "warning");
            return;
        }

        // Validación de correo electrónico
        const emailRegex = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/;
        if (!emailRegex.test(email)) {
            swal("Correo electrónico inválido", "Por favor, ingresa un correo electrónico válido.", "warning");
            return;
        }

        var user = noms.charAt(0).toLowerCase() + aps.charAt(0).toLowerCase() + ci;

        var funcion = "newUser";
        var body = {
            funcion: funcion,
            rol: rol,
            sucursal: sucursal,
            user: user,
            ci: ci,
            noms: noms,
            aps: aps,
            email: email,
            telf: telf,
            cel: cel,
            fecnac: fecnac,
            genero: genero
        };

        Empresa.rest({
            verbo: 'POST',
            url: Empresa.armarUrl("api/usuario/funcionesUsuarios.php"),
            data: body,
            funcionExito: function(respuesta) {
                if (respuesta.valor == '0') {
                    swal(
                        "Registro exitoso",
                        "El usuario se registró correctamente. Para activar tu cuenta, utiliza el código de verificación enviado al correo.",
                        "success"
                    );
                    vaciarCampos(); 
                    mostrarLogin(); 
                   
                } else {
                    swal("Error", "Hubo un problema al registrar el usuario. Intente nuevamente.", "error");
                }
            },
            funcionError: function(e) {
                swal("Error", e.mensaje, "error");
            }
        });
    }

    function vaciarCampos() {
        document.getElementById("ci").value = '';
        document.getElementById("nombres").value = '';
        document.getElementById("apellidos").value = '';
        document.getElementById("email").value = '';
    }


    function enviarRecuperacion() {
        const email = document.getElementById('emailRecuperacion').value.trim();

        const emailRegex = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/;
        if (!emailRegex.test(email)) {
            swal("Correo electrónico inválido", "Por favor, ingresa un correo electrónico válido.", "warning");
            return;
        }

        const body = {
            funcion: "recuperarContrasena",
            email: email
        };

        Empresa.rest({
            verbo: 'POST',
            url: Empresa.armarUrl("api/usuario/funcionesUsuarios.php"),
            data: body,
            funcionExito: function(respuesta) { 
                $('#modalRecuperarContraseña').modal('hide');
                swal("Éxito", "Se ha enviado un correo de recuperación a su dirección.", "success");
               
            },
            funcionError: function(e) {
                swal("Error", e.mensaje, "error");
            }
        });
    }



    this.initializer();
</script>

</html>