<!DOCTYPE html>
<html>
<head>
    <?php
	include('includes/cabecera.inc');
	?>
</head>
<body class="skin-5 pace-done mini-navbar">
    <div id="wrapper">
		<?php
			include('includes/menu_izq.inc');
		?>
        <div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
					include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Inventario Productos </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title" >
								<div class="col-sm-2"  >
									<h5>Sucursal : <b id='nomSucursal'></b></h5>
								</div>
								<div class="col-sm-2" >
									<div id="mostrarsucursal" style="display:none;">
										<select class="form-control" id="selectSucursal" onchange="cargarInventarios();"></select>
									</div>
								</div>
								<div class="row form-group col-sm-8">	
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-12 col-md-12" >
						<div class="ibox float-e-margins" >
							<div class="ibox-title" >
							  <h5> Inventario <small class="m-l-sm" > (Productos)  </small></h5>
							  <div class="ibox-tools">
							  </div>
							</div>
						</div>
						<div class="ibox float-e-margins" style='margin-top:-15px;'>
							<div class="ibox-content">
							  <div id="contenedortablaprincipal" class="ibox ">
								<div id="toogle-columns"></div>
								<div class="ibox table-responsive" style="font-size:10px;">
									<table class="table table-striped table-bordered table-hover lisInventario">
									</table>
								</div>
							  </div>
							</div>
						</div>
					</div>
				</div>
				
			</div>
			<div class="footer">
				<?php
					include('includes/footer.inc');
				?>
			</div>
        </div>	
    </div>
    <?php
	include('includes/pie.inc');
	?>
	<script>
		var ids = "<?php echo $ids;?>";
		var idu = "<?php echo $idu;?>";
		var idr = "<?php echo $idr;?>";
		var aps = "<?php echo $aps;?>";
		var nom = "<?php echo $nom;?>";
		var rol = "<?php echo $rol;?>";
		var ico = "<?php echo $ico;?>";
		var emp = "<?php echo $emp;?>";
		var foto = "<?php echo $foto;?>";
		var logo = "<?php echo $logo;?>";
		var tc = "<?php echo $tc;?>";
		var nomSuc = "<?php echo $suc;?>";
		var sig = "<?php echo $sig;?>";
		var dir = "<?php echo $dir;?>";
		var telf = "<?php echo $telf;?>";
		var cel = "<?php echo $cel;?>";
		var loc = "<?php echo $loc;?>";
		var ciu = "<?php echo $ciu;?>";
		var lisInventario = [];
	
		function initializer() {
			cargarDatosWeb(); menuNotificaciones(); 
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom+' '+aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src="img/usuario/"+foto+"";
			document.getElementById('nomUser').innerHTML = nom+' '+aps;
			document.getElementById('rolUser').innerHTML = rol;
			selectSucursal(ids);
			if(idr == '2'){
				$('#mostrarsucursal').show();
			}
			headerInventario(); cargarInventarios();
		}
		
		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor){
		    Empresa.actualizarSelect({
			selector: "#selectSucursal",
			sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
			callback: function (data) {
				$("#selectSucursal").val(valor);
				$("#selectSucursal").select2();
			}
		   });
		   ids = valor;
		}
		
		// -------------------------- Controles Tabla Rol ---------------------------- //
		function headerInventario() {
			var columnsName = [{title: "#"},{title: "Imagen"},{title: "Codigo"},{title: "C.Barras"},{title: "Producto"},{title: "Marca"},{title: "Unidad Medida"},{title: "Stock"},{title: "Lote"}, {title: "F.Vencimiento"},{title: "Precio Compra"},{title: "Precio Venta"},{title: "Precio Especial"},{title: "Precio Mayor"},{title: "Precio Tope"},{title: "Minimo"}];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".lisInventario",
				data: lisInventario,
				columnas: columnsName
			});
		}

		function cargarInventarios() {
			Empresa.showSpinner();
			lisInventario = [];
			var idsucursal = document.getElementById("selectSucursal").value;
			if(idsucursal == ""){ idsucursal=ids;}
			var body = { funcion: "listarInventarios" , idsucursal: idsucursal};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					var inventarios = respuesta.items.data;					
					for (var i = 0; i < inventarios.length; i++) {
						lisInventario.push([
							i+1,
							crearImgDet(inventarios[i].imagen),
							inventarios[i].codigo,
							inventarios[i].codigo_barras,
							inventarios[i].nombre,
							inventarios[i].marca,
							inventarios[i].unidad,
							inventarios[i].stock,
							inventarios[i].lote,
							inventarios[i].fecha_vencimiento,
							inventarios[i].precio_compra,
							inventarios[i].precio_venta,
							inventarios[i].precio_especial,
							inventarios[i].precio_mayor,
							inventarios[i].precio_tope,
							inventarios[i].stock_minimo
						]);
					}
					
					Empresa.refrescarTablaDeDatos({
						selector: ".lisInventario",
						data: lisInventario
					});
				
					var datatable = $(".lisInventario").DataTable();
            
					datatable.rows().every(function (rowIdx, tableLoop, rowLoop) {
						var data = this.data();
						var stockActual = parseFloat(data[7]); 
						var stockMinimo = parseFloat(data[15]); 

						if (stockActual <= stockMinimo) {
							$(this.node()).css({
								'color': 'red',         
								'font-weight': 'bold'  
							});
						} else if (stockActual >= stockMinimo && stockActual <= stockMinimo + 5) {
							$(this.node()).css({
								'color': '#c8c653',     
								'font-weight': 'bold'  
							});
						} else if (stockActual > stockMinimo + 5) {
							$(this.node()).css({
								'color': 'green',       
								'font-weight': 'bold'   
							});
						}
					});
					Empresa.hideSpinner();
				},
				funcionError: function (e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}
		// -------------------------- Objeto para imgenes ---------------------------- //
		function crearImgDet(url,tam,lug) {
			var imgurl = "<img class='img-thumbnail' src='img/Producto/"+url+"'  width='70' id='imageModel' /> ";
			return imgurl;
		}
		
		
		this.initializer();		
	</script>
</body>
</html>