const Empresa = function () {

    return {
		nombreEmp: 'METAFAR',
        urlBase: 'https://farmaciaespecializadajyg.metasoft-bo.com/',
        spinner: false,
        dataimg: '',

        /**
			* funciones de spinner
        */
        showSpinner: function (div) {
            
			var spin = $('#'+div+''); 
			spin.hide(); spin.empty(); 
			var panelspin = '<div class="sk-spinner sk-spinner-three-bounce" id="spinoff"><br><br><br><br><br><br> <center><h5> Cargando Datos</h5></center><div class="sk-bounce1"></div><div class="sk-bounce2"></div><div class="sk-bounce3"></div></div>';
			spin.append(panelspin);
			spin.show();
            if (!this.spinner) {
                $('#'+div+'').children('.ibox-content').toggleClass('sk-loading');
                this.spinner = true;
            }
        },
        hideSpinner: function (div) {
			var spinoff = $('#spinoff'); 
			spinoff.hide();
            if (this.spinner) {
                $('#'+div+'').children('.ibox-content').toggleClass('sk-loading');
                this.spinner = false;
            }
        },
         /**
			* oculta el preloader
        */
        hidePreloader: function (div) {
            const preloader = document.getElementById('preloader');
            const divToShow = document.getElementById(div);
            preloader.style.display = 'none'; 
            divToShow.style.display = 'block'; 
        },
        /**
			* div para mostrar un tipo de color
        */
		createBadgeColor: function(color){
			var badge = "";		
			badge = " <span class='badge' style='background-color: "+color+" ; color:white; '> -- </span>";
			return badge;
		},
		/**
			* funciones para manejar fechas 
        */
		formatoImpuestos : function(string){
			var info = string.split('-');
			return info[2] + '/' + info[1] + '/' + info[0];
		},
		fechaActual: function() {
			var f = new Date(); var dia = f.getDate(); var mes = f.getMonth() + 1; var anio = f.getFullYear();
			var fechaActual = anio+"-"+mes+"-"+dia;
			return fechaActual;
		},
		mesActual: function() {
			var f = new Date(); var dia = f.getDate(); var mes = f.getMonth() + 1; var anio = f.getFullYear();
			if (mes.length < 2) mes = '0' + mes;
			return [anio, mes].join('-');
		},
		formatDate: function(date) {
			var d = new Date(date),
				month = '' + (d.getMonth() + 1),
				day = '' + d.getDate(),
				year = d.getFullYear();

			if (month.length < 2) month = '0' + month;
			if (day.length < 2) day = '0' + day;

			return [year, month, day].join('-');
		},		
		diasMes: function(anno , mes){
		    mes = parseInt(mes);
		    anno = parseInt(anno);
		    switch (mes) {
			  case 1 : case 3 : case 5 : case 7 : case 8 : case 10 : case 12 : return 31;
			  case 2 : return (anno % 4 == 0) ? 29 : 28;
		    }
		    return 30;
	    },
		primerDiaDia: function(anno,mes){
			var day ='01';
		    return [anno, mes, day].join('-');
	    },
		fechaLiteral: function() { 
			var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"); var f=new Date(); var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear(); 
			return fecha; 
		},
		agregarCero: function (i)
        {
        	if (i < 10) 
        	{
            	i = "0" + i;
	        }
	        return i;
        },
        cambiarFechas: function(dato,idIni,idFin)
		{
			var anio = parseInt(dato.split('-')[0]);
			var mes = parseInt(dato.split('-')[1]);
			
			var primerDia = new Date(anio, mes-1, 1).getDate();
			var ultimoDia = new Date(anio, mes, 0).getDate();
			$(idIni).val(anio + "-" + this.agregarCero(mes) + "-" + this.agregarCero(primerDia));
			$(idFin).val(anio + "-" + this.agregarCero(mes) + "-" + this.agregarCero(ultimoDia));
		},
		financial: function(x,pos) {
			return Number.parseFloat(x).toFixed(pos);
		},
        /**
			* funciones para armar la ruta de la consulta BD
        */
        armarUrl: function (rutaRelativa) {
            return this.urlBase + rutaRelativa;
        },
		/**
			* funciones para recuperar la respuesta
        */
        rest: function (setRest) {
            var vi = this;
            if (setRest.funcionError === undefined) {
                setRest.funcionError = function (error) {
                    console.log(error);
                 
                }
            }
            if (setRest.funcionExito === undefined) {
                setRest.funcionExito = function (data) {
                    console.info(data);
                }
            }
            $.ajax({
                type: setRest.verbo,
                url: setRest.url,
                data: JSON.stringify(setRest.data),
                contentType: 'application/json; charset=utf-8',
                dataType: 'json',
                success: setRest.funcionExito,
                error: function (error) {
                    var dataError;
                    if (error.responseJSON) dataError = error.responseJSON;
                    else if (error.responseText) {
                        dataError = {mensaje: error.responseText};
                    }
                    setRest.funcionError(dataError);
                }
            });
        },
		/**
         * funciones para subir imagenes
        */
        restImg: function (setRest) {
            var vi = this;
            if (setRest.funcionError === undefined) {
                setRest.funcionError = function (error) {
                    console.log(error);
                 
                }
            }
            if (setRest.funcionExito === undefined) {
                setRest.funcionExito = function (data) {
                    console.info(data);
                }
            }
			$.ajax({
				url: setRest.url,      
				type: setRest.verbo,            
				data: setRest.data, 			  
				contentType: false,       
				cache: false,             
				processData:false,        
				success: setRest.funcionExito,
                error: function (error) {
                    var dataError;
                    if (error.responseJSON) dataError = error.responseJSON;
                    else if (error.responseText) {
                        dataError = {mensaje: error.responseText};
                    }
                    setRest.funcionError(dataError);
                }
			});
        },
		/**
			* funciones para realizar la consulta a la BD
        */
        sqlQuery: function ( tipo, retornoPorDefecto, consultaSql, funcionExito, funcionError) {
            if (consultaSql) {
                this.rest({
                    verbo: "POST",
                    url: this.armarUrl("/api/sql/consulta.php"),
                    data: {
                        tipo: tipo,
                        sql: consultaSql
                    },
                    funcionExito: funcionExito,
                    funcionError: funcionError
                });
            } else {
                return retornoPorDefecto;
            }
        },
		/**
			* funcion para devolver una sola fila de la consulta bd01
        */
        sqlOne: function (sqlData) {
            this.sqlQuery("one", {}, sqlData.sql, sqlData.funcionExito, sqlData.funcionError);
        },
		/**
			* funcion para devolver todas las filas de la consulta bd01
        */
        sqlAll: function (sqlData) {
            this.sqlQuery("all", [], sqlData.sql, sqlData.funcionExito, sqlData.funcionError);
        },
		       
		/**        
			* funcion para devolver el tipo de error ocurrido
        */
        error: function (mensaje, callback) {
            alert(mensaje);
            if (callback) {
                callback();
            }
        },
		/**
			* funcion para recuperar checkbox tickeados segun su nombre de clase
        */
        recuperarCheckBox: function (nombreDeClase) {
            var resultado = [];
            $("." + nombreDeClase + ":checked").each(function () {
                resultado.push($(this).val());
            });
            return resultado;
        },
		getDataByIndex: function(listValues, index) {
			var result = [];
			for(var i=0; i < listValues.length; i++){
				var stringSplited = listValues[i].split(';');
				result.push(stringSplited[index]);
			}
			return result;
		},
         /**
			* funcion para imprimir un div
        */
        obtenerSeleccionados: function(selector) {
            var resultado = [];
            // Itera por las opciones seleccionadas dentro del select especificado
            $(selector + ' option:selected').each(function () {
                resultado.push($(this).val()); // Agrega el valor de cada opción seleccionada al array
            });
            return resultado; // Devuelve el array con los valores
        },
         /**
			* funcion para imprimir un div
        */
        impDiv: function (iDiv,url,cabeza,pie)
        {
            
            $(iDiv).printThis({
		        importCSS: true,
		        header: cabeza,
		        footer: pie,
		        importStyle: true,
		        removeScripts: false,
		        canvas: true,
		        copyTagClasses: true,
		        base: url
		    });
        },

        /**
			* arma los select solo con una opcion
        */
        actualizarSelect: function (configuracion) {
            var elementoSelect = $(configuracion.selector);
            elementoSelect.hide();
            elementoSelect.find('option').remove().end().append('<option value="">Seleccione una opcion</option>').val('');
            Empresa.sqlAll({
                sql: configuracion.sql,
                funcionExito: function (response) {
                    var i;
                    const data = response.data;
                    if (data) {
                        for (i in data) {
                            var optionDinamico = '<option value="' + data[i].id + '">' + data[i].etiqueta + '</option>';
                            elementoSelect.append(optionDinamico);
                        }
                        elementoSelect.show();
                    }
                    if (configuracion.callback) configuracion.callback(data);
                }
            });
        },
		 /**
			* arma los select solo con varias opciones
        */
		multiSelect: function (configuracion) {
            var elementoSelect = $(configuracion.selector);
            elementoSelect.hide();
            elementoSelect.find('option').remove().end().append('').val('');
            Empresa.sqlAll({
                sql: configuracion.sql,
                funcionExito: function (response) {
                    var i;
                    const data = response.data;
                    if (data) {
                        for (i in data) {
                            var optionDinamico = '<option value="' + data[i].id + '">' + data[i].etiqueta + '</option>';
                            elementoSelect.append(optionDinamico);
                        }
                        elementoSelect.show();
                    }
                    if (configuracion.callback) configuracion.callback(data);
                }
            });
        }, 
		        
		/**
			* opciones para dar formato a los numeros 
        */     
		roundNumber: function(num, scale) {
			if(!("" + num).includes("e")) {
				return +(Math.round(num + "e+" + scale)  + "e-" + scale);
			} else {
				var arr = ("" + num).split("e");
				var sig = ""
				if(+arr[1] + scale > 0) {
				  sig = "+";
				}
				return +(Math.round(+arr[0] + "e" + sig + (+arr[1] + scale)) + "e-" + scale);
			}
		},
		dar_formato : function(num){
			var cadena = ""; var aux;
			var cont = 1,m,k;
			if(num<0) aux=1; else aux=0;
			num=num.toString();
			for(m=num.length-1; m>=0; m--){
				cadena = num.charAt(m) + cadena;
				if(cont%3 == 0 && m >aux)  cadena = "." + cadena; else cadena = cadena;
				if(cont== 3) cont = 1; else cont++;
			}
			cadena = cadena.replace(/.,/,',');
			return cadena;

		},
		number_format: function number_format(number, decimals, dec_point, thousands_point) {

			if (number == null || !isFinite(number)) {
				throw new TypeError("number is not valid");
			}

			if (!decimals) {
				var len = number.toString().split('.').length;
				decimals = len > 1 ? len : 0;
			}

			if (!dec_point) {
				dec_point = '.';
			}

			if (!thousands_point) {
				thousands_point = ',';
			}

			number = parseFloat(number).toFixed(decimals);

			number = number.replace(".", dec_point);

			var splitNum = number.split(dec_point);
			splitNum[0] = splitNum[0].replace(/\B(?=(\d{3})+(?!\d))/g, thousands_point);
			number = splitNum.join(dec_point);

			return number;
		},
		/**
			* opciones para crear las diferentes notificaciones
        */
		notificationSuccess: function(message) {
            if(message) {
                $(document).ready(function() {
                    setTimeout(function() {
                        toastr.options = {
                            closeButton: true,
                            progressBar: true,
                            showMethod: 'slideDown',
                            timeOut: 4000
                        };
                        toastr.success('Notificacion Sistema', message);
                    }, 100);
                });
            }
        },
        notificationInfo: function(message) {
            if(message) {
                $(document).ready(function() {
                    setTimeout(function() {
                        toastr.options = {
                            closeButton: true,
                            progressBar: true,
                            showMethod: 'slideDown',
                            timeOut: 4000
                        };
                        toastr.info('Notificacion Sistema', message);
                    }, 100);
                });
            }
        },
		notificationWarning: function(message) {
            if(message) {
                $(document).ready(function() {
                    setTimeout(function() {
                        toastr.options = {
                            closeButton: true,
                            progressBar: true,
                            showMethod: 'slideDown',
                            timeOut: 4000
                        };
                        toastr.warning('Notificacion Sistema', message);
                    }, 100);
                });
            }
        },
        notificationError: function(message) {
            if(message) {
                $(document).ready(function() {
                    setTimeout(function() {
                        toastr.options = {
                            closeButton: true,
                            progressBar: true,
                            showMethod: 'slideDown',
                            timeOut: 4000
                        };
                        toastr.error('Notificacion Sistema', message);
                    }, 100);
                });
            }
        },
		/**
			* herramientas para validar formularios
        */
		validarEmail: function (valor) {
		  if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor)){
		   var res = true;
		  } else {
		   var res = false;
		  }
		  return res;
		},
		validarPassword: function (pwd,pwd1) {
		  if (pwd != "" && pwd1 == pwd ){
			var res = true;
		  } else {
			var res = false;
		  }
		  return res;
		},
		/**
			* herramientas para habilitar y deshabilitar campos de un formulario
        */
		habilitarCampos: function (campo) {
			elementos=document.getElementsByClassName(campo);
			for(var i = 0; i < elementos.length; i++)
			{
				elementos[i].disabled = false;
			}
		},
		deshabilitarCampos: function (campo) {
			elementos=document.getElementsByClassName(campo);
			for(var i = 0; i < elementos.length; i++)
			{
				elementos[i].disabled = true;
			}
		},
		/**
			* herramientas para crear un objeto de imagen | id: id de tabla, url: nombre archivo, tam: tamaño imagen, lug: carpeta donde se aloja
        */
		crearImagenEdit: function(id,url,tam,lug) {
			var imgurl = "<a onclick='editImage"+lug+"(\"" + id + "\",\"" + url + "\")' ><img class='img-thumbnail' src='img/"+lug+"/"+url+"'  width='"+tam+"' id='image' /> </a>";
			return imgurl;
		},
		/**
			* Funcion para crear un checkbox 
        */
		crearCheckBox: function(identificador, valor) {
			return "<div class='checkbox checkbox-success'><input id='chk' class='form-check-input " + identificador + "' type='checkbox' value='" + valor + "'><label for='chk'></label></div>";
		},				
		/**
			* herramientas para crear un objeto de imagen | id: id de tabla, url: nombre archivo, tam: tamaño imagen, lug: carpeta donde se aloja
        */
		createButtonEstado: function(id,estado,tabla,campo){
			var btns = "";	var estado = estado.charAt(0); $("#updid").val(id);
			if(estado=='A'){
				btns = "<button class='btn btn-primary btn-xs' style='font-size:8px'  title='Cambiar Estado' onclick='cambiarEstado"+tabla+"(\"" + id + "\",\"" + estado + "\",\"" + campo + "\")'>"+estado+"</button>";
			}else{
				btns = "<button class='btn btn-danger btn-xs' style='font-size:8px'  title='Cambiar Estado' onclick='cambiarEstado"+tabla+"(\"" + id + "\",\"" + estado + "\",\"" + campo + "\")'>"+estado+"</button>";
			}
			
			return btns;
		},
		/**
			* herramientas para crear un objeto de imagen | id: id de tabla, url: nombre archivo, tam: tamaño imagen, lug: carpeta donde se aloja
        */
		createButtonArchivo: function(id,archivo,tabla,campo){
			var imgurl = "<a class='btn btn-warning btn-xs' style='font-size:8px'  title='Subir Archivo'onclick='editArchivo"+tabla+"(\"" + id + "\",\"" + archivo + "\")' ><i class='fa fa-upload'></i> </a>";
			return imgurl;
		},
		/**
			* herramientas para crear boton editar | id: id de tabla, tabla  de la cual se hace el llamado
        */
        createButtonsEdit: function(id,tabla){
            var btns = "";		
            btns = " <button class='btn btn-info btn-xs' style='font-size:8px'  title='Editar' onclick='modalEdit"+tabla+"(\"" + id + "\")'><i class='fa fa-edit'></i></button>";
            return btns;
        },
        /**
            * herramientas para crear boton Eliminar | id: id de tabla, tabla  de la cual se hace el llamado
        */
        createButtonDelete: function(id,tabla){
            var btns = "";		
            btns = " <button class='btn btn-danger btn-xs' style='font-size:8px'  title='Eliminar Item' onclick='deleteItem"+tabla+"(\"" + id+ "\")'><i class='fa fa-close'></i></button>";
            return btns;
        },
		/**
			* herramientas para crear boton editar | id: id de tabla, tabla  de la cual se hace el llamado
        */
		createButtons: function(id,tabla){
			var btns = "";		
			btns = " <button class='btn btn-success btn-xs' style='font-size:8px'  title='Nueva "+tabla+"' onclick='modalNew"+tabla+"(\"" + id + "\")'><i class='fa fa-plus'></i> </button> <button class='btn btn-info btn-xs' style='font-size:8px'  title='Editar' onclick='modalEdit"+tabla+"(\"" + id + "\")'><i class='fa fa-edit'></i></button>";
			return btns;
		},
        /**
			* herramientas para crear boton contenido | id: id de tabla, tabla  de la cual se hace el llamado
        */
        createEditContenido: function(id,tabla){
			var btns = "";		
			btns = "<button class='btn btn-warning btn-xs' style='font-size:8px'  title='Editar Contenido' onclick='modalEditCont"+tabla+"(\"" + id + "\")'><i class='fa fa-file-text-o'></i></button>";
			return btns;
		},
        /**
			* herramientas para crear boton contenido | id: id de tabla, tabla  de la cual se hace el llamado
        */
        createModalImg: function(id,tabla){
            var btns = "";		
            btns = "<button class='btn btn-primary btn-xs' style='font-size:8px'  title='Imagenes Producto' onclick='modalDatos"+tabla+"(\"" + id + "\")'><i class='fa fa-file-image-o'></i></button>";
            return btns;
        },
		
		/**
			* herramientas para crear un div de datos | datos : arreglo de datos a mostrar, tabla  de la cual se hace el llamado
        */
		createDivDatos: function(datos,tabla){
			var datos = datos.data;
			var divDatos = "";
			for (var i = 0; i < datos.length; i++) {
				divDatos += "<p style='margin:3px; line-height:10px; text-align:left;'><a class='text-navy' title='Eliminar' onclick='delete"+tabla+"(\"" + datos[i].id + "\")' >"+datos[i].item+"</a></p>";
			}
			return divDatos;
		},
		/**
			* Funcion para mostrar u ocultar un div
        */
		mostrarOcultarDiv: function(div) {
			var x = document.getElementById(div);
			if (x.style.display === "none") {
				x.style.display = "block";
			} else {
				x.style.display = "none";
			}
		},
		/**
			* Funcion para mostrar u ocultar un div
        */
		PopupCenter: function(pageURL, title,w,h) {
			var left = (screen.width/2)-(w/2);
			var top = (screen.height/2)-(h/2);
			var targetWin = window.open (pageURL, title, 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, copyhistory=no, width='+w+', height='+h+', top='+top+', left='+left);
		},
		/**
			* herramientas para crear un objeto de Video |  url: nombre archivo, tam: tamaño video
        */
		crearVistaVideo: function(url,tam) {
			var videourl = "<center><figure><iframe src='http://www.youtube.com/embed/"+url+"' frameborder='0' allowfullscreen='' data-aspectratio='0.8211764705882353' style='width:"+tam+"px; height: "+tam+"px; ' > </iframe> </figure> </center>";
			return videourl;
		},
		/**
			* herramientas para gestion de tablas sin formato 
        */
        inicializarTablaSinFormato: function (configuracion) {
            var tableDynamic = $(configuracion.selector).DataTable({
                destroy: true,
                autoWidth: false,
                retrieve: true,
                data: configuracion.data,
                columns: configuracion.columnas,
                responsive: true,
                searching: false,
				paging:   false,
				ordering: false,
				info:     false
            });
        },
        inicializarTablaNormal: function (configuracion) {
            var tableDynamic = $(configuracion.selector).DataTable({
                fixedHeader: true ,
				scrollY: '300px',
				scrollX: false,
                destroy: true,
                paging: true,
                retrieve: true,
                data: configuracion.data,
                columns: configuracion.columnas,
                lengthMenu: [[100, 200, 500, 1000, 2000, 5000, -1], [100, 200, 500, 1000, 2000, 5000, "Todo"]],
                pageLength: 100,
                responsive: true,
                searching: true
            });
        },
		/**
			* herramientas para gestion de tablas con formato 
        */
		inicializarTablaformato: function (configuracion) {
            var tableDynamic = $(configuracion.selector).DataTable({
                destroy: true, 
                retrieve: true,
                autoWidth: false,
				columnDefs: [ {
					visible : false,
					targets: '-1'
				} ],
                data: configuracion.data,
                responsive: true,
                searching: false,
				paging:   false,
				ordering: false,
				info:     false
            });
        },
        /**
			* herramientas para gestion de tablas sin formato 
        */
        inicializarTablaPrint: function (configuracion) {
            var tableDynamic = $(configuracion.selector).DataTable({
                paging: true,
                retrieve: true,
                autoWidth: false,
                data: configuracion.data,
                columns: configuracion.columnas,
                responsive: true,
                searching: false,
                paging:   false,
                ordering: false,
                info:     false
            });
        },
		inicializarTablaDeDatos: function (configuracion) {
            var IMAGE_EMPRESA = this.dataimg;
            var tableDynamic = $(configuracion.selector).DataTable({
                fixedHeader: true ,
				scrollY: '400px',
				scrollX: false,
                destroy: true,
                paging: true,
                retrieve: true,
                data: configuracion.data,
                columns: configuracion.columnas,
                lengthMenu: [[10, 25, 50, 100, 200, 500, -1], [10, 25, 50, 100, 200, 500, "Todo"]],
                pageLength: 50,
                responsive: true,
                searching: true,
                dom: '<"html5buttons"B>lTfgitp',
                buttons: [
                    {
                        extend: 'excel',
                        footer: true,
                        exportOptions: {
                            stripHtml: false,
                            columns: configuracion.columnsToShow
                        },
                        text: '<i class="fa fa-file-excel-o"></i> <E>Excel</E>',
                        message: configuracion.headerTitlePrint
                    },
                    {
                        extend: 'print',
                        footer: false,
                        title: '',
                        exportOptions: {
                            stripHtml: false,
                            columns: ':visible',
                        },
                        text: '<i class="fa fa-print"></i> Imprimir',
                        message: function () {
                            return `
                                <div class="col-md-12" style="background:white;">
                                <div class="col-xs-6">
                                    <img src=${IMAGE_EMPRESA} width="160" height="80" style="border-radius: 10%;">
                                </div>
                                <div class="col-xs-6">
                                    <p style="float: center; font-weight: bold">Fecha de Impresion: ${new Date().toDateString()}</p>
                                </div>
                                </div>`

                        }
                    }
                ],
            });
            $('configuracion.selector td').css('white-space','initial');
            $('a.toggle-vis').on( 'click', function (e) {
                e.preventDefault();

                // Get the column API object
                var column = tableDynamic.column( $(this).attr('data-column') );

                // Toggle the visibility
                column.visible( ! column.visible() );
            });
        },
		/**
			* herramientas para el manejo de columnas
        */
		createToogleColumns: function (arrayNameOfColumns) {
			var tagLink = '';
			for(var i = 0; i < arrayNameOfColumns.length; i++) {
				var nameColumn = arrayNameOfColumns[i].title;
				if(i === arrayNameOfColumns.length) {
					tagLink += '<li><a class="toggle-vis btn btn-primary column-visible" data-column="'+i+'"><i class="fa fa-tag"></i>' +nameColumn+ '</a>';
				} else {
					tagLink += '<a class="toggle-vis btn btn-primary btn-xs column-visible" data-column="'+i+'"><i class="fa fa-tag"></i>' +nameColumn+ '</a>';
				}
			}
			return tagLink;
		},
		/**
			* herramientas para recrgar una tabla
        */
		refrescarTablaDeDatos: function (configuracion) {
            var datatable = $(configuracion.selector).DataTable();
            datatable.clear();
            datatable.rows.add(configuracion.data);
            datatable.draw(false); // evita redibujar estructura
        }
    }
}();
