var temp = null;

function confirmarCierre() {
    var cerrar = setTimeout(salirSistema, 20000); // 20 segundos para confirmar

    swal({
        title: "Cierre de Sesión",
        text: "Su sesión expirará en 20 segundos. ¿Desea prolongarla 10 minutos?",
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: "btn-success",
        cancelButtonClass: "btn-danger",
        confirmButtonText: "Prolongar",
        cancelButtonText: "Cerrar Sesión",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm) {
        if (isConfirm) {
            clearTimeout(cerrar);
            clearTimeout(temp);
            swal({
                title: "Sesión Prolongada",
                text: "Tu sesión fue extendida por 10 minutos.",
                type: "success",
                timer: 3000,
                showConfirmButton: false
            });
            bindEvents(600000); // 10 minutos
        } else {
            swal.close();
            salirSistema();
            $(document).off();
        }
    });
}

function bindEvents(milisegundos) {
    temp = setTimeout(confirmarCierre, milisegundos);

    $(document).on('click keyup keypress keydown blur change', function (e) {
        clearTimeout(temp);
        temp = setTimeout(confirmarCierre, milisegundos);
        console.log('Actividad detectada');
    });
}

window.onload = function () {
    bindEvents(600000); 
};