<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
	<style>
		.select2-dropdown {
			z-index: 9001;
		}
	</style>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Perfil Empresa </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5>Sucursal : <b id='nomSucursal'></b></h5>
								<div class="ibox-tools">
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active "><a id="tabroles" href="#tab-1" onclick="cargarRoles()"><label class="text-navy"> <i class="fa fa-tag"></i> Listado Roles </a></label></li>
									<li><a id="tabmodulo" href="#tab-2" onclick="cargarModulos();"><label class="text-navy"><i class="fa fa-tag"></i> Listado Modulos</a></label></li>
									<li><a id="tabformulario" href="#tab-3" onclick="cargarFormularios();"><label class="text-navy"> <i class="fa fa-tag"></i> Listado Formularios</a></label></li>
									<li><a id="tabasigform" href="#tab-4" onclick="cargarFormModulo();"><label class="text-navy"> <i class="fa fa-tag"></i> Asignar Formulario/Modulo </a></label></li>
									<li><a id="tabasigmod" href="#tab-5" onclick="cargarModRol();"><label class="text-navy"> <i class="fa fa-tag"></i> Asignar Modul/Rol </a></label></li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active" style="font-size:11px;">
										<div class="ibox-title">
											<h5> Listado <small class="m-l-sm"> (Roles) </small></h5>
											<div class="ibox-tools">
												<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#newRol" title="Nuevo Rol">
													<i class="fa fa-plus" aria-hidden="true"></i>
												</button>
											</div>
										</div>
										<div class="ibox-content">
											<div id="contenedortablaprincipal" class="ibox ">
												<div id="toogle-columns"></div>
												<div class="ibox table-responsive" style="font-size:10px;  ">
													<table class="table table-striped table-bordered table-hover lisRol" style="font-size:10px;">
													</table>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-title">
											<h5> Listado <small class="m-l-sm"> (Modulos) </small></h5>
											<div class="ibox-tools">
												<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#newModulo" title="Nuevo Modulo">
													<i class="fa fa-plus" aria-hidden="true"></i>
												</button>
											</div>
										</div>
										<div class="ibox-content">
											<div id="contenedortablaprincipal" class="ibox ">
												<div id="toogle-columns1"></div>
												<div class="ibox table-responsive" style="font-size:10px;   ">
													<table class="table table-striped table-bordered table-hover lisMod" style="font-size:10px;">
													</table>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-3" class="tab-pane" style="font-size:11px;">
										<div class="ibox-title">
											<h5> Listado <small class="m-l-sm"> (Formularios) </small></h5>
											<div class="ibox-tools">
												<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#newForm" title="Nuevo Formulario">
													<i class="fa fa-plus" aria-hidden="true"></i>
												</button>
											</div>
										</div>
										<div class="ibox-content">
											<div id="contenedortablaprincipal" class="ibox ">
												<div id="toogle-columns2"></div>
												<div class="ibox table-responsive" style="font-size:10px;  ">
													<table class="table table-striped table-bordered table-hover lisForm" style="font-size:10px;">
													</table>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-4" class="tab-pane" style="font-size:11px;">
										<div class="ibox-title">
											<h5> Asignar <small class="m-l-sm"> (Formulario - Modulo) </small></h5>
											<div class="ibox-tools">
												<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#asigForMod" title="Nueva Asignacion">
													<i class="fa fa-plus" aria-hidden="true"></i>
												</button>
											</div>
										</div>
										<div class="ibox-content">
											<div id="contenedortablaprincipal" class="ibox ">
												<div id="toogle-columns3"></div>
												<div class="ibox table-responsive" style="font-size:10px;   ">
													<table class="table table-striped table-bordered table-hover asigForMod" style="font-size:10px;">
													</table>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-5" class="tab-pane" style="font-size:11px;">
										<div class="ibox-title">
											<h5> Asignar <small class="m-l-sm"> (Modulo - Rol) </small></h5>
											<div class="ibox-tools">
												<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#asigModRol" title="Nueva Asignacion">
													<i class="fa fa-plus" aria-hidden="true"></i>
												</button>
											</div>
										</div>
										<div class="ibox-content">
											<div id="contenedortablaprincipal" class="ibox ">
												<div id="toogle-columns4"></div>
												<div class="ibox table-responsive" style="font-size:10px;  ">
													<table class="table table-striped table-bordered table-hover asigModRol" style="font-size:10px;">
													</table>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newRol" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Rol</h4>
							<small>Registro de roles del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Rol:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="rol" class="form-control col-md-7 col-xs-12">
									</div>
								</div>

								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Descripcion:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<textarea id="descripcion" class="form-control col-md-7 col-xs-12"></textarea>
									</div>
								</div>

								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newRol();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updRol" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Editar Rol</h4>
							<small>Editar roles del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> rol:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="hidden" id="updid" class="form-control col-md-7 col-xs-12">
										<input type="text" id="updrol" class="form-control col-md-7 col-xs-12">
									</div>
								</div>

								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Descripcion:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<textarea id="upddescripcion" class="form-control col-md-7 col-xs-12"></textarea>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="updRol();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newModulo" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Modulo</h4>
							<small>Registro de modulos del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Modulo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="modulo" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Icono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="icono" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Descripcion:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<textarea id="descripcionM" class="form-control col-md-7 col-xs-12"></textarea>
									</div>
								</div>

								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newModulo();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<div class="modal inmodal" id="updModulo" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Editar Modulo</h4>
							<small>Editar modulos del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Modulo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="hidden" id="updidM" class="form-control col-md-7 col-xs-12">
										<input type="text" id="updmodulo" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Icono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updicono" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Descripcion:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<textarea id="upddescripcionM" class="form-control col-md-7 col-xs-12"></textarea>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="updModulo();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newForm" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Formulario</h4>
							<small>Registro de formularios del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Formulario:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="formulario" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Ruta:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="ruta" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Descripcion:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<textarea id="descripcionF" class="form-control col-md-7 col-xs-12"></textarea>
									</div>
								</div>

								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newFormulario();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updForm" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Editar Formulario</h4>
							<small>Editar formularios del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Formulario:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="hidden" id="updidF" class="form-control col-md-7 col-xs-12">
										<input type="text" id="updformulario" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Ruta:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updruta" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Descripcion:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<textarea id="upddescripcionF" class="form-control col-md-7 col-xs-12"></textarea>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="updFormulario();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="asigForMod" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-check"></i> Asignar Formulario-Modulo </h4>
							<small>Asigna un formulario a un Modulo del Sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Modulo :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="select2_demo_1 form-control" id="selectModulo" style="width: 100%;" required></select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Formulario:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="select2_demo_2 form-control" id="selectFormulario" style="width: 100%;" required></select>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newFormMod();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Ingresar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="asigModRol" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-check"></i> Asignar Modulo-Rol </h4>
							<small>Asigna un Modulo a un Rol del Sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Rol :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="select2_demo_3 form-control" id="selectRol" style="width: 100%;" required></select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Modulo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="select2_demo_4 form-control" id="selectModulo1" style="width: 100%;" required></select>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newModRol();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Ingresar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisRol = [];
		var lisMod = [];
		var lisForm = [];
		var asigForMod = [];
		var asigModRol = [];

		function initializer() {
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			cargarDatosWeb();
			selectModulo();
			selectFormulario();
			selectRol();
			selectModulo1();
			headerRoles();
			cargarRoles();
			headerModulos();
			headerFormularios();
			headerFormModulo();
			headerModRol();
		}
		// -------------------------- Cargar Selects ---------------------------- //
		function selectModulo() {
			Empresa.actualizarSelect({
				selector: "#selectModulo",
				sql: "select id_modulo as id, concat(modulo) as etiqueta from modulo",
				callback: function(data) {
					$(".select2_demo_1").select2();
				}
			});
		}

		function selectFormulario() {
			Empresa.actualizarSelect({
				selector: "#selectFormulario",
				sql: "select id_form as id, concat(formulario) as etiqueta from formulario",
				callback: function(data) {
					$(".select2_demo_2").select2();
				}
			});
		}

		function selectRol() {
			Empresa.actualizarSelect({
				selector: "#selectRol",
				sql: "select id_rol as id, concat(rol) as etiqueta from rol",
				callback: function(data) {
					$(".select2_demo_3").select2();
				}
			});
		}

		function selectModulo1() {
			Empresa.actualizarSelect({
				selector: "#selectModulo1",
				sql: "select id_modulo as id, concat(modulo) as etiqueta from modulo",
				callback: function(data) {
					$(".select2_demo_4").select2();
				}
			});
		}
		// -------------------------- Controles Tabla Rol ---------------------------- //
		function headerRoles() {
			var columnsName = [{
					title: "#"
				},
				{
					title: " Rol"
				},
				{
					title: " Descripcion"
				},
				{
					title: ""
				}
			];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".lisRol",
				data: lisRol,
				columnas: columnsName
			});
		}

		function cargarRoles() {
			$('#tabroles').tab('show');
			Empresa.showSpinner();
			lisRol = [];
			var body = {
				funcion: "listarRol"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					var roles = respuesta.roles.data;
					for (var i = 0; i < roles.length; i++) {
						lisRol.push([
							i + 1,
							roles[i].ROL,
							roles[i].DESCRIPCION,
							createButtonsEdit(roles[i].ID_ROL, "Rol")
						]);
					}

					Empresa.refrescarTablaDeDatos({
						selector: ".lisRol",
						data: lisRol
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function newRol() {
			Empresa.showSpinner();
			var rol = document.getElementById("rol").value;
			var descripcion = document.getElementById("descripcion").value;
			var funcion = "newRol";
			var body = {
				funcion: funcion,
				rol: rol,
				descripcion: descripcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newRol").modal("hide");
					$('#rol').val('');
					$('#descripcion').val('');
					cargarRoles();
					selectRol();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditRol(id) {
			Empresa.showSpinner();
			var funcion = "editRol";
			var body = {
				funcion: funcion,
				idrol: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					var rol = respuesta.rol;
					Empresa.hideSpinner();
					$("#updRol").modal("show");
					$("#updid").val(rol.ID_ROL);
					$("#updrol").val(rol.ROL);
					$("#upddescripcion").val(rol.DESCRIPCION);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updRol() {
			Empresa.showSpinner();
			var idrol = document.getElementById("updid").value;
			var rol = document.getElementById("updrol").value;
			var descripcion = document.getElementById("upddescripcion").value;
			var funcion = "updRol";
			var body = {
				funcion: funcion,
				rol: rol,
				descripcion: descripcion,
				idrol: idrol
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updRol").modal("hide");
					$('#updid').val('');
					$('#updrol').val('');
					$('#upddescripcion').val('');
					cargarRoles();
					selectRol();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se Actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}
		// -------------------------- Controles Tabla Modulo ---------------------------- //
		function headerModulos() {
			var columnsName = [{
					title: "#"
				},
				{
					title: " Icono"
				},
				{
					title: " Modulo"
				},
				{
					title: " Descripcion"
				},
				{
					title: ""
				}
			];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns1").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".lisMod",
				data: lisMod,
				columnas: columnsName
			});
		}

		function cargarModulos() {
			$('#tabmodulo').tab('show');
			Empresa.showSpinner();
			lisMod = [];
			var body = {
				funcion: "listarModulo"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					var modulos = respuesta.modulos.data;
					for (var i = 0; i < modulos.length; i++) {
						lisMod.push([
							i + 1,
							modulos[i].ICONO,
							modulos[i].MODULO,
							modulos[i].DESCRIPCION,
							createButtonsEdit(modulos[i].ID_MODULO, "Modulo")
						]);
					}

					Empresa.refrescarTablaDeDatos({
						selector: ".lisMod",
						data: lisMod
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function newModulo() {
			Empresa.showSpinner();
			var modulo = document.getElementById("modulo").value;
			var icono = document.getElementById("icono").value;
			var descripcion = document.getElementById("descripcionM").value;
			var funcion = "newModulo";
			var body = {
				funcion: funcion,
				modulo: modulo,
				icono: icono,
				descripcion: descripcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newModulo").modal("hide");
					$('#modulo').val('');
					$('#icono').val('');
					$('#descripcionM').val('');
					cargarModulos();
					selectModulo();
					selectModulo1();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditModulo(id) {
			Empresa.showSpinner();
			var funcion = "editModulo";
			var body = {
				funcion: funcion,
				idmodulo: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					var modulo = respuesta.modulo;
					Empresa.hideSpinner();
					$("#updModulo").modal("show");
					$("#updidM").val(modulo.ID_MODULO);
					$("#updmodulo").val(modulo.MODULO);
					$("#updicono").val(modulo.ICONO);
					$("#upddescripcionM").val(modulo.DESCRIPCION);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updModulo() {
			Empresa.showSpinner();
			var idmodulo = document.getElementById("updidM").value;
			var modulo = document.getElementById("updmodulo").value;
			var icono = document.getElementById("updicono").value;
			var descripcion = document.getElementById("upddescripcionM").value;
			var funcion = "updModulo";
			var body = {
				funcion: funcion,
				modulo: modulo,
				icono: icono,
				descripcion: descripcion,
				idmodulo: idmodulo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updModulo").modal("hide");
					$('#updidM').val('');
					$('#updmodulo').val('');
					$('#updicono').val('');
					$('#upddescripcionM').val('');
					cargarModulos();
					selectModulo();
					selectModulo1()
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se Actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}
		// -------------------------- Controles Tabla Formulario ---------------------------- //
		function headerFormularios() {
			var columnsName = [{
					title: "#"
				},
				{
					title: " Formulario"
				},
				{
					title: " Descripcion"
				},
				{
					title: " Ruta"
				},
				{
					title: ""
				}
			];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns2").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".lisForm",
				data: lisForm,
				columnas: columnsName
			});
		}

		function cargarFormularios() {
			$('#tabformulario').tab('show');
			Empresa.showSpinner();
			lisForm = [];
			var body = {
				funcion: "listarFormulario"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					var formularios = respuesta.formularios.data;
					for (var i = 0; i < formularios.length; i++) {
						lisForm.push([
							i + 1,
							formularios[i].FORMULARIO,
							formularios[i].DESCRIPCION,
							formularios[i].RUTA,
							createButtonsEdit(formularios[i].ID_FORM, "Formulario")
						]);
					}

					Empresa.refrescarTablaDeDatos({
						selector: ".lisForm",
						data: lisForm
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function newFormulario() {
			Empresa.showSpinner();
			var formulario = document.getElementById("formulario").value;
			var ruta = document.getElementById("ruta").value;
			var descripcion = document.getElementById("descripcionF").value;
			var funcion = "newFormulario";
			var body = {
				funcion: funcion,
				formulario: formulario,
				ruta: ruta,
				descripcion: descripcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newForm").modal("hide");
					$('#formulario').val('');
					$('#ruta').val('');
					$('#descripcionF').val('');
					cargarFormularios();
					selectFormulario();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function modalEditFormulario(id) {
			Empresa.showSpinner();
			var funcion = "editFormulario";
			var body = {
				funcion: funcion,
				idformulario: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					var formulario = respuesta.formulario;
					Empresa.hideSpinner();
					$("#updForm").modal("show");
					$("#updidF").val(formulario.ID_FORM);
					$("#updformulario").val(formulario.FORMULARIO);
					$("#updruta").val(formulario.RUTA);
					$("#upddescripcionF").val(formulario.DESCRIPCION);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updFormulario() {
			Empresa.showSpinner();
			var idformulario = document.getElementById("updidF").value;
			var formulario = document.getElementById("updformulario").value;
			var ruta = document.getElementById("updruta").value;
			var descripcion = document.getElementById("upddescripcionF").value;
			var funcion = "updFormulario";
			var body = {
				funcion: funcion,
				formulario: formulario,
				ruta: ruta,
				descripcion: descripcion,
				idformulario: idformulario
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updForm").modal("hide");
					$('#updidF').val('');
					$('#updformulario').val('');
					$('#updruta').val('');
					$('#upddescripcionF').val('');
					cargarFormularios();
					selectFormulario();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se Actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}
		// -------------------------- Controles Tabla Formulario-Modulo  ---------------------------- //
		function headerFormModulo() {
			var columnsName = [{
					title: "#"
				},
				{
					title: " Modulo"
				},
				{
					title: " Formularios"
				}
			];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns3").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".asigForMod",
				data: asigForMod,
				columnas: columnsName
			});
		}

		function cargarFormModulo() {
			$('#tabasigform').tab('show');
			Empresa.showSpinner();
			asigForMod = [];
			var body = {
				funcion: "listarFormMod"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					var formModulos = respuesta.formModulos;
					for (var i = 0; i < formModulos.length; i++) {
						asigForMod.push([
							i + 1,
							formModulos[i].modulo,
							createDivDatos(formModulos[i].datos, "FormMod")
						]);
					}
					Empresa.refrescarTablaDeDatos({
						selector: ".asigForMod",
						data: asigForMod
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function newFormMod() {
			Empresa.showSpinner();
			var formulario = document.getElementById("selectFormulario").value;
			var modulo = document.getElementById("selectModulo").value;
			var funcion = "newFormMod";
			var body = {
				funcion: funcion,
				formulario: formulario,
				modulo: modulo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#asigForMod").modal("hide");
					cargarFormModulo();
					selectFormulario();
					selectModulo();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function deleteFormMod(id) {
			swal({
					title: "Eliminar Item",
					text: "Desea eliminar este Item",
					type: "warning",
					showCancelButton: true,
					confirmButtonClass: "btn-danger",
					confirmButtonText: "Eliminar",
					cancelButtonText: "Cancelar",
					closeOnConfirm: false,
					closeOnCancel: false
				},
				function(isConfirm) {
					if (isConfirm) {
						swal.close();
						var funcion = "deleteFormMod";
						var body = {
							funcion: funcion,
							id: id
						};
						Empresa.rest({
							verbo: 'POST',
							url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
							data: body,
							funcionExito: function(respuesta) {
								Empresa.notificationSuccess("Se elimino correctamente el registro.");
							}
						});
					} else {
						swal.close();
					}
				});
		}
		// -------------------------- Controles Tabla Nodulo Rol  ---------------------------- //
		function headerModRol() {
			var columnsName = [{
					title: "#"
				},
				{
					title: " Rol"
				},
				{
					title: " Modulos"
				}
			];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns4").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".asigModRol",
				data: asigModRol,
				columnas: columnsName
			});
		}

		function cargarModRol() {
			$('#tabasigmod').tab('show');
			Empresa.showSpinner();
			asigModRol = [];
			var body = {
				funcion: "listarModRol"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					var modRoles = respuesta.modRoles;
					for (var i = 0; i < modRoles.length; i++) {
						asigModRol.push([
							i + 1,
							modRoles[i].rol,
							createDivDatos(modRoles[i].datos, "ModRol")
						]);
					}
					Empresa.refrescarTablaDeDatos({
						selector: ".asigModRol",
						data: asigModRol
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function newModRol() {
			Empresa.showSpinner();
			var rol = document.getElementById("selectRol").value;
			var modulo = document.getElementById("selectModulo1").value;
			var funcion = "newModRol";
			var body = {
				funcion: funcion,
				rol: rol,
				modulo: modulo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#asigModRol").modal("hide");
					cargarModRol();
					selectRol();
					selectModulo1();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function deleteModRol(id) {
			swal({
					title: "Eliminar Item",
					text: "Desea eliminar este Item",
					type: "warning",
					showCancelButton: true,
					confirmButtonClass: "btn-danger",
					confirmButtonText: "Eliminar",
					cancelButtonText: "Cancelar",
					closeOnConfirm: false,
					closeOnCancel: false
				},
				function(isConfirm) {
					if (isConfirm) {
						swal.close();
						var funcion = "deleteModRol";
						var body = {
							funcion: funcion,
							id: id
						};
						Empresa.rest({
							verbo: 'POST',
							url: Empresa.armarUrl("/api/mantenimiento/funcionesMantenimiento.php"),
							data: body,
							funcionExito: function(respuesta) {
								Empresa.notificationSuccess("Se elimino correctamente el registro.");
							}
						});
					} else {
						swal.close();
					}
				});
		}
		// -------------------------- Boton Editar para todas las entidades ---------------------------- //

		function createButtonsEdit(id, tabla) {
			var btns = "";
			btns = " <button class='btn btn-info btn-xs' style='font-size:8px'  title='Editar' onclick='modalEdit" + tabla + "(\"" + id + "\")'><i class='fa fa-edit'></i></button>";
			return btns;
		}

		// -------------------------- Div para mostrar Datos ---------------------------- //
		function createDivDatos(datos, tabla) {
			var datos = datos.data;
			var divDatos = "";
			for (var i = 0; i < datos.length; i++) {
				divDatos += "<p style='margin:3px; line-height:10px;'><a class='text-navy' title='Eliminar' onclick='delete" + tabla + "(\"" + datos[i].id + "\")' >" + datos[i].item + "</a></p>";
			}
			return divDatos;
		}


		this.initializer();
	</script>
</body>

</html>