	<!DOCTYPE html>
	<html>

	<head>
		<?php
		include('includes/cabecera.inc');
		?>
	</head>

	<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
			<?php
			include('includes/menu_izq.inc');
			?>
			<div id="page-wrapper" class="gray-bg">
				<div class="row border-bottom">
					<?php
					include('includes/menu_top.inc');
					?>
				</div>
				<div class="wrapper wrapper-content ">
					<div class="row">
						<div class="col-lg-12">
							<div class="ibox float-e-margins">
								<div class="ibox-title">
									<div class="col-sm-2">
										<h5>Sucursal : <b id='nomSucursal'></b></h5>
									</div>
									<div class="col-lg-2">
										<div id="mostrarsucursal" style="display:none;">
											<select class="form-control" id="selectSucursal"></select>
										</div>
									</div>
									<div class="row form-group col-sm-8">
										<div class="col-sm-11">
											<label class="col-sm-1 control-label"> Mes:</label>
											<div class="col-sm-3">
												<input type="text" class="form-control input-sm" id='mes' onchange="cam_inifin(this.value);" required />
											</div>
											<label class="col-sm-1 control-label"> F.Ini:</label>
											<div class="col-sm-3">
												<input type="text" class="form-control input-sm" id='finicio' required />
											</div>
											<label class="col-sm-1 control-label"> F.Fin:</label>
											<div class="col-sm-3">
												<input type="text" class="form-control input-sm" id='ffin' required />
											</div>
										</div>
										<div class="col-sm-1">
											<!-- -->
											<button class="btn btn-info btn-sm " onclick="cargarPedidos();"> <i class="fa fa-filter"></i> </button>
										</div>
									</div>
								</div>
							</div>
							<div class="ibox float-e-margins">
								<div class="tabs-container">
									<ul class="nav nav-tabs">
										<li class="active "> <a id="tabventa" href="#tab-1" data-toggle="tab"><label class="text-navy"><i class="fa fa-shopping-cart"></i> Realizar Pedidos </a></label></li>
										<li> <a id="tablistado" href="#tab-2" onclick="cargarPedidos();"><label class="text-navy"><i class="fa fa-tags"></i> Listado Pedidos </a></label></li>
									</ul>
									<div class="tab-content">
										<div id="tab-1" class="tab-pane active">
											<div class="ibox-content">
												<div class="row">
													<div class="tabs-container">
														<ul class="nav nav-tabs" id="tabheader">
															
														</ul>
														<div class="tab-content" id="tabbody">
															
														</div>
													</div>
												</div>
											</div>
										</div>
										<div id="tab-2" class="tab-pane" style="font-size:11px;">
											<div class="ibox-content">
												<div class="row">
													<div class="col-md-12">
														<div class="ibox-title">
															<h5> Listado Pedidos Local </h5>
															<div class="ibox-tools">
															</div>
														</div>
														<div class="ibox-content">
															<div class="ibox table-responsive">
																<table class="table table-striped table-bordered table-hover lisPedidoLocal" style="font-size:10px; ">
																</table>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal inmodal" id="mdlFactura" tabindex="-1" role="dialog" aria-hidden="true">
					<div class="modal-dialog modal-lg">
						<div class="modal-content animated bounceInRight">
							<div class="modal-body">

								<div class="ibox-content">
									<div class="row">
										<div class="col-md-9">
											<div class="ibox-title">
												<h3 class="text-navy">Detalle <small> (venta)</small></h3>
											</div>
											<div class="ibox-content">
												<div class="row">
													<div class="col-md-6">
														<label>NIT/CI : </label>
														<input type="text" id="nit1" class="form-control frm input-sm" placeholder="Introduzca nit o razon social">
													</div>
													<div class="col-md-6">
														<label>Nombres <small>(Razon social)</small> : </label>
														<input type="text" id="rzs1" class="form-control frm input-sm">
													</div>
												</div>
												<div class="row">
													<div class="col-md-4">
														<label>Correo <small>(electronico)</small> : </label>
														<input type="text" id="mail1" class="form-control input-sm">
													</div>
													<div class="col-md-4">
														<label>Tipo Documento : </label>
														<select class="form-control input-sm" id="selectTipoDoc" style="width:100%">
														</select>
													</div>
													<div class="col-md-4">
														<label>Complemento <small>(CI)</small> : </label>
														<input type="text" id="cmp1" class="form-control input-sm">
													</div>
												</div>
											</div>
											<div class="ibox-content">
												<div class="row">
													<div class="col-md-12">
														<h3 class="text-navy"> Ventas <small>(Detalle)</small> </h3>
														<hr style="border-top: 1px solid white;">
														<table class="table table-striped table-bordered table-hover lisDetalleFactura">
														</table>
													</div>

												</div>
											</div>
										</div>
										<div class="col-md-3">
											<div class="ibox-title">
												<h3 class="text-navy">Facturar<small> (venta)</small></h3>
											</div>
											<div class="ibox-content">
												<div class="row">
													<label>Total<small>(items)</small> : </label>
													<input type="number" readonly id="tpar" class="form-control frm input-sm">
													<label>Sub-Total<small>(Bs)</small> : </label>
													<input type="number" readonly id="stbs" class="form-control frm input-sm"><input type="hidden" id="idcli"><input type="hidden" id="idven">
													<label>Descuento <small>(Bs)</small> : </label>
													<input type="text" id="dtbs" onfocusout="recalcularDescuento(this.value)" value="0" class="form-control input-sm" disabled>
													<label>Total <small>(Bs)</small> : </label>
													<input type="text" id="ttbs" class="form-control input-sm" disabled>
													<label>Total Base Credito Fiscal<small>(Bs)</small> : </label>
													<input type="number" readonly id="tbs" class="form-control frm input-sm">
													<button class="btn btn-primary btn-block btn-sm" onclick="procesarFactura()"><i class="fa fa-usd"></i> Facturar </button>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal inmodal" id="modalPedido" tabindex="-1" role="dialog" aria-hidden="true" >
					<div class="modal-dialog modal-lg">
						<div class="modal-content animated bounceInRight">
						
							<div class="modal-body">
								<div class="row">
									<div class="col-md-3">
										N° PEDIDO : <b style="color:#1ab394" id="nropedido"></b>
									</div>
									<div class="col-md-8"  style="display: flex; justify-content: center; align-items: center;">
										<ol class="breadcrumb">
											<li class="breadcrumb-item">
												<a><i class="fa fa-clock-o"></i> <b> Turno: </b> <span id="turpos"> Noche</span></a>
											</li>
											<li class="breadcrumb-item">
												<a><i class="fa fa-user-circle"></i> <b> Cajero: </b><span id="cajpos"> Admin </span></a>
											</li>
											<li class="breadcrumb-item ">
												<a><i class="fa fa-user"></i> <b> Mesero: </b><span id="mespos"> Andree </span></a>
											</li>
											<li class="breadcrumb-item ">
												<a><i class="fa fa-home"></i> <b> Sucursal: </b><span id="sucpos"> Matriz </span></a>
											</li>
										</ol>
									</div>
									<div class="col-md-1">
										<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
									</div>
									
								</div><hr style="border: 0; height: 0; box-shadow: 0 1px 1px 1px #1ab394;">
								<div class="row">
									<div class="col-sm-7">
										<div class="ibox">
											<div class="col-md-12">
												<div class="cont-horizontal" id="catpos" style="display: flex; overflow-x: scroll; font-size:8px; height: 120px;">
													
												</div>
											</div>
											<div class="ibox-content">
												<div class="row">
													<div class="col-md-6" style="font-size:10px;">
														<select class="form-control" id="selectInventario" onchange="agregarItemStock(this.value,1)" style="width: 100%;" required></select>
													</div>
													<div class="col-md-6" style="font-size:10px;">
														<div class="input-group">
															<input type="text" id="codbar_ped" placeholder="Ingrese codigo de Barras" onkeypress="ingresarCodigo(event)" class="form-control input-sm vnt"><span class="input-group-btn"> <button type="button" style="width:35px;" onclick="buscarCodigoBarras()" class="btn btn-info btn-outline btn-sm"><i class="fa fa-search"></i></button></span>
														</div>
													</div>
												</div><hr>
												<div class="row">
													<div class="col-md-12 cont-horizontal" id="mosaico" style="font-size:8px; max-height: 450px; overflow-y: scroll;"></div>
												</div>
											</div>
										</div>
									</div>
									<div class="col-lg-5">

										<div class="ibox">
											<div class="ibox-title">
												<span class="pull-right btn btn-primary btn-outline btn-sm"> <i class="fa fa-shopping-cart" ></i>(<strong id="itmcantidad">0</strong>) Items</span>
												<h5>Detalle Pedido <small></small></h5>
											</div>
											<div class="ibox-content">
												<div class="row">
													<div class="col-md-12 cont-horizontal" style="font-size:8px; height: 450px; overflow-y: scroll;">
														<table class="table table-striped table-bordered table-hover lisPedido" style="font-size:10px;">
														</table>
													</div>
												</div>
											</div>
											<div class="ibox-content">
												<div class="row" >
													<div class="col-sm-6">
														<label class="control-label">Cantidad: </label>
														<input type="text" value="0" id="cantidad_ped" class="form-control input-sm peds" readonly>
														<input type="hidden"  id="updidpedido" class="form-control">
													</div>
													<div class="col-sm-6">
														<label class="control-label">Precio Total</label>
														<input type="text" value="0"  id="precio_ped" class="form-control input-sm peds" readonly>
													</div>
												</div><br>
												<div class="row" >
													<div class="col-sm-6">
														<button onclick="terminarPedido()" class="btn btn-sm btn-primary btn-block"> <i class="fa fa-check"></i> Terminar Pedido </button>
													</div>
													<div class="col-sm-6">
													<button onclick="enviarPedido()" disabled class="btn btn-sm btn-success btn-block peds"><i class="fa fa-send"></i> Enviar Comandas </button>
													</div>
												</div>	
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal inmodal" id="modalItem" tabindex="-1" role="dialog" aria-hidden="true" >
					<div class="modal-dialog modal-md">
						<div class="modal-content animated bounceInRight">
						
							<div class="modal-body">
								<div class="row">
									<div class="col-md-10">
										Receta del producto <b style="color:#1ab394;" id="nomprditm"> </b>
									</div>
									
									<div class="col-md-2">
										<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
									</div>
								</div><hr style="border: 0; height: 0; box-shadow: 0 1px 1px 1px #1ab394;">
								<div class="row">
									<div class="col-sm-7">
										<div class="ibox">
											<div class="ibox-content">
												<div class="row">
													<div class="col-md-12 cont-horizontal" id="itmcat" style="font-size:8px; max-height: 350px; overflow-y: scroll;"></div>
												</div>
											</div>
										</div>
									</div>
									<div class="col-sm-5">
										<div class="ibox">
											<div class="ibox-content">
												<div class="row" id="tablesitem">
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal inmodal" id="modalTerminarPedido" tabindex="-1" role="dialog" aria-hidden="true" >
					<div class="modal-dialog">
						<div class="modal-content animated bounceInRight">
							<div class="modal-header">
								<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
								<h4 class="modal-title"> <i class="fa fa-check"></i> Terminar Pedido Mesa : <b style="color:#1ab394" id="nromesa"></b></h4>
								<small> Se pasara directo al correspondiente del consumo de la mesa.</small>
							</div>
							<div class="modal-body">
								<div class="form-horizontal" >
									<div class="form-group">  
									<div class="col-xs-12">
										<label class="control-label "> CI/NIT: </label>
										<div class="input-group">
											<input type="text" id="nit" class="form-control input-sm" onkeypress="ingresarNit(event)"  placeholder="Introduzca nit o razon social"><span class="input-group-btn"> <button type="button" id="buscarNit" onclick="buscarNit()" class="btn btn-info btn-sm frm"><i class="fa fa-search"></i></button> </span>
										</div>
									</div>
									</div>
									<div class="form-group">  
									<div class="col-xs-12">
										<label class="control-label"> Nombres <small>(Razon social)</small> :</label>
										<input type="text" id="rzs" class="form-control input-sm">
									</div>
									</div>
									<div class="form-group">  
									<div class="col-xs-12">
										<label class="control-label"> Complemento <small>(CI)</small> : </label>
										<input type="text" id="cmp" class="form-control input-sm">
									</div>
									</div>
									<div class="form-group">  
									<div class="col-xs-12">
										<label class="control-label"> Correo <small>(electronico)</small> : </label>
										<input type="text" id="mail" class="form-control input-sm" >
									</div>
									</div>									
								</div>
							</div>
							<div class="modal-footer">
								<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
								<button onclick="terminarPedido();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Terminar Pedido </button>
							</div>
						</div>
					</div>
				</div>
				<div class="modal inmodal" id="mdlDireccion" tabindex="-1" role="dialog" aria-hidden="true">
					<div class="modal-dialog">
						<div class="modal-content animated bounceInRight">
							<div class="modal-header">
								<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
								<h4 class="modal-title"> <i class="fa fa-map-marker"></i> Ubicacion Pedido</h4>
							</div>
							<div class="modal-body">
								<div class="row">
									<div class="col-md-12">
										<div class="ibox ">
											<div class="ibox-title">
												<h5>Mapa</h5>
											</div>
											<div class="ibox-content  ">
												<center>
													<div id="myMap" style="height: 400px"></div>
												</center>
											</div>
										</div>
									</div>
									<div class="col-md-12">
										<div class="ibox ">
											<div class="ibox-content ">
												<div class="form-group">
													<div class="row" >
														<label class="control-label"> Direccion:
														</label>
														<div class="col-md-12">
															<div class="input-group">
																<input type="text" id="dirmap" class="form-control input-sm" readonly><span class="input-group-btn"> <button type="button" disabled style="width:35px;" class="btn btn-default btn-sm"><i class="fa fa-map-marker text-navy"></i></button></span>
															</div>
														</div>
													</div>
													<div class="row" >
														<label class="control-label"> Indicaciones:
														</label>
														<div class="col-md-12">
															<div class="input-group">
																<input type="text" id="indmap"  class="form-control input-sm" readonly><span class="input-group-btn"> <button type="button" style="width:35px;" disabled class="btn btn-default btn-sm"><i class="fa fa-edit text-navy"></i></button></span>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal inmodal" id="modalCmp" tabindex="-1" role="dialog" aria-hidden="true" >
					<div class="modal-dialog modal-md">
						<div class="modal-content animated bounceInRight">
						
							<div class="modal-body">
								<div class="row">
									<div class="col-md-10">
										Elegir Complementos
									</div>
									
									<div class="col-md-2">
										<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
									</div>
								</div><hr style="border: 0; height: 0; box-shadow: 0 1px 1px 1px #1ab394;">
								<div class="row">
									<div class="col-sm-6">
										<div class="ibox">
											<div class="ibox-content">
												<center>
													<img alt="image" class="img-thumbnail" width="200px" src="img/Producto/noimage.png" id="imgprdcmp">
													<h4><b id="precmp"></b></h4>
												</center>
											</div>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="ibox">
											<div class="ibox-content">
												<div id="dtcmp">
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="modal-footer">
								<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
								<button id="btnAceptar" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Aceptar </button>
							</div>
						</div>
					</div>
				</div>
				<div class="footer">
					<?php
					include('includes/footer.inc');
					?>
				</div>
			</div>
		</div>
		<?php
		include('includes/pie.inc');
		?>
		<script>
			var date = new Date();
			var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth() + 1);
			var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
			var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
			var fecini = mes + "-" + Empresa.agregarCero(primerDia);
			var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
			var fechoy = mes + "-" + date.getDate();


			var ids = "<?php echo $ids; ?>";
			var usr = "<?php echo $usr; ?>";
			var idu = "<?php echo $idu; ?>";
			var idr = "<?php echo $idr; ?>";
			var aps = "<?php echo $aps; ?>";
			var nom = "<?php echo $nom; ?>";
			var rol = "<?php echo $rol; ?>";
			var ico = "<?php echo $ico; ?>";
			var emp = "<?php echo $emp; ?>";
			var foto = "<?php echo $foto; ?>";
			var logo = "<?php echo $logo; ?>";
			var tc = "<?php echo $tc; ?>";
			var nomSuc = "<?php echo $suc; ?>";
			var sig = "<?php echo $sig; ?>";
			var dir = "<?php echo $dir; ?>";
			var telf = "<?php echo $telf; ?>";
			var cel = "<?php echo $cel; ?>";
			var loc = "<?php echo $loc; ?>";
			var ciu = "<?php echo $ciu; ?>";
			var complementos = "";
			var lisDetalleFactura = [];
			var lisNewFactura = [];
			var lisPedidoLocal = [];

			var detailItem = [];

			var pedido = [];

			function initializer() {
				cargarDatosWeb();
				menuNotificaciones();
				document.getElementById('nomSucursal').innerHTML = nomSuc;
				document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
				document.getElementById('rolUser').innerHTML = rol;
				document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
				document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
				document.getElementById('rolUser').innerHTML = rol;
				//document.getElementById('tcempresa').innerHTML = tc;
				selectTiposDoc();
				selectMetodoPago();
				selectTipoPago();
				selectSucursal(ids);
				cargarFechas();
				selectInventario();
				headerDetallePedido();
				verificarArqueo();
				cargarAmbientes(); 
				cargarCategorias();	
				if (idr == '2') {
					$('#mostrarsucursal').show();
				}

			}

			function cargarFechas() {
				$("#mes").val(mes);
				$("#finicio").val(fecini);
				$("#ffin").val(fecfin);
				$("#ffin").val(fecfin);
				var date0 = $('input[id="mes"]');
				var date1 = $('input[id="finicio"]');
				var date2 = $('input[id="ffin"]');
				var hoy = $('input[id="farqueo"]');
				date0.datepicker({
					format: 'yyyy-mm',
					startView: 'months',
					minViewMode: 'months',
					todayHighlight: true,
					autoclose: true,
				});
				date1.datepicker({
					format: 'yyyy-mm-dd',
					todayHighlight: true,
					autoclose: true,
				});
				date2.datepicker({
					format: 'yyyy-mm-dd',
					todayHighlight: true,
					autoclose: true,
				});
				hoy.datepicker({
					format: 'yyyy-mm-dd',
					todayHighlight: true,
					autoclose: true,
				});
			}

			function cam_inifin(dato) {
				Empresa.cambiarFechas(dato, "#finicio", "#ffin");
				mes = $("#mes").val();
				fecini = $("#finicio").val();
				fecfin = $("#ffin").val();
			}
			// -------------------------- Headers ---------------------------- //
			function headerDetallePedido() {
				var columnsName = [{title: "#"},{title: "Imagen"},{title: "Producto"},{title: "Cantidad"},{title: "P/U"},{title: "SubTotal"},{title: ""}];
				Empresa.inicializarTablaSinFormato({
					selector: ".lisPedido",
					columnas: columnsName
				});
			}
			// -------------------------- Cargar Selects ---------------------------- //
			function selectSucursal(valor) {
				Empresa.actualizarSelect({
					selector: "#selectSucursal",
					sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
					callback: function(data) {
						$("#selectSucursal").val(valor);
						$("#selectSucursal").select2();
						$("#selectPrecio").select2();
					}
				});
				ids = valor;
			}

			function selectTipoPago() {
				Empresa.actualizarSelect({
					selector: "#selectTipoPago",
					sql: "select id_tipo as id, concat(tipo_pago) as etiqueta from tipo_pago",
					callback: function(data) {
						$("#selectTipoPago").val(1);
						$("#selectTipoPago").select2();
					}
				});
			}

			function selectTiposDoc() {
				Empresa.actualizarSelect({
					selector: "#selectTipoDoc",
					sql: "select codigo as id, descripcion as etiqueta from siat_sinc_tipos_documento_identidad",
					callback: function(data) {
						$('#selectTipoDoc').val(1);
						$('#selectTipoDoc').select2();
					}
				});
			}

			function selectMetodoPago() {
				Empresa.actualizarSelect({
					selector: "#selectMetodoPago",
					sql: "select codigo as id, descripcion as etiqueta from siat_sinc_metodo_pago order by descripcion ",
					callback: function(data) {
						$('#selectMetodoPago').val(1);
						$('#selectMetodoPago').select2();
					}
				});
			}

			function selectInventario() {
				Empresa.actualizarSelect({
					selector: "#selectInventario",
					sql: "SELECT p.id_producto as id, concat(p.codigo,' ',p.nombre) as etiqueta FROM producto p",
					callback: function(data) {
						$("#selectInventario").select2({
							placeholder: "Seleccione un producto del inventario.",
							dropdownParent: $('#modalPedido'),
							minimumInputLength: 2
						});
					}
				});
			}
			// -------------------------- Ambientes  ------------------------------
			function cargarCategorias() {
				Empresa.showSpinner();
				var funcion = "listarCategorias";
				var body = { funcion: funcion, idsucursal: ids };
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) {
						var categorias = respuesta.categorias.data;
						var cat = $('#catpos');  
						cat.hide();cat.empty();
						for (var i = 0; i < categorias.length; i++) {
							if(i==0){
								cargarProductosCategoria(categorias[i].CATEGORIA);
							}
							var item = "<div class='col-md-3'><div class='col-md-12' style='width:100px; height: 100px; border: solid #f3f3f4;'><div class='m-t-xs font-bold'> <span class='badge badge-primary pull-right' > "+categorias[i].CANTIDAD+" </span></div><div class='text-center'><a onclick='cargarProductosCategoria(\"" + categorias[i].CATEGORIA + "\")'><img   width='55px' height='40px' src='img/categoria/"+categorias[i].IMAGEN+"' ><div class='m-t-xs font-bold'>"+categorias[i].CATEGORIA+"</div></a></div></div></div>";
							cat.append(item);
							cat.show(); 	
						}	
						Empresa.hideSpinner();
						
					},
					funcionError: function (e) {
						Empresa.notificationError(e.mensaje);
						Empresa.hideSpinner();
					}
				});
			}
			// -------------------------- Ambientes  ------------------------------
			function cargarAmbientes(){
				Empresa.showSpinner();
				var funcion = "listarAmbientes";
				var body = { funcion: funcion , idsucursal: ids};
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) {
						var ambientes = respuesta.ambientes;
						var tabh = $('#tabheader'); tabh.hide();tabh.empty();
						var tabb = $('#tabbody'); tabb.hide();tabb.empty();
						for (var i = 0; i < ambientes.length; i++) {
							var btnmesa = '';
							var nmesa = ambientes[i].DATOS.data;
							if(i==0){
								var itemh = "<li class='active'> <a data-toggle='tab' id='tabamb"+i+"' href='#tab"+i+"' ><label class='text-navy' ><i class='fa fa-home'></i> "+ambientes[i].AMBIENTE+" </a></label></li>";
								var itemb = "<div id='tab"+i+"' class='tab-pane active'><div class='ibox-content'><div class='row'><div class='col-md-4'><div class='ibox-title'><h5> Datos Ambiente </h5></div><div class='ibox-content'><div class='form-horizontal form-label-left'><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Codigo:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].CODIGO+"' class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Ambiente:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].AMBIENTE+"' readonly class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Nro Mesas:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].NMESAS+"' class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Ocupadas:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' value='"+ambientes[i].MOCUPADO+"' readonly class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Libres:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' value='"+ambientes[i].MLIBRE+"' readonly  class='form-control'></div></div></div></div></div><div class='col-md-8'><div class='ibox-title'><h5> Mesas  </h5></div><div class='ibox-content'><div class='matriz' id='matriz"+i+"'></div></div></div></div></div></div>";
							}else{
								var itemh = "<li> <a data-toggle='tab' id='tabamb"+i+"' href='#tab"+i+"' ><label class='text-navy' ><i class='fa fa-home'></i> "+ambientes[i].AMBIENTE+" </a></label></li>";
								var itemb = "<div id='tab"+i+"' class='tab-pane'><div class='ibox-content'><div class='row'><div class='col-md-4'><div class='ibox-title'><h5> Datos Ambiente </h5></div><div class='ibox-content'><div class='form-horizontal form-label-left'><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Codigo:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].CODIGO+"' class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Ambiente:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].AMBIENTE+"' readonly class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Nro Mesas:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].NMESAS+"' class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Ocupadas:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' value='"+ambientes[i].MOCUPADO+"' readonly class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Libres:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' value='"+ambientes[i].MLIBRE+"' readonly  class='form-control'></div></div></div></div></div><div class='col-md-8'><div class='ibox-title'><h5> Mesas  </h5></div><div class='ibox-content'><div class='matriz' id='matriz"+i+"'></div></div></div></div></div></div>";
							}
							tabh.append(itemh); tabb.append(itemb);
							var numColumnas = Math.ceil(Math.sqrt(nmesa.length));
							var btnm = $("#matriz"+i); btnm.empty();
							for (var j = 0; j < nmesa.length; j++) {
								if(nmesa[j].ESTADO == 'LIBRE'){
									btnmesa = "<button class='btn btn-primary btn-outline dim' style='width:110px; height:100px; font-size:10px' onclick='mostrarPedido(\"" + nmesa[j].ID + "\")'>" + nmesa[j].ITEM + " <br>  Sillas: " + nmesa[j].CAPACIDAD + "</button>";
								}else{
									btnmesa = "<button class='btn btn-danger btn-outline dim' style='width:110px; height:100px; font-size:10px' onclick='mostrarPedido(\"" + nmesa[j].ID + "\")'>" + nmesa[j].ITEM + " <br>  Sillas: " + nmesa[j].CAPACIDAD + " <br> " + nmesa[j].MESERO + "</button>";
								}
								
								btnm.append(btnmesa);
							}
							tabh.show(); tabb.show();
						}
						
					},
					funcionError: function (e) {
						Empresa.notificationError(e.mensaje);
						Empresa.hideSpinner();
					}
				});
			}
			function mostrarPedido(idmesa) {
				pedido = [];
				var funcion = "mostrarPedido";
				var body = { funcion: funcion, idmesa: idmesa, iduser: idu, idsucursal: ids};
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) {
						Empresa.hideSpinner();
						var ped = respuesta.pedido;
						var detprod = respuesta.detprod;
						var mesa = respuesta.mesa;
						cargarAmbientes();
						
						$("#modalPedido").modal("show");
						$("#updidpedido").val(ped.ID_PEDIDO);
						document.getElementById('nromesa').innerHTML = mesa.NRO_MESA;
						document.getElementById('nropedido').innerHTML = ped.BOLETA;

						for (var i = 0; i < detprod.length; i++) {
							
							itemPedido = {} ;
							itemPedido.idp = detprod[i].ID;
							itemPedido.nombre = detprod[i].NOMBRE;   
							itemPedido.precio = detprod[i].PRECIO;
							itemPedido.cantidad= detprod[i].CANTIDAD;
							itemPedido.imagen = detprod[i].IMAGEN;
							itemPedido.tipo = detprod[i].TIPO;
							itemPedido.unidad = detprod[i].UNIDAD;
							itemPedido.estado = detprod[i].ESTADO;
							pedido.push(itemPedido);	
						}
						dibujarPedido();
					},
					funcionError: function (e) {
						Empresa.notificationError(e.mensaje);
						Empresa.hideSpinner();
					}
				}); 
			}
			function verDetalleItem(nom,pos) {
				$("#modalItem").modal("show");
				document.getElementById('nomprditm').innerHTML = nom; 
				$('.titem').hide();
				$('#titem'+pos).show(); 
				var itmc = $('#itmcat');  
				itmc.empty();
				var itemdet = "<div class='alert alert-info'> <a class='alert-link'> Informacion </a>. En esta parte podra cambiar los ingredientes de su producto.</div>";
				itmc.append(itemdet);
				itmc.show();
			}
			function modalDetalleItem(i,j,idp,idcat) {
				Empresa.showSpinner();
				var idcategoria = idcat;
				var idproducto = idp;
				var posi = i; var posj = j;
				var funcion = "listarItemsCambio";
				var body = { funcion: funcion, idcategoria: idcategoria , idproducto: idproducto};
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) {
						Empresa.hideSpinner();
						var productos = respuesta.productos;					
						var itmc = $('#itmcat');  
						itmc.hide();itmc.empty();
						var cant =  productos.length;
						if(cant==0){
							var itemdet = "<div class='alert alert-danger'> <a class='alert-link'> Informacion </a>. No se Puede cambiar la receta Original </div>";
							itmc.append(itemdet);
							itmc.show(); 
						}
						for (var i = 0; i < productos.length; i++) {
							if(i==0){
								var itemmsj = "<div class='alert alert-success'> <a class='alert-link'> Informacion </a>. Elija el Item por el cual desea cambiar.</div>";
								itmc.append(itemmsj);
								itmc.show();
							}
							var itemdet = "<div class='col-sm-6'><div class='col-sm-12' style='border: solid #f3f3f4;'><div class='m-t-xs font-bold'>"+productos[i].id_prd1+"  <span class='badge pull-right' > "+productos[i].precio+" Bs. </span></div><div class='text-center'><a onclick='cambiarItemReceta(\"" + posi + "\",\"" + posj + "\",\"" + productos[i].id_prd + "\",\"" + productos[i].id_prd1 + "\")'><img   width='70px' height='70px' src='img/Producto/"+productos[i].imagen+"' ><div class='m-t-xs font-bold'>"+productos[i].nombre+"</div></a></div></div></div>";
							itmc.append(itemdet);
							itmc.show(); 	
						}	
					}
				});
			}
			function cargarProductosCategoria(cat) {
				Empresa.showSpinner();
				var funcion = "listarProductosCategoria";
				var body = { funcion: funcion, categoria: cat };
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) {
						var productos = respuesta.productos.data;					
						var ped = $('#mosaico');  
						ped.hide();ped.empty();
						for (var i = 0; i < productos.length; i++) {
							var itemvnt = "<div class='col-md-4'><div class='col-lg-12' style='border: solid #f3f3f4;'><div class='m-t-xs font-bold'>"+productos[i].ID_PRODUCTO+"  <span class='badge pull-right' > "+productos[i].PRECIO_VENTA+" Bs. </span></div><div class='text-center'><a onclick='agregarProducto(\"" + productos[i].ID_PRODUCTO+ "\")'><img   width='100px' height='100px' src='img/Producto/"+productos[i].IMAGEN+"' ><div class='m-t-xs font-bold'>"+productos[i].NOMBRE+"</div></a></div></div></div>";
							ped.append(itemvnt);
							ped.show(); 	
						}	
						Empresa.hideSpinner();
					}
				});
			}
			function agregarProducto(id){
				Empresa.showSpinner();
				var funcion = "agregarProducto";
				var body = { funcion: funcion , idproducto: id};
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) {
						Empresa.hideSpinner();
						var producto = respuesta.producto;
						var detprod = respuesta.detprod;
						var detcmp = respuesta.detcmp;
						if(producto.TIPO_PRODUCTO == "RECETA"){
							elegirComplementos(producto.ID_PRODUCTO,producto.NOMBRE,producto.PRECIO_VENTA,producto.IMAGEN,producto.TIPO_PRODUCTO,producto.UNIDAD,producto.COMPLEMENTOS, detprod, detcmp);
						}else{
							agregarItem(producto.ID_PRODUCTO,producto.NOMBRE,producto.PRECIO_VENTA,producto.IMAGEN,producto.TIPO_PRODUCTO,producto.UNIDAD,producto.COMPLEMENTOS,detprod);
						}						
						selectInventario();
						$("#codbar_ped").val("");
					},
					funcionError: function (e) {
						Empresa.hideSpinner();
						Empresa.notificationError(msj);
					}
				});
			}
			let tprecio = 0;  // Variable global para el total del precio
			let nnombre = '';     // Variable global para el nombre del producto

			function elegirComplementos(idp, nombre, precio, imagen, tipo, unidad, cmp, detprd, detcmp) {
				$("#modalCmp").modal("show");
				document.getElementById("imgprdcmp").src = "img/Producto/" + imagen;
				document.getElementById('precmp').innerHTML = `Total: Bs ${precio}`;

				let tprecio = parseFloat(precio); // Inicializamos el precio total
				let nnombre = nombre;  // Inicializamos el nombre con el nombre del producto base

				const container = document.getElementById("dtcmp");

				// Limpiar el contenedor antes de agregar los nuevos complementos
				container.innerHTML = "";

				// Procesar complementos
				complementos = detcmp;
				complementos.forEach(complemento => {
					const complementoDiv = document.createElement("div");
					complementoDiv.classList.add("complemento");

					// Título del complemento
					const titulo = document.createElement("h5");
					titulo.innerText = complemento.NOMBRE;
					complementoDiv.appendChild(titulo);

					// Crear inputs dinámicos
					const datos = JSON.parse(complemento.DATOS);
					datos.forEach((dato, index) => {
						const inputDiv = document.createElement("div");
						inputDiv.classList.add("form-check");

						const input = document.createElement("input");
						input.type = complemento.TIPO_SELECCION === "0" ? "radio" : "checkbox";
						input.name = `complemento_${complemento.ID_COMPLEMENTO}`;
						input.value = dato.id;
						input.dataset.price = dato.precio; // Añadimos el precio como atributo data
						input.dataset.group = complemento.ID_COMPLEMENTO; // Grupo del complemento
						input.classList.add("form-check-input");

						const label = document.createElement("label");
						label.innerText = dato.nombre;
						label.classList.add("form-check-label");

						inputDiv.appendChild(input);
						inputDiv.appendChild(label);
						complementoDiv.appendChild(inputDiv);

						// Seleccionar por defecto el primer elemento si CAMPO_REQUERIDO es 1
						if (complemento.TIPO_SELECCION === "0" && complemento.CAMPO_REQUERIDO === "1" && index === 0) {
							input.checked = true;
							if (complemento.AFECTAR_CANTIDADES === "1") {
								tprecio += parseFloat(dato.precio);
							}
						}

						// Escuchar cambios
						input.addEventListener("change", () => {
							// Enforce max selection if checkbox type
							if (complemento.TIPO_SELECCION === "1") {
								enforceMaxSelection(complemento.ID_COMPLEMENTO, complemento.SELECCION_MAXIMA);
							}

							// Recalcular precio total
							if (complemento.AFECTAR_CANTIDADES === "1") {
								tprecio = calculateTotal(precio);
							}

							// Actualizar el nombre del producto con complementos seleccionados
							nnombre = updateSelectionDetails(nombre); 
						});
					});

					container.appendChild(complementoDiv);
				});

				// Remover cualquier listener previo en el botón para evitar duplicados
				const btnAceptar = document.getElementById('btnAceptar');
				btnAceptar.replaceWith(btnAceptar.cloneNode(true));
				const newBtnAceptar = document.getElementById('btnAceptar');

				// Añadir listener al botón Aceptar
				newBtnAceptar.addEventListener('click', function() {
					agregarItem(idp, nnombre, tprecio, imagen, tipo, unidad, cmp, detprd);
					$("#modalCmp").modal("hide");
				});
			}


			function calculateTotal(precio) {
				let totalPrice = parseFloat(precio); 
				let selectedInputs = document.querySelectorAll("input:checked");
				
				selectedInputs.forEach(input => {
					totalPrice += parseFloat(input.dataset.price);
				});

				document.getElementById('precmp').innerHTML = `Total: Bs ${totalPrice.toFixed(2)}`;

				return totalPrice;
			}

			function enforceMaxSelection(complementoID, maxSelections) {
				let selectedCheckboxes = document.querySelectorAll(`input[name='complemento_${complementoID}']:checked`);
				if (selectedCheckboxes.length > maxSelections) {
					alert(`Puedes seleccionar un máximo de ${maxSelections} opciones para este complemento.`);
					
					selectedCheckboxes[selectedCheckboxes.length - 1].checked = false;
				}
			}

			function updateSelectionDetails(nombre) {
				let seleccionados = `${nombre} - `;

				let inputsSeleccionados = document.querySelectorAll("input:checked");

				inputsSeleccionados.forEach(input => {
					seleccionados += `${input.nextElementSibling.innerText.split(" - ")[0]}, `;
				});

				if (seleccionados.length > 0) {
					seleccionados = seleccionados.slice(0, -2); // Eliminar la última coma y espacio
				}

				return seleccionados;
			}

			function agregarItem(idp, nombre, precio, imagen, tipo, unidad, cmp, detprd) {
				if (tipo !== "RECETA") {
					let productoExistente = pedido.find(item => item.idp === idp);

					if (!productoExistente) {

						let itemPedido = {};
						itemPedido.idp = idp;
						itemPedido.nombre = nombre;
						itemPedido.precio = precio;  
						itemPedido.cantidad = 1; 
						itemPedido.imagen = imagen;
						itemPedido.tipo = tipo;
						itemPedido.unidad = unidad;
						itemPedido.estado = 'PEDIDO';
						itemPedido.detalle = nombre;
						pedido.push(itemPedido);
					}
				} else {

					let itemPedido = {};
					itemPedido.idp = idp;
					itemPedido.nombre = nombre;
					itemPedido.precio = precio;
					itemPedido.cantidad = 1;  
					itemPedido.imagen = imagen;
					itemPedido.tipo = tipo;
					itemPedido.unidad = unidad;
					itemPedido.estado = 'PEDIDO';
					itemPedido.detalle = nombre;

					pedido.push(itemPedido);
				}

				// -------------------------  Dibujar Pedido -------------------------------
				$('.peds').prop('disabled', false);  
				dibujarPedido();  
			}

			function quitarDetallePedido(id)
			{	
				// ------------------------- Quitar Item Pedido -------------------------------
				for (var k = 0; k < pedido.length; k++) {
					if( k == id ){
						pedido.splice(k,1);
					}
				}
				// -------------------------  Dibujar Pedido -------------------------------
				dibujarPedido();
				
			}
			function quitarDetalleItem(posi,posj)
			{	
				// ------------------------- Quitar Detalle Item ---------------------------
				for (var k = 0; k < pedido.length; k++) {
					if( k == posi ){
						var detp = pedido[k].detalle;
						for (var m = 0; m < detp.length; m++) {
							if( m == posj ){
								detp.splice(m,1);
							}
						}
						pedido[k].detalle = detp;
					}
				}
				// -------------------------  Dibujar Pedido -------------------------------
				dibujarPedido();

				// -------------------------  Ocultar Tablas -------------------------------
				$('.titem').hide();
				$('#titem'+posi).show(); 
			}
			function cambiarItemReceta(posi,posj,prd,prd1)
			{	
				Empresa.showSpinner();
				var posi = posi; var posj = posj;
				var funcion = "recuperarIngrediente";
				var body = { funcion: funcion, idprd: prd , idprd1: prd1};
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) {
						Empresa.hideSpinner();
						var ingrediente = respuesta.ingrediente;
						// ---------------------- Cambiar Ingredientes ------------------------------
						for (var k = 0; k < pedido.length; k++) {
							if( k == posi ){
								var detp = pedido[k].detalle;
								for (var m = 0; m < detp.length; m++) {
									if( m == posj ){	
										detp[m].id_prd = ingrediente.ID_PRD;
										detp[m].nombre = ingrediente.NOMBRE;
										detp[m].umedida = ingrediente.UMEDIDA;
										detp[m].id_cat1 = ingrediente.ID_CAT1;
										detp[m].id_prd1 = ingrediente.ID_PRD1;
										detp[m].cantidad = ingrediente.CANTIDAD;
										detp[m].precio = ingrediente.PRECIO;
										detp[m].tipo = ingrediente.TIPO;
										detp[m].fila = ingrediente.FILA;
										detp[m].id_um = ingrediente.ID_UM;
									}
								}
								pedido[k].detalle = detp;
							}
						}
						// -------------------------  Dibujar Pedido -------------------------------
						dibujarPedido();

						// -------------------------  Ocultar Tablas -------------------------------
						$('.titem').hide();
						$('#titem'+posi).show(); 
						// ---------------------  Ocultar Ingredientes -----------------------------
						var itmc = $('#itmcat');  
						itmc.empty();
						var itemdet = "<div class='alert alert-info'> <a class='alert-link'> Informacion </a>. En esta parte podra cambiar los ingredientes de su producto.</div>";
						itmc.append(itemdet);
						itmc.show();
					}
				});
			}
			function dibujarPedido() {
				
				// -------------------------  detalle del Pedido -------------------------------
				detailItem = []; var count = 0; var id;
				var sumtitems = 0; var preciototal = 0; var sumtprecio = 0;
				for (var i = 0; i < pedido.length; i++) {
					sumtitems = parseFloat(sumtitems) + parseFloat(pedido[i].cantidad); 
					preciototal = parseFloat(pedido[i].precio) * parseFloat(pedido[i].cantidad); 
					sumtprecio = parseFloat(sumtprecio) + parseFloat(preciototal);
					if(pedido[i].tipo == '1'){
						var tipop = "";
					}else{
						var tipop = crearButtonEditar(pedido[i].nombre,i);
					}
					if(pedido[i].estado == 'PEDIDO'){
						var estado = crearButtonQuitar(i);
					}else{
						var estado = "<button class='btn btn-default btn-xs' style='font-size:8px' ><i class='fa fa-check'></i> EN TRANSITO </button>";
						var tipop = "";
					}
					detailItem.push([
						tipop,
						crearImgDet(pedido[i].imagen,"50"),
						pedido[i].nombre,
						pedido[i].cantidad+ " Uds",
						pedido[i].precio+ " Bs.",
						preciototal+ " Bs.",
						estado
					]);
				}
				document.getElementById('itmcantidad').innerHTML = sumtitems;
				$("#cantidad_ped").val(sumtitems);
				$("#precio_ped").val(Empresa.roundNumber(sumtprecio,2));
				Empresa.refrescarTablaDeDatos({
					selector: ".lisPedido",
					data: detailItem
				});
			}
			// ------------------------- Enviar Pedido  -------------------------
			function enviarPedido(){	
				Empresa.showSpinner();
				var idpedido = document.getElementById("updidpedido").value;
				var funcion = "enviarPedido";
				var body = { funcion: funcion, idpedido: idpedido , detalle: pedido};
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) {
						Empresa.hideSpinner();
						$("#modalPedido").modal("hide");
						var items = respuesta.items;
						var idped = respuesta.idped;
						limpiarPedido();
						if(items > 0){
							Empresa.notificationSuccess(" Se envio correctamente " + items + " Items a Comandas.");	
							imprimirComanda(idped);
						}else{
							Empresa.notificationError("No se Envio Ningun Item a Comandas.");
						}
						
					}
				});
			}
			function limpiarPedido() {
				$('.peds').prop('disabled', true);
				pedido = [];
				Empresa.refrescarTablaDeDatos({
					selector: ".lisPedido",
					data: []
				});

			}
			function imprimirComanda(id) {                           
				Empresa.PopupCenter('print_comanda.php?id='+id+'','IMPRIMIR COMANDA',400,520);
			}
			// ------------------------- Terminar Pedido  -------------------------
			function terminarPedido(){
				var idpedido = document.getElementById("updidpedido").value;
				var body = {funcion: "terminarPedido", idpedido: idpedido};
				swal({
				title: "Terminar Pedido",
				text: "Se procedera a terminar el Pedido",
				type: "warning",
				showCancelButton: true,
				confirmButtonClass: "btn-danger",
				confirmButtonText: "Terminar",
				cancelButtonText: "Cancelar",
				closeOnConfirm: false,
				closeOnCancel: false
				},
				function(isConfirm) {
				if (isConfirm) {
					swal.close();
					Empresa.rest(
					{
						verbo: 'POST',
						url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
						data: body,
						funcionExito: function (respuesta) 
						{
							$("#modalPedido").modal("hide");
							var idped = respuesta.idped;
							limpiarPedido();
							swal({
								title: "Exito",
								type: "success",
								text: "Pedido Terminado Correctamente"
							});	
							imprimirPedido(idped);
							cargarAmbientes();
						},
						funcionError: function (e) {
							Empresa.notificationError(e.mensaje);
							Empresa.hideSpinner();
						}
					})
				} else {
					swal.close();	
				}
				});
			}
			// ------------------------------- Tabla Pedidos -------------------------------
			function cargarPedidos() {
				Empresa.showSpinner();
				var idsucursal = document.getElementById("selectSucursal").value;
				if (idsucursal == "") {
					idsucursal = ids;
				}
				$('#tablistado').tab('show');
				var fecini = document.getElementById("finicio").value;
				var fecfin = document.getElementById("ffin").value;
				var columnsName = [{
					title: "#"
				}, {
					title: " Fecha"
				}, {
					title: " Boleta"
				}, {
					title: " N° Orden"
				}, {
					title: " Cliente"
				}, {
					title: " Empleado"
				}, {
					title: " Forma Entrega"
				}, {
					title: " Hora Entrega"
				},{
					title: " Metodo Pago"
				}, {
					title: " Items"
				},{
					title: " Precio"
				},{
					title: " Estado"
				}, {
					title: " "
				}];
				lisPedidoLocal = [];
				var body = {
					funcion: "listarPedidos",
					idsucursal: idsucursal,
					fecini: fecini,
					fecfin: fecfin
				};
				Empresa.rest({
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function(respuesta) {
						var pedidos = respuesta.pedidos;
						for (var i = 0; i < pedidos.length; i++) {
							lisPedidoLocal.push([
								i + 1,
								pedidos[i].FECHA_REGISTRO,
								pedidos[i].BOLETA,
								pedidos[i].NRO_ORDEN,
								pedidos[i].CLIENTE,
								pedidos[i].EMPLEADO,
								crearButtonForma(pedidos[i].FORMA_ENTREGA,pedidos[i].LATITUD,pedidos[i].LONGITUD,pedidos[i].DIRECCION,pedidos[i].INDICACIONES,pedidos[i].MESA),
								crearButtonHora(pedidos[i].PROGRAMAR_ENTREGA,pedidos[i].FECHA_ENTREGA,pedidos[i].HORA_ENTREGA),
								pedidos[i].METODO_PAGO,
								pedidos[i].CANTIDAD,
								pedidos[i].PRECIO_TOTAL,
								pedidos[i].ESTADO,
								''
							]);
						}
						Empresa.inicializarTablaDeDatos({
							selector: ".lisPedidoLocal",
							data: lisPedidoLocal,
							columnas: columnsName
						});
						Empresa.refrescarTablaDeDatos({
							selector: ".lisPedidoLocal",
							data: lisPedidoLocal
						});
						Empresa.hideSpinner();
					},
					funcionError: function(e) {
						Empresa.notificationError("No se cargo correctamente el listado");
						Empresa.hideSpinner();
					}
				});
			}
			function verMapaPedido(lat,lng,dir,ind) {
				$("#mdlDireccion").modal("show");
				mapboxgl.accessToken = 'pk.eyJ1IjoiYW5kcmVldXNkYiIsImEiOiJja2VrcTJ2M2YwZGRoMzFxeG1xYmtvcHJzIn0.eWdITbhyklGEVNiqeqphVw';
				var map = new mapboxgl.Map({
					container: 'myMap',
					style: 'mapbox://styles/mapbox/streets-v11',
					center: [lng, lat],
					zoom: 15
				});
				var marker = new mapboxgl.Marker({
						draggable: true
					})
					.setLngLat([lng, lat])
					.addTo(map);
				$("#dirmap").val(dir);
				$("#indmap").val(ind);
			}
			function imprimirPedido(id) {                           
				Empresa.PopupCenter('print_pedido.php?id='+id+'','IMPRIMIR PEDIDO',400,520);
			}
			// ------------------------- Elementos Utilizados en POS  -------------------------
			function crearButtonQuitarItem(i,j){
				return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Item Ingrediente' onclick='quitarDetalleItem(\"" + i + "\",\"" + j + "\")'><i class='fa fa-trash'></i></button>";
			}
			function crearButtonCambiarItem(i,j,idp,idcat){
				return "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Cambiar Item Ingrediente' onclick='modalDetalleItem(\"" + i + "\",\"" + j + "\",\"" + idp + "\",\"" + idcat + "\")'><i class='fa fa-refresh'></i></button>";
			}
			function crearButtonQuitar(id){
				return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Item Pedido' onclick='quitarDetallePedido(\"" + id + "\")'><i class='fa fa-trash'></i></button>";
			}
			function crearButtonEditar(nom,pos){
				return "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Editar Ingredientes' onclick='verDetalleItem(\"" + nom + "\",\"" + pos + "\")'><i class='fa fa-edit'></i></button>";
			}
			function crearButtonsPedido(id,idsal,estado){
				var btns = "";	
				if(estado=="TERMINADO"){
					btns += "<button class='btn btn-success btn-xs btn-outline' style='font-size:8px' title='Facturar Pedido' onclick='prepararFactura(\"" + id + "\")'><i class='fa fa-calculator'></i></button>";
				}
				if(estado=="COBRADO" || estado=="FACTURADO"){
					btns += "<button class='btn btn-success btn-xs btn-outline' style='font-size:8px' title='imprimir Recibo' onclick='imprimirSalida(\"" + idsal + "\")'><i class='fa fa-print'></i></button>";
				}
				return btns;
			}
			function crearButtonHora(pent,fent,hent){
				var btns = "";
				if (pent == "AHORA MISMO") {
					btns = "<button class='btn btn-warning btn-xs' style='font-size:10px'  title='En Comedor' ><i class='fa fa-clock-o'></i> " + pent +  " </button>";
				}
				if (pent == "PROGRAMAR ENTREGA") {
					btns = "<button class='btn btn-warning btn-outline btn-xs' style='font-size:10px'  title='Para Llevar' ><i class='fa fa-calendar'></i> " + fent + " / " + hent + "</button>";
				}
				return btns;
			}
			function crearButtonForma(fent,lat,lng,dir,ind,mesa){
				var btns = "";
				if (fent == "COMEDOR") {
					btns = "<button class='btn btn-default btn-xs' style='font-size:10px'  title='En Comedor' ><i class='fa fa-cutlery'></i> " + mesa +  " </button>";
				}
				if (fent == "PARA LLEVAR") {
					btns = "<button class='btn btn-info btn-outline btn-xs' style='font-size:10px'  title='Para Llevar' ><i class='fa fa-shopping-cart'></i> " + fent + " </button>";
				}
				if (fent == "RECOGER") {
					btns = "<button class='btn btn-primary btn-outline btn-xs' style='font-size:10px'  title='Recoger En Local' ><i class='fa fa-tags'></i> " + fent + " </button>";
				}
				if (fent == "DELIVERY") {
					btns = " <button class='btn btn-success btn-outline btn-xs' onclick='verMapaPedido(\"" + lat + "\",\"" + lng + "\",\"" + dir + "\",\"" + ind + "\")' style='font-size:10px'  title='Llevar Delivery'><i class='fa fa-car'></i> " + fent + " </button> ";
				}
				return btns;
			}
			function crearImgDet(url,tam) {
				var imgurl = "<img src='img/Producto/"+url+"'  width='"+tam+"' id='imageModel' /> ";
				return imgurl;
			}

			this.initializer();
		</script>
	</body>

	</html>