<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="wrapper wrapper-content ">

				<div class="row ">
					<div class="col-lg-12">
						<div class="ibox float-e-margins ">
							<div class="row">
								<div class="col-lg-9">
									<div class="ibox">	
										<div class="ibox-title">
											<div class="col-md-3">
												<h5>Sucursal : <b id='nomSucursal'></b></h5>
											</div>
											<div class="col-md-2">
												<div id="mostrarsucursal" style="display:none;">
													<select class="form-control" id="selectSucursal" onchange="verInventario();"></select>
												</div>
											</div>
											<div class="col-md-1">
												<label style="text-align: right;">Stock : </label>
											</div>
											<div class="col-md-2">
												<input class="form-control input-sm" type="text" id="stocktotal" disabled>
											</div>
											<div class="col-md-2">
												<select class="pull-right input-sm" id="selectPrecio" onchange="cambiarPrecioVenta(this.value)">
													<option value="1">PRECIO VENTA</option>
													<option value="2">PRECIO MAYOR</option>
													<option value="3">PRECIO ESPECIAL</option>
													<option value="4">PRECIO TOPE</option>
												</select>
											</div>
											<div class="col-md-2">
												<div class="btn-group" style="float:right">
													<button data-toggle="dropdown" class="btn btn-success btn-outline btn-sm dropdown-toggle"> <i class="fa fa-keyboard-o"></i> Atajos <i class="fa fa-caret-down"></i> </button>
													<ul class="dropdown-menu">
														<li><a class="dropdown-item" href="#">(Ctrl + b) Ir Buscar Codigo Barras</a></li>
														<li><a class="dropdown-item" href="#">(Ctrl + s) Ir Buscar NIT/CI</a></li>
														buscarcodigobarras<li><a class="dropdown-item" href="#">(Ctrl + c) Ir Monto Cancelado</a></li>
														<li><a class="dropdown-item" href="#">(Ctrl + f) Facturar Venta </a></li>
														<li><a class="dropdown-item" href="#">(Ctrl + v) Solo Venta</a></li>
													</ul>
												</div>
											</div>
										</div>
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-6" style="font-size:10px;">
													<select class="form-control" id="selectInventario" onchange="agregarItemStock(this,1)" style="width: 100%;" required></select>
												</div>
												<div class="col-md-6" style="font-size:10px;">
													<div class="input-group">
														<input type="text" id="codbar_ven" placeholder="Ingrese codigo de Barras" onkeypress="ingresarCodigo(event)" class="form-control input-sm ven"><span class="input-group-btn"> <button type="button" style="width:35px;" onclick="buscarCodigoBarras()" class="btn btn-info btn-outline btn-sm"><i class="fa fa-search"></i></button></span>
													</div>
												</div>
											</div>

										</div>
										<div class="ibox-title">
											<h5>Detalle Venta </h5><small>( TC : <span id="tcempresa"></span> )</small><span class="pull-right btn btn-primary btn-outline btn-sm"> <i class="fa fa-shopping-cart"></i>(<strong id="itmcantidad">0</strong>) Items</span>
										</div>
										<div class="ibox-content">
											<div class="table-responsive">
												<table class="table table-striped table-bordered table-hover lisPedido" style="font-size:10px;">
												</table>
											</div>
										</div>
									</div>
								</div>

								<div class="col-md-3">
									<div class="ibox">
										<div class="ibox-content">
											<div class="form-horizontal form-label-left">
												<label>Tipo Documento : </label>
												<select class="form-control frm" id="selectTipoDoc" style="width:100%"></select>
												<label class="control-label">CI / NIT: </label>
												<div class="input-group">
													<input type="text" id="nit" placeholder="Ingrese CI o NIT" onkeypress="ingresarNit(event)" class="form-control input-sm ven"><span class="input-group-btn"> <button type="button" style="width:35px;" onclick="buscarNit()" class="btn btn-primary btn-outline btn-sm"><i class="fa fa-search"></i></button></span>
												</div>
												<label class="control-label">Razon Social: <a onclick="editCliente()" class="text-navy"> <b><i class="fa fa-edit"></i> </b></a></label>
												<input type="text" id="rzs" class="form-control ven">
												<div id="dtcli" style="display:none;">
													<label class="control-label">Email: </label>
													<input type="text" id="mail" class="form-control ven">
													<input type="hidden" id="idcli" value="0" class="form-control ven">
													<label class="control-label">Complemento: </label>
													<input type="text" id="cmp" class="form-control ven">
												</div>
												<label class="control-label">Concepto: </label>
												<input type="text" id="concepto_ven" value="-" class="form-control ">
												<label class="control-label">Cantidad: </label>
												<input type="text" value="0" id="cantidad_ven" class="form-control vnt" readonly>
												<label class="control-label">Precio Total</label>
												<input type="text" value="0" id="precio_ven" class="form-control vnt" readonly>
												<label class="control-label">Tipo Pago: </label>
												<select id="selectTipoPago" style="width: 100%;" class="form-control" required></select>
												<label class="control-label">Cancelado: </label>
												<input type="text" value="0" id="cancelado_ven" class="form-control vnt">
												<label class="control-label">Cambio: </label>
												<input type="text" value="0" id="cambio_ven" class="form-control vnt" readonly><br>
												<div class="row">
													<div class="col-md-6">
														<button onclick="procesarFactura()" class="btn btn-block btn-outline  btn-primary"> <i class="fa fa-calculator"></i> Facturar </button>
													</div>
													<div class="col-md-6">
														<button onclick="realizarVenta(0)" class="btn btn-block btn-outline btn-success"> <i class="fa fa-shopping-cart"></i> Vender </button>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newCliente" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Cliente</h4>
							<small> Registro de un nuevo Cliente </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Nombres :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="rzscli" class="form-control col-md-7 col-xs-12 clis">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="telcli" class="form-control col-md-7 col-xs-12 clis">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newCliente();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalImagenes" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-camera"></i> Imagenes del Producto</h4>
							<small>Todas las Imagenes del Producto</small>
						</div>
						<div class="modal-body">
							<form method="post" enctype="multipart/form-data" id="multimediaForm">
								<div class="row">
									<div class="form-group">
										<div class="col-md-2 col-sm-2 col-xs-2">
											<label class="control-label"> Imagenes: </label>
										</div>
										<div class="col-md-8 col-sm-8 col-xs-8">
											<input type="hidden" id="updidpro">
											<input type="file" class="form-control" name="images[]" id="fileInput" onchange="vistaPreviaMultiple() ;" multiple>
										</div>
										<div class="col-md-2 col-sm-2 col-xs-2">
											<button onclick="newImagenes();" class="btn btn-success btn-sm"><i class="fa fa-upload"></i> Subir Imagenes</button>
										</div>
									</div>
								</div><br>
								<div class="row" id="vista-previa"></div>
							</form>
							<div class="row">
								<div class="col-md-12">
									<div class="ibox-content" id="lisimagenes">

									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		$(document).ready(function() {
			$(document).on("keydown", function(e) {
				if (e.ctrlKey && e.key === 'v') {
					e.preventDefault();
					realizarVenta(0);
				}
				if (e.ctrlKey && e.key === 'f') {
					e.preventDefault();
					procesarFactura();
				}
				if (e.ctrlKey && e.key === 'b') {
					e.preventDefault();
					document.getElementById('codbar_ven').focus();
				}
				if (e.ctrlKey && e.key === 'c') {
					e.preventDefault();
					document.getElementById('cancelado_ven').focus();
				}
				if (e.ctrlKey && e.key === 's') {
					e.preventDefault();
					document.getElementById('nit').focus();
				}
				if (e.key === 'Escape') {
					cancelarVenta();
				}
			});
			$("#cancelado_ven").on("input", function() {
				calcularCambio(); // Llamar a la función para calcular el cambio
			});
		});


		var date = new Date();
		var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth() + 1);
		var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
		var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
		var fecini = mes + "-" + Empresa.agregarCero(primerDia);
		var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
		var fechoy = mes + "-" + date.getDate();


		var ids = "<?php echo $ids; ?>";
		var usr = "<?php echo $usr; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var nomPv = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var pedido = [];
		var lisDetalleVenta = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			menuNotificaciones();
			document.getElementById('codbar_ven').focus();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById('tcempresa').innerHTML = tc;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			selectSucursal(ids);
			cargarFechas();
			headerDetalleVenta();
			selectInventario();
			selectTipoPago();
			verificarArqueo();
			stockInventario();
			selectTiposDoc();
			if (idr == '2') {
				$('#mostrarsucursal').show();
			}

		}

		function cargarFechas() {
			$("#mes").val(mes);
			$("#finicio").val(fecini);
			$("#ffin").val(fecfin);
			$("#ffin").val(fecfin);
			var date0 = $('input[id="mes"]');
			var date1 = $('input[id="finicio"]');
			var date2 = $('input[id="ffin"]');
			var hoy = $('input[id="farqueo"]');
			date0.datepicker({
				format: 'yyyy-mm',
				startView: 'months',
				minViewMode: 'months',
				todayHighlight: true,
				autoclose: true,
			});
			date1.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			date2.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			hoy.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
		}

		function cam_inifin(dato) {
			Empresa.cambiarFechas(dato, "#finicio", "#ffin");
			mes = $("#mes").val();
			fecini = $("#finicio").val();
			fecfin = $("#ffin").val();
		}

		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor) {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectSucursal").val(valor);
					$("#selectSucursal").select2();
					$("#selectPrecio").select2();
				}
			});
			ids = valor;
		}

		function selectInventario() {
			Empresa.actualizarSelect({
				selector: "#selectInventario",
				sql: "SELECT i.id_producto as id, CONCAT(p.codigo, ' | ', p.nombre, ' | ', i.lote ) as etiqueta FROM inventario i JOIN producto p ON i.id_producto = p.id_producto WHERE i.cantidad > 0 AND i.estado = 'VERIFICADO' GROUP BY i.id_producto, i.lote",
				callback: function(data) {
					$("#selectInventario").select2({
						placeholder: "Seleccione un producto del inventario.",
						minimumInputLength: 2
					});
				}
			});
			stockInventario();
		}

		function selectTiposDoc() {
			Empresa.actualizarSelect({
				selector: "#selectTipoDoc",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_tipos_documento_identidad",
				callback: function(data) {
					$('#selectTipoDoc').val(1);
					$('#selectTipoDoc').select2();
				}
			});
		}

		function selectTipoPago() {
			Empresa.actualizarSelect({
				selector: "#selectTipoPago",
				sql: "select id_tipo as id, concat(tipo_pago) as etiqueta from tipo_pago",
				callback: function(data) {
					$("#selectTipoPago").val(1);
					$("#selectTipoPago").select2();
				}
			});
		}

		// -------------------------- Ventas ---------------------------- //

		function headerDetalleVenta() {
			var columnsName = [{
				title: "#"
			}, {
				title: "Codigo Barras"
			}, {
				title: "Producto"
			}, {
				title: "Cantidad"
			}, {
				title: "P/U"
			}, {
				title: "SubTotal"
			}, {
				title: "Cambio"
			}, {
				title: ""
			}];
			Empresa.inicializarTablaSinFormato({
				selector: ".lisPedido",
				columnas: columnsName
			});
		}

		function imprimirPos(id) {
			Empresa.PopupCenter('print_pos.php?id=' + id + '', 'IMPRIMIR VENTA', 400, 520);
		}

		function stockInventario() {
			var funcion = "stockInventario";
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: funcion,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var stock = respuesta.stock;
					$("#stocktotal").val(stock.stocktotal);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function buscarCodigoBarras() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var codigob = document.getElementById("codbar_ven").value;
			var funcion = "buscarCodigoBarras";
			var body = {
				funcion: funcion,
				codigob: codigob,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var producto = respuesta.producto;
					Empresa.hideSpinner();
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_MAYOR, producto.PRECIO_ESPECIAL, producto.PRECIO_TOPE, producto.UNIDAD, producto.CANTIDAD, producto.IMAGEN, producto.CODIGO_SIN, producto.CODIGO_ACTIVIDAD, producto.UNIDAD_MEDIDA);
					$("#codbar_ven").val("");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					$("#codbar_ven").val("");
					Empresa.hideSpinner();
				}
			});
		}

		function ingresarCodigo(e) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			if ((keycode >= 48 && keycode <= 57) || (keycode > 64 && keycode < 91) || (keycode >= 96 && keycode <= 123) || keycode == 8 || keycode == 45) {

			} else if (keycode == '13') {
				e.preventDefault();
				buscarCodigoBarras();
			} else {
				e.preventDefault();
			}
		}

		function buscarNit() {
			var nit = document.getElementById("nit").value;
			if (nit === "") {
				$('#nit').val('').focus();
				Empresa.notificationError("No ingreso ningun nit es obligatorio el campo.");
				Empresa.hideSpinner();
				return;
			}
			var body = {
				funcion: "buscarNit",
				cinit: nit
			};
			Empresa.showSpinner();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cliente = respuesta.cliente;
					Empresa.hideSpinner();
					if (cliente == null) {
						toastr.warning('no se encontro ningun nombre relacionado al nit.', '¡Ingrese un nombre por favor!');
						editCliente();
					} else {
						document.getElementById('idcli').value = cliente.id;
						document.getElementById('nit').value = cliente.nitCi;
						document.getElementById('rzs').value = cliente.razonSocial;
						document.getElementById('mail').value = cliente.email;
						document.getElementById('cmp').value = cliente.complemento;
					}

				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			})

		}

		function ingresarNit(e) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			if (keycode >= 48 && keycode <= 57 || keycode == 8) {

			} else if (keycode == '13') {
				e.preventDefault();
				buscarNit();
			} else {
				e.preventDefault();
			}
		}

		function editCliente() {
			var $div = $("#dtcli");
			if ($div.is(":visible")) {
				$div.hide(); // Oculta el div si está visible
			} else {
				$div.show(); // Muestra el div si está oculto
			}
		}

		function calcularCambio() {
			var totalBs = parseFloat($("#precio_ven").val());
			var cancelado = parseFloat($("#cancelado_ven").val());
			if (!isNaN(cancelado) && cancelado >= totalBs) {
				var cambio = cancelado - totalBs;
				$("#cambio_ven").val(cambio.toFixed(2));
			} else {
				$("#cambio_ven").val("0.00");
			}
		}

		function agregarItemStock(selectElement, cantidad) {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}

			var selectedOption = selectElement.options[selectElement.selectedIndex];

			var id = selectedOption.value;
			var text = selectedOption.text;
			var partes = text.split(" | "); 
			var lote = partes[2];
			var funcion = "verificarStock";
			var body = {
				funcion: funcion,
				idproducto: id,
				lote: lote,
				cantidad: cantidad,
				idsucursal: idsucursal,
				iduser: idu
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO_BARRAS, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_MAYOR, producto.PRECIO_ESPECIAL, producto.PRECIO_TOPE, producto.UNIDAD, cantidad, producto.IMAGEN, producto.CODIGO_SIN, producto.CODIGO_ACTIVIDAD, producto.UNIDAD_MEDIDA, producto.LOTE, producto.FECHA_VENCIMIENTO);
					selectInventario();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function agregarItem(idp, codigo, nombre, pcompra, pventa, pmayor, pespecial, ptope, unidad, cantidad, imagen, codsin, codact, unimed, lote, fvencimiento) {
			let codprecio = document.getElementById("selectPrecio").value;
			let pfinal = 0;
			let descuento = 0;

			// Determinar el precio final según el tipo seleccionado
			if (codprecio === '1') pfinal = pventa;
			else if (codprecio === '2') pfinal = pmayor;
			else if (codprecio === '3') pfinal = pespecial;
			else if (codprecio === '4') pfinal = ptope;

			// Calcular el precio total del ítem
			let precbs = Math.floor(pfinal * cantidad * 100) / 100;
			let preciobs = Empresa.financial(precbs, 2);

			// Crear clave única con idp y lote
			let claveUnica = idp + "-" + lote;

			let itemPedido = {
				idp: idp,
				clave: claveUnica,
				codigo: codigo,
				codigop: codigo,
				nombre: nombre,
				producto: nombre,
				pcompra: pcompra,
				pventa: pventa,
				pmayor: pmayor,
				pespecial: pespecial,
				ptope: ptope,
				pfinal: pfinal,
				unidad: unidad,
				cantidad: cantidad,
				imagen: imagen,
				actividad: codact,
				codigosin: codsin,
				descuento: descuento,
				unidadmedida: unimed,
				preciounitario: pfinal,
				preciobs: preciobs,
				lote: lote,
				fvencimiento: fvencimiento
			};


			// Buscar si ya existe un item con la misma clave
			let idExistente = pedido.findIndex(item => item.clave === claveUnica);

			if (idExistente >= 0) {
				console.log("📌 Ya existe el item. Sumando cantidad.");
				pedido[idExistente].cantidad = parseFloat((parseFloat(pedido[idExistente].cantidad) + parseFloat(cantidad)).toFixed(3));
				console.log("🆕 Nueva cantidad:", pedido[idExistente].cantidad);
			} else {
				console.log("🆕 No existe aún. Agregando como nuevo.");
				pedido.push({ ...itemPedido });
			}

			dibujarTabla();
		}



		function quitarArticulo(id) {
			lisDetalleVenta = [];
			var sumtitems = 0;
			var preciototal = 0;
			var sumtprecio = 0;
			var idp = pedido[id].idp;
			pedido.splice(id, 1);

			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "desmarcarLeidosId", 
				idproducto: idp,
				iduser: idu,  
				idsucursal: idsucursal 
			};

			Empresa.showSpinner();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					dibujarTabla(); 
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}


		function itemsCarrito(id, valor) {
			valor = parseFloat(valor);

			if (isNaN(valor) || valor <= 0) 
			{
				Empresa.notificationError("LA CANTIDAD DEBE SER MAYOR A CERO.");
				$('#num' + id).val(pedido[id].cantidad).focus(); 
				return;
			}
			let item = pedido[id];
			let cantidadAnterior = parseFloat(item.cantidad);
			let diferencia = valor - cantidadAnterior;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			if (diferencia === 0) {
				Empresa.notificationError("LA CANTIDAD MINIMA ES 1.");
				$('#num' + id).val(pedido[id].cantidad).focus(); 
				return;
			}

			let body = {
				funcion: "actualizarLeidos",
				idproducto: item.idp,
				lote: item.lote,
				idsucursal: idsucursal,
				iduser: idu,
				valor: valor,
				diferencia: diferencia
			};

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					item.cantidad = valor;
					dibujarTabla();
				},
				funcionError: function (e) {
					$('#num' + id).val(cantidadAnterior).focus(); 
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		
		function actualizarPrecio(e, actual, id, pmax, pmin) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if (keycode >= 46 && keycode <= 57 || keycode == 8) {
			} else if (keycode == '13' || bool == true) {
				actual = parseFloat(actual);
				pmin = parseFloat(pmin);
				if (actual >= pmin) {
					pedido[id].pfinal = actual;
					pedido[id].preciounitario = actual;
					dibujarTabla();
				} else {
					Empresa.notificationError("No se puede modificar el precio menor al precio tope");
					$('#prec' + id).val(pmax).focus();
				}
			} else {
				e.preventDefault();
			}
		}


		function cambiarPrecioVenta(valor) {
			for (var j = 0; j < pedido.length; j++) {
				if (valor == '1') {
					pedido[j].pfinal = pedido[j].pventa;
					pedido[j].preciounitario = pedido[j].pventa;
				}
				if (valor == '2') {
					pedido[j].pfinal = pedido[j].pmayor;
					pedido[j].preciounitario = pedido[j].pmayor;
				}
				if (valor == '3') {
					pedido[j].pfinal = pedido[j].pespecial;
					pedido[j].preciounitario = pedido[j].pespecial;
				}
				if (valor == '4') {
					pedido[j].pfinal = pedido[j].ptope;
					pedido[j].preciounitario = pedido[j].ptope;
				}
			}
			dibujarTabla();
		}

		function cambiarPrecioFila(event, valor, i) {
			valor = parseInt(valor); 
			i = parseInt(i); 

			if (!pedido[i]) return; 

			pedido[i].codprecio = valor;

			if (valor === 1) {
				pedido[i].pfinal = pedido[i].pventa;
				pedido[i].preciounitario = pedido[i].pventa;
			} else if (valor === 2) {
				pedido[i].pfinal = pedido[i].pmayor;
				pedido[i].preciounitario = pedido[i].pmayor;
			} else if (valor === 3) {
				pedido[i].pfinal = pedido[i].pespecial;
				pedido[i].preciounitario = pedido[i].pespecial;
			} else if (valor === 4) {
				pedido[i].pfinal = pedido[i].ptope;
				pedido[i].preciounitario = pedido[i].ptope;
			}

			dibujarTabla();
		}


		function dibujarTabla() {
			lisDetalleVenta = [];
			let sumtitems = 0;
			let sumtprecio = 0;

			for (let i = 0; i < pedido.length; i++) {
				let item = pedido[i];
				let preciototal = parseFloat(item.pfinal) * parseFloat(item.cantidad);

				sumtitems += parseFloat(item.cantidad);
				sumtprecio += preciototal;

				lisDetalleVenta.push([
					"" + (i + 1),
					crearImgDet(item.imagen, "40"),
					item.nombre + " ( " + item.lote + " ) ",
					crearInputCantidad(i, item.cantidad) + " Uds",
					crearInputPrecio(i, item.pfinal, item.ptope) + " Bs.",
					crearInputPrecioSubTotal(i, preciototal) + " Bs.",
					crearSelectPrecio(i, item.codprecio),
					crearButtonQuitar(i)
				]);
			}

			document.getElementById('itmcantidad').innerHTML = Empresa.roundNumber(sumtitems, 3);
			$("#cantidad_ven").val(Empresa.roundNumber(sumtitems, 3));
			$("#precio_ven").val(Empresa.roundNumber(sumtprecio, 2));

			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: lisDetalleVenta
			});
		}

		function realizarVenta(idf) {
			var concepto = document.getElementById("concepto_ven").value;
			var tipopago = $('select[id="selectTipoPago"] option:selected').text();
			var cantidad = document.getElementById("cantidad_ven").value;
			var precio = document.getElementById("precio_ven").value;
			var idcli = document.getElementById("idcli").value;
			var rzs = document.getElementById("rzs").value;
			var nit = document.getElementById("nit").value;
			var cmp = document.getElementById("cmp").value;
			var mail = document.getElementById("mail").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			if (nit === "") {
				$('#nit').focus();
				Empresa.notificationError("El campo NIT es necesario.");
				Empresa.hideSpinner();
				return;
			}
			if (rzs === "") {
				$('#rzs').focus();
				Empresa.notificationError("El campo Razon Social es necesario.");
				Empresa.hideSpinner();
				return;
			}

			if (pedido.length == 0) {
				Empresa.notificationError("No se Puede Realizar esta transaccion si no tiene detalle.");
				Empresa.hideSpinner();
				return;
			}
			pedido.length
			var funcion = "realizarVenta";
			var body = {
				funcion: funcion,
				concepto: concepto,
				precio: precio,
				cantidad: cantidad,
				detalle: pedido,
				idsucursal: idsucursal,
				iduser: idu,
				tipopago: tipopago,
				idcli: idcli,
				rzs: rzs,
				nit: nit,
				cmp: cmp,
				mail: mail,
				idfactura: idf
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var idven = respuesta.idven;
					$("#modalVenta").modal("hide");
					Empresa.notificationSuccess(" Se realizo correctamente la Venta");
					if (idf == 0) {
						imprimirVenta(idven);
					}
					window.location.reload();

				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function procesarFactura() {
			Empresa.showSpinner();
			var rzs = document.getElementById("rzs").value;
			var nit = document.getElementById("nit").value;
			var cmp = document.getElementById("cmp").value;
			var mail = document.getElementById("mail").value;
			var tipodoc = document.getElementById("selectTipoDoc").value;
			if (rzs === "") {
				$('#rzs').focus();
				Empresa.notificationError("El campo Razon Social es necesario.");
				Empresa.hideSpinner();
				return;
			}
			if (nit === "") {
				$('#nit').focus();
				Empresa.notificationError("El campo NIT es necesario.");
				Empresa.hideSpinner();
				return;
			}
			if (mail === "") {
				mail = "farmacia.especializadajg@gmail.com";
			}
			var stbs = document.getElementById("precio_ven").value;
			var dtbs = 0; // Descuento si existe 
			var ttbs = document.getElementById("precio_ven").value;
			var tbs = document.getElementById("precio_ven").value;

			var gift = "0";
			var tarjeta = "0";
			var metodopago = "1";
			var nrocafc = "";
			var fcafc = "";
			var hcafc = "";
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var maestro = {
				ids: ids,
				iduser: idu,
				usr: usr,
				tbs: tbs,
				ttbs: ttbs,
				stbs: stbs,
				dtbs: dtbs,
				gift: gift,
				tarjeta: tarjeta,
				metodopago: metodopago,
				rzs: rzs,
				nit: nit,
				cmp: cmp,
				tipodoc: tipodoc,
				mail: mail,
				nrocafc: nrocafc,
				fcafc: fcafc,
				hcafc: hcafc
			};
			var body = {
				funcion: "procesarFactura",
				maestro: maestro,
				detalle: pedido,
				idven: "0"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var idfac = respuesta.idfac;
					var idcmp = respuesta.idcmp;
					var cuf = respuesta.cuf;
					var tipoEmision = respuesta.tipoEmision;
					var idcli = respuesta.idcli;
					var cdevento = respuesta.cdevento;

					generarFacturaPdf(idfac);
					if (tipoEmision == '1') {
						enviarMailFactura(mail, rzs, nit, cuf);
					} else {
						if (cdevento == '2' || cdevento == '5' || cdevento == '6' || cdevento == '7') {
							enviarMailFactura(mail, rzs, nit, cuf);
						}
					}
					imprimirFacturaTicket(idfac);
					realizarVenta(idfac);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError(e.mensaje);
					x.style.display = 'block';
				}
			});
		}

		function generarFacturaPdf(idfac) {
			var body = {
				funcion: "generarFacturaPdf",
				idfac: idfac
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					var nrofac = respuesta.nrofac;
					Empresa.notificationSuccess('Exito Se genero correctamente el pdf de la factura nro: ' + nrofac);
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function enviarMailFactura(mail, rzs, nit, cuf) {
			var body = {
				funcion: "enviarMailFactura",
				mail: mail,
				rzs: rzs,
				nit: nit,
				cuf: cuf
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.notificationSuccess('Se envio correctamente los datos de la factura al correo: ' + mail + ' del cliente: ' + rzs);
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function resetVenta() {
			lisDetalleVenta = [];
			pedido = [];
			$('.vnt').val("0");
			$('.ven').val("");
			$('#concepto_ven').val("-");
			selectTiposDoc();
			selectTipoPago();
			selectInventario();
			document.getElementById('codbar_ven').focus();
			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: lisDetalleVenta
			});
		}

		function imprimirFacturaTicket(idf) {
			Empresa.PopupCenter('imprimirticket.php?idf=' + idf + '', 'IMPRIMIR FACTURA', 400, 700);
		}

		function financial(x, pos) {
			return Number.parseFloat(x).toFixed(pos);
		}

		function crearSelectPrecio(i, codpre) { 
			return "<select class='pull-right input-sm' id='selectPrecio" + i + "' onchange='cambiarPrecioFila(event, this.value, \"" + i + "\")'><option value='1'" + (codpre==1?" selected":"") + ">PRECIO VENTA</option><option value='2'" + (codpre==2?" selected":"") + ">PRECIO MAYOR</option><option value='3'" + (codpre==3?" selected":"") + ">PRECIO ESPECIAL</option><option value='4'" + (codpre==4?" selected":"") + ">PRECIO TOPE</option></select>"; 
		}

		function crearInputCantidad(id, cantidad) {
			return "<input class='form-control'  style='width: 100px;' id='num" + id + "' onchange='itemsCarrito(\"" + id + "\",this.value)' type='number'  step='1' min='1' value='" + cantidad + "' >";
		}

		function crearInputPrecio(i, precio, ptope) {
			return "<input class='form-control' id='prec" + i + "' size='6' type='text' value='" + precio + "'  onfocusout='actualizarPrecio(event,this.value,\"" + i + "\",\"" + precio + "\",\"" + ptope + "\")'>";;
		}

		function crearButtonQuitar(id) {
			return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Articulo' onclick='quitarArticulo(\"" + id + "\")'><i class='fa fa-trash'></i></button>";
		}

		function crearInputPrecioSubTotal(i, precio) {
			return "<input class='form-control' readonly id='precsubtotal" + i + "' size='5' type='text' value='" + precio + "'>";
		}
		function crearImgDet(url, tam) {
			var imgurl = "<img src='img/Producto/" + url + "'  width='" + tam + "' id='imageModel' /> ";
			return imgurl;
		}

		this.initializer();
	</script>
</body>

</html>