<!DOCTYPE html>
<html>
<head>
    <?php
	include('includes/cabecera.inc');
	?>
</head>
<body class="top-navigation">

    <div id="wrapper">
        <div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom white-bg">
				<nav class="navbar navbar-expand-lg navbar-static-top" role="navigation">
					<div class="col-md-12">
						<div class="navbar-collapse collapse" id="navbar">
							<ul class="nav navbar-nav mr-auto">
								<li class="active">
									<img class="logo-name" width="120px" id="logoempresa" src="">
								</li>
								<li >
									<a title="Sucursal"><span class="btn btn-info btn-xs btn-outline" ><i class="fa fa-home"></i> <span id='nomSucursal'></b></span></a>
								</li>
								<li >
									<a title="Cajero"><span class="btn btn-success btn-xs btn-outline" ><i class="fa fa-vcard"></i> <span id='nomCajero'></span> </span></a>
								</li>
								<li >
									<a title="Mesero"><span class="btn btn-primary btn-xs btn-outline" ><i class="fa fa-user"></i> <span id='nomMesero'></span> </span></a>
								</li>
								<li >
									<a title="Turno"><span class="btn btn-warning btn-xs btn-outline" ><i class="fa fa-calendar"></i> <span id='nroTurno'></span> </span></a>
								</li>
							</ul>
							<ul class="nav navbar-top-links navbar-right">
								<li>
									<a title="Fecha"><span class="btn btn-default btn-xs btn-outline" ><i class="fa fa-calendar"></i> <span id="fechaliteral"></span></span></a>
								</li>
								<li>
									<a title="Salir Sistema" onclick="salirSistema()"><span class="btn btn-danger btn-xs btn-outline" ><i class="fa fa-sign-out"></i> <span> Salir </span> </span></a>
								</li>
							</ul>
						</div>
					</div>
				</nav>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active "> <a id="tablistado" href="#tab-1" onclick="cargarPedidos();"><label class="text-navy" ><i class="fa fa-th"></i> Listado Pedidos </a></label></li>
									<li> <a id="tabarqueo" href="#tab-2" ><label class="text-navy" ><i class="fa fa-money"></i> Arqueo Caja </a></label></li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Pedidos </h5>
														<div class="ibox-tools">
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive" style="font-size:10px;">
															<table class="table table-striped table-bordered table-hover lisPedido">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											
										</div>
										
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalFactura"  role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-calculator"></i> Facturar Pedido </h4>
							<small> Facturar o Cobrar consumo de restaurante. </small>
						</div>
						<div class="modal-body">
							<div class="ibox-title">
								<div class="row">
									<div class="col-md-9">
										<h3 class="text-navy"> Datos <small>(Factura)</small> </h3>
									</div>
									<div class="col-md-3">
										<label>Metodo Pago : </label>
										<select class="form-control frm"  id="selectMetodoPago" onchange="mostrarGiftCard()" style="width:100%" disabled>		
										</select>	
									</div>
								</div>
							</div>
							<div class="ibox-content">
								<div class="row">
									<div class="col-md-9">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-3">
													<label>Tipo Documento : </label>
													<select class="form-control frm"  id="selectTipoDoc" style="width:100%" disabled>		
													</select>
												</div>
												<div class="col-md-3">
													<label>NIT/CI : </label>
													<div class="input-group">
														<input type="text" id="nit" class="form-control frm input-sm"  disabled onkeypress="ingresarNit(event)"  placeholder="Introduzca nit o razon social"><span class="input-group-btn"> <button type="button" disabled id="buscarNit" onclick="buscarNit()" class="btn btn-info btn-sm frm"><i class="fa fa-search"></i></button> </span>
													</div>
												</div>
												<div class="col-md-3">
													<label>Nombres <small>(Razon social)</small> : </label>
													<input type="text" id="rzs" class="form-control frm input-sm" disabled >
												</div>
												<div class="col-md-3">
													<label>Complemento <small>(CI)</small> : </label>
													<input type="text" id="cmp" class="form-control frm input-sm" disabled >
												</div>
											</div>
											<div class="row">
												<div class="col-md-12">
													<label>Correo <small>(electronico)</small> : </label>
													<input type="text" id="mail" class="form-control frm input-sm" disabled>
												</div>
											</div>
										</div>
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<h3 class="text-navy"> Pedido <small>(Detalle)</small> </h3><hr style="border-top: 1px solid white;">
													<table class="table table-striped table-bordered table-hover lisDetalleFactura" >
													</table>
												</div>
												
											</div>
										</div>
									</div>
									<div class="col-md-3">
										<div class="ibox-content">
											<div class="row">
												<h3 class="text-navy" >Facturar<small> (pedido)</small></h3> 
												<label>Total<small>(items)</small> : </label>
												<input type="number"  readonly id="tpar" class="form-control frm input-sm" >
												<input type="hidden"  id="idped" >
												<label>Sub-Total<small>(Bs)</small> : </label>
												<input type="number"  readonly id="stbs" class="form-control frm input-sm" >
												<label>Descuento <small>(Bs)</small> : </label>
												<input type="text" id="dtbs" onfocusout="recalcularDescuento(this.value)" value="0" class="form-control input-sm" disabled >
												<label>Total <small>(Bs)</small> : </label>
												<input type="text" id="ttbs" class="form-control input-sm" disabled >
												<div style ="display:none;" id ="giftcard"><label>Monto <small>(Gift Card)</small> : </label>
												<input type="text" id="gift" value="0" class="form-control frm input-sm" onfocusout="recalcularGiftCard(this.value)" disabled ></div>
												<div style ="display:none;"  id ="tarjeta"><label>Codigo <small>(Tarjeta)</small> : </label>
												<input type="hidden" value="0" id="tarjetacred">
												<input type="text" class="form-control frm" id="nrotarjeta" maxlength="16" placeholder="************9999" onkeydown="setTimeout('mascaraTarjeta(\'nrotarjeta\',\'tarjetacred\',false);',10)" autocomplete="off"></div>
												<label>Total Base Credito Fiscal<small>(Bs)</small> : </label>
												<input type="number"  readonly id="tbs" class="form-control frm input-sm" >
												<div style="display:none;">
													<label>Credito Fiscal<small>(Bs)</small> : </label>
													<input type="text"  readonly id="tcf" class="form-control frm input-sm" disabled>
												</div>
												<div id="procesarF" style="display:none;">
													<button class="btn btn-primary btn-block btn-sm" onclick="procesarFactura()"><i class="fa fa-usd"></i> Facturar </button>
												</div>
												
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
							
					</div>
				</div>
			</div>
			<div class="footer ">
				<div class="col-md-12">
					<?php
						include('includes/footer.inc');
					?>
				</div>
			</div>

        </div>
    </div>
	<?php
		include('includes/pie.inc');
	?>
	<script>

		var idu = "<?php echo $idu;?>";
		var ids = "<?php echo $ids;?>";
		var ida = "<?php echo $ida;?>";
		var ide = "<?php echo $ide;?>";
		var idm = "<?php echo $idm;?>";
		var usr = "<?php echo $usr;?>";
		var caj = "<?php echo $caj;?>";
		var mso = "<?php echo $mso;?>";
		var suc = "<?php echo $suc;?>";
		var tur = "<?php echo $tur;?>";
		
		var lisPedido = [];  
		var lisDetalleFactura = []; var lisNewFactura = []; 
	
		function initializer() {
			cargarDatosEmpresa(); obtenerFechaLiteral();
			document.getElementById('nomSucursal').innerHTML = suc;
			document.getElementById('nomCajero').innerHTML = caj;
			document.getElementById('nomMesero').innerHTML = mso;
			document.getElementById('nroTurno').innerHTML = "Turno : " + tur;
			headerDetalleFactura() ; verificarArqueo();
			cargarPedidos(); 
			selectTiposDoc(); selectMetodosPago();			
		}
		
		// -------------------------- Cargar Selects ---------------------------- //
		function selectTiposDoc() {
			var funcion = "listarTiposDocumento";
			var body = { funcion: funcion};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var tipos = respuesta.tipos;
					var selectTipoDoc = $('#selectTipoDoc');
					selectTipoDoc.empty();
					selectTipoDoc.append('<option value=""> Seleccione una opcion </option>');
					tipos.forEach(function(tipo) {
						selectTipoDoc.append(`<option value="${tipo.codigo}">${tipo.descripcion}</option>`);
					});
					selectTipoDoc.val(1);
					selectTipoDoc.select2();
				}
			}); 
		}
		function selectMetodosPago() {
			var funcion = "listarMetodosPago";
			var body = { funcion: funcion};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var tipos = respuesta.tipos;
					var selectMetodoPago = $('#selectMetodoPago');
					selectMetodoPago.empty();
					selectMetodoPago.append('<option value=""> Seleccione una opcion </option>');
					tipos.forEach(function(tipo) {
						selectMetodoPago.append(`<option value="${tipo.codigo}">${tipo.descripcion}</option>`);
					});
					selectMetodoPago.val(1);
					selectMetodoPago.select2();
				}
			}); 
		}
		function verificarArqueo(){

			var funcion = "verificarArqueo";
			var body = { funcion: funcion, idcajero: ide};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var band = respuesta.band;;
					if(band == 1){
						swal({
							title: "Arqueo No Iniciado",
							text: "Por Favor Inicie Arqueo Antes de comenzar.",
							type: "error",
							showCancelButton: true,
							confirmButtonClass: "btn-danger",
							confirmButtonText: "Aceptar",
							cancelButtonText: "Cancelar",
							closeOnConfirm: false,
							closeOnCancel: false
							},
							function(isConfirm) {
							if (isConfirm) {
								swal.close();
								window.location="index";  
							} else {
								swal.close();	
							}
						});
					}
				},
				funcionError: function (e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});			
		}
		// -------------------------- Pedidos ---------------------------- //
		function cargarPedidos(){
			Empresa.showSpinner();
			$('#tablistado').tab('show');
			var columnsName = [{title: "#"},{title: " Fecha"},{title: " Nro Pedido"},{title: " Mesero"}, {title: " Ambiente"},{title: " Mesa"},{title: " Tipo Entrega"},{title: " Estado"},{title: " "}];
			lisPedido = [];
			var body = { funcion: "listarPedidos"};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var pedidos = respuesta.pedidos;				
					for (var i = 0; i < pedidos.length; i++) {
						lisPedido.push([
							i+1,
							pedidos[i].FECHA,
							pedidos[i].NRO_ORDEN,
							pedidos[i].NOMBRE,
							pedidos[i].AMBIENTE,
							pedidos[i].NRO_MESA,
							pedidos[i].TIPO_ENTREGA,
							pedidos[i].ESTADO,
							crearButtonsPedido(pedidos[i].ID,pedidos[i].ID_SALIDA,pedidos[i].ESTADO)
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisPedido",
						data: lisPedido,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisPedido",
						data: lisPedido
					});
					Empresa.hideSpinner();
				},
				funcionError: function (e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}
		// -------------------------- Detalle Factura ---------------------------- //
		function headerDetalleFactura() {
			var columnsName = [
				{title: "#"},
				{title: "Codigo"},
				{title: "Cantidad"},
				{title: "Descripcion"},					
				{title: "PrecioUnitario"},
				{title: "Descuento"},
				{title: "Subtotal"}
			];
			Empresa.inicializarTablaSinFormato({
				selector: ".lisDetalleFactura",
				data: lisDetalleFactura,
				columnas: columnsName
			});
		}
		function prepararFactura(id) {
			lisNewFactura = [];
			$("#idped").val(id);
			var body = { funcion: "prepararFactura", idpedido: id};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var detalle = respuesta.detalle;
					var pedido = respuesta.pedido;
					$("#modalFactura").modal("show");
					$('#mail').focus();
					for (var i = 0; i < detalle.length; i++) {

						var codact = detalle[i].actividadEconomica;
						var codsin = detalle[i].codigoProductoSin;
						var codigo = detalle[i].CodigoProducto;
						var producto = detalle[i].descripcion;
						var idp = detalle[i].CodigoProducto;
						var precio = detalle[i].precioUnitario;
						var cantidad = detalle[i].cantidad;
						var descuento = 0;
						var unimed = detalle[i].unidadMedida;
						var precbs = Math.floor(precio*cantidad * 100)/100;
						var preciobs = Empresa.number_format(precbs,2) ;
						
						var item = {actividad: codact, codigosin: codsin, codigop: codigo, producto: producto, idproducto: idp, preciounitario: precio, cantidad: cantidad, unidadmedida: unimed, preciobs: preciobs, descuento: descuento};
						lisNewFactura.push(item);
					}
					var sumtcantidad = 0;
					var sumtprecio = 0; var sumtdescuento = 0;
					var x = document.getElementById('procesarF');
					x.style.display = 'block';
					$('.frm').prop('disabled', false);
					for (var i = 0; i < lisNewFactura.length; i++){ 
						sumtprecio = parseFloat(sumtprecio) + parseFloat(lisNewFactura[i].preciobs);
						sumtcantidad = parseFloat(sumtcantidad) + parseFloat(lisNewFactura[i].cantidad);
						lisDetalleFactura.push([
							i+1,
							lisNewFactura[i].codigop,
							lisNewFactura[i].cantidad,
							lisNewFactura[i].producto,
							lisNewFactura[i].preciounitario+ " Bs.",
							lisNewFactura[i].descuento+ " Bs.",
							lisNewFactura[i].preciobs
						]);
					};
					Empresa.refrescarTablaDeDatos({
						selector: ".lisDetalleFactura",
						data: lisDetalleFactura
					});
					sumtdescuento = parseFloat(sumtprecio);
					$("#stbs").val(Empresa.financial(sumtprecio,2));
					$("#dtbs").val(0);
					$("#ttbs").val(Empresa.financial(sumtdescuento,2));
					$("#tbs").val(Empresa.financial(sumtdescuento,2));
					$("#tcf").val(Empresa.financial((sumtdescuento)*0.13,2));
					$("#tpar").val(Empresa.financial(sumtcantidad,0));
				},
				funcionError: function (e) {
					Empresa.notificationError("No se cargo correctamente el listado");
				}
			});
		}
		function mostrarGiftCard() {
    		var x = document.getElementById("giftcard");
    		var y = document.getElementById("tarjeta");
			var combo = document.getElementById("selectMetodoPago");
			var cadena = combo.options[combo.selectedIndex].text;
			let gift = "GIFT-CARD";let gift1 = "GIFT CARD";
			let tarj = "TARJETA";
			// para buscar la palabra hacemos
			let posicion = cadena.indexOf(gift);
			let posicion1 = cadena.indexOf(gift1);
			let pos = cadena.indexOf(tarj);
		   	if (posicion !== -1 || posicion1 !== -1){
		   		x.style.display = "block";
				if(pos !== -1){
		   			y.style.display = "block";	
		   		}else{
		   			y.style.display = "none";
		   		}
		   	}else{
		   		x.style.display = "none";
		   		if(pos !== -1){
		   			y.style.display = "block";	
		   		}else{
		   			y.style.display = "none";
		   		}
		   	}
		}
		function recalcularGiftCard(valor){
			var stbs = document.getElementById("stbs").value;
			var dtbs = document.getElementById("dtbs").value;
			var tbs = document.getElementById("tbs").value;
			var stot = financial(stbs - valor - dtbs,2);
			document.getElementById('tbs').value = stot;
			
		}
		function recalcularDescuento(valor){
			var stbs = document.getElementById("stbs").value;
			var gift = document.getElementById("gift").value;
			var tbs = document.getElementById("tbs").value;
			var stot = financial(stbs - valor - gift,2);
			var stot1 = financial(stbs - valor ,2);
			if(stot > 0 ){
				document.getElementById('tbs').value = stot;
				document.getElementById('ttbs').value = stot;
			}else{
				$('#tbs').val(financial(stbs - 0 - gift,2));
				Empresa.notificationError("No puede haber un descuento mayor al precio total de la venta.");
				$('#dtbs').val("0");
				$('#dtbs').focus();
			}
		}
		function ingresarNit(e){
			var keycode = (e.keyCode ? e.keyCode : e.which);
			if (keycode >= 48 && keycode <= 57 || keycode == 8) {
			
			}else if (keycode == '13' ){
				e.preventDefault();
				buscarNit();
			}else{
				e.preventDefault();
			}
		}
		function buscarNit(){
			var nit = document.getElementById("nit").value;
			if(nit === ""){
				$('#nit').val('').focus();
				Empresa.notificationError("No ingreso ningun nit es obligatorio el campo.");
				Empresa.hideSpinner();
				return;
			}
			var body = {funcion: "buscarNit", cinit:nit};
			
			Empresa.rest(
			{
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) 
				{
					var cliente = respuesta.cliente;
					var filas = respuesta.filas;
					if(filas > 0){
						document.getElementById('rzs').value = cliente.RAZON;
						document.getElementById('mail').value = cliente.EMAIL;
						document.getElementById('cmp').value = cliente.COMPLEMENTO;	
					}else{
						toastr.warning('no se encontro ningun nombre relacionado al nit.', '¡Ingrese un nombre por favor!');
					}
					
				}
			})

		}
		function procesarFactura() {
			var rzs = document.getElementById("rzs").value;
			var nit = document.getElementById("nit").value;
			var cmp = document.getElementById("cmp").value;
			var mail = document.getElementById("mail").value;
			var idpedido = document.getElementById("idped").value;
			var tipodoc = document.getElementById("selectTipoDoc").value
			if(rzs === "null"){
				$('#rzs').focus();
				Empresa.notificationError("El campo Razon Social es necesario.");
				return;
			}
			if(nit === ""){
				$('#nit').focus();
				Empresa.notificationError("El campo NIT es necesario.");
				return;
			}	
	
			var x = document.getElementById('procesarF');
			x.style.display = 'none';
			var tcantidad = document.getElementById("tpar").value;
			var tbs = document.getElementById("tbs").value;
			var stbs = document.getElementById("stbs").value;
			var dtbs = document.getElementById("dtbs").value;
			var gift = document.getElementById("gift").value;
			var tarjeta = document.getElementById("tarjetacred").value;
			var metodopago = document.getElementById("selectMetodoPago").value;

			var maestro = {ids: ids, usr: usr, tcantidad: tcantidad, tbs: tbs, stbs: stbs, dtbs: dtbs, gift: gift, tarjeta: tarjeta, metodopago: metodopago,  rzs: rzs, nit: nit, cmp: cmp, tipodoc: tipodoc, mail: mail};
			var body = { funcion: "procesarFactura", maestro: maestro, detalle: lisNewFactura, idpedido: idpedido};				
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					Empresa.hideSpinner();
					var idsalida = respuesta.idsalida;
					var factura = respuesta.factura;
					Empresa.notificationSuccess('Exito se proceso correctamente la transaccion.');
					//imprimirSalida(idsalida);
					generarFacturaPdf(idsalida);
					setTimeout(function() {imprimirFactura(factura);}, 2000);
					setTimeout(function() {location. reload()}, 3000);
				},
				funcionError: function (e) {
					Empresa.notificationError(e.mensaje);
					x.style.display = 'block';
					Empresa.hideSpinner();
				}
			});
		}
		function imprimirSalida(id) {                           
			Empresa.PopupCenter('print_salida.php?id='+id+'','IMPRIMIR RECIBO',400,520);
		}
		function imprimirFactura(factura) {                           
			Empresa.PopupCenter('print_factura.php?fac='+factura+'','IMPRIMIR FACTURA',400,520);
		}
		function generarFacturaPdf(idsalida) {
			var body = { funcion: "generarFacturaPdf" , idsalida: idsalida};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var nrofac = respuesta.nrofac;
					Empresa.notificationSuccess('Exito Se genero correctamente el pdf de la factura nro: '+nrofac);
				},
				funcionError: function (e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		function enviarMailFactura(mail,rzs,nit,cuf) {
			var body = { funcion: "enviarMailFactura" , mail: mail, rzs: rzs, nit: nit, cuf: cuf};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function (respuesta) {
					Empresa.notificationSuccess('Se envio correctamente los datos de la factura al correo: '+mail+' del cliente: '+rzs);
				},
				funcionError: function (e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		function reEnviarMailFactura(mail,rzs,nit,cuf) {
			swal({
				title: "Reenviar Factura",
				text: "Desea reenviar correo de esta factura.",
				type: "warning",
				showCancelButton: true,
				confirmButtonClass: "btn-warning",
				confirmButtonText: "Enviar",
				cancelButtonText: "Cancelar",
				closeOnConfirm: false,
				closeOnCancel: false
			},
			function(isConfirm) {
				if (isConfirm) {
					swal.close();
					enviarMailFactura(mail,rzs,nit,cuf);	
				} else {
					swal.close();	
				}
			});
		}
		function cancelarVenta(){
			lisDetalleFactura = [];
			lisNewFactura = [];
			$('.frm').val('');
			$('.frm').prop('disabled',true);
			$('#dtbs').val('0');$('#tarjetacred').val('0');$('#gift').val('0');
			var x = document.getElementById('tarjeta');
			x.style.display = "none";
			var y = document.getElementById('giftcard');
			y.style.display = "none";
			selectTiposDoc();
			selectMetodoPago();
			selectProducto();
			Empresa.refrescarTablaDeDatos({  
				selector: ".lisDetalleFactura",
				data: lisDetalleFactura
			});
		}
		function imprimirFacturaTicket(idf){
			Empresa.PopupCenter('imprimirticket.php?idf='+idf+'','IMPRIMIR FACTURA',340,700);
		}

		function imprimirReporte(){
			var cabeza = "";
			var pie = "";
			var url = Empresa.armarUrl("venta.php");
			var div = '#tab-3';
			Empresa.impDiv(div,url,cabeza,pie);
		}
		$(document).ready(function() {
			$('#nrotarjeta').keydown(function(event) {
				var validarNumer = /^([0-9*]{16,16})*$/;
				if (!$('#tarjetacred').val().match(validarNumer)) {
					this.value = (this.value + '').replace(/[^0-9*]/g, '');
				}
			});	
		});

		function mascaraTarjeta(CampoMask, CampoHidd, bolDes) {
			var iniAnt, mskCar;
			var tempBull = "1999";
			var objCMask = document.getElementById(CampoMask);
			var objCHidd = document.getElementById(CampoHidd);
			var tempValIni = "";
			var tempValFin = "";
			var LognMask = objCMask.value.length;
			var CaulBol = bolDes ? LognMask : (LognMask - 1);
			var tamMask = objCMask.getAttribute("maxlength") > 4 ? ((objCMask.getAttribute("maxlength")) - 4) : 2000000;
			for (x = 0; x < LognMask; x++) {
				mskCar = objCMask.value.charAt(x);
				iniAnt = objCHidd.value.charAt(x);
				if (mskCar != unescape('%2A')) {
					tempValIni += mskCar;
					if (x < tamMask && x != CaulBol) {
						tempValFin += unescape('%2A');
					} else {
						tempValFin += mskCar;
					}
				} else {
					tempValIni += iniAnt;
					if (iniAnt != "") {
						if (x < tamMask) {
							tempValFin += unescape('%2A');
						} else {
							tempValFin += iniAnt;
						}
					}
				}
			}
			objCHidd.value = tempValIni;
			objCMask.value = "";
			objCMask.value = tempValFin;
		}
		function crearButtonsPedido(id,idsal,estado){
			var btns = "";	
			if(estado=="TERMINADO"){
				btns += "<button class='btn btn-success btn-xs btn-outline' style='font-size:8px' title='Facturar Pedido' onclick='prepararFactura(\"" + id + "\")'><i class='fa fa-calculator'></i></button>";
			}
			if(estado=="COBRADO" || estado=="FACTURADO"){
				btns += "<button class='btn btn-success btn-xs btn-outline' style='font-size:8px' title='imprimir Recibo' onclick='imprimirSalida(\"" + idsal + "\")'><i class='fa fa-print'></i></button>";
			}
			return btns;
		}

		
		this.initializer();		
	</script>
</body>
</html>