<html>
<head>
    <?php
	include('includes/cabecera.inc');
	?>
</head>
<body class="top-navigation">

    <div id="wrapper">
        <div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom white-bg">
				<nav class="navbar navbar-expand-lg navbar-static-top" role="navigation">
					<div class="col-md-12">
						<div class="navbar-collapse collapse" id="navbar">
							<ul class="nav navbar-nav mr-auto">
								<li class="active">
									<img class="logo-name" width="120px" id="logoempresa" src="">
								</li>
								<li >
									<a title="Sucursal"><span class="btn btn-info btn-xs btn-outline" ><i class="fa fa-home"></i> <span id='nomSucursal'></b></span></a>
								</li>
								<li >
									<a title="Cajero"><span class="btn btn-success btn-xs btn-outline" ><i class="fa fa-vcard"></i> <span id='nomCajero'></span> </span></a>
								</li>
								<li >
									<a title="Mesero"><span class="btn btn-primary btn-xs btn-outline" ><i class="fa fa-user"></i> <span id='nomMesero'></span> </span></a>
								</li>
								<li >
									<a title="Turno"><span class="btn btn-warning btn-xs btn-outline" ><i class="fa fa-calendar"></i> <span id='nroTurno'></span> </span></a>
								</li>
							</ul>
							<ul class="nav navbar-top-links navbar-right">
								<li>
									<a title="Fecha"><span class="btn btn-default btn-xs btn-outline" ><i class="fa fa-calendar"></i> <span id="fechaliteral"></span></span></a>
								</li>
								<li>
									<a title="Salir Sistema" onclick="salirSistema()"><span class="btn btn-danger btn-xs btn-outline" ><i class="fa fa-sign-out"></i> <span> Salir </span> </span></a>
								</li>
							</ul>
						</div>
					</div>
				</nav>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs" id="tabheader">
									
								</ul>
								<div class="tab-content" id="tabbody">
									
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalPin" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-check"></i> Asignar Mesero </h4>
							<small>Ingresa tu pin para acceder al pedido.</small>
						</div>
						<div class="modal-body" style="display: flex; justify-content: center; align-items: center;">
						    <div class="row">
								<div class="calculator">
									<input type="text" id="pinmesero" readonly>
									<input type="hidden" id="updidmesa" >
									<button class="btn btn-success btn-outline" onclick="appendToResult('7')">7</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('8')">8</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('9')">9</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('4')">4</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('5')">5</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('6')">6</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('1')">1</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('2')">2</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('3')">3</button>
									<button class="btn btn-danger btn-outline" onclick="clearResult()">Borrar</button>
									<button class="btn btn-success btn-outline" onclick="appendToResult('0')">0</button>
									<button class="btn btn-primary btn-outline" onclick="verificarPin()">Aceptar</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalPedido" tabindex="-1" role="dialog" aria-hidden="true" >
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
					
						<div class="modal-body">
							<div class="row">
								<div class="col-md-3">
									N° ORDEN : <b style="color:#1ab394" id="nropedido"></b>
								</div>
								<div class="col-md-6"  style="display: flex; justify-content: center; align-items: center;">
									<ol class="breadcrumb">
										<li class="breadcrumb-item">
											<a><i class="fa fa-clock-o"></i> <b> Turno: </b> <span id="turpos"> Noche</span></a>
										</li>
										<li class="breadcrumb-item">
											<a><i class="fa fa-user-circle"></i> <b> Cajero: </b><span id="cajpos"> Admin </span></a>
										</li>
										<li class="breadcrumb-item ">
											<a><i class="fa fa-user"></i> <b> Mesero: </b><span id="mespos"> Andree </span></a>
										</li>
										<li class="breadcrumb-item ">
											<a><i class="fa fa-home"></i> <b> Sucursal: </b><span id="sucpos"> Matriz </span></a>
										</li>
									</ol>
								</div>
								<div class="col-md-3">
									<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
								</div>
								
							</div><hr style="border: 0; height: 0; box-shadow: 0 1px 1px 1px #1ab394;">
							<div class="row">
								<div class="col-sm-7">
									<div class="ibox">
										<div class="col-md-12">
											<div class="cont-horizontal" id="catpos" style="display: flex; overflow-x: scroll; font-size:8px; height: 120px;">
												
											</div>
										</div>
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12" style="font-size:10px;">
													<select  class="form-control" id="selectProducto" onchange="agregarItemStock(this.value,1)"  style="width: 100%;"  required></select>
												</div>
											</div><hr>
											<div class="row">
												<div class="col-md-12 cont-horizontal" id="mosaico" style="font-size:8px; max-height: 450px; overflow-y: scroll;"></div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-5">

									<div class="ibox">
										<div class="ibox-title">
											<span class="pull-right btn btn-primary btn-outline btn-sm"> <i class="fa fa-shopping-cart" ></i>(<strong id="itmcantidad">0</strong>) Items</span>
											<h5>Detalle Pedido <small></small></h5>
										</div>
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12 cont-horizontal" style="font-size:8px; height: 450px; overflow-y: scroll;">
													<table class="table table-striped table-bordered table-hover lisPedido" style="font-size:10px;">
													</table>
												</div>
											</div>
										</div>
										<div class="ibox-content">
											<div class="row" >
												<div class="col-sm-6">
													<label class="control-label">Cantidad: </label>
													<input type="text" value="0" id="cantidad_ped" class="form-control input-sm peds" readonly>
													<input type="hidden"  id="updidpedido" class="form-control">
												</div>
												<div class="col-sm-6">
													<label class="control-label">Precio Total</label>
													<input type="text" value="0"  id="precio_ped" class="form-control input-sm peds" readonly>
												</div>
											</div><br>
											<div class="row" >
												<div class="col-sm-6">
													<button onclick="terminarPedido()" class="btn btn-sm btn-primary btn-block"> <i class="fa fa-check"></i> Terminar Pedido </button>
												</div>
												<div class="col-sm-6">
												<button onclick="enviarPedido()" disabled class="btn btn-sm btn-success btn-block peds"><i class="fa fa-send"></i> Enviar Comandas </button>
												</div>
											</div>	
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalItem" tabindex="-1" role="dialog" aria-hidden="true" >
				<div class="modal-dialog modal-md">
					<div class="modal-content animated bounceInRight">
					
						<div class="modal-body">
							<div class="row">
								<div class="col-md-10">
									Receta del producto <b style="color:#1ab394;" id="nomprditm"> </b>
								</div>
								
								<div class="col-md-2">
									<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
								</div>
							</div><hr style="border: 0; height: 0; box-shadow: 0 1px 1px 1px #1ab394;">
							<div class="row">
								<div class="col-sm-7">
									<div class="ibox">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12 cont-horizontal" id="itmcat" style="font-size:8px; max-height: 350px; overflow-y: scroll;"></div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-5">
									<div class="ibox">
										<div class="ibox-content">
											<div class="row" id="tablesitem">
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalTerminarPedido" tabindex="-1" role="dialog" aria-hidden="true" >
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-check"></i> Terminar Pedido Mesa : <b style="color:#1ab394" id="nromesa"></b></h4>
							<small> Se pasara directo al correspondiente del consumo de la mesa.</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal" >
								<div class="form-group">  
								  <div class="col-xs-12">
								  	<label class="control-label "> CI/NIT: </label>
								    <div class="input-group">
										<input type="text" id="nit" class="form-control input-sm" onkeypress="ingresarNit(event)"  placeholder="Introduzca nit o razon social"><span class="input-group-btn"> <button type="button" id="buscarNit" onclick="buscarNit()" class="btn btn-info btn-sm frm"><i class="fa fa-search"></i></button> </span>
									</div>
								  </div>
								</div>
								<div class="form-group">  
								  <div class="col-xs-12">
								  	<label class="control-label"> Nombres <small>(Razon social)</small> :</label>
								  	<input type="text" id="rzs" class="form-control input-sm">
								  </div>
								</div>
								<div class="form-group">  
								  <div class="col-xs-12">
								    <label class="control-label"> Complemento <small>(CI)</small> : </label>
								  	<input type="text" id="cmp" class="form-control input-sm">
								  </div>
								</div>
								<div class="form-group">  
								  <div class="col-xs-12">
								  	<label class="control-label"> Correo <small>(electronico)</small> : </label>
								  	<input type="text" id="mail" class="form-control input-sm" >
								  </div>
								</div>									
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="terminarPedido();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Terminar Pedido </button>
						</div>
					</div>
				</div>
			</div>
			<div class="footer ">
				<div class="col-md-12">
					<?php
						include('includes/footer.inc');
					?>
				</div>
			</div>

        </div>
    </div>
	<?php
		include('includes/pie.inc');
	?>
	<script>
		var idu = "<?php echo $idu;?>";
		var ids = "<?php echo $ids;?>";
		var ida = "<?php echo $ida;?>";
		var ide = "<?php echo $ide;?>";
		var idm = "<?php echo $idm;?>";
		var usr = "<?php echo $usr;?>";
		var caj = "<?php echo $caj;?>";
		var mso = "<?php echo $mso;?>";
		var suc = "<?php echo $suc;?>";
		var tur = "<?php echo $tur;?>";
		
		var lisPedido = [];  
		var lisDetalleFactura = []; var lisNewFactura = []; 
	
		function initializer() {
			//cargarDatosEmpresa(); 
			obtenerFechaLiteral();
			document.getElementById('nomSucursal').innerHTML = suc;
			document.getElementById('nomCajero').innerHTML = caj;
			document.getElementById('nomMesero').innerHTML = mso;
			document.getElementById('nroTurno').innerHTML = "Turno : " + tur;
			headerDetallePedido(); 
			cargarAmbientes(); cargarCategorias();	
			selectProductos(); 
					
		}
		// -------------------------- Headers ---------------------------- //
		function headerDetallePedido() {
			var columnsName = [{title: "#"},{title: "Imagen"},{title: "Producto"},{title: "Cantidad"},{title: "P/U"},{title: "SubTotal"},{title: ""}];
			Empresa.inicializarTablaSinFormato({
				selector: ".lisPedido",
				columnas: columnsName
			});
		}
		function headerItemPedido() {
			var columnsName = [{title: "#"},{title: "Producto"},{title: "U/M"},{title: "Cantidad"},{title: "SubTotal"},{title: ""},{title: ""}];
			Empresa.inicializarTablaSinFormato({
				selector: ".lisItem",
				columnas: columnsName
			});
		}
		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor){
		    Empresa.actualizarSelect({
			selector: "#selectSucursal",
			sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
			callback: function (data) {
				$("#selectSucursal").val(valor);
				$("#selectSucursal").select2();
			}
		   });
		   ids = valor;
		}
		function selectProductos() {
			var funcion = "listarProductos";
			var body = { funcion: funcion};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var productos = respuesta.productos.data;
					var selectProducto = $('#selectProducto');
					selectProducto.empty();
					selectProducto.append('<option value=""> Busque por el nombre el item que desea pedir. </option>');
					productos.forEach(function(producto) {
						selectProducto.append(`<option value="${producto.ID_PRODUCTO}">${producto.PRODUCTO}</option>`);
					});
					selectProducto.select2();
				}
			}); 
		}
		function selectClientes() {
			var funcion = "listarClientes";
			var body = { funcion: funcion};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var clientes = respuesta.clientes;
					var selectCliente = $('#selectCliente');
					selectCliente.empty();
					selectCliente.append('<option value="">Busque por el nombre el item que desea pedir.</option>');
					clientes.forEach(function(cliente) {
						selectCliente.append(`<option value="${cliente.id}">${cliente.nombre}</option>`);
					});
					selectCliente.select2();
				}
			}); 
		}
		// -------------------------- Ambientes  ------------------------------
		function cargarCategorias() {
			Empresa.showSpinner();
			var funcion = "listarCategorias";
			var body = { funcion: funcion, idsucursal: ids };
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var categorias = respuesta.categorias.data;
					var cat = $('#catpos');  
					cat.hide();cat.empty();
					for (var i = 0; i < categorias.length; i++) {
						if(i==0){
							cargarProductosCategoria(categorias[i].CATEGORIA);
						}
						var item = "<div class='col-md-3'><div class='col-md-12' style='width:100px; height: 100px; border: solid #f3f3f4;'><div class='m-t-xs font-bold'> <span class='badge badge-primary pull-right' > "+categorias[i].CANTIDAD+" </span></div><div class='text-center'><a onclick='cargarProductosCategoria(\"" + categorias[i].CATEGORIA + "\")'><img   width='55px' height='40px' src='img/categoria/"+categorias[i].IMAGEN+"' ><div class='m-t-xs font-bold'>"+categorias[i].CATEGORIA+"</div></a></div></div></div>";
						cat.append(item);
						cat.show(); 	
					}	
					Empresa.hideSpinner();
					
				},
				funcionError: function (e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		// -------------------------- Ambientes  ------------------------------
		function cargarAmbientes(){
			Empresa.showSpinner();
			var funcion = "listarAmbientes";
			var body = { funcion: funcion , idsucursal: ids};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var ambientes = respuesta.ambientes;
					var tabh = $('#tabheader'); tabh.hide();tabh.empty();
					var tabb = $('#tabbody'); tabb.hide();tabb.empty();
					for (var i = 0; i < ambientes.length; i++) {
						var btnmesa = '';
						var nmesa = ambientes[i].DATOS.data;
						if(i==0){
							var itemh = "<li class='active'> <a data-toggle='tab' id='tabamb"+i+"' href='#tab"+i+"' ><label class='text-navy' ><i class='fa fa-home'></i> "+ambientes[i].AMBIENTE+" </a></label></li>";
							var itemb = "<div id='tab"+i+"' class='tab-pane active'><div class='ibox-content'><div class='row'><div class='col-md-4'><div class='ibox-title'><h5> Datos Ambiente </h5></div><div class='ibox-content'><div class='form-horizontal form-label-left'><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Codigo:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].CODIGO+"' class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Ambiente:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].AMBIENTE+"' readonly class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Nro Mesas:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].NMESAS+"' class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Ocupadas:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' value='"+ambientes[i].MOCUPADO+"' readonly class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Libres:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' value='"+ambientes[i].MLIBRE+"' readonly  class='form-control'></div></div></div></div></div><div class='col-md-8'><div class='ibox-title'><h5> Mesas  </h5></div><div class='ibox-content'><div class='matriz' id='matriz"+i+"'></div></div></div></div></div></div>";
						}else{
							var itemh = "<li> <a data-toggle='tab' id='tabamb"+i+"' href='#tab"+i+"' ><label class='text-navy' ><i class='fa fa-home'></i> "+ambientes[i].AMBIENTE+" </a></label></li>";
							var itemb = "<div id='tab"+i+"' class='tab-pane'><div class='ibox-content'><div class='row'><div class='col-md-4'><div class='ibox-title'><h5> Datos Ambiente </h5></div><div class='ibox-content'><div class='form-horizontal form-label-left'><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Codigo:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].CODIGO+"' class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Ambiente:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].AMBIENTE+"' readonly class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Nro Mesas:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' readonly value='"+ambientes[i].NMESAS+"' class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Ocupadas:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' value='"+ambientes[i].MOCUPADO+"' readonly class='form-control'></div></div><div class='form-group'><label class='control-label col-md-3 col-sm-3 col-xs-12'> Libres:</label><div class='col-md-9 col-sm-9 col-xs-12'><input type='text' value='"+ambientes[i].MLIBRE+"' readonly  class='form-control'></div></div></div></div></div><div class='col-md-8'><div class='ibox-title'><h5> Mesas  </h5></div><div class='ibox-content'><div class='matriz' id='matriz"+i+"'></div></div></div></div></div></div>";
						}
						tabh.append(itemh); tabb.append(itemb);
						var numColumnas = Math.ceil(Math.sqrt(nmesa.length));
						var btnm = $("#matriz"+i); btnm.empty();
						for (var j = 0; j < nmesa.length; j++) {
							if(nmesa[j].ESTADO == 'LIBRE'){
								btnmesa = "<button class='btn btn-primary btn-outline dim' style='width:110px; height:100px; font-size:10px' onclick='modalPin(\"" + nmesa[j].ID + "\")'>" + nmesa[j].ITEM + " <br>  Sillas: " + nmesa[j].CAPACIDAD + "</button>";
							}else{
								btnmesa = "<button class='btn btn-danger btn-outline dim' style='width:110px; height:100px; font-size:10px' onclick='modalPin(\"" + nmesa[j].ID + "\")'>" + nmesa[j].ITEM + " <br>  Sillas: " + nmesa[j].CAPACIDAD + " <br> " + nmesa[j].MESERO + "</button>";
							}
							
							btnm.append(btnmesa);
						}
						tabh.show(); tabb.show();
					}
					
				},
				funcionError: function (e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		function appendToResult(value) {
			var result = document.getElementById("pinmesero");
			result.value += value;
		}
		function clearResult() {
			$("#pinmesero").val("");
		}
		function modalPin(mesa) {
			$("#updidmesa").val(mesa);
			$("#modalPin").modal("show");
		}
		function verificarPin() {
			pedido = [];
			var idmesa = document.getElementById("updidmesa").value;
			var pin = document.getElementById("pinmesero").value;
			if(pin === ""){
				$('#pinmesero').val('').focus();
				Empresa.notificationWarning(" El campo PIN es obligatorio .");
				return;
			}
			var funcion = "verificarPin";
			var body = { funcion: funcion, idmesa: idmesa, pin: pin , idcajero: ide, iduser: idu, idalmacen: ida, idsucursal: ids};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					Empresa.hideSpinner();
					var ped = respuesta.pedido;
					var detprod = respuesta.detprod;
					var mesa = respuesta.mesa;
					$("#modalPin").modal("hide");
					$("#pinmesero").val("");
					cargarAmbientes();
					
					$("#modalPedido").modal("show");
					$("#updidpedido").val(ped.ID);
					document.getElementById('nromesa').innerHTML = mesa.NRO_MESA;
					document.getElementById('nropedido').innerHTML = ped.NRO_ORDEN;

					for (var i = 0; i < detprod.length; i++) {
						
						itemPedido = {} ;
						itemPedido.idp = detprod[i].ID;
						itemPedido.nombre = detprod[i].NOMBRE;   
						itemPedido.precio = detprod[i].PRECIO;
						itemPedido.cantidad= detprod[i].CANTIDAD;
						itemPedido.imagen = detprod[i].IMAGEN;
						itemPedido.tipo = detprod[i].TIPO;
						itemPedido.id_um = detprod[i].ID_UM;
						itemPedido.estado = detprod[i].ESTADO;
						itemPedido.detalle = detprod[i].DETALLE;
						pedido.push(itemPedido);	
					}
					dibujarPedido();
				},
				funcionError: function (e) {
					$('#pinmesero').val('').focus();
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			}); 
		}	
		function verDetalleItem(nom,pos) {
			$("#modalItem").modal("show");
			document.getElementById('nomprditm').innerHTML = nom; 
			$('.titem').hide();
			$('#titem'+pos).show(); 
			var itmc = $('#itmcat');  
			itmc.empty();
			var itemdet = "<div class='alert alert-info'> <a class='alert-link'> Informacion </a>. En esta parte podra cambiar los ingredientes de su producto.</div>";
			itmc.append(itemdet);
			itmc.show();
		}
		function modalDetalleItem(i,j,idp,idcat) {
			Empresa.showSpinner();
			var idcategoria = idcat;
			var idproducto = idp;
			var posi = i; var posj = j;
			var funcion = "listarItemsCambio";
			var body = { funcion: funcion, idcategoria: idcategoria , idproducto: idproducto};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					Empresa.hideSpinner();
					var productos = respuesta.productos;					
					var itmc = $('#itmcat');  
					itmc.hide();itmc.empty();
					var cant =  productos.length;
					if(cant==0){
						var itemdet = "<div class='alert alert-danger'> <a class='alert-link'> Informacion </a>. No se Puede cambiar la receta Original </div>";
						itmc.append(itemdet);
						itmc.show(); 
					}
					for (var i = 0; i < productos.length; i++) {
						if(i==0){
							var itemmsj = "<div class='alert alert-success'> <a class='alert-link'> Informacion </a>. Elija el Item por el cual desea cambiar.</div>";
							itmc.append(itemmsj);
							itmc.show();
						}
						var itemdet = "<div class='col-sm-6'><div class='col-sm-12' style='border: solid #f3f3f4;'><div class='m-t-xs font-bold'>"+productos[i].id_prd1+"  <span class='badge pull-right' > "+productos[i].precio+" Bs. </span></div><div class='text-center'><a onclick='cambiarItemReceta(\"" + posi + "\",\"" + posj + "\",\"" + productos[i].id_prd + "\",\"" + productos[i].id_prd1 + "\")'><img   width='70px' height='70px' src='img/Producto/"+productos[i].imagen+"' ><div class='m-t-xs font-bold'>"+productos[i].nombre+"</div></a></div></div></div>";
						itmc.append(itemdet);
						itmc.show(); 	
					}	
				}
			});
		}
		function cargarProductosCategoria(cat) {
			Empresa.showSpinner();
			var funcion = "listarProductosCategoria";
			var body = { funcion: funcion, categoria: cat };
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					var productos = respuesta.productos.data;					
					var ped = $('#mosaico');  
					ped.hide();ped.empty();
					for (var i = 0; i < productos.length; i++) {
						var itemvnt = "<div class='col-md-4'><div class='col-lg-12' style='border: solid #f3f3f4;'><div class='m-t-xs font-bold'>"+productos[i].ID_PRODUCTO+"  <span class='badge pull-right' > "+productos[i].PRECIO_VENTA+" Bs. </span></div><div class='text-center'><a onclick='agregarProducto(\"" + productos[i].ID_PRODUCTO+ "\")'><img   width='100px' height='100px' src='img/Producto/"+productos[i].IMAGEN+"' ><div class='m-t-xs font-bold'>"+productos[i].NOMBRE+"</div></a></div></div></div>";
						ped.append(itemvnt);
						ped.show(); 	
					}	
					Empresa.hideSpinner();
				}
			});
		}
		function agregarProducto(id){
			Empresa.showSpinner();
			var funcion = "agregarProducto";
			var body = { funcion: funcion , idproducto: id};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					var detprod = respuesta.detprod;
					agregarItem(producto.ID,producto.NOMBRE,producto.PRECIO,producto.IMAGEN,producto.TIPO,producto.ID_UM, detprod);
					selectProductos();
				},
				funcionError: function (e) {
					Empresa.hideSpinner();
					Empresa.notificationError(msj);
				}
			});
		}
		function agregarItem(idp,nombre,precio,imagen,tipo,idum,detalle) {
			
			// -------------------------  agregar Item Pedido -------------------------------
			itemPedido = {} ;
			itemPedido.idp = idp;
			itemPedido.nombre = nombre;   
			itemPedido.precio = precio; 
			itemPedido.cantidad= 1; 
			itemPedido.imagen = imagen;
			itemPedido.tipo = tipo;
			itemPedido.id_um = idum;
			itemPedido.estado = 'PEDIDO';
			itemPedido.detalle = detalle; 
			pedido.push(itemPedido);
			// -------------------------  Dibujar Pedido -------------------------------
			$('.peds').prop('disabled', false);
			dibujarPedido();
			
		}
		function quitarDetallePedido(id)
		{	
			// ------------------------- Quitar Item Pedido -------------------------------
			for (var k = 0; k < pedido.length; k++) {
				if( k == id ){
					pedido.splice(k,1);
				}
			}
			// -------------------------  Dibujar Pedido -------------------------------
			dibujarPedido();
			
		}
		function quitarDetalleItem(posi,posj)
		{	
			// ------------------------- Quitar Detalle Item ---------------------------
			for (var k = 0; k < pedido.length; k++) {
				if( k == posi ){
					var detp = pedido[k].detalle;
					for (var m = 0; m < detp.length; m++) {
						if( m == posj ){
							detp.splice(m,1);
						}
					}
					pedido[k].detalle = detp;
				}
			}
			// -------------------------  Dibujar Pedido -------------------------------
			dibujarPedido();

			// -------------------------  Ocultar Tablas -------------------------------
			$('.titem').hide();
			$('#titem'+posi).show(); 
		}
		function cambiarItemReceta(posi,posj,prd,prd1)
		{	
			Empresa.showSpinner();
			var posi = posi; var posj = posj;
			var funcion = "recuperarIngrediente";
			var body = { funcion: funcion, idprd: prd , idprd1: prd1};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					Empresa.hideSpinner();
					var ingrediente = respuesta.ingrediente;
					// ---------------------- Cambiar Ingredientes ------------------------------
					for (var k = 0; k < pedido.length; k++) {
						if( k == posi ){
							var detp = pedido[k].detalle;
							for (var m = 0; m < detp.length; m++) {
								if( m == posj ){	
									detp[m].id_prd = ingrediente.ID_PRD;
									detp[m].nombre = ingrediente.NOMBRE;
									detp[m].umedida = ingrediente.UMEDIDA;
									detp[m].id_cat1 = ingrediente.ID_CAT1;
									detp[m].id_prd1 = ingrediente.ID_PRD1;
									detp[m].cantidad = ingrediente.CANTIDAD;
									detp[m].precio = ingrediente.PRECIO;
									detp[m].tipo = ingrediente.TIPO;
									detp[m].fila = ingrediente.FILA;
									detp[m].id_um = ingrediente.ID_UM;
								}
							}
							pedido[k].detalle = detp;
						}
					}
					// -------------------------  Dibujar Pedido -------------------------------
					dibujarPedido();

					// -------------------------  Ocultar Tablas -------------------------------
					$('.titem').hide();
					$('#titem'+posi).show(); 
					// ---------------------  Ocultar Ingredientes -----------------------------
					var itmc = $('#itmcat');  
					itmc.empty();
					var itemdet = "<div class='alert alert-info'> <a class='alert-link'> Informacion </a>. En esta parte podra cambiar los ingredientes de su producto.</div>";
					itmc.append(itemdet);
					itmc.show();
				}
			});
		}
		function dibujarPedido() {
			// -------------------------  Detalle Item -------------------------------------
			var detItm = [];
			var tableitem = $("#tablesitem"); tableitem.empty();
			var columnsName = [{title: "#"},{title: "Producto"},{title: "U/M"},{title: "Cantidad"},{title: "SubTotal"},{title: ""},{title: ""}];
			// -------------------------  detalle del Pedido -------------------------------
			var detailItem = []; var count = 0; var id;
			var sumtitems = 0; var preciototal = 0; var sumtprecio = 0;
			for (var i = 0; i < pedido.length; i++) {
				sumtitems = parseFloat(sumtitems) + parseFloat(pedido[i].cantidad); 
				preciototal = parseFloat(pedido[i].precio) * parseFloat(pedido[i].cantidad); 
				sumtprecio = parseFloat(sumtprecio) + parseFloat(preciototal);
				if(pedido[i].tipo == '1'){
					var tipop = "";
				}else{
					var tipop = crearButtonEditar(pedido[i].nombre,i);
				}
				if(pedido[i].estado == 'PEDIDO'){
					var estado = crearButtonQuitar(i);
				}else{
					var estado = "<button class='btn btn-default btn-xs' style='font-size:8px' ><i class='fa fa-check'></i> EN TRANSITO </button>";
					var tipop = "";
				}
				detailItem.push([
					tipop,
					crearImgDet(pedido[i].imagen,"50"),
					pedido[i].nombre,
					pedido[i].cantidad+ " Uds",
					pedido[i].precio+ " Bs.",
					preciototal+ " Bs.",
					estado
				]);
				// ------------------------- Detalle de los Items -------------------------
				detItm = [];
				var table = '<div class="titem" id="titem'+i+'" style="font-size:8px"><table class="table table-bordered  table_'+i+'" ></table></div>';
				tableitem.append(table);
				var detp = pedido[i].detalle;
				for (var j = 0; j < detp.length; j++) {
					detItm.push([
						j+1,
						detp[j].nombre,
						detp[j].umedida,
						detp[j].cantidad,
						detp[j].precio,
						crearButtonQuitarItem(i,j),
						crearButtonCambiarItem(i,j,pedido[i].idp,detp[j].id_cat1)
					]);

				}
				Empresa.inicializarTablaSinFormato({
					selector: ".table_"+i,
					columnas: columnsName
				});
				Empresa.refrescarTablaDeDatos({
					selector: ".table_"+i,
					data: detItm
				});
			}
			tableitem.show();
			document.getElementById('itmcantidad').innerHTML = sumtitems;
			$("#cantidad_ped").val(sumtitems);
			$("#precio_ped").val(Empresa.roundNumber(sumtprecio,2));
			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: detailItem
			});
		}
		// ------------------------- Enviar Pedido  -------------------------
		function enviarPedido(){	
			Empresa.showSpinner();
			var idpedido = document.getElementById("updidpedido").value;
			var funcion = "enviarPedido";
			var body = { funcion: funcion, idpedido: idpedido , detalle: pedido};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
				data: body,
				funcionExito: function (respuesta) {
					Empresa.hideSpinner();
					$("#modalPedido").modal("hide");
					var items = respuesta.items;
					var idped = respuesta.idped;
					limpiarPedido();
					if(items > 0){
						Empresa.notificationSuccess(" Se envio correctamente " + items + " Items a Comandas.");	
						imprimirComanda(idped);
					}else{
						Empresa.notificationError("No se Envio Ningun Item a Comandas.");
					}
					
				}
			});
		}
		function limpiarPedido() {
			$('.peds').prop('disabled', true);
			pedido = [];
			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: []
			});

		}
		function imprimirComanda(id) {                           
			Empresa.PopupCenter('print_comanda.php?id='+id+'','IMPRIMIR COMANDA',400,520);
		}
		// ------------------------- Terminar Pedido  -------------------------
		function terminarPedido(){
			var idpedido = document.getElementById("updidpedido").value;
			var body = {funcion: "terminarPedido", idpedido: idpedido};
			swal({
			  title: "Terminar Pedido",
			  text: "Se procedera a terminar el Pedido",
			  type: "warning",
			  showCancelButton: true,
			  confirmButtonClass: "btn-danger",
			  confirmButtonText: "Terminar",
			  cancelButtonText: "Cancelar",
			  closeOnConfirm: false,
			  closeOnCancel: false
			},
			function(isConfirm) {
			  if (isConfirm) {
				swal.close();
				Empresa.rest(
				{
					verbo: 'POST',
					url: Empresa.armarUrl("/api/pos/funcionesPos.php"),
					data: body,
					funcionExito: function (respuesta) 
					{
						$("#modalPedido").modal("hide");
						var idped = respuesta.idped;
						limpiarPedido();
						swal({
							title: "Exito",
							type: "success",
							text: "Pedido Terminado Correctamente"
						});	
						imprimirPedido(idped);
						cargarAmbientes();
					},
					funcionError: function (e) {
						Empresa.notificationError(e.mensaje);
						Empresa.hideSpinner();
					}
				})
			  } else {
				swal.close();	
			  }
			});
		}
		function imprimirPedido(id) {                           
			Empresa.PopupCenter('print_pedido.php?id='+id+'','IMPRIMIR PEDIDO',400,520);
		}
		// ------------------------- Elementos Utilizados en POS  -------------------------
		function crearButtonQuitarItem(i,j){
			return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Item Ingrediente' onclick='quitarDetalleItem(\"" + i + "\",\"" + j + "\")'><i class='fa fa-trash'></i></button>";
		}
		function crearButtonCambiarItem(i,j,idp,idcat){
			return "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Cambiar Item Ingrediente' onclick='modalDetalleItem(\"" + i + "\",\"" + j + "\",\"" + idp + "\",\"" + idcat + "\")'><i class='fa fa-refresh'></i></button>";
		}
		function crearButtonQuitar(id){
			return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Item Pedido' onclick='quitarDetallePedido(\"" + id + "\")'><i class='fa fa-trash'></i></button>";
		}
		function crearButtonEditar(nom,pos){
			return "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Editar Ingredientes' onclick='verDetalleItem(\"" + nom + "\",\"" + pos + "\")'><i class='fa fa-edit'></i></button>";
		}
		function crearImgDet(url,tam) {
			var imgurl = "<img src='img/Producto/"+url+"'  width='"+tam+"' id='imageModel' /> ";
			return imgurl;
		}
		
		this.initializer();		
	</script>
</body>
</html>