<?php
require('api/librerias/fpdf/fpdf.php');
include_once('controlador/conexion.php');
include_once('controlador/utils.php');

$conexion = Conectar();
$id = $_REQUEST['id'];

$c01 = "select * from ventas where id_venta='" . $id . "'";
$q01 = mysqli_query($conexion, $c01);
$d01 = mysqli_fetch_array($q01, MYSQLI_ASSOC);

$iduser = $d01["ID_USER"];
$idcliente = $d01["ID_CLIENTE"];
$idsucursal = $d01["ID_SUCURSAL"];

$c02 = "select * from user where id_user='" . $iduser . "' ";
$q02 = mysqli_query($conexion, $c02);
$d02 = mysqli_fetch_array($q02, MYSQLI_ASSOC);

$c03 = "select * from sucursal where id_sucursal = '" . $idsucursal . "' ";
$q03 = mysqli_query($conexion, $c03);
$d03 = mysqli_fetch_array($q03, MYSQLI_ASSOC);

$c04 = "SELECT sum(vd.cantidad) as CANTIDAD, vd.precio_venta as PRECIO_UNITARIO, 
        p.ID_PRODUCTO, p.NOMBRE, p.CODIGO 
        from venta_detalle vd , producto p 
        where p.id_producto = vd.id_producto and vd.id_venta ='$id' 
        group by vd.id_producto;";
$q04 = mysqli_query($conexion, $c04);

$c05 = "select * from cliente where id='$idcliente' ";
$q05 = mysqli_query($conexion, $c05);
$d05 = mysqli_fetch_array($q05, MYSQLI_ASSOC);

Desconectar($conexion);

// ================= PDF ====================
$pdf = new FPDF('P','mm',array(58,200)); // 58mm ticket
$pdf->AddPage();
$pdf->SetMargins(2, 5, 2);

// Logo de la empresa
$pdf->Image('img/empresa/'.$d03["IMAGEN"], 10, 2, 40); 
$pdf->Ln(9);

// Encabezado empresa
$pdf->SetFont('Arial','B',9);
$pdf->Cell(0,5,utf8_decode($d03["EMPRESA"]),0,1,'C');

$pdf->SetFont('Arial','',7);
$pdf->MultiCell(0,4,utf8_decode($d03["DIRECCION"]),0,'C');
$pdf->Cell(0,4,"Tel: ".$d03["TELEFONO"],0,1,'C');
$pdf->Cell(0,4,utf8_decode($d03["LOCALIDAD"])." - ".utf8_decode($d03["CIUDAD"]),0,1,'C');
$pdf->Ln(1);

$pdf->SetFont('Arial','B',9);
$pdf->Cell(0,5,"COMPROBANTE DE VENTA",0,1,'C');
$pdf->Ln(1);

// Datos venta
$pdf->SetFont('Arial','',7);
$pdf->Cell(0,4,"Fecha: ".$d01["FECHA_REGISTRO"],0,1);
$pdf->Cell(0,4,"Boleta: ".$d01["BOLETA"],0,1);
$pdf->MultiCell(0,4,"Cliente: ".utf8_decode($d05["razonSocial"]),0,'L');
$pdf->Cell(0,4,"Pago: ".$d01["TIPO_VENTA"],0,1);
$pdf->MultiCell(0,4,"Concepto: ".utf8_decode($d01["CONCEPTO"]),0,'L');
$pdf->Ln(1);

// Encabezado detalle
$pdf->SetFont('Arial','B',8);
$pdf->Cell(0,4,"DETALLE",0,1,'C');
$pdf->Cell(0,4,"---------------------------",0,1,'C');

// Productos
$pdf->SetFont('Arial','',7);
$sumatotal = 0;
while($d04 = mysqli_fetch_array($q04)){
    $subtotal = round($d04["CANTIDAD"] * $d04["PRECIO_UNITARIO"], 2);
    $sumatotal += $subtotal;

    $pdf->MultiCell(0,4,utf8_decode($d04["CODIGO"])." | ".utf8_decode($d04["NOMBRE"]),0,'L');
    $pdf->Cell(25,4,$d04["CANTIDAD"]." x ".number_format($d04["PRECIO_UNITARIO"],2),0,0,'L');
    $pdf->Cell(25,4,number_format($subtotal,2),0,1,'R');
}
$pdf->Cell(0,4,"---------------------------",0,1,'C');

// Total
$pdf->SetFont('Arial','B',8);
$pdf->Cell(25,5,"TOTAL Bs.",0,0,'L');
$pdf->Cell(25,5,number_format($sumatotal,2),0,1,'R');

$pdf->SetFont('Arial','',7);
$pdf->MultiCell(0,4,"Son: ".utf8_decode(convertir_a_letras($sumatotal,'Bolivianos.')),0,'L');
$pdf->Cell(0,4,"Usuario: ".$d02["USUARIO"],0,1);

// Pie
$pdf->Ln(2);
$pdf->SetFont('Arial','I',7);
$pdf->Cell(0,4,"GRACIAS POR SU PREFERENCIA",0,1,'C');

// ================= GUARDAR PDF ====================
// Crear carpeta "pdf" si no existe
$carpeta = __DIR__ . "/pdf";
if (!file_exists($carpeta)) {
    mkdir($carpeta, 0777, true);
}

// Nombre único para el archivo
$filename = $carpeta . "/ticket_" . $id . ".pdf";
$pdf->Output("F", $filename);

// Ruta accesible por navegador (relativa)
$pdf_url = $_SERVER['REQUEST_SCHEME'].'://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['REQUEST_URI']).'/pdf/ticket_' . $id . '.pdf';
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Imprimir Ticket</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      overflow: hidden;
    }
    #pdfFrame {
      width: 100%;
      height: 100vh;
      border: none;
    }
  </style>
</head>
<body>
  <iframe id="pdfFrame" src="<?php echo $pdf_url; ?>"></iframe>

  <script>
    // Espera a que el iframe cargue el PDF
    document.getElementById('pdfFrame').addEventListener("load", function() {
      this.contentWindow.focus();
      this.contentWindow.print(); // Abre el diálogo de impresión
    });
  </script>
</body>
</html>
