<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
	<style>
		.select2-dropdown {
			z-index: 9001;
		}
	</style>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Listado de Productos</strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5>Sucursal : <b id='nomSucursal'></b></h5>
								<div class="ibox-tools">
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active "> <a id="tabproducto" href="#tab-1" data-toggle="tab"><label class="text-navy"><i class="fa fa-tag"></i> Producto </a></label></li>
									<li> <a id="tablistado" href="#tab-2" onclick="cargarProductos();"><label class="text-navy"><i class="fa fa-tags"></i> Listado Productos </a></label></li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="row">
														<div class="col-md-4">
															<div class="ibox-title">
																<h5> Imagen (<span> Portada </span>) </h5>
																<div class="ibox-tools">
																	
																	<a style="color:white;" title="Subir Varias Imagenes" class="btn btn-primary btn-xs" onclick="modalDatosProducto();">
																		<i class="fa fa-file-image-o" aria-hidden="true"></i>
																	</a>
																</div>
															</div>
															<div class="ibox-content">
																<div class="slick_prod" id="imgprods" style='margin: 20px'>
																</div>
															</div>
														</div>
														<div class="col-md-8">
															<div class="ibox-title">
																<div class="row">
																	<div class="col-md-2">
																		<h5> Datos (<span id="idprd"> </span>) </h5>
																	</div>
																	<div class="col-md-4">
																		<div class="input-group text-navy">
																			<span class="input-group-btn"> <button type="button" onclick="irProducto(1)" style="width:35px;" class="btn btn-default btn-sm"><i class="fa fa-fast-backward"></i></button><button type="button" onclick="irProducto(2)" style="width:35px;" class="btn btn-default btn-sm"><i class="fa fa-step-backward"></i></button></span>
																			<input type="text" id="updcodigopro" onkeypress="buscarCodigoProducto(event,this.value)" style="font-size:16px;" class="form-control input-sm"><span class="input-group-btn"> <button type="button" onclick="irProducto(3)" style="width:35px;" class="btn btn-default btn-sm"><i class="fa fa-step-forward"></i></button><button type="button" onclick="irProducto(4)" style="width:35px;" class="btn btn-default btn-sm"><i class="fa fa-fast-forward"></i></button></span>
																		</div>
																	</div>
																	<div class="col-md-3">
																		<select class="form-control" id="selectProducto" onchange="refrescarProducto(this.value)" style="width: 100%;"></select>
																	</div>
																	<div class="col-md-3">
																		<a title="Kardex Compras" class="btn btn-primary btn-outline btn-xs btn-circle" onclick="reporteComprasProductos();">
																			<i class="fa fa-sign-in" aria-hidden="true"></i>
																		</a>
																		<a title="Kardex Ventas" class="btn btn-success btn-xs btn-outline btn-circle" onclick="reporteVentasProductos();">
																			<i class="fa fa-sign-out" aria-hidden="true"></i>
																		</a>
																		<a title="Kardex General" class="btn btn-warning btn-xs btn-outline btn-circle" onclick="reporteKardexProducto();">
																			<i class="fa fa-dropbox" aria-hidden="true"></i>
																		</a>
																		<a class="btn btn-primary btn-xs btn-outline" title="Importar Excel" data-toggle="modal" data-target="#modalExcel">
																			<i class="fa fa-file-excel-o" aria-hidden="true"></i>
																		</a>
																		<a class="btn btn-success btn-xs btn-outline" title="Nuevo Producto" data-toggle="modal" data-target="#newProducto">
																			<i class="fa fa-plus" aria-hidden="true"></i>
																		</a>
																		<a title="Editar Contenido" class="btn btn-warning btn-xs btn-outline" onclick="modalEditContProducto();">
																			<i class="fa fa-desktop" aria-hidden="true"></i>
																		</a>
																		<a class="btn btn-info btn-xs" style="display:none; float:right;" title="Guardar Datos" onclick="guardarDatos();" id="btnguardar">
																			<i class="fa fa-save" aria-hidden="true"></i>
																		</a>
																		<a class="btn btn-success btn-xs" style="float:right;" title="Editar Datos" onclick="habilitarDatos();" id="btneditar">
																			<i class="fa fa-edit" aria-hidden="true"></i>
																		</a>
																	</div>
																</div>
															</div>
															<div class="ibox-content">
																<div class="row">
																	<div class="col-md-6">
																		<div class="form-horizontal form-label-left">
																			<div class="form-group">

																				<label class="col-md-3 col-sm-3 col-xs-12"> Codigo:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updcodpro" disabled class="form-control pros">
																					<input type="hidden" id="updidpro">
																					<input type="hidden" id="updimgpro" >
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Codigo Barra:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updcodbarpro" disabled class="form-control pros">
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Nombre Comercial:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updnompro" disabled class="form-control pros">
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Nombre Generico:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updnomprogen" disabled class="form-control pros">
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Tipo Producto:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" disabled id="selectUpdTipoProducto" style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Presentacion:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" disabled id="selectUpdCategoria" style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Laboratorio :
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" disabled id="selectUpdMarca" style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Unidad :
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" disabled id="selectUpdUnidad" style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Precio Compra:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updprecompro" disabled class="form-control pros">
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Precio Venta:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updprevenpro" disabled class="form-control pros">
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Precio Mayor:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updpremaypro" disabled class="form-control pros">
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Precio Especial:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updpreesppro" disabled class="form-control pros">
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Precio Tope:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updpretoppro" disabled class="form-control pros">
																				</div>
																			</div>
																		</div>
																	</div>
																	<div class="col-md-6">
																		<div class="form-horizontal form-label-left">
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Estado: </label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<div class="switch">
																						<div class="onoffswitch">
																							<input type="checkbox" disabled class="onoffswitch-checkbox pros" id="switchEstado"
																								onclick="cambiarEstadoProducto()">
																							<label class="onoffswitch-label" for="switchEstado">
																								<span class="onoffswitch-inner"></span>
																								<span class="onoffswitch-switch"></span>
																							</label>
																						</div>
																					</div>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Vencimiento: </label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<div class="switch">
																						<div class="onoffswitch">
																							<input type="checkbox" disabled class="onoffswitch-checkbox pros" id="switchVencimiento"
																								onclick="cambiarEstadoVencimiento()">
																							<label class="onoffswitch-label" for="switchVencimiento">
																								<span class="onoffswitch-inner"></span>
																								<span class="onoffswitch-switch"></span>
																							</label>
																						</div>
																					</div>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Actividad :
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" id="updSelectActividad" onchange="selectProductoSin(this.value)" disabled style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Codigo Sin :
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" disabled id="updSelectProductoSin" style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Unidad Medida:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" disabled id="updSelectUnidadMedida" style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Stock Minimo:
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<input type="text" id="updstkminpro" disabled class="form-control pros">
																				</div>
																			</div>
																			<div class="form-group" id="divcomplemento" style="display:none;">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Complementos :
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" multiple disabled id="updSelectComplemento" style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group" id="divmateria" style="display:none;">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Materia Prima :
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" multiple disabled id="updSelectMateriaPrima" style="width: 100%;" required></select>
																				</div>
																			</div>
																			<div class="form-group" id="divcombo" style="display:none;">
																				<label class="col-md-3 col-sm-3 col-xs-12"> Combos :
																				</label>
																				<div class="col-md-9 col-sm-9 col-xs-12">
																					<select class="form-control pros" multiple disabled id="updSelectCombo" style="width: 100%;" required></select>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<div class="col-md-2">
															<h5> Listado Productos </h5>
														</div>
														<div class="col-md-2">
															<label style="text-align: right;"> Cantidad Productos: </label>
														</div>
														<div class="col-md-2">
															<input class="form-control input-sm" type="text" id="stocktotal" disabled>
														</div>
														<div class="col-md-2">

														</div>
														<div class="col-md-4">
															<div class="ibox-tools">

															</div>
														</div>
													</div>
													<div class="ibox-content">
														<div id="toogle-columns"></div>
														<div class="ibox table-responsive" style="font-size:10px;">
															<table class="table table-striped table-bordered table-hover lisproducto">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newProducto" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Producto</h4>
							<small> Registro de un nuevo item de producto </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal ">
								<div class="row">
									<div class="col-md-6">
										<h3>Información Producto</h3>
										<hr>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Codigo:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="codpro" class="form-control pros">
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Codigo Barras:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="codbarpro" class="form-control pros">
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Nombre Comercial:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="nompro" class="form-control pros">
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Nombre Generico:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="nomprogen" class="form-control pros">
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Tipo Producto:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<div class="input-group">
													<select class="form-control" id="selectTipoProducto" style="width: 100%;" required></select><span class="input-group-btn"> <button type="button" style="width:35px;" title="Nuevo Tipo Producto" data-toggle="modal" data-target="#newTipoProducto" class="btn btn-primary btn-outline btn-sm"><i class="fa fa-plus"></i></button></span>
												</div>

											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Presentacion:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<div class="input-group">
													<select class="form-control" id="selectCategoria" style="width: 100%;" required></select><span class="input-group-btn"> <button type="button" style="width:35px;" title="Nueva Categoria" data-toggle="modal" data-target="#newCategoria" class="btn btn-primary btn-outline btn-sm"><i class="fa fa-plus"></i></button></span>
												</div>

											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Laboratorio :
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<div class="input-group">
													<select class="form-control" id="selectMarca" style="width: 100%;" required></select><span class="input-group-btn"> <button type="button" style="width:35px;" title="Nueva Marca" data-toggle="modal" data-target="#newMarca" class="btn btn-primary btn-outline btn-sm"><i class="fa fa-plus"></i></button></span>
												</div>
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Unidad Medida:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<div class="input-group">
													<select class="form-control" id="selectUnidad" style="width: 100%;" required></select><span class="input-group-btn"> <button type="button" style="width:35px;" title="Nueva Unidad Medida" data-toggle="modal" data-target="#newUnidadMedida" class="btn btn-primary btn-outline btn-sm"><i class="fa fa-plus"></i></button></span>
												</div>

											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Precio Compra:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="precompro" value="0" class="form-control pros">
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Precio Venta:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="prevenpro" value="0" class="form-control pros">
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Precio Mayor:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="premaypro" value="0" class="form-control pros">
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Precio Especial:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="preesppro" value="0" class="form-control pros">
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-5 col-sm-5 col-xs-12"> Precio Tope:
											</label>
											<div class="col-md-7 col-sm-7 col-xs-12">
												<input type="text" id="pretoppro" value="0" class="form-control pros">
											</div>
										</div>
									</div>
									<div class="col-md-6">
										<h3>Información Impuestos</h3>
										<hr>
										<div class="form-group">
											<label class="control-label col-md-3 col-sm-3 col-xs-12"> Actividad :
											</label>
											<div class="col-md-9 col-sm-9 col-xs-12">
												<select class="form-control" id="selectActividad" onchange="selectProductoSin(this.value)" style="width: 100%;" required></select>
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo Sin :
											</label>
											<div class="col-md-9 col-sm-9 col-xs-12">
												<select class="form-control" id="selectProductoSin" style="width: 100%;" required></select>
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-3 col-sm-3 col-xs-12"> Unidad Medida:
											</label>
											<div class="col-md-9 col-sm-9 col-xs-12">
												<select class="form-control" id="selectUnidadMedida" style="width: 100%;" required></select>
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-3 col-sm-3 col-xs-12"> Stock Minimo:
											</label>
											<div class="col-md-9 col-sm-9 col-xs-12">
												<input type="text" id="stkminpro" value="0" class="form-control pros">
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="modal-footer">
								<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
								<button onclick="newProducto();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="contProducto" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Editar Producto</h4>
							<small>Editar contenido html del Producto </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label "> Contenido Actual:
									</label>
									<div class="ibox-content ">
										<div id="contproducto"></div>
									</div>
								</div>

								<div class="form-group">
									<label class="control-label "> Contenido Nuevo:
									</label>
									<div class="col-xs-12">
										<textarea class="form-control summernote" id="contenidoProducto"></textarea>
									</div>
								</div>

								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="updContProducto();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="editImageProducto" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-camera"></i> Actualizar Imagen </h4>
							<small>Actualizar portada del Producto</small>
						</div>
						<div class="modal-body">
							<div class="row">
								<form method="post" action="" enctype="multipart/form-data" id="productoForm">

									<div class="col-md-8 col-sm-8 col-xs-12">
										<input type="file" onchange="vistaPreviaProducto(this);" id="newImgProducto" class="form-control">
									</div>
									<div class="col-md-4 col-sm-4 col-xs-12" id="productoAnt">
										<center><img alt="image" class="img-thumbnail" id="imgProducto" width="200px" src=""></center>
									</div>
								</form>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updImgProducto();" type="submit" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos </button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalImagenes" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-camera"></i> Imagenes del Producto</h4>
							<small>Todas las Imagenes del Producto</small>
						</div>
						<div class="modal-body">
							<form method="post" enctype="multipart/form-data" id="multimediaForm">
								<div class="row">
									<div class="form-group">
										<div class="col-md-2 col-sm-2 col-xs-2">
											<label class="control-label"> Imagenes: </label>
										</div>
										<div class="col-md-8 col-sm-8 col-xs-8">
											<input type="file" class="form-control" name="images[]" id="fileInput" onchange="vistaPreviaMultiple() ;" multiple>
										</div>
										<div class="col-md-2 col-sm-2 col-xs-2">
											<button onclick="newImagenes();" class="btn btn-success btn-sm"><i class="fa fa-upload"></i> Subir Imagenes</button>
										</div>
									</div>
								</div><br>
								<div class="row" id="vista-previa"></div>
							</form>
							<div class="row">
								<div class="col-md-12">
									<div class="ibox-content" id="lisimagenes">

									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalReporte" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-body">
							<div class="row">
								<div class="col-md-12" id="panelreporte">
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" onclick="imprimirReporte()" class="btn btn-warning"><i class="fa fa-print"></i> Imprimir </button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalExcel" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-file-excel-o"></i> Subir Excel de Productos </h4>
							<small> Subir Excel de Productos al Sistema.</small>
						</div>
						<div class="modal-body">
							<form method="post" enctype="multipart/form-data">
								<div class="row">
									<div class="form-group">
										<div class="col-md-2 col-sm-2 col-xs-2">
											<label class="control-label"> Excel: </label>
										</div>
										<div class="col-md-8 col-sm-8 col-xs-8">
											<input type="file" class="form-control" id="excelpro">
										</div>
									</div>
								</div>
							</form>
						</div>
						<div class="modal-footer">
							<button onclick="subirExcelProductos();" class="btn btn-success btn-sm"><i class="fa fa-upload"></i> Subir Excel </button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newTipoProducto" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Item</h4>
							<small> Registro de un nuevo tipo de Producto </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codprod" class="form-control col-md-7 col-xs-12 tipprod">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Tipo Producto:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="tipprod" class="form-control col-md-7 col-xs-12 tipprod">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="newTipoProducto();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newCategoria" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nueva Presentacion</h4>
							<small> Registro de un nuevo item de Presentacion </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codcat" class="form-control col-md-7 col-xs-12 cats">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Presentacion:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="catcat" class="form-control col-md-7 col-xs-12 cats">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newCategoria();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newMarca" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Laboratorio</h4>
							<small> Registro de un nuevo item de laboratorio </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codmar" class="form-control col-md-7 col-xs-12 mars">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Laboratorio:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="marmar" class="form-control col-md-7 col-xs-12 mars">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newMarca();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newUnidadMedida" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nueva Unidad Medida</h4>
							<small> Registro de una nueva Unidad de Medida. </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Codigo:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="codunid" class="form-control col-md-7 col-xs-12 unids">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Medida:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="medunid" class="form-control col-md-7 col-xs-12 unids">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newUnidadMedida();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";

		var idp = "<?php echo $_GET['idp']; ?>";

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/usuario/" + foto + "";
			headerProducto();
			selectMarca();
			selectUnidad();
			selectTipoProducto();
			selectCategoria();
			selectActividad();
			selectUnidadMedida();
			if (idp == '') {
				editProducto(0, 0);
			} else {
				editProducto(idp, 0);
			}
		}
		// -------------------------- Cargar Selects ---------------------------- //
		function selectProducto(valor) {
			Empresa.actualizarSelect({
				selector: "#selectProducto",
				sql: "SELECT p.id_producto as id, concat(p.nombre) as etiqueta FROM producto p",
				callback: function(data) {
					$("#selectProducto").val(valor);
					$("#selectProducto").select2({
						minimumInputLength: 2
					});
				}
			});
		}

		function selectMarca() {
			Empresa.actualizarSelect({
				selector: "#selectMarca",
				sql: "select marca as id, marca as etiqueta from marca",
				callback: function(data) {
					$('#selectMarca').hide();
					$('#selectMarca').select2({
						dropdownParent: $('#newProducto')
					})
				}
			});
		}

		function selectUpdMarca(valor) {
			var valor = valor;
			Empresa.actualizarSelect({
				selector: "#selectUpdMarca",
				sql: "select marca as id, marca as etiqueta from marca",
				callback: function(data) {
					$("#selectUpdMarca").val(valor);
					$("#selectUpdMarca").select2();
				}
			});
		}

		function selectUnidad() {
			Empresa.actualizarSelect({
				selector: "#selectUnidad",
				sql: "select medida as id, medida as etiqueta from unidad_medida",
				callback: function(data) {
					$('#selectUnidad').hide();
					$('#selectUnidad').select2({
						dropdownParent: $('#newProducto')
					})
				}
			});
		}

		function selectUpdUnidad(valor) {
			var valor = valor;
			Empresa.actualizarSelect({
				selector: "#selectUpdUnidad",
				sql: "select medida as id, medida as etiqueta from unidad_medida",
				callback: function(data) {
					$("#selectUpdUnidad").val(valor);
					$("#selectUpdUnidad").select2();
				}
			});

		}

		function selectCategoria() {
			Empresa.actualizarSelect({
				selector: "#selectCategoria",
				sql: "select categoria as id, categoria as etiqueta from categoria",
				callback: function(data) {
					$('#selectCategoria').hide();
					$('#selectCategoria').select2({
						dropdownParent: $('#newProducto')
					})
				}
			});
		}

		function selectUpdCategoria(valor) {
			var valor = valor;
			Empresa.actualizarSelect({
				selector: "#selectUpdCategoria",
				sql: "select categoria as id, categoria as etiqueta from categoria",
				callback: function(data) {
					$("#selectUpdCategoria").val(valor);
					$("#selectUpdCategoria").select2();
				}
			});

		}

		function selectTipoProducto() {
			Empresa.actualizarSelect({
				selector: "#selectTipoProducto",
				sql: "select tipo_producto as id, tipo_producto as etiqueta from tipo_producto",
				callback: function(data) {
					$('#selectTipoProducto').hide();
					$('#selectTipoProducto').select2({
						dropdownParent: $('#newProducto')
					})
				}
			});
		}

		function selectUpdTipoProducto(valor) {
			var valor = valor;
			Empresa.actualizarSelect({
				selector: "#selectUpdTipoProducto",
				sql: "select tipo_producto as id, tipo_producto as etiqueta from tipo_producto",
				callback: function(data) {
					$("#selectUpdTipoProducto").val(valor);
					$("#selectUpdTipoProducto").select2();
				}
			});

		}

		function selectActividad() {
			Empresa.actualizarSelect({
				selector: "#selectActividad",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_actividades",
				callback: function(data) {
					$('#selectActividad').select2({
						dropdownParent: $('#newProducto')
					})
				}
			});
		}

		function selectProductoSin(valor) {
			Empresa.actualizarSelect({
				selector: "#selectProductoSin",
				sql: "select codigoProducto as id, descripcion as etiqueta from siat_sinc_productos_servicios where codigoActividad='" + valor + "' ",
				callback: function(data) {
					$('#selectProductoSin').select2({
						dropdownParent: $('#newProducto')
					})
				}
			});
		}

		function selectUnidadMedida() {
			Empresa.actualizarSelect({
				selector: "#selectUnidadMedida",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_unidades_medida",
				callback: function(data) {
					$('#selectUnidadMedida').val(57);
					$('#selectUnidadMedida').select2({
						dropdownParent: $('#newProducto')
					})
				}
			});
		}

		function updSelectActividad(valor) {
			Empresa.actualizarSelect({
				selector: "#updSelectActividad",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_actividades",
				callback: function(data) {
					$('#updSelectActividad').val(valor);
					$("#updSelectActividad").select2();
				}
			});
		}

		function updSelectUnidadMedida(valor) {
			Empresa.actualizarSelect({
				selector: "#updSelectUnidadMedida",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_unidades_medida",
				callback: function(data) {
					$('#updSelectUnidadMedida').val(valor);
					$("#updSelectUnidadMedida").select2();
				}
			});
		}

		function updSelectProductoSin(act, prod) {
			Empresa.actualizarSelect({
				selector: "#updSelectProductoSin",
				sql: "select codigoProducto as id, descripcion as etiqueta from siat_sinc_productos_servicios where codigoActividad='" + act + "' ",
				callback: function(data) {
					$('#updSelectProductoSin').val(prod);
					$("#updSelectProductoSin").select2();
				}
			});
		}

		function updSelectComplemento(datos) {
			var complementos = datos.split(" - ");
			Empresa.multiSelect({
				selector: "#updSelectComplemento",
				sql: "select nombre as id, nombre as etiqueta from complementos",
				callback: function(data) {
					$('#updSelectComplemento').val(complementos);
					$('#updSelectComplemento').select2({
						placeholder: "Seleccione una opción",
						allowClear: true 
					});
				}
			});
		}
		function updSelectMateriaPrima(datos) {
			var materias = datos.split(" - ");
			Empresa.multiSelect({
				selector: "#updSelectMateriaPrima",
				sql: "SELECT nombre AS id, nombre AS etiqueta FROM producto WHERE tipo_producto IN ('INSUMOS', 'MATERIA PRIMA')",
				callback: function(data) {
					$('#updSelectMateriaPrima').val(materias);
					$('#updSelectMateriaPrima').select2({
						placeholder: "Seleccione una opción",
						allowClear: true 
					});
				}
			});
		}
		function updSelectCombo(datos) {
			var materias = datos.split(" - ");
			Empresa.multiSelect({
				selector: "#updSelectCombo",
				sql: "SELECT nombre AS id, nombre AS etiqueta FROM producto WHERE tipo_producto IN ('INSUMOS', 'MATERIA PRIMA') 'PRODUCTO TERMINADO'",
				callback: function(data) {
					$('#updSelectCombo').val(materias);
					$('#updSelectCombo').select2({
						placeholder: "Seleccione una opción",
						allowClear: true 
					});
				}
			});
		}
		function headerProducto() {
			var lisproducto = [];
			var columnsName = [{
				title: "#"
			}, {
				title: "Imagen"
			}, {
				title: "Codigo"
			}, {
				title: "Codigo Barra"
			}, {
				title: "Nombre Comercial"
			}, {
				title: "Nombre Generico"
			}, {
				title: "Presentacion"
			}, {
				title: "Laboratorio"
			}, {
				title: "Unidad"
			}, {
				title: "Precio Compra"
			}, {
				title: "Precio Venta"
			}, {
				title: "Precio Mayor"
			}, {
				title: "Precio Especial"
			}, {
				title: "Precio Tope"
			}];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".lisproducto",
				data: lisproducto,
				columnas: columnsName
			});
		}

		function refrescarProducto(idp) {
			window.location.href = "producto?idp=" + idp;
		}
		// -------------------------- Productos  ------------------------------
		function cargarProductos() {
			$('#tablistado').tab('show');
			Empresa.showSpinner();
			var lisproducto = [];
			var funcion = "listarProductos";
			var body = {
				funcion: funcion
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var productos = respuesta.productos.data;
					$("#stocktotal").val(productos.length);
					for (var i = 0; i < productos.length; i++) {
						lisproducto.push([
							productos[i].ID_PRODUCTO,
							Empresa.crearImagenEdit(productos[i].ID_PRODUCTO, productos[i].IMAGEN, "50", "Producto"),
							productos[i].CODIGO,
							productos[i].CODIGO_BARRAS,
							productos[i].NOMBRE,
							productos[i].NOMBRE_GENERICO,
							productos[i].CATEGORIA,
							productos[i].MARCA,
							productos[i].UNIDAD,
							productos[i].PRECIO_COMPRA,
							productos[i].PRECIO_VENTA,
							productos[i].PRECIO_MAYOR,
							productos[i].PRECIO_ESPECIAL,
							productos[i].PRECIO_TOPE
						]);
					}
					Empresa.refrescarTablaDeDatos({
						selector: ".lisproducto",
						data: lisproducto
					});
				}
			});
		}

		function newProducto() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codpro").value;
			var codigob = document.getElementById("codbarpro").value;
			var nombre = document.getElementById("nompro").value;
			var generico = document.getElementById("nomprogen").value;
			var marca = document.getElementById("selectMarca").value;
			var categoria = document.getElementById("selectCategoria").value;
			var unidad = document.getElementById("selectUnidad").value;
			var precompra = document.getElementById("precompro").value;
			var premayor = document.getElementById("premaypro").value;
			var preespecial = document.getElementById("preesppro").value;
			var preventa = document.getElementById("prevenpro").value;
			var pretope = document.getElementById("pretoppro").value;
			var stock = document.getElementById("stkminpro").value;
			var actividad = document.getElementById("selectActividad").value;
			var productosin = document.getElementById("selectProductoSin").value;
			var umedida = document.getElementById("selectUnidadMedida").value;
			var tipop = document.getElementById("selectTipoProducto").value;
			if (actividad === "") {
				$('#selectActividad').focus();
				Empresa.notificationError("El campo Actividad es necesario.");
				Empresa.hideSpinner();
				return;
			}

			if (productosin === "") {
				$('#selectProductoSin').focus();
				Empresa.notificationError("El campo Producto es necesario.");
				Empresa.hideSpinner();
				return;
			}

			if (umedida === "") {
				$('#selectUnidadMedida').focus();
				Empresa.notificationError("El campo Unidad de Medida es necesario.");
				Empresa.hideSpinner();
				return;
			}
			var funcion = "newProducto";
			var body = {
				funcion: funcion,
				codigo: codigo,
				codigob: codigob,
				nombre: nombre,
				generico: generico,
				marca: marca,
				unidad: unidad,
				categoria: categoria,
				precompra: precompra,
				preventa: preventa,
				premayor: premayor,
				preespecial: preespecial,
				pretope: pretope,
				actividad: actividad,
				productosin: productosin,
				umedida: umedida,
				tipop: tipop,
				stock: stock
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newProducto").modal("hide");
					$('.pros').val('');
					editProducto(0, 0);
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function editProducto(id, valor) {
			Empresa.showSpinner();
			$('#tabproducto').tab('show');
			var funcion = "editProducto";
			var body = {
				funcion: funcion,
				idproducto: id,
				valor: valor
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					var imagenes = respuesta.imagenes;
					const switchCheckbox = document.getElementById("switchEstado");
					document.getElementById('idprd').innerHTML = producto.ID_PRODUCTO;
					$("#updidpro").val(producto.ID_PRODUCTO);
					$("#updcodpro").val(producto.CODIGO);
					$("#updcodigopro").val(producto.ID_PRODUCTO);
					$("#updcodbarpro").val(producto.CODIGO_BARRAS);
					$("#updnompro").val(producto.NOMBRE);
					$("#updnomprogen").val(producto.NOMBRE_GENERICO);
					$("#updprecompro").val(producto.PRECIO_COMPRA);
					$("#updprevenpro").val(producto.PRECIO_VENTA);
					$("#updpremaypro").val(producto.PRECIO_MAYOR);
					$("#updpreesppro").val(producto.PRECIO_ESPECIAL);
					$("#updpretoppro").val(producto.PRECIO_TOPE);
					$("#updstkminpro").val(producto.STOCK_MINIMO);
					selectProducto(producto.ID_PRODUCTO);
					selectUpdCategoria(producto.CATEGORIA);
					selectUpdTipoProducto(producto.TIPO_PRODUCTO);
					selectUpdUnidad(producto.UNIDAD);
					selectUpdMarca(producto.MARCA);
					updSelectActividad(producto.CODIGO_ACTIVIDAD);
					updSelectProductoSin(producto.CODIGO_ACTIVIDAD, producto.CODIGO_SIN);
					updSelectUnidadMedida(producto.UNIDAD_MEDIDA);
					updSelectComplemento(producto.COMPLEMENTOS);
					if (producto.ESTADO === "ACTIVO") {
						switchCheckbox.checked = true;
					} else {
						switchCheckbox.checked = false;
					}
					if (producto.TIPO_PRODUCTO === "RECETA") {
						document.getElementById("divcomplemento").style.display = "block";
						document.getElementById("divmateria").style.display = "block";
						document.getElementById("divcombo").style.display = "none";
					} else if (producto.TIPO_PRODUCTO === "COMBO") {
						document.getElementById("divcombo").style.display = "block";
						document.getElementById("divcomplemento").style.display = "none";
						document.getElementById("divmateria").style.display = "none";
					} else{
						document.getElementById("divcomplemento").style.display = "none";
						document.getElementById("divcombo").style.display = "none";
						document.getElementById("divmateria").style.display = "none";
					}
					var itemimg = $("#imgprods");
					itemimg.hide();
					itemimg.empty();
					for (var i = 0; i < imagenes.length; i++) {
						var panelimg = "<div style='margin: 20px' ><div class='ibox-content'><img src='img/Producto/" + imagenes[i].IMAGEN + "'  width='100%' class='img-fluid' ></div></div>";
						itemimg.append(panelimg);
					}
					itemimg.show();

					$('.slick_prod').slick({
						dots: true
					});
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError(e.mensaje);
				}
			});
		}

		function irProducto(valor) {
			var idproducto = document.getElementById("updidpro").value;
			editProducto(idproducto, valor);
		}

		function habilitarDatos() {
			$('#btneditar').hide();
			$('#btnguardar').show();
			Empresa.habilitarCampos("pros");
		}

		function guardarDatos() {
			Empresa.showSpinner();
			$('#btnguardar').hide();
			$('#btneditar').show();
			var idproducto = document.getElementById("updidpro").value;
			var codigo = document.getElementById("updcodpro").value;
			var codigob = document.getElementById("updcodbarpro").value;
			var nombre = document.getElementById("updnompro").value;
			var generico = document.getElementById("updnomprogen").value;
			var categoria = document.getElementById("selectUpdCategoria").value;
			var tipo = document.getElementById("selectUpdTipoProducto").value;
			var marca = document.getElementById("selectUpdMarca").value;
			var unidad = document.getElementById("selectUpdUnidad").value;
			var precompra = document.getElementById("updprecompro").value;
			var preventa = document.getElementById("updprevenpro").value;
			var premayor = document.getElementById("updpremaypro").value;
			var preespecial = document.getElementById("updpreesppro").value;
			var pretope = document.getElementById("updpretoppro").value;
			var stock = document.getElementById("updstkminpro").value;

			var actividad = document.getElementById("updSelectActividad").value;
			var codigosin = document.getElementById("updSelectProductoSin").value;
			var unidadmedida = document.getElementById("updSelectUnidadMedida").value;
			var complemento = Empresa.obtenerSeleccionados("#updSelectComplemento");


			var funcion = "updProducto";
			var body = {
				funcion: funcion,
				idproducto: idproducto,
				codigo: codigo,
				codigob: codigob,
				nombre: nombre,
				generico: generico,
				marca: marca,
				tipo: tipo,
				categoria: categoria,
				unidad: unidad,
				precompra: precompra,
				preventa: preventa,
				premayor: premayor,
				preespecial: preespecial,
				pretope: pretope,
				actividad: actividad,
				codigosin: codigosin,
				unidadmedida: unidadmedida,
				complemento: complemento,
				stock: stock
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.deshabilitarCampos("pros");
					editProducto(idproducto, 0);
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se Actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}

		function buscarCodigoProducto(e, actual) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;
			if ((keycode >= 47 && keycode <= 57) || (keycode > 64 && keycode < 91) || (keycode >= 96 && keycode <= 123) || keycode == 8 || keycode == 45) {} else if (keycode == '13') {
				verProducto(actual)
			} else {
				e.preventDefault();
			}
		}

		function verProducto(cod) {
			Empresa.showSpinner();
			$('#tabproducto').tab('show');
			var funcion = "irProducto";
			var body = {
				funcion: funcion,
				idproducto: cod
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					var imagenes = respuesta.imagenes;
					const switchCheckbox = document.getElementById("switchEstado");
					document.getElementById('idprd').innerHTML = producto.ID_PRODUCTO;
					$("#updidpro").val(producto.ID_PRODUCTO);
					$("#updcodpro").val(producto.CODIGO);
					$("#updcodigopro").val(producto.ID_PRODUCTO);
					$("#updcodbarpro").val(producto.CODIGO_BARRAS);
					$("#updnompro").val(producto.NOMBRE);
					$("#updnomprogen").val(producto.NOMBRE_GENERICO);
					$("#updprecompro").val(producto.PRECIO_COMPRA);
					$("#updprevenpro").val(producto.PRECIO_VENTA);
					$("#updpremaypro").val(producto.PRECIO_MAYOR);
					$("#updpreesppro").val(producto.PRECIO_ESPECIAL);
					$("#updpretoppro").val(producto.PRECIO_TOPE);
					$("#updstkminpro").val(producto.STOCK_MINIMO);
					$("#updimgpro").val(producto.IMAGEN);
					selectUpdCategoria(producto.CATEGORIA);
					selectUpdTipoProducto(producto.TIPO_PRODUCTO);
					selectUpdUnidad(producto.UNIDAD);
					selectUpdMarca(producto.MARCA);
					selectProducto(producto.ID_PRODUCTO);
					updSelectActividad(producto.CODIGO_ACTIVIDAD);
					updSelectProductoSin(producto.CODIGO_ACTIVIDAD, producto.CODIGO_SIN);
					updSelectUnidadMedida(producto.UNIDAD_MEDIDA);
					updSelectComplemento(producto.COMPLEMENTOS);
					if (producto.ESTADO === "ACTIVO") {
						switchCheckbox.checked = true;
					} else {
						switchCheckbox.checked = false;
					}
					if (producto.TIPO_PRODUCTO === "RECETA") {
						document.getElementById("divcomplemento").style.display = "block";
						document.getElementById("divmateria").style.display = "block";
						document.getElementById("divcombo").style.display = "none";
					} else if (producto.TIPO_PRODUCTO === "COMBO") {
						document.getElementById("divcombo").style.display = "block";
						document.getElementById("divcomplemento").style.display = "none";
						document.getElementById("divmateria").style.display = "none";
					} else{
						document.getElementById("divcomplemento").style.display = "none";
						document.getElementById("divcombo").style.display = "none";
						document.getElementById("divmateria").style.display = "none";
					}

					var itemimg = $("#imgprods");
					itemimg.hide();
					itemimg.empty();
					for (var i = 0; i < imagenes.length; i++) {
						var panelimg = "<div style='margin: 20px' ><div class='ibox-content'><img src='img/Producto/" + imagenes[i].IMAGEN + "'  width='100%'  class='img-fluid' ></div></div>";
						itemimg.append(panelimg);
					}
					itemimg.show();

					$('.slick_prod').slick({
						dots: true
					});
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError(e.mensaje);
				}
			});
		}

		function deleteItemProducto(id) {
			var funcion = "deleteProducto";
			var body = {
				funcion: funcion,
				id: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					editProducto(id, 0);
					Empresa.notificationSuccess("Se elimino correctamente el registro.");
				}
			});
		}

		function modalEditContProducto() {
			var id = document.getElementById("updidpro").value;
			Empresa.showSpinner();
			var funcion = "editProducto";
			var body = {
				funcion: funcion,
				idproducto: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					$('.summernote').summernote();
					$("#contProducto").modal("show");
					$("#updidpro").val(producto.ID_PRODUCTO);
					var conten = $("#contproducto");
					conten.empty();
					conten.append(producto.DETALLE);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updContProducto() {
			Empresa.showSpinner();
			var id = document.getElementById("updidpro").value;
			var contenido = document.getElementById("contenidoProducto").value;
			var funcion = "updContProducto";
			var body = {
				funcion: funcion,
				contenido: contenido,
				idproducto: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					$("#contProducto").modal("hide");
					$('#updidpro').val('');
					$('#contenidoProducto').val('');
					$('.summernote').summernote();
					editProducto(id, 0);
					Empresa.notificationSuccess("Se Actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}

		function cambiarEstadoProducto() {
			var id = document.getElementById("updidpro").value;
			var estado;
			if (document.getElementById("switchEstado").checked) {
				estado = "INACTIVO";
			} else {
				estado = "ACTIVO";
			}

			Empresa.showSpinner();
			var funcion = "cambiarEstadoProducto";
			var body = {
				funcion: funcion,
				idproducto: id,
				estado: estado
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					editProducto(id, 0);
					Empresa.notificationSuccess("Se Actualizo correctamente el Estado.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}
		function cambiarEstadoVencimiento() {
			var id = document.getElementById("updidpro").value;
			var vencimiento;
			if (document.getElementById("switchVencimiento").checked) {
				vencimiento = "NO";
			} else {
				estado = "SI";
			}

			Empresa.showSpinner();
			var funcion = "cambiarEstadoVencimiento";
			var body = {
				funcion: funcion,
				idproducto: id,
				vencimiento: vencimiento
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					editProducto(id, 0);
					Empresa.notificationSuccess("Se Actualizo correctamente el Estado.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}


		function vistaPreviaProducto(input) {
			$('#productoAnt').hide();
			if (input.files && input.files[0]) {
				var reader = new FileReader();
				reader.onload = function(e) {
					$('#productoForm + div').remove();
					$('#productoForm').after('<div class="col-md-4 col-sm-4 col-xs-12"><center><img alt="image" class="img-thumbnail" width="200px" src="' + e.target.result + '"></center></div>');
				};
				reader.readAsDataURL(input.files[0]);
			}
		}

		function editImageProducto(id,img) {
			$("#editImageProducto").modal("show");
			$("#updidpro").val(id);
			document.getElementById("imgProducto").src = "img/Producto/" + img + "";
		}

		function editImagePrd() {
			var id = document.getElementById("updidpro").value;
			var img = document.getElementById("updimgpro").value;
			$("#editImageProducto").modal("show");
			$("#updidpro").val(id);
			document.getElementById("imgProducto").src = "img/Producto/" + img + "";
		}

		function updImgProducto() {
			Empresa.showSpinner();
			var inputFileImage = document.getElementById("newImgProducto");
			var id = document.getElementById("updidpro").value;
			var file = inputFileImage.files[0];
			var archivo = file.name;
			var data = new FormData();
			var funcion = "updImgProducto";
			data.append('newImgProducto', file);
			data.append('id', id);
			data.append('funcion', funcion);
			Empresa.restImg({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesArchivosInventario.php"),
				data: data,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					$("#editImageProducto").modal("hide");
					$("#newImgProducto").val("");
					Empresa.notificationSuccess("Archivo subido Correctamente.");
					cargarProductos();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function modalDatosProducto() {
			Empresa.showSpinner();
			$("#modalImagenes").modal("show");
			var id = document.getElementById("updidpro").value;
			var funcion = "datosImagenesProducto";
			var body = {
				funcion: funcion,
				idproducto: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var imagenes = respuesta.imagenes;
					var itemimg = $("#lisimagenes");
					itemimg.hide();
					itemimg.empty();
					if (imagenes.length > 0) {
						var port = 'Portada'
						for (var i = 0; i < imagenes.length; i++) {
							var portada = imagenes[i].TIPO;
							if (portada == 'PORTADA') {
								var port = 'Portada'
							} else {
								var port = '';
							}
							var panelimg = "<div class='col-md-2'><div class='thumbnail'><img src='img/Producto/" + imagenes[i].IMAGEN + "' style='margin-bottom:3px; width:100%'><a onclick='cambiarPortada(\"" + id + "\",\"" + imagenes[i].ID_IMAGEN + "\")'> <i class='fa fa-file-image-o'></i> " + port + " </a><strong style='float:right; '><a style='color:red;' onclick='deleteItemImagen(\"" + id + "\",\"" + imagenes[i].ID_IMAGEN + "\")'> <i class='fa fa-close'></i> </a></strong></div></div>";
							itemimg.append(panelimg);
						}
					} else {
						var panelimg = "<center ><img class='thumbnail' src='img/sinimagen.png' ><p> Sin Imagenes del Producto </p></center>";
						itemimg.append(panelimg);
					}
					itemimg.show();
				}
			});
		}

		function vistaPreviaMultiple() {
			$("#vista-previa").html('');
			var archivos = document.getElementById('fileInput').files;
			var navegador = window.URL || window.webkitURL;
			/* Recorrer los archivos */
			for (x = 0; x < archivos.length; x++) {
				/* Validar tamaño y tipo de archivo */
				var size = archivos[x].size;
				var type = archivos[x].type;
				var name = archivos[x].name;
				if (size > 2048 * 2048) {
					$("#vista-previa").append("<div class='img-thumbnail' style='width:150px;'><p style='color: red'>El archivo " + name + " supera el máximo permitido 2MB</p></div>");
				} else if (type != 'image/jpeg' && type != 'image/jpg' && type != 'image/png' && type != 'image/gif') {
					$("#vista-previa").append("<div class='img-thumbnail' style='width:5;'><p style='color: red'>El archivo " + name + " no es del tipo de imagen permitida.</p></div>");
				} else {
					var objeto_url = navegador.createObjectURL(archivos[x]);
					$("#vista-previa").append("<img  class='img-thumbnail'  src='" + objeto_url + "' width='150' height='150'>");
				}
			}
		}

		function newImagenes() {
			Empresa.showSpinner();
			var data = new FormData();
			var j = 0;
			jQuery.each(jQuery('#fileInput')[0].files, function(i, file) {
				data.append('file' + i, file);
				j++;
			});
			var id = document.getElementById("updidpro").value;
			var funcion = "newImagenes";
			data.append('funcion', funcion);
			data.append('idproducto', id);
			data.append('tam', j);
			Empresa.restImg({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesArchivosInventario.php"),
				data: data,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					$("#modalImagenes").modal("hide");
					$("#fileInput").val("");
					$("#vista-previa").html('');
					modalDatosProducto(id);
					Empresa.notificationSuccess("Archivos Subidos Correctamente");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function cambiarPortada(id, idimg) {
			Empresa.showSpinner();
			var funcion = "cambiarPortada";
			var body = {
				funcion: funcion,
				idproducto: id,
				idimg: idimg
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					$("#modalImagenes").modal("hide");
					editProducto(id, 0);
					Empresa.notificationSuccess("Se Actualizo correctamente la Portada.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}

		function deleteItemImagen(id, idimg) {
			Empresa.showSpinner();
			var funcion = "deleteItemImagen";
			var body = {
				funcion: funcion,
				idimg: idimg
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					modalDatosProducto(id);
					Empresa.notificationSuccess("Se Actualizo correctamente la Portada.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}

		function subirExcelProductos() {
			Empresa.showSpinner();
			var inputFile = document.getElementById("excelpro");
			var file = inputFile.files[0];
			var archivo = file.name;
			var data = new FormData();
			var funcion = "subirExcelProductos";
			data.append('excelpro', file);
			data.append('funcion', funcion);
			Empresa.restImg({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesArchivosInventario.php"),
				data: data,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var excel = respuesta.excel;
					$("#modalExcel").modal("hide");
					$("#excelpro").val("");
					cargarExcelProducto(excel);
					Empresa.notificationSuccess("Archivos Subidos Correctamente");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function cargarExcelProducto(excel) {
			var body = {
				funcion: "cargarExcelProducto",
				excel: excel
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var insert = respuesta.insert;
					cargarProductos();
					Empresa.notificationSuccess("Se registro Correctamente los productos.");
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
				}
			});
		}

		function reporteKardexProducto() {
			Empresa.showSpinner();
			$('#modalReporte').modal('show');
			var fecini = "2000-01-01";
			var fecfin = "2050-01-01"
			var idsucursal = ids;
			var idProducto = document.getElementById("updidpro").value;
			var nombreProducto = document.getElementById("updnompro").value;
			var body = {
				funcion: "reporteKardexProducto",
				idsucursal: idsucursal,
				idProducto: idProducto,
				fecini: fecini,
				fecfin: fecfin
			};

			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {

					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Kardex General Producto </label><br><p>Producto: ' + nombreProducto + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteKardex" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Transaccion"
					}, {
						title: "Entrada"
					}, {
						title: "Salida"
					}, {
						title: "Saldo"
					}];

					var kardex = respuesta.reportes;
					var repKardex = [];

					for (var i = 0; i < kardex.length; i++) {
						repKardex.push([
							i + 1,
							kardex[i].fecha_registro,
							kardex[i].boleta,
							kardex[i].transaccion,
							kardex[i].entrada,
							kardex[i].salida,
							kardex[i].saldo
						]);
					}


					Empresa.inicializarTablaSinFormato({
						selector: ".reporteKardex",
						data: repKardex,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteVentasProductos() {
			Empresa.showSpinner();
			$('#modalReporte').modal('show');
			var fecini = "2000-01-01";
			var fecfin = "2050-01-01"
			var idsucursal = ids;
			var idProducto = document.getElementById("updidpro").value;
			var nombreProducto = document.getElementById("updnompro").value;
			var body = {
				funcion: "reporteVentasProductos",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin,
				idProducto: idProducto
			};

			var elementoPanel = $("#panelreporte");
			var totalCantidad = 0;
			var totalPrecio = 0;
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					$('#kardexVentasProductos').modal('hide');
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte Ventas Producto </label></center></div></div><br>';

					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteVentas" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Producto"
					}, {
						title: "Cantidad"
					}, {
						title: "Total"
					}];

					var ventas = respuesta.producto.data;
					var repVentas = [];
					var totalCantidad = 0;
					var totalPrecio = 0;

					for (var i = 0; i < ventas.length; i++) {
						var cantidad = parseFloat(ventas[i].Cantidad);
						var precio = parseFloat(ventas[i].Total_Precio_Venta);

						totalCantidad += cantidad;
						totalPrecio += precio;

						repVentas.push([
							i + 1,
							ventas[i].Fecha_Venta,
							ventas[i].Boleta,
							ventas[i].Producto,
							Empresa.financial(cantidad, 2),
							Empresa.financial(precio, 2),
							Empresa.financial(precio * cantidad, 2)
						]);
					}

					repVentas.push(["", "", "", "", "<b>Total</b>", `<b>${Empresa.financial(totalCantidad, 2)}</b>`, `<b>${Empresa.financial(totalPrecio, 2)}</b>`]);

					Empresa.inicializarTablaSinFormato({
						selector: ".reporteVentas",
						data: repVentas,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteComprasProductos() {
			Empresa.showSpinner();
			$('#modalReporte').modal('show');
			var fecini = "2000-01-01";
			var fecfin = "2050-01-01"
			var idsucursal = ids;
			var idProducto = document.getElementById("updidpro").value;
			var nombreProducto = document.getElementById("updnompro").value;

			var body = {
				funcion: "reporteComprasProductos",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin,
				idProducto: idProducto
			};

			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte Compras Producto </label><br><p>Producto: ' + nombreProducto + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteCompras" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Producto"
					}, {
						title: "Cantidad"
					}, {
						title: "Total"
					}];

					var compras = respuesta.producto.data;
					var repCompras = [];
					var totalCantidad = 0;
					var totalPrecio = 0;
					for (var i = 0; i < compras.length; i++) {
						var cantidad = parseFloat(compras[i].Cantidad);
						var precio = parseFloat(compras[i].Total_Precio_Compra);
						totalCantidad += cantidad;
						totalPrecio += precio;

						repCompras.push([
							i + 1,
							compras[i].Fecha_Compra,
							compras[i].Boleta,
							compras[i].Producto,
							Empresa.financial(cantidad, 2),
							Empresa.financial(precio, 2)
						]);
					}

					repCompras.push(["", "", "", "", "<b>Total</b>", `<b>${Empresa.financial(totalCantidad, 2)}</b>`, `<b>${Empresa.financial(totalPrecio, 2)}</b>`]);

					Empresa.inicializarTablaSinFormato({
						selector: ".reporteCompras",
						data: repCompras,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function imprimirReporte() {
			var cabeza = "";
			var pie = "";
			var url = Empresa.armarUrl("producto.php");
			var div = '#panelreporte';
			Empresa.impDiv(div, url, cabeza, pie);
		}

		function newUnidadMedida() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codunid").value;
			var medida = document.getElementById("medunid").value;

			var funcion = "newUnidadMedida";
			var body = {
				funcion: funcion,
				medida: medida,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newUnidadMedida").modal("hide");
					$('.unids').val('');
					selectUnidad();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function newMarca() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codmar").value;
			var marca = document.getElementById("marmar").value;

			var funcion = "newMarca";
			var body = {
				funcion: funcion,
				marca: marca,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newMarca").modal("hide");
					$('.mars').val('');
					selectMarca();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function newCategoria() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codcat").value;
			var categoria = document.getElementById("catcat").value;

			var funcion = "newCategoria";
			var body = {
				funcion: funcion,
				categoria: categoria,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newCategoria").modal("hide");
					$('.cats').val('');
					selectCategoria();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}
		function newTipoProducto() {
			Empresa.showSpinner();
			var codigo = document.getElementById("codprod").value;
			var tipo = document.getElementById("tipprod").value;

			var funcion = "newTipoProducto";
			var body = {
				funcion: funcion,
				tipo: tipo,
				codigo: codigo
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newTipoProducto").modal("hide");
					$('.tips').val('');
					cargarTiposProducto();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro, intente de nuevo por favor.");
				}
			});
		}
		this.initializer();
	</script>
</body>

</html>