<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper" class="ibox-content" style="padding: 0px;">
		<div class="sk-spinner sk-spinner-wave">
			<div class="sk-rect1"></div>
			<div class="sk-rect2"></div>
			<div class="sk-rect3"></div>
			<div class="sk-rect4"></div>
			<div class="sk-rect5"></div>
		</div>
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Reportes Sistema</strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<div class="col-sm-2">
									<h5>Sucursal : <b id='nomSucursal'></b></h5>
								</div>
								<div class="col-lg-2">
									<div id="mostrarsucursal" style="display:none;">
										<select class="form-control" id="selectSucursal" onchange="cargarArqueos();"></select>
									</div>
								</div>
								<div class="row form-group col-sm-8">
									<div class="col-sm-11">
										<label class="col-sm-1 control-label"> Mes:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='mes' onchange="cam_inifin(this.value);" required />
										</div>
										<label class="col-sm-1 control-label"> F.Ini:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='finicio' required />
										</div>
										<label class="col-sm-1 control-label"> F.Fin:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='ffin' required />
										</div>
									</div>
									<div class="col-sm-1">
										<button class="btn btn-warning btn-sm " onclick="imprimirReporte();"> <i class="fa fa-print"></i></button>
									</div>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="ibox-content">
								<div class="row">
									<div class="col-md-12">
										<div class="btn-group">
											<button data-toggle="dropdown" class="btn btn-success btn-outline btn-sm dropdown-toggle"> <i class="fa fa-shopping-cart"></i> Ventas <i class="fa fa-caret-down"></i></button>
											<ul class="dropdown-menu">
												<li><a class="dropdown-item" onclick="reporteVentasGenerales();">Reporte General Ventas</a></li>
												<li><a class="dropdown-item" onclick="reporteVentasVendedor();">Reporte Ventas/Vendedor</a></li>
												<li><a class="dropdown-item" onclick="reportePerdidasGanancias();">Reporte Perdidas/Ganancias</a></li>
												<li><a class="dropdown-item" onclick="reporteProductosMasVendidos();">Reporte Productos Mas Vendidos</a></li>
											</ul>
										</div>
										<div class="btn-group">
											<button data-toggle="dropdown" class="btn btn-primary btn-outline btn-sm dropdown-toggle"> <i class="fa fa-briefcase"></i> Compras <i class="fa fa-caret-down"></i></button>
											<ul class="dropdown-menu">
												<li><a class="dropdown-item" onclick="reporteComprasGenerales();">Reporte General Compras</a></li>
												<li><a class="dropdown-item" onclick="reporteComprasProveedor();">Reporte Compras/Proveedor</a></li>
											</ul>
										</div>
										<div class="btn-group">
											<button data-toggle="dropdown" class="btn btn-info btn-outline btn-sm dropdown-toggle"> <i class="fa fa-exchange"></i> Traspasos <i class="fa fa-caret-down"></i></button>
											<ul class="dropdown-menu">
												<li><a class="dropdown-item" onclick="reporteTraspasos();">Reporte General Traspasos</a></li>
											</ul>
										</div>
										<div class="btn-group">
											<button data-toggle="dropdown" class="btn btn-warning btn-outline btn-sm dropdown-toggle"> <i class="fa fa-download"></i> Bajas <i class="fa fa-caret-down"></i></button>
											<ul class="dropdown-menu">
												<li><a class="dropdown-item" onclick="reporteBajas();">Reporte General Bajas</a></li>
											</ul>
										</div>
										<div class="btn-group">
											<button data-toggle="dropdown" class="btn btn-danger btn-outline btn-sm dropdown-toggle"> <i class="fa fa-usd"></i> Arqueos <i class="fa fa-caret-down"></i></button>
											<ul class="dropdown-menu">
												<li><a class="dropdown-item" onclick="reporteArqueo();">Reporte General Arqueo</a></li>
											</ul>
										</div>
										<div class="btn-group">
											<button data-toggle="dropdown" class="btn btn-info btn-outline btn-sm dropdown-toggle"> <i class="fa fa-calculator"></i> Facturas <i class="fa fa-caret-down"></i></button>
											<ul class="dropdown-menu">
												<li><a class="dropdown-item" onclick="reporteFacturas();">Reporte General Facturas</a></li>
											</ul>
										</div>
										<div class="btn-group">
											<button data-toggle="dropdown" class="btn btn-success btn-outline btn-sm dropdown-toggle"> <i class="fa fa-dropbox"></i> Productos <i class="fa fa-caret-down"></i></button>
											<ul class="dropdown-menu">
												<li><a class="dropdown-item" data-toggle="modal" data-target="#kardexGeneralProductos">Kardex General Productos</a></li>
												<li><a class="dropdown-item" data-toggle="modal" data-target="#kardexVentasProductos">Kardex Ventas/Producto</a></li>
												<li><a class="dropdown-item" data-toggle="modal" data-target="#kardexComprasProductos">Kardex Compras/Producto</a></li>
												<li><a class="dropdown-item" onclick="reporteStockMinimo();">Kardex Producto Stock Minimo</a></li>
											</ul>
										</div>
										<div class="btn-group">
											<button data-toggle="dropdown" class="btn btn-primary btn-outline btn-sm dropdown-toggle"> <i class="fa fa-download"></i> Ajustes <i class="fa fa-caret-down"></i></button>
											<ul class="dropdown-menu">
												<li><a class="dropdown-item" onclick="reporteAjustes();">Reporte General Ajustes</a></li>
											</ul>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="ibox-content">
								<div class="row">
									<div class="col-md-12" id="panelreporte">

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="modal inmodal" id="kardexGeneralProductos" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal">
								<span aria-hidden="true">&times;</span>
								<span class="sr-only">Close</span>
							</button>
							<h4 class="modal-title"><i class="fa fa-box"></i> Kardex General Productos</h4>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Categoria:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectCatKardex" style="width: 100%;" onchange="selectProdKardex(this.value)" class="form-control" required>
										</select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12">Producto:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectProdKardex" style="width: 100%;" class="form-control input-sm" required>
											<option>Seleccione una opcion</option>
										</select>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
									<button onclick="reporteKardexProducto();" class="btn btn-success btn-sm">
										<i class="fa fa-check"></i> Generar Kardex
									</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="modal inmodal" id="kardexVentasProductos" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal">
								<span aria-hidden="true">&times;</span>
								<span class="sr-only">Cerrar</span>
							</button>
							<h4 class="modal-title"><i class="fa fa-box"></i> Kardex Ventas Productos</h4>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Categoria:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectCatVentas" style="width: 100%;" onchange="selectProdVentas(this.value)" class="form-control" required>
										</select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12">Producto:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectProdVentas" style="width: 100%;" class="form-control input-sm" required>
											<option>Seleccione una opcion</option>
										</select>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
									<button onclick="reporteVentasProductos();" class="btn btn-success btn-sm">
										<i class="fa fa-check"></i> Generar Kardex
									</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="kardexComprasProductos" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal">
								<span aria-hidden="true">&times;</span>
								<span class="sr-only">Cerrar</span>
							</button>
							<h4 class="modal-title"><i class="fa fa-box"></i> Kardex Compras Productos</h4>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Categoria:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectCatCompras" style="width: 100%;" onchange="selectProdCompras(this.value)" class="form-control" required>
										</select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12">Producto:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select id="selectProdCompras" style="width: 100%;" class="form-control input-sm" required>
											<option>Seleccione una opcion</option>
										</select>
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
									<button onclick="reporteComprasProductos();" class="btn btn-success btn-sm">
										<i class="fa fa-check"></i> Generar Kardex
									</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var date = new Date();
		var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth() + 1);
		var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
		var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
		var fecini = mes + "-" + Empresa.agregarCero(primerDia);
		var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
		var fechoy = mes + "-" + date.getDate();

		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisArqueo = [];
		var lisIngreso = [];
		var lisEgreso = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			selectSucursal(ids);
			cargarFechas();
			selectCategorias();
			if (idr == '2') {
				$('#mostrarsucursal').show();
			}
		}

		function cargarFechas() {
			$("#mes").val(mes);
			$("#finicio").val(fecini);
			$("#ffin").val(fecfin);
			$("#ffin").val(fecfin);
			var date0 = $('input[id="mes"]');
			var date1 = $('input[id="finicio"]');
			var date2 = $('input[id="ffin"]');
			var hoy = $('input[id="farqueo"]');
			date0.datepicker({
				format: 'yyyy-mm',
				startView: 'months',
				minViewMode: 'months',
				todayHighlight: true,
				autoclose: true,
			});
			date1.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			date2.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			hoy.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
		}

		function cam_inifin(dato) {
			Empresa.cambiarFechas(dato, "#finicio", "#ffin");
			mes = $("#mes").val();
			fecini = $("#finicio").val();
			fecfin = $("#ffin").val();
		}

		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor) {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectSucursal").val(valor);
					$("#selectSucursal").select2();
				}
			});
			ids = valor;
		}

		function selectEgresos() {
			Empresa.actualizarSelect({
				selector: "#selectEgreso",
				sql: "select id_tipo as id, concat(tipo_egreso) as etiqueta from tipo_egreso",
				callback: function(data) {
					$("#selectEgreso").select2();
				}
			});
		}

		function selectIngresos() {
			Empresa.actualizarSelect({
				selector: "#selectIngreso",
				sql: "select id_tipo as id, concat(tipo_ingreso) as etiqueta from tipo_ingreso where id_tipo<>'1'",
				callback: function(data) {
					$("#selectIngreso").select2();
				}
			});
		}

		function selectCategorias() {
			Empresa.actualizarSelect({
				selector: "#selectCatKardex",
				sql: "select categoria as id, concat(categoria) as etiqueta from categoria",
				callback: function(data) {
					$("#selectCatKardex").select2({
						dropdownParent: $('#kardexGeneralProductos')
					});
				}
			});
			Empresa.actualizarSelect({
				selector: "#selectCatVentas",
				sql: "select categoria as id, concat(categoria) as etiqueta from categoria",
				callback: function(data) {
					$("#selectCatVentas").select2({
						dropdownParent: $('#kardexVentasProductos')
					});
				}
			});
			Empresa.actualizarSelect({
				selector: "#selectCatCompras",
				sql: "select categoria as id, concat(categoria) as etiqueta from categoria",
				callback: function(data) {
					$("#selectCatCompras").select2({
						dropdownParent: $('#kardexComprasProductos')
					});
				}
			});
		}

		function selectProdKardex(valor) {
			Empresa.actualizarSelect({
				selector: "#selectProdKardex",
				sql: "select id_producto as id, concat(nombre) as etiqueta FROM producto where categoria = '" + valor + "';",
				callback: function(data) {
					$("#selectProdKardex").select2({
						dropdownParent: $('#kardexGeneralProductos')
					});
				}
			});
		}

		function selectProdVentas(valor) {
			Empresa.actualizarSelect({
				selector: "#selectProdVentas",
				sql: "select id_producto as id, concat(nombre) as etiqueta FROM producto where categoria = '" + valor + "';",
				callback: function(data) {
					$("#selectProdVentas").select2({
						dropdownParent: $('#kardexVentasProductos')
					});
				}
			});
		}

		function selectProdCompras(valor) {
			Empresa.actualizarSelect({
				selector: "#selectProdCompras",
				sql: "select id_producto as id, concat(nombre) as etiqueta FROM producto where categoria = '" + valor + "';",
				callback: function(data) {
					$("#selectProdCompras").select2({
						dropdownParent: $('#kardexComprasProductos')
					});
				}
			});
		}

		function reporteVentasGenerales() {
			Empresa.showSpinner();
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}

			var body = {
				funcion: "reporteVentas",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};

			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte de Ventas Generales</label><br><p>Del ' + fecini + ' al ' + fecfin + '</p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteVentas" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha Registro"
					}, {
						title: "Boleta"
					}, {
						title: "Vendedor"
					}, {
						title: "Producto"
					}, {
						title: "Precio Unitario"
					}, {
						title: "Cantidad"
					}, {
						title: "Precio Total"
					}];

					var ventas = respuesta.ventas.data;
					var repVenta = [];
					var totalCantidad = 0;
					var totalGeneral = 0;

					for (var i = 0; i < ventas.length; i++) {
						var cantidad = parseFloat(ventas[i].CANTIDAD);
						var total = parseFloat(ventas[i].TOTAL);

						totalCantidad += cantidad;
						totalGeneral += total;

						repVenta.push([
							i + 1,
							ventas[i].FECHA_REGISTRO,
							ventas[i].BOLETA,
							ventas[i].VENDEDOR,
							ventas[i].PRODUCTO,
							Empresa.financial(parseFloat(ventas[i].PRECIO_UNITARIO), 2),
							Empresa.financial(cantidad, 2),
							Empresa.financial(total, 2)
						]);
					}

					repVenta.push(["", "", "", "", "<b>Total</b>", "", `<b>${Empresa.financial(totalCantidad, 2)}</b>`, `<b>${Empresa.financial(totalGeneral, 2)}</b>`]);

					Empresa.inicializarTablaPrint({
						selector: ".reporteVentas",
						data: repVenta,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteVentasVendedor() {
			Empresa.showSpinner();
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "reporteVentasVendedor",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};
			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha Registro"
					}, {
						title: "Boleta"
					}, {
						title: "Vendedor"
					}, {
						title: "Producto"
					}, {
						title: "Precio Unitario"
					}, {
						title: "Cantidad"
					}, {
						title: "Precio Total"
					}];

					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;"> Reporte de Ventas por Vendedor </label><br><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var totalGlobalCantidad = 0;
					var totalGlobalPrecio = 0;

					var reportes = respuesta.reportes;
					for (var i = 0; i < reportes.length; i++) {
						var ventas = reportes[i].ventas.data;
						var repVenta = [];

						var panel = '<div class="panel panel-primary"><div class="panel-heading"><i class="fa fa-user"></i> ' + reportes[i].vendedor + ' </div><div class="panel-body" style="font-size:10px;"><table class="table table-striped table-bordered table-hover reporte' + i + '"></table></div></div>';
						elementoPanel.append(panel);

						var totalCantidad = 0;
						var totalPrecio = 0;

						for (var j = 0; j < ventas.length; j++) {
							totalCantidad += parseFloat(ventas[j].CANTIDAD);
							totalPrecio += parseFloat(ventas[j].TOTAL);

							repVenta.push([
								j + 1,
								ventas[j].FECHA_REGISTRO,
								ventas[j].BOLETA,
								ventas[j].VENDEDOR,
								ventas[j].NOMBRE,
								Empresa.financial(parseFloat(ventas[j].PRECIO_UNITARIO), 2),
								Empresa.financial(ventas[j].CANTIDAD, 2),
								Empresa.financial(ventas[j].TOTAL, 2)
							]);
						}

						repVenta.push(["", "", "", "", "<b>Total</b>", "", `<b>${Empresa.financial(totalCantidad, 2)}</b>`, `<b>${Empresa.financial(totalPrecio, 2)}</b>`]);

						Empresa.inicializarTablaPrint({
							selector: ".reporte" + i,
							data: repVenta,
							columnas: columnsName
						});

						totalGlobalCantidad += totalCantidad;
						totalGlobalPrecio += totalPrecio;
					}

					var totalesGlobalesHtml = '<div class="panel panel-primary"><div class="panel-body" style="font-size:12px; margin-top: 10px;"><div class="row"><div class="col-xs-6 text-right"><b>Total Global Cantidad:</b></div><div class="col-xs-2"><input type="text" readonly value="' + Empresa.financial(totalGlobalCantidad, 2) + '" class="form-control"></div><div class="col-xs-2 text-right"><b>Total Global Precio:</b></div><div class="col-xs-2"><input type="text" readonly value="' + Empresa.financial(totalGlobalPrecio, 2) + '" class="form-control"></div></div></div></div>';

					elementoPanel.append(totalesGlobalesHtml);


					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-12"><label> Fecha: </label> ' + fecha + ' </div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}



		function reportePerdidasGanancias() {
			Empresa.showSpinner();
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "reportePerdidasGanancias",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};
			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px" src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;"> Reporte Perdidas Ganancias </label><br><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';

					elementoPanel.append(cabecera);

					var reportes = respuesta.reportes;

					var columnsName = [{
						title: "#"
					}, {
						title: "Codigo"
					}, {
						title: "Producto"
					}, {
						title: "Compras"
					}, {
						title: "Ventas"
					}, {
						title: "Ganancias"
					}];

					var totalGlobalCompras = 0.0;
					var totalGlobalVentas = 0.0;
					var totalGlobalGanancias = 0.0;

					for (var i = 0; i < reportes.length; i++) {
						var ventas = reportes[i].ventas;
						ventas = ventas.data;

						var scompras = 0.0,
							sventas = 0.0,
							sganancias = 0.0;
						var repVenta = [];

						var panel = '<div class="panel panel-primary"><div class="panel-heading"><i class="fa fa-calendar"></i> Fecha : ' + reportes[i].fecha + ' </div><div class="panel-body" style="font-size:10px;"><table class="table table-striped table-bordered table-hover reporte' + i + '"></table></div></div>';
						elementoPanel.append(panel);

						for (var j = 0; j < ventas.length; j++) {
							scompras += parseFloat(ventas[j].compras);
							sventas += parseFloat(ventas[j].ventas);
							sganancias += parseFloat(ventas[j].ganancias);

							repVenta.push([
								j + 1,
								ventas[j].CODIGO,
								ventas[j].NOMBRE,
								Empresa.financial(parseFloat(ventas[j].compras), 2),
								Empresa.financial(parseFloat(ventas[j].ventas), 2),
								Empresa.financial(parseFloat(ventas[j].ganancias), 2)
							]);
						}

						// Sumar a los totales globales
						totalGlobalCompras += scompras;
						totalGlobalVentas += sventas;
						totalGlobalGanancias += sganancias;

						repVenta.push(["", "", "<b>Total</b>", `<b>${Empresa.financial(scompras, 2)}</b>`, `<b>${Empresa.financial(sventas, 2)}</b>`, `<b>${Empresa.financial(sganancias, 2)}</b>`]);


						Empresa.inicializarTablaPrint({
							selector: ".reporte" + i,
							data: repVenta,
							columnas: columnsName
						});
					}

					// Mostrar totales globales
					var totalesGlobalesHtml = '<div class="panel panel-primary" style="margin-top: 20px;"><div class="panel-body" style="font-size:10px;"><div class="row"><div class="col-xs-4"><b>Total Compras:</b><input type="text" readonly value="' + Empresa.financial(totalGlobalCompras, 2) + '" class="form-control"></div><div class="col-xs-4"><b>Total Ventas:</b><input type="text" readonly value="' + Empresa.financial(totalGlobalVentas, 2) + '" class="form-control"></div><div class="col-xs-4"><b>Total Ganancias:</b><input type="text" readonly value="' + Empresa.financial(totalGlobalGanancias, 2) + '" class="form-control"></div></div></div></div>';

					elementoPanel.append(totalesGlobalesHtml);

					var meses = new Array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-12"><label> Fecha: </label> ' + fecha + ' </div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteProductosMasVendidos() {
			Empresa.showSpinner();

			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal === "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "reporteProductosMasVendidos",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};

			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px" src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;">' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;">' + dir + '</p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + '</p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte Productos Mas Vendidos</label><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteMasVendidos" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Producto"
					}, {
						title: "Cantidad"
					}, {
						title: "Precio"
					}];

					var reportes = respuesta.reportes.data;
					var repMasVendidos = [];
					var totalCantidad = 0;
					var totalPrecio = 0;

					for (var i = 0; i < reportes.length; i++) {
						var cantidad = parseFloat(reportes[i].CANTIDAD);
						var precio = parseFloat(reportes[i].PRECIO);

						totalCantidad += cantidad;
						totalPrecio += precio;

						repMasVendidos.push([
							i + 1,
							reportes[i].PRODUCTO,
							cantidad,
							Empresa.financial(precio, 2)
						]);


					}

					repMasVendidos.push(["", "<b>Total</b>", `<b>${totalCantidad}</b>`, `<b>${Empresa.financial(totalPrecio, 2)}</b>`]);

					Empresa.inicializarTablaPrint({
						selector: ".reporteMasVendidos",
						data: repMasVendidos,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}


		// -------------------------------  Reportes Compras ---------------------------------

		function reporteComprasGenerales() {
			Empresa.showSpinner();
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}

			var body = {
				funcion: "reporteCompras",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};

			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte de Compras Generales</label><br><p>Del ' + fecini + ' al ' + fecfin + '</p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteCompras" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha Registro"
					}, {
						title: "Boleta"
					}, {
						title: "Proveedor"
					}, {
						title: "Producto"
					}, {
						title: "Precio Unitario"
					}, {
						title: "Cantidad"
					}, {
						title: "Precio Total"
					}];

					var compras = respuesta.compras.data; // Asegúrate de que esta sea la propiedad correcta
					var repCompra = [];
					var totalCantidad = 0;
					var totalGeneral = 0;

					for (var i = 0; i < compras.length; i++) {
						var cantidad = parseFloat(compras[i].CANTIDAD);
						var total = parseFloat(compras[i].TOTAL);

						totalCantidad += cantidad;
						totalGeneral += total;

						repCompra.push([
							i + 1,
							compras[i].FECHA_REGISTRO,
							compras[i].BOLETA,
							compras[i].PROVEEDOR,
							compras[i].NOMBRE,
							Empresa.financial(parseFloat(compras[i].PRECIO_UNITARIO), 2),
							Empresa.financial(cantidad, 2),
							Empresa.financial(total, 2)
						]);
					}

					// Agregar la fila de total
					repCompra.push(["", "", "", "", "<b>Total</b>", "", `<b>${Empresa.financial(totalCantidad, 2)}</b>`, `<b>${Empresa.financial(totalGeneral, 2)}</b>`]);

					Empresa.inicializarTablaPrint({
						selector: ".reporteCompras",
						data: repCompra,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}


		function reporteComprasProveedor() {
			Empresa.showSpinner();
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}

			var body = {
				funcion: "reporteComprasProveedor",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};
			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Proveedor"
					}, {
						title: "Producto"
					}, {
						title: "Precio Unitario"
					}, {
						title: "Cantidad"
					}, {
						title: "Total"
					}];

					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px" src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;">' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;">' + dir + '</p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + '</p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte de Compras por Proveedor</label><br><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var totalGlobalCantidad = 0;
					var totalGlobalPrecio = 0;

					var reportes = respuesta.reportes;
					for (var i = 0; i < reportes.length; i++) {
						var compras = reportes[i].compras.data;
						var repCompra = [];

						var panel = '<div class="panel panel-info"><div class="panel-heading"><i class="fa fa-ticket"></i> Proveedor : ' + reportes[i].proveedor + '</div><div class="panel-body" style="font-size:10px;"><table class="table table-striped table-bordered table-hover reporte' + i + '"></table></div></div>';
						elementoPanel.append(panel);

						var totalCantidad = 0;
						var totalPrecio = 0;

						for (var j = 0; j < compras.length; j++) {
							totalCantidad += parseFloat(compras[j].CANTIDAD);
							totalPrecio += parseFloat(compras[j].TOTAL);

							repCompra.push([
								j + 1,
								compras[j].FECHA_REGISTRO,
								compras[j].BOLETA,
								compras[j].PROVEEDOR, // Ajustar esto si el campo correcto es diferente
								"<div style='text-align:left;'>" + compras[j].NOMBRE + "</div>",
								Empresa.financial(parseFloat(compras[j].PRECIO_UNITARIO), 2),
								Empresa.financial(compras[j].CANTIDAD, 2),
								Empresa.financial(compras[j].TOTAL, 2)
							]);
						}

						repCompra.push(["", "", "", "", "<b>Total</b>", "", `<b>${Empresa.financial(totalCantidad, 2)}</b>`, `<b>${Empresa.financial(totalPrecio, 2)}</b>`]);

						Empresa.inicializarTablaPrint({
							selector: ".reporte" + i,
							data: repCompra,
							columnas: columnsName
						});

						totalGlobalCantidad += totalCantidad;
						totalGlobalPrecio += totalPrecio;
					}

					var totalesGlobalesHtml = '<div class="panel panel-info"><div class="panel-body" style="font-size:12px; margin-top: 10px;"><div class="row"><div class="col-xs-6 text-right"><b>Total Global Cantidad:</b></div><div class="col-xs-2"><input type="text" readonly value="' + Empresa.financial(totalGlobalCantidad, 2) + '" class="form-control"></div><div class="col-xs-2 text-right"><b>Total Global Precio:</b></div><div class="col-xs-2"><input type="text" readonly value="' + Empresa.financial(totalGlobalPrecio, 2) + '" class="form-control"></div></div></div></div>';

					elementoPanel.append(totalesGlobalesHtml);

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-12"><label> Fecha: </label> ' + fecha + ' </div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		// -------------------------------  Reportes Traspasos ---------------------------------

		function reporteTraspasos() {
			$('#tabreporte').tab('show');
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "reporteTraspasos",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};
			var elementoPanel = $("#panelreporte");
			var i = 0;
			var j = 0;
			var k = 0;
			var totsfinal = 0;
			var totscantidad = 0;
			elementoPanel.hide();
			elementoPanel.empty();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;"> Reporte General Traspasos </label><br><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var enviados = respuesta.enviados.data;
					var recibidos = respuesta.recibidos.data;
					var scantidad = 0;
					var sprecio = 0;
					var rscantidad = 0;
					var rsprecio = 0;
					var repEnviado = [];
					var repRecibido = [];
					var panel = ' <div class="panel panel-info"><div class="panel-heading"><i class="fa fa-ticket"></i> Detalle Productos Traspasados Enviados </div><div class="panel-body" style="font-size:9px;"><table class="table table-striped table-bordered table-hover reporteenviados" ></table></div></div><div class="panel panel-info"><div class="panel-heading"><i class="fa fa-ticket"></i> Detalle Productos Traspasados Recibidos </div><div class="panel-body" style="font-size:9px;"><table class="table table-striped table-bordered table-hover reporterecibidos" ></table></div></div>';
					elementoPanel.append(panel);
					var columnsName = [{
						title: "#"
					}, {
						title: " Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Origen"
					}, {
						title: "Destino"
					}, {
						title: " Producto"
					}, {
						title: " Precio Unitario"
					}, {
						title: " Cantidad"
					}, {
						title: " Total"
					}];
					for (var j = 0; j < enviados.length; j++) {
						scantidad = parseFloat(scantidad) + parseFloat(enviados[j].CANTIDAD);
						sprecio = parseFloat(sprecio) + parseFloat(enviados[j].TOTAL);
						repEnviado.push([
							j + 1,
							enviados[j].FECHA_REGISTRO,
							enviados[j].BOLETA,
							enviados[j].ORIGEN,
							enviados[j].DESTINO,
							"<div style='text-align:left;'>" + enviados[j].DESCRIPCION + "</div>",
							"<div style='text-align:right;'>" + enviados[j].PRECIO_UNITARIO + "</div>",
							enviados[j].CANTIDAD,
							"<div style='text-align:right;'>" + enviados[j].TOTAL + "</div>"
						]);
					}
					repEnviado.push([
						"", "", "", "", "", "", "<div style='text-align:right;'><b> TOTALES : </b></div>", "<b>" + scantidad + "</b>", "<div style='text-align:right;'><b>" + Empresa.financial(sprecio, 2) + "</b></div>"
					]);
					Empresa.inicializarTablaPrint({
						selector: ".reporteenviados",
						data: repEnviado,
						columnas: columnsName
					});

					for (var j = 0; j < recibidos.length; j++) {
						rscantidad = parseFloat(rscantidad) + parseFloat(recibidos[j].CANTIDAD);
						rsprecio = parseFloat(rsprecio) + parseFloat(recibidos[j].TOTAL);
						repRecibido.push([
							j + 1,
							recibidos[j].FECHA_REGISTRO,
							recibidos[j].BOLETA,
							recibidos[j].ORIGEN,
							recibidos[j].DESTINO,
							"<div style='text-align:left;'>" + recibidos[j].DESCRIPCION + "</div>",
							"<div style='text-align:right;'>" + recibidos[j].PRECIO_UNITARIO + "</div>",
							recibidos[j].CANTIDAD,
							"<div style='text-align:right;'>" + recibidos[j].TOTAL + "</div>"
						]);
					}
					repRecibido.push([
						"", "", "", "", "", "", "<div style='text-align:right;'><b> TOTALES : </b></div>", "<b>" + rscantidad + "</b>", "<div style='text-align:right;'><b>" + Empresa.financial(rsprecio, 2) + "</b></div>"
					]);
					Empresa.inicializarTablaPrint({
						selector: ".reporterecibidos",
						data: repRecibido,
						columnas: columnsName
					});

					var meses = new Array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-3"><label> Fecha: </label> ' + fecha + ' </div><div class="col-sm-9">  </div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}
		// -------------------------------  Reportes Ajustes ---------------------------------

		function reporteAjustes() {
			$('#tabreporte').tab('show');
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}

			var body = {
				funcion: "reporteAjustes",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};

			var elementoPanel = $("#panelreporte");
			var totsfinal = 0;
			var totscantidad = 0;

			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;"> Reporte General Ajustes </label><br><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);
					var ajustes = respuesta.ajustes.data;
					var scantidad = 0;
					var sprecio = 0;
					var repAjuste = [];
					var panel = '<table class="table table-striped table-bordered table-hover reporteajuste" style="font-size:9px;"></table>';
					elementoPanel.append(panel);
					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Código Barras"
					}, {
						title: "Producto"
					}, {
						title: "Precio Unitario"
					}, {
						title: "Cantidad"
					}, {
						title: "Total"
					}];

					for (var j = 0; j < ajustes.length; j++) {
						scantidad = parseFloat(scantidad) + parseFloat(ajustes[j].CANTIDAD);
						sprecio = parseFloat(sprecio) + parseFloat(ajustes[j].TOTAL);
						repAjuste.push([
							j + 1,
							ajustes[j].FECHA_REGISTRO,
							ajustes[j].BOLETA,
							"<div style='text-align:left;'>" + ajustes[j].ID_PRODUCTO + "</div>",
							"<div style='text-align:left;'>" + ajustes[j].NOMBRE + "</div>",
							"<div style='text-align:right;'>" + ajustes[j].PRECIO_UNITARIO + "</div>",
							ajustes[j].CANTIDAD,
							"<div style='text-align:right;'>" + ajustes[j].TOTAL + "</div>"
						]);
					}

					repAjuste.push([
						"", "", "", "", "", "<div style='text-align:right;'><b>TOTALES:</b></div>", "<b>" + scantidad + "</b>", "<div style='text-align:right;'><b>" + Empresa.financial(sprecio, 2) + "</b></div>"
					]);

					totscantidad = parseFloat(totscantidad) + parseFloat(scantidad);
					totsfinal = parseFloat(totsfinal) + parseFloat(sprecio);

					Empresa.inicializarTablaPrint({
						selector: ".reporteajuste",
						data: repAjuste,
						columnas: columnsName
					});

					var meses = new Array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-3"><label> Fecha: </label> ' + fecha + ' </div><div class="col-sm-9">  </div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}


		// -------------------------------  Reportes Bajas ---------------------------------

		function reporteBajas() {
			$('#tabreporte').tab('show');
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "reporteBajas",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};
			var elementoPanel = $("#panelreporte");
			var i = 0;
			var j = 0;
			var k = 0;
			var totsfinal = 0;
			var totscantidad = 0;
			elementoPanel.hide();
			elementoPanel.empty();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;"> Reporte General Bajas </label><br><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);
					var bajas = respuesta.bajas.data;
					var scantidad = 0;
					var sprecio = 0;
					var repBaja = [];
					var panel = ' <table class="table table-striped table-bordered table-hover reportebaja" style="font-size:9px;"></table>';
					elementoPanel.append(panel);
					var columnsName = [{
						title: "#"
					}, {
						title: " Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Vendedor"
					}, {
						title: " Codigo Barras"
					}, {
						title: " Producto"
					}, {
						title: " Precio Unitario"
					}, {
						title: " Cantidad"
					}, {
						title: " Total"
					}];
					for (var j = 0; j < bajas.length; j++) {
						scantidad = parseFloat(scantidad) + parseFloat(bajas[j].CANTIDAD);
						sprecio = parseFloat(sprecio) + parseFloat(bajas[j].TOTAL);
						repBaja.push([
							j + 1,
							bajas[j].FECHA_REGISTRO,
							bajas[j].BOLETA,
							bajas[j].VENDEDOR,
							"<div style='text-align:left;'>" + bajas[j].ID_PRODUCTO + "</div>",
							"<div style='text-align:left;'>" + bajas[j].NOMBRE + "</div>",
							"<div style='text-align:right;'>" + bajas[j].PRECIO_UNITARIO + "</div>",
							bajas[j].CANTIDAD,
							"<div style='text-align:right;'>" + bajas[j].TOTAL + "</div>"
						]);
					}
					repBaja.push([
						"", "", "", "", "", "", "<div style='text-align:right;'><b> TOTALES : </b></div>", "<b>" + scantidad + "</b>", "<div style='text-align:right;'><b>" + Empresa.financial(sprecio, 2) + "</b></div>"
					]);
					totscantidad = parseFloat(totscantidad) + parseFloat(scantidad);
					totsfinal = parseFloat(totsfinal) + parseFloat(sprecio);
					Empresa.inicializarTablaPrint({
						selector: ".reportebaja",
						data: repBaja,
						columnas: columnsName
					});

					var meses = new Array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-3"><label> Fecha: </label> ' + fecha + ' </div><div class="col-sm-9">  </div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		// -------------------------------  Reportes Arqueos ---------------------------------

		function reporteArqueo() {
			$('#tabreporte').tab('show');
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "reporteArqueo",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};
			var elementoPanel = $("#panelreporte");
			var i = 0;
			var j = 0;
			var k = 0;
			var totsfinal = 0;
			var totscantidad = 0;
			elementoPanel.hide();
			elementoPanel.empty();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;"> Reporte Arqueos Dia </label><br><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);
					var reportes = respuesta.reportes;
					for (var i = 0; i < reportes.length; i++) {
						var arqueos = reportes[i].arqueos;
						var scantidad = 0;
						var sprecio = 0;
						var repArqueo = [];
						var panel = ' <div class="panel panel-primary"><div class="panel-heading"><i class="fa fa-calendar"></i> Fecha : ' + reportes[i].fecha + ' </div><div class="panel-body" style="font-size:10px;"><table class="table table-striped table-bordered table-hover reporte' + i + '"><thead><tr><th colspan="6"></th><th colspan="3"><center> Ventas </center></th><th colspan="2"><center> Operaciones </center></th><th colspan="2"><center>  </center></th> </tr><tr><th>#</th><th>Fecha</th><th>Sucursal</th><th>Cajero</th><th>Turno</th><th>Saldo Anterior</th><th>Efectivo</th><th>QR</th><th>Tarjeta</th><th>Otro Ingreso</th><th>Egresos</th><th>Total</th><th>Estado</th></tr></thead> </table></div></div>';
						elementoPanel.append(panel);
						for (var j = 0; j < arqueos.length; j++) {
							repArqueo.push([
								j + 1,
								arqueos[j].fecha_registro,
								arqueos[j].sucursal,
								arqueos[j].cajero,
								arqueos[j].turno,
								arqueos[j].saldo_anterior,
								arqueos[j].vefe,
								arqueos[j].vqr,
								arqueos[j].vtj,
								arqueos[j].ingresos,
								arqueos[j].egresos,
								arqueos[j].total_general,
								arqueos[j].estado,
								"<div style='text-align:right;'>" + arqueos[j].precio + "</div>"
							]);
						}
						Empresa.inicializarTablaformato({
							selector: ".reporte" + i + "",
							data: repArqueo
						});
					}
					var meses = new Array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-3"><label> Fecha: </label> ' + fecha + ' </div><div class="col-sm-9">  </div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteFacturas() {
			Empresa.showSpinner();
			var columnsName = [{
				title: "#"
			}, {
				title: "Fecha"
			}, {
				title: "Hora"
			}, {
				title: "N° Factura"
			}, {
				title: "NIT"
			}, {
				title: "Razon Social"
			}, {
				title: "SubTotal"
			}, {
				title: "Descuento "
			}, {
				title: "Total Sujeto a Iva"
			}, {
				title: "Emision"
			}, {
				title: "Estado"
			}];
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "reporteFacturas",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin
			};
			var elementoPanel = $("#panelreporte");
			var lisfacturas = [];
			elementoPanel.hide();
			elementoPanel.empty();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;"> Reporte Facturas </label><br><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);
					var panel = ' <table class="table table-striped table-bordered table-hover lisfacturas" style="font-size:9px;"></table>';
					elementoPanel.append(panel);
					var reportes = respuesta.reportes;
					var sumaDeuda = 0;
					for (var i = 0; i < reportes.length; i++) {
						if (reportes[i].tipoEmision == '1') {
							var emision = 'EN LINEA';
						} else {
							var emision = 'FUERA DE LINEA'
						}
						sumaDeuda += parseFloat(reportes[i].montoTotalSujetoIva);
						lisfacturas.push([
							"" + (i + 1),
							reportes[i].fecha,
							reportes[i].hora,
							reportes[i].numeroFactura,
							reportes[i].numeroDocumento,
							reportes[i].nombreRazonSocial,
							Empresa.financial(parseFloat(reportes[i].montoTotalSujetoIva) + parseFloat(reportes[i].descuentoAdicional) + parseFloat(reportes[i].montoGiftCard), 2),
							reportes[i].descuentoAdicional,
							reportes[i].montoTotalSujetoIva,
							emision,
							reportes[i].estado
						]);
					}
					lisfacturas.push(['', '', '', '', '', '', '', '<b>Total Bs.</b>', Empresa.financial(sumaDeuda, 2), '', '']);
					Empresa.inicializarTablaPrint({
						selector: ".lisfacturas",
						data: lisfacturas,
						columnas: columnsName
					});
					var meses = new Array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-3"><label> Fecha: </label> ' + fecha + ' </div><div class="col-sm-9">  </div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteKardexProducto() {
			Empresa.showSpinner();

			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal === "") {
				idsucursal = ids;
			}
			var selectProducto = document.getElementById("selectProdKardex");
			var idProducto = selectProducto.value;
			var nombreProducto = selectProducto.options[selectProducto.selectedIndex].text;
			var body = {
				funcion: "reporteKardexProducto",
				idsucursal: idsucursal,
				idProducto: idProducto,
				fecini: fecini,
				fecfin: fecfin
			};

			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					$('#kardexGeneralProductos').modal('hide');
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Kardex General Producto </label><br><p>Producto: ' + nombreProducto + ' </p><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteKardex" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Transaccion"
					}, {
						title: "Entrada"
					}, {
						title: "Salida"
					}, {
						title: "Saldo"
					}];

					var kardex = respuesta.reportes;
					var repKardex = [];

					for (var i = 0; i < kardex.length; i++) {
						repKardex.push([
							i + 1,
							kardex[i].fecha_registro,
							kardex[i].boleta,
							kardex[i].transaccion,
							kardex[i].entrada,
							kardex[i].salida,
							kardex[i].saldo
						]);
					}


					Empresa.inicializarTablaPrint({
						selector: ".reporteKardex",
						data: repKardex,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteVentasProductos() {
			$('#tabreporte').tab('show');
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal === "") {
				idsucursal = ids;
			}
			var selectProducto = document.getElementById("selectProdVentas");
			var idProducto = selectProducto.value;
			var nombreProducto = selectProducto.options[selectProducto.selectedIndex].text;

			var body = {
				funcion: "reporteVentasProductos",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin,
				idProducto: idProducto
			};

			var elementoPanel = $("#panelreporte");
			var totalCantidad = 0;
			var totalPrecio = 0;
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					$('#kardexVentasProductos').modal('hide');
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte Ventas Producto </label><br><p>Producto: ' + nombreProducto + ' </p><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';

					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteVentas" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Producto"
					}, {
						title: "Precio"
					}, {
						title: "Cantidad"
					}, {
						title: "Total"
					}];

					var ventas = respuesta.producto.data;
					var repVentas = [];
					var totalCantidad = 0;
					var totalPrecio = 0;

					for (var i = 0; i < ventas.length; i++) {
						var cantidad = parseFloat(ventas[i].Cantidad);
						var precio = parseFloat(ventas[i].Total_Precio_Venta);

						totalCantidad += cantidad;
						totalPrecio += precio;

						repVentas.push([
							i + 1,
							ventas[i].Fecha_Venta,
							ventas[i].Boleta,
							ventas[i].Producto,
							Empresa.financial(ventas[i].Precio_Unitario, 2),
							Empresa.financial(cantidad, 2),
							Empresa.financial(precio, 2)
						]);
					}

					repVentas.push(["", "", "", "", "<b>Total</b>", `<b>${Empresa.financial(totalCantidad, 2)}</b>`, `<b>${Empresa.financial(totalPrecio, 2)}</b>`]);

					Empresa.inicializarTablaPrint({
						selector: ".reporteVentas",
						data: repVentas,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear();
					var pie = '<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>';
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteComprasProductos() {
			$('#tabreporte').tab('show');
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal === "") {
				idsucursal = ids;
			}
			var selectProducto = document.getElementById("selectProdCompras");
			var idProducto = selectProducto.value;
			var nombreProducto = selectProducto.options[selectProducto.selectedIndex].text;

			var body = {
				funcion: "reporteComprasProductos",
				idsucursal: idsucursal,
				fecini: fecini,
				fecfin: fecfin,
				idProducto: idProducto
			};

			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					$('#kardexComprasProductos').modal('hide');
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte Compras Producto </label><br><p>Producto: ' + nombreProducto + ' </p><p> Del ' + fecini + ' al ' + fecfin + ' </p></center></div></div><br>';
					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteCompras" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Fecha"
					}, {
						title: "Boleta"
					}, {
						title: "Producto"
					}, {
						title: "Precio"
					}, {
						title: "Cantidad"
					}, {
						title: "Total"
					}];

					var compras = respuesta.producto.data;
					var repCompras = [];
					var totalCantidad = 0;
					var totalPrecio = 0;
					for (var i = 0; i < compras.length; i++) {
						var cantidad = parseFloat(compras[i].Cantidad);
						var precio = parseFloat(compras[i].Total_Precio_Compra);
						totalCantidad += cantidad;
						totalPrecio += precio;

						repCompras.push([
							i + 1,
							compras[i].Fecha_Compra,
							compras[i].Boleta,
							compras[i].Producto,
							Empresa.financial(compras[i].Precio_Unitario, 2),
							Empresa.financial(cantidad, 2),
							Empresa.financial(precio, 2)
						]);
					}

					repCompras.push(["", "", "", "", "<b>Total</b>", `<b>${Empresa.financial(totalCantidad, 2)}</b>`, `<b>${Empresa.financial(totalPrecio, 2)}</b>`]);

					Empresa.inicializarTablaPrint({
						selector: ".reporteCompras",
						data: repCompras,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function reporteStockMinimo() {
			$('#tabreporte').tab('show');
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal === "") {
				idsucursal = ids;
			}

			var body = {
				funcion: "reporteStockMinimo",
				idsucursal: idsucursal
			};

			var elementoPanel = $("#panelreporte");
			elementoPanel.hide();
			elementoPanel.empty();

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/reporte/funcionesReporte.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cabecera = '<div class="row"><div class="col-xs-2"><center><img class="logo-name" width="80px"  src="img/empresa/' + logo + '"></center></div><div class="col-xs-4"><label style="font-size:10px; margin-bottom: 1px;"> ' + emp + '</label><p style="font-size:8px; margin-bottom: 1px;">' + nomSuc + '</p><p style="font-size:8px; margin-bottom: 1px;"> ' + dir + ' </p><p style="font-size:8px; margin-bottom: 1px;">telf. ' + telf + ' </p><p style="font-size:8px; margin-bottom: 1px;">' + loc + '-' + ciu + '</p></div><div class="col-xs-6"><br><center><label style="font-size:16px;">Reporte Productos Stock Minimo </label></center></div></div><br>';
					elementoPanel.append(cabecera);

					var panel = '<table class="table table-striped table-bordered table-hover reporteStockMin" style="font-size:9px;"></table>';
					elementoPanel.append(panel);

					var columnsName = [{
						title: "#"
					}, {
						title: "Codigo"
					}, {
						title: "Codigo Barras"
					}, {
						title: "Producto"
					}, {
						title: "Unidad"
					}, {
						title: "Stock Actual"
					}, {
						title: "Stock Minimo"
					}];

					var stockmin = respuesta.reportes.data;
					var repStokMinimo = [];
					var totalCantidad = 0;
					var totalPrecio = 0;
					for (var i = 0; i < stockmin.length; i++) {
						repStokMinimo.push([
							i + 1,
							stockmin[i].codigo,
							stockmin[i].codigo_barras,
							stockmin[i].nombre,
							stockmin[i].unidad,
							Empresa.financial(stockmin[i].stock, 2),
							Empresa.financial(stockmin[i].stock_minimo, 2)
						]);
					}

					Empresa.inicializarTablaPrint({
						selector: ".reporteStockMin",
						data: repStokMinimo,
						columnas: columnsName
					});

					var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
					var f = new Date();
					var fecha = `${f.getDate()} de ${meses[f.getMonth()]} de ${f.getFullYear()}`;
					var pie = `<div class="row"><div class="col-sm-3"><label>Fecha: </label> ${fecha}</div><div class="col-sm-9"></div></div><br>`;
					elementoPanel.append(pie);
					elementoPanel.show();
				}
			});
		}

		function imprimirReporte() {
			var cabeza = "";
			var pie = "";
			var url = Empresa.armarUrl("producto.php");
			var div = '#panelreporte';
			Empresa.impDiv(div, url, cabeza, pie);
		}
		this.initializer();
	</script>
</body>

</html>