<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Traspaso Productos </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<div class="col-sm-2">
									<h5>Sucursal : <b id='nomSucursal'></b></h5>
								</div>
								<div class="col-lg-2">
									<div id="mostrarsucursal" style="display:none;">
										<select class="form-control" id="selectSucursal"></select>
									</div>
								</div>
								<div class="row form-group col-sm-8">
									<div class="col-sm-11">
										<label class="col-sm-1 control-label"> Mes:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='mes' onchange="cam_inifin(this.value);" required />
										</div>
										<label class="col-sm-1 control-label"> F.Ini:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='finicio' required />
										</div>
										<label class="col-sm-1 control-label"> F.Fin:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='ffin' required />
										</div>
									</div>
									<div class="col-sm-1">
										<button class="btn btn-info btn-sm " onclick="cargarTraspasos();"> <i class="fa fa-filter"></i> </button>
									</div>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active "> <a id="tabtraspaso" href="#tab-1" data-toggle="tab"><label class="text-navy"><i class="fa fa-shopping-cart"></i> Realizar Traspasos</a></label></li>
									<li> <a id="tablistado" href="#tab-2" onclick="cargarTraspasos();"><label class="text-navy"><i class="fa fa-tags"></i> Listado Traspasos </a></label></li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-9">
													<div class="ibox">
														<div class="ibox-title">
															<div class="col-md-4">
																<h5> Listado Productos </h5>
															</div>
															<div class="col-md-2">
																<label style="text-align: right;">Stock Total: </label>
															</div>
															<div class="col-md-2">
																<input class="form-control input-sm" type="text" id="stocktotal" disabled>
															</div>
															<div class="col-md-4">

															</div>
														</div>
														<div class="ibox-content">
															<div class="row">
																<div class="col-md-6">
																	<select class="form-control" id="selectInventario" onchange="agregarItemStock(this,1)" style="width: 100%;" required></select>
																</div>
																<div class="col-md-6">
																	<div class="input-group">
																		<input type="text" id="codbar_tras" placeholder="Ingrese codigo de Barras" onkeypress="ingresarCodigo(event)" class="form-control input-sm vnt"><span class="input-group-btn"> <button type="button" style="width:35px;" onclick="buscarCodigoBarras()" class="btn btn-info btn-sm"><i class="fa fa-search"></i></button></span>
																	</div>
																</div>
															</div>
															<div class="row">
																<div class="ibox-content">
																	<div class="table-responsive">
																		<table class="table table-striped table-bordered table-hover lisPedido" style="font-size:10px;">
																		</table>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="col-md-3">

													<div class="ibox">
														<div class="ibox-title">
															<span class="pull-right btn btn-primary btn-outline btn-sm"> <i class="fa fa-shopping-cart"></i>(<strong id="itmcantidad">0</strong>) Items</span>
															<h5>Detalle Traspaso <small>( TC : <span id="tcempresa"></span> )</small></h5>
														</div>

														<div class="ibox-content">
															<div class="form-horizontal form-label-left">
																<label class="control-label">Origen:</label>
																<select class="form-control" id="selectOrigen" style="width: 100%;" disabled required></select>
																<label class="control-label">Destino: </label>
																<select class="form-control" id="selectDestino" style="width: 100%;" required></select>
																<label class="control-label">Concepto: </label>
																<input type="text" id="concepto_tras" value="-" class="form-control ven">
																<label class="control-label">Cantidad: </label>
																<input type="text" value="0" id="cantidad_tras" class="form-control ven" readonly>
																<label class="control-label">Precio Total</label>
																<input type="text" value="0" id="precio_tras" class="form-control ven" readonly>
																<div class="modal-footer">
																	<button onclick="realizarTraspaso()" class="btn btn-primary"> Realizar Traspaso </button>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-content">
														<div class="tabs-container">
															<div class="tabs-left">
																<ul class="nav nav-tabs">
																	<li><a class="nav-link active" data-toggle="tab" style="color:#337ab7" href="#tab0"> Traspasos Enviados </a></li>
																	<li><a class="nav-link" style="color:#337ab7" data-toggle="tab" href="#tab1"> Traspasos Recibidos </a></li>
																</ul>
																<div class="tab-content ">
																	<div id="tab0" class="tab-pane active">
																		<div class="panel-body">
																			<strong> Traspasos Enviados </strong>
																			<hr>
																			<p>
																			<div class="table-responsive" style="font-size:10px; width:100%;">
																				<table class="table table-striped table-bordered table-hover lisenviado" style="font-size:10px; width:100%;"></table>
																			</div>
																			</p>
																		</div>
																	</div>
																	<div id="tab1" class="tab-pane">
																		<div class="panel-body">
																			<strong> Traspasos Recibidos</strong>
																			<hr>
																			<p>
																			<div class="table-responsive" style="font-size:10px; width:100%;">
																				<table class="table table-striped table-bordered table-hover lisrecibido" style="font-size:10px; width:100%;">
																				</table>
																			</div>
																			</p>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newVendedor" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Vendedor</h4>
							<small> Registro de un nuevo Vendedor </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Nomnbre Completo :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="rzsvend" class="form-control col-md-7 col-xs-12 vends">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="telvend" class="form-control col-md-7 col-xs-12 vends">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newVendedor();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="modal inmodal" id="newCliente" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Cliente</h4>
							<small> Registro de un nuevo Cliente </small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Nombres :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="rzscli" class="form-control col-md-7 col-xs-12 clis">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="telcli" class="form-control col-md-7 col-xs-12 clis">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newCliente();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalImagenes" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-camera"></i> Imagenes del Producto</h4>
							<small>Todas las Imagenes del Producto</small>
						</div>
						<div class="modal-body">
							<form method="post" enctype="multipart/form-data" id="multimediaForm">
								<div class="row">
									<div class="form-group">
										<div class="col-md-2 col-sm-2 col-xs-2">
											<label class="control-label"> Imagenes: </label>
										</div>
										<div class="col-md-8 col-sm-8 col-xs-8">
											<input type="hidden" id="updidpro">
											<input type="file" class="form-control" name="images[]" id="fileInput" onchange="vistaPreviaMultiple() ;" multiple>
										</div>
										<div class="col-md-2 col-sm-2 col-xs-2">
											<button onclick="newImagenes();" class="btn btn-success btn-sm"><i class="fa fa-upload"></i> Subir Imagenes</button>
										</div>
									</div>
								</div><br>
								<div class="row" id="vista-previa"></div>
							</form>
							<div class="row">
								<div class="col-md-12">
									<div class="ibox-content" id="lisimagenes">

									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var date = new Date();
		var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth() + 1);
		var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
		var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
		var fecini = mes + "-" + Empresa.agregarCero(primerDia);
		var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
		var fechoy = mes + "-" + date.getDate();


		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisEnviado = [];
		var lisRecibido = [];
		var pedido = [];
		var lisReporte = [];
		var lisInventario = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById('tcempresa').innerHTML = tc;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			selectSucursal(ids);
			cargarFechas();
			headerDetalleTraspaso();
			selectInventario();
			selectOrigen(ids);
			selectDestino();
			if (idr == '2') {
				$('#mostrarsucursal').show();
			}

		}

		function cargarFechas() {
			$("#mes").val(mes);
			$("#finicio").val(fecini);
			$("#ffin").val(fecfin);
			$("#ffin").val(fecfin);
			var date0 = $('input[id="mes"]');
			var date1 = $('input[id="finicio"]');
			var date2 = $('input[id="ffin"]');
			var hoy = $('input[id="farqueo"]');
			date0.datepicker({
				format: 'yyyy-mm',
				startView: 'months',
				minViewMode: 'months',
				todayHighlight: true,
				autoclose: true,
			});
			date1.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			date2.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			hoy.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
		}

		function cam_inifin(dato) {
			Empresa.cambiarFechas(dato, "#finicio", "#ffin");
			mes = $("#mes").val();
			fecini = $("#finicio").val();
			fecfin = $("#ffin").val();
		}

		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor) {

			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectSucursal").val(valor);
					$("#selectSucursal").select2();
				}
			});
			ids = valor;
		}

		function selectOrigen(valor) {
			Empresa.actualizarSelect({
				selector: "#selectOrigen",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectOrigen").val(valor);
					$("#selectOrigen").select2();
				}
			});
		}

		function selectDestino() {
			Empresa.actualizarSelect({
				selector: "#selectDestino",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal where id_sucursal != '" + ids + "'",
				callback: function(data) {
					$("#selectDestino").select2();
				}
			});
		}

		function selectInventario() {
			Empresa.actualizarSelect({
				selector: "#selectInventario",
				sql: "SELECT i.id_producto as id, CONCAT(p.codigo, ' | ', p.nombre, ' | ', i.lote ) as etiqueta FROM inventario i JOIN producto p ON i.id_producto = p.id_producto WHERE i.cantidad > 0 AND i.estado = 'VERIFICADO' AND i.id_sucursal ="+ ids + " GROUP BY i.id_producto, i.lote",
				callback: function(data) {
					$("#selectInventario").select2({
						placeholder: "Seleccione un producto del inventario.",
						minimumInputLength: 2
					});
				}
			});
			stockInventario();
		}

		// -------------------------- Trapasos ---------------------------- //

		function headerDetalleTraspaso() {
			var columnsName = [{
				title: "#"
			}, {
				title: "Imagen"
			}, {
				title: "Codigo"
			}, {
				title: "Producto"
			}, {
				title: "Items"
			}, {
				title: "C/U"
			}, {
				title: "SubTotal"
			}, {
				title: ""
			}];
			Empresa.inicializarTablaSinFormato({
				selector: ".lisPedido",
				columnas: columnsName
			});
		}

		function stockInventario() {
			var funcion = "stockInventario";
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: funcion,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var stock = respuesta.stock;
					$("#stocktotal").val(stock.stocktotal);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function buscarCodigoBarras() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var codigob = document.getElementById("codbar_tras").value;
			var funcion = "buscarCodigoBarras";
			var body = {
				funcion: funcion,
				codigob: codigob,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var producto = respuesta.producto;
					Empresa.hideSpinner();
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_TOPE, producto.IMAGEN, producto.UNIDAD, producto.CANTIDAD);
					$("#codbar_tras").val("");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					$("#codbar_tras").val("");
					Empresa.hideSpinner();
				}
			});
		}

		function ingresarCodigo(e) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			if ((keycode >= 48 && keycode <= 57) || (keycode > 64 && keycode < 91) || (keycode >= 96 && keycode <= 123) || keycode == 8 || keycode == 45) {

			} else if (keycode == '13') {
				e.preventDefault();
				buscarCodigoBarras();
			} else {
				e.preventDefault();
			}
		}

		function agregarItemStock(selectElement, cantidad) {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}

			var selectedOption = selectElement.options[selectElement.selectedIndex];

			var id = selectedOption.value;
			var text = selectedOption.text;
			var partes = text.split(" | "); 
			var lote = partes[2];
			var funcion = "verificarStock";
			var body = {
				funcion: funcion,
				idproducto: id,
				lote: lote,
				cantidad: cantidad,
				idsucursal: idsucursal,
				iduser: idu
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_TOPE, producto.IMAGEN, producto.UNIDAD, cantidad,producto.LOTE,producto.FECHA_VENCIMIENTO);
					selectInventario();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function agregarItem(idp, codigo, nombre, pcompra, pventa, ptope, imagen, unidad, cantidad, lote, fvencimiento) {
			var id = pedido.findIndex(e => e.idp === idp);

			if (id >= 0) {
				pedido[id].cantidad = parseFloat((parseFloat(pedido[id].cantidad) + parseFloat(cantidad)).toFixed(2));
			} else {
				pedido.push({
					idp, codigo, nombre, pcompra, pventa, ptope, imagen, unidad, cantidad, lote, fvencimiento
				});
			}

			dibujarTabla();
		}

		function quitarArticulo(id) {
			pedido.splice(id, 1);
			dibujarTabla();
		}


		function dibujarTabla() {
			var detailItem = [];
			var sumtitems = 0;
			var sumtprecio = 0;

			for (var i = 0; i < pedido.length; i++) {
				let cantidadItem = parseFloat(pedido[i].cantidad);
				let precioUnitario = parseFloat(pedido[i].pcompra);
				let subtotal = cantidadItem * precioUnitario;

				sumtitems += cantidadItem;
				sumtprecio += subtotal;

				detailItem.push([
					"" + (i + 1),
					crearImgDet(pedido[i].imagen, "50"),
					pedido[i].codigo,
					pedido[i].nombre,
					crearInputCantidad(i, cantidadItem) + " " + pedido[i].unidad,
					crearInputPrecio(i, precioUnitario) + " Bs.",
					crearInputPrecioSubTotal(i, subtotal) + " Bs.",
					crearButtonQuitar(i)
				]);
			}

			document.getElementById('itmcantidad').innerHTML = sumtitems;
			$("#cantidad_tras").val(sumtitems);
			$("#precio_tras").val(Empresa.roundNumber(sumtprecio, 2));

			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: detailItem
			});
		}

		function itemsCarrito(id, valor) {
			valor = parseFloat(valor);

			if (isNaN(valor) || valor <= 0) 
			{
				Empresa.notificationError("LA CANTIDAD DEBE SER MAYOR A CERO.");
				$('#num' + id).val(pedido[id].cantidad).focus(); 
				return;
			}
			let item = pedido[id];
			let cantidadAnterior = parseFloat(item.cantidad);
			let diferencia = valor - cantidadAnterior;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			if (diferencia === 0) {
				Empresa.notificationError("LA CANTIDAD MINIMA ES 1.");
				$('#num' + id).val(pedido[id].cantidad).focus(); 
				return;
			}

			let body = {
				funcion: "actualizarLeidos",
				idproducto: item.idp,
				lote: item.lote,
				idsucursal: idsucursal,
				iduser: idu,
				valor: valor,
				diferencia: diferencia
			};

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					item.cantidad = valor;
					dibujarTabla();
				},
				funcionError: function (e) {
					$('#num' + id).val(cantidadAnterior).focus(); 
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		// -------------------------- Traspasos ---------------------------- //
		function cargarTraspasos() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			$('#tablistado').tab('show');
			var columnsName = [{
				title: "#"
			}, {
				title: " Fecha"
			}, {
				title: " Boleta"
			}, {
				title: "Sucursal Origen"
			}, {
				title: "Sucursal Destino"
			}, {
				title: "Concepto"
			}, {
				title: " Cantidad Productos"
			}, {
				title: " Costo Total"
			}, {
				title: " Estado"
			}, {
				title: " "
			}];
			lisEnviado = [];
			lisRecibido = [];
			var body = {
				funcion: "listarTraspasos",
				idsucursal: idsucursal,
				iduser: idu,
				idrol: idr,
				fecini: fecini,
				fecfin: fecfin
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var enviados = respuesta.enviados.data;
					var recibidos = respuesta.recibidos.data;
					for (var i = 0; i < enviados.length; i++) {
						lisEnviado.push([
							i + 1,
							enviados[i].FECHA_REGISTRO,
							enviados[i].BOLETA,
							enviados[i].ORIGEN,
							enviados[i].DESTINO,
							enviados[i].CONCEPTO,
							enviados[i].CANTIDAD,
							enviados[i].PRECIO_TOTAL,
							enviados[i].ESTADO,
							crearButtonsTraspaso(enviados[i].ID_TRASPASO, enviados[i].ESTADO, enviados[i].ID_SUCURSAL_ORIGEN, enviados[i].ID_SUCURSAL_DESTINO)
						]);
					}

					Empresa.inicializarTablaDeDatos({
						selector: ".lisenviado",
						data: lisEnviado,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisenviado",
						data: lisEnviado
					});
					for (var i = 0; i < recibidos.length; i++) {
						lisRecibido.push([
							i + 1,
							recibidos[i].FECHA_REGISTRO,
							recibidos[i].BOLETA,
							recibidos[i].ORIGEN,
							recibidos[i].DESTINO,
							recibidos[i].CONCEPTO,
							recibidos[i].CANTIDAD,
							recibidos[i].PRECIO_TOTAL,
							recibidos[i].ESTADO,
							crearButtonsTraspaso(recibidos[i].ID_TRASPASO, recibidos[i].ESTADO, recibidos[i].ID_SUCURSAL_ORIGEN, recibidos[i].ID_SUCURSAL_DESTINO)
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisrecibido",
						data: lisRecibido,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisrecibido",
						data: lisRecibido
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function realizarTraspaso() {
			var concepto = document.getElementById("concepto_tras").value;
			var origen = document.getElementById("selectOrigen").value;
			var destino = document.getElementById("selectDestino").value;
			var cantidad = document.getElementById("cantidad_tras").value;
			var precio = document.getElementById("precio_tras").value;
			if (concepto === "") {
				$('#concepto_tras').val('').focus();
				Empresa.notificationWarning(" El campo de concepto es obligatorio .");
				return;
			}
			if (destino === "") {
				$('#selectDestino').val('').focus();
				Empresa.notificationWarning(" El campo de destino es obligatorio .");
				return;
			}
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			if (pedido.length == 0) {
				Empresa.notificationError("No se Puede Realizar esta transaccion si no tiene detalle.");
				Empresa.hideSpinner();
				return;
			}
			var funcion = "realizarTraspaso";
			var body = {
				funcion: funcion,
				concepto: concepto,
				precio: precio,
				cantidad: cantidad,
				detalle: pedido,
				idsucursal: idsucursal,
				origen: origen,
				iduser: idu,
				destino: destino
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var idtras = respuesta.idtras;
					$("#modalTraspaso").modal("hide");
					Empresa.notificationSuccess(" Se realizo correctamente el Traspaso");
					imprimirTraspaso(idtras);
					location.reload();
				}
			});
		}

		function imprimirTraspaso(id) {
			Empresa.PopupCenter('print_traspaso.php?id=' + id + '', 'IMPRIMIR TRASPASO', 400, 520);
		}

		function confirmarTraspaso(id, origen, destino) {
			swal({
					title: "Confirmar Traspaso",
					text: "Esta Seguro de ingresar el Traspaso al Inventario",
					type: "warning",
					showCancelButton: true,
					confirmButtonClass: "btn-danger",
					confirmButtonText: "Ingresar",
					cancelButtonText: "Cancelar",
					closeOnConfirm: false,
					closeOnCancel: false
				},
				function(isConfirm) {
					if (isConfirm) {
						swal.close();
						var funcion = "confirmarTraspaso";
						var body = {
							funcion: funcion,
							idtraspaso: id,
							origen: origen,
							destino: destino
						};
						Empresa.rest({
							verbo: 'POST',
							url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
							data: body,
							funcionExito: function(respuesta) {
								var idcmp = respuesta.idcmp;
								Empresa.notificationSuccess(" Se Confirmo Correctamenta la compra y se encuentra en el inventario.");
								cargarTraspasos();
							}
						});
					} else {
						swal.close();
					}
				});

		}
		//------------------------------ Vendedor ---------------------------------------
		function newVendedor() {
			Empresa.showSpinner();
			var vendedor = document.getElementById("rzsvend").value;
			var telefono = document.getElementById("telvend").value;

			var funcion = "newVendedor";
			var body = {
				funcion: funcion,
				vendedor: vendedor,
				telefono: telefono
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newVendedor").modal("hide");
					$('.vends').val('');
					selectVendedor();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingreso correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingreso el nuevo registro intente de nuevo por favor");
				}
			});
		}

		function crearInputCantidad(id, cantidad) {
			return "<input class='form-control'  style='width: 80px;' id='num" + id + "' onchange='itemsCarrito(\"" + id + "\",this.value)' type='number'  step='1' min='1' value='" + cantidad + "' >";
		}

		function crearInputPrecio(i, precio) {
			return "<input class='form-control' readonly id='prec" + i + "' size='5' type='text' value='" + precio + "'>";
		}

		function crearButtonQuitar(id) {
			return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Articulo' onclick='quitarArticulo(\"" + id + "\")'><i class='fa fa-trash'></i></button>";
		}

		function crearInputPrecioSubTotal(i, precio) {
			return "<input class='form-control' readonly id='precsubtotal" + i + "' size='5' type='text' value='" + precio + "'>";
		}

		function crearButtonsTraspaso(id, estado, origen, destino) {
			let btns = "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Imprimir compra' onclick='imprimirTraspaso(\"" + id + "\")'><i class='fa fa-print'></i></button>";
			if (estado === "PENDIENTE" && destino === ids) {
				btns += "<button class='btn btn-success btn-xs btn-outline' style='font-size:8px' title='Confirmar Traspaso' onclick='confirmarTraspaso(\"" + id + "\",\"" + origen + "\",\"" + destino + "\")'><i class='fa fa-check'></i></button>";
			}

			return btns;
		}

		function crearImgDet(url, tam) {
			var imgurl = "<img src='img/Producto/" + url + "'  width='" + tam + "' id='imageModel' /> ";
			return imgurl;
		}

		function crearButtonsInventario(id) {
			return "<button class='btn btn-primary btn-xs btn-outline' style='font-size:8px' title='Agregar Item' onclick='agregarItemStock(\"" + id + "\",1)'><i class='fa fa-plus'></i></button>";
		}

		this.initializer();
	</script>
</body>

</html>