<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Usuarios Empresa </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5>Sucursal : <b id='nomSucursal'></b></h5>
								<div class="ibox-tools">
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-12 col-md-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5> Listado <small class="m-l-sm"> (Usuarios) </small></h5>
								<div class="ibox-tools">
									<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#newUser">
										<i class="fa fa-plus" aria-hidden="true"></i>
									</button>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins" style='margin-top:-15px;'>
							<div class="ibox-content">
								<div id="contenedortablaprincipal" class="ibox ">
									<div id="toogle-columns"></div>
									<div class="ibox table-responsive" style="font-size:10px;">
										<table class="table table-striped table-bordered table-hover lisUser" style="font-size:10px;">
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
			<div class="modal inmodal" id="newUser" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-plus"></i> Nuevo Usuario</h4>
							<small>Registro de usuarios del sistema</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Sucursal :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="select2_demo_1 form-control" id="selectSucursal" style="width: 100%;" required></select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Rol :
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="select2_demo_2 form-control" id="selectRol" style="width: 100%;" required></select>
									</div>
								</div>
								<hr>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Usuario:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="usr" class="form-control col-md-7 col-xs-12" onblur="validarUsuario(this.value)">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> CI:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="ci" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Nombres:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="noms" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Apellidos:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="aps" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Genero:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="form-control col-md-7 col-xs-12" id="gen">
											<option value="MASCULINO">MASCULINO</option>
											<option value="FEMENINO">FEMENINO</option>
										</select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Fecha Nacimiento:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="date" id="fecnac" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Email:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="email" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="telf" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Celular:
									</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="cel" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newUser();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="modal inmodal" id="editUser" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-edit"></i> Editar Usuario</h4>
							<small>Editar los Datos del Usuario</small>
						</div>
						<div class="modal-body">
							<div class="row">
								<div class="col-md-6">
									<div class="col-md-6">
										<div class="ibox ">
											<div class="ibox-title">
												<h5>Foto</h5>
												<div class="ibox-tools">
													<button type="button" class="btn btn-info btn-xs" data-toggle="modal" data-target="#updFoto">
														<i class="fa fa-camera" aria-hidden="true"></i>
													</button>
												</div>
											</div>
											<div class="ibox-content  ">
												<center>
													<img alt="image" class="img-thumbnail" width="200px" src="img/Usuario/usr.png" id="imgport">
													<h6>
														<p>Tamaño máximo de archivo: 2Mb.</p>
														<p> Formatos aceptados: JPG / PNG. </p>
														<p> Fotografia con dimensiones Iguales. </p>
													</h6>
												</center>
											</div>
										</div>
									</div>
									<div class="col-md-6">
										<div class="ibox ">
											<div class="ibox-title">
												<h5>Codigo QR</h5>
												<div class="ibox-tools">
													<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#updQR">
														<i class="fa fa-qrcode" aria-hidden="true"></i>
													</button>
												</div>
											</div>
											<div class="ibox-content  ">
												<center>
													<img alt="image" class="img-thumbnail" width="200px" src="img/qr/qrcode.png" id="imgqr">
													<h6>
														<p>Imagen QR del Usuario para autentificarse</p>
													</h6>
												</center>
											</div>
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="ibox ">
										<div class="ibox-title">
											<h5>Perfil de Usuario</h5>
											<div class="ibox-tools">
												<button class="btn btn-info btn-xs" style="display:none" title="Guardar Datos" onclick="guardarDatos();" id="btnguardar">
													<i class="fa fa-save" aria-hidden="true"></i>
												</button>
												<button class="btn btn-success btn-xs" title="Editar Datos" onclick="habilitarDatos();" id="btneditar">
													<i class="fa fa-edit" aria-hidden="true"></i>
												</button>
											</div>
										</div>
										<div class="ibox-content ">
											<div class="form-group row">
												<div class="row" style="margin:15px">
													<label class="control-label col-md-3 col-sm-3 col-xs-12"> Nombres:
													</label>
													<div class="col-md-9 col-sm-9 col-xs-12">
														<div class="input-group">
															<input type="text" disabled id="updnoms" class="form-control input-sm edit"><span class="input-group-btn"> <button type="button" disabled style="width:35px;" class="btn btn-default btn-sm"><i class="fa fa-user text-navy"></i></button></span>
														</div>
													</div>
												</div>
												<div class="row" style="margin:15px">
													<label class="control-label col-md-3 col-sm-3 col-xs-12"> Apellidos:
													</label>
													<div class="col-md-9 col-sm-9 col-xs-12">
														<div class="input-group">
															<input type="text" disabled id="updaps" class="form-control input-sm edit"><span class="input-group-btn"> <button type="button" disabled style="width:35px;" class="btn btn-default btn-sm"><i class="fa fa-users text-navy"></i></button></span>
														</div>
													</div>
												</div>
												<div class="row" style="margin:15px">
													<label class="control-label col-md-3 col-sm-3 col-xs-12"> CI:
													</label>
													<div class="col-md-9 col-sm-9 col-xs-12">
														<div class="input-group">
															<input type="text" disabled id="updci" class="form-control input-sm edit"><span class="input-group-btn"> <button type="button" style="width:35px;" disabled class="btn btn-default btn-sm"><i class="fa fa-vcard text-navy"></i></button></span>
														</div>
													</div>
												</div>
												<div class="row" style="margin:15px">
													<label class="control-label col-md-3 col-sm-3 col-xs-12"> Genero:
													</label>
													<div class="col-md-9 col-sm-9 col-xs-12">
														<div class="input-group">
															<select class="form-control edit" disabled style="width: 100%;" id="updselectgen">
																<option value="MASCULINO">MASCULINO</option>
																<option value="FEMENINO">FEMENINO</option>
															</select><span class="input-group-btn"> <button type="button" style="width:35px;" disabled class="btn btn-default btn-sm"><i class="fa fa-child text-navy"></i></button></span>
														</div>
													</div>
												</div>
												<div class="row" style="margin:15px">
													<label class="control-label col-md-3 col-sm-3 col-xs-12"> Fecha Nacimiento:
													</label>
													<div class="col-md-9 col-sm-9 col-xs-12">
														<div class="input-group">
															<input type="date" disabled id="updfecnac" class="form-control input-sm edit"><span class="input-group-btn"> <button type="button" style="width:35px;" disabled class="btn btn-default btn-sm"><i class="fa fa-calendar text-navy"></i></button></span>
														</div>
													</div>
												</div>
												<div class="row" style="margin:15px">
													<label class="control-label col-md-3 col-sm-3 col-xs-12"> Email:
													</label>
													<div class="col-md-9 col-sm-9 col-xs-12">
														<div class="input-group">
															<input type="text" disabled id="updemail" class="form-control input-sm edit"><span class="input-group-btn"> <button type="button" style="width:35px;" disabled class="btn btn-default btn-sm"><i class="fa fa-envelope text-navy"></i></button></span>
														</div>
													</div>
												</div>
												<div class="row" style="margin:15px">
													<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:
													</label>
													<div class="col-md-9 col-sm-9 col-xs-12">
														<div class="input-group">
															<input type="text" disabled id="updtelf" class="form-control input-sm edit"><span class="input-group-btn"> <button type="button" style="width:35px;" disabled class="btn btn-default btn-sm"><i class="fa fa-phone text-navy"></i></button></span>
														</div>
													</div>
												</div>
												<div class="row" style="margin:15px">
													<label class="control-label col-md-3 col-sm-3 col-xs-12"> Celular:
													</label>
													<div class="col-md-9 col-sm-9 col-xs-12">
														<div class="input-group">
															<input type="text" disabled id="updcel" class="form-control input-sm edit"><span class="input-group-btn"> <button type="button" style="width:35px;" disabled class="btn btn-default btn-sm"><i class="fa fa-mobile text-navy"></i></button></span>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="verDir" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-map-marker"></i> Direccion </h4>
							<small>Muestra el mapa de direccion del usuario.</small>
						</div>
						<div class="modal-body">
							<div class="row">
								<div class="col-md-6">
									<div class="ibox ">
										<div class="ibox-title">
											<h5>Mapa</h5>
										</div>
										<div class="ibox-content  ">
											<div id="myMap" style="height: 250px;"></div>
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="ibox ">
										<div class="ibox-title">
											<h5>Datos Direccion</h5>
										</div>
										<div class="ibox-content ">
											<p><span class="label label-primary"> <i class="fa fa-tag"></i><span id="etid"> </span></p><br>
											<p><i class="fa fa-map-marker"></i> <span id="dird"> </span></p><br>
											<p><i class="fa fa-crosshairs"></i> <span id="locd"> </span></p><br>
											<p><i class="fa fa-building"></i> <span id="ciud"> </span></p>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updFoto" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-camera"></i> Actualizar Foto</h4>
							<small>Actualizar fotografia del Usuario</small>
						</div>
						<div class="modal-body">
							<div class="row">
								<form method="post" action="" enctype="multipart/form-data" id="fotoForm">

									<div class="col-md-8 col-sm-8 col-xs-12">
										<input type="file" onchange="vistaPreviaFoto(this);" id="newFoto" class="form-control">
										<input type="hidden" id="updid" class="form-control col-md-7 col-xs-12">
										<input type="hidden" id="updusr" class="form-control col-md-7 col-xs-12">
									</div>
									<div class="col-md-4 col-sm-4 col-xs-12" id="fotoAnt">
										<center><img alt="image" class="img-thumbnail" id="imgmodal" width="100px" src="img/Usuario/usr.png"></center>
									</div>
								</form>
							</div>

						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updFotoUser();" type="submit" form="CreateForm" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updQR" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-refresh"></i> Actualizar Codigo QR</h4>
							<small>Cambiar QR del carnet del Usuario</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-5 col-sm-5 col-xs-12"> Texto del QR:
									</label>
									<div class="col-md-7 col-sm-7 col-xs-12">
										<input type="text" id="txtqr" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-5 col-sm-5 col-xs-12"> Contraseña:
									</label>
									<div class="col-md-7 col-sm-7 col-xs-12">
										<input type="password" id="pwdqr" class="form-control col-md-7 col-xs-12">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="updQrUser();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisUser = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			selectSucursal();
			selectRol();
			headerUsuarios();
			cargarUsuarios();
		}

		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal() {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$(".select2_demo_1").select2();
				}
			});
		}

		function selectRol() {
			Empresa.actualizarSelect({
				selector: "#selectRol",
				sql: "select id_rol as id, concat(rol) as etiqueta from rol where id_rol<>'1'",
				callback: function(data) {
					$(".select2_demo_2").select2();
				}
			});
		}
		// -------------------------- Controles Tabla Rol ---------------------------- //
		function headerUsuarios() {
			var columnsName = [{
					title: "#"
				},
				{
					title: " "
				},
				{
					title: " Usuario"
				},
				{
					title: " Rol(es)"
				},
				{
					title: " Sucursal(es)"
				},
				{
					title: " Nombres"
				},
				{
					title: " Apellidos"
				},
				{
					title: " CI "
				},
				{
					title: " Telefono"
				},
				{
					title: " Email"
				},
				{
					title: " Direccion"
				},
				{
					title: " Estado"
				},
				{
					title: " "
				}
			];
			var columnsLinks = Empresa.createToogleColumns(columnsName);
			$("#toogle-columns").append(columnsLinks);
			Empresa.inicializarTablaDeDatos({
				selector: ".lisUser",
				data: lisUser,
				columnas: columnsName
			});
		}

		function cargarUsuarios() {
			Empresa.showSpinner();
			lisUser = [];
			var body = {
				funcion: "listarUsuarios"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesUsuarios.php"),
				data: body,
				funcionExito: function(respuesta) {
					var users = respuesta.users;
					for (var i = 0; i < users.length; i++) {
						var idrol = users[i].id_rol;
						if (idrol != '1') {
							lisUser.push([
								i + 1,
								crearImgDet(users[i].foto),
								users[i].user,
								createDivDatos(users[i].roles, "UserRol"),
								createDivDatos(users[i].sucursales, "UserSuc"),
								users[i].noms,
								users[i].aps,
								users[i].ci,
								users[i].telf,
								users[i].email,
								createDivDir(users[i].direcciones, "Direccion"),
								createButtonEstado(users[i].id_user, users[i].estado, "User"),
								createButtonsUser(users[i].id_user)
							]);
						}
					}

					Empresa.refrescarTablaDeDatos({
						selector: ".lisUser",
						data: lisUser
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}

		function validarUsuario(user) {
			Empresa.showSpinner();
			if (user === "") {
				$('#usr').focus();
				Empresa.notificationWarning(" El campo Usuario es Obligatorio no debe estar vacio.");
				return;
			}
			var funcion = "validarUsuario";
			var body = {
				funcion: funcion,
				user: user
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesUsuarios.php"),
				data: body,
				funcionExito: function(respuesta) {
					var valor = respuesta.valor;
					Empresa.hideSpinner();
					if (valor == 0) {
						Empresa.notificationSuccess("Este nombre de usuario esta disponible.");
					}
					if (valor == 1) {
						Empresa.notificationError("Este usuario ya existe en el sistema.");
						$('#usr').focus();
					}
				}
			});
		}

		function newUser() {
			Empresa.showSpinner();
			var rol = document.getElementById("selectRol").value;
			var sucursal = document.getElementById("selectSucursal").value;
			var user = document.getElementById("usr").value;
			var ci = document.getElementById("ci").value;
			var noms = document.getElementById("noms").value;
			var aps = document.getElementById("aps").value;
			var genero = document.getElementById("gen").value;
			var fecnac = document.getElementById("fecnac").value;
			var email = document.getElementById("email").value;
			var telf = document.getElementById("telf").value;
			var cel = document.getElementById("cel").value;
			if (rol === "") {
				$('#coselectRol').focus();
				Empresa.notificationWarning(" El campo Rol es Obligatorio no debe estar vacio.");
				return;
			}
			if (sucursal === "") {
				$('#selectSucursal').focus();
				Empresa.notificationWarning(" El campo Sucursal es Obligatorio no debe estar vacio.");
				return;
			}
			if (user === "") {
				$('#usr').focus();
				Empresa.notificationWarning(" El campo Usuario es Obligatorio no debe estar vacio.");
				return;
			}
			if (ci === "") {
				$('#ci').focus();
				Empresa.notificationWarning(" El campo CI es Obligatorio no debe estar vacio.");
				return;
			}

			var funcion = "newUser";
			var body = {
				funcion: funcion,
				rol: rol,
				sucursal: sucursal,
				user: user,
				ci: ci,
				noms: noms,
				aps: aps,
				email: email,
				telf: telf,
				cel: cel,
				fecnac: fecnac,
				genero: genero
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesUsuarios.php"),
				data: body,
				funcionExito: function(respuesta) {
					var valor = respuesta.valor;
					$("#newUser").modal("hide");
					cargarUsuarios();
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function cargarDatosUser(id) {
			Empresa.showSpinner();
			$("#editUser").modal("show");
			var funcion = "editUser";
			var body = {
				funcion: funcion,
				iduser: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesUsuarios.php"),
				data: body,
				funcionExito: function(respuesta) {
					var user = respuesta.user;
					Empresa.hideSpinner();
					$("#updid").val(user.ID_USER);
					$("#updusr").val(user.USUARIO);
					$("#updci").val(user.CI);
					$("#updnoms").val(user.NOMBRES);
					$("#updaps").val(user.APELLIDOS);
					$("#updemail").val(user.EMAIL);
					$("#updtelf").val(user.TELEFONO);
					$("#updcel").val(user.CELULAR);
					$("#updfecnac").val(user.FECHA_NAC);
					$("#updselectgen").val(user.GENERO);
					$("#imgport").attr("src", "img/usuario/" + user.FOTO + "");
					$("#imgmodal").attr("src", "img/usuario/" + user.FOTO + "");
					$("#imgqr").attr("src", "img/qr/cod-" + user.CODIGO_QR + ".png");
				}
			});
		}

		function verDireccion(id) {
			Empresa.showSpinner();
			var funcion = "verDireccion";
			var body = {
				funcion: funcion,
				id: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesUsuarios.php"),
				data: body,
				funcionExito: function(respuesta) {
					var direccion = respuesta.direccion;
					Empresa.hideSpinner();
					$("#verDir").modal("show");

					document.getElementById('dird').innerHTML = direccion.DIRECCION;
					document.getElementById('etid').innerHTML = direccion.ETIQUETA;
					document.getElementById('ciud').innerHTML = direccion.CIUDAD + ' - ' + direccion.PAIS;
					document.getElementById('locd').innerHTML = direccion.LOCALIDAD;

					mapboxgl.accessToken = 'pk.eyJ1IjoiYW5kcmVldXNkYiIsImEiOiJja2VrcTJ2M2YwZGRoMzFxeG1xYmtvcHJzIn0.eWdITbhyklGEVNiqeqphVw';
					var map = new mapboxgl.Map({
						container: 'myMap',
						style: 'mapbox://styles/mapbox/streets-v11',
						center: [direccion.LONGITUD, direccion.LATITUD],
						zoom: 16
					});

					var marker = new mapboxgl.Marker({
							draggable: false
						})
						.setLngLat([direccion.LONGITUD, direccion.LATITUD])
						.addTo(map);


				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});

		}

		function habilitarDatos() {
			$('#btneditar').hide();
			$('#btnguardar').show();
			Empresa.habilitarCampos("edit");
		}

		function guardarDatos() {
			Empresa.showSpinner();
			$('#btnguardar').hide();
			$('#btneditar').show();
			var iduser = document.getElementById("updid").value;
			var user = document.getElementById("updusr").value;
			var ci = document.getElementById("updci").value;
			var noms = document.getElementById("updnoms").value;
			var aps = document.getElementById("updaps").value;
			var genero = document.getElementById("updselectgen").value;
			var fecnac = document.getElementById("updfecnac").value;
			var email = document.getElementById("updemail").value;
			var telf = document.getElementById("updtelf").value;
			var cel = document.getElementById("updcel").value;
			var funcion = "updUser";
			var body = {
				funcion: funcion,
				iduser: iduser,
				user: user,
				ci: ci,
				noms: noms,
				aps: aps,
				email: email,
				telf: telf,
				cel: cel,
				fecnac: fecnac,
				genero: genero
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesUsuarios.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarDatosUser();
					Empresa.deshabilitarCampos("edit");
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se Actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}

		function vistaPreviaFoto(input) {
			$('#fotoAnt').hide();
			if (input.files && input.files[0]) {
				var reader = new FileReader();
				reader.onload = function(e) {
					$('#fotoForm + div').remove();
					$('#fotoForm').after('<div class="col-md-4 col-sm-4 col-xs-12"><center><img alt="image" class="img-thumbnail" width="100px" src="' + e.target.result + '"></center></div>');
				};
				reader.readAsDataURL(input.files[0]);
			}
		}

		function updFotoUser() {
			Empresa.showSpinner();
			var inputFileImage = document.getElementById("newFoto");
			var iduser = document.getElementById("updid").value;
			var file = inputFileImage.files[0];
			var archivo = file.name;
			var data = new FormData();
			var funcion = "updFotoUser";
			data.append('newFoto', file);
			data.append('iduser', iduser);
			data.append('funcion', funcion);
			Empresa.restImg({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesArchivosUsuarios.php"),
				data: data,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					$("#updFoto").modal("hide");
					$("#newFoto").val("");
					cargarDatosUser(iduser);
					Empresa.notificationSuccess("Archivos Subidos Correctamente");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function updQrUser() {
			Empresa.showSpinner();
			var iduser = document.getElementById("updid").value;
			var pwd = document.getElementById("pwdqr").value;
			var txtqr = document.getElementById("txtqr").value;
			var funcion = "updQrUser";
			var body = {
				funcion: funcion,
				iduser: iduser,
				txtqr: txtqr,
				pwd: pwd
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesUsuarios.php"),
				data: body,
				funcionExito: function(respuesta) {
					var valor = respuesta.valor;
					$("#updQR").modal("hide");
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Codigo QR Actualizado correctamente.");
					cargarDatosUser(iduser);
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		// -------------------------- Boton para Cambiar Estado ---------------------------- //
		function cambiarEstadoUser(id, estado) {
			Empresa.showSpinner();
			var funcion = "cambiarEstadoUser";
			var body = {
				funcion: funcion,
				iduser: id,
				estado: estado
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/usuario/funcionesUsuarios.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarUsuarios();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se Actualizo correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizo el registro intente de nuevo por favor");
				}
			});
		}
		// -------------------------- Boton para Cambiar Estado ---------------------------- //

		function createButtonEstado(id, estado, tabla) {
			var btns = "";
			var estado = estado.charAt(0);
			$("#updid").val(id);
			if (estado == 'A') {
				btns = "<button class='btn btn-primary btn-xs' style='font-size:8px'  title='Cambiar Estado' onclick='cambiarEstado" + tabla + "(\"" + id + "\",\"" + estado + "\")'>" + estado + "</button>";
			} else {
				btns = "<button class='btn btn-danger btn-xs' style='font-size:8px'  title='Cambiar Estado' onclick='cambiarEstado" + tabla + "(\"" + id + "\",\"" + estado + "\")'>" + estado + "</button>";
			}

			return btns;
		}

		// -------------------------- Boton Editar para todas las entidades ---------------------------- //

		function createButtonsUser(id) {
			$("#updid").val(id);
			var btns = "";
			btns = " <button class='btn btn-info btn-xs' style='font-size:8px'  title='Editar Datos Usuario' onclick='cargarDatosUser(\"" + id + "\")' ><i class='fa fa-edit'></i>";
			return btns;
		}

		// -------------------------- Div para mostrar Datos ---------------------------- //
		function createDivDatos(datos, tabla) {
			var datos = datos.data;
			var divDatos = "";
			for (var i = 0; i < datos.length; i++) {
				divDatos += "<p style='margin:3px; line-height:10px;'>" + datos[i].item + "</p>";
			}
			return divDatos;
		}
		// -------------------------- Div para mostrar Direccion ---------------------------- //
		function createDivDir(datos, tabla) {
			var datos = datos.data;
			var divDatos = "";
			for (var i = 0; i < datos.length; i++) {
				if (i % 2 == 0) {
					divDatos += "<p style='font-size:8px' ><a class='label label-info' title='ver Direccion' onclick='ver" + tabla + "(\"" + datos[i].id + "\")' >" + datos[i].item + "</a></p>";
				} else {
					divDatos += "<p style='font-size:8px' ><a class='label label-success' title='ver Direccion' onclick='ver" + tabla + "(\"" + datos[i].id + "\")' >" + datos[i].item + "</a></p>";
				}

			}
			return divDatos;
		}
		// -------------------------- Objeto para imgenes ---------------------------- //
		function crearImgDet(url, tam, lug) {
			var imgurl = "<img class='img-thumbnail' src='img/usuario/" + url + "'  width='70' id='imageModel' /> ";
			return imgurl;
		}


		this.initializer();
	</script>
</body>

</html>