<!DOCTYPE html>
<html>

<head>
	<?php include('includes/cabecera.inc'); ?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper">
		<?php include('includes/menu_izq.inc'); ?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php include('includes/menu_top.inc'); ?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li><a href="home">Inicio</a></li>
						<li class="active"><strong> Vendedores Empresa </strong></li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5>Sucursal : <b id='nomSucursal'></b></h5>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-12 col-md-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<h5> Listado <small class="m-l-sm">(Vendedores)</small></h5>
								<div class="ibox-tools">
									<button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#newVendedor">
										<i class="fa fa-plus" aria-hidden="true"></i>
									</button>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins" style='margin-top:-15px;'>
							<div class="ibox-content">
								<div id="contenedortablaprincipal" class="ibox">
									<div id="toogle-columns"></div>
									<div class="ibox table-responsive" style="font-size:10px;">
										<table class="table table-striped table-bordered table-hover lisvendedor" style="font-size:10px;"></table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newVendedor" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"><i class="fa fa-plus"></i> Nuevo Vendedor</h4>
							<small>Registro de un nuevo Vendedor</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Sucursal:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="form-control" id="selectSucursal" style="width: 100%;" required></select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Nombres:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="nomvend" class="form-control col-md-7 col-xs-12 vends">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="telvend" class="form-control col-md-7 col-xs-12 vends">
									</div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newVendedor();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Insertar Datos</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="updVendedor" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"><i class="fa fa-edit"></i> Actualizar Vendedor</h4>
							<small>Actualizar Datos Vendedor</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Sucursal:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<select class="form-control" id="updSelectSucursal" style="width: 100%;" required></select>
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Nombres:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updnomvend" class="form-control col-md-7 col-xs-12 vends">
										<input type="hidden" id="updidvend">
									</div>
								</div>
								<div class="form-group">
									<label class="control-label col-md-3 col-sm-3 col-xs-12"> Telefono:</label>
									<div class="col-md-9 col-sm-9 col-xs-12">
										<input type="text" id="updtelvend" class="form-control col-md-7 col-xs-12 vends">
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button onclick="updVendedor();" class="btn btn-success btn-sm"><i class="fa fa-refresh"></i> Actualizar Datos</button>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php include('includes/footer.inc'); ?>
			</div>
		</div>
	</div>
	<?php include('includes/pie.inc'); ?>
	<script>
		var ids = "<?php echo $ids; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisUser = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/usuario/" + foto;
			selectSucursal();
			cargarVendedores();
		}
		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal() {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$('#selectSucursal').select2({
						dropdownParent: $('#newVendedor')
					})
				}
			});
		}

		function updSelectSucursal(valor) {
			Empresa.actualizarSelect({
				selector: "#updSelectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$('#updSelectSucursal').val(valor);
					$('#updSelectSucursal').select2({
						dropdownParent: $('#updVendedor')
					})
				}
			});
		}
		// -------------------------- Vendedores ------------------------------
		function cargarVendedores() {
			Empresa.showSpinner();
			var columnsName = [{
				title: "#"
			}, {
				title: "Vendedor"
			}, {
				title: "Teléfono"
			}, {
				title: "Estado"
			}, {
				title: "Editar"
			}];
			var lisvendedor = [];
			var funcion = "listarVendedores";
			var body = {
				funcion: funcion,
				sucursal: ids
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var vendedores = respuesta.vendedores.data;
					for (var i = 0; i < vendedores.length; i++) {
						lisvendedor.push([
							i + 1,
							vendedores[i].VENDEDOR,
							vendedores[i].TELEFONO,
							createButtonEstado(vendedores[i].ID_VENDEDOR, vendedores[i].ESTADO, "Vendedor"),
							Empresa.createButtonsEdit(vendedores[i].ID_VENDEDOR, "Vendedor")
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisvendedor",
						data: lisvendedor,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisvendedor",
						data: lisvendedor
					});
				}
			});
		}

		function newVendedor() {
			Empresa.showSpinner();
			var vendedor = document.getElementById("nomvend").value;
			var telefono = document.getElementById("telvend").value;
			var sucursal = document.getElementById("selectSucursal").value;

			var funcion = "newVendedor";
			var body = {
				funcion: funcion,
				vendedor: vendedor,
				telefono: telefono,
				sucursal: sucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#newVendedor").modal("hide");
					$('.vends').val('');
					cargarVendedores();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se ingresó correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se ingresó el nuevo registro. Intente de nuevo, por favor.");
				}
			});
		}

		function modalEditVendedor(id) {
			Empresa.showSpinner();
			var funcion = "editVendedor";
			var body = {
				funcion: funcion,
				idvendedor: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					var vendedor = respuesta.vendedor;
					Empresa.hideSpinner();
					$("#updVendedor").modal("show");
					$("#updidvend").val(vendedor.ID_VENDEDOR);
					$("#updnomvend").val(vendedor.VENDEDOR);
					$("#updtelvend").val(vendedor.TELEFONO);
					updSelectSucursal(vendedor.ID_SUCURSAL);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function updVendedor() {
			Empresa.showSpinner();
			var idvendedor = document.getElementById("updidvend").value;
			var vendedor = document.getElementById("updnomvend").value;
			var telefono = document.getElementById("updtelvend").value;
			var sucursal = document.getElementById("updSelectSucursal").value;
			var funcion = "updVendedor";
			var body = {
				funcion: funcion,
				idvendedor: idvendedor,
				vendedor: vendedor,
				telefono: telefono,
				sucursal: sucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					$("#updVendedor").modal("hide");
					$('.vends').val('');
					cargarVendedores();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizó correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizó el registro. Intente de nuevo, por favor.");
				}
			});
		}

		function cambiarEstadoVendedor(id, estado) {
			Empresa.showSpinner();
			var funcion = "cambiarEstadoVendedor";
			var body = {
				funcion: funcion,
				idvendedor: id,
				estado: estado
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/administracion/funcionesAdministracion.php"),
				data: body,
				funcionExito: function(respuesta) {
					cargarVendedores();
					Empresa.hideSpinner();
					Empresa.notificationSuccess("Se actualizó correctamente el registro.");
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError("No se actualizó el registro. Intente de nuevo, por favor.");
				}
			});
		}

		// -------------------------- Botón para Cambiar Estado ---------------------------- //

		function createButtonEstado(id, estado, tabla) {
			var btns = "";
			estado = estado.charAt(0);
			$("#updid").val(id);
			if (estado === 'A') {
				btns = "<button class='btn btn-primary btn-xs' style='font-size:8px' title='Cambiar Estado' onclick='cambiarEstado" + tabla + "(\"" + id + "\", \"" + estado + "\")'>" + estado + "</button>";
			} else {
				btns = "<button class='btn btn-danger btn-xs' style='font-size:8px' title='Cambiar Estado' onclick='cambiarEstado" + tabla + "(\"" + id + "\", \"" + estado + "\")'>" + estado + "</button>";
			}

			return btns;
		}
		this.initializer();
	</script>
</body>

</html>