<!DOCTYPE html>
<html>

<head>
	<?php
	include('includes/cabecera.inc');
	?>
</head>

<body class="skin-5 pace-done mini-navbar">
	<div id="wrapper" class="ibox-content" style="padding: 0px;">
		<div class="sk-spinner sk-spinner-wave" >
			<div class="sk-rect1"></div>
			<div class="sk-rect2"></div>
			<div class="sk-rect3"></div>
			<div class="sk-rect4"></div>
			<div class="sk-rect5"></div>
		</div>
		<?php
		include('includes/menu_izq.inc');
		?>
		<div id="page-wrapper" class="gray-bg">
			<div class="row border-bottom">
				<?php
				include('includes/menu_top.inc');
				?>
			</div>
			<div class="row wrapper border-bottom white-bg page-heading">
				<div class="col-lg-12">
					<br>
					<ol class="breadcrumb">
						<li>
							<a href="home">Inicio</a>
						</li>
						<li class="active">
							<strong> Venta Productos </strong>
						</li>
					</ol>
				</div>
			</div>
			<div class="wrapper wrapper-content ">
				<div class="row">
					<div class="col-lg-12">
						<div class="ibox float-e-margins">
							<div class="ibox-title">
								<div class="col-sm-2">
									<h5>Sucursal : <b id='nomSucursal'></b></h5>
								</div>
								<div class="col-lg-2">
									<div id="mostrarsucursal" style="display:none;">
										<select class="form-control" id="selectSucursal"></select>
									</div>
								</div>
								<div class="row form-group col-sm-8">
									<div class="col-sm-11">
										<label class="col-sm-1 control-label"> Mes:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='mes' onchange="cam_inifin(this.value);" required />
										</div>
										<label class="col-sm-1 control-label"> F.Ini:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='finicio' required />
										</div>
										<label class="col-sm-1 control-label"> F.Fin:</label>
										<div class="col-sm-3">
											<input type="text" class="form-control input-sm" id='ffin' required />
										</div>
									</div>
									<div class="col-sm-1">
										<!-- -->
										<button class="btn btn-info btn-sm " onclick="cargarVentas();"> <i class="fa fa-filter"></i> </button>
									</div>
								</div>
							</div>
						</div>
						<div class="ibox float-e-margins">
							<div class="tabs-container">
								<ul class="nav nav-tabs">
									<li class="active "> <a id="tabventa" href="#tab-1" data-toggle="tab"><label class="text-navy"><i class="fa fa-shopping-cart"></i> Realizar Ventas </a></label></li>
									<li> <a id="tablistado" href="#tab-2" onclick="cargarVentas();"><label class="text-navy"><i class="fa fa-tags"></i> Listado Ventas </a></label></li>
								</ul>
								<div class="tab-content">
									<div id="tab-1" class="tab-pane active">
										<div class="ibox-content">
											<div class="row">
												<div class="col-lg-7">
													<div class="ibox">
														<div class="ibox-title">
															<div class="col-md-4">
																<h5> Listado Productos </h5> <button type="button" style="float:right" class="btn btn-outline btn-primary btn-sm" data-toggle="modal" data-target="#modalExcel"> <i class="fa fa-file-excel-o"></i> </button>
															</div>
															<div class="col-md-2">
																<label style="text-align: right;">Stock Total: </label>
															</div>
															<div class="col-md-3">
																<input class="form-control input-sm" type="text" id="stocktotal" disabled>
															</div>
															<div class="col-md-3">
																<select class="pull-right input-sm" id="selectPrecio" onchange="cambiarPrecioVenta(this.value)">
																	<option value="1">PRECIO VENTA</option>
																	<option value="2">PRECIO MAYOR</option>
																	<option value="3">PRECIO ESPECIAL</option>
																	<option value="4">PRECIO TOPE</option>
																</select>
															</div>
														</div>
														<div class="ibox-content">
															<div class="row">
																<div class="col-md-12" style="font-size:10px;">
																	<select class="form-control" id="selectInventario" onchange="agregarItemStock(this,1)" style="width: 100%;" required></select>
																</div>
																<div class="col-md-6" style="font-size:10px; display: none;">
																	<div class="input-group">
																		<input type="text" id="codbar_ven" placeholder="Ingrese codigo de Barras" onkeypress="ingresarCodigo(event)" class="form-control input-sm vnt"><span class="input-group-btn"> <button type="button" style="width:35px;" onclick="buscarCodigoBarras()" class="btn btn-info btn-outline btn-sm"><i class="fa fa-search"></i></button></span>
																	</div>
																</div>
															</div>
															<hr>
															<div class="row">
																<div class="table-responsive">
																	<table class="table table-striped table-bordered table-hover lisPedido" style="font-size:10px;"></table>
																</div>
															</div>
														</div>
													</div>
												</div>
												<div class="col-lg-5">
													<div class="ibox">
														<div class="ibox-title">
															<h5>Detalle Venta </h5><small>( TC : <span id="tcempresa"></span> )</small><span class="pull-right btn btn-primary btn-outline btn-sm"> <i class="fa fa-shopping-cart"></i>(<strong id="itmcantidad">0</strong>) Items</span>
														</div>
														<div class="ibox-content">
															<div class="form-horizontal form-label-left">
																<div class="row">
																	<div class="col-md-6">
																		<label class="control-label">CI / NIT: </label>
																		<div class="input-group">
																			<input type="text" id="nit" value="100001" placeholder="Ingrese CI o NIT" onkeypress="ingresarNit(event)" class="form-control input-sm ven"><span class="input-group-btn"> <button type="button" style="width:35px;" onclick="buscarNit()" class="btn btn-primary btn-outline btn-sm"><i class="fa fa-search"></i></button></span>
																		</div>
																	</div>
																	<div class="col-md-6">
																		<label class="control-label">Razon Social: <a onclick="editCliente()" class="text-navy"> <b><i class="fa fa-edit"></i> </b></a></label>
																		<input type="text" id="rzs" value="SIN NOMBRE" class="form-control ven">
																	</div>
																</div>
																<div class="row" id="dtcli" style="display:none;">
																	<label class="control-label">Email: </label>
																	<input type="text" id="mail" class="form-control ven">
																	<input type="hidden" id="idcli" value="0" class="form-control ven">
																	<label class="control-label">Complemento: </label>
																	<input type="text" id="cmp" class="form-control ven">
																</div>
																<div class="row">
																	<div class="col-md-6">
																		<label class="control-label">Concepto: </label>
																		<input type="text" id="concepto_ven" value="-" class="form-control ">
																	</div>
																	<div class="col-md-6">
																		<label class="control-label">Tipo Pago: </label>
																		<select id="selectTipoPago" style="width: 100%;" class="form-control" required></select>
																	</div>
																</div>
																
																<div class="row">
																	<div class="col-md-6">
																		<label class="control-label">Cantidad: </label>
																		<input type="text" value="0" id="cantidad_ven" class="form-control vnt" readonly>
																	</div>
																	<div class="col-md-6">
																		<label class="control-label">Precio Total</label>
																		<input type="text" value="0" id="precio_ven" class="form-control vnt" readonly>
																	</div>
																</div>
																<div class="row">
																	<div class="col-md-6">
																		<label class="control-label">Cancelado: </label>
																		<input type="text" value="0" id="cancelado_ven" onkeydown="calcularCambioVenta(event)" class="form-control vnt">
																	</div>
																	<div class="col-md-6">
																		<label class="control-label">Cambio: </label>
																		<input type="text" value="0" id="cambio_ven" class="form-control vnt" readonly>
																	</div>
																</div>
																<br>
																<div class="row" id="rventa">
																	<div class="col-md-6">
																		<button onclick="generarFactura()" class="btn btn-block btn-outline  btn-primary"> <i class="fa fa-calculator"></i> Facturar </button>
																	</div>
																	<div class="col-md-6">
																		<button onclick="realizarVenta(0)" class="btn btn-block btn-outline btn-success"> <i class="fa fa-shopping-cart"></i> Vender </button>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div id="tab-2" class="tab-pane" style="font-size:11px;">
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<div class="ibox-title">
														<h5> Listado Ventas </h5>
														<div class="ibox-tools">
														</div>
													</div>
													<div class="ibox-content">
														<div class="ibox table-responsive">
															<table class="table table-striped table-bordered table-hover lisVenta" style="font-size:10px; ">
															</table>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="mdlFactura" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-body">

							<div class="ibox-content">
								<div class="row">
									<div class="col-md-9">
										<div class="ibox-title">
											<h3 class="text-navy">Detalle <small> (venta)</small></h3>
										</div>
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-6">
													<label>NIT/CI : </label>
													<input type="text" id="nit1" class="form-control frm input-sm" placeholder="Introduzca nit o razon social"><input type="hidden" id="updidventa" value="0">
												</div>
												<div class="col-md-6">
													<label>Nombres <small>(Razon social)</small> : </label>
													<input type="text" id="rzs1" class="form-control frm input-sm">
												</div>
											</div>
											<div class="row">
												<div class="col-md-4">
													<label>Correo <small>(electronico)</small> : </label>
													<input type="text" id="mail1" class="form-control input-sm">
												</div>
												<div class="col-md-4">
													<label>Tipo Documento : </label>
													<select class="form-control input-sm" id="selectTipoDoc" style="width:100%">
													</select>
												</div>
												<div class="col-md-4">
													<label>Complemento <small>(CI)</small> : </label>
													<input type="text" id="cmp1" class="form-control input-sm">
												</div>
											</div>
										</div>
										<div class="ibox-content">
											<div class="row">
												<div class="col-md-12">
													<h3 class="text-navy"> Ventas <small>(Detalle)</small> </h3>
													<hr style="border-top: 1px solid white;">
													<table class="table table-striped table-bordered table-hover lisDetalleFactura">
													</table>
												</div>

											</div>
										</div>
									</div>
									<div class="col-md-3">
										<div class="ibox-title">
											<h3 class="text-navy">Facturar<small> (venta)</small></h3>
										</div>
										<div class="ibox-content">
											<div class="row">
												<label>Total<small>(items)</small> : </label>
												<input type="number" readonly id="tpar" class="form-control frm input-sm">
												<label>Sub-Total<small>(Bs)</small> : </label>
												<input type="number" readonly id="stbs" class="form-control frm input-sm"><input type="hidden" id="idcli"><input type="hidden" id="idven">
												<label>Descuento <small>(Bs)</small> : </label>
												<input type="text" id="dtbs" onfocusout="recalcularDescuento(this.value)" value="0" class="form-control input-sm" disabled>
												<label>Total <small>(Bs)</small> : </label>
												<input type="text" id="ttbs" class="form-control input-sm" disabled>
												<label>Total Base Credito Fiscal<small>(Bs)</small> : </label>
												<input type="number" readonly id="tbs" class="form-control frm input-sm">
												<button class="btn btn-primary btn-block btn-sm" onclick="procesarFactura()"><i class="fa fa-usd"></i> Facturar </button>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalPagos" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<div class="modal-content animated bounceInRight">
						<div class="modal-body">
							<div class="ibox-content">
								<div class="ibox">
									<div class="ibox-title">
										<h5>Pagos a Capital</h5>
										<div class="ibox-tools">
											<button class="btn btn-success btn-outline btn-xs devolver" data-toggle="modal" data-target="#newPago">
												<i class="fa fa-money" aria-hidden="true"></i> Nuevo Pago
											</button>
										</div>
									</div>
									<div class="ibox-content" style="margin-top:-30px">
										<div class="ibox table-responsive" style="font-size:10px; max-height: 500px;">
											<table class="table table-striped table-bordered table-hover lispagos">
												<!-- Aquí se llena dinámicamente la lista de pagos -->
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="newPago" tabindex="-1" role="dialog" aria-hidden="true" >
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-money"></i> Abonar </h4>
							<small> Para Abonar la venta a Credito.</small>
						</div>
						<div class="modal-body">
							<div class="form-horizontal form-label-left">
								<div class="form-group">  
								  <label class="control-label col-md-4 col-sm-4 col-xs-12"> Monto a Abonar:
								  </label>
								  <div class="col-md-8 col-sm-8 col-xs-12">
									<input type="number" id="montopago" class="form-control mpago">
								  </div>
								</div>
								<div class="modal-footer">
									<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									<button onclick="newPago();" class="btn btn-success btn-sm"><i class="fa fa-check"></i> Abonar </button>
								</div>												
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal inmodal" id="modalExcel" tabindex="-1" role="dialog" aria-hidden="true">
				<div class="modal-dialog">
					<div class="modal-content animated bounceInRight">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
							<h4 class="modal-title"> <i class="fa fa-file-excel-o"></i> Subir Excel de Ventas</h4>
							<small> Subir Excel de Ventas al Sistema.</small>
						</div>
						<div class="modal-body">
							<form method="post" enctype="multipart/form-data">
								<div class="row">
									<div class="form-group">
										<div class="col-md-2 col-sm-2 col-xs-2">
											<label class="control-label"> Excel: </label>
										</div>
										<div class="col-md-8 col-sm-8 col-xs-8">
											<input type="file" class="form-control" id="excelven">
										</div>
									</div>
								</div>
							</form>
						</div>
						<div class="modal-footer">
							<button onclick="subirExcelVenta();" class="btn btn-success btn-sm"><i class="fa fa-upload"></i> Subir Excel </button>
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						</div>
					</div>
				</div>
			</div>
			<div class="footer">
				<?php
				include('includes/footer.inc');
				?>
			</div>
		</div>
	</div>
	<?php
	include('includes/pie.inc');
	?>
	<script>
		var date = new Date();
		var mes = date.getFullYear() + "-" + Empresa.agregarCero(date.getMonth() + 1);
		var primerDia = new Date(date.getFullYear(), date.getMonth(), 1).getDate();
		var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
		var fecini = mes + "-" + Empresa.agregarCero(primerDia);
		var fecfin = mes + "-" + Empresa.agregarCero(ultimoDia);
		var fechoy = mes + "-" + date.getDate();


		var ids = "<?php echo $ids; ?>";
		var usr = "<?php echo $usr; ?>";
		var idu = "<?php echo $idu; ?>";
		var idr = "<?php echo $idr; ?>";
		var aps = "<?php echo $aps; ?>";
		var nom = "<?php echo $nom; ?>";
		var rol = "<?php echo $rol; ?>";
		var ico = "<?php echo $ico; ?>";
		var emp = "<?php echo $emp; ?>";
		var foto = "<?php echo $foto; ?>";
		var logo = "<?php echo $logo; ?>";
		var tc = "<?php echo $tc; ?>";
		var nomSuc = "<?php echo $suc; ?>";
		var sig = "<?php echo $sig; ?>";
		var dir = "<?php echo $dir; ?>";
		var telf = "<?php echo $telf; ?>";
		var cel = "<?php echo $cel; ?>";
		var loc = "<?php echo $loc; ?>";
		var ciu = "<?php echo $ciu; ?>";
		var lisDetalleFactura = [];
		var lisNewFactura = [];
		var lisVenta = [];
		var pedido = [];

		function initializer() {
			cargarDatosWeb();
			menuNotificaciones();
			desmarcarLeidos();
			document.getElementById('nomSucursal').innerHTML = nomSuc;
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById("fotousr").src = "img/Usuario/" + foto + "";
			document.getElementById('nomUser').innerHTML = nom + ' ' + aps;
			document.getElementById('rolUser').innerHTML = rol;
			document.getElementById('tcempresa').innerHTML = tc;
			selectTiposDoc();
			selectMetodoPago();
			selectTipoPago();
			selectSucursal(ids);
			cargarFechas();
			selectInventario();
			headerDetalleFactura();
			headerDetalleVenta()
			verificarArqueo();
			if (idr == '2') {
				$('#mostrarsucursal').show();
			}

		}

		function cargarFechas() {
			$("#mes").val(mes);
			$("#finicio").val(fecini);
			$("#ffin").val(fecfin);
			$("#ffin").val(fecfin);
			var date0 = $('input[id="mes"]');
			var date1 = $('input[id="finicio"]');
			var date2 = $('input[id="ffin"]');
			var hoy = $('input[id="farqueo"]');
			date0.datepicker({
				format: 'yyyy-mm',
				startView: 'months',
				minViewMode: 'months',
				todayHighlight: true,
				autoclose: true,
			});
			date1.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			date2.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
			hoy.datepicker({
				format: 'yyyy-mm-dd',
				todayHighlight: true,
				autoclose: true,
			});
		}

		function cam_inifin(dato) {
			Empresa.cambiarFechas(dato, "#finicio", "#ffin");
			mes = $("#mes").val();
			fecini = $("#finicio").val();
			fecfin = $("#ffin").val();
		}

		// -------------------------- Cargar Selects ---------------------------- //
		function selectSucursal(valor) {
			Empresa.actualizarSelect({
				selector: "#selectSucursal",
				sql: "select id_sucursal as id, concat(sucursal) as etiqueta from sucursal",
				callback: function(data) {
					$("#selectSucursal").val(valor);
					$("#selectSucursal").select2();
					$("#selectPrecio").select2();
				}
			});
			ids = valor;
		}

		function selectTipoPago() {
			Empresa.actualizarSelect({
				selector: "#selectTipoPago",
				sql: "select id_tipo as id, concat(tipo_pago) as etiqueta from tipo_pago",
				callback: function(data) {
					$("#selectTipoPago").val(1);
					$("#selectTipoPago").select2();
				}
			});
		}

		function selectTiposDoc() {
			Empresa.actualizarSelect({
				selector: "#selectTipoDoc",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_tipos_documento_identidad",
				callback: function(data) {
					$('#selectTipoDoc').val(1);
					$('#selectTipoDoc').select2();
				}
			});
		}

		function selectMetodoPago() {
			Empresa.actualizarSelect({
				selector: "#selectMetodoPago",
				sql: "select codigo as id, descripcion as etiqueta from siat_sinc_metodo_pago order by descripcion ",
				callback: function(data) {
					$('#selectMetodoPago').val(1);
					$('#selectMetodoPago').select2();
				}
			});
		}

		function selectInventario() {
			Empresa.actualizarSelect({
				selector: "#selectInventario",
				sql: "SELECT i.id_producto as id, CONCAT(i.lote, ' | ', p.codigo, ' | ', p.nombre, ' | ',  p.nombre_generico, ' | ', p.categoria, ' | ' , CAST(SUM(i.cantidad) AS SIGNED)) as etiqueta FROM inventario i JOIN producto p ON i.id_producto = p.id_producto WHERE i.cantidad > 0 AND i.estado = 'VERIFICADO' AND i.id_sucursal='"+ids+"' GROUP BY i.id_producto, i.lote",
				callback: function(data) {
					$("#selectInventario").select2({
						placeholder: "Seleccione un producto del inventario.",
						minimumInputLength: 2
					});
				}
			});
			stockInventario();
		}

		// -------------------------- Ventas ---------------------------- //

		function headerDetalleVenta() {
			var columnsName = [{
				title: "#"
			}, {
				title: "Imagen"
			}, {
				title: "Producto"
			}, {
				title: "Cantidad"
			}, {
				title: "P/U"
			}, {
				title: "SubTotal"
			}, {
				title: "Cambio"
			}, {
				title: ""
			}];
			Empresa.inicializarTablaSinFormato({
				selector: ".lisPedido",
				columnas: columnsName
			});
		}

		function limitarCadena(cadena, maximoCaracteres) {
			return cadena.length > maximoCaracteres ? cadena.substring(0, maximoCaracteres) : cadena;
		}

		function stockInventario() {
			var funcion = "stockInventario";
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: funcion,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var stock = respuesta.stock;
					$("#stocktotal").val(stock.stocktotal);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
				}
			});
		}

		function buscarCodigoBarras() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var codigob = document.getElementById("codbar_ven").value;
			var funcion = "buscarCodigoBarras";
			var body = {
				funcion: funcion,
				codigob: codigob,
				idsucursal: idsucursal
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var producto = respuesta.producto;
					Empresa.hideSpinner();
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO_BARRAS, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_MAYOR, producto.PRECIO_ESPECIAL, producto.PRECIO_TOPE, producto.UNIDAD, cantidad, producto.IMAGEN, producto.CODIGO_SIN, producto.CODIGO_ACTIVIDAD, producto.UNIDAD_MEDIDA, producto.LOTE, producto.FECHA_VENCIMIENTO);
					$("#codbar_ven").val("");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					$("#codbar_ven").val("");
					Empresa.hideSpinner();
				}
			});
		}

		function ingresarCodigo(e) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			if ((keycode >= 48 && keycode <= 57) || (keycode > 64 && keycode < 91) || (keycode >= 96 && keycode <= 123) || keycode == 8 || keycode == 45) {

			} else if (keycode == '13') {
				e.preventDefault();
				buscarCodigoBarras();
			} else {
				e.preventDefault();
			}
		}

		function buscarNit() {
			var nit = document.getElementById("nit").value;
			if (nit === "") {
				$('#nit').val('').focus();
				Empresa.notificationError("No ingreso ningun nit es obligatorio el campo.");
				Empresa.hideSpinner();
				return;
			}
			var body = {
				funcion: "buscarNit",
				cinit: nit
			};
			Empresa.showSpinner();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cliente = respuesta.cliente;
					Empresa.hideSpinner();
					if (cliente == null) {
						toastr.warning('no se encontro ningun nombre relacionado al nit.', '¡Ingrese un nombre por favor!');
						editCliente();
					} else {
						document.getElementById('idcli').value = cliente.id;
						document.getElementById('nit').value = cliente.nitCi;
						document.getElementById('rzs').value = cliente.razonSocial;
						document.getElementById('mail').value = cliente.email;
						document.getElementById('cmp').value = cliente.complemento;
					}

				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			})

		}

		function ingresarNit(e) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			if (keycode >= 48 && keycode <= 57 || keycode == 8) {

			} else if (keycode == '13') {
				e.preventDefault();
				buscarNit();
			} else {
				e.preventDefault();
			}
		}

		function editCliente() {
			var $div = $("#dtcli");
			if ($div.is(":visible")) {
				$div.hide(); // Oculta el div si está visible
			} else {
				$div.show(); // Muestra el div si está oculto
			}
		}

		
		function desmarcarLeidos() {
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}

			var body = {
				funcion: "desmarcarLeidos", 
				iduser: idu,  
				idsucursal: idsucursal 
			};

			Empresa.showSpinner();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function agregarItemStock(selectElement, cantidad) {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}

			var selectedOption = selectElement.options[selectElement.selectedIndex];

			var id = selectedOption.value;
			var text = selectedOption.text;
			var partes = text.split(" | "); 
			var lote = partes[0];
			var funcion = "verificarStock";
			var body = {
				funcion: funcion,
				idproducto: id,
				lote: lote,
				cantidad: cantidad,
				idsucursal: idsucursal,
				iduser: idu
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var producto = respuesta.producto;
					agregarItem(producto.ID_PRODUCTO, producto.CODIGO_BARRAS, producto.NOMBRE, producto.PRECIO_COMPRA, producto.PRECIO_VENTA, producto.PRECIO_MAYOR, producto.PRECIO_ESPECIAL, producto.PRECIO_TOPE, producto.UNIDAD, cantidad, producto.IMAGEN, producto.CODIGO_SIN, producto.CODIGO_ACTIVIDAD, producto.UNIDAD_MEDIDA, producto.LOTE, producto.FECHA_VENCIMIENTO);
					selectInventario();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function agregarItem(idp, codigo, nombre, pcompra, pventa, pmayor, pespecial, ptope, unidad, cantidad, imagen, codsin, codact, unimed, lote, fvencimiento) {
			let codprecio = document.getElementById("selectPrecio").value;
			let pfinal = 0;
			let descuento = 0;

			// Determinar el precio final según el tipo seleccionado
			if (codprecio === '1') pfinal = pventa;
			else if (codprecio === '2') pfinal = pmayor;
			else if (codprecio === '3') pfinal = pespecial;
			else if (codprecio === '4') pfinal = ptope;

			// Calcular el precio total del ítem
			let precbs = Math.floor(pfinal * cantidad * 100) / 100;
			let preciobs = Empresa.financial(precbs, 2);

			// Crear clave única con idp y lote
			let claveUnica = idp + "-" + lote;

			let itemPedido = {
				idp: idp,
				clave: claveUnica,
				codigo: codigo,
				codigop: codigo,
				nombre: nombre,
				producto: nombre,
				pcompra: pcompra,
				pventa: pventa,
				pmayor: pmayor,
				pespecial: pespecial,
				ptope: ptope,
				pfinal: pfinal,
				unidad: unidad,
				cantidad: cantidad,
				imagen: imagen,
				actividad: codact,
				codigosin: codsin,
				descuento: descuento,
				unidadmedida: unimed,
				preciounitario: pfinal,
				preciobs: preciobs,
				lote: lote,
				fvencimiento: fvencimiento
			};


			// Buscar si ya existe un item con la misma clave
			let idExistente = pedido.findIndex(item => item.clave === claveUnica);

			if (idExistente >= 0) {
				console.log("📌 Ya existe el item. Sumando cantidad.");
				pedido[idExistente].cantidad = parseFloat((parseFloat(pedido[idExistente].cantidad) + parseFloat(cantidad)).toFixed(3));
				console.log("🆕 Nueva cantidad:", pedido[idExistente].cantidad);
			} else {
				console.log("🆕 No existe aún. Agregando como nuevo.");
				pedido.push({ ...itemPedido });
			}

			dibujarTabla();
		}

		function quitarArticulo(id) {
			lisDetalleVenta = [];
			var sumtitems = 0;
			var preciototal = 0;
			var sumtprecio = 0;
			var idp = pedido[id].idp;
			pedido.splice(id, 1);

			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "desmarcarLeidosId", 
				idproducto: idp,
				iduser: idu,  
				idsucursal: idsucursal 
			};

			Empresa.showSpinner();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					dibujarTabla(); 
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}


		function itemsCarrito(id, valor) {
			valor = parseFloat(valor);

			if (isNaN(valor) || valor <= 0) 
			{
				Empresa.notificationError("LA CANTIDAD DEBE SER MAYOR A CERO.");
				$('#num' + id).val(pedido[id].cantidad).focus(); 
				return;
			}
			let item = pedido[id];
			let cantidadAnterior = parseFloat(item.cantidad);
			let diferencia = valor - cantidadAnterior;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			if (diferencia === 0) {
				Empresa.notificationError("LA CANTIDAD MINIMA ES 1.");
				$('#num' + id).val(pedido[id].cantidad).focus(); 
				return;
			}

			let body = {
				funcion: "actualizarLeidos",
				idproducto: item.idp,
				lote: item.lote,
				idsucursal: idsucursal,
				iduser: idu,
				valor: valor,
				diferencia: diferencia
			};

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					item.cantidad = valor;
					dibujarTabla();
				},
				funcionError: function (e) {
					$('#num' + id).val(cantidadAnterior).focus(); 
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		
		function actualizarPrecio(e, actual, id, pmax, pmin) {
			var keycode = (e.keyCode ? e.keyCode : e.which);
			var bool = e.isTrusted;

			if (keycode >= 46 && keycode <= 57 || keycode == 8) {
			} else if (keycode == '13' || bool == true) {
				actual = parseFloat(actual);
				pmin = parseFloat(pmin);
				if (actual >= pmin) {
					pedido[id].pfinal = actual;
					pedido[id].preciounitario = actual;
					dibujarTabla();
				} else {
					Empresa.notificationError("No se puede modificar el precio menor al precio tope");
					$('#prec' + id).val(pmax).focus();
				}
			} else {
				e.preventDefault();
			}
		}


		function cambiarPrecioVenta(valor) {
			for (var j = 0; j < pedido.length; j++) {
				pedido[j].codprecio = valor;
				if (valor == '1') {
					pedido[j].pfinal = pedido[j].pventa;
					pedido[j].preciounitario = pedido[j].pventa;
				}
				if (valor == '2') {
					pedido[j].pfinal = pedido[j].pmayor;
					pedido[j].preciounitario = pedido[j].pmayor;
				}
				if (valor == '3') {
					pedido[j].pfinal = pedido[j].pespecial;
					pedido[j].preciounitario = pedido[j].pespecial;
				}
				if (valor == '4') {
					pedido[j].pfinal = pedido[j].ptope;
					pedido[j].preciounitario = pedido[j].ptope;
				}
			}
			dibujarTabla();
		}

		function cambiarPrecioFila(event, valor, i) {
			valor = parseInt(valor); 
			i = parseInt(i); 

			if (!pedido[i]) return; 

			pedido[i].codprecio = valor;

			if (valor === 1) {
				pedido[i].pfinal = pedido[i].pventa;
				pedido[i].preciounitario = pedido[i].pventa;
			} else if (valor === 2) {
				pedido[i].pfinal = pedido[i].pmayor;
				pedido[i].preciounitario = pedido[i].pmayor;
			} else if (valor === 3) {
				pedido[i].pfinal = pedido[i].pespecial;
				pedido[i].preciounitario = pedido[i].pespecial;
			} else if (valor === 4) {
				pedido[i].pfinal = pedido[i].ptope;
				pedido[i].preciounitario = pedido[i].ptope;
			}

			dibujarTabla();
		}



		function dibujarTabla() {
			lisDetalleVenta = [];
			let sumtitems = 0;
			let sumtprecio = 0;

			for (let i = 0; i < pedido.length; i++) {
				let item = pedido[i];
				let preciototal = parseFloat(item.pfinal) * parseFloat(item.cantidad);

				sumtitems += parseFloat(item.cantidad);
				sumtprecio += preciototal;

				lisDetalleVenta.push([
					"" + (i + 1),
					crearImgDet(item.imagen, "40"),
					item.nombre + " ( " + item.lote + " ) ",
					crearInputCantidad(i, item.cantidad) + " Uds",
					crearInputPrecio(i, item.pfinal, item.ptope) + " Bs.",
					crearInputPrecioSubTotal(i, preciototal) + " Bs.",
					crearSelectPrecio(i, item.codprecio),
					crearButtonQuitar(i)
				]);
			}

			document.getElementById('itmcantidad').innerHTML = Empresa.roundNumber(sumtitems, 3);
			$("#cantidad_ven").val(Empresa.roundNumber(sumtitems, 3));
			$("#precio_ven").val(Empresa.roundNumber(sumtprecio, 2));

			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: lisDetalleVenta
			});
		}

		function realizarVenta(idf) {
			Empresa.showSpinner();
			document.getElementById('rventa').style.display = 'none';
			var concepto = document.getElementById("concepto_ven").value;
			var tipopago = $('select[id="selectTipoPago"] option:selected').text();
			var cantidad = document.getElementById("cantidad_ven").value;
			var precio = document.getElementById("precio_ven").value;
			var idcli = document.getElementById("idcli").value;
			var rzs = document.getElementById("rzs").value;
			var nit = document.getElementById("nit").value;
			var cmp = document.getElementById("cmp").value;
			var mail = document.getElementById("mail").value;
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			if (nit === "") {
				$('#nit').focus();
				Empresa.notificationError("El campo NIT es necesario.");
				Empresa.hideSpinner();
				return;
			}
			if (rzs === "") {
				$('#rzs').focus();
				Empresa.notificationError("El campo Razon Social es necesario.");
				Empresa.hideSpinner();
				return;
			}

			if (pedido.length == 0) {
				Empresa.notificationError("No se Puede Realizar esta transaccion si no tiene detalle.");
				Empresa.hideSpinner();
				return;
			}
			pedido.length
			var funcion = "realizarVenta";
			var body = {
				funcion: funcion,
				concepto: concepto,
				precio: precio,
				cantidad: cantidad,
				detalle: pedido,
				idsucursal: idsucursal,
				iduser: idu,
				tipopago: tipopago,
				idcli: idcli,
				rzs: rzs,
				nit: nit,
				cmp: cmp,
				mail: mail,
				idfactura: idf
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var idven = respuesta.idven;
					$("#modalVenta").modal("hide");
					Empresa.notificationSuccess(" Se realizo correctamente la Venta");
					if (idf == 0) {
						imprimirVenta(idven);
					}
					resetFormularioVenta();
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function cargarVentas() {
			Empresa.showSpinner();
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			$('#tablistado').tab('show');
			var fecini = document.getElementById("finicio").value;
			var fecfin = document.getElementById("ffin").value;
			var columnsName = [{
				title: "#"
			}, {
				title: " Fecha"
			}, {
				title: " Boleta"
			}, {
				title: "Cliente"
			}, {
				title: " Cantidad"
			}, {
				title: " Costo Total"
			}, {
				title: " Tipo Venta"
			}, {
				title: " Pagos"
			},{
				title: " Saldo"
			}, {
				title: " Estado"
			}, {
				title: " Factura"
			}, {
				title: " "
			}];
			lisVenta = [];
			var body = {
				funcion: "listarVentas",
				idsucursal: idsucursal,
				idrol: idr,
				iduser: idu,
				fecini: fecini,
				fecfin: fecfin
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {
					var ventas = respuesta.ventas;
					for (var i = 0; i < ventas.length; i++) {
						var pagos = (ventas[i].TIPO_VENTA === "CREDITO") ? ventas[i].TOTAL_PAGOS : "-";
						var saldo = (ventas[i].TIPO_VENTA === "CREDITO") ? ventas[i].SALDO : "-";
						lisVenta.push([
							i + 1,
							ventas[i].FECHA_REGISTRO,
							ventas[i].BOLETA,
							ventas[i].NOMBRES,
							ventas[i].CANTIDAD,
							ventas[i].PRECIO_TOTAL,
							ventas[i].TIPO_VENTA,
							pagos,
							saldo,
							ventas[i].ESTADO,
							crearButtonsFactura(ventas[i].ID_VENTA, ventas[i].ID_FACTURA, ventas[i].ESTADO),
							crearButtonsVenta(ventas[i].ID_VENTA,ventas[i].TIPO_VENTA,ventas[i].ID_ARQUEO,ventas[i].ESTADO)
						]);
					}
					Empresa.inicializarTablaDeDatos({
						selector: ".lisVenta",
						data: lisVenta,
						columnas: columnsName
					});
					Empresa.refrescarTablaDeDatos({
						selector: ".lisVenta",
						data: lisVenta
					});
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
					Empresa.hideSpinner();
				}
			});
		}
		function anularVenta(idv,ida) {
 			Empresa.showSpinner();
 			
 			swal({
				title: "Anular Venta",
				text: "Se procedera a anular la Venta",
				type: "error",
				showCancelButton: true,
				confirmButtonClass: "btn-danger",
				confirmButtonText: "Anular",
				cancelButtonText: "Cancelar",
				closeOnConfirm: false,
				closeOnCancel: false
			},
			function(isConfirm) {
				if (isConfirm) {
					swal.close();
					var body = { funcion: "anularVenta", idventa: idv, idarqueo: ida };

					Empresa.rest({
						verbo: 'POST',
						url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
						data: body,
						funcionExito: function (respuesta) {
							var boleta = respuesta.boleta;
							cargarVentas();
							Empresa.notificationSuccess(" Se anulo correctamente la Venta con Boleta:" + boleta);
						},
						funcionError: function(e) {
							Empresa.notificationError(e.mensaje);
							Empresa.hideSpinner();
						}
					});
					
				} else {
					swal.close();
				}
			});
 		}

		function subirExcelVenta() {
			Empresa.showSpinner();
			var inputFile = document.getElementById("excelven");
			var file = inputFile.files[0];
			var archivo = file.name;
			var data = new FormData();
			var funcion = "subirExcelVenta";
			data.append('excelven', file);
			data.append('funcion', funcion);
			Empresa.restImg({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesArchivosInventario.php"),
				data: data,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var excel = respuesta.excel;
					$("#excelven").val("");
					cargarExcelVenta(excel);
					$("#modalExcel").modal("hide");
					Empresa.notificationSuccess("Archivo Subido Correctamente");
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function cargarExcelVenta(excel) {
			Empresa.showSpinner();
			lisNewFactura = [];
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var body = {
				funcion: "cargarExcelVenta",
				idsucursal: idsucursal,
				iduser: idu,
				excel: excel
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function(respuesta) {

					var detalle = respuesta.detalle;
					$('#tabventa').tab('show');
					pedido = [];
					pedido = detalle;

					dibujarTabla();
					Empresa.hideSpinner();
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		function verPagos(id) {
			$("#modalPagos").modal("show");
			$("#updidventa").val(id);
			var columnsName = [{ title: "Fecha Pago" }, { title: "Concepto" }, { title: "Monto" }];
			var lispagos = [];
			var body = { funcion: "verPagos", idventa: id };

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					var pagos = respuesta.pagos.data;

					// Procesar pagos
					for (var i = 0; i < pagos.length; i++) {
						lispagos.push([
							pagos[i].FECHA_PAGO,
							pagos[i].CONCEPTO,
							pagos[i].MONTO
						]);
					}

					Empresa.inicializarTablaSinFormato({
						selector: ".lispagos",
						data: lispagos,
						columnas: columnsName
					});

					Empresa.refrescarTablaDeDatos({
						selector: ".lispagos",
						data: lispagos
					});
				},
				funcionError: function () {
					Empresa.notificationError("No se pudo cargar la lista de pagos");
				}
			});
		}

		function newPago() {
			Empresa.showSpinner();
			
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal === "") { 
				idsucursal = ids; 
			}

			var monto = document.getElementById("montopago").value;
			var idventa = document.getElementById("updidventa").value;
			var iduser = idu; 
	
			if (!monto || parseFloat(monto) <= 0) {
				Empresa.notificationError("El monto del pago debe ser mayor a cero.");
				Empresa.hideSpinner();
				return;
			}
			
			var funcion = "newPago";
			var body = {
				funcion: funcion,
				idsucursal: idsucursal,
				idventa: idventa,
				monto: monto,
				iduser: iduser
			};

			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/inventario/funcionesInventario.php"),
				data: body,
				funcionExito: function (respuesta) {
					Empresa.notificationSuccess("Se ingresó correctamente el registro del pago.");
					$("#newPago").modal("hide");
					var idpago = respuesta.idpago;
					verPagos(idventa); 
					enviarWhatsappPago(idpago) 
				},
				funcionError: function (e) {
					Empresa.notificationError(e.mensaje || "Hubo un error al registrar el pago.");
					Empresa.hideSpinner();
				}
			});
		}

		function headerDetalleFactura() {
			var columnsName = [{
					title: "#"
				},
				{
					title: "Codigo"
				},
				{
					title: "Cantidad"
				},
				{
					title: "Descripcion"
				},
				{
					title: "PrecioUnitario"
				},
				{
					title: "Descuento"
				},
				{
					title: "Subtotal"
				}
			];
			Empresa.inicializarTablaPrint({
				selector: ".lisDetalleFactura",
				data: lisDetalleFactura,
				columnas: columnsName
			});
		}

		function prepararFactura(id) {
			$("#mdlFactura").modal("show");
			lisNewFactura = [];
			lisDetalleFactura = [];
			var body = {
				funcion: "prepararFactura",
				idventa: id
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					var detalle = respuesta.detalle;
					var cliente = respuesta.cliente;
					var venta = respuesta.venta;
					lisNewFactura = detalle;
					var sumtcantidad = 0;
					var sumtprecio = 0;
					var sumtdescuento = 0;

					document.getElementById('idven').value = venta.ID_VENTA;
					document.getElementById('idcli').value = cliente.id;
					document.getElementById('rzs1').value = cliente.razonSocial;
					document.getElementById('nit1').value = cliente.nitCi;
					document.getElementById('mail1').value = cliente.email;
					document.getElementById('cmp1').value = cliente.complemento;

					for (var i = 0; i < lisNewFactura.length; i++) {
						sumtprecio = parseFloat(sumtprecio) + parseFloat(lisNewFactura[i].preciobs);
						sumtcantidad = parseFloat(sumtcantidad) + parseFloat(lisNewFactura[i].cantidad);
						lisDetalleFactura.push([
							i + 1,
							lisNewFactura[i].codigop,
							lisNewFactura[i].cantidad,
							lisNewFactura[i].producto,
							lisNewFactura[i].preciounitario + " Bs.",
							lisNewFactura[i].descuento + " Bs.",
							lisNewFactura[i].preciobs
						]);
					};
					Empresa.refrescarTablaDeDatos({
						selector: ".lisDetalleFactura",
						data: lisDetalleFactura
					});
					sumtdescuento = parseFloat(sumtprecio);
					$("#stbs").val(Empresa.financial(sumtprecio, 2));
					$("#dtbs").val(0);
					$("#ttbs").val(Empresa.financial(sumtdescuento, 2));
					$("#tbs").val(Empresa.financial(sumtdescuento, 2));
					$("#tpar").val(Empresa.financial(sumtcantidad, 0));

				},
				funcionError: function(e) {
					Empresa.notificationError("No se cargo correctamente el listado");
				}
			});
		}

		function buscarNit() {
			var nit = document.getElementById("nit").value;
			if (nit === "") {
				$('#nit').val('').focus();
				Empresa.notificationError("No ingreso ningun nit es obligatorio el campo.");
				Empresa.hideSpinner();
				return;
			}
			var body = {
				funcion: "buscarNit",
				cinit: nit
			};
			Empresa.showSpinner();
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					var cliente = respuesta.cliente;
					Empresa.hideSpinner();
					if (cliente == null) {
						toastr.warning('no se encontro ningun nombre relacionado al nit.', '¡Ingrese un nombre por favor!');
					} else {
						document.getElementById('idcli').value = cliente.id;
						document.getElementById('nit').value = cliente.nitCi;
						document.getElementById('rzs').value = cliente.razonSocial;
						document.getElementById('mail').value = cliente.email;
						document.getElementById('cmp').value = cliente.complemento;
					}

				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			})

		}
		function calcularCambioVenta(e) {
			const keycode = (e.keyCode ? e.keyCode : e.which);

			if (keycode === 13) {
				const total = parseFloat(document.getElementById("precio_ven").value) || 0;
				const cancelado = parseFloat(document.getElementById("cancelado_ven").value) || 0;

				if (isNaN(cancelado) || cancelado < 0) {
					alert("Ingrese un monto válido.");
					document.getElementById("cambio_ven").value = "0";
					return;
				}

				const cambio = cancelado - total;
				document.getElementById("cambio_ven").value = cambio.toFixed(2);
				document.getElementById("cambio_ven").focus();
			}
		}
		function generarFactura() {
			Empresa.showSpinner();
			var rzs = document.getElementById("rzs").value;
			var nit = document.getElementById("nit").value;
			var cmp = document.getElementById("cmp").value;
			var mail = document.getElementById("mail").value;
			var tipodoc = document.getElementById("selectTipoDoc").value;
			if (rzs === "") {
				$('#rzs').focus();
				Empresa.notificationError("El campo Razon Social es necesario.");
				Empresa.hideSpinner();
				return;
			}
			if (nit === "") {
				$('#nit').focus();
				Empresa.notificationError("El campo NIT es necesario.");
				Empresa.hideSpinner();
				return;
			}
			if (mail === "") {
				mail = "farmacia.especializadajg@gmail.com";
			}
			var stbs = document.getElementById("precio_ven").value;
			var dtbs = 0; // Descuento si existe 
			var ttbs = document.getElementById("precio_ven").value;
			var tbs = document.getElementById("precio_ven").value;

			var gift = "0";
			var tarjeta = "0";
			var metodopago = "1";
			var nrocafc = "";
			var fcafc = "";
			var hcafc = "";
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var maestro = {
				ids: ids,
				iduser: idu,
				usr: usr,
				tbs: tbs,
				ttbs: ttbs,
				stbs: stbs,
				dtbs: dtbs,
				gift: gift,
				tarjeta: tarjeta,
				metodopago: metodopago,
				rzs: rzs,
				nit: nit,
				cmp: cmp,
				tipodoc: tipodoc,
				mail: mail,
				nrocafc: nrocafc,
				fcafc: fcafc,
				hcafc: hcafc
			};
			var body = {
				funcion: "procesarFactura",
				maestro: maestro,
				detalle: pedido,
				idven: "0"
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					var idfac = respuesta.idfac;
					var idcmp = respuesta.idcmp;
					var cuf = respuesta.cuf;
					var tipoEmision = respuesta.tipoEmision;
					var idcli = respuesta.idcli;
					var cdevento = respuesta.cdevento;

					generarFacturaPdf(idfac);
					if (tipoEmision == '1') {
						enviarMailFactura(mail, rzs, nit, cuf);
					} else {
						if (cdevento == '2' || cdevento == '5' || cdevento == '6' || cdevento == '7') {
							enviarMailFactura(mail, rzs, nit, cuf);
						}
					}
					imprimirFacturaTicket(idfac);
					realizarVenta(idfac);
				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError(e.mensaje);
					x.style.display = 'block';
				}
			});
		}

		function procesarFactura() {
			Empresa.showSpinner();
			var rzs = document.getElementById("rzs1").value;
			var nit = document.getElementById("nit1").value;
			var cmp = document.getElementById("cmp1").value;
			var mail = document.getElementById("mail1").value;
			var tipodoc = document.getElementById("selectTipoDoc").value;
			if (rzs === "") {
				$('#rzs').focus();
				Empresa.notificationError("El campo Razon Social es necesario.");
				Empresa.hideSpinner();
				return;
			}
			if (nit === "") {
				$('#nit').focus();
				Empresa.notificationError("El campo NIT es necesario.");
				Empresa.hideSpinner();
				return;
			}
			if (mail === "") {
				mail = "farmacia.especializadajg@gmail.com";
			}
			var stbs = document.getElementById("stbs").value;
			var dtbs = 0;
			var ttbs = document.getElementById("ttbs").value;
			var tbs = document.getElementById("tbs").value;
			var idven = document.getElementById("idven").value;

			var gift = "0";
			var tarjeta = "0";
			var metodopago = "1";
			var nrocafc = "";
			var fcafc = "";
			var hcafc = "";
			var idsucursal = document.getElementById("selectSucursal").value;
			if (idsucursal == "") {
				idsucursal = ids;
			}
			var maestro = {
				ids: ids,
				iduser: idu,
				usr: usr,
				tbs: tbs,
				ttbs: ttbs,
				stbs: stbs,
				dtbs: dtbs,
				gift: gift,
				tarjeta: tarjeta,
				metodopago: metodopago,
				rzs: rzs,
				nit: nit,
				cmp: cmp,
				tipodoc: tipodoc,
				mail: mail,
				nrocafc: nrocafc,
				fcafc: fcafc,
				hcafc: hcafc
			};
			var body = {
				funcion: "procesarFactura",
				maestro: maestro,
				detalle: lisNewFactura,
				idven: idven
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.hideSpinner();
					$("#mdlFactura").modal("hide");
					var idfac = respuesta.idfac;
					var idcmp = respuesta.idcmp;
					var cuf = respuesta.cuf;
					var tipoEmision = respuesta.tipoEmision;
					var idcli = respuesta.idcli;
					var cdevento = respuesta.cdevento;

					generarFacturaPdf(idfac);
					if (tipoEmision == '1') {
						enviarMailFactura(mail, rzs, nit, cuf);
					} else {
						if (cdevento == '2' || cdevento == '5' || cdevento == '6' || cdevento == '7') {
							enviarMailFactura(mail, rzs, nit, cuf);
						}
					}
					imprimirFacturaTicket(idfac);
					window.location.reload();

				},
				funcionError: function(e) {
					Empresa.hideSpinner();
					Empresa.notificationError(e.mensaje);
				}
			});
		}

		function generarFacturaPdf(idfac) {
			var body = {
				funcion: "generarFacturaPdf",
				idfac: idfac
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					var nrofac = respuesta.nrofac;
					Empresa.notificationSuccess('Exito Se genero correctamente el pdf de la factura nro: ' + nrofac);
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}

		function enviarMailFactura(mail, rzs, nit, cuf) {
			var body = {
				funcion: "enviarMailFactura",
				mail: mail,
				rzs: rzs,
				nit: nit,
				cuf: cuf
			};
			Empresa.rest({
				verbo: 'POST',
				url: Empresa.armarUrl("/api/factura/funcionesFactura.php"),
				data: body,
				funcionExito: function(respuesta) {
					Empresa.notificationSuccess('Se envio correctamente los datos de la factura al correo: ' + mail + ' del cliente: ' + rzs);
				},
				funcionError: function(e) {
					Empresa.notificationError(e.mensaje);
					Empresa.hideSpinner();
				}
			});
		}
		function resetFormularioVenta() {

			document.getElementById('nit').value = ''; 
			document.getElementById('rzs').value = ''; 
			document.getElementById('concepto_ven').value = '-'; 
			document.getElementById('cantidad_ven').value = '0';
			document.getElementById('precio_ven').value = '0';
			document.getElementById('cancelado_ven').value = '0';
			document.getElementById('cambio_ven').value = '0';
			document.getElementById('itmcantidad').innerText = '0';

			selectTipoPago();

			// Ocultar detalles de cliente
			const dtcli = document.getElementById('dtcli');
			if (dtcli) dtcli.style.display = 'none';
			document.getElementById('rventa').style.display = 'block';

			lisDetalleVenta = []; pedido = [];
			Empresa.refrescarTablaDeDatos({
				selector: ".lisPedido",
				data: lisDetalleVenta
			});
		}

		function imprimirVenta(id) {
			Empresa.PopupCenter('print_venta.php?id=' + id + '', 'IMPRIMIR VENTA', 400, 520);
		}

		function imprimirFacturaTicket(idf) {
			Empresa.PopupCenter('imprimirticket.php?idf=' + idf + '', 'IMPRIMIR FACTURA', 400, 700);
		}

		function crearButtonsVenta(id, tipoVenta, ida, est) {
			let buttons = "";

			if (est === 'ANULADO') {
				buttons += "-";
			} else {
				buttons += "<button class='btn btn-info btn-xs btn-outline' style='font-size:8px' title='Imprimir Venta' onclick='imprimirVenta(\"" + id + "\")'><i class='fa fa-print'></i></button>";

				if (tipoVenta === "CREDITO") {
					buttons += "<button class='btn btn-success btn-xs btn-outline' style='font-size:8px' title='Ver Pagos' onclick='verPagos(\"" + id + "\")'><i class='fa fa-money'></i></button>";
				} else {
					buttons += "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Anular Venta' onclick='anularVenta(\"" + id + "\",\"" + ida + "\")'><i class='fa fa-close'></i></button>";
				}
			}

			return buttons;
		}


		function crearButtonsFactura(idv, idf,est) {
			if(est=='ANULADO'){
				return "-";
			}else{
				if (idf == "0") {
					return "<button class='btn btn-primary btn-xs btn-outline' style='font-size:8px' title='Facturar Venta' onclick='prepararFactura(\"" + idv + "\")'> <i class='fa fa-calculator'></i></button>";
				} else {
					return "<button class='btn btn-warning btn-xs btn-outline' style='font-size:8px' title='Imprimir Factura' onclick='imprimirFacturaTicket(\"" + idf + "\")'> <i class='fa fa-print'></i> </button>";
				}
			}	

		}
		function crearSelectPrecio(i, codpre) { 
			return "<select class='pull-right input-sm' id='selectPrecio" + i + "' onchange='cambiarPrecioFila(event, this.value, \"" + i + "\")'><option value='1'" + (codpre==1?" selected":"") + ">PRECIO VENTA</option><option value='2'" + (codpre==2?" selected":"") + ">PRECIO MAYOR</option><option value='3'" + (codpre==3?" selected":"") + ">PRECIO ESPECIAL</option><option value='4'" + (codpre==4?" selected":"") + ">PRECIO TOPE</option></select>"; 
		}

		function crearInputCantidad(id, cantidad) {
			return "<input class='form-control'  style='width: 60px;' id='num" + id + "' onchange='itemsCarrito(\"" + id + "\",this.value)' type='number'  step='1' min='1' value='" + cantidad + "' >";
		}

		function crearInputPrecio(i, precio, ptope) {
			return "<input class='form-control' id='prec" + i + "'  style='width: 80px;' size='4' type='text' value='" + precio + "'  onfocusout='actualizarPrecio(event,this.value,\"" + i + "\",\"" + precio + "\",\"" + ptope + "\")'>";;
		}

		function crearButtonQuitar(id) {
			return "<button class='btn btn-danger btn-xs btn-outline' style='font-size:8px' title='Quitar Articulo' onclick='quitarArticulo(\"" + id + "\")'><i class='fa fa-trash'></i></button>";
		}

		function crearInputPrecioSubTotal(i, precio) {
			return "<input class='form-control' readonly id='precsubtotal" + i + "'  style='width: 60px;' size='4' type='text' value='" + precio + "'>";
		}

		function crearImgDet(url, tam) {
			var imgurl = "<img src='img/Producto/" + url + "'  width='" + tam + "' id='imageModel' /> ";
			return imgurl;
		}

		this.initializer();
	</script>
</body>

</html>